"use strict";
cc._RF.push(module, 'd4213eLzwdH/Kucjk55ZNdX', 'ResLoaderManager');
// scripts/Manager/ResLoaderManager.ts

"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/** 资源加载路径 需要加载的所有资源*/
exports.SpAtlasPath = [
    // NPC 图集
    "npc/adult01",
];
/** 预制体资源路径*/
exports.PrefabPath = [
    "prefab/eva_npc/npc"
];
exports.JsonCfgPath = [
    "jsonCfg/animation",
    "jsonCfg/visitor",
];
/** 资源管理类*/
var ResLoaderManager = /** @class */ (function () {
    function ResLoaderManager() {
        /** 图集资源列表*/
        this.spAtlasDatas = new Map();
        /** 配置资源列表*/
        this.cfgDatas = new Map();
        /** 预制体资源列表*/
        this.prfDatas = new Map();
    }
    ResLoaderManager.getInstance = function () {
        if (!this._instance) {
            this._instance = new ResLoaderManager();
        }
        return this._instance;
    };
    ResLoaderManager.prototype.initSpriteAtlas = function (cb) {
        var _this = this;
        //初始加载所有游戏资源
        //加载过程回调
        var progressCallback = function (completedCount, totalCount, item) { cb(completedCount, totalCount); };
        //加载结束回调
        var completeCallback = function (err, resource) {
            if (err) {
                cc.error(err);
                return;
            }
            for (var i = 0; i < resource.length; i++) {
                var strArr = resource[i].name.split(".");
                _this.spAtlasDatas.set(strArr[0], resource[i]);
            }
        };
        cc.loader.loadResArray(exports.SpAtlasPath, cc.SpriteAtlas, progressCallback, completeCallback);
    };
    /** 配置数据加载*/
    ResLoaderManager.prototype.initJsonCfg = function (cb) {
        var _this = this;
        //加载过程回调
        var progressCallback = function (completedCount, totalCount, item) { cb(completedCount, totalCount); };
        //加载结束回调
        var completeCallback = function (err, jsonArr) {
            if (err) {
                cc.error(err);
                return;
            }
            // 便利结果
            jsonArr.forEach(function (item) {
                // 获取配置文件名
                var name = item.name;
                _this.cfgDatas.set(name, item.json);
            });
            // cc.log(jsonArr);
        };
        cc.loader.loadResArray(exports.JsonCfgPath, cc.JsonAsset, progressCallback, completeCallback);
    };
    /** 预制体资源加载*/
    ResLoaderManager.prototype.initPrefaRes = function (cb) {
        var _this = this;
        //加载过程回调
        var progressCallback = function (completedCount, totalCount, item) { cb(completedCount, totalCount); };
        //加载结束回调
        var completeCallback = function (err, prefabs) {
            if (err) {
                cc.error(err);
                return;
            }
            //cc.log(prefabs);
            prefabs.forEach(function (item) { return _this.prfDatas.set(item.name, item); });
        };
        cc.loader.loadResArray(exports.PrefabPath, cc.Prefab, progressCallback, completeCallback);
    };
    /** 根据名字获取某张图集*/
    ResLoaderManager.prototype.getSpriteAtlasByName = function (name) {
        var data = this.spAtlasDatas.get(name);
        return data;
    };
    /** 根据名字获取某个预制体*/
    ResLoaderManager.prototype.getPrefab = function (name) {
        return this.prfDatas.get(name);
    };
    /** 根据名字获取某个配置表*/
    ResLoaderManager.prototype.getConfig = function (name) {
        return this.cfgDatas.get(name);
    };
    return ResLoaderManager;
}());
exports.default = ResLoaderManager;

cc._RF.pop();