"use strict";

cc.Class({
    extends: cc.Component,

    properties: {
        nodeImage512 : cc.Node,
        nodeImage1024 : cc.Node,
        nodeImage2048 : cc.Node,
        nodeImage4096 : cc.Node,
        nodeImage8192 : cc.Node,
    },

    onLoad() {
        this.spriteImage512 = this.nodeImage512.getComponent(cc.Sprite);
        this.texture2D512 = new cc.Texture2D();

        this.spriteImage1024 = this.nodeImage1024.getComponent(cc.Sprite);
        this.texture2D1024 = new cc.Texture2D();

        this.spriteImage2048 = this.nodeImage2048.getComponent(cc.Sprite);
        this.texture2D2048 = new cc.Texture2D();

        this.spriteImage4096 = this.nodeImage4096.getComponent(cc.Sprite);
        this.texture2D4096 = new cc.Texture2D();

        this.spriteImage8192 = this.nodeImage8192.getComponent(cc.Sprite);
        this.texture2D8192 = new cc.Texture2D();
    },

    onBtnImage512() {
        console.log("** Image512");
        var nImageWidth = 512;
        var nImageHeight = 512;
        var nColor = -1;
        var aryImage = this.test_createImage(nImageWidth, nImageWidth, nColor);
        this.refreshImageToNode(aryImage, nImageWidth, nImageHeight, this.texture2D512, this.spriteImage512);
    },

    onBtnImage1024() {
        console.log("** Image1024");
        var nImageWidth = 1024;
        var nImageHeight = 1024;
        var nColor = -1;
        var aryImage = this.test_createImage(nImageWidth, nImageWidth, nColor);
        this.refreshImageToNode(aryImage, nImageWidth, nImageHeight, this.texture2D1024, this.spriteImage1024);
    },

    onBtnImage2048() {
        console.log("** Image2048");
        var nImageWidth = 2048;
        var nImageHeight = 2048;
        var nColor = -1;
        var aryImage = this.test_createImage(nImageWidth, nImageWidth, nColor);
        this.refreshImageToNode(aryImage, nImageWidth, nImageHeight, this.texture2D2048, this.spriteImage2048);
    },

    onBtnImage4096() {
        console.log("** Image4096");
        var nImageWidth = 4096;
        var nImageHeight = 4096;
        var nColor = -1;
        var aryImage = this.test_createImage(nImageWidth, nImageWidth, nColor);
        this.refreshImageToNode(aryImage, nImageWidth, nImageHeight, this.texture2D4096, this.spriteImage4096);
    },

    onBtnImage8192() {
        console.log("** Image8192");
        var nImageWidth = 8192;
        var nImageHeight = 8192;
        var nColor = -1;
        var aryImage = this.test_createImage(nImageWidth, nImageWidth, nColor);
        this.refreshImageToNode(aryImage, nImageWidth, nImageHeight, this.texture2D8192, this.spriteImage8192);
    },

    test_createImage(nImageWidth, nImageHeight, nColor) {
        var aryImage = new Uint8Array(nImageWidth * nImageHeight * 4);
        console.log("aryImage.length =", nImageWidth, "*", nImageHeight, "* 4 =", aryImage.length);

        for (var i = 0; i < aryImage.length; i++) {
            if (nColor >= 0) {
                aryImage[i] = nColor;
            }
            else {
                aryImage[i] = Math.floor(Math.random() * 255);
            }
        }
        console.log("test_createImage() done");

        return aryImage;
    },
    
    refreshImageToNode(data, nImageWidth, nImageHeight, texture2D, sprite) {
        console.log("  initWithData() data.length =", data.length, ", image size =", nImageWidth, nImageHeight);
        texture2D.initWithData(data, cc.Texture2D.PixelFormat.RGBA8888, nImageWidth, nImageHeight);
        console.log("  new cc.SpriteFrame()");
        sprite.spriteFrame = new cc.SpriteFrame();
        console.log("  setTexture()");
        sprite.spriteFrame.setTexture(texture2D);
        console.log("  refreshImageToNode() done");
    },

    onDestroy() {
    },
});
