"use strict";
cc._RF.push(module, '280c3rsZJJKnZ9RqbALVwtK', 'HelloWorld');
// Script/HelloWorld.js

"use strict";

cc.Class({
    extends: cc.Component,

    properties: {
        radius: 2000
    },

    // use this for initialization
    onLoad: function onLoad() {
        cc.director.getPhysicsManager().enabled = true;
        cc.director.getPhysicsManager().debugDrawFlags = cc.PhysicsManager.DrawBits.e_jointBit | cc.PhysicsManager.DrawBits.e_shapeBit;

        this.bg = this.node.getChildByName("bg");
        this.bg.on(cc.Node.EventType.TOUCH_END, this.clickEnd, this);
        this.ctx = this.bg.getChildByName("ray-cast").getComponent(cc.Graphics);
        this.rayCastPos = cc.v2(300, 0);
        //手动添加墙壁...
        this.physicBound();
    },
    clickEnd: function clickEnd(event) {
        this.ctx.clear();
        this.remainLength = this.radius;
        this.reflectCount = 0;
        var touchPos = event.getLocation();
        var touchX = touchPos.x;
        var touchY = touchPos.y;
        var angle = Math.atan2(touchY - this.rayCastPos.y, touchX - this.rayCastPos.x);
        //console.log("angle ---> " + angle);
        var p2 = cc.v2(Math.cos(angle), Math.sin(angle)).mul(this.radius).add(this.rayCastPos);
        this.rayCast(this.rayCastPos, p2);
    },
    rayCast: function rayCast(p1, p2) {
        var manager = cc.director.getPhysicsManager();
        var results = manager.rayCast(p1, p2, cc.RayCastType.Closest);
        var result = results[0];
        if (result) {
            p2 = result.point;
            //console.log("p2 = " + p2.x + "..." + p2.y);
            this.ctx.circle(p2.x, p2.y, 10);
            this.ctx.fill();
        }
        this.ctx.moveTo(p1.x, p1.y);
        this.ctx.lineTo(p2.x, p2.y);
        this.ctx.stroke();
        if (!result) return;

        this.remainLength = this.remainLength - p2.sub(p1).mag();
        if (this.remainLength < 1) return;

        if (this.reflectCount === 1) return;

        var newStartPoint = p2;
        var ray = p1.sub(p2);
        console.log("发射向量 ---> " + ray.x + "---->" + ray.y);
        p2 = result.normal.mul(this.remainLength).add(p1);
        //console.log("未旋转反射向量 ---> " + p2.x + "---->" + p2.y);
        var radius = cc.pAngleSigned(ray, result.normal);
        console.log("弧度为--->" + radius);
        var angle = 180 / Math.PI * radius;
        console.log("对应的角度为--->" + angle);
        this.reflectCount += 1;
        p2 = p2.rotate(radius);
        this.rayCast(newStartPoint, p2);
    },
    physicBound: function physicBound() {
        var node = new cc.Node();
        var body = node.addComponent(cc.RigidBody);
        body.type = cc.RigidBodyType.Static;
        this._addBound(node, this.node.width / 2, this.node.height, this.node.width, 20);
        this._addBound(node, this.node.width / 2, 0, this.node.width, 20);
        this._addBound(node, 0, this.node.height / 2, 20, this.node.height);
        this._addBound(node, this.node.width, this.node.height / 2, 20, this.node.height);

        node.parent = this.bg;
    },
    _addBound: function _addBound(node, x, y, width, height) {
        var collider = node.addComponent(cc.PhysicsBoxCollider);
        collider.offset.x = x;
        collider.offset.y = y;
        collider.size.width = width;
        collider.size.height = height;
    }
});

cc._RF.pop();