
const {ccclass, property} = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    @property(cc.Prefab)
    maskPrefab: cc.Prefab = null;

    @property(cc.Node)
    btn: cc.Node = null;

    private maskLayer:cc.Node = null;

    onLoad(){
        this.maskLayer = cc.instantiate(this.maskPrefab);
        this.maskLayer.getComponent('guide').showMask(this.btn, 'boat');
    }

    /**
     * 响应事件
    */
    onButtonClickEvent(){
        this.maskLayer.getComponent('guide').hideMask();
    }

    start () {

    }
}
