
const {ccclass, property} = cc._decorator;

@ccclass
export default class Guide extends cc.Component {
    /**
     * 显示遮罩
    */
    showMask(target: cc.Node, spriteFrame: string){
        this.node.setPosition(cc.v2(target.x, target.y));
        this.node.parent = target.parent;

        cc.loader.loadRes(spriteFrame, cc.SpriteFrame, (err, spFrame)=>{
            if (err){
                console.log(err);
                return;
            }
            this.node.getComponent(cc.Mask).spriteFrame = spFrame;
            this.node.setContentSize(cc.size(target.width, target.height));
        });

        let blockLayer = this.node.getChildByName("block");
        let blockPos = blockLayer.convertToNodeSpace(cc.v2(0, 0));
        blockLayer.setPosition(cc.v2(blockPos.x, blockPos.y));
    }

    hideMask(){
        if (this.node.active)
            this.node.active = false;
    }
}
