"use strict";
cc._RF.push(module, '08bcc+IiIpM074VJ9Gaa+NX', 'TableViewUtils');
// Script/TableViewUtils.js

'use strict';

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

cc.Class({
    extends: cc.Component,
    properties: {
        // item:[cc.Prefab],
        // itemData:[],//item数据
        // scrollView:cc.ScrollView,
        // itemInterval:0, //间距
        // firstItemData:{},
        // lastItemData:{},
        // itemArr:[],
        // itemNode:[],
    },
    //得到此脚本的节点下总控制脚本,用来传递给它的所有成员item;
    setTarget: function setTarget(target) {
        this.target = target;
    },

    //itemData是item数据,itemPosMap是滚动条滚动时要用到的item位置数据.
    init: function init(itemData, scrollView, item, itemInterval, scrollViewCanFix, isSkipInit) {
        if (!arguments[0]) {
            return false;
        }

        this.itemData = itemData; //item数据
        this.scrollView = scrollView;
        this.item = item;
        this.itemInterval = itemInterval || 0; //间距
        this.scrollViewCanFix = scrollViewCanFix || true; //是否自动修正
        //初始化各类属性
        this.content = this.scrollView.content;
        this.layerHeight = this.scrollView.node.height;
        this.firstItemIndex = 0;
        this.lastItemIndex = 0;
        this.firstItemData = {};
        this.lastItemData = {};
        this.itemArr = [];
        this.itemNode = [];
        this.itemPosMap = new Map();
        this.initItemData = true;
        this.count = 0;
        if (isSkipInit) {
            return;
        }
        for (var i = 0; i < this.item.length; i++) {
            this.itemNode[i] = cc.instantiate(this.item[i]);
        }
        cc.log(this.testTime(0));
        this.initItem();
        this.getItemPos(0);
        this.scrollView.node.on('scrolling', this.callback, this);
        cc.log('tableView结束:' + this.testTime());
    },
    getItemPos: function getItemPos(index) {

        for (var i = index; i < this.itemData.length; i++) {
            var obj = {};
            var y = void 0;
            if (i === 0) {
                obj.startPos = 0;
            } else {
                obj.startPos = this.itemPosMap.get(i - 1).endPos;
            }
            var j = this.itemData[i].pfbType || 0;
            obj.endPos = obj.startPos + this.itemNode[j].height + this.itemInterval;
            this.itemPosMap.set(i, obj);
        }
        this.updateContentHeigh(this.itemPosMap.get(this.itemData.length - 1).endPos);
    },
    initItem: function initItem() {
        //实例化所有用到的item;j控制实例化item的数目,暂定超出两个
        var j = 0;

        for (var i = 0; i < this.itemData.length; i++) {
            if (this.content.height > this.layerHeight) {
                j++;
                if (j > 2) {
                    break;
                }
            }
            var y = void 0;
            if (i === 0) {
                y = 0;
            } else {
                y = this.itemArr[i - 1].y - this.itemArr[i - 1].height - this.itemInterval;
            }
            this.addItemNode(i, y);
            this.updateContentHeigh(this.itemArr[i].height - y);
        }
    },
    addItemNode: function addItemNode(i, y) {
        var pfbType = this.itemData[i].pfbType || 0;
        var item = cc.instantiate(this.itemNode[pfbType]);
        item.parent = this.content;
        item.pfbType = pfbType;
        item.index = i;
        if (i === 0) {
            item.y = 0;
        } else {
            item.y = y;
        }
        item.x = 0;
        //对item赋值
        item.getComponent(cc.Component).init(this.itemData[i], this);
        this.itemArr.push(item);
        cc.log('生成itemNode' + i);
    },
    updateContentHeigh: function updateContentHeigh(num) {
        this.content.height = num > this.layerHeight ? num : this.layerHeight;
        //cc.log('滚动条高度:', this.content.height);
    },

    //触摸滚动条的函数回调
    //第一,滚动条
    callback: function callback(event, eventType) {
        cc.log(event && event.type || eventType);
        if (this.content.height > this.layerHeight) {
            var firstItemPos = this.scrollView.getScrollOffset().y;
            var lastItemPos = firstItemPos + this.layerHeight;
            if (firstItemPos < 0) return;
            if (this.initItemData) {
                this.initItemData = false;
                this.updateFirstItemIndex(firstItemPos);
                this.itemCanMoveDown = true;
                this.updateLastItemIndex(lastItemPos);
                this.itemCanMoveDown = false;
            }

            //超出边界直接返回.
            //滚动条向上滑动可能会触发的函数
            if (firstItemPos > this.firstItemData.endPos) {
                if (this.lastItemIndex + 1 < this.itemData.length) {
                    this.updateFirstItemIndex(firstItemPos);
                }
                this.count++;
            }
            if (lastItemPos > this.lastItemData.endPos) {
                if (this.lastItemIndex + 1 < this.itemData.length) {
                    this.itemCanMoveDown = true;
                    this.updateLastItemIndex(lastItemPos);
                    this.itemCanMoveDown = false;
                }
            }
            //滚动条向下滑动可能会触发的函数
            if (lastItemPos < this.lastItemData.startPos) {
                this.updateLastItemIndex(lastItemPos);
                this.count--;
            }
            if (firstItemPos < this.firstItemData.startPos) {
                this.itemCanMoveUp = true;
                this.updateFirstItemIndex(firstItemPos);
                this.itemCanMoveUp = false;
            }
        }
    },
    updateFirstItemIndex: function updateFirstItemIndex() {
        var num = this.firstItemIndex;
        if (this.itemCanMoveUp && num > this.getItemIndex()[0] && num > 0) {
            this.itemMoveUp(this.firstItemIndex - 1);
        }
        this.updateItemIndex();
    },
    updateLastItemIndex: function updateLastItemIndex() {
        var num = this.lastItemIndex;
        if (this.itemCanMoveDown && num < this.getItemIndex()[1] && num + 1 < this.itemData.length) {
            this.itemMoveDown(this.lastItemIndex + 1);
        }
        this.updateItemIndex();
    },
    testTime: function testTime(time) {
        var t = new Date().getTime();
        this.lastTestTime = this.lastTestTime || t;
        var timestamp = new Date().getTime() - this.lastTestTime;
        return timestamp;
    },
    updateItemIndex: function updateItemIndex() {
        //cc.log(this.firstItemIndex, this.lastItemIndex, this.itemArr, this.itemData)
    },

    //得到滚动条此时状态下应有的itemNode元素,包括滚动条上方一个,滚动条下方一个.
    getItemIndex: function getItemIndex() {
        // return (function () {
        var firstItemPos = this.scrollView.getScrollOffset().y;
        var lastItemPos = firstItemPos + this.layerHeight;
        var arr = [];
        var _iteratorNormalCompletion = true;
        var _didIteratorError = false;
        var _iteratorError = undefined;

        try {
            for (var _iterator = this.itemPosMap.entries()[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                var _ref = _step.value;

                var _ref2 = _slicedToArray(_ref, 2);

                var key = _ref2[0];
                var value = _ref2[1];

                //判断状态的位置关系是[);
                var status1 = value.startPos <= firstItemPos && value.endPos > firstItemPos;
                var status2 = value.startPos >= firstItemPos && value.endPos < lastItemPos;
                var status3 = value.startPos <= lastItemPos && value.endPos > lastItemPos;
                if (status1) {
                    this.firstItemData.startPos = value.startPos;
                    this.firstItemData.endPos = value.endPos;
                    this.firstItemIndex = key;
                    arr.push(key);
                }
                if (status3) {
                    this.lastItemData.startPos = value.startPos;
                    this.lastItemData.endPos = value.endPos;
                    this.lastItemIndex = key;
                    arr.push(key);
                }
            }
        } catch (err) {
            _didIteratorError = true;
            _iteratorError = err;
        } finally {
            try {
                if (!_iteratorNormalCompletion && _iterator.return) {
                    _iterator.return();
                }
            } finally {
                if (_didIteratorError) {
                    throw _iteratorError;
                }
            }
        }

        return arr;
        // }).bind(this);
    },

    //firstIndex 滚动条顺序是从上到下开始遍历
    itemMoveUp: function itemMoveUp(num) {
        if (num < 0 || this.lastItemIndex + 1 < num || num + 1 > this.itemData.length) {
            return;
        }
        if (!this.hasItem(num)) {
            this.itemMove(num, -this.itemPosMap.get(num).startPos);
        }
        num++;
        return this.itemMoveUp(num);
    },
    itemMoveDown: function itemMoveDown(num) {
        if (num < 0 || this.firstItemIndex - 1 > num || num + 1 > this.itemData.length) {
            return;
        }
        if (!this.hasItem(num)) {
            this.itemMove(num, -this.itemPosMap.get(num).startPos);
        }
        num--;
        return this.itemMoveDown(num);
    },

    //判断指定index位置是否存在itemNode.
    hasItem: function hasItem(index) {
        for (var i = 0; i < this.itemArr.length; i++) {
            if (this.itemArr[i].index === index) {
                return true;
            }
        }
        return false;
    },

    //得到要移动的item的索引index,
    //逻辑判断,第一种情况,修改itemArr数组的某个对象,第二种情况实例化一个新itemNode
    itemMove: function itemMove(index, y) {
        for (var i = 0; i < this.itemArr.length; i++) {
            //index存在-1的情况,类似于在缓存池里的item.
            var status1 = this.itemArr[i].index < this.firstItemIndex - 1 ? true : false;
            var status2 = this.itemArr[i].index > this.lastItemIndex + 1 ? true : false;
            var status3 = this.itemArr[i].pfbType === this.itemData[index].pfbType;
            //cc.log('item的索引', this.firstItemIndex, this.lastItemIndex)
            if (status1 && status3 || status2 && status3) {
                //cc.log(i, index, this.itemArr, this.content.height);
                //给item赋值还有设置位置
                this.itemArr[i].index = index;
                this.itemArr[i].y = y;
                this.itemArr[i].getComponent(cc.Component).init(this.itemData[index], this);
                return;
            }
        }
        this.addItemNode(index, y);
    },

    //得到相关位置的排序index
    getPosIndex: function getPosIndex(pos) {
        var _iteratorNormalCompletion2 = true;
        var _didIteratorError2 = false;
        var _iteratorError2 = undefined;

        try {
            for (var _iterator2 = this.itemPosMap.entries()[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
                var _ref3 = _step2.value;

                var _ref4 = _slicedToArray(_ref3, 2);

                var key = _ref4[0];
                var value = _ref4[1];

                if (value.endPos > pos && value.startPos <= pos) {
                    return key;
                }
            }
        } catch (err) {
            _didIteratorError2 = true;
            _iteratorError2 = err;
        } finally {
            try {
                if (!_iteratorNormalCompletion2 && _iterator2.return) {
                    _iterator2.return();
                }
            } finally {
                if (_didIteratorError2) {
                    throw _iteratorError2;
                }
            }
        }
    },
    addItem: function addItem(obj) {
        this.itemData.push(obj);
        this.getItemPos(this.itemData.length - 1);
        var endPos = this.itemPosMap.get(this.itemData.length - 1).endPos;
        if (endPos - this.layerHeight > 0) {
            var startPos = endPos - this.layerHeight;
            //得到当前的firstItemIndex;
            for (var i = this.itemData.length - 1; i >= 0; i--) {
                if (this.itemPosMap.get(i).endPos > startPos && this.itemPosMap.get(i).startPos <= startPos) {
                    this.firstItemIndex = i;
                }
            }
            this.scrollView.scrollToBottom();
            this.lastItemIndex = this.itemData.length - 1;
            var num = this.firstItemIndex - 1 > 0 ? this.firstItemIndex - 1 : 0;
            this.itemMoveUp(num);
            return true;
        } else {
            this.firstItemIndex = 0;
            this.lastItemIndex = this.itemData.length - 1;
            this.itemMoveUp(this.firstItemIndex);
            return false;
        }
    },
    clearItem: function clearItem() {
        this.itemData = [];
        this.itemPosMap.clear();
        this.scrollView.scrollToTop();
        this.content.height = 0;
        for (var i in this.itemArr) {
            this.itemArr[i].index = -1;
            this.itemArr[i].y = 3000;
        }
    },
    deleteItem: function deleteItem(i) {
        this.itemData.splice(i, 1);
        this.getItemPos(this.itemData.length - 1);

        //改变this.itemArr的内容
        for (var j = 0; j < this.itemArr.length; j++) {
            if (this.itemArr[j].index === i) {
                this.itemArr[j].index = -1;
                this.itemArr[j].y = 3000;
            }
            if (this.itemArr[j].index > i) {
                var num = this.itemArr[j].index;
                // //cc.log(j,this.itemArr[j].index)
                this.itemArr[j].y = -this.itemPosMap.get(num - 1).startPos;
                this.itemArr[j].index = num - 1;
                //cc.log(this.itemArr[j].index, this.itemArr[j].y)
            }
        }
        this.updateContentHeigh(this.itemPosMap.get(this.itemData.length - 1).endPos);
        this.itemMoveUp(this.firstItemIndex);
    },
    resetItemData: function resetItemData(index) {
        for (var i = 0; i < this.itemArr.length; i++) {
            if (this.itemArr[i].index === index) {
                var js = this.itemArr[i].getComponent(cc.Component);
                js.init(this.itemData[index], this);
                break;
            }
        }
    },
    resetItemSize: function resetItemSize(index, infoHeight) {
        var func = function (index, infoHeight) {

            for (var i = 0; i < this.itemArr.length; i++) {
                if (this.itemArr[i].index > index) {
                    this.itemArr[i].y -= infoHeight;
                }
            }

            var _iteratorNormalCompletion3 = true;
            var _didIteratorError3 = false;
            var _iteratorError3 = undefined;

            try {
                for (var _iterator3 = this.itemPosMap.entries()[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
                    var _ref5 = _step3.value;

                    var _ref6 = _slicedToArray(_ref5, 2);

                    var key = _ref6[0];
                    var value = _ref6[1];

                    if (key === index) {
                        value.endPos += infoHeight;
                    }
                    if (key > index) {
                        value.endPos += infoHeight;
                        value.startPos += infoHeight;
                    }
                }
            } catch (err) {
                _didIteratorError3 = true;
                _iteratorError3 = err;
            } finally {
                try {
                    if (!_iteratorNormalCompletion3 && _iterator3.return) {
                        _iterator3.return();
                    }
                } finally {
                    if (_didIteratorError3) {
                        throw _iteratorError3;
                    }
                }
            }

            this.lastResetItemInfoHeight = infoHeight;
            this.lastResetItemIndex = index;
        }.bind(this);
        if (this.lastResetItemIndex !== null && this.lastResetItemInfoHeight) {
            if (this.lastResetItemIndex === index) {
                func(this.lastResetItemIndex, -this.lastResetItemInfoHeight);
                this.lastResetItemIndex = null;
                this.lastResetItemInfoHeight = 0;
            } else {
                func(this.lastResetItemIndex, -this.lastResetItemInfoHeight);

                func(index, infoHeight);
            }
        } else {
            func(index, infoHeight);
        }
        this.itemMoveUp(this.firstItemIndex);
        this.updateContentHeigh(this.itemPosMap.get(this.itemData.length - 1).endPos);
    }
});

cc._RF.pop();