var customManifestStr = JSON.stringify({

});


cc.Class({
    extends: cc.Component,

    properties: {
        manifestUrl: cc.RawAsset,

        panel: cc.Node,
        logLabel: cc.Label,

        _updating: false,
        _canRetry: false,
        _storagePath: '',
        _failCount:0
    },

    onLoad: function () {
        var self = this;

        if (!cc.sys.isNative) {
            return;
        }

        self._storagePath = ((jsb.fileUtils ? jsb.fileUtils.getWritablePath() : '/') + 'blackjack-remote-asset');
        self.onLog('Storage path for remote asset : ' + self._storagePath);

        var versionCompareHandle = function (versionA, versionB) {
            self.onLog("JS Custom Version Compare: version A is " + versionA + ', version B is ' + versionB);
            var vA = versionA.split('.');
            var vB = versionB.split('.');
            for (var i = 0; i < vA.length; ++i) {
                var a = parseInt(vA[i]);
                var b = parseInt(vB[i] || 0);
                if (a === b) {
                    continue;
                }
                else {
                    self.onLog("---versioncomparehandle--- res ---"+a +"--"+b);
                    return a - b;
                }
            }
            if (vB.length > vA.length) {
                self.onLog("---versioncomparehandle--- res --- -1");
                return -1;
            }
            else {
                self.onLog("---versioncomparehandle--- res --- 0");
                return 0;
            }
        };

        self._am = new jsb.AssetsManager('', self._storagePath, versionCompareHandle);
        if (!cc.sys.ENABLE_GC_FOR_NATIVE_OBJECTS) {
            self._am.retain();
        }

        self._am.setVerifyCallback(function (path, asset) {
            var compressed = asset.compressed;
            var expectedMD5 = asset.md5;
            var relativePath = asset.path;
            var size = asset.size;
            self.onLog("---data--- setverifycallback ---"+ compressed +"----"+size);
            if (compressed) {
                self.onLog("Verification passed : " + relativePath);
                return true;
            }
            else {
                self.onLog("Verification passed : " + relativePath + ' (' + expectedMD5 + ')');
                return true;
            }
        });

        self.onLog('Hot update is ready, please check or directly update.');

         if (cc.sys.os === cc.sys.OS_ANDROID) {
            self._am.setMaxConcurrentTask(2);
            self.onLog("Max concurrent tasks count have been limited to 2");
        }

    },

    checkUpdate: function () {
        if (this._updating) {
            this.onLog('Checking or updating ... 已经开始检查');
            return;
        }

        this.onLog("--- check Update begin ---");

        //本地(上面创建的)
        /*if (this._am.getState() === jsb.AssetsManager.State.UNINITED) {
            var manifest = new jsb.Manifest(customManifestStr, this._storagePath);
            this._am.loadLocalManifest(manifest, this._storagePath);
            this.onLog('Using custom manifest');
        }*/

        //动态
        this.onLog("----_am.getState----" + this._am.getState()+ "-----" +jsb.AssetsManager.State.UNINITED)
        if (this._am.getState() === jsb.AssetsManager.State.UNINITED) {
            this.onLog("this.manifestUrl" + this.manifestUrl);
            this._am.loadLocalManifest(this.manifestUrl);
        }

        if (!this._am.getLocalManifest() || !this._am.getLocalManifest().isLoaded()) {
            this.onLog('Failed to load local manifest ...');
            return;
        }

        this._checkListener = new jsb.EventListenerAssetsManager(this._am, this.checkCb.bind(this));
        cc.eventManager.addListener(this._checkListener, 1);

        this._am.checkUpdate();
        this._updating = true;
    },

    checkCb: function (event) {
        this.onLog('Code: ' + event.getEventCode());
        switch (event.getEventCode())
        {
            case jsb.EventAssetsManager.ERROR_NO_LOCAL_MANIFEST:
                this.onLog("No local manifest file found, hot update skipped.");
                break;
            case jsb.EventAssetsManager.ERROR_DOWNLOAD_MANIFEST:
            case jsb.EventAssetsManager.ERROR_PARSE_MANIFEST:
                this.onLog("Fail to download manifest file, hot update skipped.");
                break;
            case jsb.EventAssetsManager.ALREADY_UP_TO_DATE:
                this.onLog("Already up to date with the latest remote version.");
                break;
            case jsb.EventAssetsManager.NEW_VERSION_FOUND:
                this.onLog('New version found, please try to update.');
                break;
            default:
                return;
        }
        
        cc.eventManager.removeListener(this._checkListener);
        this._checkListener = null;
        this._updating = false;
    },

    hotUpdate: function () {
        this.onLog(" --- hotUpdate begin ---" + this._updating);
        if (this._am && !this._updating) {
            this.onLog("begin ---")

            this._updateListener = new jsb.EventListenerAssetsManager(this._am, this.updateCb.bind(this));
            cc.eventManager.addListener(this._updateListener, 1);

            this.onLog("----_am.getState----" + this._am.getState()+ "-----" +jsb.AssetsManager.State.UNINITED)
            
            if (this._am.getState() === jsb.AssetsManager.State.UNINITED) {
                this.onLog("this.manifestUrl" + this.manifestUrl);
                this._am.loadLocalManifest(this.manifestUrl);
            }

            this._failCount = 0;
            this.onLog("_failCount---" + this._failCount);
            this._am.update();
            this._updating = true;
        }
    },

    updateCb: function (event) {
        var needRestart = false;
        var failed = false;
        this.onLog("--- updateCb ---" + event.getEventCode());
        switch (event.getEventCode())
        {
            case jsb.EventAssetsManager.ERROR_NO_LOCAL_MANIFEST:
                this.onLog('No local manifest file found, hot update skipped.');
                failed = true;
                break;
            case jsb.EventAssetsManager.UPDATE_PROGRESSION:

                this.onLog( event.getDownloadedFiles() + ' / ' + event.getTotalFiles());
                this.onLog( event.getDownloadedBytes() + ' / ' + event.getTotalBytes());

                var msg = event.getMessage();
                if (msg) {
                    this.onLog('Updated file: ' + msg);
                }
                else{
                    this.onLog("msg is null");
                }
                break;
            case jsb.EventAssetsManager.ERROR_DOWNLOAD_MANIFEST:
            case jsb.EventAssetsManager.ERROR_PARSE_MANIFEST:
                this.onLog('Fail to download manifest file, hot update skipped.');
                failed = true;
                break;
            case jsb.EventAssetsManager.ALREADY_UP_TO_DATE:
                this.onLog('Already up to date with the latest remote version.');
                failed = true;
                break;
            case jsb.EventAssetsManager.UPDATE_FINISHED:
                this.onLog('Update finished. ' + event.getMessage());
                needRestart = true;
                break;
            case jsb.EventAssetsManager.UPDATE_FAILED:
                this.onLog('Update failed. ' + event.getMessage());
                this._updating = false;
                break;
            case jsb.EventAssetsManager.ERROR_UPDATING:
                this.onLog('Asset update error: ' + event.getAssetId() + ', ' + event.getMessage());
                break;
            case jsb.EventAssetsManager.ERROR_DECOMPRESS:
                this.onLog(event.getMessage());
                break;
            default:
                break;
        }

        if (failed) {
            this.onLog("---- failed----"+ failed);
            cc.eventManager.removeListener(this._updateListener);
            this._updateListener = null;
            this._updating = false;
        }
        else{
            this.onLog("---- success----"+ failed);
        }

        this.onLog("---- needRestart----"+ needRestart);
        if (needRestart) {
            cc.eventManager.removeListener(this._updateListener);
            this._updateListener = null;
            
            var searchPaths = jsb.fileUtils.getSearchPaths();
            var newPaths = this._am.getLocalManifest().getSearchPaths();
            console.log(JSON.stringify(newPaths));
            Array.prototype.unshift(searchPaths, newPaths);
            // This value will be retrieved and appended to the default search path during game startup,
            // please refer to samples/js-tests/main.js for detailed usage.
            // !!! Re-add the search paths in main.js is very important, otherwise, new scripts won't take effect.
            cc.sys.localStorage.setItem('HotUpdateSearchPaths', JSON.stringify(searchPaths));
            jsb.fileUtils.setSearchPaths(searchPaths);
            this.onLog("--- HotUpdateSearchPaths --- " + searchPaths);

            cc.audioEngine.stopAll();
            cc.game.restart();
        }
    },

    onLog:function(data){
        this.logLabel.string += data +"\n";
    }
});
