"use strict";
cc._RF.push(module, '280c3rsZJJKnZ9RqbALVwtK', 'HelloWorld');
// Script/HelloWorld.js

'use strict';

cc.Class({
    extends: cc.Component,

    properties: {
        enemy: {
            default: null,
            type: cc.Prefab
        }
    },

    // use this for initialization
    onLoad: function onLoad() {
        var self = this;
        self.initEnemyPool(self, self.enemy);
        self.schedule(self.createEnemy, 1);
    },

    //创建节点
    createEnemy: function createEnemy() {
        var self = this;
        var enemyNode = self.createEnemyNode(self['enemyPool'], self.enemy);
        if (enemyNode) {
            enemyNode.setPosition(self.getEnemyPos(enemyNode));
            self.node.addChild(enemyNode);
            enemyNode.getComponent('enemy').mainGame = self;
            enemyNode.getComponent('enemy').init();
        }
    },
    initEnemyPool: function initEnemyPool(thisObj, objInfo) {
        var poolName = 'enemyPool';
        thisObj[poolName] = new cc.NodePool();
        var initPoolCount = thisObj.initEnemyPoolCount;
        for (var i = 0; i < 1; ++i) {
            var nodeObj = cc.instantiate(objInfo); //创建节点
            thisObj[poolName].put(nodeObj); //放入对象池中
        }
    },

    //生成节点
    createEnemyNode: function createEnemyNode(objPool, prefab) {
        console.log('enemy is not null,size is:' + objPool.size() + '\n');
        var newNode = null;
        if (objPool.size() > 0) {
            newNode = objPool.get();
        }
        return newNode;
    },
    //随机生成的位置
    getEnemyPos: function getEnemyPos(newEnemy) {
        //位于上方，先不可见
        var self = this;
        return cc.v2(200, 330);
    },
    //放回对象池
    backObjectPool: function backObjectPool(poolName, nodeInfo) {
        console.log('pool name is:' + poolName + '\n');
        var self = this;
        self[poolName].put(nodeInfo);
    }
});

cc._RF.pop();