"use strict";
cc._RF.push(module, 'd1e37uHXpNJB4nxZfe2gtnF', 'enemy');
// Script/enemy.js

'use strict';

// Learn cc.Class:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/class.html
//  - [English] http://www.cocos2d-x.org/docs/creator/en/scripting/class.html
// Learn Attribute:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/en/scripting/life-cycle-callbacks.html

cc.Class({
    extends: cc.Component,

    properties: {
        xSpeed: 0,
        ySpeed: 0
    },
    // LIFE-CYCLE CALLBACKS:
    onLoad: function onLoad() {
        this.init();
    },
    init: function init() {
        var self = this;
        this.node.active = true;
        this.node.on('touchend', this.clickEnemy, this);
        console.log('*************************************** enemy ***********************************');
    },
    clickEnemy: function clickEnemy(other, self) {
        console.log('click enemy');
        var animation = this.node.getComponent(cc.Animation);
        animation.play();
        animation.on('finished', this.animationCallback, this);
    },

    animationCallback: function animationCallback() {
        this.node.off('touchend', this.clickEnemy, this);
        this.mainGame.backObjectPool('enemyPool', this.node);
    },
    update: function update(dt) {
        var self = this;
        if (this.node.active) {
            self.node.x += dt * self.xSpeed;
            self.node.y -= dt * self.ySpeed;
            if (self.node.y < -cc.winSize.height / 2) {
                self.mainGame.backObjectPool('enemyPool', self.node);
            }
        }
    }
});

cc._RF.pop();