(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/Script/enemy.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, 'd1e37uHXpNJB4nxZfe2gtnF', 'enemy', __filename);
// Script/enemy.js

'use strict';

// Learn cc.Class:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/class.html
//  - [English] http://www.cocos2d-x.org/docs/creator/en/scripting/class.html
// Learn Attribute:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/en/scripting/life-cycle-callbacks.html

cc.Class({
    extends: cc.Component,

    properties: {
        xSpeed: 0,
        ySpeed: 0
    },
    // LIFE-CYCLE CALLBACKS:
    onLoad: function onLoad() {
        this.init();
    },
    init: function init() {
        var self = this;
        this.node.active = true;
        this.node.on('touchend', this.clickEnemy, this);
        console.log('*************************************** enemy ***********************************');
    },
    clickEnemy: function clickEnemy(other, self) {
        console.log('click enemy');
        var animation = this.node.getComponent(cc.Animation);
        animation.play();
        animation.on('finished', this.animationCallback, this);
    },

    animationCallback: function animationCallback() {
        this.node.off('touchend', this.clickEnemy, this);
        this.mainGame.backObjectPool('enemyPool', this.node);
    },
    update: function update(dt) {
        var self = this;
        if (this.node.active) {
            self.node.x += dt * self.xSpeed;
            self.node.y -= dt * self.ySpeed;
            if (self.node.y < -cc.winSize.height / 2) {
                self.mainGame.backObjectPool('enemyPool', self.node);
            }
        }
    }
});

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=enemy.js.map
        