// Learn cc.Class:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/class.html
//  - [English] http://docs.cocos2d-x.org/creator/manual/en/scripting/class.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://docs.cocos2d-x.org/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] https://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html

cc.Class({
    extends: cc.Component,

    properties: {
        moveNode : cc.Node,
        heroNode: cc.Node,
        directionNode: cc.Node,
        heroBulletPrefab: cc.Prefab,

        bulletDirectionX: {
            default: -70,
            visible: false,
        },
        bulletDirectionY: {
            default: -43,
            visible: false,
        },

    },

    // onLoad () {},

    start() {
        // 默认朝着一个方向发射子弹
        this.schedule(function () {
            let bullet = cc.instantiate(this.heroBulletPrefab);
            bullet.getComponent("HeroBullet").init(this.bulletDirectionX, this.bulletDirectionY);
            this.moveNode.addChild(bullet);
        }.bind(this), 0.5);

        /*this.node.on('touchstart', function (event) {
            this.saveLocation(event);
        }.bind(this), this);*/
        this.node.on('touchmove', this.dragMove, this);
    },

    dragMove(event) {
        let locationv = event.getLocation();
        let location = this.node.convertToNodeSpaceAR(locationv);
        this.directionNode.rotation = -Math.atan2(location.y, location.x) * 180 / Math.PI - 90;
        let angle = -this.directionNode.rotation - 270;
        let offsetX = -Math.cos(angle * 0.017453293) * 56;
        let offsetY = -Math.sin(angle * 0.017453293) * 56;
        console.log("offset: " + offsetX + " , " + offsetY);
        console.log("hero: " + this.heroNode.position);
        let realPos = this.heroNode.position.add(cc.v2(offsetX, offsetY));
        console.log("sub: " + realPos);
        this.bulletDirectionX = realPos.x;
        this.bulletDirectionY = realPos.y;

    },

    // update (dt) {},
});