// Learn cc.Class:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/class.html
//  - [English] http://docs.cocos2d-x.org/creator/manual/en/scripting/class.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://docs.cocos2d-x.org/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] https://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html
const mHero = require("HeroScript");

cc.Class({
    extends: cc.Component,

    properties: {
        player: mHero,

        moveNode : cc.Node,

        oldParentNodeX: {
            default: 0.0,
            visible: false,
        },

        oldParentNodeY: {
            default: 0.0,
            visible: false,
        },

        oldHeroNodeX: {
            default: 0.0,
            visible: false,
        },

        oldHeroNodeY: {
            default: 0.0,
            visible: false,
        },
    },

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {},

    start() {
        this.node.on('touchstart', function (event) {
            this.saveLocation(event);
        }.bind(this), this);
        this.node.on('touchmove', this.dragMove, this);
    },

    saveLocation(event) {
        // 保存屏幕触控点
        let locationv = event.getLocation();
        let location = this.moveNode.convertToNodeSpaceAR(locationv);
        this.oldParentNodeX = location.x;
        this.oldParentNodeY = location.y;
        // 保存停留点
        let planePosition = this.player.node.position;
        this.oldHeroNodeX = planePosition.x;
        this.oldHeroNodeY = planePosition.y;
    },

    dragMove(event) {
        let locationv = event.getLocation();
        // console.log(locationv);
        // let location = this.node.convertToNodeSpaceAR(locationv);
        // let location = this.node.convertToNodeSpace(locationv);
        // let location = this.node.convertToWorldSpace(locationv);
        // let location = this.node.onvertToWorldSpaceAR(locationv);
        let location = this.moveNode.convertToNodeSpaceAR(locationv);
        // console.log(location);

        // 计算出偏移量
        let offsetX = location.x - this.oldParentNodeX;
        let offsetY = location.y - this.oldParentNodeY;
        // 当前的位置增加这些偏移量
        let newLocation = cc.v2(this.oldHeroNodeX + offsetX, this.oldHeroNodeY + offsetY);
        // 不移出屏幕
        let minX = -this.moveNode.width / 2 + this.player.node.width / 2;
        console.log("minX : " + minX);
        let maxX = -minX;
        let minY = -this.moveNode.height / 2 + this.player.node.height / 2;
        let maxY = -minY;
        if (newLocation.x < minX) {
            newLocation.x = minX;
            this.saveLocation(event);
        }
        if (newLocation.x > maxX) {
            newLocation.x = maxX;
            this.saveLocation(event);
        }
        if (newLocation.y < minY) {
            newLocation.y = minY;
            this.saveLocation(event);
        }
        if (newLocation.y > maxY) {
            newLocation.y = maxY;
            this.saveLocation(event);
        }
        this.player.node.setPosition(newLocation);
    },

    // update (dt) {},
});