(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/Script/cocos2.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, 'cfd50rPGoZP/ZMnd/4Dv2dr', 'cocos2', __filename);
// Script/cocos2.js

'use strict';

var ShaderUtils = require("ShaderUtils");

cc.Class({
    extends: cc.Component,

    properties: {
        spGray: cc.Sprite,
        fragName: {
            type: cc.String,
            default: '123'
        },
        tex1: cc.SpriteFrame
    },

    onLoad: function onLoad() {
        this.scaleX = 1;
        this.preScaleX = this.scaleX;
        this.resolution = { x: 0.0, y: 0.0 };
        // this.resolution.x = (this.node.getContentSize().width );
        // this.resolution.y = (this.node.getContentSize().height);


        //绑定 tex1
        var resTex1 = this.tex1.getTexture();
        var gltex1 = resTex1.getName();

        if (cc.sys.isNative) {} else {
            cc.gl.bindTexture2DN(1, resTex1);
        }

        this._program = ShaderUtils.setShader(this.spGray, 'gray', this.fragName);
        // let u_texture1 = this._program.getUniformLocationForName("texture1")
        // this._program.setUniformLocationWith1f( u_texture1, gltex1 );

        this._u_texture1 = this._program.getUniformLocationForName("g_Tex0"); //额外的shader图
        this._program.setUniformLocationWith1i(this._u_texture1, 1);
        if (!cc.sys.isNative) {
            var resolution = this._program.getUniformLocationForName("resolution");
            this._program.setUniformLocationWith2f(resolution, this.resolution);
            var time = this._program.getUniformLocationForName("time");
            this._program.setUniformLocationWith1f(time, 0.5);
        } else {
            this.glProgram_state = cc.GLProgramState.getOrCreateWithGLProgram(this._program);
            this.glProgram_state.setUniformFloat("v_maxY", 0.05);
            this.glProgram_state.setUniformFloat("v_maxX", 0.9);
            this.glProgram_state.setUniformFloat("resolution", this.resolution);
        }
    },

    start: function start() {
        this.startTime = new Date();
        this.scaleX_max = 0.9;
        this.scaleX_min = 1.1;
        this.diffScaleX = 0.004;
        this.scaleX = 1.0;
        this.preScaleX = this.scaleX - this.diffScaleX;
        this.ellipse_a = 0.5;
        this.ellipse_b = 0.5;
        this.offset_a_b = 0.05;
        this.time = 0.0;
        this.ellipse_angel = 180.0;
    },
    getScaleX: function getScaleX() {
        if (this.scaleX >= this.scaleX_min) {
            this.preScaleX = this.scaleX;
            this.scaleX -= this.diffScaleX;
        } else if (this.scaleX <= this.scaleX_max) {
            this.preScaleX = this.scaleX;
            this.scaleX += this.diffScaleX;
        } else {
            if (this.scaleX < this.preScaleX) {
                //减少阶段
                this.preScaleX = this.scaleX;
                this.scaleX -= this.diffScaleX;
            } else if (this.scaleX > this.preScaleX) {
                this.preScaleX = this.scaleX;
                this.scaleX += this.diffScaleX;
            } else {
                cc.log('error放大倍数不对！！！');
            }
        }
        // this.scaleX = this.scaleX.toFixed( 3 )
    },


    update: function update(dt) {

        this.time = this.time + 0.1;
        console.log('this.time', this.time);
        // let time = this._program.getUniformLocationForName("time")
        // this._program.setUniformLocationWith1f( time,  this.time);
        //
        //
        // return
        var deltaTime = (new Date() - this.startTime) / 1000;
        var sinValue = Math.sin(deltaTime * 100 * 3.14 / 180) * this.offset_a_b;

        console.log('ellipse_a', sinValue + this.ellipse_a);
        if (!cc.sys.isNative) {
            var ellipse_a = this._program.getUniformLocationForName("a");
            var ellipse_b = this._program.getUniformLocationForName("b");
            var _ellipse_angel = Math.sin(deltaTime * 100 * 3.14 / 180) * this.ellipse_angel;
            this._program.setUniformLocationWith1f(ellipse_a, sinValue + this.ellipse_a);
            this._program.setUniformLocationWith1f(ellipse_b, this.ellipse_b);
            var ellipse_angel = this._program.getUniformLocationForName("ellipse_angel");
            this._program.setUniformLocationWith1f(ellipse_angel, _ellipse_angel);
        } else {
            this.glProgram_state.setUniformFloat("u_scaleX", this.scaleX);
        }
    }
});

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=cocos2.js.map
        