const MOVE_LEFT = 1;
const MOVE_RIGHT = 2;
const MOVE_UP = 3;
const MOVE_DOWN = 4;

cc.Class({
    extends: cc.Component,

    properties: {
        maxSpeed: 200
    },

    // use this for initialization
    onLoad: function () {
        cc.systemEvent.on(cc.SystemEvent.EventType.KEY_DOWN, this.onKeyDown, this);
        cc.systemEvent.on(cc.SystemEvent.EventType.KEY_UP, this.onKeyUp, this);

        var canvas = cc.find('/Canvas');
        canvas.on(cc.Node.EventType.TOUCH_START, this.onTouchStart, this);
        canvas.on(cc.Node.EventType.TOUCH_END, this.onTouchEnd, this);

        this.moveFlags = 0;
    },

    start: function () {
        this.body = this.getComponent(cc.RigidBody);
    },

    onKeyDown (event) {
        switch(event.keyCode) {
            case cc.KEY.a:
            case cc.KEY.left:
                this.moveFlags = MOVE_LEFT;
                this.updateMotorSpeed();
                break;
            case cc.KEY.d:
            case cc.KEY.right:
                this.moveFlags = MOVE_RIGHT;
                this.updateMotorSpeed();
                break;
            case cc.KEY.w:
            case cc.KEY.KEY_UP:
                this.moveFlags = MOVE_UP;
                this.updateMotorSpeed();
                break;
            case cc.KEY.w:
            case cc.KEY.KEY_DOWN:
                this.moveFlags = MOVE_DOWN;
                this.updateMotorSpeed();
                break;
        }
    },

    onKeyUp (event) {
        this.moveFlags = null;
        // switch(event.keyCode) {
        //     case cc.KEY.a:
        //     case cc.KEY.left:
        //         this.moveFlags = null;
        //         // this.updateMotorSpeed();
        //         break;
        //     case cc.KEY.d:
        //     case cc.KEY.right:
        //         this.moveFlags &= ~MOVE_RIGHT;
        //         // this.updateMotorSpeed();
        //         break;
        //     case cc.KEY.w:
        //     case cc.KEY.KEY_UP:
        //         this.moveFlags &= ~MOVE_UP;
        //         //this.updateMotorSpeed();
        //         break;
        //     case cc.KEY.w:
        //     case cc.KEY.KEY_DOWN:
        //         this.moveFlags &= ~MOVE_DOWN;
        //         //this.updateMotorSpeed();
        //         break;
        // }
    },

    onTouchStart: function (event) {
        let touchLoc = event.touch.getLocation();
        if (touchLoc.x < cc.winSize.width/2) {
            this.moveFlags |= MOVE_LEFT;
        }
        else {
            this.moveFlags |= MOVE_RIGHT;
        }
        this.updateMotorSpeed();
    },

    onTouchEnd: function (event) {
        let touchLoc = event.touch.getLocation();
        if (touchLoc.x < cc.winSize.width/2) {
            this.moveFlags &= ~MOVE_LEFT;
        }
        else {
            this.moveFlags &= ~MOVE_RIGHT;
        }
        // this.updateMotorSpeed();
    },

    updateMotorSpeed () {
        if ( !this.body || this.node.name!="1")
            return;
        var desiredSpeed = 0;
        if ( this.moveFlags  == MOVE_LEFT )
        {
            desiredSpeed = -this.maxSpeed*3;
            //this.body.applyLinearImpulse(cc.v2(desiredSpeed,0), this.body.getWorldCenter(), true)
            this.body.applyForceToCenter(cc.v2(desiredSpeed,0));
        }
        else if ( this.moveFlags  == MOVE_RIGHT )
        {
            desiredSpeed = this.maxSpeed*3;
            this.body.applyForceToCenter(cc.v2(desiredSpeed,0));
        }else if ( this.moveFlags  == MOVE_UP ){
            desiredSpeed = this.maxSpeed;
            this.body.applyLinearImpulse(cc.v2(0,desiredSpeed), this.body.getWorldCenter(), true)
        }
            
    },

    // called every frame, uncomment this function to activate update callback
    update: function (dt) {
        if (this.moveFlags) {
            this.updateMotorSpeed();
        }
    },
});
