import UIManager from "./UIManager";

//界面（弹窗）类型(可根据项目自行扩展，并在UIManager中实现ViewType对应的操作)
export enum ViewType
{
    //普通
    Normal,
    //排他性
    Exclusivity,
}

const { ccclass, property } = cc._decorator;

@ccclass
export default class BaseView extends cc.Component
{
    public viewType: ViewType = ViewType.Normal;

    //做些界面的初始化工作，子类可重写。
    public init()
    {

    }

    //具备动画的显示
    public fadeIn()
    {

    }

    //具备动画的隐藏
    public fadeOut()
    {

    }

    //直接显示
    public show()
    {
        this.node.active = true;
    }

    //直接隐藏
    public hide()
    {
        this.node.active = false;
    }

    //将自身推出栈
    public popSelf()
    {
        UIManager.getInstance().pop(this);
    }
}


