import BaseView, { ViewType } from "./BaseView";

export class PanelName
{
    public static readonly MainPanel = "MainPanel";
    public static readonly GameoverPanel = "GameoverPanel";
    public static readonly WxSubPanel = "WxSubPanel";
}

export default class UIManager
{
    private static instance = new UIManager(); 
    private panelRoot: cc.Node;
    private panelPathDic = new Map<string, string>();
    private panelDic = new Map<string, BaseView>();
    private panelStack = new Array<BaseView>();



    //#region 外部接口
    public static getIns()
    {
        return this.instance;
    }

    public init()
    {
        this.panelRoot = cc.find("根路径，用于挂弹窗");
        this.parsePathJson();
    }

    public show(panelName: string)
    {
        let panelCompt = this.panelDic.get(panelName);
        if (panelCompt == undefined)
        {
	    //首次访问要先加载
            this.loadPanel(panelName);
        }
        else
        {
            this.pushPanel(panelCompt);
        }
    }

    public hide(panelName: string)
    {
        let panelCompt = this.panelDic.get(panelName);
        if (panelCompt != undefined)
        {
            this.popPanel(panelCompt);
        }
	else
	{
	    cc.log("弹窗不存在，请检查");
	}
    }

    public pop(panelCompt: BaseView)
    {
        panelCompt.hide();
        this.panelStack.pop();

        if (panelCompt.viewType == ViewType.Exclusivity && this.panelStack.length > 0)
        {
            //隐藏排他性窗口 需要显示被排斥隐藏的窗口
            for (let i = 0; i < this.panelStack.length; i++)
            {
                this.panelStack[i].show();
            }
        }
    }
    //#endregion



    //#region---------------------内部逻辑----------------------
    //私有构造函数 保证单例
    private constructor() { }

    //解析预制体路径json文件,可通过json文件配置项目中的弹窗加载路径，并在此处解析。
    //解析完成后存于panelPathDic字典中。
    private parsePathJson()
    {
        //这里直接存储，建议使用Json文件配置。
        this.panelPathDic.set("MainPanel", "prefab/MainPanel");
	this.panelPathDic.set("ShopPanel", "prefab/ShopPanel");
    }

    //加载单个
    private load(panelName: string)
    {
        let path = this.panelPathDic.get(panelName);
        //该方法是异步
        cc.loader.loadRes(path, cc.Prefab, (err, prefab) =>
        {
            if (err)
            {
                cc.error("UIManager LoadPanel:", err.message);
                return;
            }

            let panelNode = cc.instantiate(prefab);
            this.panelRoot.addChild(panelNode);
            let panelCompt: BaseView = panelNode.getComponent(BaseView);
            panelCompt.init();
            this.panelDic.set(panelName, panelCompt);
            this.pushPanel(panelCompt);
        });
    }

    //显示逻辑
    private push(panelCompt: BaseView)
    {
        if (panelCompt.viewType == ViewType.Exclusivity && this.panelStack.length > 0)
        {
            //显示排他性窗口 需要隐藏先进栈的窗口
            for (let i = 0; i < this.panelStack.length; i++)
            {
                this.panelStack[i].hide();
            }
        }

        panelCompt.show();
        this.panelStack.push(panelCompt);
    }
    //#endregion

}