const shader = {
    name: 'test',
    defines: [],

    vert: `
uniform mat4 viewProj;
attribute vec3 a_position;
attribute vec2 a_uv0;
varying vec2 uv0;

void main () {
    vec4 pos = viewProj * vec4(a_position, 1);
    gl_Position = pos;
    uv0 = a_uv0;
}
`,

    frag: `
#ifdef GL_ES
precision mediump float;
#endif
varying vec4 v_fragmentColor;
varying vec2 uv0;
uniform sampler2D texture;
uniform float u_radius;
uniform float u_offset;

void main()
{
    float edge = u_radius;
    float dis = 0.0;
    vec2 texCoord = uv0;
    if ( texCoord.x < edge )
    {
        if ( texCoord.y < edge )
        {
            dis = distance( texCoord, vec2(edge, edge) );
        }
        if ( texCoord.y > (1.0 - edge) )
        {
            dis = distance( texCoord, vec2(edge, (1.0 - edge)) );
        }
    }
    else if ( texCoord.x > (1.0 - edge) )
    {
        if ( texCoord.y < edge )
        {
            dis = distance( texCoord, vec2((1.0 - edge), edge ) );
        }
        if ( texCoord.y > (1.0 - edge) )
        {
            dis = distance( texCoord, vec2((1.0 - edge), (1.0 - edge) ) );
        }
    }
    if(dis > 0.001)
    {
        // 外圈沟
        float gap = edge * 0.03;
        if(dis <= edge - gap)
        {
            gl_FragColor = texture2D( texture,texCoord);
        }
        else if(dis <= edge)
        {
            // 平滑过渡
            float t = smoothstep(0.,gap,edge-dis);
            vec4 color = texture2D( texture,texCoord);
            gl_FragColor = vec4(color.rgb,t);
        }else{
            gl_FragColor = vec4(0.,0.,0.,0.);
        }
    }
    else
    {
        gl_FragColor = texture2D( texture,texCoord);
    }
}
  `
};



const math = cc.vmath;
const renderEngine = cc.renderer.renderEngine;
const renderer = renderEngine.renderer;
const gfx = renderEngine.gfx;
const Material = renderEngine.Material;

export default class ShaderMaterial extends Material {
    constructor() {
        super(false);
        // load the shader to program lib
        let rend = cc.renderer as any;
        rend._forward._programLib.define(shader.name, shader.vert, shader.frag, shader.defines);

        let pass = new renderer.Pass(shader.name);
        pass.setDepth(false, false);
        pass.setCullMode(gfx.CULL_NONE);
        pass.setBlend(
            gfx.BLEND_FUNC_ADD,
            gfx.BLEND_SRC_ALPHA, gfx.BLEND_ONE_MINUS_SRC_ALPHA,
            gfx.BLEND_FUNC_ADD,
            gfx.BLEND_SRC_ALPHA, gfx.BLEND_ONE_MINUS_SRC_ALPHA
        );

        let mainTech = new renderer.Technique(
            ['transparent'],
            [
                { name: 'iTexture', type: renderer.PARAM_TEXTURE_2D },
                { name: 'u_radius', type: renderer.PARAM_FLOAT },
            ],
            [pass]
        );

        this._texture = null;
        this._size = math.vec2.create();

        // need _effect to calculate hash
        this._effect = this.effect = new renderer.Effect(
            [mainTech],
            {
                'size': this._size
            },
            []
        );

        this._mainTech = mainTech;
    }

    getTexture() {
        return this._texture;
    }

    setTexture(val) {
        if (this._texture !== val) {
            this._texture = val;
            this._texture.update({
                // Adapt to shader
                flipY: false,
                // For load texture
                mipmap: false
            });
            this._effect.setProperty('iTexture', val.getImpl());
            this._texIds['iTexture'] = val.getId();
        }
    }

    setRadius(val) {
        this._effect.setProperty('u_radius', val);
    }
}