import ShaderMaterial from "./Material";

const { ccclass, property } = cc._decorator;

@ccclass
export default class Shader extends cc.Component {

    @property(cc.Sprite)
    Target: cc.Sprite = null;

    private _material: ShaderMaterial = null;
    private _time: number = 1;
    private _curDis: number = 2;
    private _startPos = { x: 0.5, y: 0.5 };
    private _isPlayAni: boolean = false;

    onLoad() {
        // 关闭动态图集
        // if (cc.dynamicAtlasManager) {
        //     cc.dynamicAtlasManager.enabled = false;
        // }
        this._material = new ShaderMaterial();

    }

    start() {
        if (this.Target) {
            let texture = this.Target.spriteFrame.getTexture();
            this._material.setTexture(texture);

            this._material.updateHash();
            let sp = this.Target as any;
            sp._material = this._material;
            sp._renderData._material = this._material;
        }
    }

    setRadius(event) {
        this._material.setRadius(event.progress / 2);
    }
}
