
(function(window,document,Laya){
	var __un=Laya.un,__uns=Laya.uns,__static=Laya.static,__class=Laya.class,__getset=Laya.getset,__newvec=Laya.__newvec;

	var BaseTexture=laya.resource.BaseTexture,Browser=laya.utils.Browser,Buffer=laya.webgl.utils.Buffer;
	var BufferStateBase=laya.webgl.BufferStateBase,Byte=laya.utils.Byte,ClassUtils=laya.utils.ClassUtils,CommandEncoder=laya.layagl.CommandEncoder;
	var Component=laya.components.Component,Config=Laya.Config,Context=laya.resource.Context,Event=laya.events.Event;
	var EventDispatcher=laya.events.EventDispatcher,Handler=laya.utils.Handler,InlcudeFile=laya.webgl.utils.InlcudeFile;
	var LayaGL=laya.layagl.LayaGL,LayaGLRunner=laya.layagl.LayaGLRunner,Loader=laya.net.Loader,LoaderManager=laya.net.LoaderManager;
	var MathUtil=laya.maths.MathUtil,Node=laya.display.Node,Point=laya.maths.Point,Render=laya.renders.Render;
	var RenderTexture2D=laya.resource.RenderTexture2D,Resource=laya.resource.Resource,RunDriver=laya.utils.RunDriver;
	var Shader=laya.webgl.shader.Shader,ShaderCompile=laya.webgl.utils.ShaderCompile,ShaderNode=laya.webgl.utils.ShaderNode;
	var Sprite=laya.display.Sprite,Stat=laya.utils.Stat,Submit=laya.webgl.submit.Submit,SubmitKey=laya.webgl.submit.SubmitKey;
	var Texture2D=laya.resource.Texture2D,Timer=laya.utils.Timer,URL=laya.net.URL,WebGL=laya.webgl.WebGL,WebGLContext=laya.webgl.WebGLContext;
Laya.interface('laya.d3.core.IClone');
Laya.interface('laya.d3.graphics.IVertex');
Laya.interface('laya.d3.core.scene.IOctreeObject');
/**
*<code>Quaternion</code> 类用于创建四元数。
*/
//class laya.d3.math.Native.ConchQuaternion
var ConchQuaternion=(function(){
	function ConchQuaternion(x,y,z,w,nativeElements){
		/**四元数元素数组*/
		//this.elements=null;
		(x===void 0)&& (x=0);
		(y===void 0)&& (y=0);
		(z===void 0)&& (z=0);
		(w===void 0)&& (w=1);
		var v;
		if (nativeElements){
			v=nativeElements;
			}else {
			v=new Float32Array(4);
		}
		v[0]=x;
		v[1]=y;
		v[2]=z;
		v[3]=w;
		this.elements=v;
	}

	__class(ConchQuaternion,'laya.d3.math.Native.ConchQuaternion');
	var __proto=ConchQuaternion.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*根据缩放值缩放四元数
	*@param scale 缩放值
	*@param out 输出四元数
	*/
	__proto.scaling=function(scaling,out){
		var e=out.elements;
		var f=this.elements;
		e[0]=f[0] *scaling;
		e[1]=f[1] *scaling;
		e[2]=f[2] *scaling;
		e[3]=f[3] *scaling;
	}

	/**
	*归一化四元数
	*@param out 输出四元数
	*/
	__proto.normalize=function(out){
		ConchQuaternion._normalizeArray(this.elements,out.elements);
	}

	/**
	*计算四元数的长度
	*@return 长度
	*/
	__proto.length=function(){
		var f=this.elements;
		var x=f[0],y=f[1],z=f[2],w=f[3];
		return Math.sqrt(x *x+y *y+z *z+w *w);
	}

	/**
	*根据绕X轴的角度旋转四元数
	*@param rad 角度
	*@param out 输出四元数
	*/
	__proto.rotateX=function(rad,out){
		var e=out.elements;
		var f=this.elements;
		rad *=0.5;
		var ax=f[0],ay=f[1],az=f[2],aw=f[3];
		var bx=Math.sin(rad),bw=Math.cos(rad);
		e[0]=ax *bw+aw *bx;
		e[1]=ay *bw+az *bx;
		e[2]=az *bw-ay *bx;
		e[3]=aw *bw-ax *bx;
	}

	/**
	*根据绕Y轴的制定角度旋转四元数
	*@param rad 角度
	*@param out 输出四元数
	*/
	__proto.rotateY=function(rad,out){
		var e=out.elements;
		var f=this.elements;
		rad *=0.5;
		var ax=f[0],ay=f[1],az=f[2],aw=f[3],by=Math.sin(rad),bw=Math.cos(rad);
		e[0]=ax *bw-az *by;
		e[1]=ay *bw+aw *by;
		e[2]=az *bw+ax *by;
		e[3]=aw *bw-ay *by;
	}

	/**
	*根据绕Z轴的制定角度旋转四元数
	*@param rad 角度
	*@param out 输出四元数
	*/
	__proto.rotateZ=function(rad,out){
		var e=out.elements;
		var f=this.elements;
		rad *=0.5;
		var ax=f[0],ay=f[1],az=f[2],aw=f[3],bz=Math.sin(rad),bw=Math.cos(rad);
		e[0]=ax *bw+ay *bz;
		e[1]=ay *bw-ax *bz;
		e[2]=az *bw+aw *bz;
		e[3]=aw *bw-az *bz;
	}

	/**
	*分解四元数到欧拉角（顺序为Yaw、Pitch、Roll），参考自http://xboxforums.create.msdn.com/forums/p/4574/23988.aspx#23988,问题绕X轴翻转超过±90度时有，会产生瞬间反转
	*@param quaternion 源四元数
	*@param out 欧拉角值
	*/
	__proto.getYawPitchRoll=function(out){
		ConchVector3.transformQuat(ConchVector3.ForwardRH,this,ConchQuaternion.TEMPVector31);
		ConchVector3.transformQuat(ConchVector3.Up,this,ConchQuaternion.TEMPVector32);
		var upe=ConchQuaternion.TEMPVector32.elements;
		ConchQuaternion.angleTo(ConchVector3.ZERO,ConchQuaternion.TEMPVector31,ConchQuaternion.TEMPVector33);
		var anglee=ConchQuaternion.TEMPVector33.elements;
		if (anglee[0]==Math.PI / 2){
			anglee[1]=ConchQuaternion.arcTanAngle(upe[2],upe[0]);
			anglee[2]=0;
			}else if (anglee[0]==-Math.PI / 2){
			anglee[1]=ConchQuaternion.arcTanAngle(-upe[2],-upe[0]);
			anglee[2]=0;
			}else {
			Matrix4x4.createRotationY(-anglee[1],ConchQuaternion.TEMPMatrix0);
			Matrix4x4.createRotationX(-anglee[0],ConchQuaternion.TEMPMatrix1);
			ConchVector3.transformCoordinate(ConchQuaternion.TEMPVector32,ConchQuaternion.TEMPMatrix0,ConchQuaternion.TEMPVector32);
			ConchVector3.transformCoordinate(ConchQuaternion.TEMPVector32,ConchQuaternion.TEMPMatrix1,ConchQuaternion.TEMPVector32);
			anglee[2]=ConchQuaternion.arcTanAngle(upe[1],-upe[0]);
		}
		if (anglee[1] <=-Math.PI)
			anglee[1]=Math.PI;
		if (anglee[2] <=-Math.PI)
			anglee[2]=Math.PI;
		if (anglee[1] >=Math.PI && anglee[2] >=Math.PI){
			anglee[1]=0;
			anglee[2]=0;
			anglee[0]=Math.PI-anglee[0];
		};
		var oe=out.elements;
		oe[0]=anglee[1];
		oe[1]=anglee[0];
		oe[2]=anglee[2];
	}

	/**
	*求四元数的逆
	*@param out 输出四元数
	*/
	__proto.invert=function(out){
		var e=out.elements;
		var f=this.elements;
		var a0=f[0],a1=f[1],a2=f[2],a3=f[3];
		var dot=a0 *a0+a1 *a1+a2 *a2+a3 *a3;
		var invDot=dot ? 1.0 / dot :0;
		e[0]=-a0 *invDot;
		e[1]=-a1 *invDot;
		e[2]=-a2 *invDot;
		e[3]=a3 *invDot;
	}

	/**
	*设置四元数为单位算数
	*@param out 输出四元数
	*/
	__proto.identity=function(){
		var e=this.elements;
		e[0]=0;
		e[1]=0;
		e[2]=0;
		e[3]=1;
	}

	/**
	*从Array数组拷贝值。
	*@param array 数组。
	*@param offset 数组偏移。
	*/
	__proto.fromArray=function(array,offset){
		(offset===void 0)&& (offset=0);
		this.elements[0]=array[offset+0];
		this.elements[1]=array[offset+1];
		this.elements[2]=array[offset+2];
		this.elements[3]=array[offset+3];
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var i,s,d;
		s=this.elements;
		d=destObject.elements;
		if (s===d){
			return;
		}
		for (i=0;i < 4;++i){
			d[i]=s[i];
		}
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var dest=/*__JS__ */new this.constructor();
		this.cloneTo(dest);
		return dest;
	}

	__proto.equals=function(b){
		var ae=this.elements;
		var be=b.elements;
		return MathUtils3D.nearEqual(ae[0],be[0])&& MathUtils3D.nearEqual(ae[1],be[1])&& MathUtils3D.nearEqual(ae[2],be[2])&& MathUtils3D.nearEqual(ae[3],be[3]);
	}

	/**
	*计算长度的平方。
	*@return 长度的平方。
	*/
	__proto.lengthSquared=function(){
		var x=this.elements[0];
		var y=this.elements[1];
		var z=this.elements[2];
		var w=this.elements[3];
		return (x *x)+(y *y)+(z *z)+(w *w);
	}

	/**
	*设置四元数的x值
	*/
	/**
	*获取四元数的x值
	*/
	__getset(0,__proto,'x',function(){
		return this.elements[0];
		},function(value){
		this.elements[0]=value;
	});

	/**
	*设置四元数的y值
	*/
	/**
	*获取四元数的y值
	*/
	__getset(0,__proto,'y',function(){
		return this.elements[1];
		},function(value){
		this.elements[1]=value;
	});

	/**
	*设置四元数的z值
	*/
	/**
	*获取四元数的z值
	*/
	__getset(0,__proto,'z',function(){
		return this.elements[2];
		},function(value){
		this.elements[2]=value;
	});

	/**
	*设置四元数的w值
	*/
	/**
	*获取四元数的w值
	*/
	__getset(0,__proto,'w',function(){
		return this.elements[3];
		},function(value){
		this.elements[3]=value;
	});

	ConchQuaternion._dotArray=function(l,r){
		return l[0] *r[0]+l[1] *r[1]+l[2] *r[2]+l[3] *r[3];
	}

	ConchQuaternion._normalizeArray=function(f,o){
		var x=f[0],y=f[1],z=f[2],w=f[3];
		var len=x *x+y *y+z *z+w *w;
		if (len > 0){
			len=1 / Math.sqrt(len);
			o[0]=x *len;
			o[1]=y *len;
			o[2]=z *len;
			o[3]=w *len;
		}
	}

	ConchQuaternion._lerpArray=function(l,r,amount,o){
		var inverse=1.0-amount;
		if (ConchQuaternion._dotArray(l,r)>=0){
			o[0]=(inverse *l[0])+(amount *r[0]);
			o[1]=(inverse *l[1])+(amount *r[1]);
			o[2]=(inverse *l[2])+(amount *r[2]);
			o[3]=(inverse *l[3])+(amount *r[3]);
			}else {
			o[0]=(inverse *l[0])-(amount *r[0]);
			o[1]=(inverse *l[1])-(amount *r[1]);
			o[2]=(inverse *l[2])-(amount *r[2]);
			o[3]=(inverse *l[3])-(amount *r[3]);
		}
		ConchQuaternion._normalizeArray(o,o);
	}

	ConchQuaternion.createFromYawPitchRoll=function(yaw,pitch,roll,out){
		var halfRoll=roll *0.5;
		var halfPitch=pitch *0.5;
		var halfYaw=yaw *0.5;
		var sinRoll=Math.sin(halfRoll);
		var cosRoll=Math.cos(halfRoll);
		var sinPitch=Math.sin(halfPitch);
		var cosPitch=Math.cos(halfPitch);
		var sinYaw=Math.sin(halfYaw);
		var cosYaw=Math.cos(halfYaw);
		var oe=out.elements;
		oe[0]=(cosYaw *sinPitch *cosRoll)+(sinYaw *cosPitch *sinRoll);
		oe[1]=(sinYaw *cosPitch *cosRoll)-(cosYaw *sinPitch *sinRoll);
		oe[2]=(cosYaw *cosPitch *sinRoll)-(sinYaw *sinPitch *cosRoll);
		oe[3]=(cosYaw *cosPitch *cosRoll)+(sinYaw *sinPitch *sinRoll);
	}

	ConchQuaternion.multiply=function(left,right,out){
		var le=left.elements;
		var re=right.elements;
		var oe=out.elements;
		var lx=le[0];
		var ly=le[1];
		var lz=le[2];
		var lw=le[3];
		var rx=re[0];
		var ry=re[1];
		var rz=re[2];
		var rw=re[3];
		var a=(ly *rz-lz *ry);
		var b=(lz *rx-lx *rz);
		var c=(lx *ry-ly *rx);
		var d=(lx *rx+ly *ry+lz *rz);
		oe[0]=(lx *rw+rx *lw)+a;
		oe[1]=(ly *rw+ry *lw)+b;
		oe[2]=(lz *rw+rz *lw)+c;
		oe[3]=lw *rw-d;
	}

	ConchQuaternion.arcTanAngle=function(x,y){
		if (x==0){
			if (y==1)
				return Math.PI / 2;
			return-Math.PI / 2;
		}
		if (x > 0)
			return Math.atan(y / x);
		if (x < 0){
			if (y > 0)
				return Math.atan(y / x)+Math.PI;
			return Math.atan(y / x)-Math.PI;
		}
		return 0;
	}

	ConchQuaternion.angleTo=function(from,location,angle){
		ConchVector3.subtract(location,from,ConchQuaternion.TEMPVector30);
		ConchVector3.normalize(ConchQuaternion.TEMPVector30,ConchQuaternion.TEMPVector30);
		angle.elements[0]=Math.asin(ConchQuaternion.TEMPVector30.y);
		angle.elements[1]=ConchQuaternion.arcTanAngle(-ConchQuaternion.TEMPVector30.z,-ConchQuaternion.TEMPVector30.x);
	}

	ConchQuaternion.createFromAxisAngle=function(axis,rad,out){
		var e=out.elements;
		var f=axis.elements;
		rad=rad *0.5;
		var s=Math.sin(rad);
		e[0]=s *f[0];
		e[1]=s *f[1];
		e[2]=s *f[2];
		e[3]=Math.cos(rad);
	}

	ConchQuaternion.createFromMatrix3x3=function(sou,out){
		var e=out.elements;
		var f=sou.elements;
		var fTrace=f[0]+f[4]+f[8];
		var fRoot;
		if (fTrace > 0.0){
			fRoot=Math.sqrt(fTrace+1.0);
			e[3]=0.5 *fRoot;
			fRoot=0.5 / fRoot;
			e[0]=(f[5]-f[7])*fRoot;
			e[1]=(f[6]-f[2])*fRoot;
			e[2]=(f[1]-f[3])*fRoot;
			}else {
			var i=0;
			if (f[4] > f[0])
				i=1;
			if (f[8] > f[i *3+i])
				i=2;
			var j=(i+1)% 3;
			var k=(i+2)% 3;
			fRoot=Math.sqrt(f[i *3+i]-f[j *3+j]-f[k *3+k]+1.0);
			e[i]=0.5 *fRoot;
			fRoot=0.5 / fRoot;
			e[3]=(f[j *3+k]-f[k *3+j])*fRoot;
			e[j]=(f[j *3+i]+f[i *3+j])*fRoot;
			e[k]=(f[k *3+i]+f[i *3+k])*fRoot;
		}
		return;
	}

	ConchQuaternion.createFromMatrix4x4=function(mat,out){
		var me=mat.elements;
		var oe=out.elements;
		var sqrt;
		var half;
		var scale=me[0]+me[5]+me[10];
		if (scale > 0.0){
			sqrt=Math.sqrt(scale+1.0);
			oe[3]=sqrt *0.5;
			sqrt=0.5 / sqrt;
			oe[0]=(me[6]-me[9])*sqrt;
			oe[1]=(me[8]-me[2])*sqrt;
			oe[2]=(me[1]-me[4])*sqrt;
			}else if ((me[0] >=me[5])&& (me[0] >=me[10])){
			sqrt=Math.sqrt(1.0+me[0]-me[5]-me[10]);
			half=0.5 / sqrt;
			oe[0]=0.5 *sqrt;
			oe[1]=(me[1]+me[4])*half;
			oe[2]=(me[2]+me[8])*half;
			oe[3]=(me[6]-me[9])*half;
			}else if (me[5] > me[10]){
			sqrt=Math.sqrt(1.0+me[5]-me[0]-me[10]);
			half=0.5 / sqrt;
			oe[0]=(me[4]+me[1])*half;
			oe[1]=0.5 *sqrt;
			oe[2]=(me[9]+me[6])*half;
			oe[3]=(me[8]-me[2])*half;
			}else {
			sqrt=Math.sqrt(1.0+me[10]-me[0]-me[5]);
			half=0.5 / sqrt;
			oe[0]=(me[8]+me[2])*half;
			oe[1]=(me[9]+me[6])*half;
			oe[2]=0.5 *sqrt;
			oe[3]=(me[1]-me[4])*half;
		}
	}

	ConchQuaternion.slerp=function(left,right,t,out){
		var a=left.elements;
		var b=right.elements;
		var oe=out.elements;
		var ax=a[0],ay=a[1],az=a[2],aw=a[3],bx=b[0],by=b[1],bz=b[2],bw=b[3];
		var omega,cosom,sinom,scale0,scale1;
		cosom=ax *bx+ay *by+az *bz+aw *bw;
		if (cosom < 0.0){
			cosom=-cosom;
			bx=-bx;
			by=-by;
			bz=-bz;
			bw=-bw;
		}
		if ((1.0-cosom)> 0.000001){
			omega=Math.acos(cosom);
			sinom=Math.sin(omega);
			scale0=Math.sin((1.0-t)*omega)/ sinom;
			scale1=Math.sin(t *omega)/ sinom;
			}else {
			scale0=1.0-t;
			scale1=t;
		}
		oe[0]=scale0 *ax+scale1 *bx;
		oe[1]=scale0 *ay+scale1 *by;
		oe[2]=scale0 *az+scale1 *bz;
		oe[3]=scale0 *aw+scale1 *bw;
		return oe;
	}

	ConchQuaternion.lerp=function(left,right,amount,out){
		ConchQuaternion._lerpArray(left.elements,right.elements,amount,out.elements);
	}

	ConchQuaternion.add=function(left,right,out){
		var e=out.elements;
		var f=left.elements;
		var g=right.elements;
		e[0]=f[0]+g[0];
		e[1]=f[1]+g[1];
		e[2]=f[2]+g[2];
		e[3]=f[3]+g[3];
	}

	ConchQuaternion.dot=function(left,right){
		return ConchQuaternion._dotArray(left.elements,right.elements);
	}

	ConchQuaternion.rotationLookAt=function(forward,up,out){
		ConchQuaternion.lookAt(ConchVector3.ZERO,forward,up,out);
	}

	ConchQuaternion.lookAt=function(eye,target,up,out){
		Matrix3x3.lookAt(eye,target,up,ConchQuaternion._tempMatrix3x3);
		ConchQuaternion.rotationMatrix(ConchQuaternion._tempMatrix3x3,out);
	}

	ConchQuaternion.invert=function(value,out){
		var vE=value.elements;
		var oE=out.elements;
		var lengthSq=value.lengthSquared();
		if (!MathUtils3D.isZero(lengthSq)){
			lengthSq=1.0 / lengthSq;
			oE[0]=-vE[0] *lengthSq;
			oE[1]=-vE[1] *lengthSq;
			oE[2]=-vE[2] *lengthSq;
			oE[3]=vE[3] *lengthSq;
		}
	}

	ConchQuaternion.rotationMatrix=function(matrix3x3,out){
		var me=matrix3x3.elements;
		var m11=me[0];
		var m12=me[1];
		var m13=me[2];
		var m21=me[3];
		var m22=me[4];
		var m23=me[5];
		var m31=me[6];
		var m32=me[7];
		var m33=me[8];
		var oe=out.elements;
		var sqrt=NaN,half=NaN;
		var scale=m11+m22+m33;
		if (scale > 0){
			sqrt=Math.sqrt(scale+1);
			oe[3]=sqrt *0.5;
			sqrt=0.5 / sqrt;
			oe[0]=(m23-m32)*sqrt;
			oe[1]=(m31-m13)*sqrt;
			oe[2]=(m12-m21)*sqrt;
			}else if ((m11 >=m22)&& (m11 >=m33)){
			sqrt=Math.sqrt(1+m11-m22-m33);
			half=0.5 / sqrt;
			oe[0]=0.5 *sqrt;
			oe[1]=(m12+m21)*half;
			oe[2]=(m13+m31)*half;
			oe[3]=(m23-m32)*half;
			}else if (m22 > m33){
			sqrt=Math.sqrt(1+m22-m11-m33);
			half=0.5 / sqrt;
			oe[0]=(m21+m12)*half;
			oe[1]=0.5 *sqrt;
			oe[2]=(m32+m23)*half;
			oe[3]=(m31-m13)*half;
			}else {
			sqrt=Math.sqrt(1+m33-m11-m22);
			half=0.5 / sqrt;
			oe[0]=(m31+m13)*half;
			oe[1]=(m32+m23)*half;
			oe[2]=0.5 *sqrt;
			oe[3]=(m12-m21)*half;
		}
	}

	ConchQuaternion.DEFAULT=new ConchQuaternion();
	__static(ConchQuaternion,
	['TEMPVector30',function(){return this.TEMPVector30=new ConchVector3();},'TEMPVector31',function(){return this.TEMPVector31=new ConchVector3();},'TEMPVector32',function(){return this.TEMPVector32=new ConchVector3();},'TEMPVector33',function(){return this.TEMPVector33=new ConchVector3();},'TEMPMatrix0',function(){return this.TEMPMatrix0=new Matrix4x4();},'TEMPMatrix1',function(){return this.TEMPMatrix1=new Matrix4x4();},'_tempMatrix3x3',function(){return this._tempMatrix3x3=new Matrix3x3();},'NAN',function(){return this.NAN=new ConchQuaternion(NaN,NaN,NaN,NaN);}
	]);
	return ConchQuaternion;
})()


/**
*<code>Vector4</code> 类用于创建四维向量。
*/
//class laya.d3.math.Native.ConchVector4
var ConchVector4=(function(){
	function ConchVector4(x,y,z,w){
		/**[只读]向量元素集合。*/
		this.elements=null;
		(x===void 0)&& (x=0);
		(y===void 0)&& (y=0);
		(z===void 0)&& (z=0);
		(w===void 0)&& (w=0);
		var v=this.elements=new Float32Array(4);
		v[0]=x;
		v[1]=y;
		v[2]=z;
		v[3]=w;
	}

	__class(ConchVector4,'laya.d3.math.Native.ConchVector4');
	var __proto=ConchVector4.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*从Array数组拷贝值。
	*@param array 数组。
	*@param offset 数组偏移。
	*/
	__proto.fromArray=function(array,offset){
		(offset===void 0)&& (offset=0);
		this.elements[0]=array[offset+0];
		this.elements[1]=array[offset+1];
		this.elements[2]=array[offset+2];
		this.elements[3]=array[offset+3];
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destVector4=destObject;
		var destE=destVector4.elements;
		var s=this.elements;
		destE[0]=s[0];
		destE[1]=s[1];
		destE[2]=s[2];
		destE[3]=s[3];
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destVector4=/*__JS__ */new this.constructor();
		this.cloneTo(destVector4);
		return destVector4;
	}

	/**
	*求四维向量的长度。
	*@return 长度。
	*/
	__proto.length=function(){
		return Math.sqrt(this.x *this.x+this.y *this.y+this.z *this.z+this.w *this.w);
	}

	/**
	*求四维向量长度的平方。
	*@return 长度的平方。
	*/
	__proto.lengthSquared=function(){
		return this.x *this.x+this.y *this.y+this.z *this.z+this.w *this.w;
	}

	/**
	*设置X轴坐标。
	*@param value X轴坐标。
	*/
	/**
	*获取X轴坐标。
	*@return X轴坐标。
	*/
	__getset(0,__proto,'x',function(){
		return this.elements[0];
		},function(value){
		this.elements[0]=value;
	});

	/**
	*设置Y轴坐标。
	*@param value Y轴坐标。
	*/
	/**
	*获取Y轴坐标。
	*@return Y轴坐标。
	*/
	__getset(0,__proto,'y',function(){
		return this.elements[1];
		},function(value){
		this.elements[1]=value;
	});

	/**
	*设置Z轴坐标。
	*@param value Z轴坐标。
	*/
	/**
	*获取Z轴坐标。
	*@return Z轴坐标。
	*/
	__getset(0,__proto,'z',function(){
		return this.elements[2];
		},function(value){
		this.elements[2]=value;
	});

	/**
	*设置W轴坐标。
	*@param value W轴坐标。
	*/
	/**
	*获取W轴坐标。
	*@return W轴坐标。
	*/
	__getset(0,__proto,'w',function(){
		return this.elements[3];
		},function(value){
		this.elements[3]=value;
	});

	ConchVector4.lerp=function(a,b,t,out){
		var e=out.elements;
		var f=a.elements;
		var g=b.elements;
		var ax=f[0],ay=f[1],az=f[2],aw=f[3];
		e[0]=ax+t *(g[0]-ax);
		e[1]=ay+t *(g[1]-ay);
		e[2]=az+t *(g[2]-az);
		e[3]=aw+t *(g[3]-aw);
	}

	ConchVector4.transformByM4x4=function(vector4,m4x4,out){
		var ve=vector4.elements;
		var vx=ve[0];
		var vy=ve[1];
		var vz=ve[2];
		var vw=ve[3];
		var me=m4x4.elements;
		var oe=out.elements;
		oe[0]=vx *me[0]+vy *me[4]+vz *me[8]+vw *me[12];
		oe[1]=vx *me[1]+vy *me[5]+vz *me[9]+vw *me[13];
		oe[2]=vx *me[2]+vy *me[6]+vz *me[10]+vw *me[14];
		oe[3]=vx *me[3]+vy *me[7]+vz *me[11]+vw *me[15];
	}

	ConchVector4.equals=function(a,b){
		var ae=a.elements;
		var be=b.elements;
		return MathUtils3D.nearEqual(Math.abs(ae[0]),Math.abs(be[0]))&& MathUtils3D.nearEqual(Math.abs(ae[1]),Math.abs(be[1]))&& MathUtils3D.nearEqual(Math.abs(ae[2]),Math.abs(be[2]))&& MathUtils3D.nearEqual(Math.abs(ae[3]),Math.abs(be[3]));
	}

	ConchVector4.normalize=function(s,out){
		var se=s.elements;
		var oe=out.elements;
		var len=/*if err,please use iflash.method.xmlLength()*/s.length();
		if (len > 0){
			oe[0]=se[0] *len;
			oe[1]=se[1] *len;
			oe[2]=se[2] *len;
			oe[3]=se[3] *len;
		}
	}

	ConchVector4.add=function(a,b,out){
		var oe=out.elements;
		var ae=a.elements;
		var be=b.elements;
		oe[0]=ae[0]+be[0];
		oe[1]=ae[1]+be[1];
		oe[2]=ae[2]+be[2];
		oe[3]=ae[3]+be[3];
	}

	ConchVector4.subtract=function(a,b,out){
		var oe=out.elements;
		var ae=a.elements;
		var be=b.elements;
		oe[0]=ae[0]-be[0];
		oe[1]=ae[1]-be[1];
		oe[2]=ae[2]-be[2];
		oe[3]=ae[3]-be[3];
	}

	ConchVector4.multiply=function(a,b,out){
		var oe=out.elements;
		var ae=a.elements;
		var be=b.elements;
		oe[0]=ae[0] *be[0];
		oe[1]=ae[1] *be[1];
		oe[2]=ae[2] *be[2];
		oe[3]=ae[3] *be[3];
	}

	ConchVector4.scale=function(a,b,out){
		var oe=out.elements;
		var ae=a.elements;
		oe[0]=ae[0] *b;
		oe[1]=ae[1] *b;
		oe[2]=ae[2] *b;
		oe[3]=ae[3] *b;
	}

	ConchVector4.Clamp=function(value,min,max,out){
		var valuee=value.elements;
		var x=valuee[0];
		var y=valuee[1];
		var z=valuee[2];
		var w=valuee[3];
		var mine=min.elements;
		var mineX=mine[0];
		var mineY=mine[1];
		var mineZ=mine[2];
		var mineW=mine[3];
		var maxe=max.elements;
		var maxeX=maxe[0];
		var maxeY=maxe[1];
		var maxeZ=maxe[2];
		var maxeW=maxe[3];
		var oute=out.elements;
		x=(x > maxeX)? maxeX :x;
		x=(x < mineX)? mineX :x;
		y=(y > maxeY)? maxeY :y;
		y=(y < mineY)? mineY :y;
		z=(z > maxeZ)? maxeZ :z;
		z=(z < mineZ)? mineZ :z;
		w=(w > maxeW)? maxeW :w;
		w=(w < mineW)? mineW :w;
		oute[0]=x;
		oute[1]=y;
		oute[2]=z;
		oute[3]=w;
	}

	ConchVector4.distanceSquared=function(value1,value2){
		var value1e=value1.elements;
		var value2e=value2.elements;
		var x=value1e[0]-value2e[0];
		var y=value1e[1]-value2e[1];
		var z=value1e[2]-value2e[2];
		var w=value1e[3]-value2e[3];
		return (x *x)+(y *y)+(z *z)+(w *w);
	}

	ConchVector4.distance=function(value1,value2){
		var value1e=value1.elements;
		var value2e=value2.elements;
		var x=value1e[0]-value2e[0];
		var y=value1e[1]-value2e[1];
		var z=value1e[2]-value2e[2];
		var w=value1e[3]-value2e[3];
		return Math.sqrt((x *x)+(y *y)+(z *z)+(w *w));
	}

	ConchVector4.dot=function(a,b){
		var ae=a.elements;
		var be=b.elements;
		var r=(ae[0] *be[0])+(ae[1] *be[1])+(ae[2] *be[2])+(ae[3] *be[3]);
		return r;
	}

	ConchVector4.min=function(a,b,out){
		var e=out.elements;
		var f=a.elements;
		var g=b.elements
		e[0]=Math.min(f[0],g[0]);
		e[1]=Math.min(f[1],g[1]);
		e[2]=Math.min(f[2],g[2]);
		e[3]=Math.min(f[3],g[3]);
	}

	ConchVector4.max=function(a,b,out){
		var e=out.elements;
		var f=a.elements;
		var g=b.elements
		e[0]=Math.max(f[0],g[0]);
		e[1]=Math.max(f[1],g[1]);
		e[2]=Math.max(f[2],g[2]);
		e[3]=Math.max(f[3],g[3]);
	}

	__static(ConchVector4,
	['ZERO',function(){return this.ZERO=new ConchVector4();},'ONE',function(){return this.ONE=new ConchVector4(1.0,1.0,1.0,1.0);},'UnitX',function(){return this.UnitX=new ConchVector4(1.0,0.0,0.0,0.0);},'UnitY',function(){return this.UnitY=new ConchVector4(0.0,1.0,0.0,0.0);},'UnitZ',function(){return this.UnitZ=new ConchVector4(0.0,0.0,1.0,0.0);},'UnitW',function(){return this.UnitW=new ConchVector4(0.0,0.0,0.0,1.0);}
	]);
	return ConchVector4;
})()


/**
*<code>Vector3</code> 类用于创建三维向量。
*/
//class laya.d3.math.Native.ConchVector3
var ConchVector3=(function(){
	function ConchVector3(x,y,z,nativeElements){
		/**[只读]向量元素集合。*/
		this.elements=null;
		(x===void 0)&& (x=0);
		(y===void 0)&& (y=0);
		(z===void 0)&& (z=0);
		var v;
		if (nativeElements){
			v=nativeElements;
			}else {
			v=new Float32Array(3);
		}
		this.elements=v;
		v[0]=x;
		v[1]=y;
		v[2]=z;
	}

	__class(ConchVector3,'laya.d3.math.Native.ConchVector3');
	var __proto=ConchVector3.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*设置xyz值。
	*@param x X值。
	*@param y Y值。
	*@param z Z值。
	*/
	__proto.setValue=function(x,y,z){
		this.elements[0]=x;
		this.elements[1]=y;
		this.elements[2]=z;
	}

	/**
	*从Array数组拷贝值。
	*@param array 数组。
	*@param offset 数组偏移。
	*/
	__proto.fromArray=function(array,offset){
		(offset===void 0)&& (offset=0);
		this.elements[0]=array[offset+0];
		this.elements[1]=array[offset+1];
		this.elements[2]=array[offset+2];
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destVector3=destObject;
		var destE=destVector3.elements;
		var s=this.elements;
		destE[0]=s[0];
		destE[1]=s[1];
		destE[2]=s[2];
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destVector3=/*__JS__ */new this.constructor();
		this.cloneTo(destVector3);
		return destVector3;
	}

	__proto.toDefault=function(){
		this.elements[0]=0;
		this.elements[1]=0;
		this.elements[2]=0;
	}

	/**
	*设置X轴坐标。
	*@param value X轴坐标。
	*/
	/**
	*获取X轴坐标。
	*@return X轴坐标。
	*/
	__getset(0,__proto,'x',function(){
		return this.elements[0];
		},function(value){
		this.elements[0]=value;
	});

	/**
	*设置Y轴坐标。
	*@param value Y轴坐标。
	*/
	/**
	*获取Y轴坐标。
	*@return Y轴坐标。
	*/
	__getset(0,__proto,'y',function(){
		return this.elements[1];
		},function(value){
		this.elements[1]=value;
	});

	/**
	*设置Z轴坐标。
	*@param value Z轴坐标。
	*/
	/**
	*获取Z轴坐标。
	*@return Z轴坐标。
	*/
	__getset(0,__proto,'z',function(){
		return this.elements[2];
		},function(value){
		this.elements[2]=value;
	});

	ConchVector3.distanceSquared=function(value1,value2){
		var value1e=value1.elements;
		var value2e=value2.elements;
		var x=value1e[0]-value2e[0];
		var y=value1e[1]-value2e[1];
		var z=value1e[2]-value2e[2];
		return (x *x)+(y *y)+(z *z);
	}

	ConchVector3.distance=function(value1,value2){
		var value1e=value1.elements;
		var value2e=value2.elements;
		var x=value1e[0]-value2e[0];
		var y=value1e[1]-value2e[1];
		var z=value1e[2]-value2e[2];
		return Math.sqrt((x *x)+(y *y)+(z *z));
	}

	ConchVector3.min=function(a,b,out){
		var e=out.elements;
		var f=a.elements;
		var g=b.elements
		e[0]=Math.min(f[0],g[0]);
		e[1]=Math.min(f[1],g[1]);
		e[2]=Math.min(f[2],g[2]);
	}

	ConchVector3.max=function(a,b,out){
		var e=out.elements;
		var f=a.elements;
		var g=b.elements
		e[0]=Math.max(f[0],g[0]);
		e[1]=Math.max(f[1],g[1]);
		e[2]=Math.max(f[2],g[2]);
	}

	ConchVector3.transformQuat=function(source,rotation,out){
		var destination=out.elements;
		var se=source.elements;
		var re=rotation.elements;
		var x=se[0],y=se[1],z=se[2],qx=re[0],qy=re[1],qz=re[2],qw=re[3],
		ix=qw *x+qy *z-qz *y,iy=qw *y+qz *x-qx *z,iz=qw *z+qx *y-qy *x,iw=-qx *x-qy *y-qz *z;
		destination[0]=ix *qw+iw *-qx+iy *-qz-iz *-qy;
		destination[1]=iy *qw+iw *-qy+iz *-qx-ix *-qz;
		destination[2]=iz *qw+iw *-qz+ix *-qy-iy *-qx;
	}

	ConchVector3.scalarLength=function(a){
		var f=a.elements;
		var x=f[0],y=f[1],z=f[2];
		return Math.sqrt(x *x+y *y+z *z);
	}

	ConchVector3.scalarLengthSquared=function(a){
		var f=a.elements;
		var x=f[0],y=f[1],z=f[2];
		return x *x+y *y+z *z;
	}

	ConchVector3.normalize=function(s,out){
		var se=s.elements;
		var oe=out.elements;
		var x=se[0],y=se[1],z=se[2];
		var len=x *x+y *y+z *z;
		if (len > 0){
			len=1 / Math.sqrt(len);
			oe[0]=se[0] *len;
			oe[1]=se[1] *len;
			oe[2]=se[2] *len;
		}
	}

	ConchVector3.multiply=function(a,b,out){
		var e=out.elements;
		var f=a.elements;
		var g=b.elements
		e[0]=f[0] *g[0];
		e[1]=f[1] *g[1];
		e[2]=f[2] *g[2];
	}

	ConchVector3.scale=function(a,b,out){
		var e=out.elements;
		var f=a.elements;
		e[0]=f[0] *b;
		e[1]=f[1] *b;
		e[2]=f[2] *b;
	}

	ConchVector3.lerp=function(a,b,t,out){
		var e=out.elements;
		var f=a.elements;
		var g=b.elements;
		var ax=f[0],ay=f[1],az=f[2];
		e[0]=ax+t *(g[0]-ax);
		e[1]=ay+t *(g[1]-ay);
		e[2]=az+t *(g[2]-az);
	}

	ConchVector3.transformV3ToV3=function(vector,transform,result){
		var intermediate=ConchVector3._tempVector4;
		ConchVector3.transformV3ToV4(vector,transform,intermediate);
		var intermediateElem=intermediate.elements;
		var resultElem=result.elements;
		resultElem[0]=intermediateElem[0];
		resultElem[1]=intermediateElem[1];
		resultElem[2]=intermediateElem[2];
	}

	ConchVector3.transformV3ToV4=function(vector,transform,result){
		var vectorElem=vector.elements;
		var vectorX=vectorElem[0];
		var vectorY=vectorElem[1];
		var vectorZ=vectorElem[2];
		var transformElem=transform.elements;
		var resultElem=result.elements;
		resultElem[0]=(vectorX *transformElem[0])+(vectorY *transformElem[4])+(vectorZ *transformElem[8])+transformElem[12];
		resultElem[1]=(vectorX *transformElem[1])+(vectorY *transformElem[5])+(vectorZ *transformElem[9])+transformElem[13];
		resultElem[2]=(vectorX *transformElem[2])+(vectorY *transformElem[6])+(vectorZ *transformElem[10])+transformElem[14];
		resultElem[3]=(vectorX *transformElem[3])+(vectorY *transformElem[7])+(vectorZ *transformElem[11])+transformElem[15];
	}

	ConchVector3.TransformNormal=function(normal,transform,result){
		var normalElem=normal.elements;
		var normalX=normalElem[0];
		var normalY=normalElem[1];
		var normalZ=normalElem[2];
		var transformElem=transform.elements;
		var resultElem=result.elements;
		resultElem[0]=(normalX *transformElem[0])+(normalY *transformElem[4])+(normalZ *transformElem[8]);
		resultElem[1]=(normalX *transformElem[1])+(normalY *transformElem[5])+(normalZ *transformElem[9]);
		resultElem[2]=(normalX *transformElem[2])+(normalY *transformElem[6])+(normalZ *transformElem[10]);
	}

	ConchVector3.transformCoordinate=function(coordinate,transform,result){
		var coordinateElem=coordinate.elements;
		var coordinateX=coordinateElem[0];
		var coordinateY=coordinateElem[1];
		var coordinateZ=coordinateElem[2];
		var transformElem=transform.elements;
		var w=((coordinateX *transformElem[3])+(coordinateY *transformElem[7])+(coordinateZ *transformElem[11])+transformElem[15]);
		var resultElem=result.elements;
		resultElem[0]=(coordinateX *transformElem[0])+(coordinateY *transformElem[4])+(coordinateZ *transformElem[8])+transformElem[12] / w;
		resultElem[1]=(coordinateX *transformElem[1])+(coordinateY *transformElem[5])+(coordinateZ *transformElem[9])+transformElem[13] / w;
		resultElem[2]=(coordinateX *transformElem[2])+(coordinateY *transformElem[6])+(coordinateZ *transformElem[10])+transformElem[14] / w;
	}

	ConchVector3.Clamp=function(value,min,max,out){
		var valuee=value.elements;
		var x=valuee[0];
		var y=valuee[1];
		var z=valuee[2];
		var mine=min.elements;
		var mineX=mine[0];
		var mineY=mine[1];
		var mineZ=mine[2];
		var maxe=max.elements;
		var maxeX=maxe[0];
		var maxeY=maxe[1];
		var maxeZ=maxe[2];
		var oute=out.elements;
		x=(x > maxeX)? maxeX :x;
		x=(x < mineX)? mineX :x;
		y=(y > maxeY)? maxeY :y;
		y=(y < mineY)? mineY :y;
		z=(z > maxeZ)? maxeZ :z;
		z=(z < mineZ)? mineZ :z;
		oute[0]=x;
		oute[1]=y;
		oute[2]=z;
	}

	ConchVector3.add=function(a,b,out){
		var e=out.elements;
		var f=a.elements;
		var g=b.elements
		e[0]=f[0]+g[0];
		e[1]=f[1]+g[1];
		e[2]=f[2]+g[2];
	}

	ConchVector3.subtract=function(a,b,o){
		var oe=o.elements;
		var ae=a.elements;
		var be=b.elements;
		oe[0]=ae[0]-be[0];
		oe[1]=ae[1]-be[1];
		oe[2]=ae[2]-be[2];
	}

	ConchVector3.cross=function(a,b,o){
		var ae=a.elements;
		var be=b.elements;
		var oe=o.elements;
		var ax=ae[0],ay=ae[1],az=ae[2],bx=be[0],by=be[1],bz=be[2];
		oe[0]=ay *bz-az *by;
		oe[1]=az *bx-ax *bz;
		oe[2]=ax *by-ay *bx;
	}

	ConchVector3.dot=function(a,b){
		var ae=a.elements;
		var be=b.elements;
		var r=(ae[0] *be[0])+(ae[1] *be[1])+(ae[2] *be[2]);
		return r;
	}

	ConchVector3.equals=function(a,b){
		var ae=a.elements;
		var be=b.elements;
		return MathUtils3D.nearEqual(ae[0],be[0])&& MathUtils3D.nearEqual(ae[1],be[1])&& MathUtils3D.nearEqual(ae[2],be[2]);
	}

	ConchVector3.ZERO=new ConchVector3(0.0,0.0,0.0);
	ConchVector3.ONE=new ConchVector3(1.0,1.0,1.0);
	ConchVector3.NegativeUnitX=new ConchVector3(-1,0,0);
	ConchVector3.UnitX=new ConchVector3(1,0,0);
	ConchVector3.UnitY=new ConchVector3(0,1,0);
	ConchVector3.UnitZ=new ConchVector3(0,0,1);
	ConchVector3.ForwardRH=new ConchVector3(0,0,-1);
	ConchVector3.ForwardLH=new ConchVector3(0,0,1);
	ConchVector3.Up=new ConchVector3(0,1,0);
	ConchVector3.NAN=new ConchVector3(NaN,NaN,NaN);
	__static(ConchVector3,
	['_tempVector4',function(){return this._tempVector4=new ConchVector4();}
	]);
	return ConchVector3;
})()


/**
*<code>ColorOverLifetime</code> 类用于粒子的生命周期颜色。
*/
//class laya.d3.core.particleShuriKen.module.ColorOverLifetime
var ColorOverLifetime=(function(){
	function ColorOverLifetime(color){
		/**@private */
		this._color=null;
		/**是否启用。*/
		this.enbale=false;
		this._color=color;
	}

	__class(ColorOverLifetime,'laya.d3.core.particleShuriKen.module.ColorOverLifetime');
	var __proto=ColorOverLifetime.prototype;
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destColorOverLifetime=destObject;
		this._color.cloneTo(destColorOverLifetime._color);
		destColorOverLifetime.enbale=this.enbale;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destColor;
		switch (this._color.type){
			case 0:
				destColor=GradientColor.createByConstant(this._color.constant.clone());
				break ;
			case 1:
				destColor=GradientColor.createByGradient(this._color.gradient.clone());
				break ;
			case 2:
				destColor=GradientColor.createByRandomTwoConstant(this._color.constantMin.clone(),this._color.constantMax.clone());
				break ;
			case 3:
				destColor=GradientColor.createByRandomTwoGradient(this._color.gradientMin.clone(),this._color.gradientMax.clone());
				break ;
			};
		var destColorOverLifetime=/*__JS__ */new this.constructor(destColor);
		destColorOverLifetime.enbale=this.enbale;
		return destColorOverLifetime;
	}

	/**
	*获取颜色。
	*/
	__getset(0,__proto,'color',function(){
		return this._color;
	});

	return ColorOverLifetime;
})()


/**
*<code>BaseShape</code> 类用于粒子形状。
*/
//class laya.d3.core.particleShuriKen.module.shape.BaseShape
var BaseShape=(function(){
	function BaseShape(){
		/**是否启用。*/
		this.enable=false;
		/**随机方向。*/
		this.randomDirection=false;
	}

	__class(BaseShape,'laya.d3.core.particleShuriKen.module.shape.BaseShape');
	var __proto=BaseShape.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**@private */
	__proto._getShapeBoundBox=function(boundBox){
		throw new Error("BaseShape: must override it.");
	}

	/**@private */
	__proto._getSpeedBoundBox=function(boundBox){
		throw new Error("BaseShape: must override it.");
	}

	/**
	*用于生成粒子初始位置和方向。
	*@param position 粒子位置。
	*@param direction 粒子方向。
	*/
	__proto.generatePositionAndDirection=function(position,direction,rand,randomSeeds){
		throw new Error("BaseShape: must override it.");
	}

	/**
	*@private
	*/
	__proto._calculateProceduralBounds=function(boundBox,emitterPosScale,minMaxBounds){
		this._getShapeBoundBox(boundBox);
		var min=boundBox.min;
		var max=boundBox.max;
		Vector3.multiply(min,emitterPosScale,min);
		Vector3.multiply(max,emitterPosScale,max);
		var speedBounds=new BoundBox(new Vector3(),new Vector3());
		if (this.randomDirection){
			speedBounds.min=new Vector3(-1,-1,-1);
			speedBounds.max=new Vector3(1,1,1);
		}
		else{
			this._getSpeedBoundBox(speedBounds);
		};
		var maxSpeedBound=new BoundBox(new Vector3(),new Vector3());
		var maxSpeedMin=maxSpeedBound.min;
		var maxSpeedMax=maxSpeedBound.max;
		Vector3.scale(speedBounds.min,minMaxBounds.y,maxSpeedMin);
		Vector3.scale(speedBounds.max,minMaxBounds.y,maxSpeedMax);
		Vector3.add(boundBox.min,maxSpeedMin,maxSpeedMin);
		Vector3.add(boundBox.max,maxSpeedMax,maxSpeedMax);
		Vector3.min(boundBox.min,maxSpeedMin,boundBox.min);
		Vector3.max(boundBox.max,maxSpeedMin,boundBox.max);
		var minSpeedBound=new BoundBox(new Vector3(),new Vector3());
		var minSpeedMin=minSpeedBound.min;
		var minSpeedMax=minSpeedBound.max;
		Vector3.scale(speedBounds.min,minMaxBounds.x,minSpeedMin);
		Vector3.scale(speedBounds.max,minMaxBounds.x,minSpeedMax);
		Vector3.min(minSpeedBound.min,minSpeedMax,maxSpeedMin);
		Vector3.max(minSpeedBound.min,minSpeedMax,maxSpeedMax);
		Vector3.min(boundBox.min,maxSpeedMin,boundBox.min);
		Vector3.max(boundBox.max,maxSpeedMin,boundBox.max);
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destShape=destObject;
		destShape.enable=this.enable;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destShape=/*__JS__ */new this.constructor();
		this.cloneTo(destShape);
		return destShape;
	}

	return BaseShape;
})()


/**
*<code>ColliderShape</code> 类用于创建形状碰撞器的父类，该类为抽象类。
*/
//class laya.d3.physics.shape.ColliderShape
var ColliderShape=(function(){
	function ColliderShape(){
		/**@private */
		//this._nativeShape=null;
		/**@private */
		//this._type=0;
		/**@private */
		this._attatched=false;
		/**@private */
		this._indexInCompound=-1;
		/**@private */
		this._compoundParent=null;
		/**@private */
		this._attatchedCollisionObject=null;
		/**@private */
		this._referenceCount=0;
		this.needsCustomCollisionCallback=false;
		this._scale=new Vector3(1,1,1);
		this._centerMatrix=new Matrix4x4();
		this._localOffset=new Vector3(0,0,0);
		this._localRotation=new Quaternion(0,0,0,1);
	}

	__class(ColliderShape,'laya.d3.physics.shape.ColliderShape');
	var __proto=ColliderShape.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*@private
	*/
	__proto._setScale=function(value){
		if (this._compoundParent){
			this.updateLocalTransformations();
			}else {
			ColliderShape._nativeScale.setValue(value.x,value.y,value.z);
			this._nativeShape.setLocalScaling(ColliderShape._nativeScale);
		}
	}

	/**
	*@private
	*/
	__proto._addReference=function(){
		this._referenceCount++;
	}

	/**
	*@private
	*/
	__proto._removeReference=function(){
		this._referenceCount--;
	}

	/**
	*更新本地偏移,如果修改LocalOffset或LocalRotation需要调用。
	*/
	__proto.updateLocalTransformations=function(){
		if (this._compoundParent){
			var offset=ColliderShape._tempVector30;
			Vector3.multiply(this.localOffset,this._scale,offset);
			ColliderShape._createAffineTransformation(offset,this.localRotation,this._centerMatrix.elements);
			}else {
			ColliderShape._createAffineTransformation(this.localOffset,this.localRotation,this._centerMatrix.elements);
		}
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destColliderShape=destObject;
		this._localOffset.cloneTo(destColliderShape.localOffset);
		this._localRotation.cloneTo(destColliderShape.localRotation);
		destColliderShape.localOffset=destColliderShape.localOffset;
		destColliderShape.localRotation=destColliderShape.localRotation;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		return null;
	}

	/**
	*@private
	*/
	__proto.destroy=function(){
		if (this._nativeShape){
			Laya3D._physics3D.destroy(this._nativeShape);
			this._nativeShape=null;
		}
	}

	/**
	*获取碰撞类型。
	*@return 碰撞类型。
	*/
	__getset(0,__proto,'type',function(){
		return this._type;
	});

	/**
	*设置Shape的本地偏移。
	*@param Shape的本地偏移。
	*/
	/**
	*获取Shape的本地偏移。
	*@return Shape的本地偏移。
	*/
	__getset(0,__proto,'localOffset',function(){
		return this._localOffset;
		},function(value){
		this._localOffset=value;
		if (this._compoundParent)
			this._compoundParent._updateChildTransform(this);
	});

	/**
	*设置Shape的本地旋转。
	*@param Shape的本地旋转。
	*/
	/**
	*获取Shape的本地旋转。
	*@return Shape的本地旋转。
	*/
	__getset(0,__proto,'localRotation',function(){
		return this._localRotation;
		},function(value){
		this._localRotation=value;
		if (this._compoundParent)
			this._compoundParent._updateChildTransform(this);
	});

	ColliderShape._creatShape=function(shapeData){
		var colliderShape;
		switch (shapeData.type){
			case "BoxColliderShape":;
				var sizeData=shapeData.size;
				colliderShape=sizeData ? new BoxColliderShape(sizeData[0],sizeData[1],sizeData[2]):new BoxColliderShape();
				break ;
			case "SphereColliderShape":
				colliderShape=new SphereColliderShape(shapeData.radius);
				break ;
			case "CapsuleColliderShape":
				colliderShape=new CapsuleColliderShape(shapeData.radius,shapeData.height,shapeData.orientation);
				break ;
			case "MeshColliderShape":;
				var meshCollider=new MeshColliderShape();
				shapeData.mesh && (meshCollider.mesh=Loader.getRes(shapeData.mesh));
				colliderShape=meshCollider;
				break ;
			case "ConeColliderShape":
				colliderShape=new ConeColliderShape(shapeData.radius,shapeData.height,shapeData.orientation);
				break ;
			case "CylinderColliderShape":
				colliderShape=new CylinderColliderShape(shapeData.radius,shapeData.height,shapeData.orientation);
				break ;
			default :
				throw "unknown shape type.";
			}
		if (shapeData.center){
			var localOffset=colliderShape.localOffset;
			localOffset.fromArray(shapeData.center);
			colliderShape.localOffset=localOffset;
		}
		return colliderShape;
	}

	ColliderShape._createAffineTransformation=function(trans,rot,outE){
		var x=rot.x,y=rot.y,z=rot.z,w=rot.w,x2=x+x,y2=y+y,z2=z+z;
		var xx=x *x2,xy=x *y2,xz=x *z2,yy=y *y2,yz=y *z2,zz=z *z2;
		var wx=w *x2,wy=w *y2,wz=w *z2;
		outE[0]=(1-(yy+zz));
		outE[1]=(xy+wz);
		outE[2]=(xz-wy);
		outE[3]=0;
		outE[4]=(xy-wz);
		outE[5]=(1-(xx+zz));
		outE[6]=(yz+wx);
		outE[7]=0;
		outE[8]=(xz+wy);
		outE[9]=(yz-wx);
		outE[10]=(1-(xx+yy));
		outE[11]=0;
		outE[12]=trans.x;
		outE[13]=trans.y;
		outE[14]=trans.z;
		outE[15]=1;
	}

	ColliderShape.SHAPEORIENTATION_UPX=0;
	ColliderShape.SHAPEORIENTATION_UPY=1;
	ColliderShape.SHAPEORIENTATION_UPZ=2;
	ColliderShape.SHAPETYPES_BOX=0;
	ColliderShape.SHAPETYPES_SPHERE=1;
	ColliderShape.SHAPETYPES_CYLINDER=2;
	ColliderShape.SHAPETYPES_CAPSULE=3;
	ColliderShape.SHAPETYPES_CONVEXHULL=4;
	ColliderShape.SHAPETYPES_COMPOUND=5;
	ColliderShape.SHAPETYPES_STATICPLANE=6;
	ColliderShape.SHAPETYPES_CONE=7;
	__static(ColliderShape,
	['_tempVector30',function(){return this._tempVector30=new Vector3();},'_nativeScale',function(){return this._nativeScale=new Laya3D._physics3D.btVector3(1,1,1);},'_nativeVector30',function(){return this._nativeVector30=new Laya3D._physics3D.btVector3(0,0,0);},'_nativQuaternion0',function(){return this._nativQuaternion0=new Laya3D._physics3D.btQuaternion(0,0,0,1);},'_nativeTransform0',function(){return this._nativeTransform0=new Laya3D._physics3D.btTransform();}
	]);
	return ColliderShape;
})()


/**
*<code>Laya3D</code> 类用于初始化3D设置。
*/
//class Laya3D
var Laya3D=(function(){
	/**
	*创建一个 <code>Laya3D</code> 实例。
	*/
	function Laya3D(){}
	__class(Laya3D,'Laya3D');
	/**
	*获取是否可以启用物理。
	*@param 是否启用物理。
	*/
	__getset(1,Laya3D,'enbalePhysics',function(){
		return Laya3D._enbalePhysics;
	});

	Laya3D._cancelLoadByUrl=function(url){
		Laya.loader.cancelLoadByUrl(url);
		Laya3D._innerFirstLevelLoaderManager.cancelLoadByUrl(url);
		Laya3D._innerSecondLevelLoaderManager.cancelLoadByUrl(url);
		Laya3D._innerThirdLevelLoaderManager.cancelLoadByUrl(url);
		Laya3D._innerFourthLevelLoaderManager.cancelLoadByUrl(url);
	}

	Laya3D._changeWebGLSize=function(width,height){
		WebGL.onStageResize(width,height);
		RenderContext3D.clientWidth=width;
		RenderContext3D.clientHeight=height;
	}

	Laya3D.__init__=function(width,height,config){
		Config.isAntialias=config.isAntialias;
		Config.isAlpha=config.isAlpha;
		Config.premultipliedAlpha=config.premultipliedAlpha;
		Config.isStencil=config.isStencil;
		if (!WebGL.enable()){
			alert("Laya3D init error,must support webGL!");
			return;
		}
		RunDriver.changeWebGLSize=Laya3D._changeWebGLSize;
		Render.is3DMode=true;
		Laya.init(width,height);
		if (!Render.supportWebGLPlusRendering){
			LayaGL.instance=WebGL.mainContext;
			LayaGL.instance.createCommandEncoder=function (reserveSize,adjustSize,isSyncToRenderThread){
				(reserveSize===void 0)&& (reserveSize=128);
				(adjustSize===void 0)&& (adjustSize=64);
				(isSyncToRenderThread===void 0)&& (isSyncToRenderThread=false);
				return new CommandEncoder(this,reserveSize,adjustSize,isSyncToRenderThread);
			}
		}
		Laya3D.enableNative3D();
		Sprite3D.__init__();
		RenderableSprite3D.__init__();
		MeshSprite3D.__init__();
		SkinnedMeshSprite3D.__init__();
		ShuriKenParticle3D.__init__();
		BaseMaterial.__init__();
		BlinnPhongMaterial.__init__();
		PBRStandardMaterial.__init__();
		PBRSpecularMaterial.__init__();
		SkyProceduralMaterial.__init__();
		UnlitMaterial.__init__();
		TrailSprite3D.__init__();
		TrailMaterial.__init__();
		EffectMaterial.__init__();
		WaterPrimaryMaterial.__init__();
		ShurikenParticleMaterial.__init__();
		TerrainMaterial.__init__();
		ExtendTerrainMaterial.__init__();
		ShaderInit3D.__init__();
		PixelLineMaterial.defaultMaterial.lock=true;
		BlinnPhongMaterial.defaultMaterial.lock=true;
		EffectMaterial.defaultMaterial.lock=true;
		PBRStandardMaterial.defaultMaterial.lock=true;
		PBRSpecularMaterial.defaultMaterial.lock=true;
		UnlitMaterial.defaultMaterial.lock=true;
		ShurikenParticleMaterial.defaultMaterial.lock=true;
		TrailMaterial.defaultMaterial.lock=true;
		SkyProceduralMaterial.defaultMaterial.lock=true;
		SkyBoxMaterial.defaultMaterial.lock=true;
		WaterPrimaryMaterial.defaultMaterial.lock=true;
		Texture2D.__init__();
		TextureCube.__init__();
		SkyBox.__init__();
		SkyDome.__init__();
		ScreenQuad.__init__();
		PostProcess.__init__();
		FrustumCulling.__init__();
		HalfFloatUtils.__init__();
		var createMap=LoaderManager.createMap;
		createMap["lh"]=[ /*CLASS CONST:Laya3D.HIERARCHY*/"HIERARCHY",Sprite3D._parse];
		createMap["ls"]=[ /*CLASS CONST:Laya3D.HIERARCHY*/"HIERARCHY",Scene3D._parse];
		createMap["lm"]=[ /*CLASS CONST:Laya3D.MESH*/"MESH",Mesh._parse];
		createMap["lmat"]=[ /*CLASS CONST:Laya3D.MATERIAL*/"MATERIAL",BaseMaterial._parse];
		createMap["ltc"]=[ /*CLASS CONST:Laya3D.TEXTURECUBE*/"TEXTURECUBE",TextureCube._parse];
		createMap["jpg"]=[ /*CLASS CONST:Laya3D.TEXTURE2D*/"TEXTURE2D",Texture2D._parse];
		createMap["jpeg"]=[ /*CLASS CONST:Laya3D.TEXTURE2D*/"TEXTURE2D",Texture2D._parse];
		createMap["bmp"]=[ /*CLASS CONST:Laya3D.TEXTURE2D*/"TEXTURE2D",Texture2D._parse];
		createMap["gif"]=[ /*CLASS CONST:Laya3D.TEXTURE2D*/"TEXTURE2D",Texture2D._parse];
		createMap["png"]=[ /*CLASS CONST:Laya3D.TEXTURE2D*/"TEXTURE2D",Texture2D._parse];
		createMap["dds"]=[ /*CLASS CONST:Laya3D.TEXTURE2D*/"TEXTURE2D",Texture2D._parse];
		createMap["ktx"]=[ /*CLASS CONST:Laya3D.TEXTURE2D*/"TEXTURE2D",Texture2D._parse];
		createMap["pvr"]=[ /*CLASS CONST:Laya3D.TEXTURE2D*/"TEXTURE2D",Texture2D._parse];
		createMap["lani"]=[ /*CLASS CONST:Laya3D.ANIMATIONCLIP*/"ANIMATIONCLIP",AnimationClip._parse];
		createMap["lav"]=[ /*CLASS CONST:Laya3D.AVATAR*/"AVATAR",Avatar._parse];
		createMap["thdata"]=[ /*CLASS CONST:Laya3D.TERRAINHEIGHTDATA*/"TERRAINHEIGHTDATA",TerrainHeightData._pharse];
		var parserMap=Loader.parserMap;
		parserMap[ /*CLASS CONST:Laya3D.HIERARCHY*/"HIERARCHY"]=Laya3D._loadHierarchy;
		parserMap[ /*CLASS CONST:Laya3D.MESH*/"MESH"]=Laya3D._loadMesh;
		parserMap[ /*CLASS CONST:Laya3D.MATERIAL*/"MATERIAL"]=Laya3D._loadMaterial;
		parserMap[ /*CLASS CONST:Laya3D.TEXTURECUBE*/"TEXTURECUBE"]=Laya3D._loadTextureCube;
		parserMap[ /*CLASS CONST:Laya3D.TEXTURE2D*/"TEXTURE2D"]=Laya3D._loadTexture2D;
		parserMap[ /*CLASS CONST:Laya3D.ANIMATIONCLIP*/"ANIMATIONCLIP"]=Laya3D._loadAnimationClip;
		parserMap[ /*CLASS CONST:Laya3D.AVATAR*/"AVATAR"]=Laya3D._loadAvatar;
		Laya3D._innerFirstLevelLoaderManager.on(/*laya.events.Event.ERROR*/"error",null,Laya3D._eventLoadManagerError);
		Laya3D._innerSecondLevelLoaderManager.on(/*laya.events.Event.ERROR*/"error",null,Laya3D._eventLoadManagerError);
		Laya3D._innerThirdLevelLoaderManager.on(/*laya.events.Event.ERROR*/"error",null,Laya3D._eventLoadManagerError);
		Laya3D._innerFourthLevelLoaderManager.on(/*laya.events.Event.ERROR*/"error",null,Laya3D._eventLoadManagerError);
	}

	Laya3D.enableNative3D=function(){
		if (Render.isConchApp){
			/*__JS__ */LayaGL=window.LayaGLContext;
			var shaderData=ShaderData;
			var shader3D=ShaderInstance;
			var skinnedMeshRender=SkinnedMeshRenderer;
			var avatar=Avatar;
			var frustumCulling=FrustumCulling;
			var meshRender=MeshRenderer;
			if (Render.supportWebGLPlusRendering){
				shaderData.prototype._initData=shaderData.prototype._initDataForNative;
				shaderData.prototype.setBool=shaderData.prototype.setBoolForNative;
				shaderData.prototype.getBool=shaderData.prototype.getBoolForNative;
				shaderData.prototype.setInt=shaderData.prototype.setIntForNative;
				shaderData.prototype.getInt=shaderData.prototype.getIntForNative;
				shaderData.prototype.setNumber=shaderData.prototype.setNumberForNative;
				shaderData.prototype.getNumber=shaderData.prototype.getNumberForNative;
				shaderData.prototype.setVector=shaderData.prototype.setVectorForNative;
				shaderData.prototype.getVector=shaderData.prototype.getVectorForNative;
				shaderData.prototype.setVector2=shaderData.prototype.setVector2ForNative;
				shaderData.prototype.getVector2=shaderData.prototype.getVector2ForNative;
				shaderData.prototype.setVector3=shaderData.prototype.setVector3ForNative;
				shaderData.prototype.getVector3=shaderData.prototype.getVector3ForNative;
				shaderData.prototype.setQuaternion=shaderData.prototype.setQuaternionForNative;
				shaderData.prototype.getQuaternion=shaderData.prototype.getQuaternionForNative;
				shaderData.prototype.setMatrix4x4=shaderData.prototype.setMatrix4x4ForNative;
				shaderData.prototype.getMatrix4x4=shaderData.prototype.getMatrix4x4ForNative;
				shaderData.prototype.setBuffer=shaderData.prototype.setBufferForNative;
				shaderData.prototype.getBuffer=shaderData.prototype.getBufferForNative;
				shaderData.prototype.setTexture=shaderData.prototype.setTextureForNative;
				shaderData.prototype.getTexture=shaderData.prototype.getTextureForNative;
				shaderData.prototype.setAttribute=shaderData.prototype.setAttributeForNative;
				shaderData.prototype.getAttribute=shaderData.prototype.getAttributeForNative;
				shaderData.prototype.cloneTo=shaderData.prototype.cloneToForNative;
				shaderData.prototype.getData=shaderData.prototype.getDataForNative;
				shader3D.prototype._uniformMatrix2fv=shader3D.prototype._uniformMatrix2fvForNative;
				shader3D.prototype._uniformMatrix3fv=shader3D.prototype._uniformMatrix3fvForNative;
				shader3D.prototype._uniformMatrix4fv=shader3D.prototype._uniformMatrix4fvForNative;
				meshRender.prototype._renderUpdateWithCamera=meshRender.prototype._renderUpdateWithCameraForNative;
			}
			if (Render.supportWebGLPlusCulling){
				frustumCulling.renderObjectCulling=FrustumCulling.renderObjectCullingNative;
			}
			if (Render.supportWebGLPlusAnimation){
				avatar.prototype._cloneDatasToAnimator=avatar.prototype._cloneDatasToAnimatorNative;
				/*__JS__ */FloatKeyframe=window.conchFloatKeyframe;
				/*__JS__ */Vector3Keyframe=window.conchFloatArrayKeyframe;
				/*__JS__ */QuaternionKeyframe=window.conchFloatArrayKeyframe;
				/*__JS__ */KeyframeNode=window.conchKeyframeNode;
				/*__JS__ */KeyframeNodeList=window.conchKeyframeNodeList;
				var animationClip=AnimationClip;
				animationClip.prototype._evaluateClipDatasRealTime=animationClip.prototype._evaluateClipDatasRealTimeForNative;
			}
		}
		WebGL.shaderHighPrecision=false;
		var precisionFormat=LayaGL.instance.getShaderPrecisionFormat(/*laya.webgl.WebGLContext.FRAGMENT_SHADER*/0x8B30,/*laya.webgl.WebGLContext.HIGH_FLOAT*/0x8DF2);
		precisionFormat.precision ? WebGL.shaderHighPrecision=true :WebGL.shaderHighPrecision=false;
	}

	Laya3D.formatRelativePath=function(base,value){
		var path;
		path=base+value;
		var char1=value.charAt(0);
		if (char1==="."){
			var parts=path.split("/");
			for (var i=0,len=parts.length;i < len;i++){
				if (parts[i]=='..'){
					var index=i-1;
					if (index > 0 && parts[index]!=='..'){
						parts.splice(index,2);
						i-=2;
					}
				}
			}
			path=parts.join('/');
		}
		return path;
	}

	Laya3D._endLoad=function(loader,content,subResous){
		if (subResous){
			for (var i=0,n=subResous.length;i < n;i++){
				var resou=Loader.getRes(subResous[i]);
				(resou)&& (resou._removeReference());
			}
		}
		loader.endLoad(content);
	}

	Laya3D._eventLoadManagerError=function(msg){
		Laya.loader.event(/*laya.events.Event.ERROR*/"error",msg);
	}

	Laya3D._addHierarchyInnerUrls=function(urls,urlMap,urlVersion,hierarchyBasePath,path,type,constructParams,propertyParams){
		var formatUrl=Laya3D.formatRelativePath(hierarchyBasePath,path);
		(urlVersion)&& (formatUrl=formatUrl+urlVersion);
		urls.push({url:formatUrl,type:type,constructParams:constructParams,propertyParams:propertyParams});
		urlMap.push(formatUrl);
		return formatUrl;
	}

	Laya3D._getSprite3DHierarchyInnerUrls=function(node,firstLevelUrls,secondLevelUrls,thirdLevelUrls,fourthLelUrls,subUrls,urlVersion,hierarchyBasePath){
		var i=0,n=0;
		var props=node.props;
		switch (node.type){
			case "Scene3D":;
				var lightmaps=props.lightmaps;
				for (i=0,n=lightmaps.length;i < n;i++){
					var lightMap=lightmaps[i];
					lightMap.path=Laya3D._addHierarchyInnerUrls(fourthLelUrls,subUrls,urlVersion,hierarchyBasePath,lightMap.path,/*CLASS CONST:Laya3D.TEXTURE2D*/"TEXTURE2D",lightMap.constructParams,lightMap.propertyParams);
				};
				var reflectionTextureData=props.reflectionTexture;
				(reflectionTextureData)&& (props.reflectionTexture=Laya3D._addHierarchyInnerUrls(thirdLevelUrls,subUrls,urlVersion,hierarchyBasePath,reflectionTextureData,/*CLASS CONST:Laya3D.TEXTURECUBE*/"TEXTURECUBE"));
				if (props.sky){
					var skyboxMaterial=props.sky.material;
					(skyboxMaterial)&& (skyboxMaterial.path=Laya3D._addHierarchyInnerUrls(secondLevelUrls,subUrls,urlVersion,hierarchyBasePath,skyboxMaterial.path,/*CLASS CONST:Laya3D.MATERIAL*/"MATERIAL"));
				}
				break ;
			case "Camera":;
				var skyboxMatData=props.skyboxMaterial;
				(skyboxMatData)&& (skyboxMatData.path=Laya3D._addHierarchyInnerUrls(secondLevelUrls,subUrls,urlVersion,hierarchyBasePath,skyboxMatData.path,/*CLASS CONST:Laya3D.MATERIAL*/"MATERIAL"));
				break ;
			case "TrailSprite3D":
			case "MeshSprite3D":
			case "SkinnedMeshSprite3D":;
				var meshPath=props.meshPath;
				(meshPath)&& (props.meshPath=Laya3D._addHierarchyInnerUrls(firstLevelUrls,subUrls,urlVersion,hierarchyBasePath,meshPath,/*CLASS CONST:Laya3D.MESH*/"MESH"));
				var materials=props.materials;
				if (materials)
					for (i=0,n=materials.length;i < n;i++)
				materials[i].path=Laya3D._addHierarchyInnerUrls(secondLevelUrls,subUrls,urlVersion,hierarchyBasePath,materials[i].path,/*CLASS CONST:Laya3D.MATERIAL*/"MATERIAL");
				break ;
			case "ShuriKenParticle3D":;
				var parMeshPath=props.meshPath;
				(parMeshPath)&& (props.meshPath=Laya3D._addHierarchyInnerUrls(firstLevelUrls,subUrls,urlVersion,hierarchyBasePath,parMeshPath,/*CLASS CONST:Laya3D.MESH*/"MESH"));
				props.material.path=Laya3D._addHierarchyInnerUrls(secondLevelUrls,subUrls,urlVersion,hierarchyBasePath,props.material.path,/*CLASS CONST:Laya3D.MATERIAL*/"MATERIAL");
				break ;
			case "Terrain":
				Laya3D._addHierarchyInnerUrls(fourthLelUrls,subUrls,urlVersion,hierarchyBasePath,props.dataPath,"TERRAIN");
				break ;
			};
		var components=node.components;
		if (components){
			for (var k=0,p=components.length;k < p;k++){
				var component=components[k];
				switch (component.type){
					case "Animator":;
						var avatarPath=component.avatarPath;
						var avatarData=component.avatar;
						(avatarData)&& (avatarData.path=Laya3D._addHierarchyInnerUrls(fourthLelUrls,subUrls,urlVersion,hierarchyBasePath,avatarData.path,"AVATAR"));
						var clipPaths=component.clipPaths;
						if (!clipPaths){
							var layersData=component.layers;
							for (i=0;i < layersData.length;i++){
								var states=layersData[i].states;
								for (var j=0,m=states.length;j < m;j++){
									var clipPath=states[j].clipPath;
									(clipPath)&& (states[j].clipPath=Laya3D._addHierarchyInnerUrls(fourthLelUrls,subUrls,urlVersion,hierarchyBasePath,clipPath,"ANIMATIONCLIP"));
								}
							}
							}else {
							for (i=0,n=clipPaths.length;i < n;i++)
							clipPaths[i]=Laya3D._addHierarchyInnerUrls(fourthLelUrls,subUrls,urlVersion,hierarchyBasePath,clipPaths[i],"ANIMATIONCLIP");
						}
						break ;
					case "PhysicsCollider":
					case "Rigidbody3D":
					case "CharacterController":;
						var shapes=component.shapes;
						for (i=0;i < shapes.length;i++){
							var shape=shapes[i];
							if (shape.type==="MeshColliderShape"){
								var mesh=shape.mesh;
								(mesh)&& (shape.mesh=Laya3D._addHierarchyInnerUrls(firstLevelUrls,subUrls,urlVersion,hierarchyBasePath,mesh,/*CLASS CONST:Laya3D.MESH*/"MESH"));
							}
						}
						break ;
					}
			}
		};
		var children=node.child;
		for (i=0,n=children.length;i < n;i++)
		Laya3D._getSprite3DHierarchyInnerUrls(children[i],firstLevelUrls,secondLevelUrls,thirdLevelUrls,fourthLelUrls,subUrls,urlVersion,hierarchyBasePath);
	}

	Laya3D._loadHierarchy=function(loader){
		loader.on(/*laya.events.Event.LOADED*/"loaded",null,Laya3D._onHierarchylhLoaded,[loader]);
		loader.load(loader.url,/*laya.net.Loader.JSON*/"json",false,null,true);
	}

	Laya3D._onHierarchylhLoaded=function(loader,lhData){
		var url=loader.url;
		var urlVersion=Utils3D.getURLVerion(url);
		var hierarchyBasePath=URL.getPath(url);
		var firstLevUrls=[];
		var secondLevUrls=[];
		var thirdLevUrls=[];
		var forthLevUrls=[];
		var subUrls=[];
		Laya3D._getSprite3DHierarchyInnerUrls(lhData.data,firstLevUrls,secondLevUrls,thirdLevUrls,forthLevUrls,subUrls,urlVersion,hierarchyBasePath);
		var urlCount=firstLevUrls.length+secondLevUrls.length+forthLevUrls.length;
		var totalProcessCount=urlCount+1;
		var weight=1 / totalProcessCount;
		Laya3D._onProcessChange(loader,0,weight,1.0);
		if (forthLevUrls.length > 0){
			var processCeil=urlCount / totalProcessCount;
			var processHandler=Handler.create(null,Laya3D._onProcessChange,[loader,weight,processCeil],false);
			Laya3D._innerFourthLevelLoaderManager._create(forthLevUrls,false,Handler.create(null,Laya3D._onHierarchyInnerForthLevResouLoaded,[loader,processHandler,lhData,subUrls,firstLevUrls,secondLevUrls,thirdLevUrls,weight+processCeil *forthLevUrls.length,processCeil]),processHandler,null,null,null,1,true);
			}else {
			Laya3D._onHierarchyInnerForthLevResouLoaded(loader,null,lhData,subUrls,firstLevUrls,secondLevUrls,thirdLevUrls,weight,processCeil);
		}
	}

	Laya3D._onHierarchyInnerForthLevResouLoaded=function(loader,processHandler,lhData,subUrls,firstLevUrls,secondLevUrls,thirdLevUrls,processOffset,processCeil){
		(processHandler)&& (processHandler.recover());
		if (thirdLevUrls.length > 0){
			var process=Handler.create(null,Laya3D._onProcessChange,[loader,processOffset,processCeil],false);
			Laya3D._innerThirdLevelLoaderManager._create(thirdLevUrls,false,Handler.create(null,Laya3D._onHierarchyInnerThirdLevResouLoaded,[loader,process,lhData,subUrls,firstLevUrls,secondLevUrls,processOffset+processCeil *secondLevUrls.length,processCeil]),processHandler,null,null,null,1,true);
			}else {
			Laya3D._onHierarchyInnerThirdLevResouLoaded(loader,null,lhData,subUrls,firstLevUrls,secondLevUrls,processOffset,processCeil);
		}
	}

	Laya3D._onHierarchyInnerThirdLevResouLoaded=function(loader,processHandler,lhData,subUrls,firstLevUrls,secondLevUrls,processOffset,processCeil){
		(processHandler)&& (processHandler.recover());
		if (secondLevUrls.length > 0){
			var process=Handler.create(null,Laya3D._onProcessChange,[loader,processOffset,processCeil],false);
			Laya3D._innerSecondLevelLoaderManager._create(secondLevUrls,false,Handler.create(null,Laya3D._onHierarchyInnerSecondLevResouLoaded,[loader,process,lhData,subUrls,firstLevUrls,processOffset+processCeil *secondLevUrls.length,processCeil]),processHandler,null,null,null,1,true);
			}else {
			Laya3D._onHierarchyInnerSecondLevResouLoaded(loader,null,lhData,subUrls,firstLevUrls,processOffset,processCeil);
		}
	}

	Laya3D._onHierarchyInnerSecondLevResouLoaded=function(loader,processHandler,lhData,subUrls,firstLevUrls,processOffset,processCeil){
		(processHandler)&& (processHandler.recover());
		if (firstLevUrls.length > 0){
			var process=Handler.create(null,Laya3D._onProcessChange,[loader,processOffset,processCeil],false);
			Laya3D._innerFirstLevelLoaderManager._create(firstLevUrls,false,Handler.create(null,Laya3D._onHierarchyInnerFirstLevResouLoaded,[loader,process,lhData,subUrls]),processHandler,null,null,null,1,true);
			}else {
			Laya3D._onHierarchyInnerFirstLevResouLoaded(loader,null,lhData,subUrls);
		}
	}

	Laya3D._onHierarchyInnerFirstLevResouLoaded=function(loader,processHandler,lhData,subUrls){
		(processHandler)&& (processHandler.recover());
		loader._cache=loader._createCache;
		var item=lhData.data.type==="Scene3D" ? Scene3D._parse(lhData,loader._propertyParams,loader._constructParams):Sprite3D._parse(lhData,loader._propertyParams,loader._constructParams);
		Laya3D._endLoad(loader,item,subUrls);
	}

	Laya3D._loadMesh=function(loader){
		loader.on(/*laya.events.Event.LOADED*/"loaded",null,Laya3D._onMeshLmLoaded,[loader]);
		loader.load(loader.url,/*laya.net.Loader.BUFFER*/"arraybuffer",false,null,true);
	}

	Laya3D._onMeshLmLoaded=function(loader,lmData){
		loader._cache=loader._createCache;
		var mesh=Mesh._parse(lmData,loader._propertyParams,loader._constructParams);
		Laya3D._endLoad(loader,mesh);
	}

	Laya3D._loadMaterial=function(loader){
		loader.on(/*laya.events.Event.LOADED*/"loaded",null,Laya3D._onMaterilLmatLoaded,[loader]);
		loader.load(loader.url,/*laya.net.Loader.JSON*/"json",false,null,true);
	}

	Laya3D._onMaterilLmatLoaded=function(loader,lmatData){
		var url=loader.url;
		var urlVersion=Utils3D.getURLVerion(url);
		var materialBasePath=URL.getPath(url);
		var urls=[];
		var subUrls=[];
		var customProps=lmatData.customProps;
		var formatSubUrl;
		var version=lmatData.version;
		switch (version){
			case "LAYAMATERIAL:01":
			case "LAYAMATERIAL:02":;
				var i=0,n=0;
				var textures=lmatData.props.textures;
				if (textures){
					for (i=0,n=textures.length;i < n;i++){
						var tex2D=textures[i];
						var tex2DPath=tex2D.path;
						if (tex2DPath){
							formatSubUrl=Laya3D.formatRelativePath(materialBasePath,tex2DPath);
							(urlVersion)&& (formatSubUrl=formatSubUrl+urlVersion);
							urls.push({url:formatSubUrl,constructParams:tex2D.constructParams,propertyParams:tex2D.propertyParams});
							subUrls.push(formatSubUrl);
							tex2D.path=formatSubUrl;
						}
					}
				}
				break ;
			default :
				throw new Error("Laya3D:unkonwn version.");
			};
		var urlCount=urls.length;
		var totalProcessCount=urlCount+1;
		var lmatWeight=1 / totalProcessCount;
		Laya3D._onProcessChange(loader,0,lmatWeight,1.0);
		if (urlCount > 0){
			var processHandler=Handler.create(null,Laya3D._onProcessChange,[loader,lmatWeight,urlCount / totalProcessCount],false);
			Laya3D._innerFourthLevelLoaderManager._create(urls,false,Handler.create(null,Laya3D._onMateialTexturesLoaded,[loader,processHandler,lmatData,subUrls]),processHandler,null,null,null,1,true);
			}else {
			Laya3D._onMateialTexturesLoaded(loader,null,lmatData,null);
		}
	}

	Laya3D._onMateialTexturesLoaded=function(loader,processHandler,lmatData,subUrls){
		loader._cache=loader._createCache;
		var mat=BaseMaterial._parse(lmatData,loader._propertyParams,loader._constructParams);
		Laya3D._endLoad(loader,mat,subUrls);
		(processHandler)&& (processHandler.recover());
	}

	Laya3D._loadAvatar=function(loader){
		loader.on(/*laya.events.Event.LOADED*/"loaded",null,function(data){
			loader._cache=loader._createCache;
			var avatar=Avatar._parse(data,loader._propertyParams,loader._constructParams);
			Laya3D._endLoad(loader,avatar);
		});
		loader.load(loader.url,/*laya.net.Loader.JSON*/"json",false,null,true);
	}

	Laya3D._loadAnimationClip=function(loader){
		loader.on(/*laya.events.Event.LOADED*/"loaded",null,function(data){
			loader._cache=loader._createCache;
			var clip=AnimationClip._parse(data,loader._propertyParams,loader._constructParams);
			Laya3D._endLoad(loader,clip);
		});
		loader.load(loader.url,/*laya.net.Loader.BUFFER*/"arraybuffer",false,null,true);
	}

	Laya3D._loadTexture2D=function(loader){
		var url=loader.url;
		var index=url.lastIndexOf('.')+1;
		var verIndex=url.indexOf('?');
		var endIndex=verIndex==-1 ? url.length :verIndex;
		var ext=url.substr(index,endIndex-index);
		var type;
		switch (ext){
			case "jpg":
			case "jpeg":
			case "bmp":
			case "gif":
			case "png":
				type="nativeimage";
				break ;
			case "dds":
			case "ktx":
			case "pvr":
				type=/*laya.net.Loader.BUFFER*/"arraybuffer";
				break ;
			}
		loader.on(/*laya.events.Event.LOADED*/"loaded",null,function(image){
			loader._cache=loader._createCache;
			var tex=Texture2D._parse(image,loader._propertyParams,loader._constructParams);
			Laya3D._endLoad(loader,tex);
		});
		loader.load(loader.url,type,false,null,true);
	}

	Laya3D._loadTextureCube=function(loader){
		loader.on(/*laya.events.Event.LOADED*/"loaded",null,Laya3D._onTextureCubeLtcLoaded,[loader]);
		loader.load(loader.url,/*laya.net.Loader.JSON*/"json",false,null,true);
	}

	Laya3D._onTextureCubeLtcLoaded=function(loader,ltcData){
		var ltcBasePath=URL.getPath(loader.url);
		var urls=[Laya3D.formatRelativePath(ltcBasePath,ltcData.front),Laya3D.formatRelativePath(ltcBasePath,ltcData.back),Laya3D.formatRelativePath(ltcBasePath,ltcData.left),Laya3D.formatRelativePath(ltcBasePath,ltcData.right),Laya3D.formatRelativePath(ltcBasePath,ltcData.up),Laya3D.formatRelativePath(ltcBasePath,ltcData.down)];
		var ltcWeight=1.0 / 7.0;
		Laya3D._onProcessChange(loader,0,ltcWeight,1.0);
		var processHandler=Handler.create(null,Laya3D._onProcessChange,[loader,ltcWeight,6 / 7],false);
		Laya3D._innerFourthLevelLoaderManager.load(urls,Handler.create(null,Laya3D._onTextureCubeImagesLoaded,[loader,urls,processHandler]),processHandler,"nativeimage");
	}

	Laya3D._onTextureCubeImagesLoaded=function(loader,urls,processHandler){
		var images=new Array(6);
		for (var i=0;i < 6;i++)
		images[i]=Loader.getRes(urls[i]);
		loader._cache=loader._createCache;
		var tex=TextureCube._parse(images,loader._propertyParams,loader._constructParams);
		processHandler.recover();
		for (i=0;i < 6;i++)
		Loader.clearRes(urls[i]);
		Laya3D._endLoad(loader,tex);
	}

	Laya3D._onProcessChange=function(loader,offset,weight,process){
		process=offset+process *weight;
		(process < 1.0)&& (loader.event(/*laya.events.Event.PROGRESS*/"progress",process));
	}

	Laya3D.init=function(width,height,config,compolete){
		if (Laya3D._isInit)
			return;
		Laya3D._isInit=true;
		config=config || Config3D._default;
		config.cloneTo(Laya3D._config);
		Laya3D._editerEnvironment=Laya3D._config._editerEnvironment;
		var physics3D=window.Physics3D;
		if (physics3D==null){
			Laya3D._enbalePhysics=false;
			Laya3D.__init__(width,height,Laya3D._config);
			compolete && compolete.run();
			}else {
			Laya3D._enbalePhysics=true;
			physics3D(Laya3D._config.defaultPhysicsMemory *1024 *1024).then(function(){
				Laya3D.__init__(width,height,Laya3D._config);
				compolete && compolete.run();
			});
		}
	}

	Laya3D.HIERARCHY="HIERARCHY";
	Laya3D.MESH="MESH";
	Laya3D.MATERIAL="MATERIAL";
	Laya3D.TEXTURE2D="TEXTURE2D";
	Laya3D.TEXTURECUBE="TEXTURECUBE";
	Laya3D.ANIMATIONCLIP="ANIMATIONCLIP";
	Laya3D.AVATAR="AVATAR";
	Laya3D.TERRAINHEIGHTDATA="TERRAINHEIGHTDATA";
	Laya3D.TERRAINRES="TERRAIN";
	Laya3D._isInit=false;
	Laya3D._enbalePhysics=false;
	Laya3D._editerEnvironment=false;
	__static(Laya3D,
	['_innerFirstLevelLoaderManager',function(){return this._innerFirstLevelLoaderManager=new LoaderManager();},'_innerSecondLevelLoaderManager',function(){return this._innerSecondLevelLoaderManager=new LoaderManager();},'_innerThirdLevelLoaderManager',function(){return this._innerThirdLevelLoaderManager=new LoaderManager();},'_innerFourthLevelLoaderManager',function(){return this._innerFourthLevelLoaderManager=new LoaderManager();},'_physics3D',function(){return this._physics3D=window.Physics3D;},'_config',function(){return this._config=new Config3D();},'physicsSettings',function(){return this.physicsSettings=new PhysicsSettings();}
	]);
	return Laya3D;
})()


/**
*<code>FrameOverTime</code> 类用于创建时间帧。
*/
//class laya.d3.core.particleShuriKen.module.FrameOverTime
var FrameOverTime=(function(){
	function FrameOverTime(){
		/**@private */
		this._type=0;
		/**@private */
		this._constant=0;
		/**@private */
		this._overTime=null;
		/**@private */
		this._constantMin=0;
		/**@private */
		this._constantMax=0;
		/**@private */
		this._overTimeMin=null;
		/**@private */
		this._overTimeMax=null;
	}

	__class(FrameOverTime,'laya.d3.core.particleShuriKen.module.FrameOverTime');
	var __proto=FrameOverTime.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destFrameOverTime=destObject;
		destFrameOverTime._type=this._type;
		destFrameOverTime._constant=this._constant;
		this._overTime.cloneTo(destFrameOverTime._overTime);
		destFrameOverTime._constantMin=this._constantMin;
		destFrameOverTime._constantMax=this._constantMax;
		this._overTimeMin.cloneTo(destFrameOverTime._overTimeMin);
		this._overTimeMax.cloneTo(destFrameOverTime._overTimeMax);
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destFrameOverTime=/*__JS__ */new this.constructor();
		this.cloneTo(destFrameOverTime);
		return destFrameOverTime;
	}

	/**
	*时间帧。
	*/
	__getset(0,__proto,'frameOverTimeData',function(){
		return this._overTime;
	});

	/**
	*固定帧。
	*/
	__getset(0,__proto,'constant',function(){
		return this._constant;
	});

	/**
	*生命周期旋转类型,0常量模式，1曲线模式，2随机双常量模式，3随机双曲线模式。
	*/
	__getset(0,__proto,'type',function(){
		return this._type;
	});

	/**
	*最小时间帧。
	*/
	__getset(0,__proto,'frameOverTimeDataMin',function(){
		return this._overTimeMin;
	});

	/**
	*最小固定帧。
	*/
	__getset(0,__proto,'constantMin',function(){
		return this._constantMin;
	});

	/**
	*最大时间帧。
	*/
	__getset(0,__proto,'frameOverTimeDataMax',function(){
		return this._overTimeMax;
	});

	/**
	*最大固定帧。
	*/
	__getset(0,__proto,'constantMax',function(){
		return this._constantMax;
	});

	FrameOverTime.createByConstant=function(constant){
		var rotationOverLifetime=new FrameOverTime();
		rotationOverLifetime._type=0;
		rotationOverLifetime._constant=constant;
		return rotationOverLifetime;
	}

	FrameOverTime.createByOverTime=function(overTime){
		var rotationOverLifetime=new FrameOverTime();
		rotationOverLifetime._type=1;
		rotationOverLifetime._overTime=overTime;
		return rotationOverLifetime;
	}

	FrameOverTime.createByRandomTwoConstant=function(constantMin,constantMax){
		var rotationOverLifetime=new FrameOverTime();
		rotationOverLifetime._type=2;
		rotationOverLifetime._constantMin=constantMin;
		rotationOverLifetime._constantMax=constantMax;
		return rotationOverLifetime;
	}

	FrameOverTime.createByRandomTwoOverTime=function(gradientFrameMin,gradientFrameMax){
		var rotationOverLifetime=new FrameOverTime();
		rotationOverLifetime._type=3;
		rotationOverLifetime._overTimeMin=gradientFrameMin;
		rotationOverLifetime._overTimeMax=gradientFrameMax;
		return rotationOverLifetime;
	}

	return FrameOverTime;
})()


/**
*<code>RenderState</code> 类用于控制渲染状态。
*/
//class laya.d3.core.material.RenderState
var RenderState=(function(){
	function RenderState(){
		/**渲染剔除状态。*/
		this.cull=0;
		/**透明混合。*/
		this.blend=0;
		/**源混合参数,在blend为BLEND_ENABLE_ALL时生效。*/
		this.srcBlend=0;
		/**目标混合参数,在blend为BLEND_ENABLE_ALL时生效。*/
		this.dstBlend=0;
		/**RGB源混合参数,在blend为BLEND_ENABLE_SEPERATE时生效。*/
		this.srcBlendRGB=0;
		/**RGB目标混合参数,在blend为BLEND_ENABLE_SEPERATE时生效。*/
		this.dstBlendRGB=0;
		/**Alpha源混合参数,在blend为BLEND_ENABLE_SEPERATE时生效。*/
		this.srcBlendAlpha=0;
		/**Alpha目标混合参数,在blend为BLEND_ENABLE_SEPERATE时生效。*/
		this.dstBlendAlpha=0;
		/**混合常量颜色。*/
		this.blendConstColor=null;
		/**混合方程。*/
		this.blendEquation=0;
		/**RGB混合方程。*/
		this.blendEquationRGB=0;
		/**Alpha混合方程。*/
		this.blendEquationAlpha=0;
		/**深度测试函数。*/
		this.depthTest=0;
		/**是否深度写入。*/
		this.depthWrite=false;
		this.cull=2;
		this.blend=0;
		this.srcBlend=1;
		this.dstBlend=0;
		this.srcBlendRGB=1;
		this.dstBlendRGB=0;
		this.srcBlendAlpha=1;
		this.dstBlendAlpha=0;
		this.blendConstColor=new Vector4(1,1,1,1);
		this.blendEquation=0;
		this.blendEquationRGB=0;
		this.blendEquationAlpha=0;
		this.depthTest=0x0203;
		this.depthWrite=true;
	}

	__class(RenderState,'laya.d3.core.material.RenderState');
	var __proto=RenderState.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(dest){
		var destState=dest;
		destState.cull=this.cull;
		destState.blend=this.blend;
		destState.srcBlend=this.srcBlend;
		destState.dstBlend=this.dstBlend;
		destState.srcBlendRGB=this.srcBlendRGB;
		destState.dstBlendRGB=this.dstBlendRGB;
		destState.srcBlendAlpha=this.srcBlendAlpha;
		destState.dstBlendAlpha=this.dstBlendAlpha;
		this.blendConstColor.cloneTo(destState.blendConstColor);
		destState.blendEquation=this.blendEquation;
		destState.blendEquationRGB=this.blendEquationRGB;
		destState.blendEquationAlpha=this.blendEquationAlpha;
		destState.depthTest=this.depthTest;
		destState.depthWrite=this.depthWrite;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var dest=/*__JS__ */new this.constructor();
		this.cloneTo(dest);
		return dest;
	}

	RenderState.CULL_NONE=0;
	RenderState.CULL_FRONT=1;
	RenderState.CULL_BACK=2;
	RenderState.BLEND_DISABLE=0;
	RenderState.BLEND_ENABLE_ALL=1;
	RenderState.BLEND_ENABLE_SEPERATE=2;
	RenderState.BLENDPARAM_ZERO=0;
	RenderState.BLENDPARAM_ONE=1;
	RenderState.BLENDPARAM_SRC_COLOR=0x0300;
	RenderState.BLENDPARAM_ONE_MINUS_SRC_COLOR=0x0301;
	RenderState.BLENDPARAM_DST_COLOR=0x0306;
	RenderState.BLENDPARAM_ONE_MINUS_DST_COLOR=0x0307;
	RenderState.BLENDPARAM_SRC_ALPHA=0x0302;
	RenderState.BLENDPARAM_ONE_MINUS_SRC_ALPHA=0x0303;
	RenderState.BLENDPARAM_DST_ALPHA=0x0304;
	RenderState.BLENDPARAM_ONE_MINUS_DST_ALPHA=0x0305;
	RenderState.BLENDPARAM_SRC_ALPHA_SATURATE=0x0308;
	RenderState.BLENDEQUATION_ADD=0;
	RenderState.BLENDEQUATION_SUBTRACT=1;
	RenderState.BLENDEQUATION_REVERSE_SUBTRACT=2;
	RenderState.DEPTHTEST_OFF=0;
	RenderState.DEPTHTEST_NEVER=0x0200;
	RenderState.DEPTHTEST_LESS=0x0201;
	RenderState.DEPTHTEST_EQUAL=0x0202;
	RenderState.DEPTHTEST_LEQUAL=0x0203;
	RenderState.DEPTHTEST_GREATER=0x0204;
	RenderState.DEPTHTEST_NOTEQUAL=0x0205;
	RenderState.DEPTHTEST_GEQUAL=0x0206;
	RenderState.DEPTHTEST_ALWAYS=0x0207;
	return RenderState;
})()


/**
*<code>Ray</code> 类用于创建射线。
*/
//class laya.d3.math.Ray
var Ray=(function(){
	function Ray(origin,direction){
		/**原点*/
		this.origin=null;
		/**方向*/
		this.direction=null;
		this.origin=origin;
		this.direction=direction;
	}

	__class(Ray,'laya.d3.math.Ray');
	return Ray;
})()


/**
*<code>ContactPoint</code> 类用于创建物理碰撞信息。
*/
//class laya.d3.physics.ContactPoint
var ContactPoint=(function(){
	function ContactPoint(){
		/**@private */
		this._idCounter=0;
		/**@private */
		//this._id=0;
		/**碰撞器A。*/
		this.colliderA=null;
		/**碰撞器B。*/
		this.colliderB=null;
		/**距离。*/
		this.distance=0;
		this.normal=new Vector3();
		this.positionOnA=new Vector3();
		this.positionOnB=new Vector3();
		this._id=++this._idCounter;
	}

	__class(ContactPoint,'laya.d3.physics.ContactPoint');
	return ContactPoint;
})()


/**
*<code>StaticBatchManager</code> 类用于静态批处理管理的父类。
*/
//class laya.d3.graphics.StaticBatchManager
var StaticBatchManager=(function(){
	function StaticBatchManager(){
		/**@private */
		//this._batchRenderElementPool=null;
		/**@private */
		//this._batchRenderElementPoolIndex=0;
		/**@private */
		//this._initBatchSprites=null;
		/**@private */
		//this._staticBatches=null;
		this._initBatchSprites=[];
		this._staticBatches={};
		this._batchRenderElementPoolIndex=0;
		this._batchRenderElementPool=[];
	}

	__class(StaticBatchManager,'laya.d3.graphics.StaticBatchManager');
	var __proto=StaticBatchManager.prototype;
	/**
	*@private
	*/
	__proto._partition=function(items,left,right){
		var pivot=items[Math.floor((right+left)/ 2)];
		while (left <=right){
			while (this._compare(items[left],pivot)< 0)
			left++;
			while (this._compare(items[right],pivot)> 0)
			right--;
			if (left < right){
				var temp=items[left];
				items[left]=items[right];
				items[right]=temp;
				left++;
				right--;
				}else if (left===right){
				left++;
				break ;
			}
		}
		return left;
	}

	/**
	*@private
	*/
	__proto._quickSort=function(items,left,right){
		if (items.length > 1){
			var index=this._partition(items,left,right);
			var leftIndex=index-1;
			if (left < leftIndex)
				this._quickSort(items,left,leftIndex);
			if (index < right)
				this._quickSort(items,index,right);
		}
	}

	/**
	*@private
	*/
	__proto._compare=function(left,right){
		throw "StaticBatch:must override this function.";
	}

	/**
	*@private
	*/
	__proto._initStaticBatchs=function(rootSprite){
		throw "StaticBatch:must override this function.";
	}

	/**
	*@private
	*/
	__proto._getBatchRenderElementFromPool=function(){
		throw "StaticBatch:must override this function.";
	}

	/**
	*@private
	*/
	__proto._addBatchSprite=function(renderableSprite3D){
		this._initBatchSprites.push(renderableSprite3D);
	}

	/**
	*@private
	*/
	__proto._clear=function(){
		this._batchRenderElementPoolIndex=0;
	}

	/**
	*@private
	*/
	__proto._garbageCollection=function(){
		throw "StaticBatchManager: must override it.";
	}

	/**
	*@private
	*/
	__proto.dispose=function(){
		this._staticBatches=null;
	}

	StaticBatchManager._registerManager=function(manager){
		StaticBatchManager._managers.push(manager);
	}

	StaticBatchManager._addToStaticBatchQueue=function(sprite3D,renderableSprite3D){
		if ((sprite3D instanceof laya.d3.core.RenderableSprite3D )&& sprite3D.isStatic)
			renderableSprite3D.push(sprite3D);
		for (var i=0,n=sprite3D.numChildren;i < n;i++)
		StaticBatchManager._addToStaticBatchQueue(sprite3D._children [i],renderableSprite3D);
	}

	StaticBatchManager.combine=function(staticBatchRoot,renderableSprite3Ds){
		if (!renderableSprite3Ds){
			renderableSprite3Ds=[];
			if (staticBatchRoot)
				StaticBatchManager._addToStaticBatchQueue(staticBatchRoot,renderableSprite3Ds);
		};
		var batchSpritesCount=renderableSprite3Ds.length;
		if (batchSpritesCount > 0){
			for (var i=0;i < batchSpritesCount;i++){
				var renderableSprite3D=renderableSprite3Ds[i];
				(renderableSprite3D.isStatic)&& (renderableSprite3D._addToInitStaticBatchManager());
			}
			for (var k=0,m=StaticBatchManager._managers.length;k < m;k++){
				var manager=StaticBatchManager._managers[k];
				manager._initStaticBatchs(staticBatchRoot);
			}
		}
	}

	StaticBatchManager._managers=[];
	return StaticBatchManager;
})()


/**
*@private
*<code>Command</code> 类用于创建指令。
*/
//class laya.d3.core.render.command.Command
var Command=(function(){
	/**
	*创建一个 <code>Command</code> 实例。
	*/
	function Command(){}
	__class(Command,'laya.d3.core.render.command.Command');
	var __proto=Command.prototype;
	/**
	*@private
	*/
	__proto.run=function(){}
	/**
	*@private
	*/
	__proto.recover=function(){}
	return Command;
})()


/**
*<code>RenderContext3D</code> 类用于实现渲染状态。
*/
//class laya.d3.core.render.RenderContext3D
var RenderContext3D=(function(){
	function RenderContext3D(){
		/**@private */
		//this._batchIndexStart=0;
		/**@private */
		//this._batchIndexEnd=0;
		/**@private */
		//this.viewMatrix=null;
		/**@private */
		//this.projectionMatrix=null;
		/**@private */
		//this.projectionViewMatrix=null;
		/**@private */
		//this.viewport=null;
		/**@private */
		//this.scene=null;
		/**@private */
		//this.camera=null;
		/**@private */
		//this.renderElement=null;
		/**@private */
		//this.shader=null;
	}

	__class(RenderContext3D,'laya.d3.core.render.RenderContext3D');
	RenderContext3D.clientWidth=0;
	RenderContext3D.clientHeight=0;
	__static(RenderContext3D,
	['_instance',function(){return this._instance=new RenderContext3D();}
	]);
	return RenderContext3D;
})()


/**
*...
*@author ...
*/
//class laya.d3.core.GradientMode
var GradientMode=(function(){
	function GradientMode(){}
	__class(GradientMode,'laya.d3.core.GradientMode');
	GradientMode.Blend=0;
	GradientMode.Fixed=1;
	return GradientMode;
})()


/**
*<code>SingletonList</code> 类用于实现单例队列。
*/
//class laya.d3.component.SingletonList
var SingletonList=(function(){
	function SingletonList(){
		/**@private [只读]*/
		this.length=0;
		this.elements=[];
	}

	__class(SingletonList,'laya.d3.component.SingletonList');
	var __proto=SingletonList.prototype;
	/**
	*@private
	*/
	__proto._add=function(element){
		if (this.length===this.elements.length)
			this.elements.push(element);
		else
		this.elements[this.length]=element;
	}

	return SingletonList;
})()


/**
*@private
*<code>DynamicBatchManager</code> 类用于管理动态批处理。
*/
//class laya.d3.graphics.DynamicBatchManager
var DynamicBatchManager=(function(){
	function DynamicBatchManager(){
		/**@private */
		//this._batchRenderElementPool=null;
		/**@private */
		//this._batchRenderElementPoolIndex=0;
		this._batchRenderElementPool=[];
	}

	__class(DynamicBatchManager,'laya.d3.graphics.DynamicBatchManager');
	var __proto=DynamicBatchManager.prototype;
	/**
	*@private
	*/
	__proto._clear=function(){
		this._batchRenderElementPoolIndex=0;
	}

	/**
	*@private
	*/
	__proto._getBatchRenderElementFromPool=function(){
		throw "StaticBatch:must override this function.";
	}

	/**
	*@private
	*/
	__proto.dispose=function(){}
	DynamicBatchManager._registerManager=function(manager){
		DynamicBatchManager._managers.push(manager);
	}

	DynamicBatchManager._managers=[];
	return DynamicBatchManager;
})()


/**
*<code>Point2PointConstraint</code> 类用于创建物理组件的父类。
*/
//class laya.d3.physics.constraints.Point2PointConstraint
var Point2PointConstraint=(function(){
	function Point2PointConstraint(){
		/**@private */
		this._damping=NaN;
		/**@private */
		this._impulseClamp=NaN;
		/**@private */
		this._tau=NaN;
		this._pivotInA=new Vector3();
		this._pivotInB=new Vector3();
	}

	__class(Point2PointConstraint,'laya.d3.physics.constraints.Point2PointConstraint');
	var __proto=Point2PointConstraint.prototype;
	__getset(0,__proto,'pivotInA',function(){
		return this._pivotInA;
		},function(value){
		this._pivotInA=value;
	});

	__getset(0,__proto,'pivotInB',function(){
		return this._pivotInB;
		},function(value){
		this._pivotInB=value;
	});

	__getset(0,__proto,'damping',function(){
		return this._damping;
		},function(value){
		this._damping=value;
	});

	__getset(0,__proto,'impulseClamp',function(){
		return this._impulseClamp;
		},function(value){
		this._impulseClamp=value;
	});

	__getset(0,__proto,'tau',function(){
		return this._tau;
		},function(value){
		this._tau=value;
	});

	return Point2PointConstraint;
})()


/**
*@private
*<code>GeometryElement</code> 类用于实现几何体元素,该类为抽象类。
*/
//class laya.d3.core.GeometryElement
var GeometryElement=(function(){
	function GeometryElement(){
		/**@private */
		//this._destroyed=false;
		this._destroyed=false;
	}

	__class(GeometryElement,'laya.d3.core.GeometryElement');
	var __proto=GeometryElement.prototype;
	Laya.imps(__proto,{"laya.resource.IDestroy":true})
	/**
	*获取几何体类型。
	*/
	__proto._getType=function(){
		throw "GeometryElement:must override it.";
	}

	/**
	*@private
	*@return 是否需要渲染。
	*/
	__proto._prepareRender=function(state){
		return true;
	}

	/**
	*@private
	*/
	__proto._render=function(state){
		throw "GeometryElement:must override it.";
	}

	/**
	*销毁。
	*/
	__proto.destroy=function(){
		if (this._destroyed)
			return;
		this._destroyed=true;
	}

	/**
	*获取是否销毁。
	*@return 是否销毁。
	*/
	__getset(0,__proto,'destroyed',function(){
		return this._destroyed;
	});

	GeometryElement._typeCounter=0;
	return GeometryElement;
})()


/**
*<code>VertexPositionNormalTexture</code> 类用于创建位置、纹理顶点结构。
*/
//class laya.d3.graphics.Vertex.VertexPositionTexture0
var VertexPositionTexture0=(function(){
	function VertexPositionTexture0(position,textureCoordinate0){
		this._position=null;
		this._textureCoordinate0=null;
		this._position=position;
		this._textureCoordinate0=textureCoordinate0;
	}

	__class(VertexPositionTexture0,'laya.d3.graphics.Vertex.VertexPositionTexture0');
	var __proto=VertexPositionTexture0.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'textureCoordinate0',function(){
		return this._textureCoordinate0;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionTexture0._vertexDeclaration;
	});

	__getset(1,VertexPositionTexture0,'vertexDeclaration',function(){
		return VertexPositionTexture0._vertexDeclaration;
	});

	__static(VertexPositionTexture0,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(20,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.Vertex.VertexMesh.MESH_POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*laya.d3.graphics.Vertex.VertexMesh.MESH_TEXTURECOORDINATE0*/2)]);}
	]);
	return VertexPositionTexture0;
})()


/**
*<code>MathUtils</code> 类用于创建数学工具。
*/
//class laya.d3.math.MathUtils3D
var MathUtils3D=(function(){
	/**
	*创建一个 <code>MathUtils</code> 实例。
	*/
	function MathUtils3D(){}
	__class(MathUtils3D,'laya.d3.math.MathUtils3D');
	MathUtils3D.isZero=function(v){
		return Math.abs(v)< MathUtils3D.zeroTolerance;
	}

	MathUtils3D.nearEqual=function(n1,n2){
		if (MathUtils3D.isZero(n1-n2))
			return true;
		return false;
	}

	MathUtils3D.fastInvSqrt=function(value){
		if (MathUtils3D.isZero(value))
			return value;
		return 1.0 / Math.sqrt(value);
	}

	__static(MathUtils3D,
	['zeroTolerance',function(){return this.zeroTolerance=1e-6;},'MaxValue',function(){return this.MaxValue=3.40282347e+38;},'MinValue',function(){return this.MinValue=-3.40282347e+38;}
	]);
	return MathUtils3D;
})()


/**
*<code>GradientColor</code> 类用于创建渐变颜色。
*/
//class laya.d3.core.particleShuriKen.module.GradientColor
var GradientColor=(function(){
	function GradientColor(){
		/**@private */
		this._type=0;
		/**@private */
		this._constant=null;
		/**@private */
		this._constantMin=null;
		/**@private */
		this._constantMax=null;
		/**@private */
		this._gradient=null;
		/**@private */
		this._gradientMin=null;
		/**@private */
		this._gradientMax=null;
	}

	__class(GradientColor,'laya.d3.core.particleShuriKen.module.GradientColor');
	var __proto=GradientColor.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destGradientColor=destObject;
		destGradientColor._type=this._type;
		this._constant.cloneTo(destGradientColor._constant);
		this._constantMin.cloneTo(destGradientColor._constantMin);
		this._constantMax.cloneTo(destGradientColor._constantMax);
		this._gradient.cloneTo(destGradientColor._gradient);
		this._gradientMin.cloneTo(destGradientColor._gradientMin);
		this._gradientMax.cloneTo(destGradientColor._gradientMax);
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destGradientColor=/*__JS__ */new this.constructor();
		this.cloneTo(destGradientColor);
		return destGradientColor;
	}

	/**
	*渐变颜色。
	*/
	__getset(0,__proto,'gradient',function(){
		return this._gradient;
	});

	/**
	*固定颜色。
	*/
	__getset(0,__proto,'constant',function(){
		return this._constant;
	});

	/**
	*生命周期颜色类型,0为固定颜色模式,1渐变模式,2为随机双固定颜色模式,3随机双渐变模式。
	*/
	__getset(0,__proto,'type',function(){
		return this._type;
	});

	/**
	*最小渐变颜色。
	*/
	__getset(0,__proto,'gradientMin',function(){
		return this._gradientMin;
	});

	/**
	*最小固定颜色。
	*/
	__getset(0,__proto,'constantMin',function(){
		return this._constantMin;
	});

	/**
	*最大渐变颜色。
	*/
	__getset(0,__proto,'gradientMax',function(){
		return this._gradientMax;
	});

	/**
	*最大固定颜色。
	*/
	__getset(0,__proto,'constantMax',function(){
		return this._constantMax;
	});

	GradientColor.createByConstant=function(constant){
		var gradientColor=new GradientColor();
		gradientColor._type=0;
		gradientColor._constant=constant;
		return gradientColor;
	}

	GradientColor.createByGradient=function(gradient){
		var gradientColor=new GradientColor();
		gradientColor._type=1;
		gradientColor._gradient=gradient;
		return gradientColor;
	}

	GradientColor.createByRandomTwoConstant=function(minConstant,maxConstant){
		var gradientColor=new GradientColor();
		gradientColor._type=2;
		gradientColor._constantMin=minConstant;
		gradientColor._constantMax=maxConstant;
		return gradientColor;
	}

	GradientColor.createByRandomTwoGradient=function(minGradient,maxGradient){
		var gradientColor=new GradientColor();
		gradientColor._type=3;
		gradientColor._gradientMin=minGradient;
		gradientColor._gradientMax=maxGradient;
		return gradientColor;
	}

	return GradientColor;
})()


//class laya.d3.utils.Size
var Size=(function(){
	function Size(width,height){
		this._width=0;
		this._height=0;
		this._width=width;
		this._height=height;
	}

	__class(Size,'laya.d3.utils.Size');
	var __proto=Size.prototype;
	__getset(0,__proto,'width',function(){
		if (this._width===-1)
			return RenderContext3D.clientWidth;
		return this._width;
	});

	__getset(0,__proto,'height',function(){
		if (this._height===-1)
			return RenderContext3D.clientHeight;
		return this._height;
	});

	__getset(1,Size,'fullScreen',function(){
		return new Size(-1,-1);
	});

	return Size;
})()


/**
*<code>PhysicsSettings</code> 类用于创建物理配置信息。
*/
//class laya.d3.physics.PhysicsSettings
var PhysicsSettings=(function(){
	function PhysicsSettings(){
		/**标志集合。*/
		this.flags=0;
		/**物理引擎在一帧中用于补偿减速的最大次数。*/
		this.maxSubSteps=1;
		/**物理模拟器帧的间隔时间。*/
		this.fixedTimeStep=1.0 / 60.0;
	}

	__class(PhysicsSettings,'laya.d3.physics.PhysicsSettings');
	return PhysicsSettings;
})()


/**
*<code>Plane</code> 类用于创建平面。
*/
//class laya.d3.math.Plane
var Plane=(function(){
	function Plane(normal,d){
		/**平面的向量*/
		this.normal=null;
		/**平面到坐标系原点的距离*/
		this.distance=NaN;
		(d===void 0)&& (d=0);
		this.normal=normal;
		this.distance=d;
	}

	__class(Plane,'laya.d3.math.Plane');
	var __proto=Plane.prototype;
	/**
	*更改平面法线向量的系数，使之成单位长度。
	*/
	__proto.normalize=function(){
		var normalEX=this.normal.x;
		var normalEY=this.normal.y;
		var normalEZ=this.normal.z;
		var magnitude=1 / Math.sqrt(normalEX *normalEX+normalEY *normalEY+normalEZ *normalEZ);
		this.normal.x=normalEX *magnitude;
		this.normal.y=normalEY *magnitude;
		this.normal.z=normalEZ *magnitude;
		this.distance *=magnitude;
	}

	Plane.createPlaneBy3P=function(point1,point2,point3){
		var x1=point2.x-point1.x;
		var y1=point2.y-point1.y;
		var z1=point2.z-point1.z;
		var x2=point3.x-point1.x;
		var y2=point3.y-point1.y;
		var z2=point3.z-point1.z;
		var yz=(y1 *z2)-(z1 *y2);
		var xz=(z1 *x2)-(x1 *z2);
		var xy=(x1 *y2)-(y1 *x2);
		var invPyth=1 / (Math.sqrt((yz *yz)+(xz *xz)+(xy *xy)));
		var x=yz *invPyth;
		var y=xz *invPyth;
		var z=xy *invPyth;
		Plane._TEMPVec3.x=x;
		Plane._TEMPVec3.y=y;
		Plane._TEMPVec3.z=z;
		var d=-((x *point1.x)+(y *point1.y)+(z *point1.z));
		var plane=new Plane(Plane._TEMPVec3,d);
		return plane;
	}

	Plane.PlaneIntersectionType_Back=0;
	Plane.PlaneIntersectionType_Front=1;
	Plane.PlaneIntersectionType_Intersecting=2;
	__static(Plane,
	['_TEMPVec3',function(){return this._TEMPVec3=new Vector3();}
	]);
	return Plane;
})()


/**
*<code>MaterialInfo</code> 类用于描述地形材质信息。
*/
//class laya.d3.terrain.unit.MaterialInfo
var MaterialInfo=(function(){
	function MaterialInfo(){
		this.ambientColor=null;
		this.diffuseColor=null;
		this.specularColor=null;
	}

	__class(MaterialInfo,'laya.d3.terrain.unit.MaterialInfo');
	return MaterialInfo;
})()


/**
*<code>Gradient</code> 类用于创建颜色渐变。
*/
//class laya.d3.core.Gradient
var Gradient=(function(){
	function Gradient(maxColorRGBKeyCount,maxColorAlphaKeyCount){
		/**@private */
		this._mode=0;
		/**@private */
		this._maxColorRGBKeysCount=0;
		/**@private */
		this._maxColorAlphaKeysCount=0;
		/**@private */
		this._colorRGBKeysCount=0;
		/**@private */
		this._colorAlphaKeysCount=0;
		/**@private */
		this._alphaElements=null;
		/**@private */
		this._rgbElements=null;
		this._maxColorRGBKeysCount=maxColorRGBKeyCount;
		this._maxColorAlphaKeysCount=maxColorAlphaKeyCount;
		this._rgbElements=new Float32Array(maxColorRGBKeyCount *4);
		this._alphaElements=new Float32Array(maxColorAlphaKeyCount *2);
	}

	__class(Gradient,'laya.d3.core.Gradient');
	var __proto=Gradient.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*增加颜色RGB帧。
	*@param key 生命周期，范围为0到1。
	*@param value RGB值。
	*/
	__proto.addColorRGB=function(key,value){
		if (this._colorRGBKeysCount < this._maxColorRGBKeysCount){
			var offset=this._colorRGBKeysCount *4;
			this._rgbElements[offset]=key;
			this._rgbElements[offset+1]=value.r;
			this._rgbElements[offset+2]=value.g;
			this._rgbElements[offset+3]=value.b;
			this._colorRGBKeysCount++;
			}else {
			console.warn("Gradient:warning:data count must lessEqual than "+this._maxColorRGBKeysCount);
		}
	}

	/**
	*增加颜色Alpha帧。
	*@param key 生命周期，范围为0到1。
	*@param value Alpha值。
	*/
	__proto.addColorAlpha=function(key,value){
		if (this._colorAlphaKeysCount < this._maxColorAlphaKeysCount){
			var offset=this._colorAlphaKeysCount *2;
			this._alphaElements[offset]=key;
			this._alphaElements[offset+1]=value;
			this._colorAlphaKeysCount++;
			}else {
			console.warn("Gradient:warning:data count must lessEqual than "+this._maxColorAlphaKeysCount);
		}
	}

	/**
	*更新颜色RGB帧。
	*@param index 索引。
	*@param key 生命周期，范围为0到1。
	*@param value RGB值。
	*/
	__proto.updateColorRGB=function(index,key,value){
		if (index < this._colorRGBKeysCount){
			var offset=index *4;
			this._rgbElements[offset]=key;
			this._rgbElements[offset+1]=value.r;
			this._rgbElements[offset+2]=value.g;
			this._rgbElements[offset+3]=value.b;
			}else {
			console.warn("Gradient:warning:index must lessEqual than colorRGBKeysCount:"+this._colorRGBKeysCount);
		}
	}

	/**
	*更新颜色Alpha帧。
	*@param index 索引。
	*@param key 生命周期，范围为0到1。
	*@param value Alpha值。
	*/
	__proto.updateColorAlpha=function(index,key,value){
		if (index < this._colorAlphaKeysCount){
			var offset=index *2;
			this._alphaElements[offset]=key;
			this._alphaElements[offset+1]=value;
			}else {
			console.warn("Gradient:warning:index must lessEqual than colorAlphaKeysCount:"+this._colorAlphaKeysCount);
		}
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destGradientDataColor=destObject;
		var i=0,n=0;
		destGradientDataColor._colorAlphaKeysCount=this._colorAlphaKeysCount;
		var destAlphaElements=destGradientDataColor._alphaElements;
		destAlphaElements.length=this._alphaElements.length;
		for (i=0,n=this._alphaElements.length;i < n;i++)
		destAlphaElements[i]=this._alphaElements[i];
		destGradientDataColor._colorRGBKeysCount=this._colorRGBKeysCount;
		var destRGBElements=destGradientDataColor._rgbElements;
		destRGBElements.length=this._rgbElements.length;
		for (i=0,n=this._rgbElements.length;i < n;i++)
		destRGBElements[i]=this._rgbElements[i];
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destGradientDataColor=new Gradient(this._maxColorRGBKeysCount,this._maxColorAlphaKeysCount);
		this.cloneTo(destGradientDataColor);
		return destGradientDataColor;
	}

	/**
	*获取颜色RGB数量。
	*@return 颜色RGB数量。
	*/
	__getset(0,__proto,'colorRGBKeysCount',function(){
		return this._colorRGBKeysCount / 4;
	});

	/**
	*设置梯度模式。
	*@param value 梯度模式。
	*/
	/**
	*获取梯度模式。
	*@return 梯度模式。
	*/
	__getset(0,__proto,'mode',function(){
		return this._mode;
		},function(value){
		this._mode=value;
	});

	/**
	*获取颜色Alpha数量。
	*@return 颜色Alpha数量。
	*/
	__getset(0,__proto,'colorAlphaKeysCount',function(){
		return this._colorAlphaKeysCount / 2;
	});

	/**
	*获取最大颜色RGB帧数量。
	*@return 最大RGB帧数量。
	*/
	__getset(0,__proto,'maxColorRGBKeysCount',function(){
		return this._maxColorRGBKeysCount;
	});

	/**
	*获取最大颜色Alpha帧数量。
	*@return 最大Alpha帧数量。
	*/
	__getset(0,__proto,'maxColorAlphaKeysCount',function(){
		return this._maxColorAlphaKeysCount;
	});

	return Gradient;
})()


/**
*<code>Quaternion</code> 类用于创建四元数。
*/
//class laya.d3.math.Quaternion
var Quaternion=(function(){
	function Quaternion(x,y,z,w,nativeElements){
		/**X轴坐标*/
		//this.x=NaN;
		/**Y轴坐标*/
		//this.y=NaN;
		/**Z轴坐标*/
		//this.z=NaN;
		/**W轴坐标*/
		//this.w=NaN;
		(x===void 0)&& (x=0);
		(y===void 0)&& (y=0);
		(z===void 0)&& (z=0);
		(w===void 0)&& (w=1);
		this.x=x;
		this.y=y;
		this.z=z;
		this.w=w;
	}

	__class(Quaternion,'laya.d3.math.Quaternion');
	var __proto=Quaternion.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*根据缩放值缩放四元数
	*@param scale 缩放值
	*@param out 输出四元数
	*/
	__proto.scaling=function(scaling,out){
		out.x=this.x *scaling;
		out.y=this.y *scaling;
		out.z=this.z *scaling;
		out.w=this.w *scaling;
	}

	/**
	*归一化四元数
	*@param out 输出四元数
	*/
	__proto.normalize=function(out){
		var len=this.x *this.x+this.y *this.y+this.z *this.z+this.w *this.w;
		if (len > 0){
			len=1 / Math.sqrt(len);
			out.x=this.x *len;
			out.y=this.y *len;
			out.z=this.z *len;
			out.w=this.w *len;
		}
	}

	/**
	*计算四元数的长度
	*@return 长度
	*/
	__proto.length=function(){
		return Math.sqrt(this.x *this.x+this.y *this.y+this.z *this.z+this.w *this.w);
	}

	/**
	*根据绕X轴的角度旋转四元数
	*@param rad 角度
	*@param out 输出四元数
	*/
	__proto.rotateX=function(rad,out){
		rad *=0.5;
		var bx=Math.sin(rad),bw=Math.cos(rad);
		out.x=this.x *bw+this.w *bx;
		out.y=this.y *bw+this.z *bx;
		out.z=this.z *bw-this.y *bx;
		out.w=this.w *bw-this.x *bx;
	}

	/**
	*根据绕Y轴的制定角度旋转四元数
	*@param rad 角度
	*@param out 输出四元数
	*/
	__proto.rotateY=function(rad,out){
		rad *=0.5;
		var by=Math.sin(rad),bw=Math.cos(rad);
		out.x=this.x *bw-this.z *by;
		out.y=this.y *bw+this.w *by;
		out.z=this.z *bw+this.x *by;
		out.w=this.w *bw-this.y *by;
	}

	/**
	*根据绕Z轴的制定角度旋转四元数
	*@param rad 角度
	*@param out 输出四元数
	*/
	__proto.rotateZ=function(rad,out){
		rad *=0.5;
		var bz=Math.sin(rad),bw=Math.cos(rad);
		out.x=this.x *bw+this.y *bz;
		out.y=this.y *bw-this.x *bz;
		out.z=this.z *bw+this.w *bz;
		out.w=this.w *bw-this.z *bz;
	}

	/**
	*分解四元数到欧拉角（顺序为Yaw、Pitch、Roll），参考自http://xboxforums.create.msdn.com/forums/p/4574/23988.aspx#23988,问题绕X轴翻转超过±90度时有，会产生瞬间反转
	*@param quaternion 源四元数
	*@param out 欧拉角值
	*/
	__proto.getYawPitchRoll=function(out){
		Vector3.transformQuat(Vector3._ForwardRH,this,Quaternion.TEMPVector31);
		Vector3.transformQuat(Vector3._Up,this,Quaternion.TEMPVector32);
		var upe=Quaternion.TEMPVector32;
		Quaternion.angleTo(Vector3._ZERO,Quaternion.TEMPVector31,Quaternion.TEMPVector33);
		var angle=Quaternion.TEMPVector33;
		if (angle.x==Math.PI / 2){
			angle.y=Quaternion.arcTanAngle(upe.z,upe.x);
			angle.z=0;
			}else if (angle.x==-Math.PI / 2){
			angle.y=Quaternion.arcTanAngle(-upe.z,-upe.x);
			angle.z=0;
			}else {
			Matrix4x4.createRotationY(-angle.y,Quaternion.TEMPMatrix0);
			Matrix4x4.createRotationX(-angle.x,Quaternion.TEMPMatrix1);
			Vector3.transformCoordinate(Quaternion.TEMPVector32,Quaternion.TEMPMatrix0,Quaternion.TEMPVector32);
			Vector3.transformCoordinate(Quaternion.TEMPVector32,Quaternion.TEMPMatrix1,Quaternion.TEMPVector32);
			angle.z=Quaternion.arcTanAngle(upe.y,-upe.x);
		}
		if (angle.y <=-Math.PI)
			angle.y=Math.PI;
		if (angle.z <=-Math.PI)
			angle.z=Math.PI;
		if (angle.y >=Math.PI && angle.z >=Math.PI){
			angle.y=0;
			angle.z=0;
			angle.x=Math.PI-angle.x;
		};
		var oe=out;
		oe.x=angle.y;
		oe.y=angle.x;
		oe.z=angle.z;
	}

	/**
	*求四元数的逆
	*@param out 输出四元数
	*/
	__proto.invert=function(out){
		var a0=this.x,a1=this.y,a2=this.z,a3=this.w;
		var dot=a0 *a0+a1 *a1+a2 *a2+a3 *a3;
		var invDot=dot ? 1.0 / dot :0;
		out.x=-a0 *invDot;
		out.y=-a1 *invDot;
		out.z=-a2 *invDot;
		out.w=a3 *invDot;
	}

	/**
	*设置四元数为单位算数
	*@param out 输出四元数
	*/
	__proto.identity=function(){
		this.x=0;
		this.y=0;
		this.z=0;
		this.w=1;
	}

	/**
	*从Array数组拷贝值。
	*@param array 数组。
	*@param offset 数组偏移。
	*/
	__proto.fromArray=function(array,offset){
		(offset===void 0)&& (offset=0);
		this.x=array[offset+0];
		this.y=array[offset+1];
		this.z=array[offset+2];
		this.w=array[offset+3];
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		if (this===destObject){
			return;
		}
		destObject.x=this.x;
		destObject.y=this.y;
		destObject.z=this.z;
		destObject.w=this.w;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var dest=/*__JS__ */new this.constructor();
		this.cloneTo(dest);
		return dest;
	}

	__proto.equals=function(b){
		return MathUtils3D.nearEqual(this.x,b.x)&& MathUtils3D.nearEqual(this.y,b.y)&& MathUtils3D.nearEqual(this.z,b.z)&& MathUtils3D.nearEqual(this.w,b.w);
	}

	/**
	*计算长度的平方。
	*@return 长度的平方。
	*/
	__proto.lengthSquared=function(){
		return (this.x *this.x)+(this.y *this.y)+(this.z *this.z)+(this.w *this.w);
	}

	__proto.forNativeElement=function(nativeElements){
		if (nativeElements){
			/*__JS__ */this.elements=nativeElements;
			/*__JS__ */this.elements[0]=this.x;
			/*__JS__ */this.elements[1]=this.y;
			/*__JS__ */this.elements[2]=this.z;
			/*__JS__ */this.elements[3]=this.w;
		}
		else{
			/*__JS__ */this.elements=new Float32Array([this.x,this.y,this.z,this.w]);
		}
		Vector2.rewriteNumProperty(this,"x",0);
		Vector2.rewriteNumProperty(this,"y",1);
		Vector2.rewriteNumProperty(this,"z",2);
		Vector2.rewriteNumProperty(this,"w",3);
	}

	Quaternion.createFromYawPitchRoll=function(yaw,pitch,roll,out){
		var halfRoll=roll *0.5;
		var halfPitch=pitch *0.5;
		var halfYaw=yaw *0.5;
		var sinRoll=Math.sin(halfRoll);
		var cosRoll=Math.cos(halfRoll);
		var sinPitch=Math.sin(halfPitch);
		var cosPitch=Math.cos(halfPitch);
		var sinYaw=Math.sin(halfYaw);
		var cosYaw=Math.cos(halfYaw);
		out.x=(cosYaw *sinPitch *cosRoll)+(sinYaw *cosPitch *sinRoll);
		out.y=(sinYaw *cosPitch *cosRoll)-(cosYaw *sinPitch *sinRoll);
		out.z=(cosYaw *cosPitch *sinRoll)-(sinYaw *sinPitch *cosRoll);
		out.w=(cosYaw *cosPitch *cosRoll)+(sinYaw *sinPitch *sinRoll);
	}

	Quaternion.multiply=function(left,right,out){
		var lx=left.x;
		var ly=left.y;
		var lz=left.z;
		var lw=left.w;
		var rx=right.x;
		var ry=right.y;
		var rz=right.z;
		var rw=right.w;
		var a=(ly *rz-lz *ry);
		var b=(lz *rx-lx *rz);
		var c=(lx *ry-ly *rx);
		var d=(lx *rx+ly *ry+lz *rz);
		out.x=(lx *rw+rx *lw)+a;
		out.y=(ly *rw+ry *lw)+b;
		out.z=(lz *rw+rz *lw)+c;
		out.w=lw *rw-d;
	}

	Quaternion.arcTanAngle=function(x,y){
		if (x==0){
			if (y==1)
				return Math.PI / 2;
			return-Math.PI / 2;
		}
		if (x > 0)
			return Math.atan(y / x);
		if (x < 0){
			if (y > 0)
				return Math.atan(y / x)+Math.PI;
			return Math.atan(y / x)-Math.PI;
		}
		return 0;
	}

	Quaternion.angleTo=function(from,location,angle){
		Vector3.subtract(location,from,Quaternion.TEMPVector30);
		Vector3.normalize(Quaternion.TEMPVector30,Quaternion.TEMPVector30);
		angle.x=Math.asin(Quaternion.TEMPVector30.y);
		angle.y=Quaternion.arcTanAngle(-Quaternion.TEMPVector30.z,-Quaternion.TEMPVector30.x);
	}

	Quaternion.createFromAxisAngle=function(axis,rad,out){
		rad=rad *0.5;
		var s=Math.sin(rad);
		out.x=s *axis.x;
		out.y=s *axis.y;
		out.z=s *axis.z;
		out.w=Math.cos(rad);
	}

	Quaternion.createFromMatrix4x4=function(mat,out){
		var me=mat.elements;
		var sqrt;
		var half;
		var scale=me[0]+me[5]+me[10];
		if (scale > 0.0){
			sqrt=Math.sqrt(scale+1.0);
			out.w=sqrt *0.5;
			sqrt=0.5 / sqrt;
			out.x=(me[6]-me[9])*sqrt;
			out.y=(me[8]-me[2])*sqrt;
			out.z=(me[1]-me[4])*sqrt;
			}else if ((me[0] >=me[5])&& (me[0] >=me[10])){
			sqrt=Math.sqrt(1.0+me[0]-me[5]-me[10]);
			half=0.5 / sqrt;
			out.x=0.5 *sqrt;
			out.y=(me[1]+me[4])*half;
			out.z=(me[2]+me[8])*half;
			out.w=(me[6]-me[9])*half;
			}else if (me[5] > me[10]){
			sqrt=Math.sqrt(1.0+me[5]-me[0]-me[10]);
			half=0.5 / sqrt;
			out.x=(me[4]+me[1])*half;
			out.y=0.5 *sqrt;
			out.z=(me[9]+me[6])*half;
			out.w=(me[8]-me[2])*half;
			}else {
			sqrt=Math.sqrt(1.0+me[10]-me[0]-me[5]);
			half=0.5 / sqrt;
			out.x=(me[8]+me[2])*half;
			out.y=(me[9]+me[6])*half;
			out.z=0.5 *sqrt;
			out.w=(me[1]-me[4])*half;
		}
	}

	Quaternion.slerp=function(left,right,t,out){
		var ax=left.x,ay=left.y,az=left.z,aw=left.w,bx=right.x,by=right.y,bz=right.z,bw=right.w;
		var omega,cosom,sinom,scale0,scale1;
		cosom=ax *bx+ay *by+az *bz+aw *bw;
		if (cosom < 0.0){
			cosom=-cosom;
			bx=-bx;
			by=-by;
			bz=-bz;
			bw=-bw;
		}
		if ((1.0-cosom)> 0.000001){
			omega=Math.acos(cosom);
			sinom=Math.sin(omega);
			scale0=Math.sin((1.0-t)*omega)/ sinom;
			scale1=Math.sin(t *omega)/ sinom;
			}else {
			scale0=1.0-t;
			scale1=t;
		}
		out.x=scale0 *ax+scale1 *bx;
		out.y=scale0 *ay+scale1 *by;
		out.z=scale0 *az+scale1 *bz;
		out.w=scale0 *aw+scale1 *bw;
		return out;
	}

	Quaternion.lerp=function(left,right,amount,out){
		var inverse=1.0-amount;
		if (Quaternion.dot(left,right)>=0){
			out.x=(inverse *left.x)+(amount *right.x);
			out.y=(inverse *left.y)+(amount *right.y);
			out.z=(inverse *left.z)+(amount *right.z);
			out.w=(inverse *left.w)+(amount *right.w);
			}else {
			out.x=(inverse *left.x)-(amount *right.x);
			out.y=(inverse *left.y)-(amount *right.y);
			out.z=(inverse *left.z)-(amount *right.z);
			out.w=(inverse *left.w)-(amount *right.w);
		}
		out.normalize(out);
	}

	Quaternion.add=function(left,right,out){
		out.x=left.x+right.x;
		out.y=left.y+right.y;
		out.z=left.z+right.z;
		out.w=left.w+right.w;
	}

	Quaternion.dot=function(left,right){
		return left.x *right.x+left.y *right.y+left.z *right.z+left.w *right.w;
	}

	Quaternion.rotationLookAt=function(forward,up,out){
		Quaternion.lookAt(Vector3._ZERO,forward,up,out);
	}

	Quaternion.lookAt=function(eye,target,up,out){
		Matrix3x3.lookAt(eye,target,up,Quaternion._tempMatrix3x3);
		Quaternion.rotationMatrix(Quaternion._tempMatrix3x3,out);
	}

	Quaternion.invert=function(value,out){
		var lengthSq=value.lengthSquared();
		if (!MathUtils3D.isZero(lengthSq)){
			lengthSq=1.0 / lengthSq;
			out.x=-value.x *lengthSq;
			out.y=-value.y *lengthSq;
			out.z=-value.z *lengthSq;
			out.w=value.w *lengthSq;
		}
	}

	Quaternion.rotationMatrix=function(matrix3x3,out){
		var me=matrix3x3.elements;
		var m11=me[0];
		var m12=me[1];
		var m13=me[2];
		var m21=me[3];
		var m22=me[4];
		var m23=me[5];
		var m31=me[6];
		var m32=me[7];
		var m33=me[8];
		var sqrt=NaN,half=NaN;
		var scale=m11+m22+m33;
		if (scale > 0){
			sqrt=Math.sqrt(scale+1);
			out.w=sqrt *0.5;
			sqrt=0.5 / sqrt;
			out.x=(m23-m32)*sqrt;
			out.y=(m31-m13)*sqrt;
			out.z=(m12-m21)*sqrt;
			}else if ((m11 >=m22)&& (m11 >=m33)){
			sqrt=Math.sqrt(1+m11-m22-m33);
			half=0.5 / sqrt;
			out.x=0.5 *sqrt;
			out.y=(m12+m21)*half;
			out.z=(m13+m31)*half;
			out.w=(m23-m32)*half;
			}else if (m22 > m33){
			sqrt=Math.sqrt(1+m22-m11-m33);
			half=0.5 / sqrt;
			out.x=(m21+m12)*half;
			out.y=0.5 *sqrt;
			out.z=(m32+m23)*half;
			out.w=(m31-m13)*half;
			}else {
			sqrt=Math.sqrt(1+m33-m11-m22);
			half=0.5 / sqrt;
			out.x=(m31+m13)*half;
			out.y=(m32+m23)*half;
			out.z=0.5 *sqrt;
			out.w=(m12-m21)*half;
		}
	}

	Quaternion.DEFAULT=new Quaternion();
	__static(Quaternion,
	['TEMPVector30',function(){return this.TEMPVector30=new Vector3();},'TEMPVector31',function(){return this.TEMPVector31=new Vector3();},'TEMPVector32',function(){return this.TEMPVector32=new Vector3();},'TEMPVector33',function(){return this.TEMPVector33=new Vector3();},'TEMPMatrix0',function(){return this.TEMPMatrix0=new Matrix4x4();},'TEMPMatrix1',function(){return this.TEMPMatrix1=new Matrix4x4();},'_tempMatrix3x3',function(){return this._tempMatrix3x3=new Matrix3x3();},'NAN',function(){return this.NAN=new Quaternion(NaN,NaN,NaN,NaN);}
	]);
	return Quaternion;
})()


/**
*@private
*/
//class laya.d3.shader.ShaderData
var ShaderData=(function(){
	function ShaderData(ownerResource){
		/**@private */
		this._ownerResource=null;
		/**@private */
		this._data=null;
		/**@private [NATIVE]*/
		this._int32Data=null;
		/**@private [NATIVE]*/
		this._float32Data=null;
		/**@private [NATIVE]*/
		this._nativeArray=null;
		/**@private [NATIVE]*/
		this._frameCount=0;
		/**@private [NATIVE]*/
		this._runtimeCopyValues=[];
		this._ownerResource=ownerResource;
		this._initData();
	}

	__class(ShaderData,'laya.d3.shader.ShaderData');
	var __proto=ShaderData.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*@private
	*/
	__proto._initData=function(){
		this._data=new Object();
	}

	/**
	*@private
	*/
	__proto.getData=function(){
		return this._data;
	}

	/**
	*获取布尔。
	*@param index shader索引。
	*@return 布尔。
	*/
	__proto.getBool=function(index){
		return this._data[index];
	}

	/**
	*设置布尔。
	*@param index shader索引。
	*@param value 布尔。
	*/
	__proto.setBool=function(index,value){
		this._data[index]=value;
	}

	/**
	*获取整形。
	*@param index shader索引。
	*@return 整形。
	*/
	__proto.getInt=function(index){
		return this._data[index];
	}

	/**
	*设置整型。
	*@param index shader索引。
	*@param value 整形。
	*/
	__proto.setInt=function(index,value){
		this._data[index]=value;
	}

	/**
	*获取浮点。
	*@param index shader索引。
	*@return 浮点。
	*/
	__proto.getNumber=function(index){
		return this._data[index];
	}

	/**
	*设置浮点。
	*@param index shader索引。
	*@param value 浮点。
	*/
	__proto.setNumber=function(index,value){
		this._data[index]=value;
	}

	/**
	*获取Vector2向量。
	*@param index shader索引。
	*@return Vector2向量。
	*/
	__proto.getVector2=function(index){
		return this._data[index];
	}

	/**
	*设置Vector2向量。
	*@param index shader索引。
	*@param value Vector2向量。
	*/
	__proto.setVector2=function(index,value){
		this._data[index]=value;
	}

	/**
	*获取Vector3向量。
	*@param index shader索引。
	*@return Vector3向量。
	*/
	__proto.getVector3=function(index){
		return this._data[index];
	}

	/**
	*设置Vector3向量。
	*@param index shader索引。
	*@param value Vector3向量。
	*/
	__proto.setVector3=function(index,value){
		this._data[index]=value;
	}

	/**
	*获取颜色。
	*@param index shader索引。
	*@return 颜色向量。
	*/
	__proto.getVector=function(index){
		return this._data[index];
	}

	/**
	*设置向量。
	*@param index shader索引。
	*@param value 向量。
	*/
	__proto.setVector=function(index,value){
		this._data[index]=value;
	}

	/**
	*获取四元数。
	*@param index shader索引。
	*@return 四元。
	*/
	__proto.getQuaternion=function(index){
		return this._data[index];
	}

	/**
	*设置四元数。
	*@param index shader索引。
	*@param value 四元数。
	*/
	__proto.setQuaternion=function(index,value){
		this._data[index]=value;
	}

	/**
	*获取矩阵。
	*@param index shader索引。
	*@return 矩阵。
	*/
	__proto.getMatrix4x4=function(index){
		return this._data[index];
	}

	/**
	*设置矩阵。
	*@param index shader索引。
	*@param value 矩阵。
	*/
	__proto.setMatrix4x4=function(index,value){
		this._data[index]=value;
	}

	/**
	*获取Buffer。
	*@param index shader索引。
	*@return
	*/
	__proto.getBuffer=function(shaderIndex){
		return this._data[shaderIndex];
	}

	/**
	*设置Buffer。
	*@param index shader索引。
	*@param value buffer数据。
	*/
	__proto.setBuffer=function(index,value){
		this._data[index]=value;
	}

	/**
	*设置纹理。
	*@param index shader索引。
	*@param value 纹理。
	*/
	__proto.setTexture=function(index,value){
		var lastValue=this._data[index];
		this._data[index]=value;
		if (this._ownerResource && this._ownerResource.referenceCount > 0){
			(lastValue)&& (lastValue._removeReference());
			(value)&& (value._addReference());
		}
	}

	/**
	*获取纹理。
	*@param index shader索引。
	*@return 纹理。
	*/
	__proto.getTexture=function(index){
		return this._data[index];
	}

	/**
	*设置Attribute。
	*@param index shader索引。
	*@param value 纹理。
	*/
	__proto.setAttribute=function(index,value){
		this._data[index]=value;
	}

	/**
	*获取Attribute。
	*@param index shader索引。
	*@return 纹理。
	*/
	__proto.getAttribute=function(index){
		return this._data[index];
	}

	/**
	*获取长度。
	*@return 长度。
	*/
	__proto.getLength=function(){
		return this._data.length;
	}

	/**
	*设置长度。
	*@param 长度。
	*/
	__proto.setLength=function(value){
		this._data.length=value;
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var dest=destObject;
		var destData=dest._data;
		for (var k in this._data){
			var value=this._data[k];
			if (value !=null){
				if ((typeof value=='number')){
					destData[k]=value;
					}else if (((typeof value=='number')&& Math.floor(value)==value)){
					destData[k]=value;
					}else if ((typeof value=='boolean')){
					destData[k]=value;
					}else if ((value instanceof laya.d3.math.Vector2 )){
					var v2=(destData[k])|| (destData[k]=new Vector2());
					(value).cloneTo(v2);
					destData[k]=v2;
					}else if ((value instanceof laya.d3.math.Vector3 )){
					var v3=(destData[k])|| (destData[k]=new Vector3());
					(value).cloneTo(v3);
					destData[k]=v3;
					}else if ((value instanceof laya.d3.math.Vector4 )){
					var v4=(destData[k])|| (destData[k]=new Vector4());
					(value).cloneTo(v4);
					destData[k]=v4;
					}else if ((value instanceof laya.d3.math.Matrix4x4 )){
					var mat=(destData[k])|| (destData[k]=new Matrix4x4());
					(value).cloneTo(mat);
					destData[k]=mat;
					}else if ((value instanceof laya.resource.BaseTexture )){
					destData[k]=value;
				}
			}
		}
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var dest=/*__JS__ */new this.constructor();
		this.cloneTo(dest);
		return dest;
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneToForNative=function(destObject){
		var dest=destObject;
		var diffSize=this._int32Data.length-dest._int32Data.length;
		if (diffSize > 0){
			dest.needRenewArrayBufferForNative(this._int32Data.length);
		}
		dest._int32Data.set(this._int32Data,0);
		var destData=dest._nativeArray;
		var dataCount=this._nativeArray.length;
		destData.length=dataCount;
		for (var i=0;i < dataCount;i++){
			var value=this._nativeArray[i];
			if (value){
				if ((typeof value=='number')){
					destData[i]=value;
					dest.setNumber(i,value);
					}else if (((typeof value=='number')&& Math.floor(value)==value)){
					destData[i]=value;
					dest.setInt(i,value);
					}else if ((typeof value=='boolean')){
					destData[i]=value;
					dest.setBool(i,value);
					}else if ((value instanceof laya.d3.math.Vector2 )){
					var v2=(destData[i])|| (destData[i]=new Vector2());
					(value).cloneTo(v2);
					destData[i]=v2;
					dest.setVector2(i,v2);
					}else if ((value instanceof laya.d3.math.Vector3 )){
					var v3=(destData[i])|| (destData[i]=new Vector3());
					(value).cloneTo(v3);
					destData[i]=v3;
					dest.setVector3(i,v3);
					}else if ((value instanceof laya.d3.math.Vector4 )){
					var v4=(destData[i])|| (destData[i]=new Vector4());
					(value).cloneTo(v4);
					destData[i]=v4;
					dest.setVector(i,v4);
					}else if ((value instanceof laya.d3.math.Matrix4x4 )){
					var mat=(destData[i])|| (destData[i]=new Matrix4x4());
					(value).cloneTo(mat);
					destData[i]=mat;
					dest.setMatrix4x4(i,mat);
					}else if ((value instanceof laya.resource.BaseTexture )){
					destData[i]=value;
					dest.setTexture(i,value);
				}
			}
		}
	}

	/**
	*@private [NATIVE]
	*/
	__proto._initDataForNative=function(){
		var length=8;
		if (!length){
			alert("ShaderData _initDataForNative error length=0");
		}
		this._frameCount=-1;
		this._runtimeCopyValues.length=0;
		this._nativeArray=[];
		this._data=new ArrayBuffer(length *4);
		this._int32Data=new Int32Array(this._data);
		this._float32Data=new Float32Array(this._data);
		LayaGL.createArrayBufferRef(this._data,/*laya.layagl.LayaGL.ARRAY_BUFFER_TYPE_DATA*/0,true);
	}

	__proto.needRenewArrayBufferForNative=function(index){
		if (index >=this._int32Data.length){
			var nByteLen=(index+1)*4;
			var pre=this._int32Data;
			var preConchRef=this._data["conchRef"];
			var prePtrID=this._data["_ptrID"];
			this._data=new ArrayBuffer(nByteLen);
			this._int32Data=new Int32Array(this._data);
			this._float32Data=new Float32Array(this._data);
			this._data["conchRef"]=preConchRef;
			this._data["_ptrID"]=prePtrID;
			pre && this._int32Data.set(pre,0);
			/*__JS__ */conch.updateArrayBufferRef(this._data['_ptrID'],preConchRef.isSyncToRender(),this._data);
		}
	}

	__proto.getDataForNative=function(){
		return this._nativeArray;
	}

	/**
	*@private [NATIVE]
	*/
	__proto.getIntForNative=function(index){
		return this._int32Data[index];
	}

	/**
	*@private [NATIVE]
	*/
	__proto.setIntForNative=function(index,value){
		this.needRenewArrayBufferForNative(index);
		this._int32Data[index]=value;
		this._nativeArray[index]=value;
	}

	/**
	*@private [NATIVE]
	*/
	__proto.getBoolForNative=function(index){
		return this._int32Data[index]==1;
	}

	/**
	*@private [NATIVE]
	*/
	__proto.setBoolForNative=function(index,value){
		this.needRenewArrayBufferForNative(index);
		this._int32Data[index]=value;
		this._nativeArray[index]=value;
	}

	/**
	*@private [NATIVE]
	*/
	__proto.getNumberForNative=function(index){
		return this._float32Data[index];
	}

	/**
	*@private [NATIVE]
	*/
	__proto.setNumberForNative=function(index,value){
		this.needRenewArrayBufferForNative(index);
		this._float32Data[index]=value;
		this._nativeArray[index]=value;
	}

	/**
	*@private [NATIVE]
	*/
	__proto.getMatrix4x4ForNative=function(index){
		return this._nativeArray[index];
	}

	/**
	*@private [NATIVE]
	*/
	__proto.setMatrix4x4ForNative=function(index,value){
		this.needRenewArrayBufferForNative(index);
		this._nativeArray[index]=value;
		var nPtrID=this.setReferenceForNative(value.elements);
		this._int32Data[index]=nPtrID;
	}

	/**
	*@private [NATIVE]
	*/
	__proto.getVectorForNative=function(index){
		return this._nativeArray[index];
	}

	/**
	*@private [NATIVE]
	*/
	__proto.setVectorForNative=function(index,value){
		this.needRenewArrayBufferForNative(index);
		this._nativeArray[index]=value;
		if (!value.elements){
			value.forNativeElement();
		};
		var nPtrID=this.setReferenceForNative(value.elements);
		this._int32Data[index]=nPtrID;
	}

	/**
	*@private [NATIVE]
	*/
	__proto.getVector2ForNative=function(index){
		return this._nativeArray[index];
	}

	/**
	*@private [NATIVE]
	*/
	__proto.setVector2ForNative=function(index,value){
		this.needRenewArrayBufferForNative(index);
		this._nativeArray[index]=value;
		if (!value.elements){
			value.forNativeElement();
		};
		var nPtrID=this.setReferenceForNative(value.elements);
		this._int32Data[index]=nPtrID;
	}

	/**
	*@private [NATIVE]
	*/
	__proto.getVector3ForNative=function(index){
		return this._nativeArray[index];
	}

	/**
	*@private [NATIVE]
	*/
	__proto.setVector3ForNative=function(index,value){
		this.needRenewArrayBufferForNative(index);
		this._nativeArray[index]=value;
		if (!value.elements){
			value.forNativeElement();
		};
		var nPtrID=this.setReferenceForNative(value.elements);
		this._int32Data[index]=nPtrID;
	}

	/**
	*@private [NATIVE]
	*/
	__proto.getQuaternionForNative=function(index){
		return this._nativeArray[index];
	}

	/**
	*@private [NATIVE]
	*/
	__proto.setQuaternionForNative=function(index,value){
		this.needRenewArrayBufferForNative(index);
		this._nativeArray[index]=value;
		if (!value.elements){
			value.forNativeElement();
		};
		var nPtrID=this.setReferenceForNative(value.elements);
		this._int32Data[index]=nPtrID;
	}

	/**
	*@private [NATIVE]
	*/
	__proto.getBufferForNative=function(shaderIndex){
		return this._nativeArray[shaderIndex];
	}

	/**
	*@private [NATIVE]
	*/
	__proto.setBufferForNative=function(index,value){
		this.needRenewArrayBufferForNative(index);
		this._nativeArray[index]=value;
		var nPtrID=this.setReferenceForNative(value);
		this._int32Data[index]=nPtrID;
	}

	/**
	*@private [NATIVE]
	*/
	__proto.getAttributeForNative=function(index){
		return this._nativeArray[index];
	}

	/**
	*@private [NATIVE]
	*/
	__proto.setAttributeForNative=function(index,value){
		this._nativeArray[index]=value;
		if (!value["_ptrID"]){
			LayaGL.createArrayBufferRef(value,/*laya.layagl.LayaGL.ARRAY_BUFFER_TYPE_DATA*/0,true);
		}
		LayaGL.syncBufferToRenderThread(value);
		this._int32Data[index]=value["_ptrID"];
	}

	/**
	*@private [NATIVE]
	*/
	__proto.getTextureForNative=function(index){
		return this._nativeArray[index];
	}

	/**
	*@private [NATIVE]
	*/
	__proto.setTextureForNative=function(index,value){
		if (!value)return;
		this.needRenewArrayBufferForNative(index);
		var lastValue=this._nativeArray[index];
		this._nativeArray[index]=value;
		this._int32Data[index]=(value)._glTexture.id;
		if (this._ownerResource && this._ownerResource.referenceCount > 0){
			(lastValue)&& (lastValue._removeReference());
			(value)&& (value._addReference());
		}
	}

	__proto.setReferenceForNative=function(value){
		this.clearRuntimeCopyArray();
		var nRefID=0;
		var nPtrID=0;
		if (ShaderData._SET_RUNTIME_VALUE_MODE_REFERENCE_){
			LayaGL.createArrayBufferRefs(value,/*laya.layagl.LayaGL.ARRAY_BUFFER_TYPE_DATA*/0,true,/*laya.layagl.LayaGL.ARRAY_BUFFER_REF_REFERENCE*/0);
			nRefID=0;
			nPtrID=value.getPtrID(nRefID);
			}else {
			LayaGL.createArrayBufferRefs(value,/*laya.layagl.LayaGL.ARRAY_BUFFER_TYPE_DATA*/0,true,/*laya.layagl.LayaGL.ARRAY_BUFFER_REF_COPY*/1);
			nRefID=value.getRefNum()-1;
			nPtrID=value.getPtrID(nRefID);
			this._runtimeCopyValues.push({"obj":value,"refID":nRefID,"ptrID":nPtrID});
		}
		LayaGL.syncBufferToRenderThread(value,nRefID);
		return nPtrID;
	}

	__proto.clearRuntimeCopyArray=function(){
		var currentFrame=LayaGL.getFrameCount();
		if (this._frameCount !=currentFrame){
			this._frameCount=currentFrame;
			for (var i=0,n=this._runtimeCopyValues.length;i < n;i++){
				var obj=this._runtimeCopyValues[i];
				obj.obj.clearRefNum();
			}
			this._runtimeCopyValues.length=0;
		}
	}

	ShaderData.setRuntimeValueMode=function(bReference){
		ShaderData._SET_RUNTIME_VALUE_MODE_REFERENCE_=bReference;
	}

	ShaderData._SET_RUNTIME_VALUE_MODE_REFERENCE_=true;
	return ShaderData;
})()


/**
*<code>TerrainLeaf</code> Terrain的叶子节点
*/
//class laya.d3.terrain.TerrainLeaf
var TerrainLeaf=(function(){
	function TerrainLeaf(){
		this._boundingSphere=null;
		this._boundingBox=null;
		this._sizeOfY=null;
		this._currentLODLevel=0;
		this._lastDistanceToEye=NaN;
		this._originalBoundingSphere=null;
		this._originalBoundingBox=null;
		this._originalBoundingBoxCorners=null;
		this._bUseStrip=false;
		this._gridSize=NaN;
		this._beginGridX=0;
		//针对整个大地形的偏移
		this._beginGridZ=0;
		//针对整个大地形的偏移
		this._LODError=null;
		TerrainLeaf.__init__();
		this._currentLODLevel=0;
	}

	__class(TerrainLeaf,'laya.d3.terrain.TerrainLeaf');
	var __proto=TerrainLeaf.prototype;
	__proto.calcVertextNorml=function(x,z,terrainHeightData,heighDataWidth,heightDataHeight,normal){
		var dZ=0,dX=0;
		dX=TerrainLeaf.getHeightFromTerrainHeightData(x-1,z-1,terrainHeightData,heighDataWidth,heightDataHeight)*-1.0;
		dX+=TerrainLeaf.getHeightFromTerrainHeightData(x-1,z,terrainHeightData,heighDataWidth,heightDataHeight)*-1.0;
		dX+=TerrainLeaf.getHeightFromTerrainHeightData(x-1,z+1,terrainHeightData,heighDataWidth,heightDataHeight)*-1.0;
		dX+=TerrainLeaf.getHeightFromTerrainHeightData(x+1,z-1,terrainHeightData,heighDataWidth,heightDataHeight)*1.0;
		dX+=TerrainLeaf.getHeightFromTerrainHeightData(x+1,z,terrainHeightData,heighDataWidth,heightDataHeight)*1.0;
		dX+=TerrainLeaf.getHeightFromTerrainHeightData(x+1,z+1,terrainHeightData,heighDataWidth,heightDataHeight)*1.0;
		dZ=TerrainLeaf.getHeightFromTerrainHeightData(x-1,z-1,terrainHeightData,heighDataWidth,heightDataHeight)*-1.0;
		dZ+=TerrainLeaf.getHeightFromTerrainHeightData(x,z-1,terrainHeightData,heighDataWidth,heightDataHeight)*-1.0;
		dZ+=TerrainLeaf.getHeightFromTerrainHeightData(x+1,z-1,terrainHeightData,heighDataWidth,heightDataHeight)*-1.0;
		dZ+=TerrainLeaf.getHeightFromTerrainHeightData(x-1,z+1,terrainHeightData,heighDataWidth,heightDataHeight)*1.0;
		dZ+=TerrainLeaf.getHeightFromTerrainHeightData(x,z+1,terrainHeightData,heighDataWidth,heightDataHeight)*1.0;
		dZ+=TerrainLeaf.getHeightFromTerrainHeightData(x+1,z+1,terrainHeightData,heighDataWidth,heightDataHeight)*1.0;
		normal.x=-dX;
		normal.y=6;
		normal.z=-dZ;
		Vector3.normalize(normal,normal);
	}

	__proto.calcVertextNormlUV=function(x,z,terrainWidth,terrainHeight,normal){
		normal.x=x / terrainWidth;
		normal.y=z / terrainHeight;
		normal.z=z / terrainHeight;
	}

	__proto.calcVertextBuffer=function(offsetChunkX,offsetChunkZ,beginX,beginZ,girdSize,vertextBuffer,offset,strideSize,terrainHeightData,heighDataWidth,heightDataHeight,cameraCoordinateInverse){
		if (cameraCoordinateInverse==true && !TerrainLeaf.__ADAPT_MATRIX__){
			TerrainLeaf.__ADAPT_MATRIX__=new Matrix4x4();
			var mat=new Matrix4x4();
			Matrix4x4.createRotationY(Math.PI,TerrainLeaf.__ADAPT_MATRIX__);
			Matrix4x4.createTranslate(new Vector3(0,0,(heightDataHeight-1)*girdSize),mat);
			Matrix4x4.multiply(mat,TerrainLeaf.__ADAPT_MATRIX__,TerrainLeaf.__ADAPT_MATRIX__);
			TerrainLeaf.__ADAPT_MATRIX_INV__=new Matrix4x4();
			TerrainLeaf.__ADAPT_MATRIX__.invert(TerrainLeaf.__ADAPT_MATRIX_INV__);
		}
		this._gridSize=girdSize;
		this._beginGridX=offsetChunkX *TerrainLeaf.CHUNK_GRID_NUM+beginX;
		this._beginGridZ=offsetChunkZ *TerrainLeaf.CHUNK_GRID_NUM+beginZ;
		var nNum=offset *strideSize;
		var minY=2147483647;
		var maxY=-2147483648;
		var normal=new Vector3();
		for (var i=0,s=TerrainLeaf.LEAF_GRID_NUM+1;i < s;i++){
			for (var j=0,s1=TerrainLeaf.LEAF_GRID_NUM+1;j < s1;j++){
				TerrainLeaf.__VECTOR3__.x=(this._beginGridX+j)*this._gridSize;
				TerrainLeaf.__VECTOR3__.z=(this._beginGridZ+i)*this._gridSize;
				TerrainLeaf.__VECTOR3__.y=terrainHeightData[(this._beginGridZ+i)*(heighDataWidth)+(this._beginGridX+j)];
				minY=TerrainLeaf.__VECTOR3__.y < minY ? TerrainLeaf.__VECTOR3__.y :minY;
				maxY=TerrainLeaf.__VECTOR3__.y > maxY ? TerrainLeaf.__VECTOR3__.y :maxY;
				if (TerrainLeaf.__ADAPT_MATRIX__){
					Vector3.transformV3ToV3(TerrainLeaf.__VECTOR3__,TerrainLeaf.__ADAPT_MATRIX__,TerrainLeaf.__VECTOR3__);
				}
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.x;
				nNum++;
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.y;
				nNum++;
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.z;
				nNum++;
				this.calcVertextNormlUV(this._beginGridX+j,this._beginGridZ+i,heighDataWidth,heightDataHeight,normal);
				vertextBuffer[nNum]=normal.x;
				nNum++;
				vertextBuffer[nNum]=normal.y;
				nNum++;
				vertextBuffer[nNum]=normal.z;
				nNum++;
				vertextBuffer[nNum]=(beginX+j)/ TerrainLeaf.CHUNK_GRID_NUM;
				nNum++;
				vertextBuffer[nNum]=(beginZ+i)/ TerrainLeaf.CHUNK_GRID_NUM;
				nNum++;
				vertextBuffer[nNum]=this._beginGridX+j;
				nNum++;
				vertextBuffer[nNum]=this._beginGridZ+i;
				nNum++;
			}
		}
		this._sizeOfY=new Vector2(minY-1,maxY+1);
		this.calcLODErrors(terrainHeightData,heighDataWidth,heightDataHeight);
		this.calcOriginalBoudingBoxAndSphere();
	}

	__proto.calcSkirtVertextBuffer=function(offsetChunkX,offsetChunkZ,beginX,beginZ,girdSize,vertextBuffer,offset,strideSize,terrainHeightData,heighDataWidth,heightDataHeight){
		this._gridSize=girdSize;
		this._beginGridX=offsetChunkX *TerrainLeaf.CHUNK_GRID_NUM+beginX;
		this._beginGridZ=offsetChunkZ *TerrainLeaf.CHUNK_GRID_NUM+beginZ;
		var nNum=offset *strideSize;
		var i=0,j=0,s=TerrainLeaf.LEAF_GRID_NUM+1;
		var normal=new Vector3();
		var hZIndex=0;
		var hXIndex=0;
		var h=0;
		var zh=0;
		var xh=0;
		for (i=0;i < 2;i++){
			for (j=0;j < s;j++){
				TerrainLeaf.__VECTOR3__.x=(this._beginGridX+j)*this._gridSize;
				TerrainLeaf.__VECTOR3__.y=(i==1 ? terrainHeightData[this._beginGridZ *heighDataWidth+(this._beginGridX+j)] :-this._gridSize);
				TerrainLeaf.__VECTOR3__.z=(this._beginGridZ+0)*this._gridSize;
				if (TerrainLeaf.__ADAPT_MATRIX__){
					Vector3.transformV3ToV3(TerrainLeaf.__VECTOR3__,TerrainLeaf.__ADAPT_MATRIX__,TerrainLeaf.__VECTOR3__);
				}
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.x;
				nNum++;
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.y;
				nNum++;
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.z;
				nNum++;
				if (i==0){
					hZIndex=(this._beginGridZ-1);
					}else {
					hZIndex=this._beginGridZ;
				}
				this.calcVertextNormlUV(this._beginGridX+j,hZIndex,heighDataWidth,heightDataHeight,normal);
				vertextBuffer[nNum]=normal.x;
				nNum++;
				vertextBuffer[nNum]=normal.y;
				nNum++;
				vertextBuffer[nNum]=normal.z;
				nNum++;
				vertextBuffer[nNum]=(beginX+j)/ TerrainLeaf.CHUNK_GRID_NUM;
				nNum++;
				vertextBuffer[nNum]=(beginZ+0)/ TerrainLeaf.CHUNK_GRID_NUM;
				nNum++;
				vertextBuffer[nNum]=this._beginGridX+j;
				nNum++;
				vertextBuffer[nNum]=hZIndex;
				nNum++;
			}
		}
		for (i=0;i < 2;i++){
			for (j=0;j < s;j++){
				TerrainLeaf.__VECTOR3__.x=(this._beginGridX+j)*this._gridSize;
				TerrainLeaf.__VECTOR3__.y=(i==0 ? terrainHeightData[(this._beginGridZ+TerrainLeaf.LEAF_GRID_NUM)*(heighDataWidth)+(this._beginGridX+j)] :-this._gridSize);
				TerrainLeaf.__VECTOR3__.z=(this._beginGridZ+TerrainLeaf.LEAF_GRID_NUM)*this._gridSize;
				if (TerrainLeaf.__ADAPT_MATRIX__){
					Vector3.transformV3ToV3(TerrainLeaf.__VECTOR3__,TerrainLeaf.__ADAPT_MATRIX__,TerrainLeaf.__VECTOR3__);
				}
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.x;
				nNum++;
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.y;
				nNum++;
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.z;
				nNum++;
				if (i==0){
					hZIndex=this._beginGridZ+TerrainLeaf.LEAF_GRID_NUM;
					}else {
					hZIndex=(this._beginGridZ+TerrainLeaf.LEAF_GRID_NUM+1);
				}
				this.calcVertextNormlUV(this._beginGridX+j,hZIndex,heighDataWidth,heightDataHeight,normal);
				vertextBuffer[nNum]=normal.x;
				nNum++;
				vertextBuffer[nNum]=normal.y;
				nNum++;
				vertextBuffer[nNum]=normal.z;
				nNum++;
				vertextBuffer[nNum]=(beginX+j)/ TerrainLeaf.CHUNK_GRID_NUM;
				nNum++;
				vertextBuffer[nNum]=(beginZ+TerrainLeaf.LEAF_GRID_NUM)/ TerrainLeaf.CHUNK_GRID_NUM;
				nNum++;
				vertextBuffer[nNum]=this._beginGridX+j;
				nNum++;
				vertextBuffer[nNum]=hZIndex;
				nNum++;
			}
		}
		for (i=0;i < 2;i++){
			for (j=0;j < s;j++){
				TerrainLeaf.__VECTOR3__.x=(this._beginGridX+0)*this._gridSize;
				TerrainLeaf.__VECTOR3__.y=(i==0 ? terrainHeightData[(this._beginGridZ+j)*(heighDataWidth)+(this._beginGridX+0)] :-this._gridSize);
				TerrainLeaf.__VECTOR3__.z=(this._beginGridZ+j)*this._gridSize;
				if (TerrainLeaf.__ADAPT_MATRIX__){
					Vector3.transformV3ToV3(TerrainLeaf.__VECTOR3__,TerrainLeaf.__ADAPT_MATRIX__,TerrainLeaf.__VECTOR3__);
				}
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.x;
				nNum++;
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.y;
				nNum++;
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.z;
				nNum++;
				if (i==0){
					hXIndex=this._beginGridX;
					}else {
					hXIndex=(this._beginGridX-1);
				}
				this.calcVertextNormlUV(hXIndex,this._beginGridZ+j,heighDataWidth,heightDataHeight,normal);
				vertextBuffer[nNum]=normal.x;
				nNum++;
				vertextBuffer[nNum]=normal.y;
				nNum++;
				vertextBuffer[nNum]=normal.z;
				nNum++;
				vertextBuffer[nNum]=(beginX+0)/ TerrainLeaf.CHUNK_GRID_NUM;
				nNum++;
				vertextBuffer[nNum]=(beginZ+j)/ TerrainLeaf.CHUNK_GRID_NUM;
				nNum++;
				vertextBuffer[nNum]=hXIndex;
				nNum++;
				vertextBuffer[nNum]=this._beginGridZ+j;
				nNum++;
			}
		}
		for (i=0;i < 2;i++){
			for (j=0;j < s;j++){
				TerrainLeaf.__VECTOR3__.x=(this._beginGridX+TerrainLeaf.LEAF_GRID_NUM)*this._gridSize;
				TerrainLeaf.__VECTOR3__.y=(i==1 ? terrainHeightData[(this._beginGridZ+j)*(heighDataWidth)+(this._beginGridX+TerrainLeaf.LEAF_GRID_NUM)] :-this._gridSize);
				TerrainLeaf.__VECTOR3__.z=(this._beginGridZ+j)*this._gridSize;
				if (TerrainLeaf.__ADAPT_MATRIX__){
					Vector3.transformV3ToV3(TerrainLeaf.__VECTOR3__,TerrainLeaf.__ADAPT_MATRIX__,TerrainLeaf.__VECTOR3__);
				}
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.x;
				nNum++;
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.y;
				nNum++;
				vertextBuffer[nNum]=TerrainLeaf.__VECTOR3__.z;
				nNum++;
				if (i==0){
					hXIndex=this._beginGridX+TerrainLeaf.LEAF_GRID_NUM+1;
					}else {
					hXIndex=this._beginGridX+TerrainLeaf.LEAF_GRID_NUM;
				}
				this.calcVertextNormlUV(hXIndex,this._beginGridZ+j,heighDataWidth,heightDataHeight,normal);
				vertextBuffer[nNum]=normal.x;
				nNum++;
				vertextBuffer[nNum]=normal.y;
				nNum++;
				vertextBuffer[nNum]=normal.z;
				nNum++;
				vertextBuffer[nNum]=(beginX+TerrainLeaf.LEAF_GRID_NUM)/ TerrainLeaf.CHUNK_GRID_NUM;
				nNum++;
				vertextBuffer[nNum]=(beginZ+j)/ TerrainLeaf.CHUNK_GRID_NUM;
				nNum++;
				vertextBuffer[nNum]=hXIndex;
				nNum++;
				vertextBuffer[nNum]=this._beginGridZ+j;
				nNum++;
			}
		}
	}

	__proto.calcOriginalBoudingBoxAndSphere=function(){
		var min=new Vector3(this._beginGridX *this._gridSize,this._sizeOfY.x,this._beginGridZ *this._gridSize);
		var max=new Vector3((this._beginGridX+TerrainLeaf.LEAF_GRID_NUM)*this._gridSize,this._sizeOfY.y,(this._beginGridZ+TerrainLeaf.LEAF_GRID_NUM)*this._gridSize);
		if (TerrainLeaf.__ADAPT_MATRIX__){
			Vector3.transformV3ToV3(min,TerrainLeaf.__ADAPT_MATRIX__,min);
			Vector3.transformV3ToV3(max,TerrainLeaf.__ADAPT_MATRIX__,max);
		}
		this._originalBoundingBox=new BoundBox(min,max);
		var size=new Vector3();
		Vector3.subtract(max,min,size);
		Vector3.scale(size,0.5,size);
		var center=new Vector3();
		Vector3.add(min,size,center);
		this._originalBoundingSphere=new BoundSphere(center,Vector3.scalarLength(size));
		this._originalBoundingBoxCorners=__newvec(8,null);
		this._originalBoundingBox.getCorners(this._originalBoundingBoxCorners);
		this._boundingBox=new BoundBox(new Vector3(-0.5,-0.5,-0.5),new Vector3(0.5,0.5,0.5));
		this._boundingSphere=new BoundSphere(new Vector3(0,0,0),1);
	}

	__proto.calcLeafBoudingBox=function(worldMatrix){
		for (var i=0;i < 8;i++){
			Vector3.transformCoordinate(this._originalBoundingBoxCorners[i],worldMatrix,BaseRender._tempBoundBoxCorners[i]);
		}
		BoundBox.createfromPoints(BaseRender._tempBoundBoxCorners,this._boundingBox);
	}

	__proto.calcLeafBoudingSphere=function(worldMatrix,maxScale){
		Vector3.transformCoordinate(this._originalBoundingSphere.center,worldMatrix,this._boundingSphere.center);
		this._boundingSphere.radius=this._originalBoundingSphere.radius *maxScale;
	}

	__proto.calcLODErrors=function(terrainHeightData,heighDataWidth,heightDataHeight){
		this._LODError=new Float32Array(TerrainLeaf._maxLODLevel+1);
		var step=1;
		for (var i=0,n=TerrainLeaf._maxLODLevel+1;i < n;i++){
			var maxError=0;
			for (var y=0,n1=TerrainLeaf.LEAF_GRID_NUM;y < n1;y+=step){
				for (var x=0,n2=TerrainLeaf.LEAF_GRID_NUM;x < n2;x+=step){
					var z00=terrainHeightData[(this._beginGridZ+y)*heighDataWidth+(this._beginGridX+x)];
					var z10=terrainHeightData[(this._beginGridZ+y)*heighDataWidth+(this._beginGridX+x)+step];
					var z01=terrainHeightData[(this._beginGridZ+y+step)*heighDataWidth+(this._beginGridX+x)];
					var z11=terrainHeightData[(this._beginGridZ+y+step)*heighDataWidth+(this._beginGridX+x)+step];
					for (var j=0;j < step;j++){
						var ys=j / step;
						for (var k=0;k < step;k++){
							var xs=k / step;
							var z=terrainHeightData[(this._beginGridZ+y+j)*heighDataWidth+(this._beginGridX+x)+k];
							var iz=(xs+ys <=1)? (z00+(z10-z00)*xs+(z01-z00)*ys):(z11+(z01-z11)*(1-xs)+(z10-z11)*(1-ys));
							var error=Math.abs(iz-z);
							maxError=Math.max(maxError,error);
						}
					}
				}
			}
			step *=2;
			this._LODError[i]=maxError;
		}
	}

	__proto.determineLod=function(eyePos,perspectiveFactor,tolerance,tolerAndPerspectiveChanged){
		var nDistanceToEye=Vector3.distance(eyePos,this._boundingSphere.center);
		var n=TerrainLeaf._maxLODLevel;
		if (!tolerAndPerspectiveChanged){
			if (this._lastDistanceToEye==nDistanceToEye){
				return this._currentLODLevel;
				}else if (this._lastDistanceToEye > nDistanceToEye){
				n=this._currentLODLevel;
			}
		}
		for (var i=n;i >=1;i--){
			if (Terrain.LOD_DISTANCE_FACTOR *this._LODError[i] / nDistanceToEye *perspectiveFactor < tolerance){
				this._currentLODLevel=i;
				break ;
			}
		}
		this._lastDistanceToEye=nDistanceToEye;
		return this._currentLODLevel;
	}

	TerrainLeaf.__init__=function(){
		if (!TerrainLeaf._bInit){
			var nLeafNum=(TerrainLeaf.CHUNK_GRID_NUM / TerrainLeaf.LEAF_GRID_NUM)*(TerrainLeaf.CHUNK_GRID_NUM / TerrainLeaf.LEAF_GRID_NUM);
			TerrainLeaf._planeLODIndex=__newvec(nLeafNum);
			var i=0,j=0,k=0,n=0,n1=0,nOffset=0;
			var nOriginIndexArray=null,nTempIndex=null;
			for (i=0;i < nLeafNum;i++){
				TerrainLeaf._planeLODIndex[i]=new Array(TerrainLeaf._maxLODLevel+1);
			}
			for (i=0,n=TerrainLeaf._maxLODLevel+1;i < n;i++){
				TerrainLeaf._planeLODIndex[0][i]=TerrainLeaf.calcPlaneLODIndex(i);
			}
			for (i=1;i < nLeafNum;i++){
				nOffset=i *TerrainLeaf.LEAF_PLANE_VERTEXT_COUNT;
				for (j=0,n1=TerrainLeaf._maxLODLevel+1;j < n1;j++){
					nOriginIndexArray=TerrainLeaf._planeLODIndex[0][j];
					nTempIndex=new Uint16Array(nOriginIndexArray.length);
					for (k=0;k < nOriginIndexArray.length;k++){
						nTempIndex[k]=nOriginIndexArray[k]+nOffset;
					}
					TerrainLeaf._planeLODIndex[i][j]=nTempIndex;
				}
			}
			TerrainLeaf._skirtLODIndex=__newvec(nLeafNum);
			for (i=0;i < nLeafNum;i++){
				TerrainLeaf._skirtLODIndex[i]=new Array(TerrainLeaf._maxLODLevel+1);
			}
			for (i=0,n=TerrainLeaf._maxLODLevel+1;i < n;i++){
				TerrainLeaf._skirtLODIndex[0][i]=TerrainLeaf.calcSkirtLODIndex(i);
			}
			for (i=1;i < nLeafNum;i++){
				nOffset=i *TerrainLeaf.LEAF_SKIRT_VERTEXT_COUNT;
				for (j=0,n1=TerrainLeaf._maxLODLevel+1;j < n1;j++){
					nOriginIndexArray=TerrainLeaf._skirtLODIndex[0][j];
					nTempIndex=new Uint16Array(nOriginIndexArray.length);
					for (k=0;k < nOriginIndexArray.length;k++){
						nTempIndex[k]=nOriginIndexArray[k]+nOffset;
					}
					TerrainLeaf._skirtLODIndex[i][j]=nTempIndex;
				}
			}
			TerrainLeaf._bInit=true;
		}
	}

	TerrainLeaf.getPlaneLODIndex=function(leafIndex,LODLevel){
		return TerrainLeaf._planeLODIndex[leafIndex][LODLevel];
	}

	TerrainLeaf.getSkirtLODIndex=function(leafIndex,LODLevel){
		return TerrainLeaf._skirtLODIndex[leafIndex][LODLevel];
	}

	TerrainLeaf.calcPlaneLODIndex=function(level){
		if (level > TerrainLeaf._maxLODLevel)level=TerrainLeaf._maxLODLevel;
		var nGridNumAddOne=TerrainLeaf.LEAF_GRID_NUM+1;
		var nNum=0;
		var indexBuffer=null;
		var nLODGridNum=laya.d3.terrain.TerrainLeaf.LEAF_GRID_NUM / Math.pow(2,level);
		indexBuffer=new Uint16Array(nLODGridNum *nLODGridNum *6);
		var nGridSpace=laya.d3.terrain.TerrainLeaf.LEAF_GRID_NUM / nLODGridNum;
		for (var i=0;i < TerrainLeaf.LEAF_GRID_NUM;i+=nGridSpace){
			for (var j=0;j < TerrainLeaf.LEAF_GRID_NUM;j+=nGridSpace){
				indexBuffer[nNum]=(i+nGridSpace)*nGridNumAddOne+j;
				nNum++;
				indexBuffer[nNum]=i *nGridNumAddOne+j;
				nNum++;
				indexBuffer[nNum]=i *nGridNumAddOne+j+nGridSpace;
				nNum++;
				indexBuffer[nNum]=i *nGridNumAddOne+j+nGridSpace;
				nNum++;
				indexBuffer[nNum]=(i+nGridSpace)*nGridNumAddOne+j+nGridSpace;
				nNum++;
				indexBuffer[nNum]=(i+nGridSpace)*nGridNumAddOne+j;
				nNum++;
			}
		}
		return indexBuffer;
	}

	TerrainLeaf.calcSkirtLODIndex=function(level){
		if (level > TerrainLeaf._maxLODLevel)level=TerrainLeaf._maxLODLevel;
		var nSkirtIndexOffset=(TerrainLeaf.CHUNK_GRID_NUM / TerrainLeaf.LEAF_GRID_NUM)*(TerrainLeaf.CHUNK_GRID_NUM / TerrainLeaf.LEAF_GRID_NUM)*TerrainLeaf.LEAF_PLANE_VERTEXT_COUNT;
		var nGridNumAddOne=TerrainLeaf.LEAF_GRID_NUM+1;
		var nNum=0;
		var indexBuffer=null;
		var nLODGridNum=laya.d3.terrain.TerrainLeaf.LEAF_GRID_NUM / Math.pow(2,level);
		indexBuffer=new Uint16Array(nLODGridNum *4 *6);
		var nGridSpace=laya.d3.terrain.TerrainLeaf.LEAF_GRID_NUM / nLODGridNum;
		for (var j=0;j < 4;j++){
			for (var i=0;i < TerrainLeaf.LEAF_GRID_NUM;i+=nGridSpace){
				indexBuffer[nNum]=nSkirtIndexOffset+nGridNumAddOne+i;
				nNum++;
				indexBuffer[nNum]=nSkirtIndexOffset+i;
				nNum++;
				indexBuffer[nNum]=nSkirtIndexOffset+i+nGridSpace;
				nNum++;
				indexBuffer[nNum]=nSkirtIndexOffset+i+nGridSpace;
				nNum++;
				indexBuffer[nNum]=nSkirtIndexOffset+nGridNumAddOne+i+nGridSpace;
				nNum++;
				indexBuffer[nNum]=nSkirtIndexOffset+nGridNumAddOne+i;
				nNum++;
			}
			nSkirtIndexOffset+=nGridNumAddOne *2;
		}
		return indexBuffer;
	}

	TerrainLeaf.getHeightFromTerrainHeightData=function(x,z,terrainHeightData,heighDataWidth,heightDataHeight){
		x=x < 0 ? 0 :x;
		x=(x >=heighDataWidth)? heighDataWidth-1 :x;
		z=z < 0 ? 0 :z;
		z=(z >=heightDataHeight)? heightDataHeight-1 :z;
		return terrainHeightData[z *heighDataWidth+x];
	}

	TerrainLeaf.CHUNK_GRID_NUM=64;
	TerrainLeaf.LEAF_GRID_NUM=32;
	TerrainLeaf.__ADAPT_MATRIX__=null;
	TerrainLeaf.__ADAPT_MATRIX_INV__=null;
	TerrainLeaf._planeLODIndex=null;
	TerrainLeaf._skirtLODIndex=null;
	TerrainLeaf._bInit=false;
	__static(TerrainLeaf,
	['LEAF_PLANE_VERTEXT_COUNT',function(){return this.LEAF_PLANE_VERTEXT_COUNT=(TerrainLeaf.LEAF_GRID_NUM+1)*(TerrainLeaf.LEAF_GRID_NUM+1);},'LEAF_SKIRT_VERTEXT_COUNT',function(){return this.LEAF_SKIRT_VERTEXT_COUNT=(TerrainLeaf.LEAF_GRID_NUM+1)*2 *4;},'LEAF_VERTEXT_COUNT',function(){return this.LEAF_VERTEXT_COUNT=TerrainLeaf.LEAF_PLANE_VERTEXT_COUNT+TerrainLeaf.LEAF_SKIRT_VERTEXT_COUNT;},'LEAF_PLANE_MAX_INDEX_COUNT',function(){return this.LEAF_PLANE_MAX_INDEX_COUNT=TerrainLeaf.LEAF_GRID_NUM *TerrainLeaf.LEAF_GRID_NUM *6;},'LEAF_SKIRT_MAX_INDEX_COUNT',function(){return this.LEAF_SKIRT_MAX_INDEX_COUNT=TerrainLeaf.LEAF_GRID_NUM *4 *6;},'LEAF_MAX_INDEX_COUNT',function(){return this.LEAF_MAX_INDEX_COUNT=TerrainLeaf.LEAF_PLANE_MAX_INDEX_COUNT+TerrainLeaf.LEAF_SKIRT_MAX_INDEX_COUNT;},'__VECTOR3__',function(){return this.__VECTOR3__=new Vector3();},'_maxLODLevel',function(){return this._maxLODLevel=/*__JS__ */Math.log2(TerrainLeaf.LEAF_GRID_NUM);}
	]);
	return TerrainLeaf;
})()


/**
*...
*@author ...
*/
//class laya.d3.graphics.Vertex.VertexShuriKenParticle
var VertexShuriKenParticle=(function(){
	function VertexShuriKenParticle(){}
	__class(VertexShuriKenParticle,'laya.d3.graphics.Vertex.VertexShuriKenParticle');
	VertexShuriKenParticle.PARTICLE_CORNERTEXTURECOORDINATE0=0;
	VertexShuriKenParticle.PARTICLE_POSITION0=1;
	VertexShuriKenParticle.PARTICLE_COLOR0=2;
	VertexShuriKenParticle.PARTICLE_TEXTURECOORDINATE0=3;
	VertexShuriKenParticle.PARTICLE_SHAPEPOSITIONSTARTLIFETIME=4;
	VertexShuriKenParticle.PARTICLE_DIRECTIONTIME=5;
	VertexShuriKenParticle.PARTICLE_STARTCOLOR0=6;
	VertexShuriKenParticle.PARTICLE_ENDCOLOR0=7;
	VertexShuriKenParticle.PARTICLE_STARTSIZE=8;
	VertexShuriKenParticle.PARTICLE_STARTROTATION=9;
	VertexShuriKenParticle.PARTICLE_STARTSPEED=10;
	VertexShuriKenParticle.PARTICLE_RANDOM0=11;
	VertexShuriKenParticle.PARTICLE_RANDOM1=12;
	VertexShuriKenParticle.PARTICLE_SIMULATIONWORLDPOSTION=13;
	VertexShuriKenParticle.PARTICLE_SIMULATIONWORLDROTATION=14;
	return VertexShuriKenParticle;
})()


/**
*<code>SizeOverLifetime</code> 类用于粒子的生命周期尺寸。
*/
//class laya.d3.core.particleShuriKen.module.SizeOverLifetime
var SizeOverLifetime=(function(){
	function SizeOverLifetime(size){
		/**@private */
		this._size=null;
		/**是否启用*/
		this.enbale=false;
		this._size=size;
	}

	__class(SizeOverLifetime,'laya.d3.core.particleShuriKen.module.SizeOverLifetime');
	var __proto=SizeOverLifetime.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destSizeOverLifetime=destObject;
		this._size.cloneTo(destSizeOverLifetime._size);
		destSizeOverLifetime.enbale=this.enbale;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destSize;
		switch (this._size.type){
			case 0:
				if (this._size.separateAxes)
					destSize=GradientSize.createByGradientSeparate(this._size.gradientX.clone(),this._size.gradientY.clone(),this._size.gradientZ.clone());
				else
				destSize=GradientSize.createByGradient(this._size.gradient.clone());
				break ;
			case 1:
				if (this._size.separateAxes)
					destSize=GradientSize.createByRandomTwoConstantSeparate(this._size.constantMinSeparate.clone(),this._size.constantMaxSeparate.clone());
				else
				destSize=GradientSize.createByRandomTwoConstant(this._size.constantMin,this._size.constantMax);
				break ;
			case 2:
				if (this._size.separateAxes)
					destSize=GradientSize.createByRandomTwoGradientSeparate(this._size.gradientXMin.clone(),this._size.gradientYMin.clone(),this._size.gradientZMin.clone(),this._size.gradientXMax.clone(),this._size.gradientYMax.clone(),this._size.gradientZMax.clone());
				else
				destSize=GradientSize.createByRandomTwoGradient(this._size.gradientMin.clone(),this._size.gradientMax.clone());
				break ;
			};
		var destSizeOverLifetime=/*__JS__ */new this.constructor(destSize);
		destSizeOverLifetime.enbale=this.enbale;
		return destSizeOverLifetime;
	}

	/**
	*获取尺寸。
	*/
	__getset(0,__proto,'size',function(){
		return this._size;
	});

	return SizeOverLifetime;
})()


/**
*<code>KeyFrame</code> 类用于创建关键帧实例。
*/
//class laya.d3.core.Keyframe
var Keyframe=(function(){
	function Keyframe(){
		/**时间。*/
		this.time=NaN;
	}

	__class(Keyframe,'laya.d3.core.Keyframe');
	var __proto=Keyframe.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destKeyFrame=destObject;
		destKeyFrame.time=this.time;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var dest=/*__JS__ */new this.constructor();
		this.cloneTo(dest);
		return dest;
	}

	return Keyframe;
})()


/**
*<code>Vector4</code> 类用于创建四维向量。
*/
//class laya.d3.math.Vector4
var Vector4=(function(){
	function Vector4(x,y,z,w){
		/**X轴坐标*/
		this.x=NaN;
		/**Y轴坐标*/
		this.y=NaN;
		/**Z轴坐标*/
		this.z=NaN;
		/**W轴坐标*/
		this.w=NaN;
		(x===void 0)&& (x=0);
		(y===void 0)&& (y=0);
		(z===void 0)&& (z=0);
		(w===void 0)&& (w=0);
		this.x=x;
		this.y=y;
		this.z=z;
		this.w=w;
	}

	__class(Vector4,'laya.d3.math.Vector4');
	var __proto=Vector4.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*设置xyzw值。
	*@param x X值。
	*@param y Y值。
	*@param z Z值。
	*@param w W值。
	*/
	__proto.setValue=function(x,y,z,w){
		this.x=x;
		this.y=y;
		this.z=z;
		this.w=w;
	}

	/**
	*从Array数组拷贝值。
	*@param array 数组。
	*@param offset 数组偏移。
	*/
	__proto.fromArray=function(array,offset){
		(offset===void 0)&& (offset=0);
		this.x=array[offset+0];
		this.y=array[offset+1];
		this.z=array[offset+2];
		this.w=array[offset+3];
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destVector4=destObject;
		destVector4.x=this.x;
		destVector4.y=this.y;
		destVector4.z=this.z;
		destVector4.w=this.w;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destVector4=/*__JS__ */new this.constructor();
		this.cloneTo(destVector4);
		return destVector4;
	}

	/**
	*求四维向量的长度。
	*@return 长度。
	*/
	__proto.length=function(){
		return Math.sqrt(this.x *this.x+this.y *this.y+this.z *this.z+this.w *this.w);
	}

	/**
	*求四维向量长度的平方。
	*@return 长度的平方。
	*/
	__proto.lengthSquared=function(){
		return this.x *this.x+this.y *this.y+this.z *this.z+this.w *this.w;
	}

	__proto.forNativeElement=function(nativeElements){
		if (nativeElements){
			/*__JS__ */this.elements=nativeElements;
			/*__JS__ */this.elements[0]=this.x;
			/*__JS__ */this.elements[1]=this.y;
			/*__JS__ */this.elements[2]=this.z;
			/*__JS__ */this.elements[3]=this.w;
		}
		else{
			/*__JS__ */this.elements=new Float32Array([this.x,this.y,this.z,this.w]);
		}
		Vector2.rewriteNumProperty(this,"x",0);
		Vector2.rewriteNumProperty(this,"y",1);
		Vector2.rewriteNumProperty(this,"z",2);
		Vector2.rewriteNumProperty(this,"w",3);
	}

	Vector4.lerp=function(a,b,t,out){
		var ax=a.x,ay=a.y,az=a.z,aw=a.w;
		out.x=ax+t *(b.x-ax);
		out.y=ay+t *(b.y-ay);
		out.z=az+t *(b.z-az);
		out.w=aw+t *(b.w-aw);
	}

	Vector4.transformByM4x4=function(vector4,m4x4,out){
		var vx=vector4.x;
		var vy=vector4.y;
		var vz=vector4.z;
		var vw=vector4.w;
		var me=m4x4.elements;
		out.x=vx *me[0]+vy *me[4]+vz *me[8]+vw *me[12];
		out.y=vx *me[1]+vy *me[5]+vz *me[9]+vw *me[13];
		out.z=vx *me[2]+vy *me[6]+vz *me[10]+vw *me[14];
		out.w=vx *me[3]+vy *me[7]+vz *me[11]+vw *me[15];
	}

	Vector4.equals=function(a,b){
		return MathUtils3D.nearEqual(Math.abs(a.x),Math.abs(b.x))&& MathUtils3D.nearEqual(Math.abs(a.y),Math.abs(b.y))&& MathUtils3D.nearEqual(Math.abs(a.z),Math.abs(b.z))&& MathUtils3D.nearEqual(Math.abs(a.w),Math.abs(b.w));
	}

	Vector4.normalize=function(s,out){
		var len=/*if err,please use iflash.method.xmlLength()*/s.length();
		if (len > 0){
			out.x=s.x *len;
			out.y=s.y *len;
			out.z=s.z *len;
			out.w=s.w *len;
		}
	}

	Vector4.add=function(a,b,out){
		out.x=a.x+b.x;
		out.y=a.y+b.y;
		out.z=a.z+b.z;
		out.w=a.w+b.w;
	}

	Vector4.subtract=function(a,b,out){
		out.x=a.x-b.x;
		out.y=a.y-b.y;
		out.z=a.z-b.z;
		out.w=a.w-b.w;
	}

	Vector4.multiply=function(a,b,out){
		out.x=a.x *b.x;
		out.y=a.y *b.y;
		out.z=a.z *b.z;
		out.w=a.w *b.w;
	}

	Vector4.scale=function(a,b,out){
		out.x=a.x *b;
		out.y=a.y *b;
		out.z=a.z *b;
		out.w=a.w *b;
	}

	Vector4.Clamp=function(value,min,max,out){
		var x=value.x;
		var y=value.y;
		var z=value.z;
		var w=value.w;
		var mineX=min.x;
		var mineY=min.y;
		var mineZ=min.z;
		var mineW=min.w;
		var maxeX=max.x;
		var maxeY=max.y;
		var maxeZ=max.z;
		var maxeW=max.w;
		x=(x > maxeX)? maxeX :x;
		x=(x < mineX)? mineX :x;
		y=(y > maxeY)? maxeY :y;
		y=(y < mineY)? mineY :y;
		z=(z > maxeZ)? maxeZ :z;
		z=(z < mineZ)? mineZ :z;
		w=(w > maxeW)? maxeW :w;
		w=(w < mineW)? mineW :w;
		out.x=x;
		out.y=y;
		out.z=z;
		out.w=w;
	}

	Vector4.distanceSquared=function(value1,value2){
		var x=value1.x-value2.x;
		var y=value1.y-value2.y;
		var z=value1.z-value2.z;
		var w=value1.w-value2.w;
		return (x *x)+(y *y)+(z *z)+(w *w);
	}

	Vector4.distance=function(value1,value2){
		var x=value1.x-value2.x;
		var y=value1.y-value2.y;
		var z=value1.z-value2.z;
		var w=value1.w-value2.w;
		return Math.sqrt((x *x)+(y *y)+(z *z)+(w *w));
	}

	Vector4.dot=function(a,b){
		return (a.x *b.x)+(a.y *b.y)+(a.z *b.z)+(a.w *b.w);
	}

	Vector4.min=function(a,b,out){
		out.x=Math.min(a.x,b.x);
		out.y=Math.min(a.y,b.y);
		out.z=Math.min(a.z,b.z);
		out.w=Math.min(a.w,b.w);
	}

	Vector4.max=function(a,b,out){
		out.x=Math.max(a.x,b.x);
		out.y=Math.max(a.y,b.y);
		out.z=Math.max(a.z,b.z);
		out.w=Math.max(a.w,b.w);
	}

	__static(Vector4,
	['ZERO',function(){return this.ZERO=new Vector4();},'ONE',function(){return this.ONE=new Vector4(1.0,1.0,1.0,1.0);},'UnitX',function(){return this.UnitX=new Vector4(1.0,0.0,0.0,0.0);},'UnitY',function(){return this.UnitY=new Vector4(0.0,1.0,0.0,0.0);},'UnitZ',function(){return this.UnitZ=new Vector4(0.0,0.0,1.0,0.0);},'UnitW',function(){return this.UnitW=new Vector4(0.0,0.0,0.0,1.0);}
	]);
	return Vector4;
})()


/**
*@private
*/
//class laya.d3.shader.ShaderDefines
var ShaderDefines=(function(){
	function ShaderDefines(superDefines){
		/**@private */
		this._counter=0;
		/**@private [只读]*/
		this.defines={};
		if (superDefines){
			this._counter=superDefines._counter;
			for (var k in superDefines.defines)
			this.defines[k]=superDefines.defines[k];
		}
	}

	__class(ShaderDefines,'laya.d3.shader.ShaderDefines');
	var __proto=ShaderDefines.prototype;
	/**
	*@private
	*/
	__proto.registerDefine=function(name){
		var value=Math.pow(2,this._counter++);
		this.defines[value]=name;
		return value;
	}

	return ShaderDefines;
})()


/**
*<code>Vector3</code> 类用于创建三维向量。
*/
//class laya.d3.math.Vector3
var Vector3=(function(){
	function Vector3(x,y,z,nativeElements){
		/**X轴坐标*/
		this.x=NaN;
		/**Y轴坐标*/
		this.y=NaN;
		/**Z轴坐标*/
		this.z=NaN;
		(x===void 0)&& (x=0);
		(y===void 0)&& (y=0);
		(z===void 0)&& (z=0);
		this.x=x;
		this.y=y;
		this.z=z;
	}

	__class(Vector3,'laya.d3.math.Vector3');
	var __proto=Vector3.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*设置xyz值。
	*@param x X值。
	*@param y Y值。
	*@param z Z值。
	*/
	__proto.setValue=function(x,y,z){
		this.x=x;
		this.y=y;
		this.z=z;
	}

	/**
	*从Array数组拷贝值。
	*@param array 数组。
	*@param offset 数组偏移。
	*/
	__proto.fromArray=function(array,offset){
		(offset===void 0)&& (offset=0);
		this.x=array[offset+0];
		this.y=array[offset+1];
		this.z=array[offset+2];
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destVector3=destObject;
		destVector3.x=this.x;
		destVector3.y=this.y;
		destVector3.z=this.z;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destVector3=/*__JS__ */new this.constructor();
		this.cloneTo(destVector3);
		return destVector3;
	}

	__proto.toDefault=function(){
		this.x=0;
		this.y=0;
		this.z=0;
	}

	__proto.forNativeElement=function(nativeElements){
		if (nativeElements){
			/*__JS__ */this.elements=nativeElements;
			/*__JS__ */this.elements[0]=this.x;
			/*__JS__ */this.elements[1]=this.y;
			/*__JS__ */this.elements[2]=this.z;
		}
		else{
			/*__JS__ */this.elements=new Float32Array([this.x,this.y,this.z]);
		}
		Vector2.rewriteNumProperty(this,"x",0);
		Vector2.rewriteNumProperty(this,"y",1);
		Vector2.rewriteNumProperty(this,"z",2);
	}

	Vector3.distanceSquared=function(value1,value2){
		var x=value1.x-value2.x;
		var y=value1.y-value2.y;
		var z=value1.z-value2.z;
		return (x *x)+(y *y)+(z *z);
	}

	Vector3.distance=function(value1,value2){
		var x=value1.x-value2.x;
		var y=value1.y-value2.y;
		var z=value1.z-value2.z;
		return Math.sqrt((x *x)+(y *y)+(z *z));
	}

	Vector3.min=function(a,b,out){
		out.x=Math.min(a.x,b.x);
		out.y=Math.min(a.y,b.y);
		out.z=Math.min(a.z,b.z);
	}

	Vector3.max=function(a,b,out){
		out.x=Math.max(a.x,b.x);
		out.y=Math.max(a.y,b.y);
		out.z=Math.max(a.z,b.z);
	}

	Vector3.transformQuat=function(source,rotation,out){
		var x=source.x,y=source.y,z=source.z,qx=rotation.x,qy=rotation.y,qz=rotation.z,qw=rotation.w,
		ix=qw *x+qy *z-qz *y,iy=qw *y+qz *x-qx *z,iz=qw *z+qx *y-qy *x,iw=-qx *x-qy *y-qz *z;
		out.x=ix *qw+iw *-qx+iy *-qz-iz *-qy;
		out.y=iy *qw+iw *-qy+iz *-qx-ix *-qz;
		out.z=iz *qw+iw *-qz+ix *-qy-iy *-qx;
	}

	Vector3.scalarLength=function(a){
		var x=a.x,y=a.y,z=a.z;
		return Math.sqrt(x *x+y *y+z *z);
	}

	Vector3.scalarLengthSquared=function(a){
		var x=a.x,y=a.y,z=a.z;
		return x *x+y *y+z *z;
	}

	Vector3.normalize=function(s,out){
		var x=s.x,y=s.y,z=s.z;
		var len=x *x+y *y+z *z;
		if (len > 0){
			len=1 / Math.sqrt(len);
			out.x=s.x *len;
			out.y=s.y *len;
			out.z=s.z *len;
		}
	}

	Vector3.multiply=function(a,b,out){
		out.x=a.x *b.x;
		out.y=a.y *b.y;
		out.z=a.z *b.z;
	}

	Vector3.scale=function(a,b,out){
		out.x=a.x *b;
		out.y=a.y *b;
		out.z=a.z *b;
	}

	Vector3.lerp=function(a,b,t,out){
		var ax=a.x,ay=a.y,az=a.z;
		out.x=ax+t *(b.x-ax);
		out.y=ay+t *(b.y-ay);
		out.z=az+t *(b.z-az);
	}

	Vector3.transformV3ToV3=function(vector,transform,result){
		var intermediate=Vector3._tempVector4;
		Vector3.transformV3ToV4(vector,transform,intermediate);
		result.x=intermediate.x;
		result.y=intermediate.y;
		result.z=intermediate.z;
	}

	Vector3.transformV3ToV4=function(vector,transform,result){
		var vectorX=vector.x;
		var vectorY=vector.y;
		var vectorZ=vector.z;
		var transformElem=transform.elements;
		result.x=(vectorX *transformElem[0])+(vectorY *transformElem[4])+(vectorZ *transformElem[8])+transformElem[12];
		result.y=(vectorX *transformElem[1])+(vectorY *transformElem[5])+(vectorZ *transformElem[9])+transformElem[13];
		result.z=(vectorX *transformElem[2])+(vectorY *transformElem[6])+(vectorZ *transformElem[10])+transformElem[14];
		result.w=(vectorX *transformElem[3])+(vectorY *transformElem[7])+(vectorZ *transformElem[11])+transformElem[15];
	}

	Vector3.TransformNormal=function(normal,transform,result){
		var normalX=normal.x;
		var normalY=normal.y;
		var normalZ=normal.z;
		var transformElem=transform.elements;
		result.x=(normalX *transformElem[0])+(normalY *transformElem[4])+(normalZ *transformElem[8]);
		result.y=(normalX *transformElem[1])+(normalY *transformElem[5])+(normalZ *transformElem[9]);
		result.z=(normalX *transformElem[2])+(normalY *transformElem[6])+(normalZ *transformElem[10]);
	}

	Vector3.transformCoordinate=function(coordinate,transform,result){
		var coordinateX=coordinate.x;
		var coordinateY=coordinate.y;
		var coordinateZ=coordinate.z;
		var transformElem=transform.elements;
		var w=((coordinateX *transformElem[3])+(coordinateY *transformElem[7])+(coordinateZ *transformElem[11])+transformElem[15]);
		result.x=(coordinateX *transformElem[0])+(coordinateY *transformElem[4])+(coordinateZ *transformElem[8])+transformElem[12] / w;
		result.y=(coordinateX *transformElem[1])+(coordinateY *transformElem[5])+(coordinateZ *transformElem[9])+transformElem[13] / w;
		result.z=(coordinateX *transformElem[2])+(coordinateY *transformElem[6])+(coordinateZ *transformElem[10])+transformElem[14] / w;
	}

	Vector3.Clamp=function(value,min,max,out){
		var x=value.x;
		var y=value.y;
		var z=value.z;
		var mineX=min.x;
		var mineY=min.y;
		var mineZ=min.z;
		var maxeX=max.x;
		var maxeY=max.y;
		var maxeZ=max.z;
		x=(x > maxeX)? maxeX :x;
		x=(x < mineX)? mineX :x;
		y=(y > maxeY)? maxeY :y;
		y=(y < mineY)? mineY :y;
		z=(z > maxeZ)? maxeZ :z;
		z=(z < mineZ)? mineZ :z;
		out.x=x;
		out.y=y;
		out.z=z;
	}

	Vector3.add=function(a,b,out){
		out.x=a.x+b.x;
		out.y=a.y+b.y;
		out.z=a.z+b.z;
	}

	Vector3.subtract=function(a,b,o){
		o.x=a.x-b.x;
		o.y=a.y-b.y;
		o.z=a.z-b.z;
	}

	Vector3.cross=function(a,b,o){
		var ax=a.x,ay=a.y,az=a.z,bx=b.x,by=b.y,bz=b.z;
		o.x=ay *bz-az *by;
		o.y=az *bx-ax *bz;
		o.z=ax *by-ay *bx;
	}

	Vector3.dot=function(a,b){
		return (a.x *b.x)+(a.y *b.y)+(a.z *b.z);
	}

	Vector3.equals=function(a,b){
		return MathUtils3D.nearEqual(a.x,b.x)&& MathUtils3D.nearEqual(a.y,b.y)&& MathUtils3D.nearEqual(a.z,b.z);
	}

	Vector3._ZERO=new Vector3(0.0,0.0,0.0);
	Vector3._ONE=new Vector3(1.0,1.0,1.0);
	Vector3._NegativeUnitX=new Vector3(-1,0,0);
	Vector3._UnitX=new Vector3(1,0,0);
	Vector3._UnitY=new Vector3(0,1,0);
	Vector3._UnitZ=new Vector3(0,0,1);
	Vector3._ForwardRH=new Vector3(0,0,-1);
	Vector3._ForwardLH=new Vector3(0,0,1);
	Vector3._Up=new Vector3(0,1,0);
	__static(Vector3,
	['_tempVector4',function(){return this._tempVector4=new Vector4();}
	]);
	return Vector3;
})()


/**
*<code>Vector2</code> 类用于创建二维向量。
*/
//class laya.d3.math.Vector2
var Vector2=(function(){
	function Vector2(x,y){
		/**X轴坐标*/
		this.x=NaN;
		/**Y轴坐标*/
		this.y=NaN;
		(x===void 0)&& (x=0);
		(y===void 0)&& (y=0);
		this.x=x;
		this.y=y;
	}

	__class(Vector2,'laya.d3.math.Vector2');
	var __proto=Vector2.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*设置xy值。
	*@param x X值。
	*@param y Y值。
	*/
	__proto.setValue=function(x,y){
		this.x=x;
		this.y=y;
	}

	/**
	*从Array数组拷贝值。
	*@param array 数组。
	*@param offset 数组偏移。
	*/
	__proto.fromArray=function(array,offset){
		(offset===void 0)&& (offset=0);
		this.x=array[offset+0];
		this.y=array[offset+1];
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destVector2=destObject;
		destVector2.x=this.x;
		destVector2.y=this.y;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destVector2=/*__JS__ */new this.constructor();
		this.cloneTo(destVector2);
		return destVector2;
	}

	__proto.forNativeElement=function(nativeElements){
		if (nativeElements){
			/*__JS__ */this.elements=nativeElements;
			/*__JS__ */this.elements[0]=this.x;
			/*__JS__ */this.elements[1]=this.y;
		}
		else{
			/*__JS__ */this.elements=new Float32Array([this.x,this.y]);
		}
		Vector2.rewriteNumProperty(this,"x",0);
		Vector2.rewriteNumProperty(this,"y",1);
	}

	Vector2.scale=function(a,b,out){
		out.x=a.x *b;
		out.y=a.y *b;
	}

	Vector2.dot=function(a,b){
		return (a.x *b.x)+(a.y *b.y);
	}

	Vector2.normalize=function(s,out){
		var x=s.x,y=s.y;
		var len=x *x+y *y;
		if (len > 0){
			len=1 / Math.sqrt(len);
			out.x=x *len;
			out.y=y *len;
		}
	}

	Vector2.scalarLength=function(a){
		var x=a.x,y=a.y;
		return Math.sqrt(x *x+y *y);
	}

	Vector2.rewriteNumProperty=function(proto,name,index){
		Object["defineProperty"](proto,name,{
			"get":function (){
				return /*__JS__ */this.elements[index];
			},
			"set":function (v){
				/*__JS__ */this.elements[index]=v;
			}
		});
	}

	__static(Vector2,
	['ZERO',function(){return this.ZERO=new Vector2(0.0,0.0);},'ONE',function(){return this.ONE=new Vector2(1.0,1.0);}
	]);
	return Vector2;
})()


/**
*<code>AnimatorPlayState</code> 类用于创建动画播放状态信息。
*/
//class laya.d3.component.AnimatorPlayState
var AnimatorPlayState=(function(){
	function AnimatorPlayState(){
		/**@private */
		//this._finish=false;
		/**@private */
		//this._startPlayTime=NaN;
		/**@private */
		//this._lastElapsedTime=NaN;
		/**@private */
		//this._elapsedTime=NaN;
		/**@private */
		//this._normalizedTime=NaN;
		/**@private */
		//this._normalizedPlayTime=NaN;
		/**@private */
		//this._duration=NaN;
		/**@private */
		//this._playEventIndex=0;
		/**@private */
		//this._lastIsFront=false;
	}

	__class(AnimatorPlayState,'laya.d3.component.AnimatorPlayState');
	var __proto=AnimatorPlayState.prototype;
	/**
	*@private
	*/
	__proto._resetPlayState=function(startTime){
		this._finish=false;
		this._startPlayTime=startTime;
		this._elapsedTime=startTime;
		this._playEventIndex=0;
		this._lastIsFront=true;
	}

	/**
	*@private
	*/
	__proto._cloneTo=function(dest){
		dest._finish=this._finish;
		dest._startPlayTime=this._startPlayTime;
		dest._elapsedTime=this._elapsedTime;
		dest._playEventIndex=this._playEventIndex;
		dest._lastIsFront=this._lastIsFront;
	}

	/**
	*获取播放状态的归一化时间,整数为循环次数，小数为单次播放时间。
	*/
	__getset(0,__proto,'normalizedTime',function(){
		return this._normalizedTime;
	});

	/**
	*获取当前动画的持续时间，以秒为单位。
	*/
	__getset(0,__proto,'duration',function(){
		return this._duration;
	});

	return AnimatorPlayState;
})()


/**
*<code>VelocityOverLifetime</code> 类用于粒子的生命周期速度。
*/
//class laya.d3.core.particleShuriKen.module.VelocityOverLifetime
var VelocityOverLifetime=(function(){
	function VelocityOverLifetime(velocity){
		/**@private */
		this._velocity=null;
		/**是否启用*/
		this.enbale=false;
		/**速度空间,0为local,1为world。*/
		this.space=0;
		this._velocity=velocity;
	}

	__class(VelocityOverLifetime,'laya.d3.core.particleShuriKen.module.VelocityOverLifetime');
	var __proto=VelocityOverLifetime.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destVelocityOverLifetime=destObject;
		this._velocity.cloneTo(destVelocityOverLifetime._velocity);
		destVelocityOverLifetime.enbale=this.enbale;
		destVelocityOverLifetime.space=this.space;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destVelocity;
		switch(this._velocity.type){
			case 0:
				destVelocity=GradientVelocity.createByConstant(this._velocity.constant.clone());
				break ;
			case 1:
				destVelocity=GradientVelocity.createByGradient(this._velocity.gradientX.clone(),this._velocity.gradientY.clone(),this._velocity.gradientZ.clone());
				break ;
			case 2:
				destVelocity=GradientVelocity.createByRandomTwoConstant(this._velocity.constantMin.clone(),this._velocity.constantMax.clone());
				break ;
			case 3:
				destVelocity=GradientVelocity.createByRandomTwoGradient(this._velocity.gradientXMin.clone(),this._velocity.gradientYMin.clone(),this._velocity.gradientZMin.clone(),this._velocity.gradientXMax.clone(),this._velocity.gradientYMax.clone(),this._velocity.gradientZMax.clone());
				break ;
			};
		var destVelocityOverLifetime=/*__JS__ */new this.constructor(destVelocity);
		destVelocityOverLifetime.enbale=this.enbale;
		destVelocityOverLifetime.space=this.space;
		return destVelocityOverLifetime;
	}

	/**
	*获取尺寸。
	*/
	__getset(0,__proto,'velocity',function(){
		return this._velocity;
	});

	return VelocityOverLifetime;
})()


/**
*...
*@author ...
*/
//class laya.d3.loaders.MeshReader
var MeshReader=(function(){
	function MeshReader(){}
	__class(MeshReader,'laya.d3.loaders.MeshReader');
	MeshReader.read=function(data,mesh,subMeshes){
		var readData=new Byte(data);
		readData.pos=0;
		var version=readData.readUTFString();
		switch (version){
			case "LAYAMODEL:0301":
			case "LAYAMODEL:0400":
			case "LAYAMODEL:0401":
				LoadModelV04.parse(readData,version,mesh,subMeshes);
				break ;
			case "LAYAMODEL:05":
			case "LAYAMODEL:COMPRESSION_05":
				LoadModelV05.parse(readData,version,mesh,subMeshes);
				break ;
			default :
				throw new Error("MeshReader: unknown mesh version.");
			}
		mesh._setSubMeshes(subMeshes);
	}

	return MeshReader;
})()


/**
*...
*@author ...
*/
//class laya.d3.core.scene.SceneManager
var SceneManager=(function(){
	function SceneManager(){}
	__class(SceneManager,'laya.d3.core.scene.SceneManager');
	return SceneManager;
})()


/**
*<code>ContainmentType</code> 类用于定义空间物体位置关系。
*/
//class laya.d3.math.ContainmentType
var ContainmentType=(function(){
	function ContainmentType(){}
	__class(ContainmentType,'laya.d3.math.ContainmentType');
	ContainmentType.Disjoint=0;
	ContainmentType.Contains=1;
	ContainmentType.Intersects=2;
	return ContainmentType;
})()


/**
*@private
*<code>LoadModelV05</code> 类用于模型加载。
*/
//class laya.d3.loaders.LoadModelV05
var LoadModelV05=(function(){
	function LoadModelV05(){}
	__class(LoadModelV05,'laya.d3.loaders.LoadModelV05');
	LoadModelV05.parse=function(readData,version,mesh,subMeshes){
		LoadModelV05._mesh=mesh;
		LoadModelV05._subMeshes=subMeshes;
		LoadModelV05._version=version;
		LoadModelV05._readData=readData;
		LoadModelV05.READ_DATA();
		LoadModelV05.READ_BLOCK();
		LoadModelV05.READ_STRINGS();
		for (var i=0,n=LoadModelV05._BLOCK.count;i < n;i++){
			LoadModelV05._readData.pos=LoadModelV05._BLOCK.blockStarts[i];
			var index=LoadModelV05._readData.getUint16();
			var blockName=LoadModelV05._strings[index];
			var fn=LoadModelV05["READ_"+blockName];
			if (fn==null)
				throw new Error("model file err,no this function:"+index+" "+blockName);
			else
			fn.call(null);
		}
		LoadModelV05._mesh._bindPoseIndices=new Uint16Array(LoadModelV05._bindPoseIndices);
		LoadModelV05._bindPoseIndices.length=0;
		LoadModelV05._strings.length=0;
		LoadModelV05._readData=null;
		LoadModelV05._version=null;
		LoadModelV05._mesh=null;
		LoadModelV05._subMeshes=null;
	}

	LoadModelV05._readString=function(){
		return LoadModelV05._strings[LoadModelV05._readData.getUint16()];
	}

	LoadModelV05.READ_DATA=function(){
		LoadModelV05._DATA.offset=LoadModelV05._readData.getUint32();
		LoadModelV05._DATA.size=LoadModelV05._readData.getUint32();
	}

	LoadModelV05.READ_BLOCK=function(){
		var count=LoadModelV05._BLOCK.count=LoadModelV05._readData.getUint16();
		var blockStarts=LoadModelV05._BLOCK.blockStarts=[];
		var blockLengths=LoadModelV05._BLOCK.blockLengths=[];
		for (var i=0;i < count;i++){
			blockStarts.push(LoadModelV05._readData.getUint32());
			blockLengths.push(LoadModelV05._readData.getUint32());
		}
	}

	LoadModelV05.READ_STRINGS=function(){
		var offset=LoadModelV05._readData.getUint32();
		var count=LoadModelV05._readData.getUint16();
		var prePos=LoadModelV05._readData.pos;
		LoadModelV05._readData.pos=offset+LoadModelV05._DATA.offset;
		for (var i=0;i < count;i++)
		LoadModelV05._strings[i]=LoadModelV05._readData.readUTFString();
		LoadModelV05._readData.pos=prePos;
	}

	LoadModelV05.READ_MESH=function(){
		var i=0,n=0;
		var memorySize=0;
		var name=LoadModelV05._readString();
		var arrayBuffer=LoadModelV05._readData.__getBuffer();
		var vertexBufferCount=LoadModelV05._readData.getInt16();
		var offset=LoadModelV05._DATA.offset;
		for (i=0;i < vertexBufferCount;i++){
			var vbStart=offset+LoadModelV05._readData.getUint32();
			var vertexCount=LoadModelV05._readData.getUint32();
			var vertexFlag=LoadModelV05._readString();
			var vertexDeclaration=VertexMesh.getVertexDeclaration(vertexFlag,false);
			var vertexStride=vertexDeclaration.vertexStride;
			var vertexData=new ArrayBuffer(vertexStride *vertexCount);
			var floatData=new Float32Array(vertexData);
			var subVertexFlags=vertexFlag.split(",");
			var subVertexCount=subVertexFlags.length;
			switch (LoadModelV05._version){
				case "LAYAMODEL:05":
					floatData=new Float32Array(arrayBuffer.slice(vbStart,vbStart+vertexCount *vertexStride));
					break ;
				case "LAYAMODEL:COMPRESSION_05":;
					var lastPosition=LoadModelV05._readData.pos;
					floatData=new Float32Array(vertexData);
					var uint8Data=new Uint8Array(vertexData);
					LoadModelV05._readData.pos=vbStart;
					for (var j=0;j < vertexCount;j++){
						var subOffset=0;
						var verOffset=j *vertexStride;
						for (var k=0;k < subVertexCount;k++){
						switch (subVertexFlags[k]){
							case "POSITION":
								subOffset=verOffset / 4;
								floatData[subOffset]=HalfFloatUtils.convertToNumber(LoadModelV05._readData.getUint16());
								floatData[subOffset+1]=HalfFloatUtils.convertToNumber(LoadModelV05._readData.getUint16());
								floatData[subOffset+2]=HalfFloatUtils.convertToNumber(LoadModelV05._readData.getUint16());
								verOffset+=12;
								break ;
							case "NORMAL":
								subOffset=verOffset / 4;
								floatData[subOffset]=LoadModelV05._readData.getUint8()/ 127.5-1;
								floatData[subOffset+1]=LoadModelV05._readData.getUint8()/ 127.5-1;
								floatData[subOffset+2]=LoadModelV05._readData.getUint8()/ 127.5-1;
								verOffset+=12;
								break ;
							case "COLOR":
								subOffset=verOffset / 4;
								floatData[subOffset]=LoadModelV05._readData.getUint8()/ 255;
								floatData[subOffset+1]=LoadModelV05._readData.getUint8()/ 255;
								floatData[subOffset+2]=LoadModelV05._readData.getUint8()/ 255;
								floatData[subOffset+3]=LoadModelV05._readData.getUint8()/ 255;
								verOffset+=16;
								break ;
							case "UV":
								subOffset=verOffset / 4;
								floatData[subOffset]=HalfFloatUtils.convertToNumber(LoadModelV05._readData.getUint16());
								floatData[subOffset+1]=HalfFloatUtils.convertToNumber(LoadModelV05._readData.getUint16());
								verOffset+=8;
								break ;
							case "UV1":
								subOffset=verOffset / 4;
								floatData[subOffset]=HalfFloatUtils.convertToNumber(LoadModelV05._readData.getUint16());
								floatData[subOffset+1]=HalfFloatUtils.convertToNumber(LoadModelV05._readData.getUint16());
								verOffset+=8;
								break ;
							case "BLENDWEIGHT":
								subOffset=verOffset / 4;
								floatData[subOffset]=LoadModelV05._readData.getUint8()/ 255;
								floatData[subOffset+1]=LoadModelV05._readData.getUint8()/ 255;
								floatData[subOffset+2]=LoadModelV05._readData.getUint8()/ 255;
								floatData[subOffset+3]=LoadModelV05._readData.getUint8()/ 255;
								verOffset+=16;
								break ;
							case "BLENDINDICES":
								uint8Data[verOffset]=LoadModelV05._readData.getUint8();
								uint8Data[verOffset+1]=LoadModelV05._readData.getUint8();
								uint8Data[verOffset+2]=LoadModelV05._readData.getUint8();
								uint8Data[verOffset+3]=LoadModelV05._readData.getUint8();
								verOffset+=4;
								break ;
							case "TANGENT":
								subOffset=verOffset / 4;
								floatData[subOffset]=LoadModelV05._readData.getUint8()/ 127.5-1;
								floatData[subOffset+1]=LoadModelV05._readData.getUint8()/ 127.5-1;
								floatData[subOffset+2]=LoadModelV05._readData.getUint8()/ 127.5-1;
								floatData[subOffset+3]=LoadModelV05._readData.getUint8()/ 127.5-1;
								verOffset+=16;
								break ;
							}
					}
				}
				LoadModelV05._readData.pos=lastPosition;
				break ;
			};
			var vertexBuffer=new VertexBuffer3D(vertexData.byteLength,/*laya.webgl.WebGLContext.STATIC_DRAW*/0x88E4,true);
			vertexBuffer.vertexDeclaration=vertexDeclaration;
			vertexBuffer.setData(floatData);
			LoadModelV05._mesh._vertexBuffers.push(vertexBuffer);
			LoadModelV05._mesh._vertexCount+=vertexBuffer.vertexCount;
			memorySize+=floatData.length *4;
		};
		var ibStart=offset+LoadModelV05._readData.getUint32();
		var ibLength=LoadModelV05._readData.getUint32();
		var ibDatas=new Uint16Array(arrayBuffer.slice(ibStart,ibStart+ibLength));
		var indexBuffer=new IndexBuffer3D(/*laya.d3.graphics.IndexBuffer3D.INDEXTYPE_USHORT*/"ushort",ibLength / 2,/*laya.webgl.WebGLContext.STATIC_DRAW*/0x88E4,true);
		indexBuffer.setData(ibDatas);
		LoadModelV05._mesh._indexBuffer=indexBuffer;
		LoadModelV05._mesh._setBuffer(LoadModelV05._mesh._vertexBuffers,indexBuffer);
		memorySize+=indexBuffer.indexCount *2;
		LoadModelV05._mesh._setCPUMemory(memorySize);
		LoadModelV05._mesh._setGPUMemory(memorySize);
		var boneNames=LoadModelV05._mesh._boneNames=[];
		var boneCount=LoadModelV05._readData.getUint16();
		boneNames.length=boneCount;
		for (i=0;i < boneCount;i++)
		boneNames[i]=LoadModelV05._strings[LoadModelV05._readData.getUint16()];
		var bindPoseDataStart=LoadModelV05._readData.getUint32();
		var bindPoseDataLength=LoadModelV05._readData.getUint32();
		var bindPoseDatas=new Float32Array(arrayBuffer.slice(offset+bindPoseDataStart,offset+bindPoseDataStart+bindPoseDataLength));
		var bindPoseFloatCount=bindPoseDatas.length;
		var bindPoseCount=bindPoseFloatCount / 16;
		var bindPoseBuffer=LoadModelV05._mesh._inverseBindPosesBuffer=new ArrayBuffer(bindPoseFloatCount *4);
		LoadModelV05._mesh._inverseBindPoses=__newvec(bindPoseCount);
		for (i=0;i < bindPoseFloatCount;i+=16){
			var inverseGlobalBindPose=new Matrix4x4(bindPoseDatas[i+0],bindPoseDatas[i+1],bindPoseDatas[i+2],bindPoseDatas[i+3],bindPoseDatas[i+4],bindPoseDatas[i+5],bindPoseDatas[i+6],bindPoseDatas[i+7],bindPoseDatas[i+8],bindPoseDatas[i+9],bindPoseDatas[i+10],bindPoseDatas[i+11],bindPoseDatas[i+12],bindPoseDatas[i+13],bindPoseDatas[i+14],bindPoseDatas[i+15],new Float32Array(bindPoseBuffer,i *4,16));
			LoadModelV05._mesh._inverseBindPoses[i / 16]=inverseGlobalBindPose;
		}
		return true;
	}

	LoadModelV05.READ_SUBMESH=function(){
		var arrayBuffer=LoadModelV05._readData.__getBuffer();
		var submesh=new SubMesh(LoadModelV05._mesh);
		var vbIndex=LoadModelV05._readData.getInt16();
		var ibStart=LoadModelV05._readData.getUint32();
		var ibCount=LoadModelV05._readData.getUint32();
		var indexBuffer=LoadModelV05._mesh._indexBuffer;
		submesh._indexBuffer=indexBuffer;
		submesh._indexStart=ibStart;
		submesh._indexCount=ibCount;
		submesh._indices=new Uint16Array(indexBuffer.getData().buffer,ibStart *2,ibCount);
		var vertexBuffer=LoadModelV05._mesh._vertexBuffers[vbIndex];
		submesh._vertexBuffer=vertexBuffer;
		var offset=LoadModelV05._DATA.offset;
		var subIndexBufferStart=submesh._subIndexBufferStart;
		var subIndexBufferCount=submesh._subIndexBufferCount;
		var boneIndicesList=submesh._boneIndicesList;
		var drawCount=LoadModelV05._readData.getUint16();
		subIndexBufferStart.length=drawCount;
		subIndexBufferCount.length=drawCount;
		boneIndicesList.length=drawCount;
		var pathMarks=LoadModelV05._mesh._skinDataPathMarks;
		var bindPoseIndices=LoadModelV05._bindPoseIndices;
		var subMeshIndex=LoadModelV05._subMeshes.length;
		for (var i=0;i < drawCount;i++){
			subIndexBufferStart[i]=LoadModelV05._readData.getUint32();
			subIndexBufferCount[i]=LoadModelV05._readData.getUint32();
			var boneDicofs=LoadModelV05._readData.getUint32();
			var boneDicCount=LoadModelV05._readData.getUint32();
			var boneIndices=boneIndicesList[i]=new Uint16Array(arrayBuffer.slice(offset+boneDicofs,offset+boneDicofs+boneDicCount));
			for (var j=0,m=boneIndices.length;j < m;j++){
				var index=boneIndices[j];
				var combineIndex=bindPoseIndices.indexOf(index);
				if (combineIndex===-1){
					boneIndices[j]=bindPoseIndices.length;
					bindPoseIndices.push(index);
					pathMarks.push([subMeshIndex,i,j]);
					}else {
					boneIndices[j]=combineIndex;
				}
			}
		}
		LoadModelV05._subMeshes.push(submesh);
		return true;
	}

	LoadModelV05._strings=[];
	LoadModelV05._readData=null;
	LoadModelV05._version=null;
	LoadModelV05._mesh=null;
	LoadModelV05._subMeshes=null;
	LoadModelV05._bindPoseIndices=[];
	__static(LoadModelV05,
	['_BLOCK',function(){return this._BLOCK={count:0};},'_DATA',function(){return this._DATA={offset:0,size:0};}
	]);
	return LoadModelV05;
})()


/**
*<code>Color</code> 类用于创建颜色实例。
*/
//class laya.d3.math.Color
var Color=(function(){
	function Color(r,g,b,a){
		/**red分量*/
		this.r=NaN;
		/**green分量*/
		this.g=NaN;
		/**blue分量*/
		this.b=NaN;
		/**alpha分量*/
		this.a=NaN;
		(r===void 0)&& (r=1);
		(g===void 0)&& (g=1);
		(b===void 0)&& (b=1);
		(a===void 0)&& (a=1);
		this.r=r;
		this.g=g;
		this.b=b;
		this.a=a;
	}

	__class(Color,'laya.d3.math.Color');
	var __proto=Color.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*Gamma空间转换到线性空间。
	*@param linear 线性空间颜色。
	*/
	__proto.toLinear=function(out){
		out.r=Utils3D.gammaToLinearSpace(this.r);
		out.g=Utils3D.gammaToLinearSpace(this.g);
		out.b=Utils3D.gammaToLinearSpace(this.b);
	}

	/**
	*线性空间转换到Gamma空间。
	*@param gamma Gamma空间颜色。
	*/
	__proto.toGamma=function(out){
		out.r=Utils3D.linearToGammaSpace(this.r);
		out.g=Utils3D.linearToGammaSpace(this.g);
		out.b=Utils3D.linearToGammaSpace(this.b);
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destColor=destObject;
		destColor.r=this.r;
		destColor.g=this.g;
		destColor.b=this.b;
		destColor.a=this.a;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var dest=/*__JS__ */new this.constructor();
		this.cloneTo(dest);
		return dest;
	}

	__proto.forNativeElement=function(nativeElements){
		if (nativeElements){
			/*__JS__ */this.elements=nativeElements;
			/*__JS__ */this.elements[0]=this.r;
			/*__JS__ */this.elements[1]=this.g;
			/*__JS__ */this.elements[2]=this.b;
			/*__JS__ */this.elements[3]=this.a;
			}else {
			/*__JS__ */this.elements=new Float32Array([this.r,this.g,this.b,this.a]);
		}
		Vector2.rewriteNumProperty(this,"r",0);
		Vector2.rewriteNumProperty(this,"g",1);
		Vector2.rewriteNumProperty(this,"b",2);
		Vector2.rewriteNumProperty(this,"a",3);
	}

	__static(Color,
	['RED',function(){return this.RED=new Color(1,0,0,1);},'GREEN',function(){return this.GREEN=new Color(0,1,0,1);},'BLUE',function(){return this.BLUE=new Color(0,0,1,1);},'CYAN',function(){return this.CYAN=new Color(0,1,1,1);},'YELLOW',function(){return this.YELLOW=new Color(1,0.92,0.016,1);},'MAGENTA',function(){return this.MAGENTA=new Color(1,0,1,1);},'GRAY',function(){return this.GRAY=new Color(0.5,0.5,0.5,1);},'WHITE',function(){return this.WHITE=new Color(1,1,1,1);},'BLACK',function(){return this.BLACK=new Color(0,0,0,1);}
	]);
	return Color;
})()


/**
*@private
*<code>LoadModel</code> 类用于模型加载。
*/
//class laya.d3.loaders.LoadModelV04
var LoadModelV04=(function(){
	function LoadModelV04(){}
	__class(LoadModelV04,'laya.d3.loaders.LoadModelV04');
	LoadModelV04.parse=function(readData,version,mesh,subMeshes){
		LoadModelV04._mesh=mesh;
		LoadModelV04._subMeshes=subMeshes;
		LoadModelV04._version=version;
		LoadModelV04._readData=readData;
		LoadModelV04.READ_DATA();
		LoadModelV04.READ_BLOCK();
		LoadModelV04.READ_STRINGS();
		for (var i=0,n=LoadModelV04._BLOCK.count;i < n;i++){
			LoadModelV04._readData.pos=LoadModelV04._BLOCK.blockStarts[i];
			var index=LoadModelV04._readData.getUint16();
			var blockName=LoadModelV04._strings[index];
			var fn=LoadModelV04["READ_"+blockName];
			if (fn==null)
				throw new Error("model file err,no this function:"+index+" "+blockName);
			else
			fn.call(null);
		}
		LoadModelV04._mesh._bindPoseIndices=new Uint16Array(LoadModelV04._bindPoseIndices);
		LoadModelV04._bindPoseIndices.length=0;
		LoadModelV04._strings.length=0;
		LoadModelV04._readData=null;
		LoadModelV04._version=null;
		LoadModelV04._mesh=null;
		LoadModelV04._subMeshes=null;
	}

	LoadModelV04._readString=function(){
		return LoadModelV04._strings[LoadModelV04._readData.getUint16()];
	}

	LoadModelV04.READ_DATA=function(){
		LoadModelV04._DATA.offset=LoadModelV04._readData.getUint32();
		LoadModelV04._DATA.size=LoadModelV04._readData.getUint32();
	}

	LoadModelV04.READ_BLOCK=function(){
		var count=LoadModelV04._BLOCK.count=LoadModelV04._readData.getUint16();
		var blockStarts=LoadModelV04._BLOCK.blockStarts=[];
		var blockLengths=LoadModelV04._BLOCK.blockLengths=[];
		for (var i=0;i < count;i++){
			blockStarts.push(LoadModelV04._readData.getUint32());
			blockLengths.push(LoadModelV04._readData.getUint32());
		}
	}

	LoadModelV04.READ_STRINGS=function(){
		var offset=LoadModelV04._readData.getUint32();
		var count=LoadModelV04._readData.getUint16();
		var prePos=LoadModelV04._readData.pos;
		LoadModelV04._readData.pos=offset+LoadModelV04._DATA.offset;
		for (var i=0;i < count;i++)
		LoadModelV04._strings[i]=LoadModelV04._readData.readUTFString();
		LoadModelV04._readData.pos=prePos;
	}

	LoadModelV04.READ_MESH=function(){
		var name=LoadModelV04._readString();
		var arrayBuffer=LoadModelV04._readData.__getBuffer();
		var i=0,n=0;
		var memorySize=0;
		var vertexBufferCount=LoadModelV04._readData.getInt16();
		var offset=LoadModelV04._DATA.offset;
		for (i=0;i < vertexBufferCount;i++){
			var vbStart=offset+LoadModelV04._readData.getUint32();
			var vbLength=LoadModelV04._readData.getUint32();
			var vbDatas=new Float32Array(arrayBuffer.slice(vbStart,vbStart+vbLength));
			var bufferAttribute=LoadModelV04._readString();
			var vertexDeclaration;
			switch (LoadModelV04._version){
				case "LAYAMODEL:0301":
				case "LAYAMODEL:0400":
					vertexDeclaration=VertexMesh.getVertexDeclaration(bufferAttribute);
					break ;
				case "LAYAMODEL:0401":
					vertexDeclaration=VertexMesh.getVertexDeclaration(bufferAttribute,false);
					break ;
				default :
					throw new Error("LoadModelV03: unknown version.");
				}
			if (!vertexDeclaration)
				throw new Error("LoadModelV03: unknown vertexDeclaration.");
			var vertexBuffer=new VertexBuffer3D(vbDatas.length *4,/*laya.webgl.WebGLContext.STATIC_DRAW*/0x88E4,true);
			vertexBuffer.vertexDeclaration=vertexDeclaration;
			vertexBuffer.setData(vbDatas);
			LoadModelV04._mesh._vertexBuffers.push(vertexBuffer);
			LoadModelV04._mesh._vertexCount+=vertexBuffer.vertexCount;
			memorySize+=vbDatas.length *4;
		};
		var ibStart=offset+LoadModelV04._readData.getUint32();
		var ibLength=LoadModelV04._readData.getUint32();
		var ibDatas=new Uint16Array(arrayBuffer.slice(ibStart,ibStart+ibLength));
		var indexBuffer=new IndexBuffer3D(/*laya.d3.graphics.IndexBuffer3D.INDEXTYPE_USHORT*/"ushort",ibLength / 2,/*laya.webgl.WebGLContext.STATIC_DRAW*/0x88E4,true);
		indexBuffer.setData(ibDatas);
		LoadModelV04._mesh._indexBuffer=indexBuffer;
		memorySize+=indexBuffer.indexCount *2;
		LoadModelV04._mesh._setBuffer(LoadModelV04._mesh._vertexBuffers,indexBuffer);
		LoadModelV04._mesh._setCPUMemory(memorySize);
		LoadModelV04._mesh._setGPUMemory(memorySize);
		var boneNames=LoadModelV04._mesh._boneNames=[];
		var boneCount=LoadModelV04._readData.getUint16();
		boneNames.length=boneCount;
		for (i=0;i < boneCount;i++)
		boneNames[i]=LoadModelV04._strings[LoadModelV04._readData.getUint16()];
		LoadModelV04._readData.pos+=8;
		var bindPoseDataStart=LoadModelV04._readData.getUint32();
		var bindPoseDataLength=LoadModelV04._readData.getUint32();
		var bindPoseDatas=new Float32Array(arrayBuffer.slice(offset+bindPoseDataStart,offset+bindPoseDataStart+bindPoseDataLength));
		var bindPoseFloatCount=bindPoseDatas.length;
		var bindPoseCount=bindPoseFloatCount / 16;
		var bindPoseBuffer=LoadModelV04._mesh._inverseBindPosesBuffer=new ArrayBuffer(bindPoseFloatCount *4);
		LoadModelV04._mesh._inverseBindPoses=__newvec(bindPoseCount);
		for (i=0;i < bindPoseFloatCount;i+=16){
			var inverseGlobalBindPose=new Matrix4x4(bindPoseDatas[i+0],bindPoseDatas[i+1],bindPoseDatas[i+2],bindPoseDatas[i+3],bindPoseDatas[i+4],bindPoseDatas[i+5],bindPoseDatas[i+6],bindPoseDatas[i+7],bindPoseDatas[i+8],bindPoseDatas[i+9],bindPoseDatas[i+10],bindPoseDatas[i+11],bindPoseDatas[i+12],bindPoseDatas[i+13],bindPoseDatas[i+14],bindPoseDatas[i+15],new Float32Array(bindPoseBuffer,i *4,16));
			LoadModelV04._mesh._inverseBindPoses[i / 16]=inverseGlobalBindPose;
		}
		return true;
	}

	LoadModelV04.READ_SUBMESH=function(){
		var arrayBuffer=LoadModelV04._readData.__getBuffer();
		var submesh=new SubMesh(LoadModelV04._mesh);
		var vbIndex=LoadModelV04._readData.getInt16();
		LoadModelV04._readData.getUint32();
		LoadModelV04._readData.getUint32();
		var ibStart=LoadModelV04._readData.getUint32();
		var ibCount=LoadModelV04._readData.getUint32();
		var indexBuffer=LoadModelV04._mesh._indexBuffer;
		submesh._indexBuffer=indexBuffer;
		submesh._indexStart=ibStart;
		submesh._indexCount=ibCount;
		submesh._indices=new Uint16Array(indexBuffer.getData().buffer,ibStart *2,ibCount);
		var vertexBuffer=LoadModelV04._mesh._vertexBuffers[vbIndex];
		submesh._vertexBuffer=vertexBuffer;
		var offset=LoadModelV04._DATA.offset;
		var subIndexBufferStart=submesh._subIndexBufferStart;
		var subIndexBufferCount=submesh._subIndexBufferCount;
		var boneIndicesList=submesh._boneIndicesList;
		var drawCount=LoadModelV04._readData.getUint16();
		subIndexBufferStart.length=drawCount;
		subIndexBufferCount.length=drawCount;
		boneIndicesList.length=drawCount;
		var pathMarks=LoadModelV04._mesh._skinDataPathMarks;
		var bindPoseIndices=LoadModelV04._bindPoseIndices;
		var subMeshIndex=LoadModelV04._subMeshes.length;
		for (var i=0;i < drawCount;i++){
			subIndexBufferStart[i]=LoadModelV04._readData.getUint32();
			subIndexBufferCount[i]=LoadModelV04._readData.getUint32();
			var boneDicofs=LoadModelV04._readData.getUint32();
			var boneDicCount=LoadModelV04._readData.getUint32();
			var boneIndices=boneIndicesList[i]=new Uint16Array(arrayBuffer.slice(offset+boneDicofs,offset+boneDicofs+boneDicCount));
			for (var j=0,m=boneIndices.length;j < m;j++){
				var index=boneIndices[j];
				var combineIndex=bindPoseIndices.indexOf(index);
				if (combineIndex===-1){
					boneIndices[j]=bindPoseIndices.length;
					bindPoseIndices.push(index);
					pathMarks.push([subMeshIndex,i,j]);
					}else {
					boneIndices[j]=combineIndex;
				}
			}
		}
		LoadModelV04._subMeshes.push(submesh);
		return true;
	}

	LoadModelV04._strings=[];
	LoadModelV04._readData=null;
	LoadModelV04._version=null;
	LoadModelV04._mesh=null;
	LoadModelV04._subMeshes=null;
	LoadModelV04._bindPoseIndices=[];
	__static(LoadModelV04,
	['_BLOCK',function(){return this._BLOCK={count:0};},'_DATA',function(){return this._DATA={offset:0,size:0};}
	]);
	return LoadModelV04;
})()


/**
*...
*@author ...
*/
//class laya.d3.graphics.Vertex.VertexMesh
var VertexMesh=(function(){
	function VertexMesh(){}
	__class(VertexMesh,'laya.d3.graphics.Vertex.VertexMesh');
	VertexMesh.getVertexDeclaration=function(vertexFlag,compatible){
		(compatible===void 0)&& (compatible=true);
		var verDec=VertexMesh._vertexDeclarationMap[vertexFlag+(compatible?"_0":"_1")];
		if (!verDec){
			var subFlags=vertexFlag.split(",");
			var offset=0;
			var elements=[];
			for (var i=0,n=subFlags.length;i < n;i++){
				var element;
				switch (subFlags[i]){
					case "POSITION":
						element=new VertexElement(offset,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*CLASS CONST:laya.d3.graphics.Vertex.VertexMesh.MESH_POSITION0*/0);
						offset+=12;
						break ;
					case "NORMAL":
						element=new VertexElement(offset,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*CLASS CONST:laya.d3.graphics.Vertex.VertexMesh.MESH_NORMAL0*/3);
						offset+=12;
						break ;
					case "COLOR":
						element=new VertexElement(offset,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*CLASS CONST:laya.d3.graphics.Vertex.VertexMesh.MESH_COLOR0*/1);
						offset+=16;
						break ;
					case "UV":
						element=new VertexElement(offset,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*CLASS CONST:laya.d3.graphics.Vertex.VertexMesh.MESH_TEXTURECOORDINATE0*/2);
						offset+=8;
						break ;
					case "UV1":
						element=new VertexElement(offset,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*CLASS CONST:laya.d3.graphics.Vertex.VertexMesh.MESH_TEXTURECOORDINATE1*/7);
						offset+=8;
						break ;
					case "BLENDWEIGHT":
						element=new VertexElement(offset,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*CLASS CONST:laya.d3.graphics.Vertex.VertexMesh.MESH_BLENDWEIGHT0*/6);
						offset+=16;
						break ;
					case "BLENDINDICES":
						if (compatible){
							element=new VertexElement(offset,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*CLASS CONST:laya.d3.graphics.Vertex.VertexMesh.MESH_BLENDINDICES0*/5);
							offset+=16;
							}else {
							element=new VertexElement(offset,/*laya.d3.graphics.VertexElementFormat.Byte4*/"byte4",/*CLASS CONST:laya.d3.graphics.Vertex.VertexMesh.MESH_BLENDINDICES0*/5);
							offset+=4;
						}
						break ;
					case "TANGENT":
						element=new VertexElement(offset,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*CLASS CONST:laya.d3.graphics.Vertex.VertexMesh.MESH_TANGENT0*/4);
						offset+=16;
						break ;
					default :
						throw "VertexMesh: unknown vertex flag.";
					}
				elements.push(element);
			}
			verDec=new VertexDeclaration(offset,elements);
			VertexMesh._vertexDeclarationMap[vertexFlag+(compatible?"_0":"_1")]=verDec;
		}
		return verDec;
	}

	VertexMesh.MESH_POSITION0=0;
	VertexMesh.MESH_COLOR0=1;
	VertexMesh.MESH_TEXTURECOORDINATE0=2;
	VertexMesh.MESH_NORMAL0=3;
	VertexMesh.MESH_TANGENT0=4;
	VertexMesh.MESH_BLENDINDICES0=5;
	VertexMesh.MESH_BLENDWEIGHT0=6;
	VertexMesh.MESH_TEXTURECOORDINATE1=7;
	VertexMesh.MESH_WORLDMATRIX_ROW0=8;
	VertexMesh.MESH_WORLDMATRIX_ROW1=9;
	VertexMesh.MESH_WORLDMATRIX_ROW2=10;
	VertexMesh.MESH_WORLDMATRIX_ROW3=11;
	VertexMesh.MESH_MVPMATRIX_ROW0=12;
	VertexMesh.MESH_MVPMATRIX_ROW1=13;
	VertexMesh.MESH_MVPMATRIX_ROW2=14;
	VertexMesh.MESH_MVPMATRIX_ROW3=15;
	VertexMesh._vertexDeclarationMap={};
	__static(VertexMesh,
	['instanceWorldMatrixDeclaration',function(){return this.instanceWorldMatrixDeclaration=new VertexDeclaration(64,
		[new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*CLASS CONST:laya.d3.graphics.Vertex.VertexMesh.MESH_WORLDMATRIX_ROW0*/8),
		new VertexElement(16,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*CLASS CONST:laya.d3.graphics.Vertex.VertexMesh.MESH_WORLDMATRIX_ROW1*/9),
		new VertexElement(32,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*CLASS CONST:laya.d3.graphics.Vertex.VertexMesh.MESH_WORLDMATRIX_ROW2*/10),
		new VertexElement(48,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*CLASS CONST:laya.d3.graphics.Vertex.VertexMesh.MESH_WORLDMATRIX_ROW3*/11)]);},'instanceMVPMatrixDeclaration',function(){return this.instanceMVPMatrixDeclaration=new VertexDeclaration(64,
		[new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*CLASS CONST:laya.d3.graphics.Vertex.VertexMesh.MESH_MVPMATRIX_ROW0*/12),
		new VertexElement(16,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*CLASS CONST:laya.d3.graphics.Vertex.VertexMesh.MESH_MVPMATRIX_ROW1*/13),
		new VertexElement(32,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*CLASS CONST:laya.d3.graphics.Vertex.VertexMesh.MESH_MVPMATRIX_ROW2*/14),
		new VertexElement(48,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*CLASS CONST:laya.d3.graphics.Vertex.VertexMesh.MESH_MVPMATRIX_ROW3*/15)]);}
	]);
	return VertexMesh;
})()


/**
*<code>Emission</code> 类用于粒子发射器。
*/
//class laya.d3.core.particleShuriKen.module.Emission
var Emission=(function(){
	function Emission(){
		/**@private */
		this._destroyed=false;
		/**@private 粒子发射速率,每秒发射的个数。*/
		this._emissionRate=0;
		/**@private 粒子的爆裂,不允许修改。*/
		this._bursts=null;
		/**是否启用。*/
		this.enbale=false;
		this._destroyed=false;
		this.emissionRate=10;
		this._bursts=[];
	}

	__class(Emission,'laya.d3.core.particleShuriKen.module.Emission');
	var __proto=Emission.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true,"laya.resource.IDestroy":true})
	/**
	*@private
	*/
	__proto.destroy=function(){
		this._bursts=null;
		this._destroyed=true;
	}

	/**
	*获取粒子爆裂个数。
	*@return 粒子爆裂个数。
	*/
	__proto.getBurstsCount=function(){
		return this._bursts.length;
	}

	/**
	*通过索引获取粒子爆裂。
	*@param index 爆裂索引。
	*@return 粒子爆裂。
	*/
	__proto.getBurstByIndex=function(index){
		return this._bursts[index];
	}

	/**
	*增加粒子爆裂。
	*@param burst 爆裂。
	*/
	__proto.addBurst=function(burst){
		var burstsCount=this._bursts.length;
		if (burstsCount > 0)
			for (var i=0;i < burstsCount;i++){
			if (this._bursts[i].time > burst.time)
				this._bursts.splice(i,0,burst);
		}
		this._bursts.push(burst);
	}

	/**
	*移除粒子爆裂。
	*@param burst 爆裂。
	*/
	__proto.removeBurst=function(burst){
		var index=this._bursts.indexOf(burst);
		if (index!==-1){
			this._bursts.splice(index,1);
		}
	}

	/**
	*通过索引移除粒子爆裂。
	*@param index 爆裂索引。
	*/
	__proto.removeBurstByIndex=function(index){
		this._bursts.splice(index,1);
	}

	/**
	*清空粒子爆裂。
	*/
	__proto.clearBurst=function(){
		this._bursts.length=0;
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destEmission=destObject;
		var destBursts=destEmission._bursts;
		destBursts.length=this._bursts.length;
		for (var i=0,n=this._bursts.length;i < n;i++){
			var destBurst=destBursts[i];
			if (destBurst)
				this._bursts[i].cloneTo(destBurst);
			else
			destBursts[i]=this._bursts[i].clone();
		}
		destEmission._emissionRate=this._emissionRate;
		destEmission.enbale=this.enbale;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destEmission=/*__JS__ */new this.constructor();
		this.cloneTo(destEmission);
		return destEmission;
	}

	/**
	*获取是否已销毁。
	*@return 是否已销毁。
	*/
	__getset(0,__proto,'destroyed',function(){
		return this._destroyed;
	});

	/**
	*设置粒子发射速率。
	*@param emissionRate 粒子发射速率 (个/秒)。
	*/
	/**
	*获取粒子发射速率。
	*@return 粒子发射速率 (个/秒)。
	*/
	__getset(0,__proto,'emissionRate',function(){
		return this._emissionRate;
		},function(value){
		if (value < 0)
			throw new Error("ParticleBaseShape:emissionRate value must large or equal than 0.");
		this._emissionRate=value;
	});

	return Emission;
})()


/**
*<code>BoundSphere</code> 类用于创建包围球。
*/
//class laya.d3.math.BoundSphere
var BoundSphere=(function(){
	function BoundSphere(center,radius){
		/**包围球的中心。*/
		this.center=null;
		/**包围球的半径。*/
		this.radius=NaN;
		this.center=center;
		this.radius=radius;
	}

	__class(BoundSphere,'laya.d3.math.BoundSphere');
	var __proto=BoundSphere.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	__proto.toDefault=function(){
		this.center.toDefault();
		this.radius=0;
	}

	/**
	*判断射线是否与碰撞球交叉，并返回交叉距离。
	*@param ray 射线。
	*@return 距离交叉点的距离，-1表示不交叉。
	*/
	__proto.intersectsRayDistance=function(ray){
		return CollisionUtils.intersectsRayAndSphereRD(ray,this);
	}

	/**
	*判断射线是否与碰撞球交叉，并返回交叉点。
	*@param ray 射线。
	*@param outPoint 交叉点。
	*@return 距离交叉点的距离，-1表示不交叉。
	*/
	__proto.intersectsRayPoint=function(ray,outPoint){
		return CollisionUtils.intersectsRayAndSphereRP(ray,this,outPoint);
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var dest=destObject;
		this.center.cloneTo(dest.center);
		dest.radius=this.radius;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var dest=/*__JS__ */new this.constructor(new Vector3(),new Vector3());
		this.cloneTo(dest);
		return dest;
	}

	BoundSphere.createFromSubPoints=function(points,start,count,out){
		if (points==null){
			throw new Error("points");
		}
		if (start < 0 || start >=points.length){
			throw new Error("start"+start+"Must be in the range [0, "+(points.length-1)+"]");
		}
		if (count < 0 || (start+count)> points.length){
			throw new Error("count"+count+"Must be in the range <= "+points.length+"}");
		};
		var upperEnd=start+count;
		var center=BoundSphere._tempVector3;
		center.x=0;
		center.y=0;
		center.z=0;
		for (var i=start;i < upperEnd;++i){
			Vector3.add(points[i],center,center);
		};
		var outCenter=out.center;
		Vector3.scale(center,1 / count,outCenter);
		var radius=0.0;
		for (i=start;i < upperEnd;++i){
			var distance=Vector3.distanceSquared(outCenter,points[i]);
			if (distance > radius)
				radius=distance;
		}
		out.radius=Math.sqrt(radius);
	}

	BoundSphere.createfromPoints=function(points,out){
		if (points==null){
			throw new Error("points");
		}
		BoundSphere.createFromSubPoints(points,0,points.length,out);
	}

	__static(BoundSphere,
	['_tempVector3',function(){return this._tempVector3=new Vector3();}
	]);
	return BoundSphere;
})()


/**
*@private
*<code>RenderElement</code> 类用于实现渲染元素。
*/
//class laya.d3.core.render.RenderElement
var RenderElement=(function(){
	function RenderElement(){
		/**@private */
		//this._transform=null;
		/**@private */
		//this._geometry=null;
		/**@private */
		//this.material=null;
		/**@private */
		//this.render=null;
		/**@private */
		//this.staticBatch=null;
		this.renderType=/*CLASS CONST:laya.d3.core.render.RenderElement.RENDERTYPE_NORMAL*/0;
	}

	__class(RenderElement,'laya.d3.core.render.RenderElement');
	var __proto=RenderElement.prototype;
	/**
	*@private
	*/
	__proto.setTransform=function(transform){
		this._transform=transform;
	}

	/**
	*@private
	*/
	__proto.setGeometry=function(geometry){
		this._geometry=geometry;
	}

	/**
	*@private
	*/
	__proto.addToOpaqueRenderQueue=function(context,queue){
		queue.elements.push(this);
	}

	/**
	*@private
	*/
	__proto.addToTransparentRenderQueue=function(context,queue){
		queue.elements.push(this);
		queue.lastTransparentBatched=false;
		queue.lastTransparentRenderElement=this;
	}

	/**
	*@private
	*/
	__proto._render=function(context,isTarget,customShader,replacementTag){
		var lastStateMaterial,lastStateShaderInstance,lastStateRender;
		var updateMark=Camera._updateMark;
		var scene=context.scene;
		var camera=context.camera;
		var transform=this._transform;
		var geometry=this._geometry;
		context.renderElement=this;
		var updateRender=updateMark!==this.render._updateMark || this.renderType!==this.render._updateRenderType;
		if (updateRender){
			this.render._renderUpdate(context,transform);
			this.render._renderUpdateWithCamera(context,transform);
			this.render._updateMark=updateMark;
			this.render._updateRenderType=this.renderType;
		}
		if (geometry._prepareRender(context)){
			var subShader=this.material._shader.getSubShaderAt(0);
			var passes;
			if (customShader){
				if (replacementTag){
					var oriTag=subShader.getFlag(replacementTag);
					if (oriTag){
						var customSubShaders=customShader._subShaders;
						for (var k=0,p=customSubShaders.length;k < p;k++){
							var customSubShader=customSubShaders[k];
							if (oriTag===customSubShader.getFlag(replacementTag)){
								passes=customSubShader._passes;
								break ;
							}
						}
						if (!passes)
							return;
						}else {
						return;
					}
					}else {
					passes=customShader.getSubShaderAt(0)._passes;
				}
				}else {
				passes=subShader._passes;
			}
			for (var j=0,m=passes.length;j < m;j++){
				var shaderPass=context.shader=passes[j].withCompile((scene._defineDatas.value)& (~this.material._disablePublicDefineDatas.value),this.render._defineDatas.value,this.material._defineDatas.value);
				var switchShader=shaderPass.bind();
				var switchUpdateMark=(updateMark!==shaderPass._uploadMark);
				var uploadScene=(shaderPass._uploadScene!==scene)|| switchUpdateMark;
				if (uploadScene || switchShader){
					shaderPass.uploadUniforms(shaderPass._sceneUniformParamsMap,scene._shaderValues,uploadScene);
					shaderPass._uploadScene=scene;
				};
				var uploadSprite3D=(shaderPass._uploadRender!==this.render || shaderPass._uploadRenderType!==this.renderType)|| switchUpdateMark;
				if (uploadSprite3D || switchShader){
					shaderPass.uploadUniforms(shaderPass._spriteUniformParamsMap,this.render._shaderValues,uploadSprite3D);
					shaderPass._uploadRender=this.render;
					shaderPass._uploadRenderType=this.renderType;
				};
				var uploadCamera=shaderPass._uploadCamera!==camera || switchUpdateMark;
				if (uploadCamera || switchShader){
					shaderPass.uploadUniforms(shaderPass._cameraUniformParamsMap,camera._shaderValues,uploadCamera);
					shaderPass._uploadCamera=camera;
				};
				var uploadMaterial=(shaderPass._uploadMaterial!==this.material)|| switchUpdateMark;
				if (uploadMaterial || switchShader){
					shaderPass.uploadUniforms(shaderPass._materialUniformParamsMap,this.material._shaderValues,uploadMaterial);
					shaderPass._uploadMaterial=this.material;
				};
				var matValues=this.material._shaderValues;
				if (lastStateMaterial!==this.material||lastStateShaderInstance!==shaderPass){
					shaderPass.uploadRenderStateBlendDepth(matValues);
					shaderPass.uploadRenderStateFrontFace(matValues,isTarget,transform);
					lastStateMaterial=this.material;
					lastStateShaderInstance=shaderPass;
					lastStateRender=this.render;
					}else {
					if (lastStateRender!==this.render){
						shaderPass.uploadRenderStateFrontFace(matValues,isTarget,transform);
						lastStateRender=this.render;
					}
				}
				geometry._render(context);
				shaderPass._uploadMark=updateMark;
			}
		}
		if (updateRender && this.renderType!==/*CLASS CONST:laya.d3.core.render.RenderElement.RENDERTYPE_NORMAL*/0)
			this.render._revertBatchRenderUpdate(context);
		Camera._updateMark++;
	}

	/**
	*@private
	*/
	__proto.destroy=function(){
		this._transform=null;
		this._geometry=null;
		this.material=null;
		this.render=null;
	}

	RenderElement.RENDERTYPE_NORMAL=0;
	RenderElement.RENDERTYPE_STATICBATCH=1;
	RenderElement.RENDERTYPE_INSTANCEBATCH=2;
	RenderElement.RENDERTYPE_VERTEXBATCH=3;
	return RenderElement;
})()


/**
*<code>HalfFloatUtils</code> 类用于创建HalfFloat工具。
*/
//class laya.d3.math.HalfFloatUtils
var HalfFloatUtils=(function(){
	function HalfFloatUtils(){}
	__class(HalfFloatUtils,'laya.d3.math.HalfFloatUtils');
	HalfFloatUtils.__init__=function(){
		for (var i=0;i < 256;++i){
			var e=i-127;
			if (e <-27){
				HalfFloatUtils._baseTable[i | 0x000]=0x0000;
				HalfFloatUtils._baseTable[i | 0x100]=0x8000;
				HalfFloatUtils._shiftTable[i | 0x000]=24;
				HalfFloatUtils._shiftTable[i | 0x100]=24;
				}else if (e <-14){
				HalfFloatUtils._baseTable[i | 0x000]=0x0400 >> (-e-14);
				HalfFloatUtils._baseTable[i | 0x100]=(0x0400 >> (-e-14))| 0x8000;
				HalfFloatUtils._shiftTable[i | 0x000]=-e-1;
				HalfFloatUtils._shiftTable[i | 0x100]=-e-1;
				}else if (e <=15){
				HalfFloatUtils._baseTable[i | 0x000]=(e+15)<< 10;
				HalfFloatUtils._baseTable[i | 0x100]=((e+15)<< 10)| 0x8000;
				HalfFloatUtils._shiftTable[i | 0x000]=13;
				HalfFloatUtils._shiftTable[i | 0x100]=13;
				}else if (e < 128){
				HalfFloatUtils._baseTable[i | 0x000]=0x7c00;
				HalfFloatUtils._baseTable[i | 0x100]=0xfc00;
				HalfFloatUtils._shiftTable[i | 0x000]=24;
				HalfFloatUtils._shiftTable[i | 0x100]=24;
				}else {
				HalfFloatUtils._baseTable[i | 0x000]=0x7c00;
				HalfFloatUtils._baseTable[i | 0x100]=0xfc00;
				HalfFloatUtils._shiftTable[i | 0x000]=13;
				HalfFloatUtils._shiftTable[i | 0x100]=13;
			}
		}
		HalfFloatUtils._mantissaTable[0]=0;
		for (i=1;i < 1024;++i){
			var m=i << 13;
			e=0;
			while ((m & 0x00800000)===0){
				e-=0x00800000;
				m <<=1;
			}
			m &=~0x00800000;
			e+=0x38800000;
			HalfFloatUtils._mantissaTable[i]=m | e;
		}
		for (i=1024;i < 2048;++i){
			HalfFloatUtils._mantissaTable[i]=0x38000000+((i-1024)<< 13);
		}
		HalfFloatUtils._exponentTable[0]=0;
		for (i=1;i < 31;++i){
			HalfFloatUtils._exponentTable[i]=i << 23;
		}
		HalfFloatUtils._exponentTable[31]=0x47800000;
		HalfFloatUtils._exponentTable[32]=0x80000000;
		for (i=33;i < 63;++i){
			HalfFloatUtils._exponentTable[i]=0x80000000+((i-32)<< 23);
		}
		HalfFloatUtils._exponentTable[63]=0xc7800000;
		HalfFloatUtils._offsetTable[0]=0;
		for (i=1;i < 64;++i){
			if (i===32){
				HalfFloatUtils._offsetTable[i]=0;
				}else {
				HalfFloatUtils._offsetTable[i]=1024;
			}
		}
	}

	HalfFloatUtils.roundToFloat16Bits=function(num){
		HalfFloatUtils._floatView[0]=num;
		var f=HalfFloatUtils._uint32View[0];
		var e=(f >> 23)& 0x1ff;
		return HalfFloatUtils._baseTable[e]+((f & 0x007fffff)>> HalfFloatUtils._shiftTable[e]);
	}

	HalfFloatUtils.convertToNumber=function(float16bits){
		var m=float16bits >> 10;
		HalfFloatUtils._uint32View[0]=HalfFloatUtils._mantissaTable[HalfFloatUtils._offsetTable[m]+(float16bits & 0x3ff)]+HalfFloatUtils._exponentTable[m];
		return HalfFloatUtils._floatView[0];
	}

	__static(HalfFloatUtils,
	['_buffer',function(){return this._buffer=new ArrayBuffer(4);},'_floatView',function(){return this._floatView=new Float32Array(HalfFloatUtils._buffer);},'_uint32View',function(){return this._uint32View=new Uint32Array(HalfFloatUtils._buffer);},'_baseTable',function(){return this._baseTable=new Uint32Array(512);},'_shiftTable',function(){return this._shiftTable=new Uint32Array(512);},'_mantissaTable',function(){return this._mantissaTable=new Uint32Array(2048);},'_exponentTable',function(){return this._exponentTable=new Uint32Array(64);},'_offsetTable',function(){return this._offsetTable=new Uint32Array(64);}
	]);
	return HalfFloatUtils;
})()


/**
*<code>SkyMesh</code> 类用于实现天空网格。
*/
//class laya.d3.resource.models.SkyMesh
var SkyMesh=(function(){
	function SkyMesh(){
		/**@private */
		this._vertexBuffer=null;
		/**@private */
		this._indexBuffer=null;
		/**@private */
		this._bufferState=null;
	}

	__class(SkyMesh,'laya.d3.resource.models.SkyMesh');
	var __proto=SkyMesh.prototype;
	/**
	*@private
	*/
	__proto._render=function(state){}
	return SkyMesh;
})()


/**
*<code>TextureSheetAnimation</code> 类用于创建粒子帧动画。
*/
//class laya.d3.core.particleShuriKen.module.TextureSheetAnimation
var TextureSheetAnimation=(function(){
	function TextureSheetAnimation(frame,startFrame){
		/**@private */
		this._frame=null;
		/**@private */
		this._startFrame=null;
		/**纹理平铺。*/
		this.tiles=null;
		/**类型,0为whole sheet、1为singal row。*/
		this.type=0;
		/**是否随机行，type为1时有效。*/
		this.randomRow=false;
		/**行索引,type为1时有效。*/
		this.rowIndex=0;
		/**循环次数。*/
		this.cycles=0;
		/**UV通道类型,0为Noting,1为Everything,待补充,暂不支持。*/
		this.enableUVChannels=0;
		/**是否启用*/
		this.enable=false;
		this.tiles=new Vector2(1,1);
		this.type=0;
		this.randomRow=true;
		this.rowIndex=0;
		this.cycles=1;
		this.enableUVChannels=1;
		this._frame=frame;
		this._startFrame=startFrame;
	}

	__class(TextureSheetAnimation,'laya.d3.core.particleShuriKen.module.TextureSheetAnimation');
	var __proto=TextureSheetAnimation.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destTextureSheetAnimation=destObject;
		this.tiles.cloneTo(destTextureSheetAnimation.tiles);
		destTextureSheetAnimation.type=this.type;
		destTextureSheetAnimation.randomRow=this.randomRow;
		this._frame.cloneTo(destTextureSheetAnimation._frame);
		this._startFrame.cloneTo(destTextureSheetAnimation._startFrame);
		destTextureSheetAnimation.cycles=this.cycles;
		destTextureSheetAnimation.enableUVChannels=this.enableUVChannels;
		destTextureSheetAnimation.enable=this.enable;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destFrame;
		switch (this._frame.type){
			case 0:
				destFrame=FrameOverTime.createByConstant(this._frame.constant);
				break ;
			case 1:
				destFrame=FrameOverTime.createByOverTime(this._frame.frameOverTimeData.clone());
				break ;
			case 2:
				destFrame=FrameOverTime.createByRandomTwoConstant(this._frame.constantMin,this._frame.constantMax);
				break ;
			case 3:
				destFrame=FrameOverTime.createByRandomTwoOverTime(this._frame.frameOverTimeDataMin.clone(),this._frame.frameOverTimeDataMax.clone());
				break ;
			};
		var destStartFrame;
		switch (this._startFrame.type){
			case 0:
				destStartFrame=StartFrame.createByConstant(this._startFrame.constant);
				break ;
			case 1:
				destStartFrame=StartFrame.createByRandomTwoConstant(this._startFrame.constantMin,this._startFrame.constantMax);
				break ;
			};
		var destTextureSheetAnimation=/*__JS__ */new this.constructor(destFrame,destStartFrame);
		this.tiles.cloneTo(destTextureSheetAnimation.tiles);
		destTextureSheetAnimation.type=this.type;
		destTextureSheetAnimation.randomRow=this.randomRow;
		destTextureSheetAnimation.cycles=this.cycles;
		destTextureSheetAnimation.enableUVChannels=this.enableUVChannels;
		destTextureSheetAnimation.enable=this.enable;
		return destTextureSheetAnimation;
	}

	/**获取时间帧率。*/
	__getset(0,__proto,'frame',function(){
		return this._frame;
	});

	/**获取开始帧率。*/
	__getset(0,__proto,'startFrame',function(){
		return this._startFrame;
	});

	return TextureSheetAnimation;
})()


/**
*...
*@author
*/
//class laya.d3.resource.TextureGenerator
var TextureGenerator=(function(){
	function TextureGenerator(){}
	__class(TextureGenerator,'laya.d3.resource.TextureGenerator');
	TextureGenerator.lightAttenTexture=function(x,y,maxX,maxY,index,data){
		var sqrRange=x / maxX;
		var atten=1.0 / (1.0+25.0 *sqrRange);
		if (sqrRange >=0.64){
			if (sqrRange > 1.0){
				atten=0;
				}else {
				atten *=1-(sqrRange-0.64)/ (1-0.64);
			}
		}
		data[index]=Math.floor(atten *255.0+0.5);
	}

	TextureGenerator.haloTexture=function(x,y,maxX,maxY,index,data){
		maxX >>=1;
		maxY >>=1;
		var xFac=(x-maxX)/ maxX;
		var yFac=(y-maxY)/ maxY;
		var sqrRange=xFac *xFac+yFac *yFac;
		if (sqrRange > 1.0){
			sqrRange=1.0;
		}
		data[index]=Math.floor((1.0-sqrRange)*255.0+0.5);
	}

	TextureGenerator._generateTexture2D=function(texture,textureWidth,textureHeight,func){
		var index=0;
		var size=0;
		switch (texture.format){
			case /*laya.resource.BaseTexture.FORMAT_R8G8B8*/0:
				size=3;
				break ;
			case /*laya.resource.BaseTexture.FORMAT_R8G8B8A8*/1:
				size=4;
				break ;
			case /*laya.resource.BaseTexture.FORMAT_ALPHA8*/2:
				size=1;
				break ;
			default :
				throw "GeneratedTexture._generateTexture: unkonw texture format.";
			};
		var data=new Uint8Array(textureWidth *textureHeight *size);
		for (var y=0;y < textureHeight;y++){
			for (var x=0;x < textureWidth;x++){
				func(x,y,textureWidth,textureHeight,index,data);
				index+=size;
			}
		}
		texture.setPixels(data);
	}

	return TextureGenerator;
})()


/**
*<code>Shader3D</code> 类用于创建Shader3D。
*/
//class laya.d3.shader.Shader3D
var Shader3D=(function(){
	function Shader3D(name,attributeMap,uniformMap,enableInstancing){
		/**@private */
		this._attributeMap=null;
		/**@private */
		this._uniformMap=null;
		/**@private */
		//this._name=null;
		/**@private */
		this._enableInstancing=false;
		this._subShaders=[];
		this._name=name;
		this._attributeMap=attributeMap;
		this._uniformMap=uniformMap;
		this._enableInstancing=enableInstancing;
	}

	__class(Shader3D,'laya.d3.shader.Shader3D');
	var __proto=Shader3D.prototype;
	/**
	*添加子着色器。
	*@param 子着色器。
	*/
	__proto.addSubShader=function(subShader){
		this._subShaders.push(subShader);
		subShader._owner=this;
	}

	/**
	*在特定索引获取子着色器。
	*@param index 索引。
	*@return 子着色器。
	*/
	__proto.getSubShaderAt=function(index){
		return this._subShaders[index];
	}

	Shader3D.propertyNameToID=function(name){
		if (Shader3D._propertyNameMap[name] !=null){
			return Shader3D._propertyNameMap[name];
			}else {
			var id=Shader3D._propertyNameCounter++;
			Shader3D._propertyNameMap[name]=id;
			return id;
		}
	}

	Shader3D.addInclude=function(fileName,txt){
		ShaderCompile.addInclude(fileName,txt);
	}

	Shader3D.registerPublicDefine=function(name){
		var value=Math.pow(2,Shader3D._publicCounter++);
		Shader3D._globleDefines[value]=name;
		return value;
	}

	Shader3D.compileShader=function(name,subShaderIndex,passIndex,publicDefine,spriteDefine,materialDefine){
		var shader=laya.d3.shader.Shader3D.find(name);
		if (shader){
			var subShader=shader.getSubShaderAt(subShaderIndex);
			if (subShader){
				var pass=subShader._passes[passIndex];
				if (pass){
					if (WebGL.shaderHighPrecision)
						pass.withCompile(publicDefine,spriteDefine,materialDefine);
					else
					pass.withCompile(publicDefine-laya.d3.shader.Shader3D.SHADERDEFINE_HIGHPRECISION,spriteDefine,materialDefine);
					}else {
					console.warn("Shader3D: unknown passIndex.");
				}
				}else {
				console.warn("Shader3D: unknown subShaderIndex.");
			}
			}else {
			console.warn("Shader3D: unknown shader name.");
		}
	}

	Shader3D.add=function(name,attributeMap,uniformMap,enableInstancing){
		(enableInstancing===void 0)&& (enableInstancing=false);
		return laya.d3.shader.Shader3D._preCompileShader[name]=new Shader3D(name,attributeMap,uniformMap,enableInstancing);
	}

	Shader3D.find=function(name){
		return laya.d3.shader.Shader3D._preCompileShader[name];
	}

	Shader3D.RENDER_STATE_CULL=0;
	Shader3D.RENDER_STATE_BLEND=1;
	Shader3D.RENDER_STATE_BLEND_SRC=2;
	Shader3D.RENDER_STATE_BLEND_DST=3;
	Shader3D.RENDER_STATE_BLEND_SRC_RGB=4;
	Shader3D.RENDER_STATE_BLEND_DST_RGB=5;
	Shader3D.RENDER_STATE_BLEND_SRC_ALPHA=6;
	Shader3D.RENDER_STATE_BLEND_DST_ALPHA=7;
	Shader3D.RENDER_STATE_BLEND_CONST_COLOR=8;
	Shader3D.RENDER_STATE_BLEND_EQUATION=9;
	Shader3D.RENDER_STATE_BLEND_EQUATION_RGB=10;
	Shader3D.RENDER_STATE_BLEND_EQUATION_ALPHA=11;
	Shader3D.RENDER_STATE_DEPTH_TEST=12;
	Shader3D.RENDER_STATE_DEPTH_WRITE=13;
	Shader3D.PERIOD_CUSTOM=0;
	Shader3D.PERIOD_MATERIAL=1;
	Shader3D.PERIOD_SPRITE=2;
	Shader3D.PERIOD_CAMERA=3;
	Shader3D.PERIOD_SCENE=4;
	Shader3D.SHADERDEFINE_HIGHPRECISION=0;
	Shader3D._propertyNameCounter=0;
	Shader3D._propertyNameMap={};
	Shader3D._publicCounter=0;
	Shader3D._globleDefines=[];
	Shader3D._preCompileShader={};
	Shader3D.debugMode=false;
	return Shader3D;
})()


/**
*<code>Rand</code> 类用于通过32位无符号整型随机种子创建随机数。
*/
//class laya.d3.math.Rand
var Rand=(function(){
	function Rand(seed){
		this._temp=new Uint32Array(1);
		this.seeds=new Uint32Array(4);
		this.seeds[0]=seed;
		this.seeds[1]=this.seeds[0] *0x6C078965+1;
		this.seeds[2]=this.seeds[1] *0x6C078965+1;
		this.seeds[3]=this.seeds[2] *0x6C078965+1;
	}

	__class(Rand,'laya.d3.math.Rand');
	var __proto=Rand.prototype;
	/**
	*获取无符号32位整形随机数。
	*@return 无符号32位整形随机数。
	*/
	__proto.getUint=function(){
		this._temp[0]=this.seeds[0] ^ (this.seeds[0] << 11);
		this.seeds[0]=this.seeds[1];
		this.seeds[1]=this.seeds[2];
		this.seeds[2]=this.seeds[3];
		this.seeds[3]=(this.seeds[3] ^ (this.seeds[3] >>> 19))^ (this._temp[0] ^ (this._temp[0] >>> 8));
		return this.seeds[3];
	}

	/**
	*获取0到1之间的浮点随机数。
	*@return 0到1之间的浮点随机数。
	*/
	__proto.getFloat=function(){
		this.getUint();
		return (this.seeds[3] & 0x007FFFFF)*(1.0 / 8388607.0);
	}

	/**
	*获取-1到1之间的浮点随机数。
	*@return-1到1之间的浮点随机数。
	*/
	__proto.getSignedFloat=function(){
		return this.getFloat()*2.0-1.0;
	}

	/**
	*设置随机种子。
	*@param seed 随机种子。
	*/
	/**
	*获取随机种子。
	*@return 随机种子。
	*/
	__getset(0,__proto,'seed',function(){
		return this.seeds[0];
		},function(seed){
		this.seeds[0]=seed;
		this.seeds[1]=this.seeds[0] *0x6C078965+1;
		this.seeds[2]=this.seeds[1] *0x6C078965+1;
		this.seeds[3]=this.seeds[2] *0x6C078965+1;
	});

	Rand.getFloatFromInt=function(v){
		return (v & 0x007FFFFF)*(1.0 / 8388607.0)
	}

	Rand.getByteFromInt=function(v){
		return (v & 0x007FFFFF)>>> 15;
	}

	return Rand;
})()


/**
*...
*@author ...
*/
//class laya.d3.shadowMap.ParallelSplitShadowMap
var ParallelSplitShadowMap=(function(){
	function ParallelSplitShadowMap(){
		/**@private */
		//this.lastNearPlane=NaN;
		/**@private */
		//this.lastFieldOfView=NaN;
		/**@private */
		//this.lastAspectRatio=NaN;
		/**@private */
		this._currentPSSM=-1;
		/**@private */
		this._shadowMapCount=3;
		/**@private */
		this._maxDistance=200.0;
		/**@private */
		this._ratioOfDistance=1.0 / this._shadowMapCount;
		/**@private */
		this._statesDirty=true;
		/**@private */
		//this.cameras=null;
		/**@private */
		this._shadowMapTextureSize=1024;
		/**@private */
		this._scene=null;
		/**@private */
		this._PCFType=0;
		/**@private */
		this._shaderValueLightVP=null;
		/**@private */
		//this._shaderValueVPs=null;
		this._spiltDistance=new Array(/*CLASS CONST:laya.d3.shadowMap.ParallelSplitShadowMap.MAX_PSSM_COUNT*/3+1);
		this._globalParallelLightDir=new Vector3(0,-1,0);
		this._boundingSphere=new Array(/*CLASS CONST:laya.d3.shadowMap.ParallelSplitShadowMap.MAX_PSSM_COUNT*/3+1);
		this._boundingBox=new Array(/*CLASS CONST:laya.d3.shadowMap.ParallelSplitShadowMap.MAX_PSSM_COUNT*/3+1);
		this._frustumPos=new Array((/*CLASS CONST:laya.d3.shadowMap.ParallelSplitShadowMap.MAX_PSSM_COUNT*/3+1)*4);
		this._uniformDistance=new Array(/*CLASS CONST:laya.d3.shadowMap.ParallelSplitShadowMap.MAX_PSSM_COUNT*/3+1);
		this._logDistance=new Array(/*CLASS CONST:laya.d3.shadowMap.ParallelSplitShadowMap.MAX_PSSM_COUNT*/3+1);
		this._dimension=new Array(/*CLASS CONST:laya.d3.shadowMap.ParallelSplitShadowMap.MAX_PSSM_COUNT*/3+1);
		this._tempLookAt3=new Vector3();
		this._tempLookAt4=new Vector4();
		this._tempValue=new Vector4();
		this._tempPos=new Vector3();
		this._tempLightUp=new Vector3();
		this._tempMin=new Vector4();
		this._tempMax=new Vector4();
		this._tempMatrix44=new Matrix4x4;
		this._splitFrustumCulling=new BoundFrustum(Matrix4x4.DEFAULT);
		this._tempScaleMatrix44=new Matrix4x4();
		this._shadowPCFOffset=new Vector2(1.0 / 1024.0,1.0 / 1024.0);
		this._shaderValueDistance=new Vector4();
		this.cameras=[];
		this._shaderValueVPs=[];
		var i=0;
		for (i=0;i < this._spiltDistance.length;i++){
			this._spiltDistance[i]=0.0;
		}
		for (i=0;i < this._dimension.length;i++){
			this._dimension[i]=new Vector2();
		}
		for (i=0;i < this._frustumPos.length;i++){
			this._frustumPos[i]=new Vector3();
		}
		for (i=0;i < this._boundingBox.length;i++){
			this._boundingBox[i]=new BoundBox(new Vector3(),new Vector3());
		}
		for (i=0;i < this._boundingSphere.length;i++){
			this._boundingSphere[i]=new BoundSphere(new Vector3(),0.0);
		}
		Matrix4x4.createScaling(new Vector3(0.5,0.5,1.0),this._tempScaleMatrix44);
		this._tempScaleMatrix44.elements[12]=0.5;
		this._tempScaleMatrix44.elements[13]=0.5;
	}

	__class(ParallelSplitShadowMap,'laya.d3.shadowMap.ParallelSplitShadowMap');
	var __proto=ParallelSplitShadowMap.prototype;
	__proto.setInfo=function(scene,maxDistance,globalParallelDir,shadowMapTextureSize,numberOfPSSM,PCFType){
		if (numberOfPSSM > /*CLASS CONST:laya.d3.shadowMap.ParallelSplitShadowMap.MAX_PSSM_COUNT*/3){
			this._shadowMapCount=/*CLASS CONST:laya.d3.shadowMap.ParallelSplitShadowMap.MAX_PSSM_COUNT*/3;
		}
		this._scene=scene;
		this._maxDistance=maxDistance;
		this.shadowMapCount=numberOfPSSM;
		this._globalParallelLightDir=globalParallelDir;
		this._ratioOfDistance=1.0 / this._shadowMapCount;
		for (var i=0;i < this._spiltDistance.length;i++){
			this._spiltDistance[i]=0.0;
		}
		this._shadowMapTextureSize=shadowMapTextureSize;
		this._shadowPCFOffset.x=1.0 / this._shadowMapTextureSize;
		this._shadowPCFOffset.y=1.0 / this._shadowMapTextureSize;
		this.setPCFType(PCFType);
		this._statesDirty=true;
	}

	__proto.setPCFType=function(PCFtype){
		this._PCFType=PCFtype;
		var defineData=this._scene._defineDatas;
		switch (this._PCFType){
			case 0:
				defineData.add(Scene3D.SHADERDEFINE_SHADOW_PCF_NO);
				defineData.remove(Scene3D.SHADERDEFINE_SHADOW_PCF1);
				defineData.remove(Scene3D.SHADERDEFINE_SHADOW_PCF2);
				defineData.remove(Scene3D.SHADERDEFINE_SHADOW_PCF3);
				break ;
			case 1:
				defineData.add(Scene3D.SHADERDEFINE_SHADOW_PCF1);
				defineData.remove(Scene3D.SHADERDEFINE_SHADOW_PCF_NO);
				defineData.remove(Scene3D.SHADERDEFINE_SHADOW_PCF2);
				defineData.remove(Scene3D.SHADERDEFINE_SHADOW_PCF3);
				break ;
			case 2:
				defineData.add(Scene3D.SHADERDEFINE_SHADOW_PCF2);
				defineData.remove(Scene3D.SHADERDEFINE_SHADOW_PCF_NO);
				defineData.remove(Scene3D.SHADERDEFINE_SHADOW_PCF1);
				defineData.remove(Scene3D.SHADERDEFINE_SHADOW_PCF3);
				break ;
			case 3:
				defineData.add(Scene3D.SHADERDEFINE_SHADOW_PCF3);
				defineData.remove(Scene3D.SHADERDEFINE_SHADOW_PCF_NO);
				defineData.remove(Scene3D.SHADERDEFINE_SHADOW_PCF1);
				defineData.remove(Scene3D.SHADERDEFINE_SHADOW_PCF2);
				break ;
			}
	}

	__proto.getPCFType=function(){
		return this._PCFType;
	}

	__proto.setFarDistance=function(value){
		if (this._maxDistance !=value){
			this._maxDistance=value;
			this._statesDirty=true;
		}
	}

	__proto.getFarDistance=function(){
		return this._maxDistance;
	}

	/**
	*@private
	*/
	__proto._beginSampler=function(index,sceneCamera){
		if (index < 0 || index > this._shadowMapCount)
			throw new Error("ParallelSplitShadowMap: beginSample invalid index");
		this._currentPSSM=index;
		this._update(sceneCamera);
	}

	/**
	*@private
	*/
	__proto.endSampler=function(sceneCamera){
		this._currentPSSM=-1;
	}

	/**
	*@private
	*/
	__proto._calcAllLightCameraInfo=function(sceneCamera){
		if (this._shadowMapCount===1){
			this._beginSampler(0,sceneCamera);
			this.endSampler(sceneCamera);
			}else {
			for (var i=0,n=this._shadowMapCount+1;i < n;i++){
				this._beginSampler(i,sceneCamera);
				this.endSampler(sceneCamera);
			}
		}
	}

	/**
	*@private
	*/
	__proto._recalculate=function(nearPlane,fieldOfView,aspectRatio){
		this._calcSplitDistance(nearPlane);
		this._calcBoundingBox(fieldOfView,aspectRatio);
		this._rebuildRenderInfo();
	}

	/**
	*@private
	*/
	__proto._update=function(sceneCamera){
		var nearPlane=sceneCamera.nearPlane;
		var fieldOfView=sceneCamera.fieldOfView;
		var aspectRatio=(sceneCamera).aspectRatio;
		if (this._statesDirty || this.lastNearPlane!==nearPlane || this.lastFieldOfView!==fieldOfView || this.lastAspectRatio!==aspectRatio){
			this._recalculate(nearPlane,fieldOfView,aspectRatio);
			this._uploadShaderValue();
			this._statesDirty=false;
			this.lastNearPlane=nearPlane;
			this.lastFieldOfView=fieldOfView;
			this.lastAspectRatio=aspectRatio;
		}
		this._calcLightViewProject(sceneCamera);
	}

	/**
	*@private
	*/
	__proto._uploadShaderValue=function(){
		var defDatas=this._scene._defineDatas;
		switch (this._shadowMapCount){
			case 1:
				defDatas.add(Scene3D.SHADERDEFINE_SHADOW_PSSM1);
				defDatas.remove(Scene3D.SHADERDEFINE_SHADOW_PSSM2);
				defDatas.remove(Scene3D.SHADERDEFINE_SHADOW_PSSM3);
				break ;
			case 2:
				defDatas.add(Scene3D.SHADERDEFINE_SHADOW_PSSM2);
				defDatas.remove(Scene3D.SHADERDEFINE_SHADOW_PSSM1);
				defDatas.remove(Scene3D.SHADERDEFINE_SHADOW_PSSM3);
				break ;
			case 3:
				defDatas.add(Scene3D.SHADERDEFINE_SHADOW_PSSM3);
				defDatas.remove(Scene3D.SHADERDEFINE_SHADOW_PSSM1);
				defDatas.remove(Scene3D.SHADERDEFINE_SHADOW_PSSM2);
				break ;
			};
		var sceneSV=this._scene._shaderValues;
		sceneSV.setVector(Scene3D.SHADOWDISTANCE,this._shaderValueDistance);
		sceneSV.setBuffer(Scene3D.SHADOWLIGHTVIEWPROJECT,this._shaderValueLightVP);
		sceneSV.setVector2(Scene3D.SHADOWMAPPCFOFFSET,this._shadowPCFOffset);
		switch (this._shadowMapCount){
			case 3:
				sceneSV.setTexture(Scene3D.SHADOWMAPTEXTURE1,this.cameras[1].renderTarget);
				sceneSV.setTexture(Scene3D.SHADOWMAPTEXTURE2,this.cameras[2].renderTarget)
				sceneSV.setTexture(Scene3D.SHADOWMAPTEXTURE3,this.cameras[3].renderTarget);
				break ;
			case 2:
				sceneSV.setTexture(Scene3D.SHADOWMAPTEXTURE1,this.cameras[1].renderTarget);
				sceneSV.setTexture(Scene3D.SHADOWMAPTEXTURE2,this.cameras[2].renderTarget);
				break ;
			case 1:
				sceneSV.setTexture(Scene3D.SHADOWMAPTEXTURE1,this.cameras[1].renderTarget);
				break ;
			}
	}

	/**
	*@private
	*/
	__proto._calcSplitDistance=function(nearPlane){
		var far=this._maxDistance;
		var invNumberOfPSSM=1.0 / this._shadowMapCount;
		var i=0;
		for (i=0;i <=this._shadowMapCount;i++){
			this._uniformDistance[i]=nearPlane+(far-nearPlane)*i *invNumberOfPSSM;
		};
		var farDivNear=far / nearPlane;
		for (i=0;i <=this._shadowMapCount;i++){
			var n=Math.pow(farDivNear,i *invNumberOfPSSM);
			this._logDistance[i]=nearPlane *n;
		}
		for (i=0;i <=this._shadowMapCount;i++){
			this._spiltDistance[i]=this._uniformDistance[i] *this._ratioOfDistance+this._logDistance[i] *(1.0-this._ratioOfDistance);
		}
		this._shaderValueDistance.x=this._spiltDistance[1];
		this._shaderValueDistance.y=this._spiltDistance[2];
		this._shaderValueDistance.z=this._spiltDistance[3];
		this._shaderValueDistance.w=0.0;
	}

	/**
	*@private
	*/
	__proto._calcBoundingBox=function(fieldOfView,aspectRatio){
		var fov=3.1415926 *fieldOfView / 180.0;
		var halfTanValue=Math.tan(fov / 2.0);
		var height=NaN;
		var width=NaN;
		var distance=NaN;
		var i=0;
		for (i=0;i <=this._shadowMapCount;i++){
			distance=this._spiltDistance[i];
			height=distance *halfTanValue;
			width=height *aspectRatio;
			var temp=this._frustumPos[i *4+0];
			temp.x=-width;
			temp.y=-height;
			temp.z=-distance;
			temp=this._frustumPos[i *4+1];
			temp.x=width;
			temp.y=-height;
			temp.z=-distance;
			temp=this._frustumPos[i *4+2];
			temp.x=-width;
			temp.y=height;
			temp.z=-distance;
			temp=this._frustumPos[i *4+3];
			temp.x=width;
			temp.y=height;
			temp.z=-distance;
			temp=this._dimension[i];
			temp.x=width;
			temp.y=height;
		};
		var d;
		var min;
		var max;
		var center;
		for (i=1;i <=this._shadowMapCount;i++){
			d=this._dimension[i];
			min=this._boundingBox[i].min;
			min.x=-d.x;
			min.y=-d.y;
			min.z=-this._spiltDistance[i];
			max=this._boundingBox[i].max;
			max.x=d.x;
			max.y=d.y;
			max.z=-this._spiltDistance[i-1];
			center=this._boundingSphere[i].center;
			center.x=(min.x+max.x)*0.5;
			center.y=(min.y+max.y)*0.5;
			center.z=(min.z+max.z)*0.5;
			this._boundingSphere[i].radius=Math.sqrt(Math.pow(max.x-min.x,2)+Math.pow(max.y-min.y,2)+Math.pow(max.z-min.z,2))*0.5;
		}
		min=this._boundingBox[0].min;
		d=this._dimension[this._shadowMapCount];
		min.x=-d.x;
		min.y=-d.y;
		min.z=-this._spiltDistance[this._shadowMapCount];
		max=this._boundingBox[0].max;
		max.x=d.x;
		max.y=d.y;
		max.z=-this._spiltDistance[0];
		center=this._boundingSphere[0].center;
		center.x=(min.x+max.x)*0.5;
		center.y=(min.y+max.y)*0.5;
		center.z=(min.z+max.z)*0.5;
		this._boundingSphere[0].radius=Math.sqrt(Math.pow(max.x-min.x,2)+Math.pow(max.y-min.y,2)+Math.pow(max.z-min.z,2))*0.5;
	}

	__proto.calcSplitFrustum=function(sceneCamera){
		if (this._currentPSSM > 0){
			Matrix4x4.createPerspective(3.1416 *sceneCamera.fieldOfView / 180.0,(sceneCamera).aspectRatio,this._spiltDistance[this._currentPSSM-1],this._spiltDistance[this._currentPSSM],this._tempMatrix44);
			}else {
			Matrix4x4.createPerspective(3.1416 *sceneCamera.fieldOfView / 180.0,(sceneCamera).aspectRatio,this._spiltDistance[0],this._spiltDistance[this._shadowMapCount],this._tempMatrix44);
		}
		Matrix4x4.multiply(this._tempMatrix44,(sceneCamera).viewMatrix,this._tempMatrix44);
		this._splitFrustumCulling.matrix=this._tempMatrix44;
	}

	/**
	*@private
	*/
	__proto._rebuildRenderInfo=function(){
		var nNum=this._shadowMapCount+1;
		var i=0;
		this.cameras.length=nNum;
		for (i=0;i < nNum;i++){
			if (!this.cameras[i]){
				var camera=new Camera();
				camera.name="lightCamera"+i;
				camera.clearColor=new Vector4(1.0,1.0,1.0,1.0);
				this.cameras[i]=camera;
			};
			var shadowMap=this.cameras[i].renderTarget;
			if (shadowMap==null || shadowMap.width !=this._shadowMapTextureSize || shadowMap.height !=this._shadowMapTextureSize){
				(shadowMap)&& (shadowMap.destroy());
				shadowMap=new RenderTexture(this._shadowMapTextureSize,this._shadowMapTextureSize,/*laya.resource.BaseTexture.FORMAT_R8G8B8A8*/1,/*laya.resource.BaseTexture.FORMAT_DEPTH_16*/0);
				shadowMap.filterMode=/*laya.resource.BaseTexture.FILTERMODE_POINT*/0;
				this.cameras[i].renderTarget=shadowMap;
			}
		}
	}

	/**
	*@private
	*/
	__proto._calcLightViewProject=function(sceneCamera){
		var boundSphere=this._boundingSphere[this._currentPSSM];
		var cameraMatViewInv=sceneCamera.transform.worldMatrix;
		var radius=boundSphere.radius;
		boundSphere.center.cloneTo(this._tempLookAt3);
		Vector3.transformV3ToV4(this._tempLookAt3,cameraMatViewInv,this._tempLookAt4);
		var lookAt3Element=this._tempLookAt3;
		var lookAt4Element=this._tempLookAt4;
		lookAt3Element.x=lookAt4Element.x;
		lookAt3Element.y=lookAt4Element.y;
		lookAt3Element.z=lookAt4Element.z;
		var lightUpElement=this._tempLightUp;
		sceneCamera.transform.worldMatrix.getForward(ParallelSplitShadowMap._tempVector30);
		var sceneCameraDir=ParallelSplitShadowMap._tempVector30;
		lightUpElement.x=sceneCameraDir.x;
		lightUpElement.y=1.0;
		lightUpElement.z=sceneCameraDir.z;
		Vector3.normalize(this._tempLightUp,this._tempLightUp);
		Vector3.scale(this._globalParallelLightDir,boundSphere.radius *4,this._tempPos);
		Vector3.subtract(this._tempLookAt3,this._tempPos,this._tempPos);
		var curLightCamera=this.cameras[this._currentPSSM];
		curLightCamera.transform.position=this._tempPos;
		curLightCamera.transform.lookAt(this._tempLookAt3,this._tempLightUp,false);
		var tempMax=this._tempMax;
		var tempMin=this._tempMin;
		tempMax.x=tempMax.y=tempMax.z=-100000.0;
		tempMax.w=1.0;
		tempMin.x=tempMin.y=tempMin.z=100000.0;
		tempMin.w=1.0;
		Matrix4x4.multiply(curLightCamera.viewMatrix,cameraMatViewInv,this._tempMatrix44);
		var tempValueElement=this._tempValue;
		var corners=[];
		corners.length=8;
		this._boundingBox[this._currentPSSM].getCorners(corners);
		for (var i=0;i < 8;i++){
			var frustumPosElements=corners[i];
			tempValueElement.x=frustumPosElements.x;
			tempValueElement.y=frustumPosElements.y;
			tempValueElement.z=frustumPosElements.z;
			tempValueElement.w=1.0;
			Vector4.transformByM4x4(this._tempValue,this._tempMatrix44,this._tempValue);
			tempMin.x=(tempValueElement.x < tempMin.x)? tempValueElement.x :tempMin.x;
			tempMin.y=(tempValueElement.y < tempMin.y)? tempValueElement.y :tempMin.y;
			tempMin.z=(tempValueElement.z < tempMin.z)? tempValueElement.z :tempMin.z;
			tempMax.x=(tempValueElement.x > tempMax.x)? tempValueElement.x :tempMax.x;
			tempMax.y=(tempValueElement.y > tempMax.y)? tempValueElement.y :tempMax.y;
			tempMax.z=(tempValueElement.z > tempMax.z)? tempValueElement.z :tempMax.z;
		}
		Vector4.add(this._tempMax,this._tempMin,this._tempValue);
		tempValueElement.x *=0.5;
		tempValueElement.y *=0.5;
		tempValueElement.z *=0.5;
		tempValueElement.w=1;
		Vector4.transformByM4x4(this._tempValue,curLightCamera.transform.worldMatrix,this._tempValue);
		var distance=Math.abs(-this._tempMax.z);
		var farPlane=distance > this._maxDistance ? distance :this._maxDistance;
		Vector3.scale(this._globalParallelLightDir,farPlane,this._tempPos);
		var tempPosElement=this._tempPos;
		tempPosElement.x=tempValueElement.x-tempPosElement.x;
		tempPosElement.y=tempValueElement.y-tempPosElement.y;
		tempPosElement.z=tempValueElement.z-tempPosElement.z;
		curLightCamera.transform.position=this._tempPos;
		curLightCamera.transform.lookAt(this._tempLookAt3,this._tempLightUp,false);
		Matrix4x4.createOrthoOffCenter(tempMin.x,tempMax.x,tempMin.y,tempMax.y,1.0,farPlane+0.5 *(tempMax.z-tempMin.z),curLightCamera.projectionMatrix);
		var projectView=curLightCamera.projectionViewMatrix;
		ParallelSplitShadowMap.multiplyMatrixOutFloat32Array(this._tempScaleMatrix44,projectView,this._shaderValueVPs[this._currentPSSM]);
		this._scene._shaderValues.setBuffer(Scene3D.SHADOWLIGHTVIEWPROJECT,this._shaderValueLightVP);
	}

	__proto.setShadowMapTextureSize=function(size){
		if (size!==this._shadowMapTextureSize){
			this._shadowMapTextureSize=size;
			this._shadowPCFOffset.x=1 / this._shadowMapTextureSize;
			this._shadowPCFOffset.y=1 / this._shadowMapTextureSize;
			this._statesDirty=true;
		}
	}

	__proto.disposeAllRenderTarget=function(){
		for (var i=0,n=this._shadowMapCount+1;i < n;i++){
			if (this.cameras[i].renderTarget){
				this.cameras[i].renderTarget.destroy();
				this.cameras[i].renderTarget=null;
			}
		}
	}

	__getset(0,__proto,'shadowMapCount',function(){
		return this._shadowMapCount;
		},function(value){
		value=value > 0 ? value :1;
		value=value <=3 ? value :3;
		if (this._shadowMapCount !=value){
			this._shadowMapCount=value;
			this._ratioOfDistance=1.0 / this._shadowMapCount;
			this._statesDirty=true;
			this._shaderValueLightVP=new Float32Array(value *16);
			this._shaderValueVPs.length=value;
			for (var i=0;i < value;i++)
			this._shaderValueVPs[i]=new Float32Array(this._shaderValueLightVP.buffer,i *64);
		}
	});

	ParallelSplitShadowMap.multiplyMatrixOutFloat32Array=function(left,right,out){
		var i,a,b,ai0,ai1,ai2,ai3;
		a=left.elements;
		b=right.elements;
		for (i=0;i < 4;i++){
			ai0=a[i];
			ai1=a[i+4];
			ai2=a[i+8];
			ai3=a[i+12];
			out[i]=ai0 *b[0]+ai1 *b[1]+ai2 *b[2]+ai3 *b[3];
			out[i+4]=ai0 *b[4]+ai1 *b[5]+ai2 *b[6]+ai3 *b[7];
			out[i+8]=ai0 *b[8]+ai1 *b[9]+ai2 *b[10]+ai3 *b[11];
			out[i+12]=ai0 *b[12]+ai1 *b[13]+ai2 *b[14]+ai3 *b[15];
		}
	}

	ParallelSplitShadowMap.MAX_PSSM_COUNT=3;
	__static(ParallelSplitShadowMap,
	['_tempVector30',function(){return this._tempVector30=new Vector3();}
	]);
	return ParallelSplitShadowMap;
})()


/**
*<code>PrimitiveMesh</code> 类用于创建简单网格。
*/
//class laya.d3.resource.models.PrimitiveMesh
var PrimitiveMesh=(function(){
	function PrimitiveMesh(){}
	__class(PrimitiveMesh,'laya.d3.resource.models.PrimitiveMesh');
	PrimitiveMesh._createMesh=function(vertexDeclaration,vertices,indices){
		var mesh=new Mesh();
		var subMesh=new SubMesh(mesh);
		var vertexBuffer=new VertexBuffer3D(vertices.length *4,/*laya.webgl.WebGLContext.STATIC_DRAW*/0x88E4,true);
		vertexBuffer.vertexDeclaration=vertexDeclaration;
		vertexBuffer.setData(vertices);
		mesh._vertexBuffers.push(vertexBuffer);
		mesh._vertexCount+=vertexBuffer.vertexCount;
		var indexBuffer=new IndexBuffer3D(/*laya.d3.graphics.IndexBuffer3D.INDEXTYPE_USHORT*/"ushort",indices.length,/*laya.webgl.WebGLContext.STATIC_DRAW*/0x88E4,true);
		indexBuffer.setData(indices);
		mesh._indexBuffer=indexBuffer;
		var vertexBuffers=__newvec(1,null);
		vertexBuffers[0]=vertexBuffer;
		mesh._setBuffer(vertexBuffers,indexBuffer);
		subMesh._vertexBuffer=vertexBuffer;
		subMesh._indexBuffer=indexBuffer;
		subMesh._indexStart=0;
		subMesh._indexCount=indexBuffer.indexCount;
		var subIndexBufferStart=subMesh._subIndexBufferStart;
		var subIndexBufferCount=subMesh._subIndexBufferCount;
		var boneIndicesList=subMesh._boneIndicesList;
		subIndexBufferStart.length=1;
		subIndexBufferCount.length=1;
		boneIndicesList.length=1;
		subIndexBufferStart[0]=0;
		subIndexBufferCount[0]=indexBuffer.indexCount;
		var subMeshes=[];
		subMeshes.push(subMesh);
		mesh._setSubMeshes(subMeshes);
		var memorySize=vertexBuffer._byteLength+indexBuffer._byteLength;
		mesh._setCPUMemory(memorySize);
		mesh._setGPUMemory(memorySize);
		return mesh;
	}

	PrimitiveMesh.createBox=function(long,height,width){
		(long===void 0)&& (long=1);
		(height===void 0)&& (height=1);
		(width===void 0)&& (width=1);
		var vertexCount=24;
		var indexCount=36;
		var vertexDeclaration=VertexMesh.getVertexDeclaration("POSITION,NORMAL,UV");
		var halfLong=long / 2;
		var halfHeight=height / 2;
		var halfWidth=width / 2;
		var vertices=new Float32Array([
		-halfLong,halfHeight,-halfWidth,0,1,0,0,0,halfLong,halfHeight,-halfWidth,0,1,0,1,0,halfLong,halfHeight,halfWidth,0,1,0,1,1,-halfLong,halfHeight,halfWidth,0,1,0,0,1,
		-halfLong,-halfHeight,-halfWidth,0,-1,0,0,1,halfLong,-halfHeight,-halfWidth,0,-1,0,1,1,halfLong,-halfHeight,halfWidth,0,-1,0,1,0,-halfLong,-halfHeight,halfWidth,0,-1,0,0,0,
		-halfLong,halfHeight,-halfWidth,-1,0,0,0,0,-halfLong,halfHeight,halfWidth,-1,0,0,1,0,-halfLong,-halfHeight,halfWidth,-1,0,0,1,1,-halfLong,-halfHeight,-halfWidth,-1,0,0,0,1,
		halfLong,halfHeight,-halfWidth,1,0,0,1,0,halfLong,halfHeight,halfWidth,1,0,0,0,0,halfLong,-halfHeight,halfWidth,1,0,0,0,1,halfLong,-halfHeight,-halfWidth,1,0,0,1,1,
		-halfLong,halfHeight,halfWidth,0,0,1,0,0,halfLong,halfHeight,halfWidth,0,0,1,1,0,halfLong,-halfHeight,halfWidth,0,0,1,1,1,-halfLong,-halfHeight,halfWidth,0,0,1,0,1,
		-halfLong,halfHeight,-halfWidth,0,0,-1,1,0,halfLong,halfHeight,-halfWidth,0,0,-1,0,0,halfLong,-halfHeight,-halfWidth,0,0,-1,0,1,-halfLong,-halfHeight,-halfWidth,0,0,-1,1,1]);
		var indices=new Uint16Array([
		0,1,2,2,3,0,
		4,7,6,6,5,4,
		8,9,10,10,11,8,
		12,15,14,14,13,12,
		16,17,18,18,19,16,
		20,23,22,22,21,20]);
		return PrimitiveMesh._createMesh(vertexDeclaration,vertices,indices);
	}

	PrimitiveMesh.createCapsule=function(radius,height,stacks,slices){
		(radius===void 0)&& (radius=0.5);
		(height===void 0)&& (height=2);
		(stacks===void 0)&& (stacks=16);
		(slices===void 0)&& (slices=32);
		var vertexCount=(stacks+1)*(slices+1)*2+(slices+1)*2;
		var indexCount=(3 *stacks *(slices+1))*2 *2+2 *slices *3;
		var vertexDeclaration=VertexMesh.getVertexDeclaration("POSITION,NORMAL,UV");
		var vertexFloatStride=vertexDeclaration.vertexStride / 4;
		var vertices=new Float32Array(vertexCount *vertexFloatStride);
		var indices=new Uint16Array(indexCount);
		var stackAngle=(Math.PI / 2.0)/ stacks;
		var sliceAngle=(Math.PI *2.0)/ slices;
		var hcHeight=height / 2-radius;
		var posX=0;
		var posY=0;
		var posZ=0;
		var vc=0;
		var ic=0;
		var verticeCount=0;
		var stack=0,slice=0;
		for (stack=0;stack <=stacks;stack++){
			for (slice=0;slice <=slices;slice++){
				posX=radius *Math.cos(stack *stackAngle)*Math.cos(slice *sliceAngle+Math.PI);
				posY=radius *Math.sin(stack *stackAngle);
				posZ=radius *Math.cos(stack *stackAngle)*Math.sin(slice *sliceAngle+Math.PI);
				vertices[vc++]=posX;
				vertices[vc++]=posY+hcHeight;
				vertices[vc++]=posZ;
				vertices[vc++]=posX;
				vertices[vc++]=posY;
				vertices[vc++]=posZ;
				vertices[vc++]=1-slice / slices;
				vertices[vc++]=(1-stack / stacks)*((Math.PI *radius / 2)/ (height+Math.PI *radius));
				if (stack < stacks){
					indices[ic++]=(stack *(slices+1))+slice+(slices+1);
					indices[ic++]=(stack *(slices+1))+slice;
					indices[ic++]=(stack *(slices+1))+slice+1;
					indices[ic++]=(stack *(slices+1))+slice+(slices);
					indices[ic++]=(stack *(slices+1))+slice;
					indices[ic++]=(stack *(slices+1))+slice+(slices+1);
				}
			}
		}
		verticeCount+=(stacks+1)*(slices+1);
		for (stack=0;stack <=stacks;stack++){
			for (slice=0;slice <=slices;slice++){
				posX=radius *Math.cos(stack *stackAngle)*Math.cos(slice *sliceAngle+Math.PI);
				posY=radius *Math.sin(-stack *stackAngle);
				posZ=radius *Math.cos(stack *stackAngle)*Math.sin(slice *sliceAngle+Math.PI);
				vertices[vc++]=posX;
				vertices[vc++]=posY-hcHeight;
				vertices[vc++]=posZ;
				vertices[vc++]=posX;
				vertices[vc++]=posY;
				vertices[vc++]=posZ;
				vertices[vc++]=1-slice / slices;
				vertices[vc++]=((stack / stacks)*(Math.PI *radius / 2)+(height+Math.PI *radius / 2))/ (height+Math.PI *radius);
				if (stack < stacks){
					indices[ic++]=verticeCount+(stack *(slices+1))+slice;
					indices[ic++]=verticeCount+(stack *(slices+1))+slice+(slices+1);
					indices[ic++]=verticeCount+(stack *(slices+1))+slice+1;
					indices[ic++]=verticeCount+(stack *(slices+1))+slice;
					indices[ic++]=verticeCount+(stack *(slices+1))+slice+(slices);
					indices[ic++]=verticeCount+(stack *(slices+1))+slice+(slices+1);
				}
			}
		}
		verticeCount+=(stacks+1)*(slices+1);
		for (slice=0;slice <=slices;slice++){
			posX=radius *Math.cos(slice *sliceAngle+Math.PI);
			posY=hcHeight;
			posZ=radius *Math.sin(slice *sliceAngle+Math.PI);
			vertices[vc++]=posX;
			vertices[vc+(slices+1)*8-1]=posX;
			vertices[vc++]=posY;
			vertices[vc+(slices+1)*8-1]=-posY;
			vertices[vc++]=posZ;
			vertices[vc+(slices+1)*8-1]=posZ;
			vertices[vc++]=posX;
			vertices[vc+(slices+1)*8-1]=posX;
			vertices[vc++]=0;
			vertices[vc+(slices+1)*8-1]=0;
			vertices[vc++]=posZ;
			vertices[vc+(slices+1)*8-1]=posZ;
			vertices[vc++]=1-slice *1 / slices;
			vertices[vc+(slices+1)*8-1]=1-slice *1 / slices;
			vertices[vc++]=(Math.PI *radius / 2)/ (height+Math.PI *radius);
			vertices[vc+(slices+1)*8-1]=(Math.PI *radius / 2+height)/ (height+Math.PI *radius);
		}
		for (slice=0;slice < slices;slice++){
			indices[ic++]=slice+verticeCount+(slices+1);
			indices[ic++]=slice+verticeCount+1;
			indices[ic++]=slice+verticeCount;
			indices[ic++]=slice+verticeCount+(slices+1);
			indices[ic++]=slice+verticeCount+(slices+1)+1;
			indices[ic++]=slice+verticeCount+1;
		}
		verticeCount+=2 *(slices+1);
		return PrimitiveMesh._createMesh(vertexDeclaration,vertices,indices);
	}

	PrimitiveMesh.createCone=function(radius,height,slices){
		(radius===void 0)&& (radius=0.5);
		(height===void 0)&& (height=1);
		(slices===void 0)&& (slices=32);
		var vertexCount=(slices+1+1)+(slices+1)*2;
		var indexCount=6 *slices+3 *slices;
		var vertexDeclaration=VertexMesh.getVertexDeclaration("POSITION,NORMAL,UV");
		var vertexFloatStride=vertexDeclaration.vertexStride / 4;
		var vertices=new Float32Array(vertexCount *vertexFloatStride);
		var indices=new Uint16Array(indexCount);
		var sliceAngle=(Math.PI *2.0)/ slices;
		var halfHeight=height / 2;
		var curAngle=0;
		var verticeCount=0;
		var posX=0;
		var posY=0;
		var posZ=0;
		var normal=new Vector3();
		var downV3=new Vector3(0,-1,0);
		var upPoint=new Vector3(0,halfHeight,0);
		var downPoint=new Vector3();
		var v3=new Vector3();
		var q4=new Quaternion();
		var rotateAxis=new Vector3();
		var rotateRadius=NaN;
		var vc=0;
		var ic=0;
		for (var rv=0;rv <=slices;rv++){
			curAngle=rv *sliceAngle;
			posX=Math.cos(curAngle+Math.PI)*radius;
			posY=halfHeight;
			posZ=Math.sin(curAngle+Math.PI)*radius;
			vertices[vc++]=0;
			vertices[vc+(slices+1)*8-1]=posX;
			vertices[vc++]=posY;
			vertices[vc+(slices+1)*8-1]=-posY;
			vertices[vc++]=0;
			vertices[vc+(slices+1)*8-1]=posZ;
			normal.x=posX;
			normal.y=0;
			normal.z=posZ;
			downPoint.x=posX;
			downPoint.y=-posY;
			downPoint.z=posZ;
			Vector3.subtract(downPoint,upPoint,v3);
			Vector3.normalize(v3,v3);
			rotateRadius=Math.acos(Vector3.dot(downV3,v3));
			Vector3.cross(downV3,v3,rotateAxis);
			Vector3.normalize(rotateAxis,rotateAxis);
			Quaternion.createFromAxisAngle(rotateAxis,rotateRadius,q4);
			Vector3.normalize(normal,normal);
			Vector3.transformQuat(normal,q4,normal);
			Vector3.normalize(normal,normal);
			vertices[vc++]=normal.x;
			vertices[vc+(slices+1)*8-1]=normal.x;
			vertices[vc++]=normal.y;
			vertices[vc+(slices+1)*8-1]=normal.y;
			vertices[vc++]=normal.z;
			vertices[vc+(slices+1)*8-1]=normal.z;
			vertices[vc++]=1-rv *1 / slices;
			vertices[vc+(slices+1)*8-1]=1-rv *1 / slices;
			vertices[vc++]=0;
			vertices[vc+(slices+1)*8-1]=1;
		}
		vc+=(slices+1)*8;
		for (var ri=0;ri < slices;ri++){
			indices[ic++]=ri+verticeCount+(slices+1);
			indices[ic++]=ri+verticeCount+1;
			indices[ic++]=ri+verticeCount;
			indices[ic++]=ri+verticeCount+(slices+1);
			indices[ic++]=ri+verticeCount+(slices+1)+1;
			indices[ic++]=ri+verticeCount+1;
		}
		verticeCount+=2 *(slices+1);
		for (var bv=0;bv <=slices;bv++){
			if (bv===0){
				vertices[vc++]=0;
				vertices[vc++]=-halfHeight;
				vertices[vc++]=0;
				vertices[vc++]=0;
				vertices[vc++]=-1;
				vertices[vc++]=0;
				vertices[vc++]=0.5;
				vertices[vc++]=0.5;
			}
			curAngle=bv *sliceAngle;
			posX=Math.cos(curAngle+Math.PI)*radius;
			posY=-halfHeight;
			posZ=Math.sin(curAngle+Math.PI)*radius;
			vertices[vc++]=posX;
			vertices[vc++]=posY;
			vertices[vc++]=posZ;
			vertices[vc++]=0;
			vertices[vc++]=-1;
			vertices[vc++]=0;
			vertices[vc++]=0.5+Math.cos(curAngle)*0.5;
			vertices[vc++]=0.5+Math.sin(curAngle)*0.5;
		}
		for (var bi=0;bi < slices;bi++){
			indices[ic++]=0+verticeCount;
			indices[ic++]=bi+2+verticeCount;
			indices[ic++]=bi+1+verticeCount;
		}
		verticeCount+=slices+1+1;
		return PrimitiveMesh._createMesh(vertexDeclaration,vertices,indices);
	}

	PrimitiveMesh.createCylinder=function(radius,height,slices){
		(radius===void 0)&& (radius=0.5);
		(height===void 0)&& (height=2);
		(slices===void 0)&& (slices=32);
		var vertexCount=(slices+1+1)+(slices+1)*2+(slices+1+1);
		var indexCount=3 *slices+6 *slices+3 *slices;
		var vertexDeclaration=VertexMesh.getVertexDeclaration("POSITION,NORMAL,UV");
		var vertexFloatStride=vertexDeclaration.vertexStride / 4;
		var vertices=new Float32Array(vertexCount *vertexFloatStride);
		var indices=new Uint16Array(indexCount);
		var sliceAngle=(Math.PI *2.0)/ slices;
		var halfHeight=height / 2;
		var curAngle=0;
		var verticeCount=0;
		var posX=0;
		var posY=0;
		var posZ=0;
		var vc=0;
		var ic=0;
		for (var tv=0;tv <=slices;tv++){
			if (tv===0){
				vertices[vc++]=0;
				vertices[vc++]=halfHeight;
				vertices[vc++]=0;
				vertices[vc++]=0;
				vertices[vc++]=1;
				vertices[vc++]=0;
				vertices[vc++]=0.5;
				vertices[vc++]=0.5;
			}
			curAngle=tv *sliceAngle;
			posX=Math.cos(curAngle)*radius;
			posY=halfHeight;
			posZ=Math.sin(curAngle)*radius;
			vertices[vc++]=posX;
			vertices[vc++]=posY;
			vertices[vc++]=posZ;
			vertices[vc++]=0;
			vertices[vc++]=1;
			vertices[vc++]=0;
			vertices[vc++]=0.5+Math.cos(curAngle)*0.5;
			vertices[vc++]=0.5+Math.sin(curAngle)*0.5;
		}
		for (var ti=0;ti < slices;ti++){
			indices[ic++]=0;
			indices[ic++]=ti+1;
			indices[ic++]=ti+2;
		}
		verticeCount+=slices+1+1;
		for (var rv=0;rv <=slices;rv++){
			curAngle=rv *sliceAngle;
			posX=Math.cos(curAngle+Math.PI)*radius;
			posY=halfHeight;
			posZ=Math.sin(curAngle+Math.PI)*radius;
			vertices[vc++]=posX;
			vertices[vc+(slices+1)*8-1]=posX;
			vertices[vc++]=posY;
			vertices[vc+(slices+1)*8-1]=-posY;
			vertices[vc++]=posZ;
			vertices[vc+(slices+1)*8-1]=posZ;
			vertices[vc++]=posX;
			vertices[vc+(slices+1)*8-1]=posX;
			vertices[vc++]=0;
			vertices[vc+(slices+1)*8-1]=0;
			vertices[vc++]=posZ;
			vertices[vc+(slices+1)*8-1]=posZ;
			vertices[vc++]=1-rv *1 / slices;
			vertices[vc+(slices+1)*8-1]=1-rv *1 / slices;
			vertices[vc++]=0;
			vertices[vc+(slices+1)*8-1]=1;
		}
		vc+=(slices+1)*8;
		for (var ri=0;ri < slices;ri++){
			indices[ic++]=ri+verticeCount+(slices+1);
			indices[ic++]=ri+verticeCount+1;
			indices[ic++]=ri+verticeCount;
			indices[ic++]=ri+verticeCount+(slices+1);
			indices[ic++]=ri+verticeCount+(slices+1)+1;
			indices[ic++]=ri+verticeCount+1;
		}
		verticeCount+=2 *(slices+1);
		for (var bv=0;bv <=slices;bv++){
			if (bv===0){
				vertices[vc++]=0;
				vertices[vc++]=-halfHeight;
				vertices[vc++]=0;
				vertices[vc++]=0;
				vertices[vc++]=-1;
				vertices[vc++]=0;
				vertices[vc++]=0.5;
				vertices[vc++]=0.5;
			}
			curAngle=bv *sliceAngle;
			posX=Math.cos(curAngle+Math.PI)*radius;
			posY=-halfHeight;
			posZ=Math.sin(curAngle+Math.PI)*radius;
			vertices[vc++]=posX;
			vertices[vc++]=posY;
			vertices[vc++]=posZ;
			vertices[vc++]=0;
			vertices[vc++]=-1;
			vertices[vc++]=0;
			vertices[vc++]=0.5+Math.cos(curAngle)*0.5;
			vertices[vc++]=0.5+Math.sin(curAngle)*0.5;
		}
		for (var bi=0;bi < slices;bi++){
			indices[ic++]=0+verticeCount;
			indices[ic++]=bi+2+verticeCount;
			indices[ic++]=bi+1+verticeCount;
		}
		verticeCount+=slices+1+1;
		return PrimitiveMesh._createMesh(vertexDeclaration,vertices,indices);
	}

	PrimitiveMesh.createPlane=function(long,width,stacks,slices){
		(long===void 0)&& (long=10);
		(width===void 0)&& (width=10);
		(stacks===void 0)&& (stacks=10);
		(slices===void 0)&& (slices=10);
		var vertexCount=(stacks+1)*(slices+1);
		var indexCount=stacks *slices *2 *3;
		var indices=new Uint16Array(indexCount);
		var vertexDeclaration=VertexMesh.getVertexDeclaration("POSITION,NORMAL,UV");
		var vertexFloatStride=vertexDeclaration.vertexStride / 4;
		var vertices=new Float32Array(vertexCount *vertexFloatStride);
		var halfLong=long / 2;
		var halfWidth=width / 2;
		var stacksLong=long / stacks;
		var slicesWidth=width / slices;
		var verticeCount=0;
		for (var i=0;i <=slices;i++){
			for (var j=0;j <=stacks;j++){
				vertices[verticeCount++]=j *stacksLong-halfLong;
				vertices[verticeCount++]=0;
				vertices[verticeCount++]=i *slicesWidth-halfWidth;
				vertices[verticeCount++]=0;
				vertices[verticeCount++]=1;
				vertices[verticeCount++]=0;
				vertices[verticeCount++]=j *1 / stacks;
				vertices[verticeCount++]=i *1 / slices;
			}
		};
		var indiceIndex=0;
		for (i=0;i < slices;i++){
			for (j=0;j < stacks;j++){
				indices[indiceIndex++]=(i+1)*(stacks+1)+j;
				indices[indiceIndex++]=i *(stacks+1)+j;
				indices[indiceIndex++]=(i+1)*(stacks+1)+j+1;
				indices[indiceIndex++]=i *(stacks+1)+j;
				indices[indiceIndex++]=i *(stacks+1)+j+1;
				indices[indiceIndex++]=(i+1)*(stacks+1)+j+1;
			}
		}
		return PrimitiveMesh._createMesh(vertexDeclaration,vertices,indices);
	}

	PrimitiveMesh.createQuad=function(long,width){
		(long===void 0)&& (long=1);
		(width===void 0)&& (width=1);
		var vertexCount=4;
		var indexCount=6;
		var vertexDeclaration=VertexMesh.getVertexDeclaration("POSITION,NORMAL,UV");
		var vertexFloatStride=vertexDeclaration.vertexStride / 4;
		var halfLong=long / 2;
		var halfWidth=width / 2;
		var vertices=new Float32Array([
		-halfLong,halfWidth,0,0,0,1,0,0,halfLong,halfWidth,0,0,0,1,1,0,-halfLong,-halfWidth,0,0,0,1,0,1,halfLong,-halfWidth,0,0,0,1,1,1,]);
		var indices=new Uint16Array([
		0,1,2,3,2,1,]);
		return PrimitiveMesh._createMesh(vertexDeclaration,vertices,indices);
	}

	PrimitiveMesh.createSphere=function(radius,stacks,slices){
		(radius===void 0)&& (radius=0.5);
		(stacks===void 0)&& (stacks=32);
		(slices===void 0)&& (slices=32);
		var vertexCount=(stacks+1)*(slices+1);
		var indexCount=(3 *stacks *(slices+1))*2;
		var indices=new Uint16Array(indexCount);
		var vertexDeclaration=VertexMesh.getVertexDeclaration("POSITION,NORMAL,UV");
		var vertexFloatStride=vertexDeclaration.vertexStride / 4;
		var vertices=new Float32Array(vertexCount *vertexFloatStride);
		var stackAngle=Math.PI / stacks;
		var sliceAngle=(Math.PI *2.0)/ slices;
		var vertexIndex=0;
		vertexCount=0;
		indexCount=0;
		for (var stack=0;stack < (stacks+1);stack++){
			var r=Math.sin(stack *stackAngle);
			var y=Math.cos(stack *stackAngle);
			for (var slice=0;slice < (slices+1);slice++){
				var x=r *Math.sin(slice *sliceAngle+Math.PI *1 / 2);
				var z=r *Math.cos(slice *sliceAngle+Math.PI *1 / 2);
				vertices[vertexCount+0]=x *radius;
				vertices[vertexCount+1]=y *radius;
				vertices[vertexCount+2]=z *radius;
				vertices[vertexCount+3]=x;
				vertices[vertexCount+4]=y;
				vertices[vertexCount+5]=z;
				vertices[vertexCount+6]=slice / slices;
				vertices[vertexCount+7]=stack / stacks;
				vertexCount+=vertexFloatStride;
				if (stack !=(stacks-1)){
					indices[indexCount++]=vertexIndex+(slices+1);
					indices[indexCount++]=vertexIndex;
					indices[indexCount++]=vertexIndex+1;
					indices[indexCount++]=vertexIndex+(slices);
					indices[indexCount++]=vertexIndex;
					indices[indexCount++]=vertexIndex+(slices+1);
					vertexIndex++;
				}
			}
		}
		return PrimitiveMesh._createMesh(vertexDeclaration,vertices,indices);
	}

	return PrimitiveMesh;
})()


/**
*<code>PostProcessEffect</code> 类用于创建后期处理渲染效果。
*/
//class laya.d3.core.render.PostProcessEffect
var PostProcessEffect=(function(){
	/**
	*创建一个 <code>PostProcessEffect</code> 实例。
	*/
	function PostProcessEffect(){}
	__class(PostProcessEffect,'laya.d3.core.render.PostProcessEffect');
	var __proto=PostProcessEffect.prototype;
	/**
	*@private
	*/
	__proto.render=function(context){}
	return PostProcessEffect;
})()


/**
*@private
*/
//class laya.d3.animation.AnimationClipParser04
var AnimationClipParser04=(function(){
	function AnimationClipParser04(){}
	__class(AnimationClipParser04,'laya.d3.animation.AnimationClipParser04');
	AnimationClipParser04.READ_DATA=function(){
		AnimationClipParser04._DATA.offset=AnimationClipParser04._reader.getUint32();
		AnimationClipParser04._DATA.size=AnimationClipParser04._reader.getUint32();
	}

	AnimationClipParser04.READ_BLOCK=function(){
		var count=AnimationClipParser04._BLOCK.count=AnimationClipParser04._reader.getUint16();
		var blockStarts=AnimationClipParser04._BLOCK.blockStarts=[];
		var blockLengths=AnimationClipParser04._BLOCK.blockLengths=[];
		for (var i=0;i < count;i++){
			blockStarts.push(AnimationClipParser04._reader.getUint32());
			blockLengths.push(AnimationClipParser04._reader.getUint32());
		}
	}

	AnimationClipParser04.READ_STRINGS=function(){
		var offset=AnimationClipParser04._reader.getUint32();
		var count=AnimationClipParser04._reader.getUint16();
		var prePos=AnimationClipParser04._reader.pos;
		AnimationClipParser04._reader.pos=offset+AnimationClipParser04._DATA.offset;
		for (var i=0;i < count;i++)
		AnimationClipParser04._strings[i]=AnimationClipParser04._reader.readUTFString();
		AnimationClipParser04._reader.pos=prePos;
	}

	AnimationClipParser04.parse=function(clip,reader,version){
		AnimationClipParser04._animationClip=clip;
		AnimationClipParser04._reader=reader;
		AnimationClipParser04._version=version;
		AnimationClipParser04.READ_DATA();
		AnimationClipParser04.READ_BLOCK();
		AnimationClipParser04.READ_STRINGS();
		for (var i=0,n=AnimationClipParser04._BLOCK.count;i < n;i++){
			var index=reader.getUint16();
			var blockName=AnimationClipParser04._strings[index];
			var fn=AnimationClipParser04["READ_"+blockName];
			if (fn==null)
				throw new Error("model file err,no this function:"+index+" "+blockName);
			else
			fn.call(null);
		}
		AnimationClipParser04._version=null;
		AnimationClipParser04._reader=null;
		AnimationClipParser04._animationClip=null;
	}

	AnimationClipParser04.READ_ANIMATIONS=function(){
		var i=0,j=0;
		var node;
		var reader=AnimationClipParser04._reader;
		var buffer=reader.__getBuffer();
		var startTimeTypes=[];
		var startTimeTypeCount=reader.getUint16();
		startTimeTypes.length=startTimeTypeCount;
		for (i=0;i < startTimeTypeCount;i++)
		startTimeTypes[i]=reader.getFloat32();
		var clip=AnimationClipParser04._animationClip;
		clip.name=AnimationClipParser04._strings[reader.getUint16()];
		var clipDur=clip._duration=reader.getFloat32();
		clip.islooping=!!reader.getByte();
		clip._frameRate=reader.getInt16();
		var nodeCount=reader.getInt16();
		var nodes=clip._nodes;
		nodes.count=nodeCount;
		var nodesMap=clip._nodesMap={};
		var nodesDic=clip._nodesDic={};
		for (i=0;i < nodeCount;i++){
			node=new KeyframeNode();
			nodes.setNodeByIndex(i,node);
			node._indexInList=i;
			var type=node.type=reader.getUint8();
			var pathLength=reader.getUint16();
			node._setOwnerPathCount(pathLength);
			for (j=0;j < pathLength;j++)
			node._setOwnerPathByIndex(j,AnimationClipParser04._strings[reader.getUint16()]);
			var nodePath=node._joinOwnerPath("/");
			var mapArray=nodesMap[nodePath];
			(mapArray)|| (nodesMap[nodePath]=mapArray=[]);
			mapArray.push(node);
			node.propertyOwner=AnimationClipParser04._strings[reader.getUint16()];
			var propertyLength=reader.getUint16();
			node._setPropertyCount(propertyLength);
			for (j=0;j < propertyLength;j++)
			node._setPropertyByIndex(j,AnimationClipParser04._strings[reader.getUint16()]);
			var fullPath=nodePath+"."+node.propertyOwner+"."+node._joinProperty(".");
			nodesDic[fullPath]=node;
			node.fullPath=fullPath;
			var keyframeCount=reader.getUint16();
			node._setKeyframeCount(keyframeCount);
			var startTime=NaN;
			switch (type){
				case 0:
					break ;
				case 1:
				case 3:
				case 4:
					node.data=Render.supportWebGLPlusAnimation ? new ConchVector3 :new Vector3();
					break ;
				case 2:
					node.data=Render.supportWebGLPlusAnimation ? new ConchQuaternion :new Quaternion();
					break ;
				default :
					throw "AnimationClipParser04:unknown type.";
				}
			switch (AnimationClipParser04._version){
				case "LAYAANIMATION:04":
					for (j=0;j < keyframeCount;j++){
					switch (type){
						case 0:;
							var floatKeyframe=new FloatKeyframe();
							node._setKeyframeByIndex(j,floatKeyframe);
							startTime=floatKeyframe.time=startTimeTypes[reader.getUint16()];
							floatKeyframe.inTangent=reader.getFloat32();
							floatKeyframe.outTangent=reader.getFloat32();
							floatKeyframe.value=reader.getFloat32();
							break ;
						case 1:
						case 3:
						case 4:;
							var floatArrayKeyframe=new Vector3Keyframe();
							node._setKeyframeByIndex(j,floatArrayKeyframe);
							startTime=floatArrayKeyframe.time=startTimeTypes[reader.getUint16()];
							if (Render.supportWebGLPlusAnimation){
								var data=(floatArrayKeyframe).data=new Float32Array(3 *3);
								for (var k=0;k < 3;k++)
								data[k]=reader.getFloat32();
								for (k=0;k < 3;k++)
								data[3+k]=reader.getFloat32();
								for (k=0;k < 3;k++)
								data[6+k]=reader.getFloat32();
							}
							else {
								var inTangent=floatArrayKeyframe.inTangent;
								var outTangent=floatArrayKeyframe.outTangent;
								var value=floatArrayKeyframe.value;
								inTangent.x=reader.getFloat32();
								inTangent.y=reader.getFloat32();
								inTangent.z=reader.getFloat32();
								outTangent.x=reader.getFloat32();
								outTangent.y=reader.getFloat32();
								outTangent.z=reader.getFloat32();
								value.x=reader.getFloat32();
								value.y=reader.getFloat32();
								value.z=reader.getFloat32();
							}
							break ;
						case 2:;
							var quaternionKeyframe=new QuaternionKeyframe();
							node._setKeyframeByIndex(j,quaternionKeyframe);
							startTime=quaternionKeyframe.time=startTimeTypes[reader.getUint16()];
							if (Render.supportWebGLPlusAnimation){
								data=(quaternionKeyframe).data=new Float32Array(3 *4);
								for (k=0;k < 4;k++)
								data[k]=reader.getFloat32();
								for (k=0;k < 4;k++)
								data[4+k]=reader.getFloat32();
								for (k=0;k < 4;k++)
								data[8+k]=reader.getFloat32();
							}
							else {
								var inTangentQua=quaternionKeyframe.inTangent;
								var outTangentQua=quaternionKeyframe.outTangent;
								var valueQua=quaternionKeyframe.value;
								inTangentQua.x=reader.getFloat32();
								inTangentQua.y=reader.getFloat32();
								inTangentQua.z=reader.getFloat32();
								inTangentQua.w=reader.getFloat32();
								outTangentQua.x=reader.getFloat32();
								outTangentQua.y=reader.getFloat32();
								outTangentQua.z=reader.getFloat32();
								outTangentQua.w=reader.getFloat32();
								valueQua.x=reader.getFloat32();
								valueQua.y=reader.getFloat32();
								valueQua.z=reader.getFloat32();
								valueQua.w=reader.getFloat32();
							}
							break ;
						default :
							throw "AnimationClipParser04:unknown type.";
						}
				}
				break ;
				case "LAYAANIMATION:COMPRESSION_04":
				for (j=0;j < keyframeCount;j++){
					switch (type){
						case 0:
							floatKeyframe=new FloatKeyframe();
							node._setKeyframeByIndex(j,floatKeyframe);
							startTime=floatKeyframe.time=startTimeTypes[reader.getUint16()];
							floatKeyframe.inTangent=HalfFloatUtils.convertToNumber(reader.getUint16());
							floatKeyframe.outTangent=HalfFloatUtils.convertToNumber(reader.getUint16());
							floatKeyframe.value=HalfFloatUtils.convertToNumber(reader.getUint16());
							break ;
						case 1:
						case 3:
						case 4:
							floatArrayKeyframe=new Vector3Keyframe();
							node._setKeyframeByIndex(j,floatArrayKeyframe);
							startTime=floatArrayKeyframe.time=startTimeTypes[reader.getUint16()];
							if (Render.supportWebGLPlusAnimation){
								data=(floatArrayKeyframe).data=new Float32Array(3 *3);
								for (k=0;k < 3;k++)
								data[k]=HalfFloatUtils.convertToNumber(reader.getUint16());
								for (k=0;k < 3;k++)
								data[3+k]=HalfFloatUtils.convertToNumber(reader.getUint16());
								for (k=0;k < 3;k++)
								data[6+k]=HalfFloatUtils.convertToNumber(reader.getUint16());
							}
							else {
								inTangent=floatArrayKeyframe.inTangent;
								outTangent=floatArrayKeyframe.outTangent;
								value=floatArrayKeyframe.value;
								inTangent.x=HalfFloatUtils.convertToNumber(reader.getUint16());
								inTangent.y=HalfFloatUtils.convertToNumber(reader.getUint16());
								inTangent.z=HalfFloatUtils.convertToNumber(reader.getUint16());
								outTangent.x=HalfFloatUtils.convertToNumber(reader.getUint16());
								outTangent.y=HalfFloatUtils.convertToNumber(reader.getUint16());
								outTangent.z=HalfFloatUtils.convertToNumber(reader.getUint16());
								value.x=HalfFloatUtils.convertToNumber(reader.getUint16());
								value.y=HalfFloatUtils.convertToNumber(reader.getUint16());
								value.z=HalfFloatUtils.convertToNumber(reader.getUint16());
							}
							break ;
						case 2:
							quaternionKeyframe=new QuaternionKeyframe();
							node._setKeyframeByIndex(j,quaternionKeyframe);
							startTime=quaternionKeyframe.time=startTimeTypes[reader.getUint16()];
							if (Render.supportWebGLPlusAnimation){
								data=(quaternionKeyframe).data=new Float32Array(3 *4);
								for (k=0;k < 4;k++)
								data[k]=HalfFloatUtils.convertToNumber(reader.getUint16());
								for (k=0;k < 4;k++)
								data[4+k]=HalfFloatUtils.convertToNumber(reader.getUint16());
								for (k=0;k < 4;k++)
								data[8+k]=HalfFloatUtils.convertToNumber(reader.getUint16());
							}
							else {
								inTangentQua=quaternionKeyframe.inTangent;
								outTangentQua=quaternionKeyframe.outTangent;
								valueQua=quaternionKeyframe.value;
								inTangentQua.x=HalfFloatUtils.convertToNumber(reader.getUint16());
								inTangentQua.y=HalfFloatUtils.convertToNumber(reader.getUint16());
								inTangentQua.z=HalfFloatUtils.convertToNumber(reader.getUint16());
								inTangentQua.w=HalfFloatUtils.convertToNumber(reader.getUint16());
								outTangentQua.x=HalfFloatUtils.convertToNumber(reader.getUint16());
								outTangentQua.y=HalfFloatUtils.convertToNumber(reader.getUint16());
								outTangentQua.z=HalfFloatUtils.convertToNumber(reader.getUint16());
								outTangentQua.w=HalfFloatUtils.convertToNumber(reader.getUint16());
								valueQua.x=HalfFloatUtils.convertToNumber(reader.getUint16());
								valueQua.y=HalfFloatUtils.convertToNumber(reader.getUint16());
								valueQua.z=HalfFloatUtils.convertToNumber(reader.getUint16());
								valueQua.w=HalfFloatUtils.convertToNumber(reader.getUint16());
							}
							break ;
						default :
							throw "AnimationClipParser04:unknown type.";
						}
				}
				break ;
			}
		};
		var eventCount=reader.getUint16();
		for (i=0;i < eventCount;i++){
			var event=new AnimationEvent();
			event.time=Math.min(clipDur,reader.getFloat32());
			event.eventName=AnimationClipParser04._strings[reader.getUint16()];
			var params;
			var paramCount=reader.getUint16();
			(paramCount > 0)&& (event.params=params=[]);
			for (j=0;j < paramCount;j++){
				var eventType=reader.getByte();
				switch (eventType){
					case 0:
						params.push(!!reader.getByte());
						break ;
					case 1:
						params.push(reader.getInt32());
						break ;
					case 2:
						params.push(reader.getFloat32());
						break ;
					case 3:
						params.push(AnimationClipParser04._strings[reader.getUint16()]);
						break ;
					default :
						throw new Error("unknown type.");
					}
			}
			clip.addEvent(event);
		}
	}

	AnimationClipParser04._animationClip=null;
	AnimationClipParser04._reader=null;
	AnimationClipParser04._strings=[];
	AnimationClipParser04._version=null;
	__static(AnimationClipParser04,
	['_BLOCK',function(){return this._BLOCK={count:0};},'_DATA',function(){return this._DATA={offset:0,size:0};}
	]);
	return AnimationClipParser04;
})()


/**
*@private
*/
//class laya.d3.animation.AnimationClipParser03
var AnimationClipParser03=(function(){
	function AnimationClipParser03(){}
	__class(AnimationClipParser03,'laya.d3.animation.AnimationClipParser03');
	AnimationClipParser03.READ_DATA=function(){
		AnimationClipParser03._DATA.offset=AnimationClipParser03._reader.getUint32();
		AnimationClipParser03._DATA.size=AnimationClipParser03._reader.getUint32();
	}

	AnimationClipParser03.READ_BLOCK=function(){
		var count=AnimationClipParser03._BLOCK.count=AnimationClipParser03._reader.getUint16();
		var blockStarts=AnimationClipParser03._BLOCK.blockStarts=[];
		var blockLengths=AnimationClipParser03._BLOCK.blockLengths=[];
		for (var i=0;i < count;i++){
			blockStarts.push(AnimationClipParser03._reader.getUint32());
			blockLengths.push(AnimationClipParser03._reader.getUint32());
		}
	}

	AnimationClipParser03.READ_STRINGS=function(){
		var offset=AnimationClipParser03._reader.getUint32();
		var count=AnimationClipParser03._reader.getUint16();
		var prePos=AnimationClipParser03._reader.pos;
		AnimationClipParser03._reader.pos=offset+AnimationClipParser03._DATA.offset;
		for (var i=0;i < count;i++)
		AnimationClipParser03._strings[i]=AnimationClipParser03._reader.readUTFString();
		AnimationClipParser03._reader.pos=prePos;
	}

	AnimationClipParser03.parse=function(clip,reader){
		AnimationClipParser03._animationClip=clip;
		AnimationClipParser03._reader=reader;
		var arrayBuffer=reader.__getBuffer();
		AnimationClipParser03.READ_DATA();
		AnimationClipParser03.READ_BLOCK();
		AnimationClipParser03.READ_STRINGS();
		for (var i=0,n=AnimationClipParser03._BLOCK.count;i < n;i++){
			var index=reader.getUint16();
			var blockName=AnimationClipParser03._strings[index];
			var fn=AnimationClipParser03["READ_"+blockName];
			if (fn==null)
				throw new Error("model file err,no this function:"+index+" "+blockName);
			else
			fn.call(null);
		}
	}

	AnimationClipParser03.READ_ANIMATIONS=function(){
		var i=0,j=0;
		var node;
		var reader=AnimationClipParser03._reader;
		var buffer=reader.__getBuffer();
		var startTimeTypes=[];
		var startTimeTypeCount=reader.getUint16();
		startTimeTypes.length=startTimeTypeCount;
		for (i=0;i < startTimeTypeCount;i++)
		startTimeTypes[i]=reader.getFloat32();
		var clip=AnimationClipParser03._animationClip;
		clip.name=AnimationClipParser03._strings[reader.getUint16()];
		var clipDur=clip._duration=reader.getFloat32();
		clip.islooping=!!reader.getByte();
		clip._frameRate=reader.getInt16();
		var nodeCount=reader.getInt16();
		var nodes=clip._nodes;
		nodes.count=nodeCount;
		var nodesMap=clip._nodesMap={};
		var nodesDic=clip._nodesDic={};
		for (i=0;i < nodeCount;i++){
			node=new KeyframeNode();
			nodes.setNodeByIndex(i,node);
			node._indexInList=i;
			var type=node.type=reader.getUint8();
			var pathLength=reader.getUint16();
			node._setOwnerPathCount(pathLength);
			for (j=0;j < pathLength;j++)
			node._setOwnerPathByIndex(j,AnimationClipParser03._strings[reader.getUint16()]);
			var nodePath=node._joinOwnerPath("/");
			var mapArray=nodesMap[nodePath];
			(mapArray)|| (nodesMap[nodePath]=mapArray=[]);
			mapArray.push(node);
			node.propertyOwner=AnimationClipParser03._strings[reader.getUint16()];
			var propertyLength=reader.getUint16();
			node._setPropertyCount(propertyLength);
			for (j=0;j < propertyLength;j++)
			node._setPropertyByIndex(j,AnimationClipParser03._strings[reader.getUint16()]);
			var fullPath=nodePath+"."+node.propertyOwner+"."+node._joinProperty(".");
			nodesDic[fullPath]=node;
			node.fullPath=fullPath;
			var keyframeCount=reader.getUint16();
			node._setKeyframeCount(keyframeCount);
			var startTime=NaN;
			switch (type){
				case 0:
					break ;
				case 1:
				case 3:
				case 4:
					node.data=Render.supportWebGLPlusAnimation ? new ConchVector3 :new Vector3();
					break ;
				case 2:
					node.data=Render.supportWebGLPlusAnimation ? new ConchQuaternion :new Quaternion();
					break ;
				default :
					throw "AnimationClipParser03:unknown type.";
				}
			for (j=0;j < keyframeCount;j++){
				switch (type){
					case 0:;
						var floatKeyframe=new FloatKeyframe();
						node._setKeyframeByIndex(j,floatKeyframe);
						startTime=floatKeyframe.time=startTimeTypes[reader.getUint16()];
						floatKeyframe.inTangent=reader.getFloat32();
						floatKeyframe.outTangent=reader.getFloat32();
						floatKeyframe.value=reader.getFloat32();
						break ;
					case 1:
					case 3:
					case 4:;
						var floatArrayKeyframe=new Vector3Keyframe();
						node._setKeyframeByIndex(j,floatArrayKeyframe);
						startTime=floatArrayKeyframe.time=startTimeTypes[reader.getUint16()];
						if (Render.supportWebGLPlusAnimation){
							var data=(floatArrayKeyframe).data=new Float32Array(3 *3);
							for (var k=0;k < 3;k++)
							data[k]=reader.getFloat32();
							for (k=0;k < 3;k++)
							data[3+k]=reader.getFloat32();
							for (k=0;k < 3;k++)
							data[6+k]=reader.getFloat32();
						}
						else {
							var inTangent=floatArrayKeyframe.inTangent;
							var outTangent=floatArrayKeyframe.outTangent;
							var value=floatArrayKeyframe.value;
							inTangent.x=reader.getFloat32();
							inTangent.y=reader.getFloat32();
							inTangent.z=reader.getFloat32();
							outTangent.x=reader.getFloat32();
							outTangent.y=reader.getFloat32();
							outTangent.z=reader.getFloat32();
							value.x=reader.getFloat32();
							value.y=reader.getFloat32();
							value.z=reader.getFloat32();
						}
						break ;
					case 2:;
						var quaArrayKeyframe=new QuaternionKeyframe();
						node._setKeyframeByIndex(j,quaArrayKeyframe);
						startTime=quaArrayKeyframe.time=startTimeTypes[reader.getUint16()];
						if (Render.supportWebGLPlusAnimation){
							data=(quaArrayKeyframe).data=new Float32Array(3 *4);
							for (k=0;k < 4;k++)
							data[k]=reader.getFloat32();
							for (k=0;k < 4;k++)
							data[4+k]=reader.getFloat32();
							for (k=0;k < 4;k++)
							data[8+k]=reader.getFloat32();
						}
						else {
							var inTangentQua=quaArrayKeyframe.inTangent;
							var outTangentQua=quaArrayKeyframe.outTangent;
							var valueQua=quaArrayKeyframe.value;
							inTangentQua.x=reader.getFloat32();
							inTangentQua.y=reader.getFloat32();
							inTangentQua.z=reader.getFloat32();
							inTangentQua.w=reader.getFloat32();
							outTangentQua.x=reader.getFloat32();
							outTangentQua.y=reader.getFloat32();
							outTangentQua.z=reader.getFloat32();
							outTangentQua.w=reader.getFloat32();
							valueQua.x=reader.getFloat32();
							valueQua.y=reader.getFloat32();
							valueQua.z=reader.getFloat32();
							valueQua.w=reader.getFloat32();
						}
						break ;
					default :
						throw "AnimationClipParser03:unknown type.";
					}
			}
		};
		var eventCount=reader.getUint16();
		for (i=0;i < eventCount;i++){
			var event=new AnimationEvent();
			event.time=Math.min(clipDur,reader.getFloat32());
			event.eventName=AnimationClipParser03._strings[reader.getUint16()];
			var params;
			var paramCount=reader.getUint16();
			(paramCount > 0)&& (event.params=params=[]);
			for (j=0;j < paramCount;j++){
				var eventType=reader.getByte();
				switch (eventType){
					case 0:
						params.push(!!reader.getByte());
						break ;
					case 1:
						params.push(reader.getInt32());
						break ;
					case 2:
						params.push(reader.getFloat32());
						break ;
					case 3:
						params.push(AnimationClipParser03._strings[reader.getUint16()]);
						break ;
					default :
						throw new Error("unknown type.");
					}
			}
			clip.addEvent(event);
		}
	}

	AnimationClipParser03._animationClip=null;
	AnimationClipParser03._reader=null;
	AnimationClipParser03._strings=[];
	__static(AnimationClipParser03,
	['_BLOCK',function(){return this._BLOCK={count:0};},'_DATA',function(){return this._DATA={offset:0,size:0};}
	]);
	return AnimationClipParser03;
})()


/**
*<code>DefineDatas</code> 类用于创建宏定义数据。
*/
//class laya.d3.shader.DefineDatas
var DefineDatas=(function(){
	function DefineDatas(){
		/**@private */
		//this.value=0;
		this.value=0;
	}

	__class(DefineDatas,'laya.d3.shader.DefineDatas');
	var __proto=DefineDatas.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*增加Shader宏定义。
	*@param value 宏定义。
	*/
	__proto.add=function(define){
		this.value |=define;
	}

	/**
	*移除Shader宏定义。
	*@param value 宏定义。
	*/
	__proto.remove=function(define){
		this.value &=~define;
	}

	/**
	*是否包含Shader宏定义。
	*@param value 宏定义。
	*/
	__proto.has=function(define){
		return (this.value & define)> 0;
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destDefineData=destObject;
		destDefineData.value=this.value;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var dest=/*__JS__ */new this.constructor();
		this.cloneTo(dest);
		return dest;
	}

	return DefineDatas;
})()


/**
*<code>VertexElement</code> 类用于创建顶点结构分配。
*/
//class laya.d3.graphics.VertexElement
var VertexElement=(function(){
	function VertexElement(offset,elementFormat,elementUsage){
		this.offset=0;
		this.elementFormat=null;
		this.elementUsage=0;
		this.offset=offset;
		this.elementFormat=elementFormat;
		this.elementUsage=elementUsage;
	}

	__class(VertexElement,'laya.d3.graphics.VertexElement');
	return VertexElement;
})()


/**
*<code>HeightMap</code> 类用于实现高度图数据。
*/
//class laya.d3.core.HeightMap
var HeightMap=(function(){
	function HeightMap(width,height,minHeight,maxHeight){
		/**@private */
		this._datas=null;
		/**@private */
		this._w=0;
		/**@private */
		this._h=0;
		/**@private */
		this._minHeight=NaN;
		/**@private */
		this._maxHeight=NaN;
		this._datas=[];
		this._w=width;
		this._h=height;
		this._minHeight=minHeight;
		this._maxHeight=maxHeight;
	}

	__class(HeightMap,'laya.d3.core.HeightMap');
	var __proto=HeightMap.prototype;
	/**@private */
	__proto._inBounds=function(row,col){
		return row >=0 && row < this._h && col >=0 && col < this._w;
	}

	/**
	*获取高度。
	*@param row 列数。
	*@param col 行数。
	*@return 高度。
	*/
	__proto.getHeight=function(row,col){
		if (this._inBounds(row,col))
			return this._datas[row][col];
		else
		return NaN;
	}

	/**
	*获取宽度。
	*@return value 宽度。
	*/
	__getset(0,__proto,'width',function(){
		return this._w;
	});

	/**
	*获取高度。
	*@return value 高度。
	*/
	__getset(0,__proto,'height',function(){
		return this._h;
	});

	/**
	*最大高度。
	*@return value 最大高度。
	*/
	__getset(0,__proto,'maxHeight',function(){
		return this._maxHeight;
	});

	/**
	*最大高度。
	*@return value 最大高度。
	*/
	__getset(0,__proto,'minHeight',function(){
		return this._minHeight;
	});

	HeightMap.creatFromMesh=function(mesh,width,height,outCellSize){
		var vertices=[];
		var indexs=[];
		var submesheCount=mesh.subMeshCount;
		for (var i=0;i < submesheCount;i++){
			var subMesh=mesh._getSubMesh(i);
			var vertexBuffer=subMesh._vertexBuffer;
			var verts=vertexBuffer.getData();
			var subMeshVertices=[];
			for (var j=0;j < verts.length;j+=vertexBuffer.vertexDeclaration.vertexStride / 4){
				var position=new Vector3(verts[j+0],verts[j+1],verts[j+2]);
				subMeshVertices.push(position);
			}
			vertices.push(subMeshVertices);
			var ib=subMesh._indexBuffer;
			indexs.push(ib.getData());
		};
		var bounds=mesh.bounds;
		var minX=bounds.getMin().x;
		var minZ=bounds.getMin().z;
		var maxX=bounds.getMax().x;
		var maxZ=bounds.getMax().z;
		var minY=bounds.getMin().y;
		var maxY=bounds.getMax().y;
		var widthSize=maxX-minX;
		var heightSize=maxZ-minZ;
		var cellWidth=outCellSize.x=widthSize / (width-1);
		var cellHeight=outCellSize.y=heightSize / (height-1);
		var heightMap=new HeightMap(width,height,minY,maxY);
		var ray=HeightMap._tempRay;
		var rayDir=ray.direction;
		rayDir.x=0;
		rayDir.y=-1;
		rayDir.z=0;
		var heightOffset=0.1;
		var rayY=maxY+heightOffset;
		ray.origin.y=rayY;
		for (var h=0;h < height;h++){
			var posZ=minZ+h *cellHeight;
			heightMap._datas[h]=[];
			for (var w=0;w < width;w++){
				var posX=minX+w *cellWidth;
				var rayOri=ray.origin;
				rayOri.x=posX;
				rayOri.z=posZ;
				var closestIntersection=HeightMap._getPosition(ray,vertices,indexs);
				heightMap._datas[h][w]=(closestIntersection===Number.MAX_VALUE)? NaN :rayY-closestIntersection;
			}
		}
		return heightMap;
	}

	HeightMap.createFromImage=function(texture,minHeight,maxHeight){
		var textureWidth=texture.width;
		var textureHeight=texture.height;
		var heightMap=new HeightMap(textureWidth,textureHeight,minHeight,maxHeight);
		var compressionRatio=(maxHeight-minHeight)/ 254;
		var pixelsInfo=texture.getPixels();
		var index=0;
		for (var h=0;h <textureHeight;h++){
			var colDatas=heightMap._datas[h]=[];
			for (var w=0;w < textureWidth;w++){
				var r=pixelsInfo[index++];
				var g=pixelsInfo[index++];
				var b=pixelsInfo[index++];
				var a=pixelsInfo[index++];
				if (r==255 && g==255 && b==255 && a==255)
					colDatas[w]=NaN;
				else {
					colDatas[w]=(r+g+b)/ 3 *compressionRatio+minHeight;
				}
			}
		}
		return heightMap;
	}

	HeightMap._getPosition=function(ray,vertices,indexs){
		var closestIntersection=Number.MAX_VALUE;
		for (var i=0;i < vertices.length;i++){
			var subMeshVertices=vertices[i];
			var subMeshIndexes=indexs[i];
			for (var j=0;j < subMeshIndexes.length;j+=3){
				var vertex1=subMeshVertices[subMeshIndexes[j+0]];
				var vertex2=subMeshVertices[subMeshIndexes[j+1]];
				var vertex3=subMeshVertices[subMeshIndexes[j+2]];
				var intersection=Picker.rayIntersectsTriangle(ray,vertex1,vertex2,vertex3);
				if (!isNaN(intersection)&& intersection < closestIntersection){
					closestIntersection=intersection;
				}
			}
		}
		return closestIntersection;
	}

	__static(HeightMap,
	['_tempRay',function(){return this._tempRay=new Ray(new Vector3(),new Vector3());}
	]);
	return HeightMap;
})()


/**
*@private
*<code>ShaderInit</code> 类用于初始化内置Shader。
*/
//class laya.d3.shader.ShaderInit3D
var ShaderInit3D=(function(){
	/**
	*创建一个 <code>ShaderInit</code> 实例。
	*/
	function ShaderInit3D(){}
	__class(ShaderInit3D,'laya.d3.shader.ShaderInit3D');
	ShaderInit3D.__init__=function(){
		ShaderInit3D._rangeAttenTex=Utils3D._buildTexture2D(1024,1,/*laya.resource.BaseTexture.FORMAT_ALPHA8*/2,TextureGenerator.lightAttenTexture);
		ShaderInit3D._rangeAttenTex.wrapModeU=/*laya.resource.BaseTexture.WARPMODE_CLAMP*/1;
		ShaderInit3D._rangeAttenTex.wrapModeV=/*laya.resource.BaseTexture.WARPMODE_CLAMP*/1;
		ShaderInit3D._rangeAttenTex.lock=true;
		Shader3D.SHADERDEFINE_HIGHPRECISION=Shader3D.registerPublicDefine("HIGHPRECISION");
		Scene3D.SHADERDEFINE_FOG=Shader3D.registerPublicDefine("FOG");
		Scene3D.SHADERDEFINE_DIRECTIONLIGHT=Shader3D.registerPublicDefine("DIRECTIONLIGHT");
		Scene3D.SHADERDEFINE_POINTLIGHT=Shader3D.registerPublicDefine("POINTLIGHT");
		Scene3D.SHADERDEFINE_SPOTLIGHT=Shader3D.registerPublicDefine("SPOTLIGHT");
		Scene3D.SHADERDEFINE_CAST_SHADOW=Shader3D.registerPublicDefine("CASTSHADOW");
		Scene3D.SHADERDEFINE_SHADOW_PSSM1=Shader3D.registerPublicDefine("SHADOWMAP_PSSM1");
		Scene3D.SHADERDEFINE_SHADOW_PSSM2=Shader3D.registerPublicDefine("SHADOWMAP_PSSM2");
		Scene3D.SHADERDEFINE_SHADOW_PSSM3=Shader3D.registerPublicDefine("SHADOWMAP_PSSM3");
		Scene3D.SHADERDEFINE_SHADOW_PCF_NO=Shader3D.registerPublicDefine("SHADOWMAP_PCF_NO");
		Scene3D.SHADERDEFINE_SHADOW_PCF1=Shader3D.registerPublicDefine("SHADOWMAP_PCF1");
		Scene3D.SHADERDEFINE_SHADOW_PCF2=Shader3D.registerPublicDefine("SHADOWMAP_PCF2");
		Scene3D.SHADERDEFINE_SHADOW_PCF3=Shader3D.registerPublicDefine("SHADOWMAP_PCF3");
		Scene3D.SHADERDEFINE_REFLECTMAP=Shader3D.registerPublicDefine("REFLECTMAP");
		Shader3D.addInclude("Lighting.glsl","\nstruct DirectionLight {\n	vec3 Color;\n	vec3 Direction;\n};\n\nstruct PointLight {\n	vec3 Color;\n	vec3 Position;\n	float Range;\n};\n\nstruct SpotLight {\n	vec3 Color;\n	vec3 Position;\n	vec3 Direction;\n	float Spot;\n	float Range;\n};\n\n// Laya中使用衰减纹理\nfloat LayaAttenuation(in vec3 L,in float invLightRadius) {\n	float fRatio = clamp(length(L) * invLightRadius,0.0,1.0);\n	fRatio *= fRatio;\n	return 1.0 / (1.0 + 25.0 * fRatio)* clamp(4.0*(1.0 - fRatio),0.0,1.0); //fade to black as if 4 pixel texture\n}\n\n// Same as Just Cause 2 and Crysis 2 (you can read GPU Pro 1 book for more information)\nfloat BasicAttenuation(in vec3 L,in float invLightRadius) {\n	vec3 distance = L * invLightRadius;\n	float attenuation = clamp(1.0 - dot(distance, distance),0.0,1.0); // Equals float attenuation = saturate(1.0f - dot(L, L) / (lightRadius *  lightRadius));\n	return attenuation * attenuation;\n}\n\n// Inspired on http://fools.slindev.com/viewtopic.php?f=11&t=21&view=unread#unread\nfloat NaturalAttenuation(in vec3 L,in float invLightRadius) {\n	float attenuationFactor = 30.0;\n	vec3 distance = L * invLightRadius;\n	float attenuation = dot(distance, distance); // Equals float attenuation = dot(L, L) / (lightRadius *  lightRadius);\n	attenuation = 1.0 / (attenuation * attenuationFactor + 1.0);\n	// Second we move down the function therewith it reaches zero at abscissa 1:\n	attenuationFactor = 1.0 / (attenuationFactor + 1.0); //attenuationFactor contains now the value we have to subtract\n	attenuation = max(attenuation - attenuationFactor, 0.0); // The max fixes a bug.\n	// Finally we expand the equation along the y-axis so that it starts with a function value of 1 again.\n	attenuation /= 1.0 - attenuationFactor;\n	return attenuation;\n}\n\nvoid LayaAirBlinnPhongLight (in vec3 specColor,in float specColorIntensity,in vec3 normal,in vec3 gloss, in vec3 viewDir,in vec3 lightColor, in vec3 lightVec,out vec3 diffuseColor,out vec3 specularColor) {\n	mediump vec3 h = normalize(viewDir-lightVec);\n	lowp float ln = max (0.0, dot (-lightVec,normal));\n	float nh = max (0.0, dot (h,normal));\n	diffuseColor=lightColor * ln;\n	specularColor=lightColor *specColor*pow (nh, specColorIntensity*128.0) * gloss;\n}\n\nvoid LayaAirBlinnPhongDiectionLight (in vec3 specColor,in float specColorIntensity,in vec3 normal,in vec3 gloss, in vec3 viewDir, in DirectionLight light,out vec3 diffuseColor,out vec3 specularColor) {\n	vec3 lightVec=normalize(light.Direction);\n	LayaAirBlinnPhongLight(specColor,specColorIntensity,normal,gloss,viewDir,light.Color,lightVec,diffuseColor,specularColor);\n}\n\nvoid LayaAirBlinnPhongPointLight (in vec3 pos,in vec3 specColor,in float specColorIntensity,in vec3 normal,in vec3 gloss, in vec3 viewDir, in PointLight light,out vec3 diffuseColor,out vec3 specularColor) {\n	vec3 lightVec =  pos-light.Position;\n	//if( length(lightVec) > light.Range )\n	//	return;\n	LayaAirBlinnPhongLight(specColor,specColorIntensity,normal,gloss,viewDir,light.Color,lightVec/length(lightVec),diffuseColor,specularColor);\n	float attenuate = LayaAttenuation(lightVec, 1.0/light.Range);\n	diffuseColor *= attenuate;\n	specularColor*= attenuate;\n}\n\nvoid LayaAirBlinnPhongSpotLight (in vec3 pos,in vec3 specColor,in float specColorIntensity,in vec3 normal,in vec3 gloss, in vec3 viewDir, in SpotLight light,out vec3 diffuseColor,out vec3 specularColor) {\n	vec3 lightVec =  pos-light.Position;\n	//if( length(lightVec) > light.Range)\n	//	return;\n\n	vec3 normalLightVec=lightVec/length(lightVec);\n	LayaAirBlinnPhongLight(specColor,specColorIntensity,normal,gloss,viewDir,light.Color,normalLightVec,diffuseColor,specularColor);\n	vec2 cosAngles=cos(vec2(light.Spot,light.Spot*0.5)*0.5);//ConeAttenuation\n	float dl=dot(normalize(light.Direction),normalLightVec);\n	dl*=smoothstep(cosAngles[0],cosAngles[1],dl);\n	float attenuate = LayaAttenuation(lightVec, 1.0/light.Range)*dl;\n	diffuseColor *=attenuate;\n	specularColor *=attenuate;\n}\n\nvec3 NormalSampleToWorldSpace(vec3 normalMapSample, vec3 unitNormal, vec3 tangent,vec3 binormal) {\n	vec3 normalT =vec3(2.0*normalMapSample.x - 1.0,1.0-2.0*normalMapSample.y,2.0*normalMapSample.z - 1.0);\n\n	// Build orthonormal basis.\n	vec3 N = normalize(unitNormal);\n	vec3 T = normalize(tangent);\n	vec3 B = normalize(binormal);\n	mat3 TBN = mat3(T, B, N);\n\n	// Transform from tangent space to world space.\n	vec3 bumpedNormal = TBN*normalT;\n\n	return bumpedNormal;\n}\n\nvec3 NormalSampleToWorldSpace1(vec4 normalMapSample, vec3 tangent, vec3 binormal, vec3 unitNormal) {\n	vec3 normalT;\n	normalT.x = 2.0 * normalMapSample.x - 1.0;\n	normalT.y = 1.0 - 2.0 * normalMapSample.y;\n	normalT.z = sqrt(1.0 - clamp(dot(normalT.xy, normalT.xy), 0.0, 1.0));\n\n	vec3 T = normalize(tangent);\n	vec3 B = normalize(binormal);\n	vec3 N = normalize(unitNormal);\n	mat3 TBN = mat3(T, B, N);\n\n	// Transform from tangent space to world space.\n	vec3 bumpedNormal = TBN * normalize(normalT);\n\n	return bumpedNormal;\n}\n\nvec3 DecodeLightmap(vec4 color) {\n	return color.rgb*color.a*5.0;\n}\n\nvec2 TransformUV(vec2 texcoord,vec4 tilingOffset) {\n	vec2 transTexcoord=vec2(texcoord.x,texcoord.y-1.0)*tilingOffset.xy+vec2(tilingOffset.z,-tilingOffset.w);\n	transTexcoord.y+=1.0;\n	return transTexcoord;\n}\n\nvec4 remapGLPositionZ(vec4 position) {\n	position.z=position.z * 2.0 - position.w;\n	return position;\n}\n\nmat3 inverse(mat3 m) {\n  float a00 = m[0][0], a01 = m[0][1], a02 = m[0][2];\n  float a10 = m[1][0], a11 = m[1][1], a12 = m[1][2];\n  float a20 = m[2][0], a21 = m[2][1], a22 = m[2][2];\n\n  float b01 = a22 * a11 - a12 * a21;\n  float b11 = -a22 * a10 + a12 * a20;\n  float b21 = a21 * a10 - a11 * a20;\n\n  float det = a00 * b01 + a01 * b11 + a02 * b21;\n\n  return mat3(b01, (-a22 * a01 + a02 * a21), (a12 * a01 - a02 * a11),\n              b11, (a22 * a00 - a02 * a20), (-a12 * a00 + a02 * a10),\n              b21, (-a21 * a00 + a01 * a20), (a11 * a00 - a01 * a10)) / det;\n}\n\n");
		Shader3D.addInclude("ShadowHelper.glsl","uniform sampler2D u_shadowMap1;\nuniform sampler2D u_shadowMap2;\nuniform sampler2D u_shadowMap3;\nuniform vec2	  u_shadowPCFoffset;\nuniform vec4     u_shadowPSSMDistance;\nvec4 packDepth(const in float depth)\n{\n	const vec4 bitShift = vec4(256.0*256.0*256.0, 256.0*256.0, 256.0, 1.0);\n	const vec4 bitMask	= vec4(0.0, 1.0/256.0, 1.0/256.0, 1.0/256.0);\n	vec4 res = mod(depth*bitShift*vec4(255), vec4(256))/vec4(255);\n	res -= res.xxyz * bitMask;\n	return res;\n}\nfloat unpackDepth(const in vec4 rgbaDepth)\n{\n	const vec4 bitShift = vec4(1.0/(256.0*256.0*256.0), 1.0/(256.0*256.0), 1.0/256.0, 1.0);\n	float depth = dot(rgbaDepth, bitShift);\n	return depth;\n}\nfloat tex2DPCF( sampler2D shadowMap,vec2 texcoord,vec2 invsize,float zRef )\n{\n	vec2 texelpos =texcoord / invsize;\n	vec2 lerps = fract( texelpos );\n	float sourcevals[4];\n	sourcevals[0] = float( unpackDepth(texture2D(shadowMap,texcoord)) > zRef );\n	sourcevals[1] = float( unpackDepth(texture2D(shadowMap,texcoord + vec2(invsize.x,0))) > zRef );\n	sourcevals[2] = float( unpackDepth(texture2D(shadowMap,texcoord + vec2(0,invsize.y))) > zRef );\n	sourcevals[3] = float( unpackDepth(texture2D(shadowMap,texcoord + vec2(invsize.x, invsize.y) )) > zRef );\n	return mix( mix(sourcevals[0],sourcevals[2],lerps.y),mix(sourcevals[1],sourcevals[3],lerps.y),lerps.x );\n}\nfloat getShadowPSSM3( sampler2D shadowMap1,sampler2D shadowMap2,sampler2D shadowMap3,mat4 lightShadowVP[4],vec4 pssmDistance,vec2 shadowPCFOffset,vec3 worldPos,float posViewZ,float zBias )\n{\n	float value = 1.0;\n	int nPSNum = int(posViewZ>pssmDistance.x);\n	nPSNum += int(posViewZ>pssmDistance.y);\n	nPSNum += int(posViewZ>pssmDistance.z);\n	//真SB,webgl不支持在PS中直接访问数组\n	mat4 lightVP;\n	if( nPSNum == 0 )\n	{\n		lightVP = lightShadowVP[1];\n	}\n	else if( nPSNum == 1 )\n	{\n		lightVP = lightShadowVP[2];\n	}\n	else if( nPSNum == 2 )\n	{\n		lightVP = lightShadowVP[3];\n	}\n	vec4 vLightMVPPos = lightVP * vec4(worldPos,1.0);\n	//为了效率，在CPU计算/2.0 + 0.5\n	//vec3 vText = (vLightMVPPos.xyz / vLightMVPPos.w)/2.0 + 0.5;\n	vec3 vText = vLightMVPPos.xyz / vLightMVPPos.w;\n	float fMyZ = vText.z - zBias;\n	/*\n	bvec4 bInFrustumVec = bvec4 ( vText.x >= 0.0, vText.x <= 1.0, vText.y >= 0.0, vText.y <= 1.0 );\n	bool bInFrustum = all( bInFrustumVec );\n	bvec2 bFrustumTestVec = bvec2( bInFrustum, fMyZ <= 1.0 );\n	bool bFrustumTest = all( bFrustumTestVec );\n	if ( bFrustumTest ) \n	*/\n	if( fMyZ <= 1.0 )\n	{\n		float zdepth=0.0;\n#ifdef SHADOWMAP_PCF3\n		if ( nPSNum == 0 )\n		{\n			value =  tex2DPCF( shadowMap1, vText.xy,shadowPCFOffset,fMyZ );\n			value += tex2DPCF( shadowMap1, vText.xy+vec2(shadowPCFOffset.xy),shadowPCFOffset,	fMyZ );\n			value += tex2DPCF( shadowMap1, vText.xy+vec2(shadowPCFOffset.x,0),shadowPCFOffset,	fMyZ );\n			value += tex2DPCF( shadowMap1, vText.xy+vec2(0,shadowPCFOffset.y),shadowPCFOffset,	fMyZ );\n			value = value/4.0;\n		} \n		else if( nPSNum == 1 )\n		{\n			value = tex2DPCF( shadowMap2,vText.xy,shadowPCFOffset,fMyZ);\n		}\n		else if( nPSNum == 2 )\n		{\n			vec4 color = texture2D( shadowMap3,vText.xy );\n			zdepth = unpackDepth(color);\n			value = float(fMyZ < zdepth);\n		}\n#endif\n#ifdef SHADOWMAP_PCF2\n		if ( nPSNum == 0 )\n		{\n			value = tex2DPCF( shadowMap1,vText.xy,shadowPCFOffset,fMyZ);\n		}\n		else if( nPSNum == 1 )\n		{\n			value = tex2DPCF( shadowMap2,vText.xy,shadowPCFOffset,fMyZ);\n		}\n		else if( nPSNum == 2 )\n		{\n			vec4 color = texture2D( shadowMap3,vText.xy );\n			zdepth = unpackDepth(color);\n			value = float(fMyZ < zdepth);\n		}\n\n#endif\n#ifdef SHADOWMAP_PCF1\n		if ( nPSNum == 0 )\n		{\n			value = tex2DPCF( shadowMap1,vText.xy,shadowPCFOffset,fMyZ);\n		}\n		else if( nPSNum == 1 )\n		{\n			vec4 color = texture2D( shadowMap2,vText.xy );\n			zdepth = unpackDepth(color);\n			value = float(fMyZ < zdepth);\n		}\n		else if( nPSNum == 2 )\n		{\n			vec4 color = texture2D( shadowMap3,vText.xy );\n			zdepth = unpackDepth(color);\n			value = float(fMyZ < zdepth);\n		}\n#endif\n#ifdef SHADOWMAP_PCF_NO\n		vec4 color;\n		if ( nPSNum == 0 )\n		{\n			color = texture2D( shadowMap1,vText.xy );\n		}\n		else if( nPSNum == 1 )\n		{\n			color = texture2D( shadowMap2,vText.xy );\n		}\n		else if( nPSNum == 2 )\n		{\n			color = texture2D( shadowMap3,vText.xy );\n		}\n		zdepth = unpackDepth(color);\n		value = float(fMyZ < zdepth);\n#endif\n	}\n	return value;\n}\nfloat getShadowPSSM2( sampler2D shadowMap1,sampler2D shadowMap2,mat4 lightShadowVP[4],vec4 pssmDistance,vec2 shadowPCFOffset,vec3 worldPos,float posViewZ,float zBias )\n{\n	float value = 1.0;\n	int nPSNum = int(posViewZ>pssmDistance.x);\n	nPSNum += int(posViewZ>pssmDistance.y);\n	//真SB,webgl不支持在PS中直接访问数组\n	mat4 lightVP;\n	if( nPSNum == 0 )\n	{\n		lightVP = lightShadowVP[1];\n	}\n	else if( nPSNum == 1 )\n	{\n		lightVP = lightShadowVP[2];\n	}\n	vec4 vLightMVPPos = lightVP * vec4(worldPos,1.0);\n	//为了效率，在CPU计算/2.0 + 0.5\n	//vec3 vText = (vLightMVPPos.xyz / vLightMVPPos.w)/2.0 + 0.5;\n	vec3 vText = vLightMVPPos.xyz / vLightMVPPos.w;\n	float fMyZ = vText.z - zBias;\n	/*\n	bvec4 bInFrustumVec = bvec4 ( vText.x >= 0.0, vText.x <= 1.0, vText.y >= 0.0, vText.y <= 1.0 );\n	bool bInFrustum = all( bInFrustumVec );\n	bvec2 bFrustumTestVec = bvec2( bInFrustum, fMyZ <= 1.0 );\n	bool bFrustumTest = all( bFrustumTestVec );\n	if ( bFrustumTest ) \n	*/\n	if( fMyZ <= 1.0 )\n	{\n		float zdepth=0.0;\n#ifdef SHADOWMAP_PCF3\n		if ( nPSNum == 0 )\n		{\n			value =  tex2DPCF( shadowMap1, vText.xy,shadowPCFOffset,fMyZ );\n			value += tex2DPCF( shadowMap1, vText.xy+vec2(shadowPCFOffset.xy),shadowPCFOffset,	fMyZ );\n			value += tex2DPCF( shadowMap1, vText.xy+vec2(shadowPCFOffset.x,0),shadowPCFOffset,	fMyZ );\n			value += tex2DPCF( shadowMap1, vText.xy+vec2(0,shadowPCFOffset.y),shadowPCFOffset,	fMyZ );\n			value = value/4.0;\n		}\n		else if( nPSNum == 1 )\n		{\n			value = tex2DPCF( shadowMap2,vText.xy,shadowPCFOffset,fMyZ);\n		}\n#endif\n#ifdef SHADOWMAP_PCF2\n		if ( nPSNum == 0 )\n		{\n			value = tex2DPCF( shadowMap1,vText.xy,shadowPCFOffset,fMyZ);\n		}\n		else if( nPSNum == 1 )\n		{\n			value = tex2DPCF( shadowMap2,vText.xy,shadowPCFOffset,fMyZ);\n		}\n#endif\n#ifdef SHADOWMAP_PCF1\n		if ( nPSNum == 0 )\n		{\n			value = tex2DPCF( shadowMap1,vText.xy,shadowPCFOffset,fMyZ);\n		}\n		else if( nPSNum == 1 )\n		{\n			vec4 color = texture2D( shadowMap2,vText.xy );\n			zdepth = unpackDepth(color);\n			value = float(fMyZ < zdepth);\n		}\n#endif\n#ifdef SHADOWMAP_PCF_NO\n		vec4 color;\n		if ( nPSNum == 0 )\n		{\n			color = texture2D( shadowMap1,vText.xy );\n		}\n		else if( nPSNum == 1 )\n		{\n			color = texture2D( shadowMap2,vText.xy );\n		}\n		zdepth = unpackDepth(color);\n		value = float(fMyZ < zdepth);\n#endif\n	}\n	return value;\n}\nfloat getShadowPSSM1( sampler2D shadowMap1,vec4 lightMVPPos,vec4 pssmDistance,vec2 shadowPCFOffset,float posViewZ,float zBias )\n{\n	float value = 1.0;\n	if( posViewZ < pssmDistance.x )\n	{\n		vec3 vText = lightMVPPos.xyz / lightMVPPos.w;\n		float fMyZ = vText.z - zBias;\n		/*\n		bvec4 bInFrustumVec = bvec4 ( vText.x >= 0.0, vText.x <= 1.0, vText.y >= 0.0, vText.y <= 1.0 );\n		bool bInFrustum = all( bInFrustumVec );\n		bvec2 bFrustumTestVec = bvec2( bInFrustum, fMyZ <= 1.0 );\n		bool bFrustumTest = all( bFrustumTestVec );\n		*/\n		if ( fMyZ <= 1.0 ) \n		{\n			float zdepth=0.0;\n#ifdef SHADOWMAP_PCF3\n			value =  tex2DPCF( shadowMap1, vText.xy,shadowPCFOffset,fMyZ );\n			value += tex2DPCF( shadowMap1, vText.xy+vec2(shadowPCFOffset.xy),shadowPCFOffset,fMyZ );\n			value += tex2DPCF( shadowMap1, vText.xy+vec2(shadowPCFOffset.x,0),shadowPCFOffset,fMyZ );\n			value += tex2DPCF( shadowMap1, vText.xy+vec2(0,shadowPCFOffset.y),shadowPCFOffset,fMyZ );\n			value = value/4.0;\n#endif\n#ifdef SHADOWMAP_PCF2		\n			value = tex2DPCF( shadowMap1,vText.xy,shadowPCFOffset,fMyZ);\n#endif\n#ifdef SHADOWMAP_PCF1\n			value = tex2DPCF( shadowMap1,vText.xy,shadowPCFOffset,fMyZ);\n#endif\n#ifdef SHADOWMAP_PCF_NO		\n			vec4 color = texture2D( shadowMap1,vText.xy );\n			zdepth = unpackDepth(color);\n			value = float(fMyZ < zdepth);\n#endif\n		}\n	}\n	return value;\n}");
		Shader3D.addInclude("BRDF.glsl","struct LayaGI\n{\n	vec3 diffuse;\n	vec3 specular;\n};\n\nvec4 LayaAirBRDF(in vec3 diffuseColor, in vec3 specularColor, in float oneMinusReflectivity, in float smoothness, in vec3 normal, in vec3 viewDir, in vec3 lightDir, in vec3 lightColor, in LayaGI gi)\n{\n	float perceptualRoughness = SmoothnessToPerceptualRoughness(smoothness);\n	vec3 halfDir = SafeNormalize(viewDir - lightDir);\n	\n	float nv = abs(dot(normal, viewDir));\n	\n	float nl = clamp(dot(normal,   -lightDir),  0.0, 1.0);\n	float nh = clamp(dot(normal,     halfDir),  0.0, 1.0);\n	float lv = clamp(dot(lightDir,   viewDir),  0.0, 1.0);\n	float lh = clamp(dot(lightDir,  -halfDir),  0.0, 1.0);\n	\n	float diffuseTerm = DisneyDiffuse(nv, nl, lh, perceptualRoughness) * nl;\n	\n	float roughness = PerceptualRoughnessToRoughness(perceptualRoughness);\n	\n	//#if UNITY_BRDF_GGX\n	float V = SmithJointGGXVisibilityTerm(nl, nv, roughness);\n	float D = GGXTerm(nh, roughness);\n	\n	float specularTerm = V * D * PI;\n	\n	specularTerm = sqrt(max(0.0001, specularTerm));\n	specularTerm = max(0.0, specularTerm * nl);\n	\n	float surfaceReduction = 1.0 - 0.28 * roughness * perceptualRoughness;\n	float grazingTerm = clamp(smoothness + (1.0 - oneMinusReflectivity), 0.0, 1.0);\n	\n	vec4 color;\n	color.rgb = diffuseColor * (gi.diffuse + lightColor * diffuseTerm) \n			  + specularTerm * lightColor * FresnelTerm (specularColor, lh)\n			  + surfaceReduction * gi.specular * FresnelLerp(specularColor, vec3(grazingTerm), nv);\n	\n	return color;\n}");
		Shader3D.addInclude("PBRUtils.glsl","struct DirectionLight\n{\n	vec3 Color;\n	vec3 Direction;\n};\n\nstruct PointLight\n{\n	vec3 Color;\n	vec3 Position;\n	float Range;\n};\n\nstruct SpotLight\n{\n	vec3 Color;\n	vec3 Position;\n	vec3 Direction;\n	float SpotAngle;\n	float Range;\n};\n\nvec3 UnpackScaleNormal(in vec2 uv0)\n{\n	#ifdef NORMALTEXTURE\n		vec3 normalT;\n		vec4 normalMapSample = texture2D(u_NormalTexture, uv0);\n		normalT.x = 2.0 * normalMapSample.x - 1.0;\n		normalT.y = 1.0 - 2.0 * normalMapSample.y;\n		normalT.xy *= u_normalScale;\n		normalT.z = sqrt(1.0 - clamp(dot(normalT.xy, normalT.xy), 0.0, 1.0));\n		\n		vec3 T = normalize(v_Tangent);\n		vec3 B = normalize(v_Binormal);\n		vec3 N = normalize(v_Normal);\n		mat3 TBN = mat3(T, B, N);\n		\n		vec3 bumpedNormal = TBN * normalize(normalT);\n		return bumpedNormal;\n	#else\n		return normalize(v_Normal);\n	#endif\n}\n\nvec4 DielectricSpecularColor = vec4(0.220916301, 0.220916301, 0.220916301, 1.0 - 0.220916301);\n\nfloat PI = 3.14159265359;\n\nvec3 FresnelTerm (in vec3 F0, in float cosA)\n{\n	return F0 + (vec3(1.0) - F0) * pow(1.0 - cosA, 5.0);\n}\n\nvec3 FresnelLerp (in vec3 F0, in vec3 F90, float cosA)\n{\n    float t = pow(1.0 - cosA, 5.0);\n    return mix(F0, F90, t);\n}\n\nfloat PerceptualRoughnessToRoughness(in float perceptualRoughness)\n{\n	return perceptualRoughness * perceptualRoughness;\n}\n\nfloat PerceptualRoughnessToSpecularPower(in float perceptualRoughness)\n{\n	float m = PerceptualRoughnessToRoughness(perceptualRoughness);\n	float sq = max(0.0001, m * m);\n	float n = (2.0 / sq) - 2.0;\n	n = max(n, 0.0001);\n	return n;\n}\n\nfloat RoughnessToPerceptualRoughness(in float roughness)\n{\n	return sqrt(roughness);\n}\n\nfloat SmoothnessToRoughness(in float smoothness)\n{\n	return (1.0 - smoothness) * (1.0 - smoothness);\n}\n\nfloat SmoothnessToPerceptualRoughness(in float smoothness)\n{\n	return (1.0 - smoothness);\n}\n\nvec3 SafeNormalize(in vec3 inVec)\n{\n	float dp3 = max(0.001,dot(inVec,inVec));\n	return inVec * (1.0 / sqrt(dp3));\n}\n\nfloat DisneyDiffuse(in float NdotV, in float NdotL, in float LdotH, in float perceptualRoughness)\n{\n	float fd90 = 0.5 + 2.0 * LdotH * LdotH * perceptualRoughness;\n	float lightScatter	= (1.0 + (fd90 - 1.0) * pow(1.0 - NdotL,5.0));\n	float viewScatter	= (1.0 + (fd90 - 1.0) * pow(1.0 - NdotV,5.0));\n\n	return lightScatter * viewScatter;\n}\n\nfloat SmithJointGGXVisibilityTerm (float NdotL, float NdotV, float roughness)\n{\n	float a = roughness;\n	float lambdaV = NdotL * (NdotV * (1.0 - a) + a);\n	float lambdaL = NdotV * (NdotL * (1.0 - a) + a);\n\n	return 0.5 / (lambdaV + lambdaL + 0.00001);\n}\n\nfloat GGXTerm (float NdotH, float roughness)\n{\n	float a2 = roughness * roughness;\n	float d = (NdotH * a2 - NdotH) * NdotH + 1.0;\n	return 0.31830988618 * a2 / (d * d + 0.0000001);\n}\n\nfloat OneMinusReflectivityFromMetallic(in float metallic)\n{\n	float oneMinusDielectricSpec = DielectricSpecularColor.a;\n	return oneMinusDielectricSpec - metallic * oneMinusDielectricSpec;\n}\n\nfloat SpecularStrength(vec3 specular)\n{\n    //(SHADER_TARGET < 30)return specular.r; \n    return max (max (specular.r, specular.g), specular.b);\n}\n\nvec3 DiffuseAndSpecularFromMetallic(in vec3 diffuseColor, in float metallic, out vec3 specularColor, out float oneMinusReflectivity)\n{\n	specularColor = mix(DielectricSpecularColor.rgb, diffuseColor, metallic);\n	oneMinusReflectivity = OneMinusReflectivityFromMetallic(metallic);\n	return diffuseColor * oneMinusReflectivity;\n}\n\nvec3 EnergyConservationBetweenDiffuseAndSpecular(in vec3 diffuseColor, in vec3 specularColor, out float oneMinusReflectivity)\n{\n	oneMinusReflectivity = 1.0 - SpecularStrength(specularColor);\n	return diffuseColor * oneMinusReflectivity;\n}\n\nvec4 Occlusion(in vec2 uv0){\n	#ifdef OCCLUSIONTEXTURE\n		vec4 occlusionTextureColor = texture2D(u_OcclusionTexture, uv0);\n		float occ = occlusionTextureColor.g;\n		float oneMinusT = 1.0 - u_occlusionStrength;\n		float lerpOneTo = oneMinusT + occ * u_occlusionStrength;\n		return occlusionTextureColor * lerpOneTo;\n	#else\n		return vec4(1.0);\n	#endif\n}\n\nvec2 ParallaxOffset(in vec3 viewDir){\n	#ifdef PARALLAXTEXTURE\n		float h = texture2D(u_ParallaxTexture, v_Texcoord0).g;\n		h = h * u_parallaxScale - u_parallaxScale / 2.0;\n		vec3 v = viewDir;\n		v.z += 0.42;\n		vec2 offset = h * (v.xy / v.z);\n		return v_Texcoord0 + offset;\n	#else\n		return v_Texcoord0;\n	#endif\n}\n\nvec3 ReflectCubeMap(in vec3 viewDir, in vec3 normal){\n	#ifdef REFLECTMAP\n		vec3 incident = -viewDir;\n		vec3 reflectionVector = reflect(incident, normal);\n		vec3 reflectionColor = textureCube(u_ReflectTexture, vec3(-reflectionVector.x, reflectionVector.yz)).rgb;\n		return reflectionColor * u_ReflectIntensity;\n	#else\n		return vec3(0.0);\n	#endif\n}\n\nfloat LayaAttenuation(in vec3 L, in float invLightRadius)\n{\n	float fRatio = clamp(length(L) * invLightRadius, 0.0, 1.0);\n	fRatio *= fRatio;\n	return 1.0 / (1.0 + 25.0 * fRatio) * clamp(4.0*(1.0 - fRatio), 0.0, 1.0); //fade to black as if 4 pixel texture\n}\n\nvec3 LayaPreMultiplyAlpha(vec3 diffColor, float alpha, float oneMinusReflectivity, out float outModifiedAlpha)\n{\n	#ifdef ALPHAPREMULTIPLY\n		diffColor *= alpha;\n		outModifiedAlpha = 1.0 - oneMinusReflectivity + alpha * oneMinusReflectivity;\n	#else\n		outModifiedAlpha = alpha;\n	#endif\n	return diffColor;\n}\n\n");
		Shader3D.addInclude("PBRStandardLighting.glsl","#include \"PBRUtils.glsl\"\n#include \"BRDF.glsl\"\n\nvec4 PBRStandardLight(in vec4 albedoColor, in float metallic, in float smoothness, in vec3 normal, in vec3 viewDir, in vec3 lightDir, in vec3 lightColor, in LayaGI gi)\n{\n	float oneMinusReflectivity;\n	vec3 diffuseColor;\n	vec3 specularColor;\n	float alpha;\n	\n	diffuseColor = DiffuseAndSpecularFromMetallic (albedoColor.rgb, metallic, specularColor, oneMinusReflectivity);\n	\n	diffuseColor = LayaPreMultiplyAlpha(diffuseColor, albedoColor.a, oneMinusReflectivity, alpha);\n	\n	vec4 color = LayaAirBRDF(diffuseColor, specularColor, oneMinusReflectivity, smoothness, normal, viewDir, lightDir, lightColor, gi);\n	color.a = alpha;\n	return color;\n}\n\nvec4 PBRStandardDiectionLight (in vec4 albedoColor, in float metallic, in float smoothness, in vec3 normal, in vec3 viewDir, in DirectionLight light, in LayaGI gi)\n{\n	vec3 lightVec = normalize(light.Direction);\n	return PBRStandardLight(albedoColor, metallic, smoothness, normal, viewDir, lightVec, light.Color, gi);\n}\n\nvec4 PBRStandardPointLight (in vec4 albedoColor, in float metallic, in float smoothness, in vec3 normal, in vec3 viewDir, in PointLight light, in vec3 pos, in LayaGI gi)\n{\n	vec3 lightCoord = (u_PointLightMatrix * vec4(pos, 1.0)).xyz;\n	float distance = dot(lightCoord, lightCoord);\n	float attenuate = texture2D(u_RangeTexture, vec2(distance)).w;\n	vec3 lightVec = normalize(pos - light.Position);\n	return PBRStandardLight(albedoColor, metallic, smoothness, normal, viewDir, lightVec, light.Color, gi) * attenuate;\n}\n\nvec4 PBRStandardSpotLight (in vec4 albedoColor, in float metallic, in float smoothness, in vec3 normal, in vec3 viewDir, in SpotLight light, in vec3 pos, in LayaGI gi)\n{\n	vec3 lightVec =  pos - light.Position;\n	vec3 normalLightVec = normalize(lightVec);\n	vec2 cosAngles = cos(vec2(light.SpotAngle, light.SpotAngle*0.5) * 0.5);//ConeAttenuation\n	float dl = dot(normalize(light.Direction), normalLightVec);\n	dl *= smoothstep(cosAngles[0], cosAngles[1], dl);\n	float attenuate = LayaAttenuation(lightVec, 1.0/light.Range) * dl;\n	return PBRStandardLight(albedoColor, metallic, smoothness, normal, viewDir, lightVec, light.Color, gi) * attenuate;\n}\n\n//vec4 PBRStandardSpotLight1 (in vec4 albedoColor, in float metallic, in float smoothness, in vec3 normal, in vec3 viewDir, in SpotLight light, in vec3 pos, in LayaGI gi)\n//{\n//	vec4 lightCoord = u_SpotLightMatrix * vec4(pos, 1.0);\n//	\n//	float distance = dot(lightCoord, lightCoord);\n//	float attenuate = (lightCoord.z < 0.0) ? texture2D(u_RangeTexture, vec2(distance)).w : 0.0;\n//	//float attenuate = (lightCoord.z < 0.0) ? texture2D(u_AngleTexture, vec2(lightCoord.x / lightCoord.w + 0.5, lightCoord.y / lightCoord.w + 0.5)).r * texture2D(u_RangeTexture, vec2(distance)).w : 0.0;\n//	//vec2 _uv = vec2(pos.x * 180.0/(2.0 * pos.z) + 0.5, pos.y * 180.0/(2.0 * pos.z) + 0.5);\n//	vec3 lightVec = normalize(pos - light.Position);\n//	return PBRStandardLight(albedoColor, metallic, smoothness, normal, viewDir, lightVec, light.Color, gi) * attenuate;\n//}\n\nvec2 MetallicGloss(in float albedoTextureAlpha, in vec2 uv0)\n{\n	vec2 mg;\n	\n	#ifdef METALLICGLOSSTEXTURE\n		vec4 metallicGlossTextureColor = texture2D(u_MetallicGlossTexture, uv0);\n		#ifdef SMOOTHNESSSOURCE_ALBEDOTEXTURE_ALPHA\n			mg.r = metallicGlossTextureColor.r;\n			mg.g = albedoTextureAlpha;\n		#else\n		    mg = metallicGlossTextureColor.ra;\n		#endif\n		mg.g *= u_smoothnessScale;\n	#else\n		mg.r = u_metallic;\n		#ifdef SMOOTHNESSSOURCE_ALBEDOTEXTURE_ALPHA\n			mg.g = albedoTextureAlpha * u_smoothnessScale;\n		#else\n			mg.g = u_smoothness;\n		#endif\n	#endif\n	\n	return mg;\n}\n\n");
		Shader3D.addInclude("PBRSpecularLighting.glsl","#include \"PBRUtils.glsl\"\n#include \"BRDF.glsl\"\n\nvec4 PBRSpecularLight(in vec4 albedoColor, in vec3 specularColor, in float smoothness, in vec3 normal, in vec3 viewDir, in vec3 lightDir, in vec3 lightColor, in LayaGI gi)\n{\n	float oneMinusReflectivity;\n	vec3 diffuseColor;\n	float alpha;\n	\n	diffuseColor = EnergyConservationBetweenDiffuseAndSpecular (albedoColor.rgb, specularColor, oneMinusReflectivity);\n	\n	diffuseColor = LayaPreMultiplyAlpha(diffuseColor, albedoColor.a, oneMinusReflectivity, alpha);\n	\n	vec4 color = LayaAirBRDF(diffuseColor, specularColor, oneMinusReflectivity, smoothness, normal, viewDir, lightDir, lightColor, gi);\n	color.a = alpha;\n	return color;\n}\n\nvec4 PBRSpecularDiectionLight (in vec4 albedoColor, in vec3 specularColor, in float smoothness, in vec3 normal, in vec3 viewDir, in DirectionLight light, in LayaGI gi)\n{\n	vec3 lightVec = normalize(light.Direction);\n	return PBRSpecularLight(albedoColor, specularColor, smoothness, normal, viewDir, lightVec, light.Color, gi);\n}\n\nvec4 PBRSpecularPointLight (in vec4 albedoColor, in vec3 specularColor, in float smoothness, in vec3 normal, in vec3 viewDir, in PointLight light, in vec3 pos, in LayaGI gi)\n{\n	vec3 lightCoord = (u_PointLightMatrix * vec4(pos, 1.0)).xyz;\n	float distance = dot(lightCoord, lightCoord);\n	float attenuate = texture2D(u_RangeTexture, vec2(distance)).w;\n	vec3 lightVec = normalize(pos - light.Position);\n	return PBRSpecularLight(albedoColor, specularColor, smoothness, normal, viewDir, lightVec, light.Color, gi) * attenuate;\n}\n\nvec4 PBRSpecularSpotLight (in vec4 albedoColor, in vec3 specularColor, in float smoothness, in vec3 normal, in vec3 viewDir, in SpotLight light, in vec3 pos, in LayaGI gi)\n{\n	vec3 lightVec =  pos - light.Position;\n	vec3 normalLightVec = normalize(lightVec);\n	vec2 cosAngles = cos(vec2(light.SpotAngle, light.SpotAngle*0.5) * 0.5);//ConeAttenuation\n	float dl = dot(normalize(light.Direction), normalLightVec);\n	dl *= smoothstep(cosAngles[0], cosAngles[1], dl);\n	float attenuate = LayaAttenuation(lightVec, 1.0/light.Range) * dl;\n	return PBRSpecularLight(albedoColor, specularColor, smoothness, normal, viewDir, lightVec, light.Color, gi) * attenuate;\n}\n\n//vec4 PBRStandardSpotLight1 (in vec4 albedoColor, in float metallic, in float smoothness, in vec3 normal, in vec3 viewDir, in SpotLight light, in vec3 pos, in LayaGI gi)\n//{\n//	vec4 lightCoord = u_SpotLightMatrix * vec4(pos, 1.0);\n//	\n//	float distance = dot(lightCoord, lightCoord);\n//	float attenuate = (lightCoord.z < 0.0) ? texture2D(u_RangeTexture, vec2(distance)).w : 0.0;\n//	//float attenuate = (lightCoord.z < 0.0) ? texture2D(u_AngleTexture, vec2(lightCoord.x / lightCoord.w + 0.5, lightCoord.y / lightCoord.w + 0.5)).r * texture2D(u_RangeTexture, vec2(distance)).w : 0.0;\n//	//vec2 _uv = vec2(pos.x * 180.0/(2.0 * pos.z) + 0.5, pos.y * 180.0/(2.0 * pos.z) + 0.5);\n//	vec3 lightVec = normalize(pos - light.Position);\n//	return PBRStandardLight(albedoColor, metallic, smoothness, normal, viewDir, lightVec, light.Color, gi) * attenuate;\n//}\n\nvec4 SpecularGloss(float albedoTextureAlpha, in vec2 uv0)\n{\n    vec4 sg;\n	\n	#ifdef SPECULARTEXTURE\n		vec4 specularTextureColor = texture2D(u_SpecularTexture, uv0);\n		#ifdef SMOOTHNESSSOURCE_ALBEDOTEXTURE_ALPHA\n			sg.rgb = specularTextureColor.rgb;\n			sg.a = albedoTextureAlpha;\n		#else\n			sg = specularTextureColor;\n		#endif\n		sg.a *= u_smoothnessScale;\n	#else\n		sg.rgb = u_SpecularColor.rgb;\n		#ifdef SMOOTHNESSSOURCE_ALBEDOTEXTURE_ALPHA\n			sg.a = albedoTextureAlpha * u_smoothnessScale;\n		#else\n			sg.a = u_smoothness;\n		#endif\n	#endif\n	\n    return sg;\n}\n\n");
		Shader3D.addInclude("Colors.glsl","#include \"StdLib.glsl\";\n\n#define EPSILON 1.0e-4\n\n// Quadratic color thresholding\n// curve = (threshold - knee, knee * 2, 0.25 / knee)\nmediump vec4 quadraticThreshold(mediump vec4 color, mediump float threshold, mediump vec3 curve) {\n	// Pixel brightness\n	mediump float br = max3(color.r, color.g, color.b);\n\n	// Under-threshold part: quadratic curve\n	mediump float rq = clamp(br - curve.x, 0.0, curve.y);\n	rq = curve.z * rq * rq;\n\n	// Combine and apply the brightness response curve.\n	color *= max(rq, br - threshold) / max(br, EPSILON);\n\n	return color;\n}\n\n//\n// sRGB transfer functions\n// Fast path ref: http://chilliant.blogspot.com.au/2012/08/srgb-approximations-for-hlsl.html?m=1\n//\nmediump vec3 SRGBToLinear(mediump vec3 c) {\n	#ifdef USE_VERY_FAST_SRGB\n		return c * c;\n	#elif defined(USE_FAST_SRGB)\n		return c * (c * (c * 0.305306011 + 0.682171111) + 0.012522878);\n	#else\n		mediump vec3 linearRGBLo = c / 12.92;\n		mediump vec3 power=vec3(2.4, 2.4, 2.4);\n		mediump vec3 linearRGBHi = positivePow((c + 0.055) / 1.055, power);\n		mediump vec3 linearRGB =vec3((c.r<=0.04045) ? linearRGBLo.r : linearRGBHi.r,(c.g<=0.04045) ? linearRGBLo.g : linearRGBHi.g,(c.b<=0.04045) ? linearRGBLo.b : linearRGBHi.b);\n		return linearRGB;\n	#endif\n}\n\nmediump vec3 LinearToSRGB(mediump vec3 c) {\n	#ifdef USE_VERY_FAST_SRGB\n		return sqrt(c);\n	#elif defined(USE_FAST_SRGB)\n		return max(1.055 * PositivePow(c, 0.416666667) - 0.055, 0.0);\n	#else\n		mediump vec3 sRGBLo = c * 12.92;\n		mediump vec3 power=vec3(1.0 / 2.4, 1.0 / 2.4, 1.0 / 2.4);\n		mediump vec3 sRGBHi = (positivePow(c, power) * 1.055) - 0.055;\n		mediump vec3 sRGB =vec3((c.r<=0.0031308) ? sRGBLo.r : sRGBHi.r,(c.g<=0.0031308) ? sRGBLo.g : sRGBHi.g,(c.b<=0.0031308) ? sRGBLo.b : sRGBHi.b);\n		return sRGB;\n	#endif\n}");
		Shader3D.addInclude("Sampling.glsl","// Better, temporally stable box filtering\n// [Jimenez14] http://goo.gl/eomGso\n// . . . . . . .\n// . A . B . C .\n// . . D . E . .\n// . F . G . H .\n// . . I . J . .\n// . K . L . M .\n// . . . . . . .\nmediump vec4 downsampleBox13Tap(sampler2D tex, vec2 uv, vec2 texelSize)\n{\n    mediump vec4 A = texture2D(tex, uv + texelSize * vec2(-1.0, -1.0));\n    mediump vec4 B = texture2D(tex, uv + texelSize * vec2( 0.0, -1.0));\n    mediump vec4 C = texture2D(tex, uv + texelSize * vec2( 1.0, -1.0));\n    mediump vec4 D = texture2D(tex, uv + texelSize * vec2(-0.5, -0.5));\n    mediump vec4 E = texture2D(tex, uv + texelSize * vec2( 0.5, -0.5));\n    mediump vec4 F = texture2D(tex, uv + texelSize * vec2(-1.0,  0.0));\n    mediump vec4 G = texture2D(tex, uv);\n    mediump vec4 H = texture2D(tex, uv + texelSize * vec2( 1.0,  0.0));\n    mediump vec4 I = texture2D(tex, uv + texelSize * vec2(-0.5,  0.5));\n    mediump vec4 J = texture2D(tex, uv + texelSize * vec2( 0.5,  0.5));\n    mediump vec4 K = texture2D(tex, uv + texelSize * vec2(-1.0,  1.0));\n    mediump vec4 L = texture2D(tex, uv + texelSize * vec2( 0.0,  1.0));\n    mediump vec4 M = texture2D(tex, uv + texelSize * vec2( 1.0,  1.0));\n\n	mediump vec2 scale= vec2(0.5, 0.125);\n    mediump vec2 div = (1.0 / 4.0) * scale;\n\n    mediump vec4 o = (D + E + I + J) * div.x;\n    o += (A + B + G + F) * div.y;\n    o += (B + C + H + G) * div.y;\n    o += (F + G + L + K) * div.y;\n    o += (G + H + M + L) * div.y;\n\n    return o;\n}\n\n// Standard box filtering\nmediump vec4 downsampleBox4Tap(sampler2D tex, vec2 uv, vec2 texelSize)\n{\n    vec4 d = texelSize.xyxy * vec4(-1.0, -1.0, 1.0, 1.0);\n\n    mediump vec4 s =  texture2D(tex, uv + d.xy);\n    s += texture2D(tex, uv + d.zy);\n    s += texture2D(tex, uv + d.xw);\n    s += texture2D(tex, uv + d.zw);\n\n    return s * (1.0 / 4.0);\n}\n\n// 9-tap bilinear upsampler (tent filter)\n// . . . . . . .\n// . 1 . 2 . 1 .\n// . . . . . . .\n// . 2 . 4 . 2 .\n// . . . . . . .\n// . 1 . 2 . 1 .\n// . . . . . . .\nmediump vec4 upsampleTent(sampler2D tex, vec2 uv, vec2 texelSize, vec4 sampleScale)\n{\n    vec4 d = texelSize.xyxy * vec4(1.0, 1.0, -1.0, 0.0) * sampleScale;\n\n    mediump vec4 s =  texture2D(tex, uv - d.xy);\n    s += texture2D(tex, uv - d.wy) * 2.0;\n    s += texture2D(tex, uv - d.zy);\n\n    s += texture2D(tex, uv + d.zw) * 2.0;\n    s += texture2D(tex, uv) * 4.0;\n    s += texture2D(tex,	uv + d.xw) * 2.0;\n\n    s += texture2D(tex, uv + d.zy);\n    s += texture2D(tex, uv + d.wy) * 2.0;\n    s += texture2D(tex, uv + d.xy);\n\n    return s * (1.0 / 16.0);\n}\n\n// Standard box filtering\nmediump vec4 upsampleBox(sampler2D tex, vec2 uv, vec2 texelSize, vec4 sampleScale)\n{\n    vec4 d = texelSize.xyxy * vec4(-1.0, -1.0, 1.0, 1.0) * (sampleScale * 0.5);\n\n    mediump vec4 s =  texture2D(tex, uv + d.xy);\n    s += texture2D(tex, uv + d.zy);\n    s += texture2D(tex, uv + d.xw);\n    s += texture2D(tex, uv + d.zw);\n\n    return s * (1.0 / 4.0);\n}");
		Shader3D.addInclude("StdLib.glsl","#define HALF_MAX       65504.0 // (2 - 2^-10) * 2^15\n\n#define FLT_EPSILON    1.192092896e-07 // Smallest positive number, such that 1.0 + FLT_EPSILON != 1.0\n\nmediump vec4 safeHDR(mediump vec4 c)\n{\n    return min(c, HALF_MAX);\n}\n\nfloat max3(float a, float b, float c)\n{\n    return max(max(a, b), c);\n}\n\nvec3 positivePow(vec3 base, vec3 power)\n{\n    return pow(max(abs(base), vec3(FLT_EPSILON, FLT_EPSILON, FLT_EPSILON)), power);\n}");
		var vs,ps;
		var attributeMap={
			'a_Position':/*laya.d3.graphics.Vertex.VertexMesh.MESH_POSITION0*/0,
			'a_Color':/*laya.d3.graphics.Vertex.VertexMesh.MESH_COLOR0*/1,
			'a_Normal':/*laya.d3.graphics.Vertex.VertexMesh.MESH_NORMAL0*/3,
			'a_Texcoord0':/*laya.d3.graphics.Vertex.VertexMesh.MESH_TEXTURECOORDINATE0*/2,
			'a_Texcoord1':/*laya.d3.graphics.Vertex.VertexMesh.MESH_TEXTURECOORDINATE1*/7,
			'a_BoneWeights':/*laya.d3.graphics.Vertex.VertexMesh.MESH_BLENDWEIGHT0*/6,
			'a_BoneIndices':/*laya.d3.graphics.Vertex.VertexMesh.MESH_BLENDINDICES0*/5,
			'a_Tangent0':/*laya.d3.graphics.Vertex.VertexMesh.MESH_TANGENT0*/4,
			'a_MvpMatrix':/*laya.d3.graphics.Vertex.VertexMesh.MESH_MVPMATRIX_ROW0*/12,
			'a_WorldMat':/*laya.d3.graphics.Vertex.VertexMesh.MESH_WORLDMATRIX_ROW0*/8
		};
		var uniformMap={
			'u_Bones':/*laya.d3.shader.Shader3D.PERIOD_CUSTOM*/0,
			'u_DiffuseTexture':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_SpecularTexture':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_NormalTexture':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_AlphaTestValue':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_DiffuseColor':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_MaterialSpecular':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_Shininess':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_TilingOffset':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_WorldMat':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_MvpMatrix':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_LightmapScaleOffset':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_LightMap':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_CameraPos':/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3,
			'u_ReflectTexture':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_ReflectIntensity':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_FogStart':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_FogRange':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_FogColor':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_DirectionLight.Color':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_DirectionLight.Direction':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_PointLight.Position':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_PointLight.Range':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_PointLight.Color':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_SpotLight.Position':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_SpotLight.Direction':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_SpotLight.Range':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_SpotLight.Spot':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_SpotLight.Color':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_AmbientColor':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_shadowMap1':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_shadowMap2':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_shadowMap3':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_shadowPSSMDistance':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_lightShadowVP':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_shadowPCFoffset':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4
		};
		var stateMap={
			's_Cull':/*laya.d3.shader.Shader3D.RENDER_STATE_CULL*/0,
			's_Blend':/*laya.d3.shader.Shader3D.RENDER_STATE_BLEND*/1,
			's_BlendSrc':/*laya.d3.shader.Shader3D.RENDER_STATE_BLEND_SRC*/2,
			's_BlendDst':/*laya.d3.shader.Shader3D.RENDER_STATE_BLEND_DST*/3,
			's_DepthTest':/*laya.d3.shader.Shader3D.RENDER_STATE_DEPTH_TEST*/12,
			's_DepthWrite':/*laya.d3.shader.Shader3D.RENDER_STATE_DEPTH_WRITE*/13
		}
		vs="#include \"Lighting.glsl\";\n\nattribute vec4 a_Position;\n\n#ifdef GPU_INSTANCE\n	attribute mat4 a_MvpMatrix;\n#else\n	uniform mat4 u_MvpMatrix;\n#endif\n\n\n#if defined(DIFFUSEMAP)||((defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT))&&(defined(SPECULARMAP)||defined(NORMALMAP)))||(defined(LIGHTMAP)&&defined(UV))\n	attribute vec2 a_Texcoord0;\n	varying vec2 v_Texcoord0;\n#endif\n\n#if defined(LIGHTMAP)&&defined(UV1)\n	attribute vec2 a_Texcoord1;\n#endif\n\n#ifdef LIGHTMAP\n	uniform vec4 u_LightmapScaleOffset;\n	varying vec2 v_LightMapUV;\n#endif\n\n#ifdef COLOR\n	attribute vec4 a_Color;\n	varying vec4 v_Color;\n#endif\n\n#ifdef BONE\n	const int c_MaxBoneCount = 24;\n	attribute vec4 a_BoneIndices;\n	attribute vec4 a_BoneWeights;\n	uniform mat4 u_Bones[c_MaxBoneCount];\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n	attribute vec3 a_Normal;\n	varying vec3 v_Normal; \n	uniform vec3 u_CameraPos;\n	varying vec3 v_ViewDir; \n#endif\n\n#if (defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT))&&defined(NORMALMAP)\n	attribute vec4 a_Tangent0;\n	varying vec3 v_Tangent;\n	varying vec3 v_Binormal;\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(RECEIVESHADOW)\n	#ifdef GPU_INSTANCE\n		attribute mat4 a_WorldMat;\n	#else\n		uniform mat4 u_WorldMat;\n	#endif\n	varying vec3 v_PositionWorld;\n#endif\n\nvarying float v_posViewZ;\n#ifdef RECEIVESHADOW\n  #ifdef SHADOWMAP_PSSM1 \n  varying vec4 v_lightMVPPos;\n  uniform mat4 u_lightShadowVP[4];\n  #endif\n#endif\n\n#ifdef TILINGOFFSET\n	uniform vec4 u_TilingOffset;\n#endif\n\nvoid main_castShadow()\n{\n	vec4 position;\n	#ifdef BONE\n		mat4 skinTransform = u_Bones[int(a_BoneIndices.x)] * a_BoneWeights.x;\n		skinTransform += u_Bones[int(a_BoneIndices.y)] * a_BoneWeights.y;\n		skinTransform += u_Bones[int(a_BoneIndices.z)] * a_BoneWeights.z;\n		skinTransform += u_Bones[int(a_BoneIndices.w)] * a_BoneWeights.w;\n		position=skinTransform*a_Position;\n	#else\n		position=a_Position;\n	#endif\n	#ifdef GPU_INSTANCE\n		gl_Position = a_MvpMatrix * position;\n	#else\n		gl_Position = u_MvpMatrix * position;\n	#endif\n	\n	//TODO没考虑UV动画呢\n	#if defined(DIFFUSEMAP)&&defined(ALPHATEST)\n		v_Texcoord0=a_Texcoord0;\n	#endif\n	gl_Position=remapGLPositionZ(gl_Position);\n	v_posViewZ = gl_Position.z;\n}\n\nvoid main_normal()\n{\n	vec4 position;\n	#ifdef BONE\n		mat4 skinTransform = u_Bones[int(a_BoneIndices.x)] * a_BoneWeights.x;\n		skinTransform += u_Bones[int(a_BoneIndices.y)] * a_BoneWeights.y;\n		skinTransform += u_Bones[int(a_BoneIndices.z)] * a_BoneWeights.z;\n		skinTransform += u_Bones[int(a_BoneIndices.w)] * a_BoneWeights.w;\n		position=skinTransform*a_Position;\n	#else\n		position=a_Position;\n	#endif\n	#ifdef GPU_INSTANCE\n		gl_Position = a_MvpMatrix * position;\n	#else\n		gl_Position = u_MvpMatrix * position;\n	#endif\n	\n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(RECEIVESHADOW)\n		mat4 worldMat;\n		#ifdef GPU_INSTANCE\n			worldMat = a_WorldMat;\n		#else\n			worldMat = u_WorldMat;\n		#endif\n	#endif\n	\n\n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n		mat3 worldInvMat;\n		#ifdef BONE\n			worldInvMat=inverse(mat3(worldMat*skinTransform));\n		#else\n			worldInvMat=inverse(mat3(worldMat));\n		#endif  \n		v_Normal=a_Normal*worldInvMat;\n		#if (defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT))&&defined(NORMALMAP)\n			v_Tangent=a_Tangent0.xyz*worldInvMat;\n			v_Binormal=cross(v_Normal,v_Tangent)*a_Tangent0.w;\n		#endif\n	#endif\n\n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(RECEIVESHADOW)\n		v_PositionWorld=(worldMat*position).xyz;\n	#endif\n	\n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n		v_ViewDir=u_CameraPos-v_PositionWorld;\n	#endif\n\n	#if defined(DIFFUSEMAP)||((defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT))&&(defined(SPECULARMAP)||defined(NORMALMAP)))\n		#ifdef TILINGOFFSET\n			v_Texcoord0=TransformUV(a_Texcoord0,u_TilingOffset);\n		#else\n			v_Texcoord0=a_Texcoord0;\n		#endif\n	#endif\n\n	#ifdef LIGHTMAP\n		#ifdef SCALEOFFSETLIGHTINGMAPUV\n			#ifdef UV1\n				v_LightMapUV=vec2(a_Texcoord1.x,1.0-a_Texcoord1.y)*u_LightmapScaleOffset.xy+u_LightmapScaleOffset.zw;\n			#else\n				v_LightMapUV=vec2(a_Texcoord0.x,1.0-a_Texcoord0.y)*u_LightmapScaleOffset.xy+u_LightmapScaleOffset.zw;\n			#endif \n			v_LightMapUV.y=1.0-v_LightMapUV.y;\n		#else\n			#ifdef UV1\n				v_LightMapUV=a_Texcoord1;\n			#else\n				v_LightMapUV=a_Texcoord0;\n			#endif \n		#endif \n	#endif\n\n	#if defined(COLOR)&&defined(ENABLEVERTEXCOLOR)\n		v_Color=a_Color;\n	#endif\n\n	#ifdef RECEIVESHADOW\n		v_posViewZ = gl_Position.w;\n		#ifdef SHADOWMAP_PSSM1 \n			v_lightMVPPos = u_lightShadowVP[0] * vec4(v_PositionWorld,1.0);\n		#endif\n	#endif\n	gl_Position=remapGLPositionZ(gl_Position);\n}\n\nvoid main()\n{\n	#ifdef CASTSHADOW\n		main_castShadow();\n	#else\n		main_normal();\n	#endif\n}";
		ps="#ifdef HIGHPRECISION\n	precision highp float;\n#else\n	precision mediump float;\n#endif\n\n#include \"Lighting.glsl\";\n\nuniform vec4 u_DiffuseColor;\n\n#if defined(COLOR)&&defined(ENABLEVERTEXCOLOR)\n	varying vec4 v_Color;\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n	varying vec3 v_ViewDir; \n#endif\n\n#ifdef ALPHATEST\n	uniform float u_AlphaTestValue;\n#endif\n\n#ifdef DIFFUSEMAP\n	uniform sampler2D u_DiffuseTexture;\n#endif\n\n\n\n#if defined(DIFFUSEMAP)||((defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT))&&(defined(SPECULARMAP)||defined(NORMALMAP)))\n	varying vec2 v_Texcoord0;\n#endif\n\n#ifdef LIGHTMAP\n	varying vec2 v_LightMapUV;\n	uniform sampler2D u_LightMap;\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n	uniform vec3 u_MaterialSpecular;\n	uniform float u_Shininess;\n	#ifdef SPECULARMAP \n		uniform sampler2D u_SpecularTexture;\n	#endif\n#endif\n\n#ifdef FOG\n	uniform float u_FogStart;\n	uniform float u_FogRange;\n	uniform vec3 u_FogColor;\n#endif\n\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n	varying vec3 v_Normal;\n#endif\n\n#if (defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT))&&defined(NORMALMAP)\n	uniform sampler2D u_NormalTexture;\n	varying vec3 v_Tangent;\n	varying vec3 v_Binormal;\n#endif\n\n#ifdef DIRECTIONLIGHT\n	uniform DirectionLight u_DirectionLight;\n#endif\n\n#ifdef POINTLIGHT\n	uniform PointLight u_PointLight;\n#endif\n\n#ifdef SPOTLIGHT\n	uniform SpotLight u_SpotLight;\n#endif\n\nuniform vec3 u_AmbientColor;\n\n\n#if defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(RECEIVESHADOW)\n	varying vec3 v_PositionWorld;\n#endif\n\n#include \"ShadowHelper.glsl\"\nvarying float v_posViewZ;\n#ifdef RECEIVESHADOW\n	#if defined(SHADOWMAP_PSSM2)||defined(SHADOWMAP_PSSM3)\n		uniform mat4 u_lightShadowVP[4];\n	#endif\n	#ifdef SHADOWMAP_PSSM1 \n		varying vec4 v_lightMVPPos;\n	#endif\n#endif\n\nvoid main_castShadow()\n{\n	//gl_FragColor=vec4(v_posViewZ,0.0,0.0,1.0);\n	gl_FragColor=packDepth(v_posViewZ);\n	#if defined(DIFFUSEMAP)&&defined(ALPHATEST)\n		float alpha = texture2D(u_DiffuseTexture,v_Texcoord0).w;\n		if( alpha < u_AlphaTestValue )\n		{\n			discard;\n		}\n	#endif\n}\nvoid main_normal()\n{\n	vec3 globalDiffuse=u_AmbientColor;\n	#ifdef LIGHTMAP	\n		globalDiffuse += DecodeLightmap(texture2D(u_LightMap, v_LightMapUV));\n	#endif\n	\n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n		vec3 normal;\n		#if (defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT))&&defined(NORMALMAP)\n			vec3 normalMapSample = texture2D(u_NormalTexture, v_Texcoord0).rgb;\n			normal = normalize(NormalSampleToWorldSpace(normalMapSample, v_Normal, v_Tangent,v_Binormal));\n		#else\n			normal = normalize(v_Normal);\n		#endif\n		vec3 viewDir= normalize(v_ViewDir);\n	#endif\n	\n	vec4 mainColor=u_DiffuseColor;\n	#ifdef DIFFUSEMAP\n		vec4 difTexColor=texture2D(u_DiffuseTexture, v_Texcoord0);\n		mainColor=mainColor*difTexColor;\n	#endif \n	#if defined(COLOR)&&defined(ENABLEVERTEXCOLOR)\n		mainColor=mainColor*v_Color;\n	#endif \n    \n	#ifdef ALPHATEST\n		if(mainColor.a<u_AlphaTestValue)\n			discard;\n	#endif\n  \n	\n	vec3 diffuse = vec3(0.0);\n	vec3 specular= vec3(0.0);\n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n		vec3 dif,spe;\n		#ifdef SPECULARMAP\n			vec3 gloss=texture2D(u_SpecularTexture, v_Texcoord0).rgb;\n		#else\n			#ifdef DIFFUSEMAP\n				vec3 gloss=vec3(difTexColor.a);\n			#else\n				vec3 gloss=vec3(1.0);\n			#endif\n		#endif\n	#endif\n\n	\n	#ifdef DIRECTIONLIGHT\n		LayaAirBlinnPhongDiectionLight(u_MaterialSpecular,u_Shininess,normal,gloss,viewDir,u_DirectionLight,dif,spe);\n		diffuse+=dif;\n		specular+=spe;\n	#endif\n \n	#ifdef POINTLIGHT\n		LayaAirBlinnPhongPointLight(v_PositionWorld,u_MaterialSpecular,u_Shininess,normal,gloss,viewDir,u_PointLight,dif,spe);\n		diffuse+=dif;\n		specular+=spe;\n	#endif\n\n	#ifdef SPOTLIGHT\n		LayaAirBlinnPhongSpotLight(v_PositionWorld,u_MaterialSpecular,u_Shininess,normal,gloss,viewDir,u_SpotLight,dif,spe);\n		diffuse+=dif;\n		specular+=spe;\n	#endif\n\n	#ifdef RECEIVESHADOW\n		float shadowValue = 1.0;\n		#ifdef SHADOWMAP_PSSM3\n			shadowValue = getShadowPSSM3(u_shadowMap1,u_shadowMap2,u_shadowMap3,u_lightShadowVP,u_shadowPSSMDistance,u_shadowPCFoffset,v_PositionWorld,v_posViewZ,0.001);\n		#endif\n		#ifdef SHADOWMAP_PSSM2\n			shadowValue = getShadowPSSM2(u_shadowMap1,u_shadowMap2,u_lightShadowVP,u_shadowPSSMDistance,u_shadowPCFoffset,v_PositionWorld,v_posViewZ,0.001);\n		#endif \n		#ifdef SHADOWMAP_PSSM1\n			shadowValue = getShadowPSSM1(u_shadowMap1,v_lightMVPPos,u_shadowPSSMDistance,u_shadowPCFoffset,v_posViewZ,0.001);\n		#endif\n		gl_FragColor =vec4(mainColor.rgb*(globalDiffuse + diffuse*shadowValue),mainColor.a);\n	#else\n		gl_FragColor =vec4(mainColor.rgb*(globalDiffuse + diffuse),mainColor.a);\n	#endif\n\n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n		#ifdef RECEIVESHADOW\n			gl_FragColor.rgb+=specular*shadowValue;\n		#else\n			gl_FragColor.rgb+=specular;\n		#endif\n	#endif\n	  \n	#ifdef FOG\n		float lerpFact=clamp((1.0/gl_FragCoord.w-u_FogStart)/u_FogRange,0.0,1.0);\n		gl_FragColor.rgb=mix(gl_FragColor.rgb,u_FogColor,lerpFact);\n	#endif\n}\n\nvoid main()\n{\n	#ifdef CASTSHADOW		\n		main_castShadow();\n	#else\n		main_normal();\n	#endif  \n}\n\n";
		var shader=Shader3D.add("BLINNPHONG",true);
		var subShader=new SubShader(attributeMap,uniformMap,SkinnedMeshSprite3D.shaderDefines,BlinnPhongMaterial.shaderDefines);
		shader.addSubShader(subShader);
		subShader.addShaderPass(vs,ps,stateMap);
		attributeMap={
			'a_Position':/*laya.d3.graphics.Vertex.VertexMesh.MESH_POSITION0*/0,
			'a_Color':/*laya.d3.graphics.Vertex.VertexMesh.MESH_COLOR0*/1};
		uniformMap={
			'u_MvpMatrix':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_Color':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1
		};
		stateMap={
			's_Cull':/*laya.d3.shader.Shader3D.RENDER_STATE_CULL*/0,
			's_Blend':/*laya.d3.shader.Shader3D.RENDER_STATE_BLEND*/1,
			's_BlendSrc':/*laya.d3.shader.Shader3D.RENDER_STATE_BLEND_SRC*/2,
			's_BlendDst':/*laya.d3.shader.Shader3D.RENDER_STATE_BLEND_DST*/3,
			's_DepthTest':/*laya.d3.shader.Shader3D.RENDER_STATE_DEPTH_TEST*/12,
			's_DepthWrite':/*laya.d3.shader.Shader3D.RENDER_STATE_DEPTH_WRITE*/13
		}
		vs="#include \"Lighting.glsl\";\n\nattribute vec4 a_Position;\nuniform mat4 u_MvpMatrix;\nuniform vec4 u_Color;\nattribute vec4 a_Color;\nvarying vec4 v_Color;\n\n\nvoid main()\n{\n	gl_Position = u_MvpMatrix * a_Position;\n	v_Color=a_Color*u_Color;\n	gl_Position=remapGLPositionZ(gl_Position);\n}";
		ps="#ifdef HIGHPRECISION\nprecision highp float;\n#else\nprecision mediump float;\n#endif\n\nvarying vec4 v_Color;\nuniform vec4 u_Color;\n\nvoid main()\n{\n  gl_FragColor = v_Color * u_Color; \n}\n\n";
		shader=Shader3D.add("LineShader");
		subShader=new SubShader(attributeMap,uniformMap);
		shader.addSubShader(subShader);
		subShader.addShaderPass(vs,ps,stateMap);
		attributeMap={
			'a_Position':/*laya.d3.graphics.Vertex.VertexMesh.MESH_POSITION0*/0,
			'a_Normal':/*laya.d3.graphics.Vertex.VertexMesh.MESH_NORMAL0*/3,
			'a_Tangent0':/*laya.d3.graphics.Vertex.VertexMesh.MESH_TANGENT0*/4,
			'a_Texcoord0':/*laya.d3.graphics.Vertex.VertexMesh.MESH_TEXTURECOORDINATE0*/2,
			'a_BoneWeights':/*laya.d3.graphics.Vertex.VertexMesh.MESH_BLENDWEIGHT0*/6,
			'a_BoneIndices':/*laya.d3.graphics.Vertex.VertexMesh.MESH_BLENDINDICES0*/5,
			'a_MvpMatrix':/*laya.d3.graphics.Vertex.VertexMesh.MESH_MVPMATRIX_ROW0*/12,
			'a_WorldMat':/*laya.d3.graphics.Vertex.VertexMesh.MESH_WORLDMATRIX_ROW0*/8
		};
		uniformMap={
			'u_Bones':/*laya.d3.shader.Shader3D.PERIOD_CUSTOM*/0,
			'u_MvpMatrix':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_WorldMat':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_CameraPos':/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3,
			'u_AlphaTestValue':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_AlbedoColor':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_EmissionColor':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_AlbedoTexture':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_NormalTexture':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_ParallaxTexture':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_MetallicGlossTexture':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_OcclusionTexture':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_EmissionTexture':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_metallic':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_smoothness':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_smoothnessScale':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_occlusionStrength':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_normalScale':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_parallaxScale':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_TilingOffset':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_DirectionLight.Direction':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_DirectionLight.Color':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_PointLightMatrix':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_PointLight.Position':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_PointLight.Range':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_PointLight.Color':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_SpotLight.Position':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_SpotLight.Direction':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_SpotLight.Range':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_SpotLight.SpotAngle':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_SpotLight.Color':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_RangeTexture':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_ReflectTexture':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_ReflectIntensity':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_AmbientColor':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_shadowMap1':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_shadowMap2':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_shadowMap3':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_shadowPSSMDistance':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_lightShadowVP':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_shadowPCFoffset':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_FogStart':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_FogRange':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_FogColor':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4
		};
		stateMap={
			's_Cull':/*laya.d3.shader.Shader3D.RENDER_STATE_CULL*/0,
			's_Blend':/*laya.d3.shader.Shader3D.RENDER_STATE_BLEND*/1,
			's_BlendSrc':/*laya.d3.shader.Shader3D.RENDER_STATE_BLEND_SRC*/2,
			's_BlendDst':/*laya.d3.shader.Shader3D.RENDER_STATE_BLEND_DST*/3,
			's_DepthTest':/*laya.d3.shader.Shader3D.RENDER_STATE_DEPTH_TEST*/12,
			's_DepthWrite':/*laya.d3.shader.Shader3D.RENDER_STATE_DEPTH_WRITE*/13
		}
		vs="#include \"Lighting.glsl\";\n\nattribute vec4 a_Position;\nattribute vec3 a_Normal;\nattribute vec4 a_Tangent0;\nattribute vec2 a_Texcoord0;\n\n#ifdef GPU_INSTANCE\n	attribute mat4 a_MvpMatrix;\n#else\n	uniform mat4 u_MvpMatrix;\n#endif\n\n#ifdef GPU_INSTANCE\n	attribute mat4 a_WorldMat;\n#else\n	uniform mat4 u_WorldMat;\n#endif\n\nuniform vec3 u_CameraPos;\n\nvarying vec2 v_Texcoord0;\nvarying vec3 v_Normal;\nvarying vec3 v_Tangent;\nvarying vec3 v_Binormal;\nvarying vec3 v_ViewDir;\nvarying vec3 v_PositionWorld;\n\n#ifdef TILINGOFFSET\n	uniform vec4 u_TilingOffset;\n#endif\n\nvarying float v_posViewZ;\n#ifdef RECEIVESHADOW\n  #ifdef SHADOWMAP_PSSM1 \n	  varying vec4 v_lightMVPPos;\n	  uniform mat4 u_lightShadowVP[4];\n  #endif\n#endif\n\n#ifdef BONE\n	const int c_MaxBoneCount = 24;\n	attribute vec4 a_BoneIndices;\n	attribute vec4 a_BoneWeights;\n	uniform mat4 u_Bones[c_MaxBoneCount];\n#endif\n\nvoid main_castShadow()\n{\n	vec4 position;\n	#ifdef BONE\n		mat4 skinTransform = u_Bones[int(a_BoneIndices.x)] * a_BoneWeights.x;\n		skinTransform += u_Bones[int(a_BoneIndices.y)] * a_BoneWeights.y;\n		skinTransform += u_Bones[int(a_BoneIndices.z)] * a_BoneWeights.z;\n		skinTransform += u_Bones[int(a_BoneIndices.w)] * a_BoneWeights.w;\n		position=skinTransform*a_Position;\n	#else\n		position=a_Position;\n	#endif\n	#ifdef GPU_INSTANCE\n		gl_Position = a_MvpMatrix * position;\n	#else\n		gl_Position = u_MvpMatrix * position;\n	#endif\n	 \n	//TODO没考虑UV动画呢\n	#if defined(DIFFUSEMAP)&&defined(ALPHATEST)\n		v_Texcoord0 = a_Texcoord0;\n	#endif\n	gl_Position=remapGLPositionZ(gl_Position);\n	v_posViewZ = gl_Position.z;\n}\n\nvoid main_normal()\n{\n	vec4 position;\n	#ifdef BONE\n		mat4 skinTransform = u_Bones[int(a_BoneIndices.x)] * a_BoneWeights.x;\n		skinTransform += u_Bones[int(a_BoneIndices.y)] * a_BoneWeights.y;\n		skinTransform += u_Bones[int(a_BoneIndices.z)] * a_BoneWeights.z;\n		skinTransform += u_Bones[int(a_BoneIndices.w)] * a_BoneWeights.w;\n		position=skinTransform*a_Position;\n	#else\n		position=a_Position;\n	#endif\n	#ifdef GPU_INSTANCE\n		gl_Position = a_MvpMatrix * position;\n	#else\n		gl_Position = u_MvpMatrix * position;\n	#endif\n	\n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(RECEIVESHADOW)\n		mat4 worldMat;\n		#ifdef GPU_INSTANCE\n			worldMat = a_WorldMat;\n		#else\n			worldMat = u_WorldMat;\n		#endif\n	#endif\n	\n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n		mat3 worldInvMat;\n		#ifdef BONE\n			worldInvMat=inverse(mat3(worldMat*skinTransform));\n		#else\n			worldInvMat=inverse(mat3(worldMat));\n		#endif  \n		v_Normal=a_Normal*worldInvMat;\n		#if (defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT))\n			v_Tangent=a_Tangent0.xyz*worldInvMat;\n			v_Binormal=cross(v_Normal,v_Tangent)*a_Tangent0.w;\n		#endif\n	#endif\n	\n	\n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(RECEIVESHADOW)\n		v_PositionWorld=(worldMat*position).xyz;\n	#endif\n	\n  \n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n		v_ViewDir=u_CameraPos-v_PositionWorld;\n	#endif\n\n	#ifdef TILINGOFFSET\n		v_Texcoord0=TransformUV(a_Texcoord0,u_TilingOffset);\n	#else\n		v_Texcoord0=a_Texcoord0;\n	#endif\n  \n	#ifdef RECEIVESHADOW\n		v_posViewZ = gl_Position.w;\n		#ifdef SHADOWMAP_PSSM1 \n			v_lightMVPPos = u_lightShadowVP[0] * vec4(v_PositionWorld,1.0);\n		#endif\n	#endif\n	gl_Position=remapGLPositionZ(gl_Position);\n}\n\nvoid main()\n{\n	#ifdef CASTSHADOW\n		main_castShadow();\n	#else\n		main_normal();\n	#endif\n}";
		ps="#ifdef FSHIGHPRECISION\n	precision highp float;\n#else\n	precision mediump float;\n#endif\n\nvarying vec2 v_Texcoord0;\nvarying vec3 v_Normal;\nvarying vec3 v_Tangent;\nvarying vec3 v_Binormal;\nvarying vec3 v_ViewDir;\nvarying vec3 v_PositionWorld;\n\nuniform vec3 u_AmbientColor;\nuniform vec4 u_AlbedoColor;\n\n#ifdef ALBEDOTEXTURE\n	uniform sampler2D u_AlbedoTexture;\n#endif\n#ifdef METALLICGLOSSTEXTURE\n	uniform sampler2D u_MetallicGlossTexture;\n#endif\n#ifdef NORMALTEXTURE\n	uniform sampler2D u_NormalTexture;\n	uniform float u_normalScale;\n#endif\n#ifdef PARALLAXTEXTURE\n	uniform sampler2D u_ParallaxTexture;\n	uniform float u_parallaxScale;\n#endif\n#ifdef OCCLUSIONTEXTURE\n	uniform sampler2D u_OcclusionTexture;\n	uniform float u_occlusionStrength;\n#endif\n#ifdef EMISSION\n	#ifdef EMISSIONTEXTURE\n		uniform sampler2D u_EmissionTexture;\n	#endif\n	uniform vec4 u_EmissionColor;\n#endif\n#ifdef REFLECTMAP\n	uniform samplerCube u_ReflectTexture;\n	uniform float u_ReflectIntensity;\n#endif\n\nuniform float u_AlphaTestValue;\nuniform float u_metallic;\nuniform float u_smoothness;\nuniform float u_smoothnessScale;\n\nuniform sampler2D u_RangeTexture;\n//uniform sampler2D u_AngleTexture;\nuniform mat4 u_PointLightMatrix;\n//uniform mat4 u_SpotLightMatrix;\n\n#include \"PBRStandardLighting.glsl\"\n#include \"ShadowHelper.glsl\"\n\nvarying float v_posViewZ;\n#ifdef RECEIVESHADOW\n	#if defined(SHADOWMAP_PSSM2)||defined(SHADOWMAP_PSSM3)\n		uniform mat4 u_lightShadowVP[4];\n	#endif\n	#ifdef SHADOWMAP_PSSM1 \n		varying vec4 v_lightMVPPos;\n	#endif\n#endif\n\n#ifdef DIRECTIONLIGHT\n	uniform DirectionLight u_DirectionLight;\n#endif\n#ifdef POINTLIGHT\n	uniform PointLight u_PointLight;\n#endif\n#ifdef SPOTLIGHT\n	uniform SpotLight u_SpotLight;\n#endif\n\n#ifdef FOG\n	uniform float u_FogStart;\n	uniform float u_FogRange;\n	uniform vec3 u_FogColor;\n#endif\n\nvoid main_castShadow()\n{\n	gl_FragColor=packDepth(v_posViewZ);\n	#if defined(DIFFUSEMAP)&&defined(ALPHATEST)\n		float alpha = texture2D(u_AlbedoTexture,v_Texcoord0).w;\n		if( alpha < u_AlphaTestValue )\n		{\n			discard;\n		}\n	#endif\n}\n\nvoid main_normal()\n{	\n	vec3 viewDir = normalize(v_ViewDir);\n	\n	vec2 uv0 = ParallaxOffset(viewDir);\n	\n	vec2 mg;\n	vec4 albedoColor;\n	#ifdef ALBEDOTEXTURE\n		vec4 abledoTextureColor = texture2D(u_AlbedoTexture, uv0);\n		albedoColor = abledoTextureColor * u_AlbedoColor;\n		mg = MetallicGloss(abledoTextureColor.a, uv0);\n	#else\n		albedoColor = u_AlbedoColor;\n		mg = MetallicGloss(1.0, uv0);\n	#endif\n	\n	#ifdef ALPHATEST\n		if(albedoColor.a < u_AlphaTestValue)\n			discard;\n	#endif\n	\n	vec3 normal = UnpackScaleNormal(uv0);\n  \n	LayaGI gi;\n	gi.diffuse = u_AmbientColor * Occlusion(uv0).rgb;\n	gi.specular = ReflectCubeMap(viewDir, normal);\n  \n	vec4 color = vec4(0.0);\n	\n	#ifdef DIRECTIONLIGHT\n		color += PBRStandardDiectionLight(albedoColor, mg.r, mg.g, normal, viewDir, u_DirectionLight, gi);\n	#endif\n \n	#ifdef POINTLIGHT\n		color.a = 0.0;\n		color += PBRStandardPointLight(albedoColor, mg.r, mg.g, normal, viewDir, u_PointLight, v_PositionWorld, gi);\n	#endif\n	\n	#ifdef SPOTLIGHT\n		color.a = 0.0;\n		color += PBRStandardSpotLight(albedoColor, mg.r, mg.g, normal, viewDir, u_SpotLight, v_PositionWorld, gi);\n	#endif\n	\n	#ifdef EMISSION\n		vec4 emissionColor = u_EmissionColor;\n		#ifdef EMISSIONTEXTURE\n			emissionColor *=  texture2D(u_EmissionTexture, uv0);\n		#endif\n		color.rgb += emissionColor.rgb;\n	#endif\n	\n	#ifdef RECEIVESHADOW\n		float shadowValue = 1.0;\n		#ifdef SHADOWMAP_PSSM3\n			shadowValue = getShadowPSSM3( u_shadowMap1,u_shadowMap2,u_shadowMap3,u_lightShadowVP,u_shadowPSSMDistance,u_shadowPCFoffset,v_PositionWorld,v_posViewZ,0.001);\n		#endif\n		#ifdef SHADOWMAP_PSSM2\n			shadowValue = getShadowPSSM2( u_shadowMap1,u_shadowMap2,u_lightShadowVP,u_shadowPSSMDistance,u_shadowPCFoffset,v_PositionWorld,v_posViewZ,0.001);\n		#endif \n		#ifdef SHADOWMAP_PSSM1\n			shadowValue = getShadowPSSM1( u_shadowMap1,v_lightMVPPos,u_shadowPSSMDistance,u_shadowPCFoffset,v_posViewZ,0.001);\n		#endif\n		gl_FragColor = vec4(color.rgb * shadowValue, color.a);\n	#else\n		gl_FragColor = color;\n	#endif\n	\n	#ifdef FOG\n		float lerpFact = clamp((1.0 / gl_FragCoord.w - u_FogStart) / u_FogRange, 0.0, 1.0);\n		gl_FragColor.rgb = mix(gl_FragColor.rgb, u_FogColor, lerpFact);\n	#endif\n}\n\nvoid main()\n{\n	#ifdef CASTSHADOW		\n		main_castShadow();\n	#else\n		main_normal();\n	#endif  \n}";
		shader=Shader3D.add("PBRStandard",true);
		subShader=new SubShader(attributeMap,uniformMap,SkinnedMeshSprite3D.shaderDefines,PBRStandardMaterial.shaderDefines);
		shader.addSubShader(subShader);
		subShader.addShaderPass(vs,ps,stateMap);
		attributeMap={
			'a_Position':/*laya.d3.graphics.Vertex.VertexMesh.MESH_POSITION0*/0,
			'a_Normal':/*laya.d3.graphics.Vertex.VertexMesh.MESH_NORMAL0*/3,
			'a_Tangent0':/*laya.d3.graphics.Vertex.VertexMesh.MESH_TANGENT0*/4,
			'a_Texcoord0':/*laya.d3.graphics.Vertex.VertexMesh.MESH_TEXTURECOORDINATE0*/2,
			'a_BoneWeights':/*laya.d3.graphics.Vertex.VertexMesh.MESH_BLENDWEIGHT0*/6,
			'a_BoneIndices':/*laya.d3.graphics.Vertex.VertexMesh.MESH_BLENDINDICES0*/5,
			'a_MvpMatrix':/*laya.d3.graphics.Vertex.VertexMesh.MESH_MVPMATRIX_ROW0*/12,
			'a_WorldMat':/*laya.d3.graphics.Vertex.VertexMesh.MESH_WORLDMATRIX_ROW0*/8
		};
		uniformMap={
			'u_Bones':/*laya.d3.shader.Shader3D.PERIOD_CUSTOM*/0,
			'u_MvpMatrix':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_WorldMat':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_CameraPos':/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3,
			'u_AlphaTestValue':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_AlbedoColor':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_SpecularColor':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_EmissionColor':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_AlbedoTexture':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_NormalTexture':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_ParallaxTexture':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_SpecularTexture':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_OcclusionTexture':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_EmissionTexture':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_smoothness':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_smoothnessScale':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_occlusionStrength':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_normalScale':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_parallaxScale':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_TilingOffset':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_DirectionLight.Direction':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_DirectionLight.Color':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_PointLightMatrix':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_PointLight.Position':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_PointLight.Range':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_PointLight.Color':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_SpotLight.Position':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_SpotLight.Direction':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_SpotLight.Range':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_SpotLight.SpotAngle':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_SpotLight.Color':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_RangeTexture':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_ReflectTexture':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_ReflectIntensity':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_AmbientColor':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_shadowMap1':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_shadowMap2':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_shadowMap3':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_shadowPSSMDistance':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_lightShadowVP':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_shadowPCFoffset':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_FogStart':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_FogRange':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_FogColor':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4
		};
		stateMap={
			's_Cull':/*laya.d3.shader.Shader3D.RENDER_STATE_CULL*/0,
			's_Blend':/*laya.d3.shader.Shader3D.RENDER_STATE_BLEND*/1,
			's_BlendSrc':/*laya.d3.shader.Shader3D.RENDER_STATE_BLEND_SRC*/2,
			's_BlendDst':/*laya.d3.shader.Shader3D.RENDER_STATE_BLEND_DST*/3,
			's_DepthTest':/*laya.d3.shader.Shader3D.RENDER_STATE_DEPTH_TEST*/12,
			's_DepthWrite':/*laya.d3.shader.Shader3D.RENDER_STATE_DEPTH_WRITE*/13
		}
		vs="#include \"Lighting.glsl\";\n\nattribute vec4 a_Position;\nattribute vec3 a_Normal;\nattribute vec4 a_Tangent0;\nattribute vec2 a_Texcoord0;\n\n#ifdef GPU_INSTANCE\n	attribute mat4 a_MvpMatrix;\n#else\n	uniform mat4 u_MvpMatrix;\n#endif\n\n#ifdef GPU_INSTANCE\n	attribute mat4 a_WorldMat;\n#else\n	uniform mat4 u_WorldMat;\n#endif\nuniform vec3 u_CameraPos;\n\nvarying vec2 v_Texcoord0;\nvarying vec3 v_Normal;\nvarying vec3 v_Tangent;\nvarying vec3 v_Binormal;\nvarying vec3 v_ViewDir;\nvarying vec3 v_PositionWorld;\n\n#ifdef TILINGOFFSET\n	uniform vec4 u_TilingOffset;\n#endif\n\nvarying float v_posViewZ;\n#ifdef RECEIVESHADOW\n  #ifdef SHADOWMAP_PSSM1 \n	  varying vec4 v_lightMVPPos;\n	  uniform mat4 u_lightShadowVP[4];\n  #endif\n#endif\n\n#ifdef BONE\n	const int c_MaxBoneCount = 24;\n	attribute vec4 a_BoneIndices;\n	attribute vec4 a_BoneWeights;\n	uniform mat4 u_Bones[c_MaxBoneCount];\n#endif\n\nvoid main_castShadow()\n{\n	vec4 position;\n	#ifdef BONE\n		mat4 skinTransform = u_Bones[int(a_BoneIndices.x)] * a_BoneWeights.x;\n		skinTransform += u_Bones[int(a_BoneIndices.y)] * a_BoneWeights.y;\n		skinTransform += u_Bones[int(a_BoneIndices.z)] * a_BoneWeights.z;\n		skinTransform += u_Bones[int(a_BoneIndices.w)] * a_BoneWeights.w;\n		position=skinTransform*a_Position;\n	#else\n		position=a_Position;\n	#endif\n	#ifdef GPU_INSTANCE\n		gl_Position = a_MvpMatrix * position;\n	#else\n		gl_Position = u_MvpMatrix * position;\n	#endif\n	 \n	//TODO没考虑UV动画呢\n	#if defined(DIFFUSEMAP)&&defined(ALPHATEST)\n		v_Texcoord0 = a_Texcoord0;\n	#endif\n	gl_Position=remapGLPositionZ(gl_Position);\n	v_posViewZ = gl_Position.z;\n}\n\nvoid main_normal()\n{\n	vec4 position;\n	#ifdef BONE\n		mat4 skinTransform = u_Bones[int(a_BoneIndices.x)] * a_BoneWeights.x;\n		skinTransform += u_Bones[int(a_BoneIndices.y)] * a_BoneWeights.y;\n		skinTransform += u_Bones[int(a_BoneIndices.z)] * a_BoneWeights.z;\n		skinTransform += u_Bones[int(a_BoneIndices.w)] * a_BoneWeights.w;\n		position=skinTransform*a_Position;\n	#else\n		position=a_Position;\n	#endif\n	#ifdef GPU_INSTANCE\n		gl_Position = a_MvpMatrix * position;\n	#else\n		gl_Position = u_MvpMatrix * position;\n	#endif\n	\n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(RECEIVESHADOW)\n		mat4 worldMat;\n		#ifdef GPU_INSTANCE\n			worldMat = a_WorldMat;\n		#else\n			worldMat = u_WorldMat;\n		#endif\n	#endif\n	\n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n		mat3 worldInvMat;\n		#ifdef BONE\n			worldInvMat=inverse(mat3(worldMat*skinTransform));\n		#else\n			worldInvMat=inverse(mat3(worldMat));\n		#endif  \n		v_Normal=a_Normal*worldInvMat;\n		#if (defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT))\n			v_Tangent=a_Tangent0.xyz*worldInvMat;\n			v_Binormal=cross(v_Normal,v_Tangent)*a_Tangent0.w;\n		#endif\n	#endif\n	\n	\n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(RECEIVESHADOW)\n		v_PositionWorld=(worldMat*position).xyz;\n	#endif\n	\n  \n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n		v_ViewDir=u_CameraPos-v_PositionWorld;\n	#endif\n\n	#ifdef TILINGOFFSET\n		v_Texcoord0=TransformUV(a_Texcoord0,u_TilingOffset);\n	#else\n		v_Texcoord0=a_Texcoord0;\n	#endif\n  \n	#ifdef RECEIVESHADOW\n		v_posViewZ = gl_Position.w;\n		#ifdef SHADOWMAP_PSSM1 \n			v_lightMVPPos = u_lightShadowVP[0] * vec4(v_PositionWorld,1.0);\n		#endif\n	#endif\n	gl_Position=remapGLPositionZ(gl_Position);\n}\n\nvoid main()\n{\n	#ifdef CASTSHADOW\n		main_castShadow();\n	#else\n		main_normal();\n	#endif\n}";
		ps="#ifdef FSHIGHPRECISION\n	precision highp float;\n#else\n	precision mediump float;\n#endif\n\nvarying vec2 v_Texcoord0;\nvarying vec3 v_Normal;\nvarying vec3 v_Tangent;\nvarying vec3 v_Binormal;\nvarying vec3 v_ViewDir;\nvarying vec3 v_PositionWorld;\n\nuniform vec3 u_AmbientColor;\nuniform vec4 u_AlbedoColor;\nuniform vec4 u_SpecularColor;\n\n#ifdef ALBEDOTEXTURE\n	uniform sampler2D u_AlbedoTexture;\n#endif\n#ifdef SPECULARTEXTURE\n	uniform sampler2D u_SpecularTexture;\n#endif\n#ifdef NORMALTEXTURE\n	uniform sampler2D u_NormalTexture;\n	uniform float u_normalScale;\n#endif\n#ifdef PARALLAXTEXTURE\n	uniform sampler2D u_ParallaxTexture;\n	uniform float u_parallaxScale;\n#endif\n#ifdef OCCLUSIONTEXTURE\n	uniform sampler2D u_OcclusionTexture;\n	uniform float u_occlusionStrength;\n#endif\n#ifdef EMISSION\n	#ifdef EMISSIONTEXTURE\n		uniform sampler2D u_EmissionTexture;\n	#endif\n	uniform vec4 u_EmissionColor;\n#endif\n#ifdef REFLECTMAP\n	uniform samplerCube u_ReflectTexture;\n	uniform float u_ReflectIntensity;\n#endif\n\nuniform float u_AlphaTestValue;\nuniform float u_metallic;\nuniform float u_smoothness;\nuniform float u_smoothnessScale;\n\nuniform sampler2D u_RangeTexture;\n//uniform sampler2D u_AngleTexture;\nuniform mat4 u_PointLightMatrix;\n//uniform mat4 u_SpotLightMatrix;\n\n#include \"PBRSpecularLighting.glsl\"\n#include \"ShadowHelper.glsl\"\n\nvarying float v_posViewZ;\n#ifdef RECEIVESHADOW\n	#if defined(SHADOWMAP_PSSM2)||defined(SHADOWMAP_PSSM3)\n		uniform mat4 u_lightShadowVP[4];\n	#endif\n	#ifdef SHADOWMAP_PSSM1 \n		varying vec4 v_lightMVPPos;\n	#endif\n#endif\n\n#ifdef DIRECTIONLIGHT\n	uniform DirectionLight u_DirectionLight;\n#endif\n#ifdef POINTLIGHT\n	uniform PointLight u_PointLight;\n#endif\n#ifdef SPOTLIGHT\n	uniform SpotLight u_SpotLight;\n#endif\n\n#ifdef FOG\n	uniform float u_FogStart;\n	uniform float u_FogRange;\n	uniform vec3 u_FogColor;\n#endif\n\nvoid main_castShadow()\n{\n	gl_FragColor=packDepth(v_posViewZ);\n	#if defined(DIFFUSEMAP)&&defined(ALPHATEST)\n		float alpha = texture2D(u_AlbedoTexture,v_Texcoord0).w;\n		if( alpha < u_AlphaTestValue )\n		{\n			discard;\n		}\n	#endif\n}\n\nvoid main_normal()\n{	\n	vec3 viewDir = normalize(v_ViewDir);\n	\n	vec2 uv0 = ParallaxOffset(viewDir);\n	\n	vec4 sg;\n	vec4 albedoColor;\n	#ifdef ALBEDOTEXTURE\n		vec4 albedoTextureColor = texture2D(u_AlbedoTexture, uv0);\n		albedoColor = albedoTextureColor * u_AlbedoColor;\n		sg = SpecularGloss(albedoTextureColor.a, uv0);\n	#else\n		albedoColor = u_AlbedoColor;\n		sg = SpecularGloss(1.0, uv0);\n	#endif\n	\n	#ifdef ALPHATEST\n		if(albedoColor.a < u_AlphaTestValue)\n			discard;\n	#endif\n  \n	vec3 normal = UnpackScaleNormal(uv0);\n	\n	LayaGI gi;\n	gi.diffuse = u_AmbientColor * Occlusion(uv0).rgb;\n	gi.specular = ReflectCubeMap(viewDir, normal);\n	\n	//float a = (sg.r+sg.g+sg.b) / 3.0;\n  \n	vec4 color = vec4(0.0);\n	\n	#ifdef DIRECTIONLIGHT\n		color += PBRSpecularDiectionLight(albedoColor, sg.rgb, sg.a, normal, viewDir, u_DirectionLight, gi);\n	#endif\n \n	#ifdef POINTLIGHT\n		color.a = 0.0;\n		color += PBRSpecularPointLight(albedoColor, sg.rgb, sg.a, normal, viewDir, u_PointLight, v_PositionWorld, gi);\n	#endif\n	\n	#ifdef SPOTLIGHT\n		color.a = 0.0;\n		color += PBRSpecularSpotLight(albedoColor, sg.rgb, sg.a, normal, viewDir, u_SpotLight, v_PositionWorld, gi);\n	#endif\n	\n	#ifdef EMISSION\n		vec4 emissionColor = u_EmissionColor;\n		#ifdef EMISSIONTEXTURE\n			emissionColor *=  texture2D(u_EmissionTexture, uv0);\n		#endif\n		color.rgb += emissionColor.rgb;\n	#endif\n	\n	#ifdef RECEIVESHADOW\n		float shadowValue = 1.0;\n		#ifdef SHADOWMAP_PSSM3\n			shadowValue = getShadowPSSM3( u_shadowMap1,u_shadowMap2,u_shadowMap3,u_lightShadowVP,u_shadowPSSMDistance,u_shadowPCFoffset,v_PositionWorld,v_posViewZ,0.001);\n		#endif\n		#ifdef SHADOWMAP_PSSM2\n			shadowValue = getShadowPSSM2( u_shadowMap1,u_shadowMap2,u_lightShadowVP,u_shadowPSSMDistance,u_shadowPCFoffset,v_PositionWorld,v_posViewZ,0.001);\n		#endif \n		#ifdef SHADOWMAP_PSSM1\n			shadowValue = getShadowPSSM1( u_shadowMap1,v_lightMVPPos,u_shadowPSSMDistance,u_shadowPCFoffset,v_posViewZ,0.001);\n		#endif\n		gl_FragColor = vec4(color.rgb * shadowValue, color.a);\n	#else\n		gl_FragColor = color;\n	#endif\n	\n	#ifdef FOG\n		float lerpFact = clamp((1.0 / gl_FragCoord.w - u_FogStart) / u_FogRange, 0.0, 1.0);\n		gl_FragColor.rgb = mix(gl_FragColor.rgb, u_FogColor, lerpFact);\n	#endif\n}\n\nvoid main()\n{\n	#ifdef CASTSHADOW		\n		main_castShadow();\n	#else\n		main_normal();\n	#endif  \n}\n\n";
		shader=Shader3D.add("PBRSpecular",true);
		subShader=new SubShader(attributeMap,uniformMap,SkinnedMeshSprite3D.shaderDefines,PBRSpecularMaterial.shaderDefines);
		shader.addSubShader(subShader);
		subShader.addShaderPass(vs,ps,stateMap);
		attributeMap={
			'a_Position':/*laya.d3.graphics.Vertex.VertexMesh.MESH_POSITION0*/0,
			'a_Color':/*laya.d3.graphics.Vertex.VertexMesh.MESH_COLOR0*/1,
			'a_Texcoord0':/*laya.d3.graphics.Vertex.VertexMesh.MESH_TEXTURECOORDINATE0*/2,
			'a_BoneWeights':/*laya.d3.graphics.Vertex.VertexMesh.MESH_BLENDWEIGHT0*/6,
			'a_BoneIndices':/*laya.d3.graphics.Vertex.VertexMesh.MESH_BLENDINDICES0*/5,
			'a_MvpMatrix':/*laya.d3.graphics.Vertex.VertexMesh.MESH_MVPMATRIX_ROW0*/12
		};
		uniformMap={
			'u_Bones':/*laya.d3.shader.Shader3D.PERIOD_CUSTOM*/0,
			'u_AlbedoTexture':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_AlbedoColor':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_TilingOffset':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_AlphaTestValue':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_MvpMatrix':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_FogStart':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_FogRange':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_FogColor':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4
		};
		stateMap={
			's_Cull':/*laya.d3.shader.Shader3D.RENDER_STATE_CULL*/0,
			's_Blend':/*laya.d3.shader.Shader3D.RENDER_STATE_BLEND*/1,
			's_BlendSrc':/*laya.d3.shader.Shader3D.RENDER_STATE_BLEND_SRC*/2,
			's_BlendDst':/*laya.d3.shader.Shader3D.RENDER_STATE_BLEND_DST*/3,
			's_DepthTest':/*laya.d3.shader.Shader3D.RENDER_STATE_DEPTH_TEST*/12,
			's_DepthWrite':/*laya.d3.shader.Shader3D.RENDER_STATE_DEPTH_WRITE*/13
		}
		vs="#include \"Lighting.glsl\";\n\nattribute vec4 a_Position;\n\nattribute vec2 a_Texcoord0;\n\n#ifdef GPU_INSTANCE\n	attribute mat4 a_MvpMatrix;\n#else\n	uniform mat4 u_MvpMatrix;\n#endif\n\nattribute vec4 a_Color;\nvarying vec4 v_Color;\nvarying vec2 v_Texcoord0;\n\n#ifdef TILINGOFFSET\n	uniform vec4 u_TilingOffset;\n#endif\n\n#ifdef BONE\n	const int c_MaxBoneCount = 24;\n	attribute vec4 a_BoneIndices;\n	attribute vec4 a_BoneWeights;\n	uniform mat4 u_Bones[c_MaxBoneCount];\n#endif\n\nvoid main() {\n	vec4 position;\n	#ifdef BONE\n		mat4 skinTransform = u_Bones[int(a_BoneIndices.x)] * a_BoneWeights.x;\n		skinTransform += u_Bones[int(a_BoneIndices.y)] * a_BoneWeights.y;\n		skinTransform += u_Bones[int(a_BoneIndices.z)] * a_BoneWeights.z;\n		skinTransform += u_Bones[int(a_BoneIndices.w)] * a_BoneWeights.w;\n		position=skinTransform*a_Position;\n	#else\n		position=a_Position;\n	#endif\n	#ifdef GPU_INSTANCE\n		gl_Position = a_MvpMatrix * position;\n	#else\n		gl_Position = u_MvpMatrix * position;\n	#endif\n\n	#ifdef TILINGOFFSET\n		v_Texcoord0=TransformUV(a_Texcoord0,u_TilingOffset);\n	#else\n		v_Texcoord0=a_Texcoord0;\n	#endif\n\n	#if defined(COLOR)&&defined(ENABLEVERTEXCOLOR)\n		v_Color = a_Color;\n	#endif\n	gl_Position=remapGLPositionZ(gl_Position);\n}";
		ps="#ifdef FSHIGHPRECISION\n	precision highp float;\n#else\n	precision mediump float;\n#endif\n\n#if defined(COLOR)&&defined(ENABLEVERTEXCOLOR)\n	varying vec4 v_Color;\n#endif\n\n#ifdef ALBEDOTEXTURE\n	uniform sampler2D u_AlbedoTexture;\n	varying vec2 v_Texcoord0;\n#endif\n\nuniform vec4 u_AlbedoColor;\n\n#ifdef ALPHATEST\n	uniform float u_AlphaTestValue;\n#endif\n\n#ifdef FOG\n	uniform float u_FogStart;\n	uniform float u_FogRange;\n	#ifdef ADDTIVEFOG\n	#else\n		uniform vec3 u_FogColor;\n	#endif\n#endif\n\nvoid main()\n{\n	vec4 color =  u_AlbedoColor;\n	#ifdef ALBEDOTEXTURE\n		color *= texture2D(u_AlbedoTexture, v_Texcoord0);\n	#endif\n	#if defined(COLOR)&&defined(ENABLEVERTEXCOLOR)\n		color *= v_Color;\n	#endif\n	\n	#ifdef ALPHATEST\n		if(color.a < u_AlphaTestValue)\n			discard;\n	#endif\n	\n	gl_FragColor = color;\n	\n	#ifdef FOG\n		float lerpFact = clamp((1.0 / gl_FragCoord.w - u_FogStart) / u_FogRange, 0.0, 1.0);\n		#ifdef ADDTIVEFOG\n			gl_FragColor.rgb = mix(gl_FragColor.rgb, vec3(0.0), lerpFact);\n		#else\n			gl_FragColor.rgb = mix(gl_FragColor.rgb, u_FogColor, lerpFact);\n		#endif\n	#endif\n	\n}\n\n";
		shader=Shader3D.add("Unlit",true);
		subShader=new SubShader(attributeMap,uniformMap,SkinnedMeshSprite3D.shaderDefines,UnlitMaterial.shaderDefines);
		shader.addSubShader(subShader);
		subShader.addShaderPass(vs,ps,stateMap);
		attributeMap={
			'a_Position':/*laya.d3.graphics.Vertex.VertexMesh.MESH_POSITION0*/0,
			'a_Texcoord0':/*laya.d3.graphics.Vertex.VertexMesh.MESH_TEXTURECOORDINATE0*/2,
			'a_BoneWeights':/*laya.d3.graphics.Vertex.VertexMesh.MESH_BLENDWEIGHT0*/6,
			'a_BoneIndices':/*laya.d3.graphics.Vertex.VertexMesh.MESH_BLENDINDICES0*/5,
			'a_MvpMatrix':/*laya.d3.graphics.Vertex.VertexMesh.MESH_MVPMATRIX_ROW0*/12
		};
		uniformMap={
			'u_Bones':/*laya.d3.shader.Shader3D.PERIOD_CUSTOM*/0,
			'u_AlbedoTexture':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_AlbedoColor':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_TilingOffset':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_AlphaTestValue':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_MvpMatrix':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_FogStart':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_FogRange':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_FogColor':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4
		};
		stateMap={
			's_Cull':/*laya.d3.shader.Shader3D.RENDER_STATE_CULL*/0,
			's_Blend':/*laya.d3.shader.Shader3D.RENDER_STATE_BLEND*/1,
			's_BlendSrc':/*laya.d3.shader.Shader3D.RENDER_STATE_BLEND_SRC*/2,
			's_BlendDst':/*laya.d3.shader.Shader3D.RENDER_STATE_BLEND_DST*/3,
			's_DepthTest':/*laya.d3.shader.Shader3D.RENDER_STATE_DEPTH_TEST*/12,
			's_DepthWrite':/*laya.d3.shader.Shader3D.RENDER_STATE_DEPTH_WRITE*/13
		}
		vs="#include \"Lighting.glsl\";\n\nattribute vec4 a_Position;\nattribute vec4 a_Color;\nattribute vec2 a_Texcoord0;\n\n#ifdef GPU_INSTANCE\n	attribute mat4 a_MvpMatrix;\n#else\n	uniform mat4 u_MvpMatrix;\n#endif\n\nvarying vec4 v_Color;\nvarying vec2 v_Texcoord0;\n\n#ifdef TILINGOFFSET\n	uniform vec4 u_TilingOffset;\n#endif\n\n#ifdef BONE\n	const int c_MaxBoneCount = 24;\n	attribute vec4 a_BoneIndices;\n	attribute vec4 a_BoneWeights;\n	uniform mat4 u_Bones[c_MaxBoneCount];\n#endif\n\nvoid main()\n{\n	vec4 position;\n	#ifdef BONE\n		mat4 skinTransform = u_Bones[int(a_BoneIndices.x)] * a_BoneWeights.x;\n		skinTransform += u_Bones[int(a_BoneIndices.y)] * a_BoneWeights.y;\n		skinTransform += u_Bones[int(a_BoneIndices.z)] * a_BoneWeights.z;\n		skinTransform += u_Bones[int(a_BoneIndices.w)] * a_BoneWeights.w;\n		position=skinTransform*a_Position;\n	#else\n		position=a_Position;\n	#endif\n	#ifdef GPU_INSTANCE\n		gl_Position = a_MvpMatrix * position;\n	#else\n		gl_Position = u_MvpMatrix * position;\n	#endif\n	\n	#ifdef TILINGOFFSET\n		v_Texcoord0=TransformUV(a_Texcoord0,u_TilingOffset);\n	#else\n		v_Texcoord0=a_Texcoord0;\n	#endif\n		\n	v_Color = a_Color;\n	gl_Position=remapGLPositionZ(gl_Position);\n}";
		ps="#ifdef FSHIGHPRECISION\n	precision highp float;\n#else\n	precision mediump float;\n#endif\n\n#ifdef COLOR\n	varying vec4 v_Color;\n#endif\nvarying vec2 v_Texcoord0;\n\n#ifdef MAINTEXTURE\n	uniform sampler2D u_AlbedoTexture;\n#endif\n\nuniform vec4 u_AlbedoColor;\n\n#ifdef FOG\n	uniform float u_FogStart;\n	uniform float u_FogRange;\n	#ifdef ADDTIVEFOG\n	#else\n		uniform vec3 u_FogColor;\n	#endif\n#endif\n\nvoid main()\n{\n	vec4 color =  2.0 * u_AlbedoColor;\n	#ifdef COLOR\n		color *= v_Color;\n	#endif\n	#ifdef MAINTEXTURE\n		color *= texture2D(u_AlbedoTexture, v_Texcoord0);\n	#endif\n	\n	gl_FragColor = color;\n	\n	#ifdef FOG\n		float lerpFact = clamp((1.0 / gl_FragCoord.w - u_FogStart) / u_FogRange, 0.0, 1.0);\n		#ifdef ADDTIVEFOG\n			gl_FragColor.rgb = mix(gl_FragColor.rgb, vec3(0.0), lerpFact);\n		#else\n			gl_FragColor.rgb = mix(gl_FragColor.rgb, u_FogColor, lerpFact);\n		#endif\n	#endif\n}\n\n";
		shader=Shader3D.add("Effect",true);
		subShader=new SubShader(attributeMap,uniformMap,SkinnedMeshSprite3D.shaderDefines,EffectMaterial.shaderDefines);
		shader.addSubShader(subShader);
		subShader.addShaderPass(vs,ps,stateMap);
		attributeMap={
			'a_CornerTextureCoordinate':/*laya.d3.graphics.Vertex.VertexShuriKenParticle.PARTICLE_CORNERTEXTURECOORDINATE0*/0,
			'a_MeshPosition':/*laya.d3.graphics.Vertex.VertexShuriKenParticle.PARTICLE_POSITION0*/1,
			'a_MeshColor':/*laya.d3.graphics.Vertex.VertexShuriKenParticle.PARTICLE_COLOR0*/2,
			'a_MeshTextureCoordinate':/*laya.d3.graphics.Vertex.VertexShuriKenParticle.PARTICLE_TEXTURECOORDINATE0*/3,
			'a_ShapePositionStartLifeTime':/*laya.d3.graphics.Vertex.VertexShuriKenParticle.PARTICLE_SHAPEPOSITIONSTARTLIFETIME*/4,
			'a_DirectionTime':/*laya.d3.graphics.Vertex.VertexShuriKenParticle.PARTICLE_DIRECTIONTIME*/5,
			'a_StartColor':/*laya.d3.graphics.Vertex.VertexShuriKenParticle.PARTICLE_STARTCOLOR0*/6,
			'a_EndColor':/*laya.d3.graphics.Vertex.VertexShuriKenParticle.PARTICLE_ENDCOLOR0*/7,
			'a_StartSize':/*laya.d3.graphics.Vertex.VertexShuriKenParticle.PARTICLE_STARTSIZE*/8,
			'a_StartRotation0':/*laya.d3.graphics.Vertex.VertexShuriKenParticle.PARTICLE_STARTROTATION*/9,
			'a_StartSpeed':/*laya.d3.graphics.Vertex.VertexShuriKenParticle.PARTICLE_STARTSPEED*/10,
			'a_Random0':/*laya.d3.graphics.Vertex.VertexShuriKenParticle.PARTICLE_RANDOM0*/11,
			'a_Random1':/*laya.d3.graphics.Vertex.VertexShuriKenParticle.PARTICLE_RANDOM1*/12,
			'a_SimulationWorldPostion':/*laya.d3.graphics.Vertex.VertexShuriKenParticle.PARTICLE_SIMULATIONWORLDPOSTION*/13,
			'a_SimulationWorldRotation':/*laya.d3.graphics.Vertex.VertexShuriKenParticle.PARTICLE_SIMULATIONWORLDROTATION*/14};
		uniformMap={
			'u_Tintcolor':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_TilingOffset':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_texture':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_WorldPosition':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_WorldRotation':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_PositionScale':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_SizeScale':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_ScalingMode':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_Gravity':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_ThreeDStartRotation':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_StretchedBillboardLengthScale':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_StretchedBillboardSpeedScale':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_SimulationSpace':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_CurrentTime':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_ColorOverLifeGradientAlphas':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_ColorOverLifeGradientColors':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_MaxColorOverLifeGradientAlphas':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_MaxColorOverLifeGradientColors':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_VOLVelocityConst':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_VOLVelocityGradientX':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_VOLVelocityGradientY':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_VOLVelocityGradientZ':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_VOLVelocityConstMax':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_VOLVelocityGradientMaxX':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_VOLVelocityGradientMaxY':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_VOLVelocityGradientMaxZ':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_VOLSpaceType':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_SOLSizeGradient':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_SOLSizeGradientX':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_SOLSizeGradientY':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_SOLSizeGradientZ':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_SOLSizeGradientMax':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_SOLSizeGradientMaxX':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_SOLSizeGradientMaxY':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_SOLSizeGradientMaxZ':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_ROLAngularVelocityConst':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_ROLAngularVelocityConstSeprarate':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_ROLAngularVelocityGradient':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_ROLAngularVelocityGradientX':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_ROLAngularVelocityGradientY':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_ROLAngularVelocityGradientZ':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_ROLAngularVelocityConstMax':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_ROLAngularVelocityConstMaxSeprarate':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_ROLAngularVelocityGradientMax':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_ROLAngularVelocityGradientMaxX':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_ROLAngularVelocityGradientMaxY':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_ROLAngularVelocityGradientMaxZ':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_ROLAngularVelocityGradientMaxW':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_TSACycles':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_TSASubUVLength':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_TSAGradientUVs':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_TSAMaxGradientUVs':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_CameraPos':/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3,
			'u_CameraDirection':/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3,
			'u_CameraUp':/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3,
			'u_View':/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3,
			'u_Projection':/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3,
			'u_FogStart':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_FogRange':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_FogColor':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4
		};
		stateMap={
			's_Cull':/*laya.d3.shader.Shader3D.RENDER_STATE_CULL*/0,
			's_Blend':/*laya.d3.shader.Shader3D.RENDER_STATE_BLEND*/1,
			's_BlendSrc':/*laya.d3.shader.Shader3D.RENDER_STATE_BLEND_SRC*/2,
			's_BlendDst':/*laya.d3.shader.Shader3D.RENDER_STATE_BLEND_DST*/3,
			's_DepthTest':/*laya.d3.shader.Shader3D.RENDER_STATE_DEPTH_TEST*/12,
			's_DepthWrite':/*laya.d3.shader.Shader3D.RENDER_STATE_DEPTH_WRITE*/13
		};
		vs="#include \"Lighting.glsl\";\n\n#ifdef HIGHPRECISION\n  precision highp float;\n#else\n  precision mediump float;\n#endif\n\n#if defined(SPHERHBILLBOARD)||defined(STRETCHEDBILLBOARD)||defined(HORIZONTALBILLBOARD)||defined(VERTICALBILLBOARD)\n	attribute vec4 a_CornerTextureCoordinate;\n#endif\n#ifdef RENDERMODE_MESH\n	attribute vec3 a_MeshPosition;\n	attribute vec4 a_MeshColor;\n	attribute vec2 a_MeshTextureCoordinate;\n	varying vec4 v_MeshColor;\n#endif\n\nattribute vec4 a_ShapePositionStartLifeTime;\nattribute vec4 a_DirectionTime;\nattribute vec4 a_StartColor;\nattribute vec3 a_StartSize;\nattribute vec3 a_StartRotation0;\nattribute float a_StartSpeed;\n#if defined(COLOROVERLIFETIME)||defined(RANDOMCOLOROVERLIFETIME)||defined(SIZEOVERLIFETIMERANDOMCURVES)||defined(SIZEOVERLIFETIMERANDOMCURVESSEPERATE)||defined(ROTATIONOVERLIFETIMERANDOMCONSTANTS)||defined(ROTATIONOVERLIFETIMERANDOMCURVES)\n  attribute vec4 a_Random0;\n#endif\n#if defined(TEXTURESHEETANIMATIONRANDOMCURVE)||defined(VELOCITYOVERLIFETIMERANDOMCONSTANT)||defined(VELOCITYOVERLIFETIMERANDOMCURVE)\n  attribute vec4 a_Random1;\n#endif\nattribute vec3 a_SimulationWorldPostion;\nattribute vec4 a_SimulationWorldRotation;\n\nvarying float v_Discard;\nvarying vec4 v_Color;\n#ifdef DIFFUSEMAP\n	varying vec2 v_TextureCoordinate;\n#endif\n\nuniform float u_CurrentTime;\nuniform vec3 u_Gravity;\n\nuniform vec3 u_WorldPosition;\nuniform vec4 u_WorldRotation;\nuniform bool u_ThreeDStartRotation;\nuniform int u_ScalingMode;\nuniform vec3 u_PositionScale;\nuniform vec3 u_SizeScale;\nuniform mat4 u_View;\nuniform mat4 u_Projection;\n\n#ifdef STRETCHEDBILLBOARD\n	uniform vec3 u_CameraPosition;\n#endif\nuniform vec3 u_CameraDirection;//TODO:只有几种广告牌模式需要用\nuniform vec3 u_CameraUp;\n\nuniform  float u_StretchedBillboardLengthScale;\nuniform  float u_StretchedBillboardSpeedScale;\nuniform int u_SimulationSpace;\n\n#if defined(VELOCITYOVERLIFETIMECONSTANT)||defined(VELOCITYOVERLIFETIMECURVE)||defined(VELOCITYOVERLIFETIMERANDOMCONSTANT)||defined(VELOCITYOVERLIFETIMERANDOMCURVE)\n  uniform  int  u_VOLSpaceType;\n#endif\n#if defined(VELOCITYOVERLIFETIMECONSTANT)||defined(VELOCITYOVERLIFETIMERANDOMCONSTANT)\n  uniform  vec3 u_VOLVelocityConst;\n#endif\n#if defined(VELOCITYOVERLIFETIMECURVE)||defined(VELOCITYOVERLIFETIMERANDOMCURVE)\n  uniform  vec2 u_VOLVelocityGradientX[4];//x为key,y为速度\n  uniform  vec2 u_VOLVelocityGradientY[4];//x为key,y为速度\n  uniform  vec2 u_VOLVelocityGradientZ[4];//x为key,y为速度\n#endif\n#ifdef VELOCITYOVERLIFETIMERANDOMCONSTANT\n  uniform  vec3 u_VOLVelocityConstMax;\n#endif\n#ifdef VELOCITYOVERLIFETIMERANDOMCURVE\n  uniform  vec2 u_VOLVelocityGradientMaxX[4];//x为key,y为速度\n  uniform  vec2 u_VOLVelocityGradientMaxY[4];//x为key,y为速度\n  uniform  vec2 u_VOLVelocityGradientMaxZ[4];//x为key,y为速度\n#endif\n\n#ifdef COLOROVERLIFETIME\n  uniform  vec4 u_ColorOverLifeGradientColors[4];//x为key,yzw为Color\n  uniform  vec2 u_ColorOverLifeGradientAlphas[4];//x为key,y为Alpha\n#endif\n#ifdef RANDOMCOLOROVERLIFETIME\n  uniform  vec4 u_ColorOverLifeGradientColors[4];//x为key,yzw为Color\n  uniform  vec2 u_ColorOverLifeGradientAlphas[4];//x为key,y为Alpha\n  uniform  vec4 u_MaxColorOverLifeGradientColors[4];//x为key,yzw为Color\n  uniform  vec2 u_MaxColorOverLifeGradientAlphas[4];//x为key,y为Alpha\n#endif\n\n\n#if defined(SIZEOVERLIFETIMECURVE)||defined(SIZEOVERLIFETIMERANDOMCURVES)\n  uniform  vec2 u_SOLSizeGradient[4];//x为key,y为尺寸\n#endif\n#ifdef SIZEOVERLIFETIMERANDOMCURVES\n  uniform  vec2 u_SOLSizeGradientMax[4];//x为key,y为尺寸\n#endif\n#if defined(SIZEOVERLIFETIMECURVESEPERATE)||defined(SIZEOVERLIFETIMERANDOMCURVESSEPERATE)\n  uniform  vec2 u_SOLSizeGradientX[4];//x为key,y为尺寸\n  uniform  vec2 u_SOLSizeGradientY[4];//x为key,y为尺寸\n  uniform  vec2 u_SOLSizeGradientZ[4];//x为key,y为尺寸\n#endif\n#ifdef SIZEOVERLIFETIMERANDOMCURVESSEPERATE\n  uniform  vec2 u_SOLSizeGradientMaxX[4];//x为key,y为尺寸\n  uniform  vec2 u_SOLSizeGradientMaxY[4];//x为key,y为尺寸\n  uniform  vec2 u_SOLSizeGradientMaxZ[4];//x为key,y为尺寸\n#endif\n\n\n#ifdef ROTATIONOVERLIFETIME\n  #if defined(ROTATIONOVERLIFETIMECONSTANT)||defined(ROTATIONOVERLIFETIMERANDOMCONSTANTS)\n    uniform  float u_ROLAngularVelocityConst;\n  #endif\n  #ifdef ROTATIONOVERLIFETIMERANDOMCONSTANTS\n    uniform  float u_ROLAngularVelocityConstMax;\n  #endif\n  #if defined(ROTATIONOVERLIFETIMECURVE)||defined(ROTATIONOVERLIFETIMERANDOMCURVES)\n    uniform  vec2 u_ROLAngularVelocityGradient[4];//x为key,y为旋转\n  #endif\n  #ifdef ROTATIONOVERLIFETIMERANDOMCURVES\n    uniform  vec2 u_ROLAngularVelocityGradientMax[4];//x为key,y为旋转\n  #endif\n#endif\n#ifdef ROTATIONOVERLIFETIMESEPERATE\n  #if defined(ROTATIONOVERLIFETIMECONSTANT)||defined(ROTATIONOVERLIFETIMERANDOMCONSTANTS)\n    uniform  vec3 u_ROLAngularVelocityConstSeprarate;\n  #endif\n  #ifdef ROTATIONOVERLIFETIMERANDOMCONSTANTS\n    uniform  vec3 u_ROLAngularVelocityConstMaxSeprarate;\n  #endif\n  #if defined(ROTATIONOVERLIFETIMECURVE)||defined(ROTATIONOVERLIFETIMERANDOMCURVES)\n    uniform  vec2 u_ROLAngularVelocityGradientX[4];\n    uniform  vec2 u_ROLAngularVelocityGradientY[4];\n    uniform  vec2 u_ROLAngularVelocityGradientZ[4];\n  #endif\n  #ifdef ROTATIONOVERLIFETIMERANDOMCURVES\n    uniform  vec2 u_ROLAngularVelocityGradientMaxX[4];\n    uniform  vec2 u_ROLAngularVelocityGradientMaxY[4];\n    uniform  vec2 u_ROLAngularVelocityGradientMaxZ[4];\n	uniform  vec2 u_ROLAngularVelocityGradientMaxW[4];\n  #endif\n#endif\n\n#if defined(TEXTURESHEETANIMATIONCURVE)||defined(TEXTURESHEETANIMATIONRANDOMCURVE)\n  uniform  float u_TSACycles;\n  uniform  vec2 u_TSASubUVLength;\n  uniform  vec2 u_TSAGradientUVs[4];//x为key,y为frame\n#endif\n#ifdef TEXTURESHEETANIMATIONRANDOMCURVE\n  uniform  vec2 u_TSAMaxGradientUVs[4];//x为key,y为frame\n#endif\n\n#ifdef FOG\n	varying vec3 v_PositionWorld;\n#endif\n\n#ifdef TILINGOFFSET\n	uniform vec4 u_TilingOffset;\n#endif\n\nvec3 rotationByEuler(in vec3 vector,in vec3 rot)\n{\n	float halfRoll = rot.z * 0.5;\n    float halfPitch = rot.x * 0.5;\n	float halfYaw = rot.y * 0.5;\n\n	float sinRoll = sin(halfRoll);\n	float cosRoll = cos(halfRoll);\n	float sinPitch = sin(halfPitch);\n	float cosPitch = cos(halfPitch);\n	float sinYaw = sin(halfYaw);\n	float cosYaw = cos(halfYaw);\n\n	float quaX = (cosYaw * sinPitch * cosRoll) + (sinYaw * cosPitch * sinRoll);\n	float quaY = (sinYaw * cosPitch * cosRoll) - (cosYaw * sinPitch * sinRoll);\n	float quaZ = (cosYaw * cosPitch * sinRoll) - (sinYaw * sinPitch * cosRoll);\n	float quaW = (cosYaw * cosPitch * cosRoll) + (sinYaw * sinPitch * sinRoll);\n	\n	//vec4 q=vec4(quaX,quaY,quaZ,quaW);\n	//vec3 temp = cross(q.xyz, vector) + q.w * vector;\n	//return (cross(temp, -q.xyz) + dot(q.xyz,vector) * q.xyz + q.w * temp);\n	\n	float x = quaX + quaX;\n    float y = quaY + quaY;\n    float z = quaZ + quaZ;\n    float wx = quaW * x;\n    float wy = quaW * y;\n    float wz = quaW * z;\n	float xx = quaX * x;\n    float xy = quaX * y;\n	float xz = quaX * z;\n    float yy = quaY * y;\n    float yz = quaY * z;\n    float zz = quaZ * z;\n\n    return vec3(((vector.x * ((1.0 - yy) - zz)) + (vector.y * (xy - wz))) + (vector.z * (xz + wy)),\n                ((vector.x * (xy + wz)) + (vector.y * ((1.0 - xx) - zz))) + (vector.z * (yz - wx)),\n                ((vector.x * (xz - wy)) + (vector.y * (yz + wx))) + (vector.z * ((1.0 - xx) - yy)));\n	\n}\n\n//假定axis已经归一化\nvec3 rotationByAxis(in vec3 vector,in vec3 axis, in float angle)\n{\n	float halfAngle = angle * 0.5;\n	float sin = sin(halfAngle);\n	\n	float quaX = axis.x * sin;\n	float quaY = axis.y * sin;\n	float quaZ = axis.z * sin;\n	float quaW = cos(halfAngle);\n	\n	//vec4 q=vec4(quaX,quaY,quaZ,quaW);\n	//vec3 temp = cross(q.xyz, vector) + q.w * vector;\n	//return (cross(temp, -q.xyz) + dot(q.xyz,vector) * q.xyz + q.w * temp);\n	\n	float x = quaX + quaX;\n    float y = quaY + quaY;\n    float z = quaZ + quaZ;\n    float wx = quaW * x;\n    float wy = quaW * y;\n    float wz = quaW * z;\n	float xx = quaX * x;\n    float xy = quaX * y;\n	float xz = quaX * z;\n    float yy = quaY * y;\n    float yz = quaY * z;\n    float zz = quaZ * z;\n\n    return vec3(((vector.x * ((1.0 - yy) - zz)) + (vector.y * (xy - wz))) + (vector.z * (xz + wy)),\n                ((vector.x * (xy + wz)) + (vector.y * ((1.0 - xx) - zz))) + (vector.z * (yz - wx)),\n                ((vector.x * (xz - wy)) + (vector.y * (yz + wx))) + (vector.z * ((1.0 - xx) - yy)));\n	\n}\n\nvec3 rotationByQuaternions(in vec3 v,in vec4 q) \n{\n	return v + 2.0 * cross(q.xyz, cross(q.xyz, v) + q.w * v);\n}\n\n \n#if defined(VELOCITYOVERLIFETIMECURVE)||defined(VELOCITYOVERLIFETIMERANDOMCURVE)||defined(SIZEOVERLIFETIMECURVE)||defined(SIZEOVERLIFETIMECURVESEPERATE)||defined(SIZEOVERLIFETIMERANDOMCURVES)||defined(SIZEOVERLIFETIMERANDOMCURVESSEPERATE)\nfloat getCurValueFromGradientFloat(in vec2 gradientNumbers[4],in float normalizedAge)\n{\n	float curValue;\n	for(int i=1;i<4;i++)\n	{\n		vec2 gradientNumber=gradientNumbers[i];\n		float key=gradientNumber.x;\n		if(key>=normalizedAge)\n		{\n			vec2 lastGradientNumber=gradientNumbers[i-1];\n			float lastKey=lastGradientNumber.x;\n			float age=(normalizedAge-lastKey)/(key-lastKey);\n			curValue=mix(lastGradientNumber.y,gradientNumber.y,age);\n			break;\n		}\n	}\n	return curValue;\n}\n#endif\n\n#if defined(VELOCITYOVERLIFETIMECURVE)||defined(VELOCITYOVERLIFETIMERANDOMCURVE)||defined(ROTATIONOVERLIFETIMECURVE)||defined(ROTATIONOVERLIFETIMERANDOMCURVES)\nfloat getTotalValueFromGradientFloat(in vec2 gradientNumbers[4],in float normalizedAge)\n{\n	float totalValue=0.0;\n	for(int i=1;i<4;i++)\n	{\n		vec2 gradientNumber=gradientNumbers[i];\n		float key=gradientNumber.x;\n		vec2 lastGradientNumber=gradientNumbers[i-1];\n		float lastValue=lastGradientNumber.y;\n		\n		if(key>=normalizedAge){\n			float lastKey=lastGradientNumber.x;\n			float age=(normalizedAge-lastKey)/(key-lastKey);\n			totalValue+=(lastValue+mix(lastValue,gradientNumber.y,age))/2.0*a_ShapePositionStartLifeTime.w*(normalizedAge-lastKey);\n			break;\n		}\n		else{\n			totalValue+=(lastValue+gradientNumber.y)/2.0*a_ShapePositionStartLifeTime.w*(key-lastGradientNumber.x);\n		}\n	}\n	return totalValue;\n}\n#endif\n\n#if defined(COLOROVERLIFETIME)||defined(RANDOMCOLOROVERLIFETIME)\nvec4 getColorFromGradient(in vec2 gradientAlphas[4],in vec4 gradientColors[4],in float normalizedAge)\n{\n	vec4 overTimeColor;\n	for(int i=1;i<4;i++)\n	{\n		vec2 gradientAlpha=gradientAlphas[i];\n		float alphaKey=gradientAlpha.x;\n		if(alphaKey>=normalizedAge)\n		{\n			vec2 lastGradientAlpha=gradientAlphas[i-1];\n			float lastAlphaKey=lastGradientAlpha.x;\n			float age=(normalizedAge-lastAlphaKey)/(alphaKey-lastAlphaKey);\n			overTimeColor.a=mix(lastGradientAlpha.y,gradientAlpha.y,age);\n			break;\n		}\n	}\n	\n	for(int i=1;i<4;i++)\n	{\n		vec4 gradientColor=gradientColors[i];\n		float colorKey=gradientColor.x;\n		if(colorKey>=normalizedAge)\n		{\n			vec4 lastGradientColor=gradientColors[i-1];\n			float lastColorKey=lastGradientColor.x;\n			float age=(normalizedAge-lastColorKey)/(colorKey-lastColorKey);\n			overTimeColor.rgb=mix(gradientColors[i-1].yzw,gradientColor.yzw,age);\n			break;\n		}\n	}\n	return overTimeColor;\n}\n#endif\n\n\n#if defined(TEXTURESHEETANIMATIONCURVE)||defined(TEXTURESHEETANIMATIONRANDOMCURVE)\nfloat getFrameFromGradient(in vec2 gradientFrames[4],in float normalizedAge)\n{\n	float overTimeFrame;\n	for(int i=1;i<4;i++)\n	{\n		vec2 gradientFrame=gradientFrames[i];\n		float key=gradientFrame.x;\n		if(key>=normalizedAge)\n		{\n			vec2 lastGradientFrame=gradientFrames[i-1];\n			float lastKey=lastGradientFrame.x;\n			float age=(normalizedAge-lastKey)/(key-lastKey);\n			overTimeFrame=mix(lastGradientFrame.y,gradientFrame.y,age);\n			break;\n		}\n	}\n	return floor(overTimeFrame);\n}\n#endif\n\n#if defined(VELOCITYOVERLIFETIMECONSTANT)||defined(VELOCITYOVERLIFETIMECURVE)||defined(VELOCITYOVERLIFETIMERANDOMCONSTANT)||defined(VELOCITYOVERLIFETIMERANDOMCURVE)\nvec3 computeParticleLifeVelocity(in float normalizedAge)\n{\n  vec3 outLifeVelocity;\n  #ifdef VELOCITYOVERLIFETIMECONSTANT\n	 outLifeVelocity=u_VOLVelocityConst; \n  #endif\n  #ifdef VELOCITYOVERLIFETIMECURVE\n     outLifeVelocity= vec3(getCurValueFromGradientFloat(u_VOLVelocityGradientX,normalizedAge),getCurValueFromGradientFloat(u_VOLVelocityGradientY,normalizedAge),getCurValueFromGradientFloat(u_VOLVelocityGradientZ,normalizedAge));\n  #endif\n  #ifdef VELOCITYOVERLIFETIMERANDOMCONSTANT\n	 outLifeVelocity=mix(u_VOLVelocityConst,u_VOLVelocityConstMax,vec3(a_Random1.y,a_Random1.z,a_Random1.w)); \n  #endif\n  #ifdef VELOCITYOVERLIFETIMERANDOMCURVE\n     outLifeVelocity=vec3(mix(getCurValueFromGradientFloat(u_VOLVelocityGradientX,normalizedAge),getCurValueFromGradientFloat(u_VOLVelocityGradientMaxX,normalizedAge),a_Random1.y),\n	                 mix(getCurValueFromGradientFloat(u_VOLVelocityGradientY,normalizedAge),getCurValueFromGradientFloat(u_VOLVelocityGradientMaxY,normalizedAge),a_Random1.z),\n					 mix(getCurValueFromGradientFloat(u_VOLVelocityGradientZ,normalizedAge),getCurValueFromGradientFloat(u_VOLVelocityGradientMaxZ,normalizedAge),a_Random1.w));\n  #endif\n					\n  return outLifeVelocity;\n} \n#endif\n\nvec3 computeParticlePosition(in vec3 startVelocity, in vec3 lifeVelocity,in float age,in float normalizedAge,vec3 gravityVelocity,vec4 worldRotation)\n{\n   vec3 startPosition;\n   vec3 lifePosition;\n   #if defined(VELOCITYOVERLIFETIMECONSTANT)||defined(VELOCITYOVERLIFETIMECURVE)||defined(VELOCITYOVERLIFETIMERANDOMCONSTANT)||defined(VELOCITYOVERLIFETIMERANDOMCURVE)\n	#ifdef VELOCITYOVERLIFETIMECONSTANT\n		  startPosition=startVelocity*age;\n		  lifePosition=lifeVelocity*age;\n	#endif\n	#ifdef VELOCITYOVERLIFETIMECURVE\n		  startPosition=startVelocity*age;\n		  lifePosition=vec3(getTotalValueFromGradientFloat(u_VOLVelocityGradientX,normalizedAge),getTotalValueFromGradientFloat(u_VOLVelocityGradientY,normalizedAge),getTotalValueFromGradientFloat(u_VOLVelocityGradientZ,normalizedAge));\n	#endif\n	#ifdef VELOCITYOVERLIFETIMERANDOMCONSTANT\n		  startPosition=startVelocity*age;\n		  lifePosition=lifeVelocity*age;\n	#endif\n	#ifdef VELOCITYOVERLIFETIMERANDOMCURVE\n		  startPosition=startVelocity*age;\n		  lifePosition=vec3(mix(getTotalValueFromGradientFloat(u_VOLVelocityGradientX,normalizedAge),getTotalValueFromGradientFloat(u_VOLVelocityGradientMaxX,normalizedAge),a_Random1.y)\n	      ,mix(getTotalValueFromGradientFloat(u_VOLVelocityGradientY,normalizedAge),getTotalValueFromGradientFloat(u_VOLVelocityGradientMaxY,normalizedAge),a_Random1.z)\n	      ,mix(getTotalValueFromGradientFloat(u_VOLVelocityGradientZ,normalizedAge),getTotalValueFromGradientFloat(u_VOLVelocityGradientMaxZ,normalizedAge),a_Random1.w));\n	#endif\n	\n	vec3 finalPosition;\n	if(u_VOLSpaceType==0){\n	  if(u_ScalingMode!=2)\n	   finalPosition =rotationByQuaternions(u_PositionScale*(a_ShapePositionStartLifeTime.xyz+startPosition+lifePosition),worldRotation);\n	  else\n	   finalPosition =rotationByQuaternions(u_PositionScale*a_ShapePositionStartLifeTime.xyz+startPosition+lifePosition,worldRotation);\n	}\n	else{\n	  if(u_ScalingMode!=2)\n	    finalPosition = rotationByQuaternions(u_PositionScale*(a_ShapePositionStartLifeTime.xyz+startPosition),worldRotation)+lifePosition;\n	  else\n	    finalPosition = rotationByQuaternions(u_PositionScale*a_ShapePositionStartLifeTime.xyz+startPosition,worldRotation)+lifePosition;\n	}\n  #else\n	 startPosition=startVelocity*age;\n	 vec3 finalPosition;\n	 if(u_ScalingMode!=2)\n	   finalPosition = rotationByQuaternions(u_PositionScale*(a_ShapePositionStartLifeTime.xyz+startPosition),worldRotation);\n	 else\n	   finalPosition = rotationByQuaternions(u_PositionScale*a_ShapePositionStartLifeTime.xyz+startPosition,worldRotation);\n  #endif\n  \n  if(u_SimulationSpace==0)\n    finalPosition=finalPosition+a_SimulationWorldPostion;\n  else if(u_SimulationSpace==1) \n    finalPosition=finalPosition+u_WorldPosition;\n  \n  finalPosition+=0.5*gravityVelocity*age;\n \n  return  finalPosition;\n}\n\n\nvec4 computeParticleColor(in vec4 color,in float normalizedAge)\n{\n	#ifdef COLOROVERLIFETIME\n	  color*=getColorFromGradient(u_ColorOverLifeGradientAlphas,u_ColorOverLifeGradientColors,normalizedAge);\n	#endif\n	\n	#ifdef RANDOMCOLOROVERLIFETIME\n	  color*=mix(getColorFromGradient(u_ColorOverLifeGradientAlphas,u_ColorOverLifeGradientColors,normalizedAge),getColorFromGradient(u_MaxColorOverLifeGradientAlphas,u_MaxColorOverLifeGradientColors,normalizedAge),a_Random0.y);\n	#endif\n\n    return color;\n}\n\nvec2 computeParticleSizeBillbard(in vec2 size,in float normalizedAge)\n{\n	#ifdef SIZEOVERLIFETIMECURVE\n		size*=getCurValueFromGradientFloat(u_SOLSizeGradient,normalizedAge);\n	#endif\n	#ifdef SIZEOVERLIFETIMERANDOMCURVES\n	    size*=mix(getCurValueFromGradientFloat(u_SOLSizeGradient,normalizedAge),getCurValueFromGradientFloat(u_SOLSizeGradientMax,normalizedAge),a_Random0.z); \n	#endif\n	#ifdef SIZEOVERLIFETIMECURVESEPERATE\n		size*=vec2(getCurValueFromGradientFloat(u_SOLSizeGradientX,normalizedAge),getCurValueFromGradientFloat(u_SOLSizeGradientY,normalizedAge));\n	#endif\n	#ifdef SIZEOVERLIFETIMERANDOMCURVESSEPERATE\n	    size*=vec2(mix(getCurValueFromGradientFloat(u_SOLSizeGradientX,normalizedAge),getCurValueFromGradientFloat(u_SOLSizeGradientMaxX,normalizedAge),a_Random0.z)\n	    ,mix(getCurValueFromGradientFloat(u_SOLSizeGradientY,normalizedAge),getCurValueFromGradientFloat(u_SOLSizeGradientMaxY,normalizedAge),a_Random0.z));\n	#endif\n	return size;\n}\n\n#ifdef RENDERMODE_MESH\nvec3 computeParticleSizeMesh(in vec3 size,in float normalizedAge)\n{\n	#ifdef SIZEOVERLIFETIMECURVE\n		size*=getCurValueFromGradientFloat(u_SOLSizeGradient,normalizedAge);\n	#endif\n	#ifdef SIZEOVERLIFETIMERANDOMCURVES\n	    size*=mix(getCurValueFromGradientFloat(u_SOLSizeGradient,normalizedAge),getCurValueFromGradientFloat(u_SOLSizeGradientMax,normalizedAge),a_Random0.z); \n	#endif\n	#ifdef SIZEOVERLIFETIMECURVESEPERATE\n		size*=vec3(getCurValueFromGradientFloat(u_SOLSizeGradientX,normalizedAge),getCurValueFromGradientFloat(u_SOLSizeGradientY,normalizedAge),getCurValueFromGradientFloat(u_SOLSizeGradientZ,normalizedAge));\n	#endif\n	#ifdef SIZEOVERLIFETIMERANDOMCURVESSEPERATE\n	    size*=vec3(mix(getCurValueFromGradientFloat(u_SOLSizeGradientX,normalizedAge),getCurValueFromGradientFloat(u_SOLSizeGradientMaxX,normalizedAge),a_Random0.z)\n	    ,mix(getCurValueFromGradientFloat(u_SOLSizeGradientY,normalizedAge),getCurValueFromGradientFloat(u_SOLSizeGradientMaxY,normalizedAge),a_Random0.z)\n		,mix(getCurValueFromGradientFloat(u_SOLSizeGradientZ,normalizedAge),getCurValueFromGradientFloat(u_SOLSizeGradientMaxZ,normalizedAge),a_Random0.z));\n	#endif\n	return size;\n}\n#endif\n\nfloat computeParticleRotationFloat(in float rotation,in float age,in float normalizedAge)\n{ \n	#ifdef ROTATIONOVERLIFETIME\n		#ifdef ROTATIONOVERLIFETIMECONSTANT\n			float ageRot=u_ROLAngularVelocityConst*age;\n	        rotation+=ageRot;\n		#endif\n		#ifdef ROTATIONOVERLIFETIMECURVE\n			rotation+=getTotalValueFromGradientFloat(u_ROLAngularVelocityGradient,normalizedAge);\n		#endif\n		#ifdef ROTATIONOVERLIFETIMERANDOMCONSTANTS\n			float ageRot=mix(u_ROLAngularVelocityConst,u_ROLAngularVelocityConstMax,a_Random0.w)*age;\n	        rotation+=ageRot;\n	    #endif\n		#ifdef ROTATIONOVERLIFETIMERANDOMCURVES\n			rotation+=mix(getTotalValueFromGradientFloat(u_ROLAngularVelocityGradient,normalizedAge),getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientMax,normalizedAge),a_Random0.w);\n		#endif\n	#endif\n	#ifdef ROTATIONOVERLIFETIMESEPERATE\n		#ifdef ROTATIONOVERLIFETIMECONSTANT\n			float ageRot=u_ROLAngularVelocityConstSeprarate.z*age;\n	        rotation+=ageRot;\n		#endif\n		#ifdef ROTATIONOVERLIFETIMECURVE\n			rotation+=getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientZ,normalizedAge);\n		#endif\n		#ifdef ROTATIONOVERLIFETIMERANDOMCONSTANTS\n			float ageRot=mix(u_ROLAngularVelocityConstSeprarate.z,u_ROLAngularVelocityConstMaxSeprarate.z,a_Random0.w)*age;\n	        rotation+=ageRot;\n	    #endif\n		#ifdef ROTATIONOVERLIFETIMERANDOMCURVES\n			rotation+=mix(getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientZ,normalizedAge),getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientMaxZ,normalizedAge),a_Random0.w));\n		#endif\n	#endif\n	return rotation;\n}\n\n#if defined(RENDERMODE_MESH)&&(defined(ROTATIONOVERLIFETIME)||defined(ROTATIONOVERLIFETIMESEPERATE))\nvec3 computeParticleRotationVec3(in vec3 rotation,in float age,in float normalizedAge)\n{ \n	#ifdef ROTATIONOVERLIFETIME\n	#ifdef ROTATIONOVERLIFETIMECONSTANT\n			float ageRot=u_ROLAngularVelocityConst*age;\n	        rotation+=ageRot;\n		#endif\n		#ifdef ROTATIONOVERLIFETIMECURVE\n			rotation+=getTotalValueFromGradientFloat(u_ROLAngularVelocityGradient,normalizedAge);\n		#endif\n		#ifdef ROTATIONOVERLIFETIMERANDOMCONSTANTS\n			float ageRot=mix(u_ROLAngularVelocityConst,u_ROLAngularVelocityConstMax,a_Random0.w)*age;\n	        rotation+=ageRot;\n	    #endif\n		#ifdef ROTATIONOVERLIFETIMERANDOMCURVES\n			rotation+=mix(getTotalValueFromGradientFloat(u_ROLAngularVelocityGradient,normalizedAge),getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientMax,normalizedAge),a_Random0.w);\n		#endif\n	#endif\n	#ifdef ROTATIONOVERLIFETIMESEPERATE\n		#ifdef ROTATIONOVERLIFETIMECONSTANT\n			vec3 ageRot=u_ROLAngularVelocityConstSeprarate*age;\n	        rotation+=ageRot;\n		#endif\n		#ifdef ROTATIONOVERLIFETIMECURVE\n			rotation+=vec3(getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientX,normalizedAge),getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientY,normalizedAge),getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientZ,normalizedAge));\n		#endif\n		#ifdef ROTATIONOVERLIFETIMERANDOMCONSTANTS\n			vec3 ageRot=mix(u_ROLAngularVelocityConstSeprarate,u_ROLAngularVelocityConstMaxSeprarate,a_Random0.w)*age;\n	        rotation+=ageRot;\n	    #endif\n		#ifdef ROTATIONOVERLIFETIMERANDOMCURVES\n			rotation+=vec3(mix(getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientX,normalizedAge),getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientMaxX,normalizedAge),a_Random0.w)\n	        ,mix(getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientY,normalizedAge),getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientMaxY,normalizedAge),a_Random0.w)\n	        ,mix(getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientZ,normalizedAge),getTotalValueFromGradientFloat(u_ROLAngularVelocityGradientMaxZ,normalizedAge),a_Random0.w));\n		#endif\n	#endif\n	return rotation;\n}\n#endif\n\nvec2 computeParticleUV(in vec2 uv,in float normalizedAge)\n{ \n	#ifdef TEXTURESHEETANIMATIONCURVE\n		float cycleNormalizedAge=normalizedAge*u_TSACycles;\n		float frame=getFrameFromGradient(u_TSAGradientUVs,cycleNormalizedAge-floor(cycleNormalizedAge));\n		float totalULength=frame*u_TSASubUVLength.x;\n		float floorTotalULength=floor(totalULength);\n	    uv.x+=totalULength-floorTotalULength;\n		uv.y+=floorTotalULength*u_TSASubUVLength.y;\n    #endif\n	#ifdef TEXTURESHEETANIMATIONRANDOMCURVE\n		float cycleNormalizedAge=normalizedAge*u_TSACycles;\n		float uvNormalizedAge=cycleNormalizedAge-floor(cycleNormalizedAge);\n	    float frame=floor(mix(getFrameFromGradient(u_TSAGradientUVs,uvNormalizedAge),getFrameFromGradient(u_TSAMaxGradientUVs,uvNormalizedAge),a_Random1.x));\n		float totalULength=frame*u_TSASubUVLength.x;\n		float floorTotalULength=floor(totalULength);\n	    uv.x+=totalULength-floorTotalULength;\n		uv.y+=floorTotalULength*u_TSASubUVLength.y;\n    #endif\n	return uv;\n}\n\nvoid main()\n{\n	float age = u_CurrentTime - a_DirectionTime.w;\n	float normalizedAge = age/a_ShapePositionStartLifeTime.w;\n	vec3 lifeVelocity;\n	if(normalizedAge<1.0){ \n	vec3 startVelocity=a_DirectionTime.xyz*a_StartSpeed;\n	#if defined(VELOCITYOVERLIFETIMECONSTANT)||defined(VELOCITYOVERLIFETIMECURVE)||defined(VELOCITYOVERLIFETIMERANDOMCONSTANT)||defined(VELOCITYOVERLIFETIMERANDOMCURVE)\n		lifeVelocity= computeParticleLifeVelocity(normalizedAge);//计算粒子生命周期速度\n	#endif \n	vec3 gravityVelocity=u_Gravity*age;\n	\n	vec4 worldRotation;\n	if(u_SimulationSpace==0)\n		worldRotation=a_SimulationWorldRotation;\n	else\n		worldRotation=u_WorldRotation;\n	\n	vec3 center=computeParticlePosition(startVelocity, lifeVelocity, age, normalizedAge,gravityVelocity,worldRotation);//计算粒子位置\n   \n   \n   #ifdef SPHERHBILLBOARD\n		vec2 corner=a_CornerTextureCoordinate.xy;//Billboard模式z轴无效\n        vec3 cameraUpVector =normalize(u_CameraUp);//TODO:是否外面归一化\n        vec3 sideVector = normalize(cross(u_CameraDirection,cameraUpVector));\n        vec3 upVector = normalize(cross(sideVector,u_CameraDirection));\n	    corner*=computeParticleSizeBillbard(a_StartSize.xy,normalizedAge);\n		#if defined(ROTATIONOVERLIFETIME)||defined(ROTATIONOVERLIFETIMESEPERATE)\n			if(u_ThreeDStartRotation){\n				vec3 rotation=vec3(a_StartRotation0.xy,computeParticleRotationFloat(a_StartRotation0.z,age,normalizedAge));\n				center += u_SizeScale.xzy*rotationByEuler(corner.x*sideVector+corner.y*upVector,rotation);\n			}\n			else{\n				float rot = computeParticleRotationFloat(a_StartRotation0.x, age,normalizedAge);\n				float c = cos(rot);\n				float s = sin(rot);\n				mat2 rotation= mat2(c, -s, s, c);\n				corner=rotation*corner;\n				center += u_SizeScale.xzy*(corner.x*sideVector+corner.y*upVector);\n			}\n		#else\n			if(u_ThreeDStartRotation){\n				center += u_SizeScale.xzy*rotationByEuler(corner.x*sideVector+corner.y*upVector,a_StartRotation0);\n			}\n			else{\n				float c = cos(a_StartRotation0.x);\n				float s = sin(a_StartRotation0.x);\n				mat2 rotation= mat2(c, -s, s, c);\n				corner=rotation*corner;\n				center += u_SizeScale.xzy*(corner.x*sideVector+corner.y*upVector);\n			}\n		#endif\n   #endif\n   \n   #ifdef STRETCHEDBILLBOARD\n	vec2 corner=a_CornerTextureCoordinate.xy;//Billboard模式z轴无效\n	vec3 velocity;\n	#if defined(VELOCITYOVERLIFETIMECONSTANT)||defined(VELOCITYOVERLIFETIMECURVE)||defined(VELOCITYOVERLIFETIMERANDOMCONSTANT)||defined(VELOCITYOVERLIFETIMERANDOMCURVE)\n	    if(u_VOLSpaceType==0)\n		  velocity=rotationByQuaternions(u_SizeScale*(startVelocity+lifeVelocity),worldRotation)+gravityVelocity;\n	    else\n		  velocity=rotationByQuaternions(u_SizeScale*startVelocity,worldRotation)+lifeVelocity+gravityVelocity;\n    #else\n	    velocity= rotationByQuaternions(u_SizeScale*startVelocity,worldRotation)+gravityVelocity;\n    #endif	\n		vec3 cameraUpVector = normalize(velocity);\n		vec3 direction = normalize(center-u_CameraPosition);\n        vec3 sideVector = normalize(cross(direction,normalize(velocity)));\n		\n		sideVector=u_SizeScale.xzy*sideVector;\n		cameraUpVector=length(vec3(u_SizeScale.x,0.0,0.0))*cameraUpVector;\n		\n	    vec2 size=computeParticleSizeBillbard(a_StartSize.xy,normalizedAge);\n		\n	    const mat2 rotaionZHalfPI=mat2(0.0, -1.0, 1.0, 0.0);\n	    corner=rotaionZHalfPI*corner;\n	    corner.y=corner.y-abs(corner.y);\n		\n	    float speed=length(velocity);//TODO:\n	    center +=sign(u_SizeScale.x)*(sign(u_StretchedBillboardLengthScale)*size.x*corner.x*sideVector+(speed*u_StretchedBillboardSpeedScale+size.y*u_StretchedBillboardLengthScale)*corner.y*cameraUpVector);\n   #endif\n   \n   #ifdef HORIZONTALBILLBOARD\n		vec2 corner=a_CornerTextureCoordinate.xy;//Billboard模式z轴无效\n        const vec3 cameraUpVector=vec3(0.0,0.0,1.0);\n	    const vec3 sideVector = vec3(-1.0,0.0,0.0);\n		\n		float rot = computeParticleRotationFloat(a_StartRotation0.x, age,normalizedAge);\n        float c = cos(rot);\n        float s = sin(rot);\n        mat2 rotation= mat2(c, -s, s, c);\n	    corner=rotation*corner*cos(0.78539816339744830961566084581988);//TODO:临时缩小cos45,不确定U3D原因\n		corner*=computeParticleSizeBillbard(a_StartSize.xy,normalizedAge);\n        center +=u_SizeScale.xzy*(corner.x*sideVector+ corner.y*cameraUpVector);\n   #endif\n   \n   #ifdef VERTICALBILLBOARD\n		vec2 corner=a_CornerTextureCoordinate.xy;//Billboard模式z轴无效\n        const vec3 cameraUpVector =vec3(0.0,1.0,0.0);\n        vec3 sideVector = normalize(cross(u_CameraDirection,cameraUpVector));\n		\n		float rot = computeParticleRotationFloat(a_StartRotation0.x, age,normalizedAge);\n        float c = cos(rot);\n        float s = sin(rot);\n        mat2 rotation= mat2(c, -s, s, c);\n	    corner=rotation*corner*cos(0.78539816339744830961566084581988);//TODO:临时缩小cos45,不确定U3D原因\n		corner*=computeParticleSizeBillbard(a_StartSize.xy,normalizedAge);\n        center +=u_SizeScale.xzy*(corner.x*sideVector+ corner.y*cameraUpVector);\n   #endif\n   \n   #ifdef RENDERMODE_MESH\n	    vec3 size=computeParticleSizeMesh(a_StartSize,normalizedAge);\n		#if defined(ROTATIONOVERLIFETIME)||defined(ROTATIONOVERLIFETIMESEPERATE)\n			if(u_ThreeDStartRotation){\n				vec3 rotation=vec3(a_StartRotation0.xy,computeParticleRotationFloat(a_StartRotation0.z, age,normalizedAge));\n				center+= rotationByQuaternions(u_SizeScale*rotationByEuler(a_MeshPosition*size,rotation),worldRotation);\n			}\n			else{\n				#ifdef ROTATIONOVERLIFETIME\n					float angle=computeParticleRotationFloat(a_StartRotation0.x, age,normalizedAge);\n					if(a_ShapePositionStartLifeTime.x!=0.0||a_ShapePositionStartLifeTime.y!=0.0){\n						center+= (rotationByQuaternions(rotationByAxis(u_SizeScale*a_MeshPosition*size,normalize(cross(vec3(0.0,0.0,1.0),vec3(a_ShapePositionStartLifeTime.xy,0.0))),angle),worldRotation));//已验证\n					}\n					else{\n						#ifdef SHAPE\n							center+= u_SizeScale.xzy*(rotationByQuaternions(rotationByAxis(a_MeshPosition*size,vec3(0.0,-1.0,0.0),angle),worldRotation));\n						#else\n							if(u_SimulationSpace==0)\n								center+=rotationByAxis(u_SizeScale*a_MeshPosition*size,vec3(0.0,0.0,-1.0),angle);//已验证\n							else if(u_SimulationSpace==1)\n								center+=rotationByQuaternions(u_SizeScale*rotationByAxis(a_MeshPosition*size,vec3(0.0,0.0,-1.0),angle),worldRotation);//已验证\n						#endif\n					}\n				#endif\n				#ifdef ROTATIONOVERLIFETIMESEPERATE\n					//TODO:是否应合并if(u_ThreeDStartRotation)分支代码,待测试\n					vec3 angle=computeParticleRotationVec3(vec3(0.0,0.0,-a_StartRotation0.x), age,normalizedAge);\n					center+= (rotationByQuaternions(rotationByEuler(u_SizeScale*a_MeshPosition*size,vec3(angle.x,angle.y,angle.z)),worldRotation));//已验证\n				#endif		\n			}\n		#else\n			if(u_ThreeDStartRotation){\n				center+= rotationByQuaternions(u_SizeScale*rotationByEuler(a_MeshPosition*size,a_StartRotation0),worldRotation);//已验证\n			}\n			else{\n				if(a_ShapePositionStartLifeTime.x!=0.0||a_ShapePositionStartLifeTime.y!=0.0){\n					if(u_SimulationSpace==0)\n						center+= rotationByAxis(u_SizeScale*a_MeshPosition*size,normalize(cross(vec3(0.0,0.0,1.0),vec3(a_ShapePositionStartLifeTime.xy,0.0))),a_StartRotation0.x);\n					else if(u_SimulationSpace==1)\n						center+= (rotationByQuaternions(u_SizeScale*rotationByAxis(a_MeshPosition*size,normalize(cross(vec3(0.0,0.0,1.0),vec3(a_ShapePositionStartLifeTime.xy,0.0))),a_StartRotation0.x),worldRotation));//已验证\n				}\n				else{\n					#ifdef SHAPE\n						if(u_SimulationSpace==0)\n							center+= u_SizeScale*rotationByAxis(a_MeshPosition*size,vec3(0.0,-1.0,0.0),a_StartRotation0.x);\n						else if(u_SimulationSpace==1)\n							center+= rotationByQuaternions(u_SizeScale*rotationByAxis(a_MeshPosition*size,vec3(0.0,-1.0,0.0),a_StartRotation0.x),worldRotation);	\n					#else\n						if(u_SimulationSpace==0)\n							center+= rotationByAxis(u_SizeScale*a_MeshPosition*size,vec3(0.0,0.0,-1.0),a_StartRotation0.x);\n						else if(u_SimulationSpace==1)\n							center+= rotationByQuaternions(u_SizeScale*rotationByAxis(a_MeshPosition*size,vec3(0.0,0.0,-1.0),a_StartRotation0.x),worldRotation);//已验证\n					#endif\n				}\n			}\n		#endif\n		v_MeshColor=a_MeshColor;\n   #endif\n   \n    gl_Position=u_Projection*u_View*vec4(center,1.0);\n    v_Color = computeParticleColor(a_StartColor, normalizedAge);\n	#ifdef DIFFUSEMAP\n		#if defined(SPHERHBILLBOARD)||defined(STRETCHEDBILLBOARD)||defined(HORIZONTALBILLBOARD)||defined(VERTICALBILLBOARD)\n			v_TextureCoordinate =computeParticleUV(a_CornerTextureCoordinate.zw, normalizedAge);\n		#endif\n		#ifdef RENDERMODE_MESH\n			v_TextureCoordinate =computeParticleUV(a_MeshTextureCoordinate, normalizedAge);\n		#endif\n		\n		#ifdef TILINGOFFSET\n			v_TextureCoordinate=vec2(v_TextureCoordinate.x,1.0-v_TextureCoordinate.y)*u_TilingOffset.xy+vec2(u_TilingOffset.z,-u_TilingOffset.w);//需要特殊处理\n			v_TextureCoordinate=vec2(v_TextureCoordinate.x,1.0-v_TextureCoordinate.y);//需要特殊处理\n		#endif\n	#endif\n    v_Discard=0.0;\n	  \n	#ifdef FOG\n		v_PositionWorld=center;\n	#endif\n   }\n   else\n	{\n		v_Discard=1.0;\n	}\n	gl_Position=remapGLPositionZ(gl_Position);\n}\n\n";
		ps="#ifdef HIGHPRECISION\n  precision highp float;\n#else\n  precision mediump float;\n#endif\n\nvarying float v_Discard;\nvarying vec4 v_Color;\nvarying vec2 v_TextureCoordinate;\nuniform sampler2D u_texture;\nuniform vec4 u_Tintcolor;\n\n#ifdef RENDERMODE_MESH\n	varying vec4 v_MeshColor;\n#endif\n\n#ifdef FOG\n	varying vec3 v_PositionWorld;\n	uniform vec3 u_CameraPosition;\n	uniform float u_FogStart;\n	uniform float u_FogRange;\n	#ifdef ADDTIVEFOG\n	#else\n		uniform vec3 u_FogColor;\n	#endif\n#endif\n\n\nvoid main()\n{	\n	#ifdef RENDERMODE_MESH\n		gl_FragColor=v_MeshColor;\n	#else\n		gl_FragColor=vec4(1.0);	\n	#endif\n		\n	#ifdef DIFFUSEMAP\n		if(v_Discard!=0.0)\n			discard;\n		#ifdef TINTCOLOR\n			gl_FragColor*=texture2D(u_texture,v_TextureCoordinate)*u_Tintcolor*2.0*v_Color;\n		#else\n			gl_FragColor*=texture2D(u_texture,v_TextureCoordinate)*v_Color;\n		#endif\n	#else\n		#ifdef TINTCOLOR\n			gl_FragColor*=u_Tintcolor*2.0*v_Color;\n		#else\n			gl_FragColor*=v_Color;\n		#endif\n	#endif\n	\n	#ifdef FOG\n		vec3 toEye=u_CameraPosition-v_PositionWorld;\n		float toEyeLength=length(toEye);\n		toEye/=toEyeLength;\n		\n		float lerpFact=clamp((toEyeLength-u_FogStart)/u_FogRange,0.0,1.0);\n		#ifdef ADDTIVEFOG\n			gl_FragColor.rgb=mix(gl_FragColor.rgb,vec3(0.0,0.0,0.0),lerpFact);\n		#else\n			gl_FragColor.rgb=mix(gl_FragColor.rgb,u_FogColor,lerpFact);\n		#endif\n	#endif\n}";
		shader=Shader3D.add("PARTICLESHURIKEN");
		subShader=new SubShader(attributeMap,uniformMap,ShuriKenParticle3D.shaderDefines,ShurikenParticleMaterial.shaderDefines);
		shader.addSubShader(subShader);
		subShader.addShaderPass(vs,ps,stateMap);
		attributeMap={
			'a_Position':/*laya.d3.graphics.Vertex.VertexMesh.MESH_POSITION0*/0};
		uniformMap={
			'u_TintColor':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_Exposure':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_Rotation':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_CubeTexture':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_MvpMatrix':/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3};
		vs="#include \"Lighting.glsl\";\n\nattribute vec4 a_Position;\nuniform mat4 u_MvpMatrix;\nuniform float u_Rotation;\nvarying vec3 v_Texcoord;\n\n\nvec4 rotateAroundYInDegrees (vec4 vertex, float degrees)\n{\n	float angle = degrees * 3.141593 / 180.0;\n	float sina=sin(angle);\n	float cosa=cos(angle);\n	mat2 m = mat2(cosa, -sina, sina, cosa);\n	return vec4(m*vertex.xz, vertex.yw).xzyw;\n}\n		\nvoid main()\n{\n	vec4 position=rotateAroundYInDegrees(a_Position,u_Rotation);\n	gl_Position = (u_MvpMatrix*position).xyww;\n	v_Texcoord=vec3(-a_Position.x,a_Position.yz);//转换坐标系\n	gl_Position=remapGLPositionZ(gl_Position);\n}\n";
		ps="#ifdef HIGHPRECISION\nprecision highp float;\n#else\nprecision mediump float;\n#endif\n\nvarying vec3 v_Texcoord;\n\nuniform samplerCube u_CubeTexture;\nuniform float u_Exposure;\nuniform vec4 u_TintColor;\n\n\nvoid main()\n{	\n	vec3 color=textureCube(u_CubeTexture, v_Texcoord).rgb*u_TintColor.rgb*u_Exposure*2.0;\n	gl_FragColor=vec4(color,1.0);\n}\n\n";
		shader=Shader3D.add("SkyBox");
		subShader=new SubShader(attributeMap,uniformMap);
		shader.addSubShader(subShader);
		subShader.addShaderPass(vs,ps);
		attributeMap={
			'a_Position':/*laya.d3.graphics.Vertex.VertexMesh.MESH_POSITION0*/0};
		uniformMap={
			'u_SunSize':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_SunSizeConvergence':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_AtmosphereThickness':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_SkyTint':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_GroundTint':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_Exposure':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_MvpMatrix':/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3,
			'u_DirectionLight.Direction':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_DirectionLight.Color':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4
		};
		vs="#ifdef HIGHPRECISION\n	precision highp float;\n#else\n	precision mediump float;\n#endif\n\n#include \"Lighting.glsl\";\n\n#define OUTER_RADIUS 1.025\n#define RAYLEIGH (mix(0.0, 0.0025, pow(u_AtmosphereThickness,2.5)))// Rayleigh constant Rayleigh为夜空光和极光亮度单位\n#define MIE 0.0010             // Mie constant 米氏散射\n#define SUN_BRIGHTNESS 20.0    // Sun brightness\n#define MAX_SCATTER 50.0 // Maximum scattering value, to prevent math overflows on Adrenos\n\nconst float SKY_GROUND_THRESHOLD = 0.02;\nconst float outerRadius = OUTER_RADIUS;\nconst float outerRadius2 = OUTER_RADIUS*OUTER_RADIUS;\nconst float innerRadius = 1.0;\nconst float innerRadius2 = 1.0;\nconst float cameraHeight = 0.0001;\n\nconst float HDSundiskIntensityFactor = 15.0;\nconst float simpleSundiskIntensityFactor = 27.0;\n\nconst float sunScale = 400.0 * SUN_BRIGHTNESS;\nconst float kmESun = MIE * SUN_BRIGHTNESS;\nconst float km4PI = MIE * 4.0 * 3.14159265;\nconst float scale = 1.0 / (OUTER_RADIUS - 1.0);\nconst float scaleDepth = 0.25;\nconst float scaleOverScaleDepth = (1.0 / (OUTER_RADIUS - 1.0)) / 0.25;\nconst float samples = 2.0; // THIS IS UNROLLED MANUALLY, DON'T TOUCH\n\n// RGB wavelengths        .35 (.62=158), .43 (.68=174), .525 (.75=190)\nconst vec3 c_DefaultScatteringWavelength = vec3(0.65, 0.57, 0.475);//默认散射波长\nconst vec3 c_VariableRangeForScatteringWavelength = vec3(0.15, 0.15, 0.15);//散射播放的可变范围\n\nattribute vec4 a_Position;\n\nuniform mat4 u_MvpMatrix;\nuniform vec3 u_SkyTint;\nuniform vec3 u_GroundTint;\nuniform float u_Exposure;\nuniform float u_AtmosphereThickness;\nuniform DirectionLight u_DirectionLight;\n\nvarying vec3 v_GroundColor;\nvarying vec3 v_SkyColor;\n\n#ifdef SUN_HIGH_QUALITY\n	varying vec3 v_Vertex;\n#elif defined(SUN_SIMPLE)\n	varying vec3 v_RayDir;\n#else\n	varying float v_SkyGroundFactor;\n#endif\n\n#if defined(SUN_HIGH_QUALITY)||defined(SUN_SIMPLE)\n	varying vec3 v_SunColor;\n#endif\n\n// Calculates the Rayleigh phase function\nfloat getRayleighPhase(vec3 light, vec3 ray) \n{\n	float eyeCos = dot(light, ray);\n	return 0.75 + 0.75*eyeCos*eyeCos;\n}\n\nfloat scaleAngle(float inCos)\n{\n	float x = 1.0 - inCos;\n	return 0.25 * exp(-0.00287 + x*(0.459 + x*(3.83 + x*(-6.80 + x*5.25))));\n}\n\n\nvoid main () {\n	gl_Position = (u_MvpMatrix*a_Position).xyww;\n\n	vec3 skyTintInGammaSpace = u_SkyTint;//支持非GAMMA空间后要调整\n	vec3 scatteringWavelength = mix(c_DefaultScatteringWavelength-c_VariableRangeForScatteringWavelength,c_DefaultScatteringWavelength+c_VariableRangeForScatteringWavelength,vec3(1.0) - skyTintInGammaSpace); // using Tint in sRGB+ gamma allows for more visually linear interpolation and to keep (0.5) at (128, gray in sRGB) point\n	vec3 invWavelength = 1.0 / pow(scatteringWavelength, vec3(4.0));\n\n	float krESun = RAYLEIGH * SUN_BRIGHTNESS;\n	float kr4PI = RAYLEIGH * 4.0 * 3.14159265;\n\n	vec3 cameraPos = vec3(0.0,innerRadius + cameraHeight,0.0); // The camera's current position\n\n	// Get the ray from the camera to the vertex and its length (which is the far point of the ray passing through the atmosphere)\n	vec3 eyeRay = normalize(a_Position.xyz);\n\n	float far = 0.0;\n	vec3 cIn, cOut;\n	if (eyeRay.y >= 0.0) {// Sky\n		// Calculate the length of the \"atmosphere\"\n		far = sqrt(outerRadius2 + innerRadius2 * eyeRay.y * eyeRay.y - innerRadius2) - innerRadius * eyeRay.y;\n\n		// Calculate the ray's starting position, then calculate its scattering offset\n		float height = innerRadius + cameraHeight;\n		float depth = exp(scaleOverScaleDepth * -cameraHeight);\n		float startAngle = dot(eyeRay, cameraPos) / height;\n		float startOffset = depth*scaleAngle(startAngle);\n\n		// Initialize the scattering loop variables\n		float sampleLength = far / samples;\n		float scaledLength = sampleLength * scale;\n		vec3 sampleRay = eyeRay * sampleLength;\n		vec3 samplePoint = cameraPos + sampleRay * 0.5;\n\n		vec3 frontColor = vec3(0.0);\n		//unrolling this manually to avoid some platform for loop slow\n		{\n			float height = length(samplePoint);\n			float depth = exp(scaleOverScaleDepth * (innerRadius - height));\n			float lightAngle = dot(-u_DirectionLight.Direction, samplePoint) / height;\n			float cameraAngle = dot(eyeRay, samplePoint) / height;\n			float scatter = (startOffset + depth*(scaleAngle(lightAngle) - scaleAngle(cameraAngle)));\n			vec3 attenuate = exp(-clamp(scatter, 0.0, MAX_SCATTER) * (invWavelength * kr4PI + km4PI));\n\n			frontColor += attenuate * (depth * scaledLength);\n			samplePoint += sampleRay;\n		}\n		{\n			float height = length(samplePoint);\n			float depth = exp(scaleOverScaleDepth * (innerRadius - height));\n			float lightAngle = dot(-u_DirectionLight.Direction, samplePoint) / height;\n			float cameraAngle = dot(eyeRay, samplePoint) / height;\n			float scatter = (startOffset + depth*(scaleAngle(lightAngle) - scaleAngle(cameraAngle)));\n			vec3 attenuate = exp(-clamp(scatter, 0.0, MAX_SCATTER) * (invWavelength * kr4PI + km4PI));\n\n			frontColor += attenuate * (depth * scaledLength);\n			samplePoint += sampleRay;\n		}\n\n		// Finally, scale the Mie and Rayleigh colors and set up the varying variables for the pixel shader\n		cIn = frontColor * (invWavelength * krESun);\n		cOut = frontColor * kmESun;\n	} else {// Ground\n		far = (-cameraHeight) / (min(-0.001, eyeRay.y));\n		vec3 pos = cameraPos + far * eyeRay;\n\n		// Calculate the ray's starting position, then calculate its scattering offset\n		float depth = exp((-cameraHeight) * (1.0/scaleDepth));\n		float cameraAngle = dot(-eyeRay, pos);\n		float lightAngle = dot(-u_DirectionLight.Direction, pos);\n		float cameraScale = scaleAngle(cameraAngle);\n		float lightScale = scaleAngle(lightAngle);\n		float cameraOffset = depth*cameraScale;\n		float temp = lightScale + cameraScale;\n\n		// Initialize the scattering loop variables\n		float sampleLength = far / samples;\n		float scaledLength = sampleLength * scale;\n		vec3 sampleRay = eyeRay * sampleLength;\n		vec3 samplePoint = cameraPos + sampleRay * 0.5;\n\n		// Now loop through the sample rays\n		vec3 frontColor = vec3(0.0, 0.0, 0.0);\n		vec3 attenuate;\n\n		// Loop removed because we kept hitting SM2.0 temp variable limits. Doesn't affect the image too much.\n		{\n			float height = length(samplePoint);\n			float depth = exp(scaleOverScaleDepth * (innerRadius - height));\n			float scatter = depth*temp - cameraOffset;\n			attenuate = exp(-clamp(scatter, 0.0, MAX_SCATTER) * (invWavelength * kr4PI + km4PI));\n			frontColor += attenuate * (depth * scaledLength);\n			samplePoint += sampleRay;\n		}\n\n		cIn = frontColor * (invWavelength * krESun + kmESun);\n		cOut = clamp(attenuate, 0.0, 1.0);\n	}\n\n	#ifdef SUN_HIGH_QUALITY\n		v_Vertex = -a_Position.xyz;\n	#elif defined(SUN_SIMPLE) \n		v_RayDir = -eyeRay;\n	#else\n		v_SkyGroundFactor = -eyeRay.y / SKY_GROUND_THRESHOLD;\n	#endif\n\n	// if we want to calculate color in vprog:\n	// in case of linear: multiply by _Exposure in here (even in case of lerp it will be common multiplier, so we can skip mul in fshader)\n	v_GroundColor = u_Exposure * (cIn + u_GroundTint*u_GroundTint * cOut);//u_GroundColor*u_GroundColor is gamma space convert to linear space\n	v_SkyColor    = u_Exposure * (cIn * getRayleighPhase(-u_DirectionLight.Direction, -eyeRay));\n\n	\n	// The sun should have a stable intensity in its course in the sky. Moreover it should match the highlight of a purely specular material.\n	// This matching was done using the Unity3D standard shader BRDF1 on the 5/31/2017\n	// Finally we want the sun to be always bright even in LDR thus the normalization of the lightColor for low intensity.\n	float lightColorIntensity = clamp(length(u_DirectionLight.Color), 0.25, 1.0);\n\n	#ifdef SUN_HIGH_QUALITY \n		v_SunColor = HDSundiskIntensityFactor * clamp(cOut,0.0,1.0) * u_DirectionLight.Color / lightColorIntensity;\n	#elif defined(SUN_SIMPLE) \n		v_SunColor = simpleSundiskIntensityFactor * clamp(cOut * sunScale,0.0,1.0) * u_DirectionLight.Color / lightColorIntensity;\n	#endif\n	gl_Position=remapGLPositionZ(gl_Position);\n}\n";
		ps="#ifdef HIGHPRECISION\n	precision highp float;\n#else\n	precision mediump float;\n#endif\n\n#include \"Lighting.glsl\";\n\nconst float MIE_G = -0.990;\nconst float MIE_G2 = 0.9801;\nconst float SKY_GROUND_THRESHOLD = 0.02;\n\nuniform float u_SunSize;\nuniform float u_SunSizeConvergence;\nuniform DirectionLight u_DirectionLight;\n\n\nvarying vec3 v_GroundColor;\nvarying vec3 v_SkyColor;\n\n\n#ifdef SUN_HIGH_QUALITY\n	varying vec3 v_Vertex;\n#elif defined(SUN_SIMPLE)\n	varying vec3 v_RayDir;\n#else\n	varying float v_SkyGroundFactor;\n#endif\n\n#if defined(SUN_HIGH_QUALITY)||defined(SUN_SIMPLE)\n	varying vec3 v_SunColor;\n#endif\n\n// Calculates the Mie phase function\nfloat getMiePhase(float eyeCos, float eyeCos2) {\n	float temp = 1.0 + MIE_G2 - 2.0 * MIE_G * eyeCos;\n	temp = pow(temp, pow(u_SunSize,0.65) * 10.0);\n	temp = max(temp,1.0e-4); // prevent division by zero, esp. in half precision\n	temp = 1.5 * ((1.0 - MIE_G2) / (2.0 + MIE_G2)) * (1.0 + eyeCos2) / temp;\n	return temp;\n}\n\n// Calculates the sun shape\nfloat calcSunAttenuation(vec3 lightPos, vec3 ray) {\n	#ifdef SUN_HIGH_QUALITY\n		float focusedEyeCos = pow(clamp(dot(lightPos, ray),0.0,1.0), u_SunSizeConvergence);\n		return getMiePhase(-focusedEyeCos, focusedEyeCos * focusedEyeCos);\n	#else //SUN_SIMPLE\n		vec3 delta = lightPos - ray;\n		float dist = length(delta);\n		float spot = 1.0 - smoothstep(0.0, u_SunSize, dist);\n		return spot * spot;\n	#endif\n}\n\nvoid main() {\n	// if y > 1 [eyeRay.y < -SKY_GROUND_THRESHOLD] - ground\n	// if y >= 0 and < 1 [eyeRay.y <= 0 and > -SKY_GROUND_THRESHOLD] - horizon\n	// if y < 0 [eyeRay.y > 0] - sky\n	vec3 col = vec3(0.0, 0.0, 0.0);\n\n	#ifdef SUN_HIGH_QUALITY\n		vec3 ray = normalize(v_Vertex);\n		float y = ray.y / SKY_GROUND_THRESHOLD;\n	#elif defined(SUN_SIMPLE) \n		vec3 ray = v_RayDir;\n		float y = ray.y / SKY_GROUND_THRESHOLD;	\n	#else\n		float y = v_SkyGroundFactor;\n	#endif\n\n	// if we did precalculate color in vprog: just do lerp between them\n	col = mix(v_SkyColor, v_GroundColor, clamp(y,0.0,1.0));\n\n	#if defined(SUN_HIGH_QUALITY)||defined(SUN_SIMPLE)\n		if (y < 0.0)\n			col += v_SunColor * calcSunAttenuation(-u_DirectionLight.Direction, -ray);\n	#endif\n\n	col = sqrt(col);//linear space convert to gamma space\n	gl_FragColor=vec4(col,1.0);\n}\n\n";
		shader=Shader3D.add("SkyBoxProcedural");
		subShader=new SubShader(attributeMap,uniformMap,null,SkyProceduralMaterial.shaderDefines);
		shader.addSubShader(subShader);
		subShader.addShaderPass(vs,ps);
		attributeMap={
			'a_Position':/*laya.d3.graphics.Vertex.VertexMesh.MESH_POSITION0*/0,
			'a_Normal':/*laya.d3.graphics.Vertex.VertexMesh.MESH_NORMAL0*/3,
			'a_Texcoord0':/*laya.d3.graphics.Vertex.VertexMesh.MESH_TEXTURECOORDINATE0*/2
		};
		uniformMap={
			'u_MvpMatrix':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_WorldMat':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_CameraPos':/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3,
			'u_LightmapScaleOffset':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_LightMap':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_SplatAlphaTexture':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_DiffuseTexture1':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_DiffuseTexture2':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_DiffuseTexture3':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_DiffuseTexture4':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_DiffuseTexture5':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_DiffuseScaleOffset1':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_DiffuseScaleOffset2':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_DiffuseScaleOffset3':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_DiffuseScaleOffset4':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_DiffuseScaleOffset5':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_FogStart':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_FogRange':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_FogColor':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_DirectionLight.Direction':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_DirectionLight.Color':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_PointLight.Position':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_PointLight.Range':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_PointLight.Attenuation':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_PointLight.Color':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_SpotLight.Position':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_SpotLight.Direction':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_SpotLight.Range':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_SpotLight.Spot':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_SpotLight.Color':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_AmbientColor':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_shadowMap1':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_shadowMap2':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_shadowMap3':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_shadowPSSMDistance':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_lightShadowVP':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_shadowPCFoffset':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4
		};
		stateMap={
			's_Cull':/*laya.d3.shader.Shader3D.RENDER_STATE_CULL*/0,
			's_Blend':/*laya.d3.shader.Shader3D.RENDER_STATE_BLEND*/1,
			's_BlendSrc':/*laya.d3.shader.Shader3D.RENDER_STATE_BLEND_SRC*/2,
			's_BlendDst':/*laya.d3.shader.Shader3D.RENDER_STATE_BLEND_DST*/3,
			's_DepthTest':/*laya.d3.shader.Shader3D.RENDER_STATE_DEPTH_TEST*/12,
			's_DepthWrite':/*laya.d3.shader.Shader3D.RENDER_STATE_DEPTH_WRITE*/13
		};
		vs="#include \"Lighting.glsl\";\n\nattribute vec4 a_Position;\nattribute vec2 a_Texcoord0;\n\nuniform mat4 u_MvpMatrix;\n\nvarying vec2 v_Texcoord0;\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(LIGHTMAP)\n	attribute vec3 a_Normal;\n	varying vec3 v_Normal;\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(FOG)||(defined(RECEIVESHADOW)&&defined(SHADOWMAP_PSSM1))\n	uniform mat4 u_WorldMat;\n	varying vec3 v_PositionWorld;\n#endif\n\n#ifdef LIGHTMAP\n	varying vec2 v_LightMapUV;\n	uniform vec4 u_LightmapScaleOffset;\n#endif\n\n#ifdef RECEIVESHADOW\n	varying float v_posViewZ;\n	#ifdef SHADOWMAP_PSSM1 \n		varying vec4 v_lightMVPPos;\n		uniform mat4 u_lightShadowVP[4];\n	#endif\n#endif\n\nvoid main()\n{\n	gl_Position = u_MvpMatrix * a_Position;\n  \n	v_Texcoord0 = a_Texcoord0;\n  \n	#ifdef LIGHTMAP\n		v_LightMapUV = vec2(a_Texcoord0.x, 1.0 - a_Texcoord0.y) * u_LightmapScaleOffset.xy + u_LightmapScaleOffset.zw;\n		v_LightMapUV.y = 1.0 - v_LightMapUV.y;\n	#endif\n  \n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n		v_Normal = a_Normal;\n	#endif\n\n	#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(FOG)||(defined(RECEIVESHADOW)&&defined(SHADOWMAP_PSSM1))\n		v_PositionWorld=(u_WorldMat*a_Position).xyz;\n	#endif\n\n	#ifdef RECEIVESHADOW\n		v_posViewZ = gl_Position.w;\n		#ifdef SHADOWMAP_PSSM1\n			v_lightMVPPos = u_lightShadowVP[0] * vec4(v_PositionWorld,1.0);\n		#endif\n	#endif\n	gl_Position=remapGLPositionZ(gl_Position);\n}";
		ps="#ifdef HIGHPRECISION\n	precision highp float;\n#else\n	precision mediump float;\n#endif\n\n#include \"Lighting.glsl\";\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(FOG)\n	uniform vec3 u_CameraPos;\n	varying vec3 v_Normal;\n	varying vec3 v_PositionWorld;\n#endif\n\n#ifdef FOG\n	uniform float u_FogStart;\n	uniform float u_FogRange;\n	uniform vec3 u_FogColor;\n#endif\n\n\n#ifdef DIRECTIONLIGHT\n	uniform DirectionLight u_DirectionLight;\n#endif\n\n#ifdef POINTLIGHT\n	uniform PointLight u_PointLight;\n#endif\n\n#ifdef SPOTLIGHT\n	uniform SpotLight u_SpotLight;\n#endif\n\n#include \"ShadowHelper.glsl\"\n#ifdef RECEIVESHADOW\n	#if defined(SHADOWMAP_PSSM2)||defined(SHADOWMAP_PSSM3)\n	uniform mat4 u_lightShadowVP[4];\n	#endif\n	#ifdef SHADOWMAP_PSSM1 \n	varying vec4 v_lightMVPPos;\n	#endif\n#endif\nvarying float v_posViewZ;\n\nuniform vec3 u_AmbientColor;\n\nuniform sampler2D u_SplatAlphaTexture;\n\nuniform sampler2D u_DiffuseTexture1;\nuniform sampler2D u_DiffuseTexture2;\nuniform sampler2D u_DiffuseTexture3;\nuniform sampler2D u_DiffuseTexture4;\nuniform sampler2D u_DiffuseTexture5;\n\nuniform vec4 u_DiffuseScaleOffset1;\nuniform vec4 u_DiffuseScaleOffset2;\nuniform vec4 u_DiffuseScaleOffset3;\nuniform vec4 u_DiffuseScaleOffset4;\nuniform vec4 u_DiffuseScaleOffset5;\n\nvarying vec2 v_Texcoord0;\n\n#ifdef LIGHTMAP\n	uniform sampler2D u_LightMap;\n	varying vec2 v_LightMapUV;\n#endif\n\nvoid main()\n{\n	vec4 splatAlpha = vec4(1.0);\n	#ifdef ExtendTerrain_DETAIL_NUM1\n		splatAlpha = texture2D(u_SplatAlphaTexture, v_Texcoord0);\n		vec4 color1 = texture2D(u_DiffuseTexture1, v_Texcoord0 * u_DiffuseScaleOffset1.xy);\n		gl_FragColor.xyz = color1.xyz * splatAlpha.r;\n	#endif\n	#ifdef ExtendTerrain_DETAIL_NUM2\n		splatAlpha = texture2D(u_SplatAlphaTexture, v_Texcoord0);\n		vec4 color1 = texture2D(u_DiffuseTexture1, v_Texcoord0 * u_DiffuseScaleOffset1.xy);\n		vec4 color2 = texture2D(u_DiffuseTexture2, v_Texcoord0 * u_DiffuseScaleOffset2.xy);\n		gl_FragColor.xyz = color1.xyz * splatAlpha.r + color2.xyz * (1.0 - splatAlpha.r);\n	#endif\n	#ifdef ExtendTerrain_DETAIL_NUM3\n		splatAlpha = texture2D(u_SplatAlphaTexture, v_Texcoord0);\n		vec4 color1 = texture2D(u_DiffuseTexture1, v_Texcoord0 * u_DiffuseScaleOffset1.xy);\n		vec4 color2 = texture2D(u_DiffuseTexture2, v_Texcoord0 * u_DiffuseScaleOffset2.xy);\n		vec4 color3 = texture2D(u_DiffuseTexture3, v_Texcoord0 * u_DiffuseScaleOffset3.xy);\n		gl_FragColor.xyz = color1.xyz * splatAlpha.r  + color2.xyz * splatAlpha.g + color3.xyz * (1.0 - splatAlpha.r - splatAlpha.g);\n	#endif\n	#ifdef ExtendTerrain_DETAIL_NUM4\n		splatAlpha = texture2D(u_SplatAlphaTexture, v_Texcoord0);\n		vec4 color1 = texture2D(u_DiffuseTexture1, v_Texcoord0 * u_DiffuseScaleOffset1.xy);\n		vec4 color2 = texture2D(u_DiffuseTexture2, v_Texcoord0 * u_DiffuseScaleOffset2.xy);\n		vec4 color3 = texture2D(u_DiffuseTexture3, v_Texcoord0 * u_DiffuseScaleOffset3.xy);\n		vec4 color4 = texture2D(u_DiffuseTexture4, v_Texcoord0 * u_DiffuseScaleOffset4.xy);\n		gl_FragColor.xyz = color1.xyz * splatAlpha.r  + color2.xyz * splatAlpha.g + color3.xyz * splatAlpha.b + color4.xyz * (1.0 - splatAlpha.r - splatAlpha.g - splatAlpha.b);\n	#endif\n	#ifdef ExtendTerrain_DETAIL_NUM5\n		splatAlpha = texture2D(u_SplatAlphaTexture, v_Texcoord0);\n		vec4 color1 = texture2D(u_DiffuseTexture1, v_Texcoord0 * u_DiffuseScaleOffset1.xy);\n		vec4 color2 = texture2D(u_DiffuseTexture2, v_Texcoord0 * u_DiffuseScaleOffset2.xy);\n		vec4 color3 = texture2D(u_DiffuseTexture3, v_Texcoord0 * u_DiffuseScaleOffset3.xy);\n		vec4 color4 = texture2D(u_DiffuseTexture4, v_Texcoord0 * u_DiffuseScaleOffset4.xy);\n		vec4 color5 = texture2D(u_DiffuseTexture5, v_Texcoord0 * u_DiffuseScaleOffset5.xy);\n		gl_FragColor.xyz = color1.xyz * splatAlpha.r  + color2.xyz * splatAlpha.g + color3.xyz * splatAlpha.b + color4.xyz * splatAlpha.a + color5.xyz * (1.0 - splatAlpha.r - splatAlpha.g - splatAlpha.b - splatAlpha.a);\n	#endif\n		gl_FragColor.w = splatAlpha.a;\n		\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n    vec3 normal = v_Normal;\n	vec3 dif, spe;\n#endif\n\nvec3 diffuse = vec3(0.0);\nvec3 specular= vec3(0.0);\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)||defined(FOG)\n	vec3 toEye;\n	#ifdef FOG\n		toEye=u_CameraPos-v_PositionWorld;\n		float toEyeLength=length(toEye);\n		toEye/=toEyeLength;\n	#else\n		toEye=normalize(u_CameraPos-v_PositionWorld);\n	#endif\n#endif\n\n#ifdef DIRECTIONLIGHT\n	LayaAirBlinnPhongDiectionLight(vec3(0.0), 1.0, normal, vec3(1.0), toEye,u_DirectionLight, dif, spe);\n	diffuse+=dif;\n	specular+=spe;\n#endif\n \n#ifdef POINTLIGHT\n	LayaAirBlinnPhongPointLight(v_PositionWorld, vec3(0.0), 1.0, normal, vec3(1.0), toEye, u_PointLight, dif, spe);\n	diffuse+=dif;\n	specular+=spe;\n#endif\n\n#ifdef SPOTLIGHT\n	LayaAirBlinnPhongSpotLight(v_PositionWorld, vec3(0.0), 1.0, normal, vec3(1.0), toEye, u_SpotLight, dif, spe);\n	diffuse+=dif;\n	specular+=spe;\n#endif\n\nvec3 globalDiffuse = u_AmbientColor;\n#ifdef LIGHTMAP\n	globalDiffuse += DecodeLightmap(texture2D(u_LightMap, v_LightMapUV));\n#endif\n\n#ifdef RECEIVESHADOW\n	float shadowValue = 1.0;\n	#ifdef SHADOWMAP_PSSM3\n		shadowValue = getShadowPSSM3( u_shadowMap1,u_shadowMap2,u_shadowMap3,u_lightShadowVP,u_shadowPSSMDistance,u_shadowPCFoffset,v_PositionWorld,v_posViewZ,0.001);\n	#endif\n	#ifdef SHADOWMAP_PSSM2\n		shadowValue = getShadowPSSM2( u_shadowMap1,u_shadowMap2,u_lightShadowVP,u_shadowPSSMDistance,u_shadowPCFoffset,v_PositionWorld,v_posViewZ,0.001);\n	#endif \n	#ifdef SHADOWMAP_PSSM1\n		shadowValue = getShadowPSSM1( u_shadowMap1,v_lightMVPPos,u_shadowPSSMDistance,u_shadowPCFoffset,v_posViewZ,0.001);\n	#endif\n	gl_FragColor = vec4(gl_FragColor.rgb * (globalDiffuse + diffuse) * shadowValue, gl_FragColor.a);\n#else\n	gl_FragColor = vec4(gl_FragColor.rgb * (globalDiffuse + diffuse), gl_FragColor.a);\n#endif\n\n#if defined(DIRECTIONLIGHT)||defined(POINTLIGHT)||defined(SPOTLIGHT)\n	#ifdef RECEIVESHADOW\n		gl_FragColor.rgb += specular * shadowValue;\n	#else\n		gl_FragColor.rgb += specular;\n	#endif\n#endif\n\n#ifdef FOG\n	float lerpFact=clamp((toEyeLength-u_FogStart)/u_FogRange,0.0,1.0);\n	gl_FragColor.rgb=mix(gl_FragColor.rgb,u_FogColor,lerpFact);\n#endif\n}\n\n\n\n\n\n";
		shader=Shader3D.add("ExtendTerrain");
		subShader=new SubShader(attributeMap,uniformMap,RenderableSprite3D.shaderDefines,ExtendTerrainMaterial.shaderDefines);
		shader.addSubShader(subShader);
		subShader.addShaderPass(vs,ps,stateMap);
		attributeMap={
			'a_Position' :/*laya.d3.core.trail.VertexTrail.TRAIL_POSITION0*/0,
			'a_OffsetVector':/*laya.d3.core.trail.VertexTrail.TRAIL_OFFSETVECTOR*/1,
			'a_Texcoord0X' :/*laya.d3.core.trail.VertexTrail.TRAIL_TEXTURECOORDINATE0X*/4,
			'a_Texcoord0Y' :/*laya.d3.core.trail.VertexTrail.TRAIL_TEXTURECOORDINATE0Y*/3,
			'a_BirthTime' :/*laya.d3.core.trail.VertexTrail.TRAIL_TIME0*/2
		};
		uniformMap={
			'u_MvpMatrix':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_View':/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3,
			'u_Projection':/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3,
			'u_TilingOffset':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_MainTexture':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_MainColor':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_CurTime' :/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_LifeTime' :/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_WidthCurve' :/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_WidthCurveKeyLength' :/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_GradientColorkey' :/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_GradientAlphakey' :/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2
		};
		stateMap={
			's_Cull':/*laya.d3.shader.Shader3D.RENDER_STATE_CULL*/0,
			's_Blend':/*laya.d3.shader.Shader3D.RENDER_STATE_BLEND*/1,
			's_BlendSrc':/*laya.d3.shader.Shader3D.RENDER_STATE_BLEND_SRC*/2,
			's_BlendDst':/*laya.d3.shader.Shader3D.RENDER_STATE_BLEND_DST*/3,
			's_DepthTest':/*laya.d3.shader.Shader3D.RENDER_STATE_DEPTH_TEST*/12,
			's_DepthWrite':/*laya.d3.shader.Shader3D.RENDER_STATE_DEPTH_WRITE*/13
		};
		vs="#include \"Lighting.glsl\";\n\nattribute vec3 a_Position;\nattribute vec3 a_OffsetVector;\nattribute vec4 a_Color;\nattribute float a_Texcoord0X;\nattribute float a_Texcoord0Y;\nattribute float a_BirthTime;\n\nuniform mat4 u_View;\nuniform mat4 u_Projection;\n\nuniform vec4 u_TilingOffset;\n\nuniform float u_CurTime;\nuniform float u_LifeTime;\nuniform vec4 u_WidthCurve[10];\nuniform int u_WidthCurveKeyLength;\n\nuniform vec4 u_GradientColorkey[10];\nuniform vec2 u_GradientAlphakey[10];\n\nvarying vec2 v_Texcoord0;\nvarying vec4 v_Color;\n\nfloat hermiteInterpolate(float t, float outTangent, float inTangent, float duration, float value1, float value2)\n{\n	float t2 = t * t;\n	float t3 = t2 * t;\n	float a = 2.0 * t3 - 3.0 * t2 + 1.0;\n	float b = t3 - 2.0 * t2 + t;\n	float c = t3 - t2;\n	float d = -2.0 * t3 + 3.0 * t2;\n	return a * value1 + b * outTangent * duration + c * inTangent * duration + d * value2;\n}\n\nfloat getCurWidth(in float normalizeTime)\n{\n	float width;\n	if(normalizeTime == 0.0){\n		width=u_WidthCurve[0].w;\n	}\n	else if(normalizeTime >= 1.0){\n		width=u_WidthCurve[u_WidthCurveKeyLength - 1].w;\n	}\n	else{\n		for(int i = 0; i < 10; i ++ )\n		{\n			if(normalizeTime == u_WidthCurve[i].x){\n				width=u_WidthCurve[i].w;\n				break;\n			}\n			\n			vec4 lastFrame = u_WidthCurve[i];\n			vec4 nextFrame = u_WidthCurve[i + 1];\n			if(normalizeTime > lastFrame.x && normalizeTime < nextFrame.x)\n			{\n				float duration = nextFrame.x - lastFrame.x;\n				float t = (normalizeTime - lastFrame.x) / duration;\n				float outTangent = lastFrame.z;\n				float inTangent = nextFrame.y;\n				float value1 = lastFrame.w;\n				float value2 = nextFrame.w;\n				width=hermiteInterpolate(t, outTangent, inTangent, duration, value1, value2);\n				break;\n			}\n		}\n	}\n	return width;\n}	\n\nvec4 getColorFromGradientByBlend(in vec4 gradientColors[10], in vec2 gradientAlphas[10], in float normalizeTime)\n{\n	vec4 color;\n	for(int i = 1; i < 10; i++)\n	{\n		vec4 gradientColor = gradientColors[i];\n		float colorKey = gradientColor.x;\n		if(colorKey >= normalizeTime)\n		{\n			vec4 lastGradientColor = gradientColors[i-1];\n			float lastColorKey = lastGradientColor.x;\n			float age = (normalizeTime - lastColorKey) / (colorKey - lastColorKey);\n			color.rgb = mix(gradientColors[i-1].yzw, gradientColor.yzw, age);\n			break;\n		}\n	}\n	for(int i = 1; i < 10; i++)\n	{\n		vec2 gradientAlpha = gradientAlphas[i];\n		float alphaKey = gradientAlpha.x;\n		if(alphaKey >= normalizeTime)\n		{\n			vec2 lastGradientAlpha = gradientAlphas[i-1];\n			float lastAlphaKey = lastGradientAlpha.x;\n			float age = (normalizeTime - lastAlphaKey) / (alphaKey - lastAlphaKey);\n			color.a = mix(lastGradientAlpha.y, gradientAlpha.y, age);\n			break;\n		}\n	}\n	return color;\n}\n\nvec4 getColorFromGradientByFixed(in vec4 gradientColors[10], in vec2 gradientAlphas[10], in float normalizeTime)\n{\n	vec4 color;\n	for(int i = 1; i < 10; i++)\n	{\n		vec4 gradientColor = gradientColors[i];\n		if(gradientColor.w >= normalizeTime)\n		{\n			color.rgb = gradientColor.xyz;\n			break;\n		}\n	}\n	for(int i = 1; i < 10; i++)\n	{\n		vec2 gradientAlpha = gradientAlphas[i];\n		if(gradientAlpha.y >= normalizeTime)\n		{\n			color.a = gradientAlpha.x;\n			break;\n		}\n	}\n	return color;\n}\n\nvoid main()\n{\n	float normalizeTime = (u_CurTime - a_BirthTime) / u_LifeTime;\n	\n	#ifdef TILINGOFFSET\n		v_Texcoord0 = vec2(a_Texcoord0X, 1.0 - a_Texcoord0Y) * u_TilingOffset.xy + u_TilingOffset.zw;\n	#else\n		v_Texcoord0 = vec2(a_Texcoord0X, a_Texcoord0Y);\n	#endif\n	\n	#ifdef GRADIENTMODE_BLEND\n		v_Color = getColorFromGradientByBlend(u_GradientColorkey, u_GradientAlphakey, normalizeTime);\n	#else\n		v_Color = getColorFromGradientByFixed(u_GradientColorkey, u_GradientAlphakey, normalizeTime);\n	#endif\n	\n	gl_Position = u_Projection * u_View * vec4(a_Position + a_OffsetVector * getCurWidth(normalizeTime),1.0);\n	gl_Position=remapGLPositionZ(gl_Position);\n}\n";
		ps="#ifdef HIGHPRECISION\n	precision highp float;\n#else\n	precision mediump float;\n#endif\n\nuniform sampler2D u_MainTexture;\nuniform vec4 u_MainColor;\n\nvarying vec2 v_Texcoord0;\nvarying vec4 v_Color;\n\nvoid main()\n{	\n	vec4 color = 2.0 * u_MainColor * v_Color;\n	#ifdef MAINTEXTURE\n		vec4 mainTextureColor = texture2D(u_MainTexture, v_Texcoord0);\n		color *= mainTextureColor;\n	#endif\n	gl_FragColor = color;\n}\n\n";
		shader=Shader3D.add("Trail");
		subShader=new SubShader(attributeMap,uniformMap,TrailSprite3D.shaderDefines,TrailMaterial.shaderDefines);
		shader.addSubShader(subShader);
		subShader.addShaderPass(vs,ps,stateMap);
		attributeMap={
			'a_Position':/*laya.d3.graphics.Vertex.VertexMesh.MESH_POSITION0*/0,
			'a_Normal':/*laya.d3.graphics.Vertex.VertexMesh.MESH_NORMAL0*/3,
			'a_Tangent0':/*laya.d3.graphics.Vertex.VertexMesh.MESH_TANGENT0*/4
		};
		uniformMap={
			'u_MvpMatrix':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_WorldMat':/*laya.d3.shader.Shader3D.PERIOD_SPRITE*/2,
			'u_CameraPos':/*laya.d3.shader.Shader3D.PERIOD_CAMERA*/3,
			'u_Time':/*laya.d3.shader.Shader3D.PERIOD_SCENE*/4,
			'u_MainTexture':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_NormalTexture':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_HorizonColor':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_WaveScale' :/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_WaveSpeed' :/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1
		};
		vs="#include \"Lighting.glsl\";\n\nattribute vec4 a_Position;\nattribute vec3 a_Normal;\nattribute vec4 a_Tangent0;\n\nuniform mat4 u_MvpMatrix;\nuniform mat4 u_WorldMat;\nuniform vec3 u_CameraPos;\nuniform float u_WaveScale;\nuniform vec4 u_WaveSpeed;\nuniform float u_Time;\n\nvarying vec3 v_Normal;\nvarying vec3 v_Tangent;\nvarying vec3 v_Binormal;\nvarying vec3 v_ViewDir;\nvarying vec2 v_Texcoord0;\nvarying vec2 v_Texcoord1;\n\nvoid main()\n{\n	vec4 positionWorld = u_WorldMat * a_Position;\n	vec4 position = u_MvpMatrix * a_Position;\n	\n	vec4 temp = vec4(positionWorld.x, positionWorld.z, positionWorld.x, positionWorld.z) * u_WaveScale + u_WaveSpeed * u_WaveScale * u_Time;\n	\n	v_Texcoord0 = temp.xy * vec2(0.4, 0.45);\n	v_Texcoord1 = temp.wz;\n	\n	mat3 worldMat = mat3(u_WorldMat);\n	v_Normal = worldMat * a_Normal;\n	v_Tangent = worldMat * a_Tangent0.xyz;\n	v_Binormal = cross(v_Normal, v_Tangent) * a_Tangent0.w;\n	\n	v_ViewDir = u_CameraPos - positionWorld.xyz;\n	gl_Position = position;\n	gl_Position=remapGLPositionZ(gl_Position);\n}";
		ps="#ifdef FSHIGHPRECISION\n	precision highp float;\n#else\n	precision mediump float;\n#endif\n\n#ifdef MAINTEXTURE\n	uniform sampler2D u_MainTexture;\n#endif\n\n#ifdef NORMALTEXTURE\n	uniform sampler2D u_NormalTexture;\n#endif\n\nuniform vec4 u_HorizonColor;\n\nvarying vec3 v_Normal;\nvarying vec3 v_Tangent;\nvarying vec3 v_Binormal;\nvarying vec3 v_ViewDir;\nvarying vec2 v_Texcoord0;\nvarying vec2 v_Texcoord1;\n\n#include \"Lighting.glsl\"\n\nvoid main()\n{\n	vec4 bumpColor1 = texture2D(u_NormalTexture, v_Texcoord0);\n	vec4 bumpColor2 = texture2D(u_NormalTexture, v_Texcoord1);\n	\n	vec3 normal1 = NormalSampleToWorldSpace1(bumpColor1, v_Tangent, v_Binormal, v_Normal);\n	vec3 normal2 = NormalSampleToWorldSpace1(bumpColor2, v_Tangent, v_Binormal, v_Normal);\n	\n	vec3 normal = normalize((normal1 + normal2) * 0.5);\n	vec3 viewDir = normalize(v_ViewDir);\n	float fresnel = dot(viewDir, normal);\n	\n	vec4 waterColor = texture2D(u_MainTexture, vec2(fresnel, fresnel));\n	\n	vec4 color;\n	color.rgb = mix(waterColor.rgb, u_HorizonColor.rgb, vec3(waterColor.a));\n	color.a = u_HorizonColor.a;\n	\n	gl_FragColor = color;\n}\n\n";
		shader=Shader3D.add("WaterPrimary");
		subShader=new SubShader(attributeMap,uniformMap,null,WaterPrimaryMaterial.shaderDefines);
		shader.addSubShader(subShader);
		subShader.addShaderPass(vs,ps);
		attributeMap={
			'a_PositionTexcoord':/*laya.d3.graphics.Vertex.VertexMesh.MESH_POSITION0*/0
		};
		uniformMap={
			'u_ScreenTexture':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1
		};
		vs="#include \"Lighting.glsl\";\n\nattribute vec4 a_PositionTexcoord;\nvarying vec2 v_Texcoord0;\n\nvoid main() {\n	gl_Position = vec4(a_PositionTexcoord.xy, 0.0, 1.0);\n	v_Texcoord0 = a_PositionTexcoord.zw;\n	gl_Position = remapGLPositionZ(gl_Position);\n}";
		ps="#ifdef FSHIGHPRECISION\n	precision highp float;\n#else\n	precision mediump float;\n#endif\n\nuniform sampler2D u_ScreenTexture;\nvarying vec2 v_Texcoord0;\n\nvoid main() {\n	gl_FragColor = texture2D(u_ScreenTexture, v_Texcoord0);\n}\n\n";
		shader=Shader3D.add("ScreenQuad");
		subShader=new SubShader(attributeMap,uniformMap,null,null);
		shader.addSubShader(subShader);
		var shaderPass=subShader.addShaderPass(vs,ps);
		var renderState=shaderPass.renderState;
		renderState.depthTest=/*laya.d3.core.material.RenderState.DEPTHTEST_ALWAYS*/0x0207;
		renderState.depthWrite=false;
		renderState.cull=/*laya.d3.core.material.RenderState.CULL_NONE*/0;
		renderState.blend=/*laya.d3.core.material.RenderState.BLEND_DISABLE*/0;
		attributeMap={
			'a_PositionTexcoord':/*laya.d3.graphics.Vertex.VertexMesh.MESH_POSITION0*/0
		};
		uniformMap={
			'u_MainTex':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_BloomTex':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_AutoExposureTex':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_MainTex_TexelSize':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_SampleScale':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_Threshold':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_Params' :/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1
		};
		shader=Shader3D.add("PostProcessBloom",attributeMap,uniformMap);
		subShader=new SubShader(null,null,null,null);
		shader.addSubShader(subShader);
		shaderPass=subShader.addShaderPass("#include \"Lighting.glsl\";\n\nattribute vec4 a_PositionTexcoord;\nvarying vec2 v_Texcoord0;\n\nvoid main() {\n	gl_Position = vec4(a_PositionTexcoord.xy, 0.0, 1.0);\n	v_Texcoord0 = a_PositionTexcoord.zw;\n	gl_Position = remapGLPositionZ(gl_Position);\n}","#ifdef HIGHPRECISION\n	precision highp float;\n#else\n	precision mediump float;\n#endif\n\n#include \"Colors.glsl\";\n#include \"Sampling.glsl\";\n\nvarying vec2 v_Texcoord0;\n\nuniform sampler2D u_MainTex;\nuniform sampler2D u_AutoExposureTex;\nuniform vec4 u_MainTex_TexelSize;\nuniform vec4 u_Threshold; // x: threshold value (linear), y: threshold - knee, z: knee * 2, w: 0.25 / knee\nuniform vec4 u_Params; // x: clamp, yzw: unused\n\nmediump vec4 prefilter(mediump vec4 color, vec2 uv) {\n	mediump float autoExposure = texture2D(u_AutoExposureTex, uv).r;\n	color *= autoExposure;\n	color = min(vec4(u_Params.x), color); // clamp to max\n	color = quadraticThreshold(color, u_Threshold.x, u_Threshold.yzw);\n	return color;\n}\n\nvoid fragPrefilter13() {\n	mediump vec4 color = downsampleBox13Tap(u_MainTex, v_Texcoord0, u_MainTex_TexelSize.xy);\n	gl_FragColor = prefilter(safeHDR(color), v_Texcoord0);\n}\n\nvoid main() {\n	fragPrefilter13();\n}");
		renderState=shaderPass.renderState;
		renderState.depthTest=/*laya.d3.core.material.RenderState.DEPTHTEST_ALWAYS*/0x0207;
		renderState.depthWrite=false;
		renderState.cull=/*laya.d3.core.material.RenderState.CULL_NONE*/0;
		renderState.blend=/*laya.d3.core.material.RenderState.BLEND_DISABLE*/0;
		subShader=new SubShader(null,null,null,null);
		shader.addSubShader(subShader);
		shaderPass=subShader.addShaderPass("#include \"Lighting.glsl\";\n\nattribute vec4 a_PositionTexcoord;\nvarying vec2 v_Texcoord0;\n\nvoid main() {\n	gl_Position = vec4(a_PositionTexcoord.xy, 0.0, 1.0);\n	v_Texcoord0 = a_PositionTexcoord.zw;\n	gl_Position = remapGLPositionZ(gl_Position);\n}","#ifdef HIGHPRECISION\n	precision highp float;\n#else\n	precision mediump float;\n#endif\n\n#include \"Colors.glsl\";\n#include \"Sampling.glsl\";\n\nvarying vec2 v_Texcoord0;\n\nuniform sampler2D u_MainTex;\nuniform sampler2D u_AutoExposureTex;\nuniform vec4 u_MainTex_TexelSize;\nuniform vec4 u_Threshold; // x: threshold value (linear), y: threshold - knee, z: knee * 2, w: 0.25 / knee\nuniform vec4 u_Params; // x: clamp, yzw: unused\n\nmediump vec4 prefilter(mediump vec4 color, vec2 uv) {\n	mediump float autoExposure = texture2D(u_AutoExposureTex, uv).r;\n	color *= autoExposure;\n	color = min(vec4(u_Params.x), color); // clamp to max\n	color = quadraticThreshold(color, u_Threshold.x, u_Threshold.yzw);\n	return color;\n}\n\nvoid fragPrefilter4() {\n	mediump vec4 color = downsampleBox4Tap(u_MainTex, v_Texcoord0, u_MainTex_TexelSize.xy);\n	gl_FragColor = prefilter(safeHDR(color), v_Texcoord0);\n}\n\nvoid main() {\n	fragPrefilter4();\n}");
		renderState=shaderPass.renderState;
		renderState.depthTest=/*laya.d3.core.material.RenderState.DEPTHTEST_ALWAYS*/0x0207;
		renderState.depthWrite=false;
		renderState.cull=/*laya.d3.core.material.RenderState.CULL_NONE*/0;
		renderState.blend=/*laya.d3.core.material.RenderState.BLEND_DISABLE*/0;
		subShader=new SubShader(null,null,null,null);
		shader.addSubShader(subShader);
		shaderPass=subShader.addShaderPass("#include \"Lighting.glsl\";\n\nattribute vec4 a_PositionTexcoord;\nvarying vec2 v_Texcoord0;\n\nvoid main() {\n	gl_Position = vec4(a_PositionTexcoord.xy, 0.0, 1.0);\n	v_Texcoord0 = a_PositionTexcoord.zw;\n	gl_Position = remapGLPositionZ(gl_Position);\n}","#ifdef HIGHPRECISION\n	precision highp float;\n#else\n	precision mediump float;\n#endif\n\n#include \"Colors.glsl\";\n#include \"Sampling.glsl\";\n\nvarying vec2 v_Texcoord0;\n\nuniform sampler2D u_MainTex;\nuniform vec4 u_MainTex_TexelSize;\n\nvoid fragDownsample13() {\n	mediump vec4 color = downsampleBox13Tap(u_MainTex, v_Texcoord0, u_MainTex_TexelSize.xy);\n	gl_FragColor = color;\n}\n\nvoid main() {\n	fragDownsample13();\n}");
		renderState=shaderPass.renderState;
		renderState.depthTest=/*laya.d3.core.material.RenderState.DEPTHTEST_ALWAYS*/0x0207;
		renderState.depthWrite=false;
		renderState.cull=/*laya.d3.core.material.RenderState.CULL_NONE*/0;
		renderState.blend=/*laya.d3.core.material.RenderState.BLEND_DISABLE*/0;
		subShader=new SubShader(null,null,null,null);
		shader.addSubShader(subShader);
		shaderPass=subShader.addShaderPass("#include \"Lighting.glsl\";\n\nattribute vec4 a_PositionTexcoord;\nvarying vec2 v_Texcoord0;\n\nvoid main() {\n	gl_Position = vec4(a_PositionTexcoord.xy, 0.0, 1.0);\n	v_Texcoord0 = a_PositionTexcoord.zw;\n	gl_Position = remapGLPositionZ(gl_Position);\n}","#ifdef HIGHPRECISION\n	precision highp float;\n#else\n	precision mediump float;\n#endif\n\n#include \"Colors.glsl\";\n#include \"Sampling.glsl\";\n\nvarying vec2 v_Texcoord0;\n\nuniform sampler2D u_MainTex;\nuniform sampler2D u_BloomTex;\n\nuniform vec4 u_MainTex_TexelSize;\nuniform float u_SampleScale;\n\nmediump vec4 combine(mediump vec4 bloom, vec2 uv) {\n	mediump vec4 color = texture2D(u_BloomTex, uv);\n	return bloom + color;\n}\n\nvoid fragUpsampleTent() {\n	mediump vec4 bloom = UpsampleTent(u_MainTex, v_Texcoord0, u_MainTex_TexelSize.xy, u_SampleScale);\n	gl_FragColor = combine(bloom, v_Texcoord0);\n}\n\nvoid main() {\n	fragUpsampleTent();\n}");
		renderState=shaderPass.renderState;
		renderState.depthTest=/*laya.d3.core.material.RenderState.DEPTHTEST_ALWAYS*/0x0207;
		renderState.depthWrite=false;
		renderState.cull=/*laya.d3.core.material.RenderState.CULL_NONE*/0;
		renderState.blend=/*laya.d3.core.material.RenderState.BLEND_DISABLE*/0;
		subShader=new SubShader(null,null,null,null);
		shader.addSubShader(subShader);
		shaderPass=subShader.addShaderPass("#include \"Lighting.glsl\";\n\nattribute vec4 a_PositionTexcoord;\nvarying vec2 v_Texcoord0;\n\nvoid main() {\n	gl_Position = vec4(a_PositionTexcoord.xy, 0.0, 1.0);\n	v_Texcoord0 = a_PositionTexcoord.zw;\n	gl_Position = remapGLPositionZ(gl_Position);\n}","#ifdef HIGHPRECISION\n	precision highp float;\n#else\n	precision mediump float;\n#endif\n\n#include \"Colors.glsl\";\n#include \"Sampling.glsl\";\n\nvarying vec2 v_Texcoord0;\n\nuniform sampler2D u_MainTex;\nuniform sampler2D u_BloomTex;\n\nuniform vec4 u_MainTex_TexelSize;\nuniform float u_SampleScale;\n\nmediump vec4 combine(mediump vec4 bloom, vec2 uv) {\n	mediump vec4 color = texture2D(u_BloomTex, uv);\n	return bloom + color;\n}\n\nvoid fragUpsampleBox() {\n	mediump vec4 bloom = upsampleBox(u_MainTex, v_Texcoord0, u_MainTex_TexelSize.xy, vec4(u_SampleScale));\n	gl_FragColor = combine(bloom, v_Texcoord0);\n}\n\nvoid main() {\n	fragUpsampleBox();\n}");
		renderState=shaderPass.renderState;
		renderState.depthTest=/*laya.d3.core.material.RenderState.DEPTHTEST_ALWAYS*/0x0207;
		renderState.depthWrite=false;
		renderState.cull=/*laya.d3.core.material.RenderState.CULL_NONE*/0;
		renderState.blend=/*laya.d3.core.material.RenderState.BLEND_DISABLE*/0;
		subShader=new SubShader(null,null,null,null);
		shader.addSubShader(subShader);
		shaderPass=subShader.addShaderPass("#include \"Lighting.glsl\";\n\nattribute vec4 a_PositionTexcoord;\nvarying vec2 v_Texcoord0;\n\nvoid main() {\n	gl_Position = vec4(a_PositionTexcoord.xy, 0.0, 1.0);\n	v_Texcoord0 = a_PositionTexcoord.zw;\n	gl_Position = remapGLPositionZ(gl_Position);\n}","#ifdef HIGHPRECISION\n	precision highp float;\n#else\n	precision mediump float;\n#endif\n\n#include \"Colors.glsl\";\n#include \"Sampling.glsl\";\n\nvarying vec2 v_Texcoord0;\n\nuniform sampler2D u_MainTex;\nuniform sampler2D u_AutoExposureTex;\nuniform vec4 u_MainTex_TexelSize;\nuniform vec4 u_Threshold; // x: threshold value (linear), y: threshold - knee, z: knee * 2, w: 0.25 / knee\nuniform vec4 u_Params; // x: clamp, yzw: unused\n\nmediump vec4 prefilter(mediump vec4 color, vec2 uv) {\n	mediump float autoExposure = texture2D(u_AutoExposureTex, uv).r;\n	color *= autoExposure;\n	color = min(vec4(u_Params.x), color); // clamp to max\n	color = quadraticThreshold(color, u_Threshold.x, u_Threshold.yzw);\n	return color;\n}\n\nvoid fragPrefilter13() {\n	mediump vec4 color = downsampleBox13Tap(u_MainTex, v_Texcoord0, u_MainTex_TexelSize.xy);\n	gl_FragColor = prefilter(safeHDR(color), v_Texcoord0);\n}\n\nvoid main() {\n	fragPrefilter13();\n}");
		renderState=shaderPass.renderState;
		renderState.depthTest=/*laya.d3.core.material.RenderState.DEPTHTEST_ALWAYS*/0x0207;
		renderState.depthWrite=false;
		renderState.cull=/*laya.d3.core.material.RenderState.CULL_NONE*/0;
		renderState.blend=/*laya.d3.core.material.RenderState.BLEND_DISABLE*/0;
		attributeMap={
			'a_PositionTexcoord':/*laya.d3.graphics.Vertex.VertexMesh.MESH_POSITION0*/0
		};
		uniformMap={
			'u_MainTex':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_BloomTex':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_AutoExposureTex':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_Bloom_DirtTex':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_BloomTex_TexelSize':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_Bloom_Settings':/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1,
			'u_Bloom_Color' :/*laya.d3.shader.Shader3D.PERIOD_MATERIAL*/1
		};
		shader=Shader3D.add("PostProcessComposite",attributeMap,uniformMap);
		subShader=new SubShader(null,null,null,PostProcess.shaderDefines);
		shader.addSubShader(subShader);
		shaderPass=subShader.addShaderPass("attribute vec4 a_Position;\nvarying vec2 v_Texcoord0;\n\nvec2 TransformTriangleVertexToUV(vec2 vertex)\n{\n    vec2 uv = (vertex + 1.0) * 0.5;\n    return uv;\n}\n\nvoid main() {\n	gl_Position =vec4(a_Position.xy, 0.0, 1.0);\n	v_Texcoord0=TransformTriangleVertexToUV(a_Position.xy);\n	gl_Position=remapGLPositionZ(gl_Position);\n}","#include \"Colors.glsl\";\n#include \"Sampling.glsl\";\n\nvarying vec2 v_Texcoord0;\n\nuniform sampler2D u_MainTex;\nuniform sampler2D u_BloomTex;\n\nuniform sampler2D u_AutoExposureTex;\nuniform sampler2D u_Bloom_DirtTex;\nuniform vec4 u_BloomTex_TexelSize;\nuniform vec4 u_Bloom_DirtTileOffset; // xy: tiling, zw: offset\nuniform mediump vec3 u_Bloom_Settings;// x: sampleScale, y: intensity, z: dirt intensity\nuniform mediump vec3 u_Bloom_Color;\n\nvoid main() {\n	mediump float autoExposure = texture2D(u_AutoExposureTex, v_Texcoord0).r;\n	mediump vec4 color=vec4(0.0)\n	color = texture2D(u_MainTex, v_Texcoord0);\n	\n	color = SRGBToLinear(color);\n	color.rgb *= autoExposure;\n	\n	#if BLOOM || BLOOM_LOW\n	{\n		#if BLOOM\n			mediump vec4 bloom = UpsampleTent(_BloomTex, uvDistorted, _BloomTex_TexelSize.xy, _Bloom_Settings.x);\n		#else\n			mediump vec4 bloom = UpsampleBox(_BloomTex, uvDistorted, _BloomTex_TexelSize.xy, _Bloom_Settings.x);\n		#endif\n\n		// UVs should be Distort(uv * _Bloom_DirtTileOffset.xy + _Bloom_DirtTileOffset.zw)\n		// but considering we use a cover-style scale on the dirt texture the difference\n		// isn't massive so we chose to save a few ALUs here instead in case lens distortion\n		// is active\n		mediump vec4 dirt = mediump vec4(SAMPLE_TEXTURE2D(_Bloom_DirtTex, sampler_Bloom_DirtTex, uvDistorted * _Bloom_DirtTileOffset.xy + _Bloom_DirtTileOffset.zw).rgb, 0.0);\n\n		// Additive bloom (artist friendly)\n		bloom *= _Bloom_Settings.y;\n		dirt *= _Bloom_Settings.z;\n		color += bloom * half4(_Bloom_Color, 1.0);\n		color += dirt * bloom;\n	}\n	#endif\n	\n	half4 output = color;\n	output = LinearToSRGB(output);\n	//output.rgb = Dither(output.rgb, v_Texcoord0);//TODO:\n}");
		renderState=shaderPass.renderState;
		renderState.depthTest=/*laya.d3.core.material.RenderState.DEPTHTEST_ALWAYS*/0x0207;
		renderState.depthWrite=false;
		renderState.cull=/*laya.d3.core.material.RenderState.CULL_NONE*/0;
		renderState.blend=/*laya.d3.core.material.RenderState.BLEND_DISABLE*/0;
	}

	ShaderInit3D._rangeAttenTex=null;
	return ShaderInit3D;
})()


/**
*<code>Utils3D</code> 类用于创建3D工具。
*/
//class laya.d3.utils.Utils3D
var Utils3D=(function(){
	function Utils3D(){}
	__class(Utils3D,'laya.d3.utils.Utils3D');
	Utils3D._convertToLayaVec3=function(bVector,out,inverseX){
		out.x=inverseX ?-bVector.x():bVector.x();
		out.y=bVector.y();
		out.z=bVector.z();
	}

	Utils3D._convertToBulletVec3=function(lVector,out,inverseX){
		out.setValue(inverseX ?-lVector.x :lVector.x,lVector.y,lVector.z);
	}

	Utils3D._rotationTransformScaleSkinAnimation=function(tx,ty,tz,qx,qy,qz,qw,sx,sy,sz,outArray,outOffset){
		var re=Utils3D._tempArray16_0;
		var se=Utils3D._tempArray16_1;
		var tse=Utils3D._tempArray16_2;
		var x2=qx+qx;
		var y2=qy+qy;
		var z2=qz+qz;
		var xx=qx *x2;
		var yx=qy *x2;
		var yy=qy *y2;
		var zx=qz *x2;
		var zy=qz *y2;
		var zz=qz *z2;
		var wx=qw *x2;
		var wy=qw *y2;
		var wz=qw *z2;
		re[15]=1;
		re[0]=1-yy-zz;
		re[1]=yx+wz;
		re[2]=zx-wy;
		re[4]=yx-wz;
		re[5]=1-xx-zz;
		re[6]=zy+wx;
		re[8]=zx+wy;
		re[9]=zy-wx;
		re[10]=1-xx-yy;
		se[15]=1;
		se[0]=sx;
		se[5]=sy;
		se[10]=sz;
		var i,a,b,e,ai0,ai1,ai2,ai3;
		for (i=0;i < 4;i++){
			ai0=re[i];
			ai1=re[i+4];
			ai2=re[i+8];
			ai3=re[i+12];
			tse[i]=ai0;
			tse[i+4]=ai1;
			tse[i+8]=ai2;
			tse[i+12]=ai0 *tx+ai1 *ty+ai2 *tz+ai3;
		}
		for (i=0;i < 4;i++){
			ai0=tse[i];
			ai1=tse[i+4];
			ai2=tse[i+8];
			ai3=tse[i+12];
			outArray[i+outOffset]=ai0 *se[0]+ai1 *se[1]+ai2 *se[2]+ai3 *se[3];
			outArray[i+outOffset+4]=ai0 *se[4]+ai1 *se[5]+ai2 *se[6]+ai3 *se[7];
			outArray[i+outOffset+8]=ai0 *se[8]+ai1 *se[9]+ai2 *se[10]+ai3 *se[11];
			outArray[i+outOffset+12]=ai0 *se[12]+ai1 *se[13]+ai2 *se[14]+ai3 *se[15];
		}
	}

	Utils3D._createSceneByJsonForMaker=function(nodeData,outBatchSprites,initTool){
		var scene3d=Utils3D._createNodeByJsonForMaker(nodeData,outBatchSprites,initTool);
		Utils3D._addComponentByJsonForMaker(nodeData,outBatchSprites,initTool);
		return scene3d;
	}

	Utils3D._createNodeByJsonForMaker=function(nodeData,outBatchSprites,initTool){
		var node;
		switch (nodeData.type){
			case "Scene3D":
				node=new Scene3D();
				break ;
			case "Sprite3D":
				node=new Sprite3D();
				break ;
			case "MeshSprite3D":
				node=new MeshSprite3D();
				(outBatchSprites)&& (outBatchSprites.push(node));
				break ;
			case "SkinnedMeshSprite3D":
				node=new SkinnedMeshSprite3D();
				break ;
			case "ShuriKenParticle3D":
				node=new ShuriKenParticle3D();
				break ;
			case "Terrain":
				node=new Terrain();
				break ;
			case "Camera":
				node=new Camera();
				break ;
			case "DirectionLight":
				node=new DirectionLight();
				break ;
			case "PointLight":
				node=new PointLight();
				break ;
			case "SpotLight":
				node=new SpotLight();
				break ;
			case "TrailSprite3D":
				node=new TrailSprite3D();
				break ;
			default :;
				var clas=ClassUtils.getClass(nodeData.props.runtime);
				node=new clas();
				break ;
			};
		var childData=nodeData.child;
		if (childData){
			for (var i=0,n=childData.length;i < n;i++){
				var child=Utils3D._createNodeByJsonForMaker(childData[i],outBatchSprites,initTool);
				node.addChild(child);
			}
		};
		var compId=nodeData.compId;
		(node).compId=compId;
		node._parse(nodeData.props,null);
		if (initTool){
			initTool._idMap[compId]=node;
		}
		Utils3D._compIdToNode[compId]=node;
		var componentsData=nodeData.components;
		if (componentsData){
			for (var j=0,m=componentsData.length;j < m;j++){
				var data=componentsData[j];
				clas=Browser.window.Laya[data.type];
				if (!clas){
					clas=Browser.window;
					var clasPaths=data.type.split('.');
					clasPaths.forEach(function(cls){
						clas=clas[cls];
					});
				}
				if (typeof(clas)=='function'){
					var comp=new clas();
					if (initTool){
						initTool._idMap[data.compId]=comp;
						console.log(data.compId);
					}
					}else {
					console.warn("Utils3D:Unkown component type.");
				}
			}
		}
		return node;
	}

	Utils3D._addComponentByJsonForMaker=function(nodeData,outBatchSprites,initTool){
		var compId=nodeData.compId;
		var node=Utils3D._compIdToNode[compId];
		var childData=nodeData.child;
		if (childData){
			for (var i=0,n=childData.length;i < n;i++){
				var child=Utils3D._addComponentByJsonForMaker(childData[i],outBatchSprites,initTool);
			}
		};
		var componentsData=nodeData.components;
		if (componentsData){
			for (var j=0,m=componentsData.length;j < m;j++){
				var data=componentsData[j];
				clas=Browser.window.Laya[data.type];
				if (!clas){
					var clasPaths=data.type.split('.');
					var clas=Browser.window;
					clasPaths.forEach(function(cls){
						clas=clas[cls];
					});
				}
				if (typeof(clas)=='function'){
					var component=initTool._idMap[data.compId];
					node.addComponentIntance(component);
					component._parse(data);
					}else {
					console.warn("Utils3D:Unkown component type.");
				}
			}
		}
	}

	Utils3D._createSprite3DInstance=function(nodeData,spriteMap,outBatchSprites){
		var node;
		switch (nodeData.type){
			case "Scene3D":
				node=new Scene3D();
				break ;
			case "Sprite3D":
				node=new Sprite3D();
				break ;
			case "MeshSprite3D":
				node=new MeshSprite3D();
				(outBatchSprites)&& (outBatchSprites.push(node));
				break ;
			case "SkinnedMeshSprite3D":
				node=new SkinnedMeshSprite3D();
				break ;
			case "ShuriKenParticle3D":
				node=new ShuriKenParticle3D();
				break ;
			case "Terrain":
				node=new Terrain();
				break ;
			case "Camera":
				node=new Camera();
				break ;
			case "DirectionLight":
				node=new DirectionLight();
				break ;
			case "PointLight":
				node=new PointLight();
				break ;
			case "SpotLight":
				node=new SpotLight();
				break ;
			case "TrailSprite3D":
				node=new TrailSprite3D();
				break ;
			default :
				throw new Error("Utils3D:unidentified class type in (.lh) file.");
			};
		var childData=nodeData.child;
		if (childData){
			for (var i=0,n=childData.length;i < n;i++){
				var child=Utils3D._createSprite3DInstance(childData[i],spriteMap,outBatchSprites)
				node.addChild(child);
			}
		}
		spriteMap[nodeData.instanceID]=node;
		return node;
	}

	Utils3D._createComponentInstance=function(nodeData,spriteMap){
		var node=spriteMap[nodeData.instanceID];
		node._parse(nodeData.props,spriteMap);
		var childData=nodeData.child;
		if (childData){
			for (var i=0,n=childData.length;i < n;i++)
			Utils3D._createComponentInstance(childData[i],spriteMap)
		};
		var componentsData=nodeData.components;
		if (componentsData){
			for (var j=0,m=componentsData.length;j < m;j++){
				var data=componentsData[j];
				var clas=Browser.window.Laya[data.type];
				if (!clas){
					var clasPaths=data.type.split('.');
					clas=Browser.window;
					clasPaths.forEach(function(cls){
						clas=clas[cls];
					});
				}
				if (typeof(clas)=='function'){
					var component=node.addComponent(clas);
					component._parse(data);
					}else {
					console.warn("Unkown component type.");
				}
			}
		}
	}

	Utils3D._createNodeByJson02=function(nodeData,outBatchSprites){
		var spriteMap={};
		var node=Utils3D._createSprite3DInstance(nodeData,spriteMap,outBatchSprites);
		Utils3D._createComponentInstance(nodeData,spriteMap);
		return node;
	}

	Utils3D._computeBoneAndAnimationDatasByBindPoseMatrxix=function(bones,curData,inverGlobalBindPose,outBonesDatas,outAnimationDatas,boneIndexToMesh){
		var offset=0;
		var matOffset=0;
		var i;
		var parentOffset;
		var boneLength=bones.length;
		for (i=0;i < boneLength;offset+=bones[i].keyframeWidth,matOffset+=16,i++){
			laya.d3.utils.Utils3D._rotationTransformScaleSkinAnimation(curData[offset+0],curData[offset+1],curData[offset+2],curData[offset+3],curData[offset+4],curData[offset+5],curData[offset+6],curData[offset+7],curData[offset+8],curData[offset+9],outBonesDatas,matOffset);
			if (i !=0){
				parentOffset=bones[i].parentIndex *16;
				laya.d3.utils.Utils3D.mulMatrixByArray(outBonesDatas,parentOffset,outBonesDatas,matOffset,outBonesDatas,matOffset);
			}
		};
		var n=inverGlobalBindPose.length;
		for (i=0;i < n;i++){
			laya.d3.utils.Utils3D.mulMatrixByArrayAndMatrixFast(outBonesDatas,boneIndexToMesh[i] *16,inverGlobalBindPose[i],outAnimationDatas,i *16);
		}
	}

	Utils3D._computeAnimationDatasByArrayAndMatrixFast=function(inverGlobalBindPose,bonesDatas,outAnimationDatas,boneIndexToMesh){
		for (var i=0,n=inverGlobalBindPose.length;i < n;i++)
		laya.d3.utils.Utils3D.mulMatrixByArrayAndMatrixFast(bonesDatas,boneIndexToMesh[i] *16,inverGlobalBindPose[i],outAnimationDatas,i *16);
	}

	Utils3D._computeBoneAndAnimationDatasByBindPoseMatrxixOld=function(bones,curData,inverGlobalBindPose,outBonesDatas,outAnimationDatas){
		var offset=0;
		var matOffset=0;
		var i;
		var parentOffset;
		var boneLength=bones.length;
		for (i=0;i < boneLength;offset+=bones[i].keyframeWidth,matOffset+=16,i++){
			laya.d3.utils.Utils3D._rotationTransformScaleSkinAnimation(curData[offset+7],curData[offset+8],curData[offset+9],curData[offset+3],curData[offset+4],curData[offset+5],curData[offset+6],curData[offset+0],curData[offset+1],curData[offset+2],outBonesDatas,matOffset);
			if (i !=0){
				parentOffset=bones[i].parentIndex *16;
				laya.d3.utils.Utils3D.mulMatrixByArray(outBonesDatas,parentOffset,outBonesDatas,matOffset,outBonesDatas,matOffset);
			}
		};
		var n=inverGlobalBindPose.length;
		for (i=0;i < n;i++){
			var arrayOffset=i *16;
			laya.d3.utils.Utils3D.mulMatrixByArrayAndMatrixFast(outBonesDatas,arrayOffset,inverGlobalBindPose[i],outAnimationDatas,arrayOffset);
		}
	}

	Utils3D._computeAnimationDatasByArrayAndMatrixFastOld=function(inverGlobalBindPose,bonesDatas,outAnimationDatas){
		var n=inverGlobalBindPose.length;
		for (var i=0;i < n;i++){
			var arrayOffset=i *16;
			laya.d3.utils.Utils3D.mulMatrixByArrayAndMatrixFast(bonesDatas,arrayOffset,inverGlobalBindPose[i],outAnimationDatas,arrayOffset);
		}
	}

	Utils3D._computeRootAnimationData=function(bones,curData,animationDatas){
		for (var i=0,offset=0,matOffset=0,boneLength=bones.length;i < boneLength;offset+=bones[i].keyframeWidth,matOffset+=16,i++)
		laya.d3.utils.Utils3D.createAffineTransformationArray(curData[offset+0],curData[offset+1],curData[offset+2],curData[offset+3],curData[offset+4],curData[offset+5],curData[offset+6],curData[offset+7],curData[offset+8],curData[offset+9],animationDatas,matOffset);
	}

	Utils3D.transformVector3ArrayByQuat=function(sourceArray,sourceOffset,rotation,outArray,outOffset){
		var x=sourceArray[sourceOffset],y=sourceArray[sourceOffset+1],z=sourceArray[sourceOffset+2],qx=rotation.x,qy=rotation.y,qz=rotation.z,qw=rotation.w,ix=qw *x+qy *z-qz *y,iy=qw *y+qz *x-qx *z,iz=qw *z+qx *y-qy *x,iw=-qx *x-qy *y-qz *z;
		outArray[outOffset]=ix *qw+iw *-qx+iy *-qz-iz *-qy;
		outArray[outOffset+1]=iy *qw+iw *-qy+iz *-qx-ix *-qz;
		outArray[outOffset+2]=iz *qw+iw *-qz+ix *-qy-iy *-qx;
	}

	Utils3D.mulMatrixByArray=function(leftArray,leftOffset,rightArray,rightOffset,outArray,outOffset){
		var i,ai0,ai1,ai2,ai3;
		if (outArray===rightArray){
			rightArray=Utils3D._tempArray16_3;
			for (i=0;i < 16;++i){
				rightArray[i]=outArray[outOffset+i];
			}
			rightOffset=0;
		}
		for (i=0;i < 4;i++){
			ai0=leftArray[leftOffset+i];
			ai1=leftArray[leftOffset+i+4];
			ai2=leftArray[leftOffset+i+8];
			ai3=leftArray[leftOffset+i+12];
			outArray[outOffset+i]=ai0 *rightArray[rightOffset+0]+ai1 *rightArray[rightOffset+1]+ai2 *rightArray[rightOffset+2]+ai3 *rightArray[rightOffset+3];
			outArray[outOffset+i+4]=ai0 *rightArray[rightOffset+4]+ai1 *rightArray[rightOffset+5]+ai2 *rightArray[rightOffset+6]+ai3 *rightArray[rightOffset+7];
			outArray[outOffset+i+8]=ai0 *rightArray[rightOffset+8]+ai1 *rightArray[rightOffset+9]+ai2 *rightArray[rightOffset+10]+ai3 *rightArray[rightOffset+11];
			outArray[outOffset+i+12]=ai0 *rightArray[rightOffset+12]+ai1 *rightArray[rightOffset+13]+ai2 *rightArray[rightOffset+14]+ai3 *rightArray[rightOffset+15];
		}
	}

	Utils3D.mulMatrixByArrayFast=function(leftArray,leftOffset,rightArray,rightOffset,outArray,outOffset){
		var i,ai0,ai1,ai2,ai3;
		for (i=0;i < 4;i++){
			ai0=leftArray[leftOffset+i];
			ai1=leftArray[leftOffset+i+4];
			ai2=leftArray[leftOffset+i+8];
			ai3=leftArray[leftOffset+i+12];
			outArray[outOffset+i]=ai0 *rightArray[rightOffset+0]+ai1 *rightArray[rightOffset+1]+ai2 *rightArray[rightOffset+2]+ai3 *rightArray[rightOffset+3];
			outArray[outOffset+i+4]=ai0 *rightArray[rightOffset+4]+ai1 *rightArray[rightOffset+5]+ai2 *rightArray[rightOffset+6]+ai3 *rightArray[rightOffset+7];
			outArray[outOffset+i+8]=ai0 *rightArray[rightOffset+8]+ai1 *rightArray[rightOffset+9]+ai2 *rightArray[rightOffset+10]+ai3 *rightArray[rightOffset+11];
			outArray[outOffset+i+12]=ai0 *rightArray[rightOffset+12]+ai1 *rightArray[rightOffset+13]+ai2 *rightArray[rightOffset+14]+ai3 *rightArray[rightOffset+15];
		}
	}

	Utils3D.mulMatrixByArrayAndMatrixFast=function(leftArray,leftOffset,rightMatrix,outArray,outOffset){
		var i,ai0,ai1,ai2,ai3;
		var rightMatrixE=rightMatrix.elements;
		var m11=rightMatrixE[0],m12=rightMatrixE[1],m13=rightMatrixE[2],m14=rightMatrixE[3];
		var m21=rightMatrixE[4],m22=rightMatrixE[5],m23=rightMatrixE[6],m24=rightMatrixE[7];
		var m31=rightMatrixE[8],m32=rightMatrixE[9],m33=rightMatrixE[10],m34=rightMatrixE[11];
		var m41=rightMatrixE[12],m42=rightMatrixE[13],m43=rightMatrixE[14],m44=rightMatrixE[15];
		var ai0LeftOffset=leftOffset;
		var ai1LeftOffset=leftOffset+4;
		var ai2LeftOffset=leftOffset+8;
		var ai3LeftOffset=leftOffset+12;
		var ai0OutOffset=outOffset;
		var ai1OutOffset=outOffset+4;
		var ai2OutOffset=outOffset+8;
		var ai3OutOffset=outOffset+12;
		for (i=0;i < 4;i++){
			ai0=leftArray[ai0LeftOffset+i];
			ai1=leftArray[ai1LeftOffset+i];
			ai2=leftArray[ai2LeftOffset+i];
			ai3=leftArray[ai3LeftOffset+i];
			outArray[ai0OutOffset+i]=ai0 *m11+ai1 *m12+ai2 *m13+ai3 *m14;
			outArray[ai1OutOffset+i]=ai0 *m21+ai1 *m22+ai2 *m23+ai3 *m24;
			outArray[ai2OutOffset+i]=ai0 *m31+ai1 *m32+ai2 *m33+ai3 *m34;
			outArray[ai3OutOffset+i]=ai0 *m41+ai1 *m42+ai2 *m43+ai3 *m44;
		}
	}

	Utils3D.createAffineTransformationArray=function(tX,tY,tZ,rX,rY,rZ,rW,sX,sY,sZ,outArray,outOffset){
		var x2=rX+rX,y2=rY+rY,z2=rZ+rZ;
		var xx=rX *x2,xy=rX *y2,xz=rX *z2,yy=rY *y2,yz=rY *z2,zz=rZ *z2;
		var wx=rW *x2,wy=rW *y2,wz=rW *z2;
		outArray[outOffset+0]=(1-(yy+zz))*sX;
		outArray[outOffset+1]=(xy+wz)*sX;
		outArray[outOffset+2]=(xz-wy)*sX;
		outArray[outOffset+3]=0;
		outArray[outOffset+4]=(xy-wz)*sY;
		outArray[outOffset+5]=(1-(xx+zz))*sY;
		outArray[outOffset+6]=(yz+wx)*sY;
		outArray[outOffset+7]=0;
		outArray[outOffset+8]=(xz+wy)*sZ;
		outArray[outOffset+9]=(yz-wx)*sZ;
		outArray[outOffset+10]=(1-(xx+yy))*sZ;
		outArray[outOffset+11]=0;
		outArray[outOffset+12]=tX;
		outArray[outOffset+13]=tY;
		outArray[outOffset+14]=tZ;
		outArray[outOffset+15]=1;
	}

	Utils3D.transformVector3ArrayToVector3ArrayCoordinate=function(source,sourceOffset,transform,result,resultOffset){
		var coordinateX=source[sourceOffset+0];
		var coordinateY=source[sourceOffset+1];
		var coordinateZ=source[sourceOffset+2];
		var transformElem=transform.elements;
		var w=((coordinateX *transformElem[3])+(coordinateY *transformElem[7])+(coordinateZ *transformElem[11])+transformElem[15]);
		result[resultOffset]=(coordinateX *transformElem[0])+(coordinateY *transformElem[4])+(coordinateZ *transformElem[8])+transformElem[12] / w;
		result[resultOffset+1]=(coordinateX *transformElem[1])+(coordinateY *transformElem[5])+(coordinateZ *transformElem[9])+transformElem[13] / w;
		result[resultOffset+2]=(coordinateX *transformElem[2])+(coordinateY *transformElem[6])+(coordinateZ *transformElem[10])+transformElem[14] / w;
	}

	Utils3D.transformLightingMapTexcoordArray=function(source,sourceOffset,lightingMapScaleOffset,result,resultOffset){
		result[resultOffset+0]=source[sourceOffset+0] *lightingMapScaleOffset.x+lightingMapScaleOffset.z;
		result[resultOffset+1]=1.0-((1.0-source[sourceOffset+1])*lightingMapScaleOffset.y+lightingMapScaleOffset.w);
	}

	Utils3D.getURLVerion=function(url){
		var index=url.indexOf("?");
		return index >=0 ? url.substr(index):null;
	}

	Utils3D._createAffineTransformationArray=function(trans,rot,scale,outE){
		var x=rot.x,y=rot.y,z=rot.z,w=rot.w,x2=x+x,y2=y+y,z2=z+z;
		var xx=x *x2,xy=x *y2,xz=x *z2,yy=y *y2,yz=y *z2,zz=z *z2;
		var wx=w *x2,wy=w *y2,wz=w *z2,sx=scale.x,sy=scale.y,sz=scale.z;
		outE[0]=(1-(yy+zz))*sx;
		outE[1]=(xy+wz)*sx;
		outE[2]=(xz-wy)*sx;
		outE[3]=0;
		outE[4]=(xy-wz)*sy;
		outE[5]=(1-(xx+zz))*sy;
		outE[6]=(yz+wx)*sy;
		outE[7]=0;
		outE[8]=(xz+wy)*sz;
		outE[9]=(yz-wx)*sz;
		outE[10]=(1-(xx+yy))*sz;
		outE[11]=0;
		outE[12]=trans.x;
		outE[13]=trans.y;
		outE[14]=trans.z;
		outE[15]=1;
	}

	Utils3D._mulMatrixArray=function(leftMatrixE,rightMatrix,outArray,outOffset){
		var i,ai0,ai1,ai2,ai3;
		var rightMatrixE=rightMatrix.elements;
		var m11=rightMatrixE[0],m12=rightMatrixE[1],m13=rightMatrixE[2],m14=rightMatrixE[3];
		var m21=rightMatrixE[4],m22=rightMatrixE[5],m23=rightMatrixE[6],m24=rightMatrixE[7];
		var m31=rightMatrixE[8],m32=rightMatrixE[9],m33=rightMatrixE[10],m34=rightMatrixE[11];
		var m41=rightMatrixE[12],m42=rightMatrixE[13],m43=rightMatrixE[14],m44=rightMatrixE[15];
		var ai0OutOffset=outOffset;
		var ai1OutOffset=outOffset+4;
		var ai2OutOffset=outOffset+8;
		var ai3OutOffset=outOffset+12;
		for (i=0;i < 4;i++){
			ai0=leftMatrixE[i];
			ai1=leftMatrixE[i+4];
			ai2=leftMatrixE[i+8];
			ai3=leftMatrixE[i+12];
			outArray[ai0OutOffset+i]=ai0 *m11+ai1 *m12+ai2 *m13+ai3 *m14;
			outArray[ai1OutOffset+i]=ai0 *m21+ai1 *m22+ai2 *m23+ai3 *m24;
			outArray[ai2OutOffset+i]=ai0 *m31+ai1 *m32+ai2 *m33+ai3 *m34;
			outArray[ai3OutOffset+i]=ai0 *m41+ai1 *m42+ai2 *m43+ai3 *m44;
		}
	}

	Utils3D.arcTanAngle=function(x,y){
		if (x==0){
			if (y==1)
				return Math.PI / 2;
			return-Math.PI / 2;
		}
		if (x > 0)
			return Math.atan(y / x);
		if (x < 0){
			if (y > 0)
				return Math.atan(y / x)+Math.PI;
			return Math.atan(y / x)-Math.PI;
		}
		return 0;
	}

	Utils3D.angleTo=function(from,location,angle){
		Vector3.subtract(location,from,Quaternion.TEMPVector30);
		Vector3.normalize(Quaternion.TEMPVector30,Quaternion.TEMPVector30);
		angle.x=Math.asin(Quaternion.TEMPVector30.y);
		angle.y=Utils3D.arcTanAngle(-Quaternion.TEMPVector30.z,-Quaternion.TEMPVector30.x);
	}

	Utils3D.transformQuat=function(source,rotation,out){
		var re=rotation;
		var x=source.x,y=source.y,z=source.z,qx=re[0],qy=re[1],qz=re[2],qw=re[3],
		ix=qw *x+qy *z-qz *y,iy=qw *y+qz *x-qx *z,iz=qw *z+qx *y-qy *x,iw=-qx *x-qy *y-qz *z;
		out.x=ix *qw+iw *-qx+iy *-qz-iz *-qy;
		out.y=iy *qw+iw *-qy+iz *-qx-ix *-qz;
		out.z=iz *qw+iw *-qz+ix *-qy-iy *-qx;
	}

	Utils3D.quaternionWeight=function(f,weight,e){
		e.x=f.x *weight;
		e.y=f.y *weight;
		e.z=f.z *weight;
		e.w=f.w;
	}

	Utils3D.quaternionConjugate=function(value,result){
		result.x=-value.x;
		result.y=-value.y;
		result.z=-value.z;
		result.w=value.w;
	}

	Utils3D.scaleWeight=function(s,w,out){
		var sX=s.x,sY=s.y,sZ=s.z;
		out.x=sX > 0 ? Math.pow(Math.abs(sX),w):-Math.pow(Math.abs(sX),w);
		out.y=sY > 0 ? Math.pow(Math.abs(sY),w):-Math.pow(Math.abs(sY),w);
		out.z=sZ > 0 ? Math.pow(Math.abs(sZ),w):-Math.pow(Math.abs(sZ),w);
	}

	Utils3D.scaleBlend=function(sa,sb,w,out){
		var saw=Utils3D._tempVector3_0;
		var sbw=Utils3D._tempVector3_1;
		Utils3D.scaleWeight(sa,1.0-w,saw);
		Utils3D.scaleWeight(sb,w,sbw);
		var sng=w > 0.5 ? sb :sa;
		out.x=sng.x > 0 ? Math.abs(saw.x *sbw.x):-Math.abs(saw.x *sbw.x);
		out.y=sng.y > 0 ? Math.abs(saw.y *sbw.y):-Math.abs(saw.y *sbw.y);
		out.z=sng.z > 0 ? Math.abs(saw.z *sbw.z):-Math.abs(saw.z *sbw.z);
	}

	Utils3D.gammaToLinearSpace=function(value){
		if (value <=0.04045)
			return value / 12.92;
		else if (value < 1.0)
		return Math.pow((value+0.055)/ 1.055,2.4);
		else
		return Math.pow(value,2.4);
	}

	Utils3D.linearToGammaSpace=function(value){
		if (value <=0.0)
			return 0.0;
		else if (value <=0.0031308)
		return 12.92 *value;
		else if (value <=1.0)
		return 1.055 *Math.pow(value,0.41666)-0.055;
		else
		return Math.pow(value,0.41666);
	}

	Utils3D.matrix4x4MultiplyFFF=function(a,b,e){
		var i,ai0,ai1,ai2,ai3;
		if (e===b){
			b=new Float32Array(16);
			for (i=0;i < 16;++i){
				b[i]=e[i];
			}
		};
		var b0=b[0],b1=b[1],b2=b[2],b3=b[3];
		var b4=b[4],b5=b[5],b6=b[6],b7=b[7];
		var b8=b[8],b9=b[9],b10=b[10],b11=b[11];
		var b12=b[12],b13=b[13],b14=b[14],b15=b[15];
		for (i=0;i < 4;i++){
			ai0=a[i];
			ai1=a[i+4];
			ai2=a[i+8];
			ai3=a[i+12];
			e[i]=ai0 *b0+ai1 *b1+ai2 *b2+ai3 *b3;
			e[i+4]=ai0 *b4+ai1 *b5+ai2 *b6+ai3 *b7;
			e[i+8]=ai0 *b8+ai1 *b9+ai2 *b10+ai3 *b11;
			e[i+12]=ai0 *b12+ai1 *b13+ai2 *b14+ai3 *b15;
		}
	}

	Utils3D.matrix4x4MultiplyFFFForNative=function(a,b,e){
		LayaGL.instance.matrix4x4Multiply(a,b,e);
	}

	Utils3D.matrix4x4MultiplyMFM=function(left,right,out){
		Utils3D.matrix4x4MultiplyFFF(left.elements,right,out.elements);
	}

	Utils3D._buildTexture2D=function(width,height,format,colorFunc,mipmaps){
		(mipmaps===void 0)&& (mipmaps=false);
		var texture=new Texture2D(width,height,format,mipmaps,true);
		texture.anisoLevel=1;
		texture.filterMode=/*laya.resource.BaseTexture.FILTERMODE_POINT*/0;
		TextureGenerator._generateTexture2D(texture,width,height,colorFunc);
		return texture;
	}

	Utils3D._drawBound=function(debugLine,boundBox,color){
		if (debugLine.lineCount+12 > debugLine.maxLineCount)
			debugLine.maxLineCount+=12;
		var start=Utils3D._tempVector3_0;
		var end=Utils3D._tempVector3_1;
		var min=boundBox.min;
		var max=boundBox.max;
		start.setValue(min.x,min.y,min.z);
		end.setValue(max.x,min.y,min.z);
		debugLine.addLine(start,end,color,color);
		start.setValue(min.x,min.y,min.z);
		end.setValue(min.x,min.y,max.z);
		debugLine.addLine(start,end,color,color);
		start.setValue(max.x,min.y,min.z);
		end.setValue(max.x,min.y,max.z);
		debugLine.addLine(start,end,color,color);
		start.setValue(min.x,min.y,max.z);
		end.setValue(max.x,min.y,max.z);
		debugLine.addLine(start,end,color,color);
		start.setValue(min.x,min.y,min.z);
		end.setValue(min.x,max.y,min.z);
		debugLine.addLine(start,end,color,color);
		start.setValue(min.x,min.y,max.z);
		end.setValue(min.x,max.y,max.z);
		debugLine.addLine(start,end,color,color);
		start.setValue(max.x,min.y,min.z);
		end.setValue(max.x,max.y,min.z);
		debugLine.addLine(start,end,color,color);
		start.setValue(max.x,min.y,max.z);
		end.setValue(max.x,max.y,max.z);
		debugLine.addLine(start,end,color,color);
		start.setValue(min.x,max.y,min.z);
		end.setValue(max.x,max.y,min.z);
		debugLine.addLine(start,end,color,color);
		start.setValue(min.x,max.y,min.z);
		end.setValue(min.x,max.y,max.z);
		debugLine.addLine(start,end,color,color);
		start.setValue(max.x,max.y,min.z);
		end.setValue(max.x,max.y,max.z);
		debugLine.addLine(start,end,color,color);
		start.setValue(min.x,max.y,max.z);
		end.setValue(max.x,max.y,max.z);
		debugLine.addLine(start,end,color,color);
	}

	Utils3D._getHierarchyPath=function(rootSprite,checkSprite,path){
		path.length=0;
		var sprite=checkSprite;
		while (sprite!==rootSprite){
			var parent=sprite._parent;
			if (parent)
				path.push(parent.getChildIndex(sprite));
			else
			return null;
			sprite=parent;
		}
		return path;
	}

	Utils3D._getNodeByHierarchyPath=function(rootSprite,invPath){
		var sprite=rootSprite;
		for (var i=invPath.length-1;i >=0;i--){
			sprite=sprite.getChildAt(invPath[i]);
		}
		return sprite;
	}

	Utils3D._createNodeByJson=function(nodeData,outBatchSprites){
		var node;
		switch (nodeData.type){
			case "Scene3D":
				node=new Scene3D();
				break ;
			case "Sprite3D":
				node=new Sprite3D();
				break ;
			case "MeshSprite3D":
				node=new MeshSprite3D();
				(outBatchSprites)&& (outBatchSprites.push(node));
				break ;
			case "SkinnedMeshSprite3D":
				node=new SkinnedMeshSprite3D();
				break ;
			case "ShuriKenParticle3D":
				node=new ShuriKenParticle3D();
				break ;
			case "Terrain":
				node=new Terrain();
				break ;
			case "Camera":
				node=new Camera();
				break ;
			case "DirectionLight":
				node=new DirectionLight();
				break ;
			case "PointLight":
				node=new PointLight();
				break ;
			case "SpotLight":
				node=new SpotLight();
				break ;
			case "TrailSprite3D":
				node=new TrailSprite3D();
				break ;
			default :
				throw new Error("Utils3D:unidentified class type in (.lh) file.");
			};
		var childData=nodeData.child;
		if (childData){
			for (var i=0,n=childData.length;i < n;i++){
				var child=Utils3D._createNodeByJson(childData[i],outBatchSprites)
				node.addChild(child);
			}
		};
		var componentsData=nodeData.components;
		if (componentsData){
			for (var j=0,m=componentsData.length;j < m;j++){
				var data=componentsData[j];
				clas=Browser.window.Laya[data.type];
				if (!clas){
					var clasPaths=data.type.split('.');
					var clas=Browser.window;
					clasPaths.forEach(function(cls){
						clas=clas[cls];
					});
				}
				if (typeof(clas)=='function'){
					var component=node.addComponent(clas);
					component._parse(data);
					}else {
					console.warn("Unkown component type.");
				}
			}
		}
		node._parse(nodeData.props,null);
		return node;
	}

	Utils3D._tempArray16_0=new Float32Array(16);
	Utils3D._tempArray16_1=new Float32Array(16);
	Utils3D._tempArray16_2=new Float32Array(16);
	Utils3D._tempArray16_3=new Float32Array(16);
	__static(Utils3D,
	['_tempVector3_0',function(){return this._tempVector3_0=new Vector3();},'_tempVector3_1',function(){return this._tempVector3_1=new Vector3();},'_tempVector3_2',function(){return this._tempVector3_2=new Vector3();},'_tempColor0',function(){return this._tempColor0=new Color();},'_compIdToNode',function(){return this._compIdToNode=new Object();}
	]);
	return Utils3D;
})()


/**
*<code>GradientDataNumber</code> 类用于创建浮点渐变。
*/
//class laya.d3.core.particleShuriKen.module.GradientDataNumber
var GradientDataNumber=(function(){
	function GradientDataNumber(){
		/**@private */
		this._currentLength=0;
		/**@private 开发者禁止修改。*/
		this._elements=null;
		this._elements=new Float32Array(8);
	}

	__class(GradientDataNumber,'laya.d3.core.particleShuriKen.module.GradientDataNumber');
	var __proto=GradientDataNumber.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*增加浮点渐变。
	*@param key 生命周期，范围为0到1。
	*@param value 浮点值。
	*/
	__proto.add=function(key,value){
		if (this._currentLength < 8){
			if ((this._currentLength===6)&& ((key!==1))){
				key=1;
				console.log("GradientDataNumber warning:the forth key is  be force set to 1.");
			}
			this._elements[this._currentLength++]=key;
			this._elements[this._currentLength++]=value;
			}else {
			console.log("GradientDataNumber warning:data count must lessEqual than 4");
		}
	}

	/**
	*通过索引获取键。
	*@param index 索引。
	*@return value 键。
	*/
	__proto.getKeyByIndex=function(index){
		return this._elements[index *2];
	}

	/**
	*通过索引获取值。
	*@param index 索引。
	*@return value 值。
	*/
	__proto.getValueByIndex=function(index){
		return this._elements[index *2+1];
	}

	/**
	*获取平均值。
	*/
	__proto.getAverageValue=function(){
		var total=0;
		for (var i=0,n=this._currentLength-2;i < n;i+=2){
			var subValue=this._elements[i+1];
			subValue+=this._elements[i+3];
			subValue=subValue *(this._elements[i+2]-this._elements[i]);
		}
		return total / 2;
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destGradientDataNumber=destObject;
		destGradientDataNumber._currentLength=this._currentLength;
		var destElements=destGradientDataNumber._elements;
		destElements.length=this._elements.length;
		for (var i=0,n=this._elements.length;i < n;i++)
		destElements[i]=this._elements[i];
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destGradientDataNumber=/*__JS__ */new this.constructor();
		this.cloneTo(destGradientDataNumber);
		return destGradientDataNumber;
	}

	/**渐变浮点数量。*/
	__getset(0,__proto,'gradientCount',function(){
		return this._currentLength / 2;
	});

	return GradientDataNumber;
})()


/**
*...
*@author
*/
//class laya.d3.core.pixelLine.PixelLineVertex
var PixelLineVertex=(function(){
	function PixelLineVertex(){}
	__class(PixelLineVertex,'laya.d3.core.pixelLine.PixelLineVertex');
	var __proto=PixelLineVertex.prototype;
	__getset(0,__proto,'vertexDeclaration',function(){
		return PixelLineVertex._vertexDeclaration;
	});

	__getset(1,PixelLineVertex,'vertexDeclaration',function(){
		return PixelLineVertex._vertexDeclaration;
	});

	__static(PixelLineVertex,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(28,
		[new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*laya.d3.graphics.Vertex.VertexMesh.MESH_POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector4*/"vector4",/*laya.d3.graphics.Vertex.VertexMesh.MESH_COLOR0*/1)]);}
	]);
	return PixelLineVertex;
})()


/**
*<code>CollisionMap</code> 类用于实现碰撞组合实例图。
*/
//class laya.d3.physics.CollisionTool
var CollisionTool=(function(){
	function CollisionTool(){
		/**@private */
		this._hitResultsPoolIndex=0;
		/**@private */
		this._contactPonintsPoolIndex=0;
		/**@private */
		this._collisions={};
		this._hitResultsPool=[];
		this._contactPointsPool=[];
		this._collisionsPool=[];
	}

	__class(CollisionTool,'laya.d3.physics.CollisionTool');
	var __proto=CollisionTool.prototype;
	/**
	*@private
	*/
	__proto.getHitResult=function(){
		var hitResult=this._hitResultsPool[this._hitResultsPoolIndex++];
		if (!hitResult){
			hitResult=new HitResult();
			this._hitResultsPool.push(hitResult);
		}
		return hitResult;
	}

	/**
	*@private
	*/
	__proto.recoverAllHitResultsPool=function(){
		this._hitResultsPoolIndex=0;
	}

	/**
	*@private
	*/
	__proto.getContactPoints=function(){
		var contactPoint=this._contactPointsPool[this._contactPonintsPoolIndex++];
		if (!contactPoint){
			contactPoint=new ContactPoint();
			this._contactPointsPool.push(contactPoint);
		}
		return contactPoint;
	}

	/**
	*@private
	*/
	__proto.recoverAllContactPointsPool=function(){
		this._contactPonintsPoolIndex=0;
	}

	/**
	*@private
	*/
	__proto.getCollision=function(physicComponentA,physicComponentB){
		var collision;
		var idA=physicComponentA.id;
		var idB=physicComponentB.id;
		var subCollisionFirst=this._collisions[idA];
		if (subCollisionFirst)
			collision=subCollisionFirst[idB];
		if (!collision){
			if (!subCollisionFirst){
				subCollisionFirst={};
				this._collisions[idA]=subCollisionFirst;
			}
			collision=this._collisionsPool.length===0 ? new Collision():this._collisionsPool.pop();
			collision._colliderA=physicComponentA;
			collision._colliderB=physicComponentB;
			subCollisionFirst[idB]=collision;
		}
		return collision;
	}

	/**
	*@private
	*/
	__proto.recoverCollision=function(collision){
		var idA=collision._colliderA.id;
		var idB=collision._colliderB.id;
		this._collisions[idA][idB]=null;
		this._collisionsPool.push(collision);
	}

	/**
	*@private
	*/
	__proto.garbageCollection=function(){
		this._hitResultsPoolIndex=0;
		this._hitResultsPool.length=0;
		this._contactPonintsPoolIndex=0;
		this._contactPointsPool.length=0;
		this._collisionsPool.length=0;
		for (var subCollisionsKey in this._collisionsPool){
			var subCollisions=this._collisionsPool[subCollisionsKey];
			var wholeDelete=true;
			for (var collisionKey in subCollisions){
				if (subCollisions[collisionKey])
					wholeDelete=false;
				else
				delete subCollisions[collisionKey];
			}
			if (wholeDelete)
				delete this._collisionsPool[subCollisionsKey];
		}
	}

	return CollisionTool;
})()


/**
*<code>Input3D</code> 类用于实现3D输入。
*/
//class laya.d3.Input3D
var Input3D=(function(){
	function Input3D(){
		/**@private */
		this._scene=null;
		/**@private */
		this._eventList=[];
		/**@private */
		this._multiTouchEnabled=true;
		this._mouseTouch=new MouseTouch();
		this._touchPool=[];
		this._touches=new SimpleSingletonList();
	}

	__class(Input3D,'laya.d3.Input3D');
	var __proto=Input3D.prototype;
	/**
	*@private
	*/
	__proto.__init__=function(canvas,scene){
		this._scene=scene;
		var list=this._eventList;
		canvas.oncontextmenu=function (e){
			return false;
		}
		canvas.addEventListener('mousedown',function(e){
			e.preventDefault();
			list.push(e);
		});
		canvas.addEventListener('mouseup',function(e){
			e.preventDefault();
			list.push(e);
		},true);
		canvas.addEventListener('mousemove',function(e){
			e.preventDefault();
			list.push(e);
		},true);
		canvas.addEventListener("touchstart",function(e){
			e.preventDefault();
			list.push(e);
		});
		canvas.addEventListener("touchend",function(e){
			e.preventDefault();
			list.push(e);
		},true);
		canvas.addEventListener("touchmove",function(e){
			e.preventDefault();
			list.push(e);
		},true);
		canvas.addEventListener("touchcancel",function(e){
			list.push(e);
		},true);
	}

	/**
	*获取触摸点个数。
	*@return 触摸点个数。
	*/
	__proto.touchCount=function(){
		return this._touches.length;
	}

	/**
	*@private
	*/
	__proto._getTouch=function(touchID){
		var touch=this._touchPool[touchID];
		if (!touch){
			touch=new Touch();
			this._touchPool[touchID]=touch;
			touch._identifier=touchID;
		}
		return touch;
	}

	/**
	*@private
	*/
	__proto._mouseTouchDown=function(){
		var touch=this._mouseTouch;
		var sprite=touch.sprite;
		touch._pressedSprite=sprite;
		touch._pressedLoopCount=Stat.loopCount;
		if (sprite){
			var scripts=sprite._scripts;
			if (scripts){
				for (var i=0,n=scripts.length;i < n;i++)
				scripts[i].onMouseDown();
			}
		}
	}

	/**
	*@private
	*/
	__proto._mouseTouchUp=function(){
		var i=0,n=0;
		var touch=this._mouseTouch;
		var lastPressedSprite=touch._pressedSprite;
		touch._pressedSprite=null;
		touch._pressedLoopCount=-1;
		var sprite=touch.sprite;
		if (sprite){
			if (sprite===lastPressedSprite){
				var scripts=sprite._scripts;
				if (scripts){
					for (i=0,n=scripts.length;i < n;i++)
					scripts[i].onMouseClick();
				}
			}
		}
		if (lastPressedSprite){
			var lastScripts=lastPressedSprite._scripts;
			if (lastScripts){
				for (i=0,n=lastScripts.length;i < n;i++)
				lastScripts[i].onMouseUp();
			}
		}
	}

	/**
	*@private
	*/
	__proto._mouseTouchRayCast=function(cameras){
		var touchHitResult=Input3D._tempHitResult0;
		var touchPos=Input3D._tempVector20;
		var touchRay=Input3D._tempRay0;
		touchHitResult.succeeded=false;
		var x=this._mouseTouch.mousePositionX;
		var y=this._mouseTouch.mousePositionY;
		touchPos.x=x;
		touchPos.y=y;
		for (var i=cameras.length-1;i >=0;i--){
			var camera=cameras [i];
			var viewport=camera.viewport;
			if (touchPos.x >=viewport.x && touchPos.y >=viewport.y && touchPos.x <=viewport.width && touchPos.y <=viewport.height){
				camera.viewportPointToRay(touchPos,touchRay);
				var sucess=this._scene._physicsSimulation.rayCast(touchRay,touchHitResult);
				if (sucess || (camera.clearFlag===/*laya.d3.core.BaseCamera.CLEARFLAG_SOLIDCOLOR*/0 || camera.clearFlag===/*laya.d3.core.BaseCamera.CLEARFLAG_SKY*/1))
					break ;
			}
		};
		var touch=this._mouseTouch;
		var lastSprite=touch.sprite;
		if (touchHitResult.succeeded){
			var touchSprite=touchHitResult.collider.owner;
			touch.sprite=touchSprite;
			var scripts=touchSprite._scripts;
			if (lastSprite!==touchSprite){
				if (scripts){
					for (var j=0,m=scripts.length;j < m;j++)
					scripts[j].onMouseEnter();
				}
			}
			}else {
			touch.sprite=null;
		}
		if (lastSprite && (lastSprite!==touchSprite)){
			var outScripts=lastSprite._scripts;
			if (outScripts){
				for (j=0,m=outScripts.length;j < m;j++)
				outScripts[j].onMouseOut();
			}
		}
	}

	/**
	*@private
	*@param flag 0:add、1:remove、2:change
	*/
	__proto._changeTouches=function(changedTouches,flag){
		var offsetX=0,offsetY=0;
		var lastCount=this._touches.length;
		for (var j=0,m=changedTouches.length;j < m;j++){
			var nativeTouch=changedTouches[j];
			var identifier=nativeTouch.identifier;
			if (!this._multiTouchEnabled && identifier!==0)
				continue ;
			var touch=this._getTouch(identifier);
			var pos=touch._position;
			var mousePoint=Input3D._tempPoint;
			mousePoint.setTo(nativeTouch.pageX,nativeTouch.pageY);
			Laya.stage._canvasTransform.invertTransformPoint(mousePoint);
			var posX=mousePoint.x;
			var posY=mousePoint.y;
			switch (flag){
				case 0:
					this._touches.add(touch);
					offsetX+=posX;
					offsetY+=posY;
					break ;
				case 1:
					this._touches.remove(touch);
					offsetX-=posX;
					offsetY-=posY;
					break ;
				case 2:
					offsetX=posX-pos.x;
					offsetY=posY-pos.y;
					break ;
				}
			pos.x=posX;
			pos.y=posY;
		};
		var touchCount=this._touches.length;
		if (touchCount===0){
			this._mouseTouch.mousePositionX=0;
			this._mouseTouch.mousePositionY=0;
			}else {
			this._mouseTouch.mousePositionX=(this._mouseTouch.mousePositionX *lastCount+offsetX)/ touchCount;
			this._mouseTouch.mousePositionY=(this._mouseTouch.mousePositionY *lastCount+offsetY)/ touchCount;
		}
	}

	/**
	*@private
	*/
	__proto._update=function(){
		var i=0,n=0,j=0,m=0;
		n=this._eventList.length;
		var cameras=this._scene._cameraPool;
		if (n > 0){
			for (i=0;i < n;i++){
				var e=this._eventList[i];
				switch (e.type){
					case "mousedown":
						this._mouseTouchDown();
						break ;
					case "mouseup":
						this._mouseTouchUp();
						break ;
					case "mousemove":;
						var mousePoint=Input3D._tempPoint;
						mousePoint.setTo(e.pageX,e.pageY);
						Laya.stage._canvasTransform.invertTransformPoint(mousePoint);
						this._mouseTouch.mousePositionX=mousePoint.x;
						this._mouseTouch.mousePositionY=mousePoint.y;
						this._mouseTouchRayCast(cameras);
						break ;
					case "touchstart":;
						var lastLength=this._touches.length;
						this._changeTouches(e.changedTouches,0);
						this._mouseTouchRayCast(cameras);
						(lastLength===0)&& (this._mouseTouchDown());
						break ;
					case "touchend":
					case "touchcancel":
						this._changeTouches(e.changedTouches,1);
						(this._touches.length===0)&& (this._mouseTouchUp());
						break ;
					case "touchmove":
						this._changeTouches(e.changedTouches,2);
						this._mouseTouchRayCast(cameras);
						break ;
					default :
						throw "Input3D:unkonwn event type.";
					}
			}
			this._eventList.length=0;
		};
		var mouseTouch=this._mouseTouch;
		var pressedSprite=mouseTouch._pressedSprite;
		if (pressedSprite && (Stat.loopCount > mouseTouch._pressedLoopCount)){
			var pressedScripts=pressedSprite._scripts;
			if (pressedScripts){
				for (j=0,m=pressedScripts.length;j < m;j++)
				pressedScripts[j].onMouseDrag();
			}
		};
		var touchSprite=mouseTouch.sprite;
		if (touchSprite){
			var scripts=touchSprite._scripts;
			if (scripts){
				for (j=0,m=scripts.length;j < m;j++)
				scripts[j].onMouseOver();
			}
		}
	}

	/**
	*获取触摸点。
	*@param index 索引。
	*@return 触摸点。
	*/
	__proto.getTouch=function(index){
		if (index < this._touches.length){
			return this._touches.elements [index];
			}else {
			return null;
		}
	}

	/**
	*设置是否可以使用多点触摸。
	*@param 是否可以使用多点触摸。
	*/
	/**
	*获取是否可以使用多点触摸。
	*@return 是否可以使用多点触摸。
	*/
	__getset(0,__proto,'multiTouchEnabled',function(){
		return this._multiTouchEnabled;
		},function(value){
		this._multiTouchEnabled=value;
	});

	__static(Input3D,
	['_tempPoint',function(){return this._tempPoint=new Point();},'_tempVector20',function(){return this._tempVector20=new Vector2();},'_tempRay0',function(){return this._tempRay0=new Ray(new Vector3(),new Vector3());},'_tempHitResult0',function(){return this._tempHitResult0=new HitResult();}
	]);
	return Input3D;
})()


/**
*@private
*/
//class laya.d3.core.particleShuriKen.ShurikenParticleData
var ShurikenParticleData=(function(){
	function ShurikenParticleData(){}
	__class(ShurikenParticleData,'laya.d3.core.particleShuriKen.ShurikenParticleData');
	ShurikenParticleData._getStartLifetimeFromGradient=function(startLifeTimeGradient,emissionTime){
		for (var i=1,n=startLifeTimeGradient.gradientCount;i < n;i++){
			var key=startLifeTimeGradient.getKeyByIndex(i);
			if (key >=emissionTime){
				var lastKey=startLifeTimeGradient.getKeyByIndex(i-1);
				var age=(emissionTime-lastKey)/ (key-lastKey);
				return MathUtil.lerp(startLifeTimeGradient.getValueByIndex(i-1),startLifeTimeGradient.getValueByIndex(i),age)
			}
		}
		throw new Error("ShurikenParticleData: can't get value foam startLifeTimeGradient.");
	}

	ShurikenParticleData._randomInvertRoationArray=function(rotatonE,outE,randomizeRotationDirection,rand,randomSeeds){
		var randDic=NaN;
		if (rand){
			rand.seed=randomSeeds[6];
			randDic=rand.getFloat();
			randomSeeds[6]=rand.seed;
			}else {
			randDic=Math.random();
		}
		if (randDic < randomizeRotationDirection){
			outE.x=-rotatonE.x;
			outE.y=-rotatonE.y;
			outE.z=-rotatonE.z;
			}else {
			outE.x=rotatonE.x;
			outE.y=rotatonE.y;
			outE.z=rotatonE.z;
		}
	}

	ShurikenParticleData._randomInvertRoation=function(rotaton,randomizeRotationDirection,rand,randomSeeds){
		var randDic=NaN;
		if (rand){
			rand.seed=randomSeeds[6];
			randDic=rand.getFloat();
			randomSeeds[6]=rand.seed;
			}else {
			randDic=Math.random();
		}
		if (randDic < randomizeRotationDirection)
			rotaton=-rotaton;
		return rotaton;
	}

	ShurikenParticleData.create=function(particleSystem,particleRender,transform){
		var autoRandomSeed=particleSystem.autoRandomSeed;
		var rand=particleSystem._rand;
		var randomSeeds=particleSystem._randomSeeds;
		switch (particleSystem.startColorType){
			case 0:;
				var constantStartColor=particleSystem.startColorConstant;
				ShurikenParticleData.startColor.x=constantStartColor.x;
				ShurikenParticleData.startColor.y=constantStartColor.y;
				ShurikenParticleData.startColor.z=constantStartColor.z;
				ShurikenParticleData.startColor.w=constantStartColor.w;
				break ;
			case 2:
				if (autoRandomSeed){
					Vector4.lerp(particleSystem.startColorConstantMin,particleSystem.startColorConstantMax,Math.random(),ShurikenParticleData.startColor);
					}else {
					rand.seed=randomSeeds[3];
					Vector4.lerp(particleSystem.startColorConstantMin,particleSystem.startColorConstantMax,rand.getFloat(),ShurikenParticleData.startColor);
					randomSeeds[3]=rand.seed;
				}
				break ;
			};
		var colorOverLifetime=particleSystem.colorOverLifetime;
		if (colorOverLifetime && colorOverLifetime.enbale){
			var color=colorOverLifetime.color;
			switch (color.type){
				case 0:
					ShurikenParticleData.startColor.x=ShurikenParticleData.startColor.x *color.constant.x;
					ShurikenParticleData.startColor.y=ShurikenParticleData.startColor.y *color.constant.y;
					ShurikenParticleData.startColor.z=ShurikenParticleData.startColor.z *color.constant.z;
					ShurikenParticleData.startColor.w=ShurikenParticleData.startColor.w *color.constant.w;
					break ;
				case 2:;
					var colorRandom=NaN;
					if (autoRandomSeed){
						colorRandom=Math.random();
						}else {
						rand.seed=randomSeeds[10];
						colorRandom=rand.getFloat();
						randomSeeds[10]=rand.seed;
					};
					var minConstantColor=color.constantMin;
					var maxConstantColor=color.constantMax;
					ShurikenParticleData.startColor.x=ShurikenParticleData.startColor.x *MathUtil.lerp(minConstantColor.x,maxConstantColor.x,colorRandom);
					ShurikenParticleData.startColor.y=ShurikenParticleData.startColor.y *MathUtil.lerp(minConstantColor.y,maxConstantColor.y,colorRandom);
					ShurikenParticleData.startColor.z=ShurikenParticleData.startColor.z *MathUtil.lerp(minConstantColor.z,maxConstantColor.z,colorRandom);
					ShurikenParticleData.startColor.w=ShurikenParticleData.startColor.w *MathUtil.lerp(minConstantColor.w,maxConstantColor.w,colorRandom);
					break ;
				}
		};
		var particleSize=ShurikenParticleData.startSize;
		switch (particleSystem.startSizeType){
			case 0:
				if (particleSystem.threeDStartSize){
					var startSizeConstantSeparate=particleSystem.startSizeConstantSeparate;
					particleSize[0]=startSizeConstantSeparate.x;
					particleSize[1]=startSizeConstantSeparate.y;
					particleSize[2]=startSizeConstantSeparate.z;
					}else {
					particleSize[0]=particleSize[1]=particleSize[2]=particleSystem.startSizeConstant;
				}
				break ;
			case 2:
				if (particleSystem.threeDStartSize){
					var startSizeConstantMinSeparate=particleSystem.startSizeConstantMinSeparate;
					var startSizeConstantMaxSeparate=particleSystem.startSizeConstantMaxSeparate;
					if (autoRandomSeed){
						particleSize[0]=MathUtil.lerp(startSizeConstantMinSeparate.x,startSizeConstantMaxSeparate.x,Math.random());
						particleSize[1]=MathUtil.lerp(startSizeConstantMinSeparate.y,startSizeConstantMaxSeparate.y,Math.random());
						particleSize[2]=MathUtil.lerp(startSizeConstantMinSeparate.z,startSizeConstantMaxSeparate.z,Math.random());
						}else {
						rand.seed=randomSeeds[4];
						particleSize[0]=MathUtil.lerp(startSizeConstantMinSeparate.x,startSizeConstantMaxSeparate.x,rand.getFloat());
						particleSize[1]=MathUtil.lerp(startSizeConstantMinSeparate.y,startSizeConstantMaxSeparate.y,rand.getFloat());
						particleSize[2]=MathUtil.lerp(startSizeConstantMinSeparate.z,startSizeConstantMaxSeparate.z,rand.getFloat());
						randomSeeds[4]=rand.seed;
					}
					}else {
					if (autoRandomSeed){
						particleSize[0]=particleSize[1]=particleSize[2]=MathUtil.lerp(particleSystem.startSizeConstantMin,particleSystem.startSizeConstantMax,Math.random());
						}else {
						rand.seed=randomSeeds[4];
						particleSize[0]=particleSize[1]=particleSize[2]=MathUtil.lerp(particleSystem.startSizeConstantMin,particleSystem.startSizeConstantMax,rand.getFloat());
						randomSeeds[4]=rand.seed;
					}
				}
				break ;
			};
		var sizeOverLifetime=particleSystem.sizeOverLifetime;
		if (sizeOverLifetime && sizeOverLifetime.enbale && sizeOverLifetime.size.type===1){
			var size=sizeOverLifetime.size;
			if (size.separateAxes){
				if (autoRandomSeed){
					particleSize[0]=particleSize[0] *MathUtil.lerp(size.constantMinSeparate.x,size.constantMaxSeparate.x,Math.random());
					particleSize[1]=particleSize[1] *MathUtil.lerp(size.constantMinSeparate.y,size.constantMaxSeparate.y,Math.random());
					particleSize[2]=particleSize[2] *MathUtil.lerp(size.constantMinSeparate.z,size.constantMaxSeparate.z,Math.random());
					}else {
					rand.seed=randomSeeds[11];
					particleSize[0]=particleSize[0] *MathUtil.lerp(size.constantMinSeparate.x,size.constantMaxSeparate.x,rand.getFloat());
					particleSize[1]=particleSize[1] *MathUtil.lerp(size.constantMinSeparate.y,size.constantMaxSeparate.y,rand.getFloat());
					particleSize[2]=particleSize[2] *MathUtil.lerp(size.constantMinSeparate.z,size.constantMaxSeparate.z,rand.getFloat());
					randomSeeds[11]=rand.seed;
				}
				}else {
				var randomSize=NaN;
				if (autoRandomSeed){
					randomSize=MathUtil.lerp(size.constantMin,size.constantMax,Math.random());
					}else {
					rand.seed=randomSeeds[11];
					randomSize=MathUtil.lerp(size.constantMin,size.constantMax,rand.getFloat());
					randomSeeds[11]=rand.seed;
				}
				particleSize[0]=particleSize[0] *randomSize;
				particleSize[1]=particleSize[1] *randomSize;
				particleSize[2]=particleSize[2] *randomSize;
			}
		};
		var renderMode=particleRender.renderMode;
		if (renderMode!==1){
			switch (particleSystem.startRotationType){
				case 0:
					if (particleSystem.threeDStartRotation){
						var startRotationConstantSeparate=particleSystem.startRotationConstantSeparate;
						var randomRotationE=ShurikenParticleData._tempVector30;
						ShurikenParticleData._randomInvertRoationArray(startRotationConstantSeparate,randomRotationE,particleSystem.randomizeRotationDirection,autoRandomSeed ? null :rand,randomSeeds);
						ShurikenParticleData.startRotation[0]=randomRotationE.x;
						ShurikenParticleData.startRotation[1]=randomRotationE.y;
						if (renderMode!==4)
							ShurikenParticleData.startRotation[2]=-randomRotationE.z;
						else
						ShurikenParticleData.startRotation[2]=randomRotationE.z;
						}else {
						ShurikenParticleData.startRotation[0]=ShurikenParticleData._randomInvertRoation(particleSystem.startRotationConstant,particleSystem.randomizeRotationDirection,autoRandomSeed ? null :rand,randomSeeds);
						ShurikenParticleData.startRotation[1]=0;
						ShurikenParticleData.startRotation[2]=0;
					}
					break ;
				case 2:
					if (particleSystem.threeDStartRotation){
						var startRotationConstantMinSeparate=particleSystem.startRotationConstantMinSeparate;
						var startRotationConstantMaxSeparate=particleSystem.startRotationConstantMaxSeparate;
						var lerpRoationE=ShurikenParticleData._tempVector30;
						if (autoRandomSeed){
							lerpRoationE.x=MathUtil.lerp(startRotationConstantMinSeparate.x,startRotationConstantMaxSeparate.x,Math.random());
							lerpRoationE.y=MathUtil.lerp(startRotationConstantMinSeparate.y,startRotationConstantMaxSeparate.y,Math.random());
							lerpRoationE.z=MathUtil.lerp(startRotationConstantMinSeparate.z,startRotationConstantMaxSeparate.z,Math.random());
							}else {
							rand.seed=randomSeeds[5];
							lerpRoationE.x=MathUtil.lerp(startRotationConstantMinSeparate.x,startRotationConstantMaxSeparate.x,rand.getFloat());
							lerpRoationE.y=MathUtil.lerp(startRotationConstantMinSeparate.y,startRotationConstantMaxSeparate.y,rand.getFloat());
							lerpRoationE.z=MathUtil.lerp(startRotationConstantMinSeparate.z,startRotationConstantMaxSeparate.z,rand.getFloat());
							randomSeeds[5]=rand.seed;
						}
						ShurikenParticleData._randomInvertRoationArray(lerpRoationE,lerpRoationE,particleSystem.randomizeRotationDirection,autoRandomSeed ? null :rand,randomSeeds);
						ShurikenParticleData.startRotation[0]=lerpRoationE.x;
						ShurikenParticleData.startRotation[1]=lerpRoationE.y;
						if (renderMode!==4)
							ShurikenParticleData.startRotation[2]=-lerpRoationE.z;
						else
						ShurikenParticleData.startRotation[2]=lerpRoationE.z;
						}else {
						if (autoRandomSeed){
							ShurikenParticleData.startRotation[0]=ShurikenParticleData._randomInvertRoation(MathUtil.lerp(particleSystem.startRotationConstantMin,particleSystem.startRotationConstantMax,Math.random()),particleSystem.randomizeRotationDirection,autoRandomSeed ? null :rand,randomSeeds);
							}else {
							rand.seed=randomSeeds[5];
							ShurikenParticleData.startRotation[0]=ShurikenParticleData._randomInvertRoation(MathUtil.lerp(particleSystem.startRotationConstantMin,particleSystem.startRotationConstantMax,rand.getFloat()),particleSystem.randomizeRotationDirection,autoRandomSeed ? null :rand,randomSeeds);
							randomSeeds[5]=rand.seed;
						}
					}
					break ;
				}
		}
		switch (particleSystem.startLifetimeType){
			case 0:
				ShurikenParticleData.startLifeTime=particleSystem.startLifetimeConstant;
				break ;
			case 1:
				ShurikenParticleData.startLifeTime=ShurikenParticleData._getStartLifetimeFromGradient(particleSystem.startLifeTimeGradient,particleSystem.emissionTime);
				break ;
			case 2:
				if (autoRandomSeed){
					ShurikenParticleData.startLifeTime=MathUtil.lerp(particleSystem.startLifetimeConstantMin,particleSystem.startLifetimeConstantMax,Math.random());
					}else {
					rand.seed=randomSeeds[7];
					ShurikenParticleData.startLifeTime=MathUtil.lerp(particleSystem.startLifetimeConstantMin,particleSystem.startLifetimeConstantMax,rand.getFloat());
					randomSeeds[7]=rand.seed;
				}
				break ;
			case 3:;
				var emissionTime=particleSystem.emissionTime;
				if (autoRandomSeed){
					ShurikenParticleData.startLifeTime=MathUtil.lerp(ShurikenParticleData._getStartLifetimeFromGradient(particleSystem.startLifeTimeGradientMin,emissionTime),ShurikenParticleData._getStartLifetimeFromGradient(particleSystem.startLifeTimeGradientMax,emissionTime),Math.random());
					}else {
					rand.seed=randomSeeds[7];
					ShurikenParticleData.startLifeTime=MathUtil.lerp(ShurikenParticleData._getStartLifetimeFromGradient(particleSystem.startLifeTimeGradientMin,emissionTime),ShurikenParticleData._getStartLifetimeFromGradient(particleSystem.startLifeTimeGradientMax,emissionTime),rand.getFloat());
					randomSeeds[7]=rand.seed;
				}
				break ;
			}
		switch (particleSystem.startSpeedType){
			case 0:
				ShurikenParticleData.startSpeed=particleSystem.startSpeedConstant;
				break ;
			case 2:
				if (autoRandomSeed){
					ShurikenParticleData.startSpeed=MathUtil.lerp(particleSystem.startSpeedConstantMin,particleSystem.startSpeedConstantMax,Math.random());
					}else {
					rand.seed=randomSeeds[8];
					ShurikenParticleData.startSpeed=MathUtil.lerp(particleSystem.startSpeedConstantMin,particleSystem.startSpeedConstantMax,rand.getFloat());
					randomSeeds[8]=rand.seed;
				}
				break ;
			};
		var textureSheetAnimation=particleSystem.textureSheetAnimation;
		var enableSheetAnimation=textureSheetAnimation && textureSheetAnimation.enable;
		if (enableSheetAnimation){
			var title=textureSheetAnimation.tiles;
			var titleX=title.x,titleY=title.y;
			var subU=1.0 / titleX,subV=1.0 / titleY;
			var startFrameCount=0;
			var startFrame=textureSheetAnimation.startFrame;
			switch (startFrame.type){
				case 0:
					startFrameCount=startFrame.constant;
					break ;
				case 1:
					if (autoRandomSeed){
						startFrameCount=MathUtil.lerp(startFrame.constantMin,startFrame.constantMax,Math.random());
						}else {
						rand.seed=randomSeeds[14];
						startFrameCount=MathUtil.lerp(startFrame.constantMin,startFrame.constantMax,rand.getFloat());
						randomSeeds[14]=rand.seed;
					}
					break ;
				};
			var frame=textureSheetAnimation.frame;
			switch (frame.type){
				case 0:
					startFrameCount+=frame.constant;
					break ;
				case 2:
					if (autoRandomSeed){
						startFrameCount+=MathUtil.lerp(frame.constantMin,frame.constantMax,Math.random());
						}else {
						rand.seed=randomSeeds[15];
						startFrameCount+=MathUtil.lerp(frame.constantMin,frame.constantMax,rand.getFloat());
						randomSeeds[15]=rand.seed;
					}
					break ;
				};
			var startRow=0;
			switch (textureSheetAnimation.type){
				case 0:
					startRow=Math.floor(startFrameCount / titleX);
					break ;
				case 1:
					if (textureSheetAnimation.randomRow){
						if (autoRandomSeed){
							startRow=Math.floor(Math.random()*titleY);
							}else {
							rand.seed=randomSeeds[13];
							startRow=Math.floor(rand.getFloat()*titleY);
							randomSeeds[13]=rand.seed;
						}
						}else {
						startRow=textureSheetAnimation.rowIndex;
					}
					break ;
				};
			var startCol=Math.floor(startFrameCount % titleX);
			ShurikenParticleData.startUVInfo=ShurikenParticleData.startUVInfo;
			ShurikenParticleData.startUVInfo[0]=subU;
			ShurikenParticleData.startUVInfo[1]=subV;
			ShurikenParticleData.startUVInfo[2]=startCol *subU;
			ShurikenParticleData.startUVInfo[3]=startRow *subV;
			}else {
			ShurikenParticleData.startUVInfo=ShurikenParticleData.startUVInfo;
			ShurikenParticleData.startUVInfo[0]=1.0;
			ShurikenParticleData.startUVInfo[1]=1.0;
			ShurikenParticleData.startUVInfo[2]=0.0;
			ShurikenParticleData.startUVInfo[3]=0.0;
		}
		switch (particleSystem.simulationSpace){
			case 0:;
				var position=transform.position;
				ShurikenParticleData.simulationWorldPostion[0]=position.x;
				ShurikenParticleData.simulationWorldPostion[1]=position.y;
				ShurikenParticleData.simulationWorldPostion[2]=position.z;
				var rotation=transform.rotation;
				ShurikenParticleData.simulationWorldRotation[0]=rotation.x;
				ShurikenParticleData.simulationWorldRotation[1]=rotation.y;
				ShurikenParticleData.simulationWorldRotation[2]=rotation.z;
				ShurikenParticleData.simulationWorldRotation[3]=rotation.w;
				break ;
			case 1:
				break ;
			default :
				throw new Error("ShurikenParticleMaterial: SimulationSpace value is invalid.");
				break ;
			}
	}

	ShurikenParticleData.startLifeTime=NaN;
	ShurikenParticleData.startSpeed=NaN;
	__static(ShurikenParticleData,
	['_tempVector30',function(){return this._tempVector30=new Vector3();},'_tempQuaternion',function(){return this._tempQuaternion=new Quaternion();},'startColor',function(){return this.startColor=new Vector4();},'startSize',function(){return this.startSize=new Float32Array(3);},'startRotation',function(){return this.startRotation=new Float32Array(3);},'startUVInfo',function(){return this.startUVInfo=new Float32Array(4);},'simulationWorldPostion',function(){return this.simulationWorldPostion=new Float32Array(3);},'simulationWorldRotation',function(){return this.simulationWorldRotation=new Float32Array(4);}
	]);
	return ShurikenParticleData;
})()


/**
*<code>BoundsOctreeNode</code> 类用于创建八叉树节点。
*/
//class laya.d3.core.scene.BoundsOctreeNode
var BoundsOctreeNode=(function(){
	function BoundsOctreeNode(octree,parent,baseLength,center){
		/**@private */
		this._octree=null;
		/**@private */
		this._parent=null;
		/**@private */
		this._children=null;
		/**@private [Debug]*/
		this._isContaion=false;
		/**@private [只读]*/
		this.baseLength=0.0;
		this._bounds=new BoundBox(new Vector3(),new Vector3());
		this._objects=[];
		this.center=new Vector3();
		this._setValues(octree,parent,baseLength,center);
	}

	__class(BoundsOctreeNode,'laya.d3.core.scene.BoundsOctreeNode');
	var __proto=BoundsOctreeNode.prototype;
	/**
	*@private
	*/
	__proto._setValues=function(octree,parent,baseLength,center){
		this._octree=octree;
		this._parent=parent;
		this.baseLength=baseLength;
		center.cloneTo(this.center);
		var min=this._bounds.min;
		var max=this._bounds.max;
		var halfSize=(octree._looseness *baseLength)/ 2;
		min.setValue(center.x-halfSize,center.y-halfSize,center.z-halfSize);
		max.setValue(center.x+halfSize,center.y+halfSize,center.z+halfSize);
	}

	/**
	*@private
	*/
	__proto._getChildBound=function(index){
		if (this._children !=null && this._children[index]){
			return this._children[index]._bounds;
			}else {
			var quarter=this.baseLength / 4;
			var halfChildSize=((this.baseLength / 2)*this._octree._looseness)/ 2;
			var bounds=BoundsOctreeNode._tempBoundBox;
			var min=bounds.min;
			var max=bounds.max;
			switch (index){
				case 0:
					min.x=this.center.x-quarter-halfChildSize;
					min.y=this.center.y+quarter-halfChildSize;
					min.z=this.center.z-quarter-halfChildSize;
					max.x=this.center.x-quarter+halfChildSize;
					max.y=this.center.y+quarter+halfChildSize;
					max.z=this.center.z-quarter+halfChildSize;
					break ;
				case 1:
					min.x=this.center.x+quarter-halfChildSize;
					min.y=this.center.y+quarter-halfChildSize;
					min.z=this.center.z-quarter-halfChildSize;
					max.x=this.center.x+quarter+halfChildSize;
					max.y=this.center.y+quarter+halfChildSize;
					max.z=this.center.z-quarter+halfChildSize;
					break ;
				case 2:
					min.x=this.center.x-quarter-halfChildSize;
					min.y=this.center.y+quarter-halfChildSize;
					min.z=this.center.z+quarter-halfChildSize;
					max.x=this.center.x-quarter+halfChildSize;
					max.y=this.center.y+quarter+halfChildSize;
					max.z=this.center.z+quarter+halfChildSize;
					break ;
				case 3:
					min.x=this.center.x+quarter-halfChildSize;
					min.y=this.center.y+quarter-halfChildSize;
					min.z=this.center.z+quarter-halfChildSize;
					max.x=this.center.x+quarter+halfChildSize;
					max.y=this.center.y+quarter+halfChildSize;
					max.z=this.center.z+quarter+halfChildSize;
					break ;
				case 4:
					min.x=this.center.x-quarter-halfChildSize;
					min.y=this.center.y-quarter-halfChildSize;
					min.z=this.center.z-quarter-halfChildSize;
					max.x=this.center.x-quarter+halfChildSize;
					max.y=this.center.y-quarter+halfChildSize;
					max.z=this.center.z-quarter+halfChildSize;
					break ;
				case 5:
					min.x=this.center.x+quarter-halfChildSize;
					min.y=this.center.y-quarter-halfChildSize;
					min.z=this.center.z-quarter-halfChildSize;
					max.x=this.center.x+quarter+halfChildSize;
					max.y=this.center.y-quarter+halfChildSize;
					max.z=this.center.z-quarter+halfChildSize;
					break ;
				case 6:
					min.x=this.center.x-quarter-halfChildSize;
					min.y=this.center.y-quarter-halfChildSize;
					min.z=this.center.z+quarter-halfChildSize;
					max.x=this.center.x-quarter+halfChildSize;
					max.y=this.center.y-quarter+halfChildSize;
					max.z=this.center.z+quarter+halfChildSize;
					break ;
				case 7:
					min.x=this.center.x+quarter-halfChildSize;
					min.y=this.center.y-quarter-halfChildSize;
					min.z=this.center.z+quarter-halfChildSize;
					max.x=this.center.x+quarter+halfChildSize;
					max.y=this.center.y-quarter+halfChildSize;
					max.z=this.center.z+quarter+halfChildSize;
					break ;
				default :
				}
			return bounds;
		}
	}

	/**
	*@private
	*/
	__proto._getChildCenter=function(index){
		if (this._children !=null){
			return this._children[index].center;
			}else {
			var quarter=this.baseLength / 4;
			var childCenter=BoundsOctreeNode._tempVector30;
			switch (index){
				case 0:
					childCenter.x=this.center.x-quarter;
					childCenter.y=this.center.y+quarter;
					childCenter.z=this.center.z-quarter;
					break ;
				case 1:
					childCenter.x=this.center.x+quarter;
					childCenter.y=this.center.y+quarter;
					childCenter.z=this.center.z-quarter;
					break ;
				case 2:
					childCenter.x=this.center.x-quarter;
					childCenter.y=this.center.y+quarter;
					childCenter.z=this.center.z+quarter;
					break ;
				case 3:
					childCenter.x=this.center.x+quarter;
					childCenter.y=this.center.y+quarter;
					childCenter.z=this.center.z+quarter;
					break ;
				case 4:
					childCenter.x=this.center.x-quarter;
					childCenter.y=this.center.y-quarter;
					childCenter.z=this.center.z-quarter;
					break ;
				case 5:
					childCenter.x=this.center.x+quarter;
					childCenter.y=this.center.y-quarter;
					childCenter.z=this.center.z-quarter;
					break ;
				case 6:
					childCenter.x=this.center.x-quarter;
					childCenter.y=this.center.y-quarter;
					childCenter.z=this.center.z+quarter;
					break ;
				case 7:
					childCenter.x=this.center.x+quarter;
					childCenter.y=this.center.y-quarter;
					childCenter.z=this.center.z+quarter;
					break ;
				default :
				}
			return childCenter;
		}
	}

	/**
	*@private
	*/
	__proto._getChild=function(index){
		var quarter=this.baseLength / 4;
		this._children || (this._children=__newvec(8,null));
		switch (index){
			case 0:
				return this._children[0] || (this._children[0]=new BoundsOctreeNode(this._octree,this,this.baseLength / 2,new Vector3(this.center.x+-quarter,this.center.y+quarter,this.center.z-quarter)));
			case 1:
				return this._children[1] || (this._children[1]=new BoundsOctreeNode(this._octree,this,this.baseLength / 2,new Vector3(this.center.x+quarter,this.center.y+quarter,this.center.z-quarter)));
			case 2:
				return this._children[2] || (this._children[2]=new BoundsOctreeNode(this._octree,this,this.baseLength / 2,new Vector3(this.center.x-quarter,this.center.y+quarter,this.center.z+quarter)));
			case 3:
				return this._children[3] || (this._children[3]=new BoundsOctreeNode(this._octree,this,this.baseLength / 2,new Vector3(this.center.x+quarter,this.center.y+quarter,this.center.z+quarter)));
			case 4:
				return this._children[4] || (this._children[4]=new BoundsOctreeNode(this._octree,this,this.baseLength / 2,new Vector3(this.center.x-quarter,this.center.y-quarter,this.center.z-quarter)));
			case 5:
				return this._children[5] || (this._children[5]=new BoundsOctreeNode(this._octree,this,this.baseLength / 2,new Vector3(this.center.x+quarter,this.center.y-quarter,this.center.z-quarter)));
			case 6:
				return this._children[6] || (this._children[6]=new BoundsOctreeNode(this._octree,this,this.baseLength / 2,new Vector3(this.center.x-quarter,this.center.y-quarter,this.center.z+quarter)));
			case 7:
				return this._children[7] || (this._children[7]=new BoundsOctreeNode(this._octree,this,this.baseLength / 2,new Vector3(this.center.x+quarter,this.center.y-quarter,this.center.z+quarter)));
			default :
				throw "BoundsOctreeNode: unknown index.";
			}
	}

	/**
	*@private
	*是否合并判断(如果该节点和子节点包含的物体小于_NUM_OBJECTS_ALLOWED则应将子节点合并到该节点)
	*/
	__proto._shouldMerge=function(){
		var objectCount=this._objects.length;
		for (var i=0;i < 8;i++){
			var child=this._children[i];
			if (child){
				if (child._children !=null)
					return false;
				objectCount+=child._objects.length;
			}
		}
		return objectCount <=8;
	}

	/**
	*@private
	*/
	__proto._mergeChildren=function(){
		for (var i=0;i < 8;i++){
			var child=this._children[i];
			if (child){
				child._parent=null;
				var childObjects=child._objects;
				for (var j=childObjects.length-1;j >=0;j--){
					var childObject=childObjects[j];
					this._objects.push(childObject);
					childObject._setOctreeNode(this);
				}
			}
		}
		this._children=null;
	}

	/**
	*@private
	*/
	__proto._merge=function(){
		if (this._children===null){
			var parent=this._parent;
			if (parent && parent._shouldMerge()){
				parent._mergeChildren();
				parent._merge();
			}
		}
	}

	/**
	*@private
	*/
	__proto._checkAddNode=function(object){
		if (this._children==null){
			if (this._objects.length < 8 || (this.baseLength / 2)< this._octree._minSize){
				return this;
			}
			for (var i=this._objects.length-1;i >=0;i--){
				var existObject=this._objects[i];
				var fitChildIndex=this._bestFitChild(existObject.bounds.getCenter());
				if (BoundsOctreeNode._encapsulates(this._getChildBound(fitChildIndex),existObject.bounds._getBoundBox())){
					this._objects.splice(this._objects.indexOf(existObject),1);
					this._getChild(fitChildIndex)._add(existObject);
				}
			}
		};
		var newFitChildIndex=this._bestFitChild(object.bounds.getCenter());
		if (BoundsOctreeNode._encapsulates(this._getChildBound(newFitChildIndex),object.bounds._getBoundBox()))
			return this._getChild(newFitChildIndex)._checkAddNode(object);
		else
		return this;
	}

	/**
	*@private
	*/
	__proto._add=function(object){
		var addNode=this._checkAddNode(object);
		addNode._objects.push(object);
		object._setOctreeNode(addNode);
	}

	/**
	*@private
	*/
	__proto._remove=function(object){
		var index=this._objects.indexOf(object);
		this._objects.splice(index,1);
		object._setOctreeNode(null);
		this._merge();
	}

	/**
	*@private
	*/
	__proto._addUp=function(object){
		if ((CollisionUtils.boxContainsBox(this._bounds,object.bounds._getBoundBox())===/*laya.d3.math.ContainmentType.Contains*/1)){
			this._add(object);
			return true;
			}else {
			if (this._parent)
				return this._parent._addUp(object);
			else
			return false;
		}
	}

	/**
	*@private
	*/
	__proto._getCollidingWithFrustum=function(context,frustum,testVisible,camPos){
		if (testVisible){
			var type=frustum.containsBoundBox(this._bounds);
			Stat.octreeNodeCulling++;
			if (type===/*laya.d3.math.ContainmentType.Disjoint*/0)
				return;
			testVisible=(type===/*laya.d3.math.ContainmentType.Intersects*/2);
		}
		this._isContaion=!testVisible;
		var camera=context.camera;
		var scene=context.scene;
		for (var i=0,n=this._objects.length;i < n;i++){
			var render=this._objects [i];
			if (camera._isLayerVisible(render._owner.layer)&& render._enable){
				if (testVisible){
					Stat.frustumCulling++;
					if (!render._needRender(frustum))
						continue ;
				}
				render._distanceForSort=Vector3.distance(render.bounds.getCenter(),camPos);
				var elements=render._renderElements;
				for (var j=0,m=elements.length;j < m;j++){
					var element=elements[j];
					var renderQueue=scene._getRenderQueue(element.material.renderQueue);
					if (renderQueue.isTransparent)
						element.addToTransparentRenderQueue(context,renderQueue);
					else
					element.addToOpaqueRenderQueue(context,renderQueue);
				}
			}
		}
		if (this._children !=null){
			for (i=0;i < 8;i++){
				var child=this._children[i];
				child && child._getCollidingWithFrustum(context,frustum,testVisible,camPos);
			}
		}
	}

	/**
	*@private
	*/
	__proto._getCollidingWithBoundBox=function(checkBound,testVisible,result){
		if (testVisible){
			var type=CollisionUtils.boxContainsBox(this._bounds,checkBound);
			if (type===/*laya.d3.math.ContainmentType.Disjoint*/0)
				return;
			testVisible=(type===/*laya.d3.math.ContainmentType.Intersects*/2);
		}
		if (testVisible){
			for (var i=0,n=this._objects.length;i < n;i++){
				var object=this._objects[i];
				if (CollisionUtils.intersectsBoxAndBox(object.bounds._getBoundBox(),checkBound)){
					result.push(object);
				}
			}
		}
		if (this._children !=null){
			for (i=0;i < 8;i++){
				var child=this._children[i];
				child._getCollidingWithBoundBox(checkBound,testVisible,result);
			}
		}
	}

	/**
	*@private
	*/
	__proto._bestFitChild=function(boundCenter){
		return (boundCenter.x <=this.center.x ? 0 :1)+(boundCenter.y >=this.center.y ? 0 :4)+(boundCenter.z <=this.center.z ? 0 :2);
	}

	/**
	*@private
	*@return 是否需要扩充根节点
	*/
	__proto._update=function(object){
		if (CollisionUtils.boxContainsBox(this._bounds,object.bounds._getBoundBox())===/*laya.d3.math.ContainmentType.Contains*/1){
			var addNode=this._checkAddNode(object);
			if (addNode!==object._getOctreeNode()){
				addNode._objects.push(object);
				object._setOctreeNode(addNode);
				var index=this._objects.indexOf(object);
				this._objects.splice(index,1);
				this._merge();
			}
			return true;
			}else {
			if (this._parent){
				var sucess=this._parent._addUp(object);
				if (sucess){
					index=this._objects.indexOf(object);
					this._objects.splice(index,1);
					this._merge();
				}
				return sucess;
				}else {
				return false;
			}
		}
	}

	/**
	*添加指定物体。
	*@param object 指定物体。
	*/
	__proto.add=function(object){
		if (!BoundsOctreeNode._encapsulates(this._bounds,object.bounds._getBoundBox()))
			return false;
		this._add(object);
		return true;
	}

	/**
	*移除指定物体。
	*@param obejct 指定物体。
	*@return 是否成功。
	*/
	__proto.remove=function(object){
		if (object._getOctreeNode()!==this)
			return false;
		this._remove(object);
		return true;
	}

	/**
	*更新制定物体，
	*@param obejct 指定物体。
	*@return 是否成功。
	*/
	__proto.update=function(object){
		if (object._getOctreeNode()!==this)
			return false;
		return this._update(object);
	}

	/**
	*收缩八叉树节点。
	*-所有物体都在根节点的八分之一区域
	*-该节点无子节点或有子节点但1/8的子节点不包含物体
	*@param minLength 最小尺寸。
	*@return 新的根节点。
	*/
	__proto.shrinkIfPossible=function(minLength){
		if (this.baseLength < minLength *2)
			return this;
		var bestFit=-1;
		for (var i=0,n=this._objects.length;i < n;i++){
			var object=this._objects[i];
			var newBestFit=this._bestFitChild(object.bounds.getCenter());
			if (i==0 || newBestFit==bestFit){
				var childBounds=this._getChildBound(newBestFit);
				if (BoundsOctreeNode._encapsulates(childBounds,object.bounds._getBoundBox()))
					(i==0)&& (bestFit=newBestFit);
				else
				return this;
				}else {
				return this;
			}
		}
		if (this._children !=null){
			var childHadContent=false;
			for (i=0,n=this._children.length;i < n;i++){
				var child=this._children[i];
				if (child && child.hasAnyObjects()){
					if (childHadContent)
						return this;
					if (bestFit >=0 && bestFit !=i)
						return this;
					childHadContent=true;
					bestFit=i;
				}
			}
			}else {
			if (bestFit !=-1){
				var childCenter=this._getChildCenter(bestFit);
				this._setValues(this._octree,null,this.baseLength / 2,childCenter);
			}
			return this;
		}
		if (bestFit !=-1){
			var newRoot=this._children[bestFit];
			newRoot._parent=null;
			return newRoot;
			}else {
			return this;
		}
	}

	/**
	*检查该节点和其子节点是否包含任意物体。
	*@return 是否包含任意物体。
	*/
	__proto.hasAnyObjects=function(){
		if (this._objects.length > 0)
			return true;
		if (this._children !=null){
			for (var i=0;i < 8;i++){
				var child=this._children[i];
				if (child && child.hasAnyObjects())
					return true;
			}
		}
		return false;
	}

	/**
	*获取与指定包围盒相交的物体列表。
	*@param checkBound AABB包围盒。
	*@param result 相交物体列表
	*/
	__proto.getCollidingWithBoundBox=function(checkBound,result){
		this._getCollidingWithBoundBox(checkBound,true,result);
	}

	/**
	*获取与指定射线相交的的物理列表。
	*@param ray 射线。
	*@param result 相交物体列表。
	*@param maxDistance 射线的最大距离。
	*/
	__proto.getCollidingWithRay=function(ray,result,maxDistance){
		(maxDistance===void 0)&& (maxDistance=Number.MAX_VALUE);
		var distance=CollisionUtils.intersectsRayAndBoxRD(ray,this._bounds);
		if (distance==-1 || distance > maxDistance)
			return;
		for (var i=0,n=this._objects.length;i < n;i++){
			var object=this._objects[i];
			distance=CollisionUtils.intersectsRayAndBoxRD(ray,object.bounds._getBoundBox());
			if (distance!==-1 && distance <=maxDistance)
				result.push(object);
		}
		if (this._children !=null){
			for (i=0;i < 8;i++){
				var child=this._children[i];
				child.getCollidingWithRay(ray,result,maxDistance);
			}
		}
	}

	/**
	*获取与指定视锥相交的的物理列表。
	*@param ray 射线。.
	*@param result 相交物体列表。
	*/
	__proto.getCollidingWithFrustum=function(context){
		var cameraPos=context.camera.transform.position;
		var boundFrustum=(context.camera).boundFrustum;
		this._getCollidingWithFrustum(context,boundFrustum,true,cameraPos);
	}

	/**
	*获取是否与指定包围盒相交。
	*@param checkBound AABB包围盒。
	*@return 是否相交。
	*/
	__proto.isCollidingWithBoundBox=function(checkBound){
		if (!(CollisionUtils.intersectsBoxAndBox(this._bounds,checkBound)))
			return false;
		for (var i=0,n=this._objects.length;i < n;i++){
			var object=this._objects[i];
			if (CollisionUtils.intersectsBoxAndBox(object.bounds._getBoundBox(),checkBound))
				return true;
		}
		if (this._children !=null){
			for (i=0;i < 8;i++){
				var child=this._children[i];
				if (child.isCollidingWithBoundBox(checkBound))
					return true;
			}
		}
		return false;
	}

	/**
	*获取是否与指定射线相交。
	*@param ray 射线。
	*@param maxDistance 射线的最大距离。
	*@return 是否相交。
	*/
	__proto.isCollidingWithRay=function(ray,maxDistance){
		(maxDistance===void 0)&& (maxDistance=Number.MAX_VALUE);
		var distance=CollisionUtils.intersectsRayAndBoxRD(ray,this._bounds);
		if (distance==-1 || distance > maxDistance)
			return false;
		for (var i=0,n=this._objects.length;i < n;i++){
			var object=this._objects[i];
			distance=CollisionUtils.intersectsRayAndBoxRD(ray,object.bounds._getBoundBox());
			if (distance!==-1 && distance <=maxDistance)
				return true;
		}
		if (this._children !=null){
			for (i=0;i < 8;i++){
				var child=this._children[i];
				if (child.isCollidingWithRay(ray,maxDistance))
					return true;
			}
		}
		return false;
	}

	/**
	*获取包围盒。
	*/
	__proto.getBound=function(){
		return this._bounds;
	}

	/**
	*@private
	*[Debug]
	*/
	__proto.drawAllBounds=function(debugLine,currentDepth,maxDepth){
		if (this._children===null && this._objects.length==0)
			return;
		currentDepth++;
		var color=BoundsOctreeNode._tempColor0;
		if (this._isContaion){
			color.r=0.0;
			color.g=0.0;
			color.b=1.0;
			}else {
			var tint=maxDepth ? currentDepth / maxDepth :0;
			color.r=1.0-tint;
			color.g=tint;
			color.b=0.0;
		}
		color.a=0.3;
		Utils3D._drawBound(debugLine,this._bounds,color);
		if (this._children !=null){
			for (var i=0;i < 8;i++){
				var child=this._children[i];
				child && child.drawAllBounds(debugLine,currentDepth,maxDepth);
			}
		}
	}

	/**
	*@private
	*[Debug]
	*/
	__proto.drawAllObjects=function(debugLine,currentDepth,maxDepth){
		currentDepth++;
		var color=BoundsOctreeNode._tempColor0;
		if (this._isContaion){
			color.r=0.0;
			color.g=0.0;
			color.b=1.0;
			}else {
			var tint=maxDepth ? currentDepth / maxDepth :0;
			color.r=1.0-tint;
			color.g=tint;
			color.b=0.0;
		}
		color.a=1.0;
		for (var i=0,n=this._objects.length;i < n;i++)
		Utils3D._drawBound(debugLine,this._objects[i].bounds._getBoundBox(),color);
		if (this._children !=null){
			for (i=0;i < 8;i++){
				var child=this._children[i];
				child && child.drawAllObjects(debugLine,currentDepth,maxDepth);
			}
		}
	}

	BoundsOctreeNode._encapsulates=function(outerBound,innerBound){
		return CollisionUtils.boxContainsBox(outerBound,innerBound)==/*laya.d3.math.ContainmentType.Contains*/1;
	}

	BoundsOctreeNode._NUM_OBJECTS_ALLOWED=8;
	__static(BoundsOctreeNode,
	['_tempVector3',function(){return this._tempVector3=new Vector3();},'_tempVector30',function(){return this._tempVector30=new Vector3();},'_tempVector31',function(){return this._tempVector31=new Vector3();},'_tempColor0',function(){return this._tempColor0=new Color();},'_tempBoundBox',function(){return this._tempBoundBox=new BoundBox(new Vector3(),new Vector3());}
	]);
	return BoundsOctreeNode;
})()


/**
*<code>GradientDataVector2</code> 类用于创建二维向量渐变。
*/
//class laya.d3.core.particleShuriKen.module.GradientDataVector2
var GradientDataVector2=(function(){
	function GradientDataVector2(){
		/**@private */
		this._currentLength=0;
		/**@private 开发者禁止修改。*/
		this._elements=null;
		this._elements=new Float32Array(12);
	}

	__class(GradientDataVector2,'laya.d3.core.particleShuriKen.module.GradientDataVector2');
	var __proto=GradientDataVector2.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*增加二维向量渐变。
	*@param key 生命周期，范围为0到1。
	*@param value 二维向量值。
	*/
	__proto.add=function(key,value){
		if (this._currentLength < 8){
			if ((this._currentLength===6)&& ((key!==1))){
				key=1;
				console.log("GradientDataVector2 warning:the forth key is  be force set to 1.");
			}
			this._elements[this._currentLength++]=key;
			this._elements[this._currentLength++]=value.x;
			this._elements[this._currentLength++]=value.y;
			}else {
			console.log("GradientDataVector2 warning:data count must lessEqual than 4");
		}
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destGradientDataVector2=destObject;
		destGradientDataVector2._currentLength=this._currentLength;
		var destElements=destGradientDataVector2._elements;
		destElements.length=this._elements.length;
		for (var i=0,n=this._elements.length;i < n;i++){
			destElements[i]=this._elements[i];
		}
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destGradientDataVector2=/*__JS__ */new this.constructor();
		this.cloneTo(destGradientDataVector2);
		return destGradientDataVector2;
	}

	/**二维向量渐变数量。*/
	__getset(0,__proto,'gradientCount',function(){
		return this._currentLength / 3;
	});

	return GradientDataVector2;
})()


/**
*<code>VertexPositionTerrain</code> 类用于创建位置、法线、纹理1、纹理2顶点结构。
*/
//class laya.d3.graphics.Vertex.VertexPositionTerrain
var VertexPositionTerrain=(function(){
	function VertexPositionTerrain(position,normal,textureCoord0,textureCoord1){
		this._position=null;
		this._normal=null;
		this._textureCoord0=null;
		this._textureCoord1=null;
		this._position=position;
		this._normal=normal;
		this._textureCoord0=textureCoord0;
		this._textureCoord1=textureCoord1;
	}

	__class(VertexPositionTerrain,'laya.d3.graphics.Vertex.VertexPositionTerrain');
	var __proto=VertexPositionTerrain.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'normal',function(){
		return this._normal;
	});

	__getset(0,__proto,'position',function(){
		return this._position;
	});

	__getset(0,__proto,'textureCoord0',function(){
		return this._textureCoord0;
	});

	__getset(0,__proto,'textureCoord1',function(){
		return this._textureCoord1;
	});

	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexPositionTerrain._vertexDeclaration;
	});

	__getset(1,VertexPositionTerrain,'vertexDeclaration',function(){
		return VertexPositionTerrain._vertexDeclaration;
	});

	VertexPositionTerrain.TERRAIN_POSITION0=0;
	VertexPositionTerrain.TERRAIN_NORMAL0=1;
	VertexPositionTerrain.TERRAIN_TEXTURECOORDINATE0=2;
	VertexPositionTerrain.TERRAIN_TEXTURECOORDINATE1=3;
	__static(VertexPositionTerrain,
	['_vertexDeclaration',function(){return this._vertexDeclaration=new VertexDeclaration(40,[
		new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*CLASS CONST:laya.d3.graphics.Vertex.VertexPositionTerrain.TERRAIN_POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*CLASS CONST:laya.d3.graphics.Vertex.VertexPositionTerrain.TERRAIN_NORMAL0*/1),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*CLASS CONST:laya.d3.graphics.Vertex.VertexPositionTerrain.TERRAIN_TEXTURECOORDINATE0*/2),
		new VertexElement(32,/*laya.d3.graphics.VertexElementFormat.Vector2*/"vector2",/*CLASS CONST:laya.d3.graphics.Vertex.VertexPositionTerrain.TERRAIN_TEXTURECOORDINATE1*/3)]);}
	]);
	return VertexPositionTerrain;
})()


/**
*<code>KeyframeNodeList</code> 类用于创建KeyframeNode节点队列。
*/
//class laya.d3.animation.KeyframeNodeList
var KeyframeNodeList=(function(){
	function KeyframeNodeList(){
		this._nodes=[];
	}

	__class(KeyframeNodeList,'laya.d3.animation.KeyframeNodeList');
	var __proto=KeyframeNodeList.prototype;
	/**
	*通过索引获取节点。
	*@param index 索引。
	*@return 节点。
	*/
	__proto.getNodeByIndex=function(index){
		return this._nodes[index];
	}

	/**
	*通过索引设置节点。
	*@param index 索引。
	*@param 节点。
	*/
	__proto.setNodeByIndex=function(index,node){
		this._nodes[index]=node;
	}

	/**
	*设置节点个数。
	*@param value 节点个数。
	*/
	/**
	*获取节点个数。
	*@return 节点个数。
	*/
	__getset(0,__proto,'count',function(){
		return this._nodes.length;
		},function(value){
		this._nodes.length=value;
	});

	return KeyframeNodeList;
})()


/**
*<code>BoundsOctree</code> 类用于创建八叉树。
*/
//class laya.d3.core.scene.BoundsOctree
var BoundsOctree=(function(){
	function BoundsOctree(initialWorldSize,initialWorldPos,minNodeSize,looseness){
		/**@private */
		this._initialSize=NaN;
		/**@private */
		this._rootNode=null;
		/**@private */
		this._looseness=NaN;
		/**@private */
		this._minSize=NaN;
		/**@private [只读]*/
		this.count=0;
		this._motionObjects=new OctreeMotionList();
		if (minNodeSize > initialWorldSize){
			console.warn("Minimum node size must be at least as big as the initial world size. Was: "+minNodeSize+" Adjusted to: "+initialWorldSize);
			minNodeSize=initialWorldSize;
		}
		this._initialSize=initialWorldSize;
		this._minSize=minNodeSize;
		this._looseness=Math.min(Math.max(looseness,1.0),2.0);
		this._rootNode=new BoundsOctreeNode(this,null,initialWorldSize,initialWorldPos);
	}

	__class(BoundsOctree,'laya.d3.core.scene.BoundsOctree');
	var __proto=BoundsOctree.prototype;
	/**
	*@private
	*/
	__proto._getMaxDepth=function(node,depth){
		depth++;
		var children=node._children;
		if (children !=null){
			var curDepth=depth;
			for (var i=0,n=children.length;i < n;i++){
				var child=children[i];
				child && (depth=Math.max(this._getMaxDepth(child,curDepth),depth));
			}
		}
		return depth;
	}

	/**
	*@private
	*/
	__proto._grow=function(growObjectCenter){
		var xDirection=growObjectCenter.x >=0 ? 1 :-1;
		var yDirection=growObjectCenter.y >=0 ? 1 :-1;
		var zDirection=growObjectCenter.z >=0 ? 1 :-1;
		var oldRoot=this._rootNode;
		var half=this._rootNode.baseLength / 2;
		var newLength=this._rootNode.baseLength *2;
		var rootCenter=this._rootNode.center;
		var newCenter=new Vector3(rootCenter.x+xDirection *half,rootCenter.y+yDirection *half,rootCenter.z+zDirection *half);
		this._rootNode=new BoundsOctreeNode(this,null,newLength,newCenter);
		if (oldRoot.hasAnyObjects()){
			var rootPos=this._rootNode._bestFitChild(oldRoot.center);
			var children=__newvec(8,null);
			for (var i=0;i < 8;i++){
				if (i==rootPos){
					oldRoot._parent=this._rootNode;
					children[i]=oldRoot;
				}
			}
			this._rootNode._children=children;
		}
	}

	/**
	*添加物体
	*@param object
	*/
	__proto.add=function(object){
		var count=0;
		while (!this._rootNode.add(object)){
			var growCenter=BoundsOctree._tempVector30;
			Vector3.subtract(object.bounds.getCenter(),this._rootNode.center,growCenter);
			this._grow(growCenter);
			if (++count > 20){
				throw "Aborted Add operation as it seemed to be going on forever ("+(count-1)+") attempts at growing the octree.";
			}
		}
		this.count++;
	}

	/**
	*移除物体
	*@return 是否成功
	*/
	__proto.remove=function(object){
		var removed=object._getOctreeNode().remove(object);
		if (removed){
			this.count--;
		}
		return removed;
	}

	/**
	*更新物体
	*/
	__proto.update=function(object){
		var count=0;
		var octreeNode=object._getOctreeNode();
		if (octreeNode){
			while (!octreeNode._update(object)){
				this._grow(object.bounds.getCenter());
				if (++count > 20){
					throw "Aborted Add operation as it seemed to be going on forever ("+(count-1)+") attempts at growing the octree.";
				}
			}
			return true;
			}else {
			return false;
		}
	}

	/**
	*如果可能则收缩根节点。
	*/
	__proto.shrinkRootIfPossible=function(){
		this._rootNode=this._rootNode.shrinkIfPossible(this._initialSize);
	}

	/**
	*添加运动物体。
	*@param 运动物体。
	*/
	__proto.addMotionObject=function(object){
		this._motionObjects.add(object);
	}

	/**
	*移除运动物体。
	*@param 运动物体。
	*/
	__proto.removeMotionObject=function(object){
		this._motionObjects.remove(object);
	}

	/**
	*更新所有运动物体。
	*/
	__proto.updateMotionObjects=function(){
		var elements=this._motionObjects.elements;
		for (var i=0,n=this._motionObjects.length;i < n;i++){
			var object=elements [i];
			this.update(object);
			object._setIndexInMotionList(-1);
		}
		this._motionObjects.length=0;
	}

	/**
	*获取是否与指定包围盒相交。
	*@param checkBound AABB包围盒。
	*@return 是否相交。
	*/
	__proto.isCollidingWithBoundBox=function(checkBounds){
		return this._rootNode.isCollidingWithBoundBox(checkBounds);
	}

	/**
	*获取是否与指定射线相交。
	*@param ray 射线。
	*@param maxDistance 射线的最大距离。
	*@return 是否相交。
	*/
	__proto.isCollidingWithRay=function(ray,maxDistance){
		(maxDistance===void 0)&& (maxDistance=Number.MAX_VALUE);
		return this._rootNode.isCollidingWithRay(ray,maxDistance);
	}

	/**
	*获取与指定包围盒相交的物体列表。
	*@param checkBound AABB包围盒。
	*@param result 相交物体列表
	*/
	__proto.getCollidingWithBoundBox=function(checkBound,result){
		this._rootNode.getCollidingWithBoundBox(checkBound,result);
	}

	/**
	*获取与指定射线相交的的物理列表。
	*@param ray 射线。
	*@param result 相交物体列表。
	*@param maxDistance 射线的最大距离。
	*/
	__proto.getCollidingWithRay=function(ray,result,maxDistance){
		(maxDistance===void 0)&& (maxDistance=Number.MAX_VALUE);
		this._rootNode.getCollidingWithRay(ray,result,maxDistance);
	}

	/**
	*获取与指定视锥相交的的物理列表。
	*@param 渲染上下文。
	*/
	__proto.getCollidingWithFrustum=function(context){
		this._rootNode.getCollidingWithFrustum(context);
	}

	/**
	*获取最大包围盒
	*@return 最大包围盒
	*/
	__proto.getMaxBounds=function(){
		return this._rootNode.getBound();
	}

	/**
	*@private
	*[Debug]
	*/
	__proto.drawAllBounds=function(pixelLine){
		var maxDepth=this._getMaxDepth(this._rootNode,-1);
		this._rootNode.drawAllBounds(pixelLine,-1,maxDepth);
	}

	/**
	*@private
	*[Debug]
	*/
	__proto.drawAllObjects=function(pixelLine){
		var maxDepth=this._getMaxDepth(this._rootNode,-1);
		this._rootNode.drawAllObjects(pixelLine,-1,maxDepth);
	}

	__static(BoundsOctree,
	['_tempVector30',function(){return this._tempVector30=new Vector3();}
	]);
	return BoundsOctree;
})()


/**
*<code>MeshFilter</code> 类用于创建网格过滤器。
*/
//class laya.d3.core.MeshFilter
var MeshFilter=(function(){
	function MeshFilter(owner){
		/**@private */
		this._owner=null;
		/**@private */
		this._sharedMesh=null;
		this._owner=owner;
	}

	__class(MeshFilter,'laya.d3.core.MeshFilter');
	var __proto=MeshFilter.prototype;
	/**
	*@private
	*/
	__proto._getMeshDefine=function(mesh){
		var define=0;
		for (var i=0,n=mesh._subMeshCount;i < n;i++){
			var subMesh=mesh._getSubMesh(i);
			var vertexElements=subMesh._vertexBuffer._vertexDeclaration.vertexElements;
			for (var j=0,m=vertexElements.length;j < m;j++){
				var vertexElement=vertexElements[j];
				var name=vertexElement.elementUsage;
				switch (name){
					case /*laya.d3.graphics.Vertex.VertexMesh.MESH_COLOR0*/1:
						define |=MeshSprite3D.SHADERDEFINE_COLOR;
						break
					case /*laya.d3.graphics.Vertex.VertexMesh.MESH_TEXTURECOORDINATE0*/2:
						define |=MeshSprite3D.SHADERDEFINE_UV0;
						break ;
					case /*laya.d3.graphics.Vertex.VertexMesh.MESH_TEXTURECOORDINATE1*/7:
						define |=MeshSprite3D.SHADERDEFINE_UV1;
						break ;
					}
			}
		}
		return define;
	}

	/**
	*@inheritDoc
	*/
	__proto.destroy=function(){
		this._owner=null;
		(this._sharedMesh)&& (this._sharedMesh._removeReference(),this._sharedMesh=null);
	}

	/**
	*设置共享网格。
	*@return value 共享网格。
	*/
	/**
	*获取共享网格。
	*@return 共享网格。
	*/
	__getset(0,__proto,'sharedMesh',function(){
		return this._sharedMesh;
		},function(value){
		if (this._sharedMesh!==value){
			var defineDatas=this._owner._render._defineDatas;
			var lastValue=this._sharedMesh;
			if (lastValue){
				lastValue._removeReference();
				defineDatas.remove(this._getMeshDefine(lastValue));
			}
			value._addReference();
			this._sharedMesh=value;
			defineDatas.add(this._getMeshDefine(value));
			(this._owner._render)._changeRenderObjectsByMesh(value);
		}
		(this._owner._render)._onMeshChange(value);
	});

	return MeshFilter;
})()


/**
*<code>TrailFilter</code> 类用于创建拖尾过滤器。
*/
//class laya.d3.core.trail.TrailFilter
var TrailFilter=(function(){
	function TrailFilter(owner){
		/**@private */
		this._minVertexDistance=NaN;
		/**@private */
		this._widthMultiplier=NaN;
		/**@private */
		this._time=NaN;
		/**@private */
		this._widthCurve=null;
		/**@private */
		this._colorGradient=null;
		/**@private */
		this._textureMode=0;
		/**@private */
		this._trialGeometry=null;
		/**@private 拖尾总长度*/
		this._totalLength=0;
		this._owner=null;
		this._curtime=0;
		this._trailRenderElementIndex=0;
		this._lastPosition=new Vector3();
		this.alignment=0;
		this._owner=owner;
		this._initDefaultData();
		this.addRenderElement();
	}

	__class(TrailFilter,'laya.d3.core.trail.TrailFilter');
	var __proto=TrailFilter.prototype;
	/**
	*@private
	*/
	__proto.addRenderElement=function(){
		var render=this._owner._render;
		var elements=render._renderElements;
		var material=render.sharedMaterials [0];
		(material)|| (material=TrailMaterial.defaultMaterial);
		var element=new RenderElement();
		element.setTransform(this._owner._transform);
		element.render=render;
		element.material=material;
		this._trialGeometry=new TrailGeometry(this);
		element.setGeometry(this._trialGeometry);
		elements.push(element);
	}

	/**
	*@private
	*/
	__proto._update=function(state){
		var render=this._owner._render;
		this._curtime+=(state.scene).timer._delta / 1000;
		render._shaderValues.setNumber(TrailSprite3D.CURTIME,this._curtime);
		var curPos=this._owner.transform.position;
		var element=render._renderElements[0] ._geometry;
		element._updateDisappear();
		element._updateTrail(state.camera,this._lastPosition,curPos);
		element._updateVertexBufferUV();
		curPos.cloneTo(this._lastPosition);
	}

	/**
	*@private
	*/
	__proto._initDefaultData=function(){
		this.time=5.0;
		this.minVertexDistance=0.1;
		this.widthMultiplier=1;
		this.textureMode=/*laya.d3.core.TextureMode.Stretch*/0;
		var widthKeyFrames=[];
		var widthKeyFrame1=new FloatKeyframe();
		widthKeyFrame1.time=0;
		widthKeyFrame1.inTangent=0;
		widthKeyFrame1.outTangent=0;
		widthKeyFrame1.value=1;
		widthKeyFrames.push(widthKeyFrame1);
		var widthKeyFrame2=new FloatKeyframe();
		widthKeyFrame2.time=1;
		widthKeyFrame2.inTangent=0;
		widthKeyFrame2.outTangent=0;
		widthKeyFrame2.value=1;
		widthKeyFrames.push(widthKeyFrame2);
		this.widthCurve=widthKeyFrames;
		var gradient=new Gradient(2,2);
		gradient.mode=/*laya.d3.core.GradientMode.Blend*/0;
		gradient.addColorRGB(0,Color.WHITE);
		gradient.addColorRGB(1,Color.WHITE);
		gradient.addColorAlpha(0,1);
		gradient.addColorAlpha(1,1);
		this.colorGradient=gradient;
	}

	/**
	*@private
	*/
	__proto.destroy=function(){
		this._trialGeometry.destroy();
		this._trialGeometry=null;
		this._widthCurve=null;
		this._colorGradient=null;
	}

	/**
	*设置宽度倍数。
	*@param value 宽度倍数。
	*/
	/**
	*获取宽度倍数。
	*@return 宽度倍数。
	*/
	__getset(0,__proto,'widthMultiplier',function(){
		return this._widthMultiplier;
		},function(value){
		this._widthMultiplier=value;
	});

	/**
	*设置淡出时间。
	*@param value 淡出时间。
	*/
	/**
	*获取淡出时间。
	*@return 淡出时间。
	*/
	__getset(0,__proto,'time',function(){
		return this._time;
		},function(value){
		this._time=value;
		this._owner._render._shaderValues.setNumber(TrailSprite3D.LIFETIME,value);
	});

	/**
	*设置宽度曲线。
	*@param value 宽度曲线。
	*/
	/**
	*获取宽度曲线。
	*@return 宽度曲线。
	*/
	__getset(0,__proto,'widthCurve',function(){
		return this._widthCurve;
		},function(value){
		this._widthCurve=value;
		var widthCurveFloatArray=new Float32Array(value.length *4);
		var i=0,j=0,index=0;
		for (i=0,j=value.length;i < j;i++){
			widthCurveFloatArray[index++]=value[i].time;
			widthCurveFloatArray[index++]=value[i].inTangent;
			widthCurveFloatArray[index++]=value[i].outTangent;
			widthCurveFloatArray[index++]=value[i].value;
		}
		this._owner._render._shaderValues.setBuffer(TrailSprite3D.WIDTHCURVE,widthCurveFloatArray);
		this._owner._render._shaderValues.setInt(TrailSprite3D.WIDTHCURVEKEYLENGTH,value.length);
	});

	/**
	*设置新旧顶点之间最小距离。
	*@param value 新旧顶点之间最小距离。
	*/
	/**
	*获取新旧顶点之间最小距离。
	*@return 新旧顶点之间最小距离。
	*/
	__getset(0,__proto,'minVertexDistance',function(){
		return this._minVertexDistance;
		},function(value){
		this._minVertexDistance=value;
	});

	/**
	*设置颜色梯度。
	*@param value 颜色梯度。
	*/
	/**
	*获取颜色梯度。
	*@return 颜色梯度。
	*/
	__getset(0,__proto,'colorGradient',function(){
		return this._colorGradient;
		},function(value){
		this._colorGradient=value;
		this._owner._render._shaderValues.setBuffer(TrailSprite3D.GRADIENTCOLORKEY,value._rgbElements);
		this._owner._render._shaderValues.setBuffer(TrailSprite3D.GRADIENTALPHAKEY,value._alphaElements);
		if (value.mode==/*laya.d3.core.GradientMode.Blend*/0){
			this._owner._render._defineDatas.add(TrailSprite3D.SHADERDEFINE_GRADIENTMODE_BLEND);
			}else {
			this._owner._render._defineDatas.remove(TrailSprite3D.SHADERDEFINE_GRADIENTMODE_BLEND);
		}
	});

	/**
	*设置纹理模式。
	*@param value 纹理模式。
	*/
	/**
	*获取纹理模式。
	*@return 纹理模式。
	*/
	__getset(0,__proto,'textureMode',function(){
		return this._textureMode;
		},function(value){
		this._textureMode=value;
	});

	TrailFilter.ALIGNMENT_VIEW=0;
	TrailFilter.ALIGNMENT_TRANSFORM_Z=1;
	return TrailFilter;
})()


/**
*<code>VertexTrail</code> 类用于创建拖尾顶点结构。
*/
//class laya.d3.core.trail.VertexTrail
var VertexTrail=(function(){
	function VertexTrail(){}
	__class(VertexTrail,'laya.d3.core.trail.VertexTrail');
	var __proto=VertexTrail.prototype;
	Laya.imps(__proto,{"laya.d3.graphics.IVertex":true})
	__getset(0,__proto,'vertexDeclaration',function(){
		return VertexTrail._vertexDeclaration1;
	});

	__getset(1,VertexTrail,'vertexDeclaration1',function(){
		return VertexTrail._vertexDeclaration1;
	});

	__getset(1,VertexTrail,'vertexDeclaration2',function(){
		return VertexTrail._vertexDeclaration2;
	});

	VertexTrail.TRAIL_POSITION0=0;
	VertexTrail.TRAIL_OFFSETVECTOR=1;
	VertexTrail.TRAIL_TIME0=2;
	VertexTrail.TRAIL_TEXTURECOORDINATE0Y=3;
	VertexTrail.TRAIL_TEXTURECOORDINATE0X=4;
	__static(VertexTrail,
	['_vertexDeclaration1',function(){return this._vertexDeclaration1=new VertexDeclaration(32,
		[new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*CLASS CONST:laya.d3.core.trail.VertexTrail.TRAIL_POSITION0*/0),
		new VertexElement(12,/*laya.d3.graphics.VertexElementFormat.Vector3*/"vector3",/*CLASS CONST:laya.d3.core.trail.VertexTrail.TRAIL_OFFSETVECTOR*/1),
		new VertexElement(24,/*laya.d3.graphics.VertexElementFormat.Single*/"single",/*CLASS CONST:laya.d3.core.trail.VertexTrail.TRAIL_TIME0*/2),
		new VertexElement(28,/*laya.d3.graphics.VertexElementFormat.Single*/"single",/*CLASS CONST:laya.d3.core.trail.VertexTrail.TRAIL_TEXTURECOORDINATE0Y*/3)]);},'_vertexDeclaration2',function(){return this._vertexDeclaration2=new VertexDeclaration(4,
		[new VertexElement(0,/*laya.d3.graphics.VertexElementFormat.Single*/"single",/*CLASS CONST:laya.d3.core.trail.VertexTrail.TRAIL_TEXTURECOORDINATE0X*/4)]);}
	]);
	return VertexTrail;
})()


/**
*<code>Burst</code> 类用于粒子的爆裂描述。
*/
//class laya.d3.core.particleShuriKen.module.Burst
var Burst=(function(){
	function Burst(time,minCount,maxCount){
		/**@private 爆裂时间,单位为秒。*/
		this._time=NaN;
		/**@private 爆裂的最小数量。*/
		this._minCount=0;
		/**@private 爆裂的最大数量。*/
		this._maxCount=0;
		this._time=time;
		this._minCount=minCount;
		this._maxCount=maxCount;
	}

	__class(Burst,'laya.d3.core.particleShuriKen.module.Burst');
	var __proto=Burst.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destBurst=destObject;
		destBurst._time=this._time
		destBurst._minCount=this._minCount;
		destBurst._maxCount=this._maxCount;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destBurst=/*__JS__ */new this.constructor();
		this.cloneTo(destBurst);
		return destBurst;
	}

	/**
	*获取爆裂时间,单位为秒。
	*@return 爆裂时间,单位为秒。
	*/
	__getset(0,__proto,'time',function(){
		return this._time;
	});

	/**
	*获取爆裂的最小数量。
	*@return 爆裂的最小数量。
	*/
	__getset(0,__proto,'minCount',function(){
		return this._minCount;
	});

	/**
	*获取爆裂的最大数量。
	*@return 爆裂的最大数量。
	*/
	__getset(0,__proto,'maxCount',function(){
		return this._maxCount;
	});

	return Burst;
})()


/**
*<code>AnimationEvent</code> 类用于实现动画事件。
*/
//class laya.d3.animation.AnimationEvent
var AnimationEvent=(function(){
	function AnimationEvent(){
		/**事件触发时间。*/
		this.time=NaN;
		/**事件触发名称。*/
		this.eventName=null;
		/**事件触发参数。*/
		this.params=null;
	}

	__class(AnimationEvent,'laya.d3.animation.AnimationEvent');
	return AnimationEvent;
})()


/**
*...
*@author ...
*/
//class laya.d3.physics.Constraint3D
var Constraint3D=(function(){
	function Constraint3D(){
		/**@private */
		this._nativeConstraint=null;
		/**@private */
		this._simulation=null;
		/**获取刚体A。[只读]*/
		this.rigidbodyA=null;
		/**获取刚体A。[只读]*/
		this.rigidbodyB=null;
	}

	__class(Constraint3D,'laya.d3.physics.Constraint3D');
	return Constraint3D;
})()


/**
*@private
*/
//class laya.d3.MouseTouch
var MouseTouch=(function(){
	function MouseTouch(){
		/**@private */
		this._pressedSprite=null;
		/**@private */
		this._pressedLoopCount=-1;
		/**@private */
		this.sprite=null;
		/**@private */
		this.mousePositionX=0;
		/**@private */
		this.mousePositionY=0;
	}

	__class(MouseTouch,'laya.d3.MouseTouch');
	return MouseTouch;
})()


/**
*<code>GradientDataInt</code> 类用于创建整形渐变。
*/
//class laya.d3.core.particleShuriKen.module.GradientDataInt
var GradientDataInt=(function(){
	function GradientDataInt(){
		/**@private */
		this._currentLength=0;
		/**@private 开发者禁止修改。*/
		this._elements=null;
		this._elements=new Float32Array(8);
	}

	__class(GradientDataInt,'laya.d3.core.particleShuriKen.module.GradientDataInt');
	var __proto=GradientDataInt.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*增加整形渐变。
	*@param key 生命周期，范围为0到1。
	*@param value 整形值。
	*/
	__proto.add=function(key,value){
		if (this._currentLength < 8){
			if ((this._currentLength===6)&& ((key!==1))){
				key=1;
				console.log("Warning:the forth key is  be force set to 1.");
			}
			this._elements[this._currentLength++]=key;
			this._elements[this._currentLength++]=value;
			}else {
			console.log("Warning:data count must lessEqual than 4");
		}
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destGradientDataInt=destObject;
		destGradientDataInt._currentLength=this._currentLength;
		var destElements=destGradientDataInt._elements;
		destElements.length=this._elements.length;
		for (var i=0,n=this._elements.length;i < n;i++){
			destElements[i]=this._elements[i];
		}
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destGradientDataInt=/*__JS__ */new this.constructor();
		this.cloneTo(destGradientDataInt);
		return destGradientDataInt;
	}

	/**整形渐变数量。*/
	__getset(0,__proto,'gradientCount',function(){
		return this._currentLength / 2;
	});

	return GradientDataInt;
})()


/**
*<code>SubShader</code> 类用于创建SubShader。
*/
//class laya.d3.shader.SubShader
var SubShader=(function(){
	function SubShader(attributeMap,uniformMap,spriteDefines,materialDefines){
		/**@private */
		this._attributeMap=null;
		/**@private */
		this._uniformMap=null;
		/**@private */
		this._publicDefines=null;
		/**@private */
		this._publicDefinesMap=null;
		/**@private */
		this._spriteDefines=null;
		/**@private */
		this._spriteDefinesMap=null;
		/**@private */
		this._materialDefines=null;
		/**@private */
		this._materialDefinesMap=null;
		/**@private */
		this._owner=null;
		/**@private */
		this._flags={};
		this._passes=[];
		this._publicDefines=[];
		this._publicDefinesMap={};
		this._spriteDefines=[];
		this._spriteDefinesMap={};
		this._materialDefines=[];
		this._materialDefinesMap={};
		this._addDefines(this._publicDefines,this._publicDefinesMap,Shader3D._globleDefines);
		(spriteDefines)&& (this._addDefines(this._spriteDefines,this._spriteDefinesMap,spriteDefines.defines));
		(materialDefines)&& (this._addDefines(this._materialDefines,this._materialDefinesMap,materialDefines.defines));
		this._attributeMap=attributeMap;
		this._uniformMap=uniformMap;
	}

	__class(SubShader,'laya.d3.shader.SubShader');
	var __proto=SubShader.prototype;
	/**
	*@private
	*/
	__proto._addDefines=function(defines,definesMap,supportDefines){
		for (var k in supportDefines){
			var name=supportDefines[k];
			var i=parseInt(k);
			defines[i]=name;
			definesMap[name]=i;
		}
	}

	/**
	*通过名称获取宏定义值。
	*@param name 名称。
	*@return 宏定义值。
	*/
	__proto.getMaterialDefineByName=function(name){
		return this._materialDefinesMap[name];
	}

	/**
	*添加标记。
	*@param key 标记键。
	*@param value 标记值。
	*/
	__proto.setFlag=function(key,value){
		if (value)
			this._flags[key]=value;
		else
		delete this._flags[key];
	}

	/**
	*获取标记值。
	*@return key 标记键。
	*/
	__proto.getFlag=function(key){
		return this._flags[key];
	}

	/**
	*@private
	*/
	__proto.addShaderPass=function(vs,ps,stateMap){
		var shaderPass=new ShaderPass(this,vs,ps,stateMap);
		this._passes.push(shaderPass);
		return shaderPass;
	}

	return SubShader;
})()


/**
**<code>PostProcessRenderContext</code> 类用于创建后期处理渲染上下文。
*/
//class laya.d3.core.render.PostProcessRenderContext
var PostProcessRenderContext=(function(){
	function PostProcessRenderContext(){
		/**源纹理。*/
		this.source=null;
		/**输出纹理。*/
		this.destination=null;
		/**渲染相机。*/
		this.camera=null;
		/**合成着色器数据。*/
		this.compositeShaderData=null;
		/**合成着色器宏定义。*/
		this.compositeDefineData=null;
		/**后期处理指令流。*/
		this.command=null;
		this.tempRenderTextures=[];
	}

	__class(PostProcessRenderContext,'laya.d3.core.render.PostProcessRenderContext');
	return PostProcessRenderContext;
})()


/**
*<code>CommandBuffer</code> 类用于创建命令流。
*/
//class laya.d3.core.render.command.CommandBuffer
var CommandBuffer=(function(){
	function CommandBuffer(){
		this._commands=[];
	}

	__class(CommandBuffer,'laya.d3.core.render.command.CommandBuffer');
	var __proto=CommandBuffer.prototype;
	/**
	*@private
	*/
	__proto._apply=function(){
		for (var i=0,n=this._commands.length;i < n;i++)
		this._commands[i].run();
	}

	/**
	*@private
	*/
	__proto.setShaderDataTexture=function(shaderData,nameID,source){
		this._commands.push(SetShaderDataTextureCMD.create(shaderData,nameID,source));
	}

	/**
	*@private
	*/
	__proto.blit=function(source,dest,shader,shaderData,subShader){
		(subShader===void 0)&& (subShader=0);
		this._commands.push(BlitCMD.create(source,dest,shader,shaderData,subShader));
	}

	/**
	*@private
	*/
	__proto.setRenderTarget=function(renderTexture){
		this._commands.push(SetRenderTargetCMD.create(renderTexture));
	}

	/**
	*@private
	*/
	__proto.clear=function(){
		for (var i=0,n=this._commands.length;i < n;i++)
		this._commands[i].recover();
		this._commands.length=0;
	}

	CommandBuffer.SCREENTEXTURE_NAME="u_ScreenTexture";
	__static(CommandBuffer,
	['screenShader',function(){return this.screenShader=Shader3D.find("ScreenQuad");},'SCREENTEXTURE_ID',function(){return this.SCREENTEXTURE_ID=Shader3D.propertyNameToID("u_ScreenTexture");}
	]);
	return CommandBuffer;
})()


/**
*<code>GradientRotation</code> 类用于创建渐变角速度。
*/
//class laya.d3.core.particleShuriKen.module.GradientAngularVelocity
var GradientAngularVelocity=(function(){
	function GradientAngularVelocity(){
		/**@private */
		this._type=0;
		/**@private */
		this._separateAxes=false;
		/**@private */
		this._constant=NaN;
		/**@private */
		this._constantSeparate=null;
		/**@private */
		this._gradient=null;
		/**@private */
		this._gradientX=null;
		/**@private */
		this._gradientY=null;
		/**@private */
		this._gradientZ=null;
		/**@private */
		this._gradientW=null;
		/**@private */
		this._constantMin=NaN;
		/**@private */
		this._constantMax=NaN;
		/**@private */
		this._constantMinSeparate=null;
		/**@private */
		this._constantMaxSeparate=null;
		/**@private */
		this._gradientMin=null;
		/**@private */
		this._gradientMax=null;
		/**@private */
		this._gradientXMin=null;
		/**@private */
		this._gradientXMax=null;
		/**@private */
		this._gradientYMin=null;
		/**@private */
		this._gradientYMax=null;
		/**@private */
		this._gradientZMin=null;
		/**@private */
		this._gradientZMax=null;
		/**@private */
		this._gradientWMin=null;
		/**@private */
		this._gradientWMax=null;
	}

	__class(GradientAngularVelocity,'laya.d3.core.particleShuriKen.module.GradientAngularVelocity');
	var __proto=GradientAngularVelocity.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destGradientAngularVelocity=destObject;
		destGradientAngularVelocity._type=this._type;
		destGradientAngularVelocity._separateAxes=this._separateAxes;
		destGradientAngularVelocity._constant=this._constant;
		this._constantSeparate.cloneTo(destGradientAngularVelocity._constantSeparate);
		this._gradient.cloneTo(destGradientAngularVelocity._gradient);
		this._gradientX.cloneTo(destGradientAngularVelocity._gradientX);
		this._gradientY.cloneTo(destGradientAngularVelocity._gradientY);
		this._gradientZ.cloneTo(destGradientAngularVelocity._gradientZ);
		destGradientAngularVelocity._constantMin=this._constantMin;
		destGradientAngularVelocity._constantMax=this._constantMax;
		this._constantMinSeparate.cloneTo(destGradientAngularVelocity._constantMinSeparate);
		this._constantMaxSeparate.cloneTo(destGradientAngularVelocity._constantMaxSeparate);
		this._gradientMin.cloneTo(destGradientAngularVelocity._gradientMin);
		this._gradientMax.cloneTo(destGradientAngularVelocity._gradientMax);
		this._gradientXMin.cloneTo(destGradientAngularVelocity._gradientXMin);
		this._gradientXMax.cloneTo(destGradientAngularVelocity._gradientXMax);
		this._gradientYMin.cloneTo(destGradientAngularVelocity._gradientYMin);
		this._gradientYMax.cloneTo(destGradientAngularVelocity._gradientYMax);
		this._gradientZMin.cloneTo(destGradientAngularVelocity._gradientZMin);
		this._gradientZMax.cloneTo(destGradientAngularVelocity._gradientZMax);
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destGradientAngularVelocity=/*__JS__ */new this.constructor();
		this.cloneTo(destGradientAngularVelocity);
		return destGradientAngularVelocity;
	}

	/**
	*渐变角速度Z。
	*/
	__getset(0,__proto,'gradientZ',function(){
		return this._gradientZ;
	});

	/**
	*固定角速度。
	*/
	__getset(0,__proto,'constant',function(){
		return this._constant;
	});

	/**
	*渐变角速度。
	*/
	__getset(0,__proto,'gradient',function(){
		return this._gradient;
	});

	/**
	*是否分轴。
	*/
	__getset(0,__proto,'separateAxes',function(){
		return this._separateAxes;
	});

	/**
	*生命周期角速度类型,0常量模式，1曲线模式，2随机双常量模式，3随机双曲线模式。
	*/
	__getset(0,__proto,'type',function(){
		return this._type;
	});

	/**
	*分轴固定角速度。
	*/
	__getset(0,__proto,'constantSeparate',function(){
		return this._constantSeparate;
	});

	/**
	*渐变角角速度X。
	*/
	__getset(0,__proto,'gradientX',function(){
		return this._gradientX;
	});

	/**
	*渐变角速度Y。
	*/
	__getset(0,__proto,'gradientY',function(){
		return this._gradientY;
	});

	/**
	*渐变角速度Z。
	*/
	__getset(0,__proto,'gradientW',function(){
		return this._gradientW;
	});

	/**
	*最小渐变角速度。
	*/
	__getset(0,__proto,'gradientMin',function(){
		return this._gradientMin;
	});

	/**
	*最小随机双固定角速度。
	*/
	__getset(0,__proto,'constantMin',function(){
		return this._constantMin;
	});

	/**
	*最大渐变角速度。
	*/
	__getset(0,__proto,'gradientMax',function(){
		return this._gradientMax;
	});

	/**
	*最大随机双固定角速度。
	*/
	__getset(0,__proto,'constantMax',function(){
		return this._constantMax;
	});

	/**
	*最小渐变角速度Z。
	*/
	__getset(0,__proto,'gradientWMin',function(){
		return this._gradientWMin;
	});

	/**
	*最小分轴随机双固定角速度。
	*/
	__getset(0,__proto,'constantMinSeparate',function(){
		return this._constantMinSeparate;
	});

	/**
	*最大分轴随机双固定角速度。
	*/
	__getset(0,__proto,'constantMaxSeparate',function(){
		return this._constantMaxSeparate;
	});

	/**
	*最小渐变角速度X。
	*/
	__getset(0,__proto,'gradientXMin',function(){
		return this._gradientXMin;
	});

	/**
	*最大渐变角速度X。
	*/
	__getset(0,__proto,'gradientXMax',function(){
		return this._gradientXMax;
	});

	/**
	*最大渐变角速度Z。
	*/
	__getset(0,__proto,'gradientWMax',function(){
		return this._gradientWMax;
	});

	/**
	*最小渐变角速度Y。
	*/
	__getset(0,__proto,'gradientYMin',function(){
		return this._gradientYMin;
	});

	/**
	*最大渐变角速度Y。
	*/
	__getset(0,__proto,'gradientYMax',function(){
		return this._gradientYMax;
	});

	/**
	*最小渐变角速度Z。
	*/
	__getset(0,__proto,'gradientZMin',function(){
		return this._gradientZMin;
	});

	/**
	*最大渐变角速度Z。
	*/
	__getset(0,__proto,'gradientZMax',function(){
		return this._gradientZMax;
	});

	GradientAngularVelocity.createByConstant=function(constant){
		var gradientAngularVelocity=new GradientAngularVelocity();
		gradientAngularVelocity._type=0;
		gradientAngularVelocity._separateAxes=false;
		gradientAngularVelocity._constant=constant;
		return gradientAngularVelocity;
	}

	GradientAngularVelocity.createByConstantSeparate=function(separateConstant){
		var gradientAngularVelocity=new GradientAngularVelocity();
		gradientAngularVelocity._type=0;
		gradientAngularVelocity._separateAxes=true;
		gradientAngularVelocity._constantSeparate=separateConstant;
		return gradientAngularVelocity;
	}

	GradientAngularVelocity.createByGradient=function(gradient){
		var gradientAngularVelocity=new GradientAngularVelocity();
		gradientAngularVelocity._type=1;
		gradientAngularVelocity._separateAxes=false;
		gradientAngularVelocity._gradient=gradient;
		return gradientAngularVelocity;
	}

	GradientAngularVelocity.createByGradientSeparate=function(gradientX,gradientY,gradientZ){
		var gradientAngularVelocity=new GradientAngularVelocity();
		gradientAngularVelocity._type=1;
		gradientAngularVelocity._separateAxes=true;
		gradientAngularVelocity._gradientX=gradientX;
		gradientAngularVelocity._gradientY=gradientY;
		gradientAngularVelocity._gradientZ=gradientZ;
		return gradientAngularVelocity;
	}

	GradientAngularVelocity.createByRandomTwoConstant=function(constantMin,constantMax){
		var gradientAngularVelocity=new GradientAngularVelocity();
		gradientAngularVelocity._type=2;
		gradientAngularVelocity._separateAxes=false;
		gradientAngularVelocity._constantMin=constantMin;
		gradientAngularVelocity._constantMax=constantMax;
		return gradientAngularVelocity;
	}

	GradientAngularVelocity.createByRandomTwoConstantSeparate=function(separateConstantMin,separateConstantMax){
		var gradientAngularVelocity=new GradientAngularVelocity();
		gradientAngularVelocity._type=2;
		gradientAngularVelocity._separateAxes=true;
		gradientAngularVelocity._constantMinSeparate=separateConstantMin;
		gradientAngularVelocity._constantMaxSeparate=separateConstantMax;
		return gradientAngularVelocity;
	}

	GradientAngularVelocity.createByRandomTwoGradient=function(gradientMin,gradientMax){
		var gradientAngularVelocity=new GradientAngularVelocity();
		gradientAngularVelocity._type=3;
		gradientAngularVelocity._separateAxes=false;
		gradientAngularVelocity._gradientMin=gradientMin;
		gradientAngularVelocity._gradientMax=gradientMax;
		return gradientAngularVelocity;
	}

	GradientAngularVelocity.createByRandomTwoGradientSeparate=function(gradientXMin,gradientXMax,gradientYMin,gradientYMax,gradientZMin,gradientZMax,gradientWMin,gradientWMax){
		var gradientAngularVelocity=new GradientAngularVelocity();
		gradientAngularVelocity._type=3;
		gradientAngularVelocity._separateAxes=true;
		gradientAngularVelocity._gradientXMin=gradientXMin;
		gradientAngularVelocity._gradientXMax=gradientXMax;
		gradientAngularVelocity._gradientYMin=gradientYMin;
		gradientAngularVelocity._gradientYMax=gradientYMax;
		gradientAngularVelocity._gradientZMin=gradientZMin;
		gradientAngularVelocity._gradientZMax=gradientZMax;
		gradientAngularVelocity._gradientWMin=gradientWMin;
		gradientAngularVelocity._gradientWMax=gradientWMax;
		return gradientAngularVelocity;
	}

	return GradientAngularVelocity;
})()


/**
*<code>Config3D</code> 类用于创建3D初始化配置。
*/
//class Config3D
var Config3D=(function(){
	function Config3D(){
		/**@private */
		this._defaultPhysicsMemory=16;
		/**@private */
		this._editerEnvironment=false;
		/**是否开启抗锯齿。*/
		this.isAntialias=true;
		/**设置画布是否透明。*/
		this.isAlpha=false;
		/**设置画布是否预乘。*/
		this.premultipliedAlpha=true;
		/**设置画布的是否开启模板缓冲。*/
		this.isStencil=true;
		/**是否开启八叉树裁剪。*/
		this.octreeCulling=false;
		/**八叉树初始化尺寸。*/
		this.octreeInitialSize=64.0;
		/**八叉树最小尺寸。*/
		this.octreeMinNodeSize=2.0;
		/**八叉树松散值。*/
		this.octreeLooseness=1.25;
		/**
		*是否开启视锥裁剪调试。
		*如果开启八叉树裁剪,使用红色绘制高层次八叉树节点包围盒,使用蓝色绘制低层次八叉节点包围盒,精灵包围盒和八叉树节点包围盒颜色一致,但Alpha为半透明。如果视锥完全包含八叉树节点,八叉树节点包围盒和精灵包围盒变为蓝色,同样精灵包围盒的Alpha为半透明。
		*如果不开启八叉树裁剪,使用绿色像素线绘制精灵包围盒。
		*/
		this.debugFrustumCulling=false;
		this.octreeInitialCenter=new Vector3(0,0,0);
	}

	__class(Config3D,'Config3D');
	var __proto=Config3D.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(dest){
		var destConfig3D=dest;
		destConfig3D._defaultPhysicsMemory=this._defaultPhysicsMemory;
		destConfig3D._editerEnvironment=this._editerEnvironment;
		destConfig3D.isAntialias=this.isAntialias;
		destConfig3D.isAlpha=this.isAlpha;
		destConfig3D.premultipliedAlpha=this.premultipliedAlpha;
		destConfig3D.isStencil=this.isStencil;
		destConfig3D.octreeCulling=this.octreeCulling;
		this.octreeInitialCenter.cloneTo(destConfig3D.octreeInitialCenter);
		destConfig3D.octreeMinNodeSize=this.octreeMinNodeSize;
		destConfig3D.octreeLooseness=this.octreeLooseness;
		destConfig3D.debugFrustumCulling=this.debugFrustumCulling;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var dest=new Config3D();
		this.cloneTo(dest);
		return dest;
	}

	/**
	*设置默认物理功能初始化内存，单位为M。
	*@param value 默认物理功能初始化内存。
	*/
	/**
	*获取默认物理功能初始化内存，单位为M。
	*@return 默认物理功能初始化内存。
	*/
	__getset(0,__proto,'defaultPhysicsMemory',function(){
		return this._defaultPhysicsMemory;
		},function(value){
		if (value < 16)
			throw "defaultPhysicsMemory must large than 16M";
		this._defaultPhysicsMemory=value;
	});

	__static(Config3D,
	['_default',function(){return this._default=new Config3D();}
	]);
	return Config3D;
})()


/**
*<code>Rand</code> 类用于通过128位整型种子创建随机数,算法来自:https://github.com/AndreasMadsen/xorshift。
*/
//class laya.d3.math.RandX
var RandX=(function(){
	function RandX(seed){
		/**@private */
		this._state0U=NaN;
		/**@private */
		this._state0L=NaN;
		/**@private */
		this._state1U=NaN;
		/**@private */
		this._state1L=NaN;
		if (!((seed instanceof Array))|| seed.length!==4)
			throw new Error('Rand:Seed must be an array with 4 numbers');
		this._state0U=seed[0] | 0;
		this._state0L=seed[1] | 0;
		this._state1U=seed[2] | 0;
		this._state1L=seed[3] | 0;
	}

	__class(RandX,'laya.d3.math.RandX');
	var __proto=RandX.prototype;
	/**
	*通过2x32位的数组，返回64位的随机数。
	*@return 64位的随机数。
	*/
	__proto.randomint=function(){
		var s1U=this._state0U,s1L=this._state0L;
		var s0U=this._state1U,s0L=this._state1L;
		var sumL=(s0L >>> 0)+(s1L >>> 0);
		var resU=(s0U+s1U+(sumL / 2 >>> 31))>>> 0;
		var resL=sumL >>> 0;
		this._state0U=s0U;
		this._state0L=s0L;
		var t1U=0,t1L=0;
		var t2U=0,t2L=0;
		var a1=23;
		var m1=0xFFFFFFFF << (32-a1);
		t1U=(s1U << a1)| ((s1L & m1)>>> (32-a1));
		t1L=s1L << a1;
		s1U=s1U ^ t1U;
		s1L=s1L ^ t1L;
		t1U=s1U ^ s0U;
		t1L=s1L ^ s0L;
		var a2=18;
		var m2=0xFFFFFFFF >>> (32-a2);
		t2U=s1U >>> a2;
		t2L=(s1L >>> a2)| ((s1U & m2)<< (32-a2));
		t1U=t1U ^ t2U;
		t1L=t1L ^ t2L;
		var a3=5;
		var m3=0xFFFFFFFF >>> (32-a3);
		t2U=s0U >>> a3;
		t2L=(s0L >>> a3)| ((s0U & m3)<< (32-a3));
		t1U=t1U ^ t2U;
		t1L=t1L ^ t2L;
		this._state1U=t1U;
		this._state1L=t1L;
		return [resU,resL];
	}

	/**
	*返回[0,1)之间的随机数。
	*@return
	*/
	__proto.random=function(){
		var t2=this.randomint();
		var t2U=t2[0];
		var t2L=t2[1];
		var eU=0x3FF << (52-32);
		var eL=0;
		var a1=12;
		var m1=0xFFFFFFFF >>> (32-a1);
		var sU=t2U >>> a1;
		var sL=(t2L >>> a1)| ((t2U & m1)<< (32-a1));
		var xU=eU | sU;
		var xL=eL | sL;
		RandX._CONVERTION_BUFFER.setUint32(0,xU,false);
		RandX._CONVERTION_BUFFER.setUint32(4,xL,false);
		var d=/*__JS__ */Rand._CONVERTION_BUFFER.getFloat64(0,false);
		return d-1;
	}

	__static(RandX,
	['_CONVERTION_BUFFER',function(){return this._CONVERTION_BUFFER=new DataView(new ArrayBuffer(8));},'defaultRand',function(){return this.defaultRand=/*__JS__ */new Rand([0,Date.now()/ 65536,0,Date.now()% 65536]);}
	]);
	return RandX;
})()


/**
*<code>Picker</code> 类用于创建拾取。
*/
//class laya.d3.utils.Picker
var Picker=(function(){
	/**
	*创建一个 <code>Picker</code> 实例。
	*/
	function Picker(){}
	__class(Picker,'laya.d3.utils.Picker');
	Picker.calculateCursorRay=function(point,viewPort,projectionMatrix,viewMatrix,world,out){
		var x=point.x;
		var y=point.y;
		var nearSource=Picker._tempVector30;
		var nerSourceE=nearSource;
		nerSourceE.x=x;
		nerSourceE.y=y;
		nerSourceE.z=viewPort.minDepth;
		var farSource=Picker._tempVector31;
		var farSourceE=farSource;
		farSourceE.x=x;
		farSourceE.y=y;
		farSourceE.z=viewPort.maxDepth;
		var nearPoint=out.origin;
		var farPoint=Picker._tempVector32;
		viewPort.unprojectFromWVP(nearSource,projectionMatrix,viewMatrix,world,nearPoint);
		viewPort.unprojectFromWVP(farSource,projectionMatrix,viewMatrix,world,farPoint);
		var outDire=out.direction;
		outDire.x=farPoint.x-nearPoint.x;
		outDire.y=farPoint.y-nearPoint.y;
		outDire.z=farPoint.z-nearPoint.z;
		Vector3.normalize(out.direction,out.direction);
	}

	Picker.rayIntersectsTriangle=function(ray,vertex1,vertex2,vertex3){
		var result;
		var edge1=Picker._tempVector30,edge2=Picker._tempVector31;
		Vector3.subtract(vertex2,vertex1,edge1);
		Vector3.subtract(vertex3,vertex1,edge2);
		var directionCrossEdge2=Picker._tempVector32;
		Vector3.cross(ray.direction,edge2,directionCrossEdge2);
		var determinant;
		determinant=Vector3.dot(edge1,directionCrossEdge2);
		if (determinant >-Number.MIN_VALUE && determinant < Number.MIN_VALUE){
			result=Number.NaN;
			return result;
		};
		var inverseDeterminant=1.0 / determinant;
		var distanceVector=Picker._tempVector33;
		Vector3.subtract(ray.origin,vertex1,distanceVector);
		var triangleU;
		triangleU=Vector3.dot(distanceVector,directionCrossEdge2);
		triangleU *=inverseDeterminant;
		if (triangleU < 0 || triangleU > 1){
			result=Number.NaN;
			return result;
		};
		var distanceCrossEdge1=Picker._tempVector34;
		Vector3.cross(distanceVector,edge1,distanceCrossEdge1);
		var triangleV;
		triangleV=Vector3.dot(ray.direction,distanceCrossEdge1);
		triangleV *=inverseDeterminant;
		if (triangleV < 0 || triangleU+triangleV > 1){
			result=Number.NaN;
			return result;
		};
		var rayDistance;
		rayDistance=Vector3.dot(edge2,distanceCrossEdge1);
		rayDistance *=inverseDeterminant;
		if (rayDistance < 0){
			result=Number.NaN;
			return result;
		}
		result=rayDistance;
		return result;
	}

	__static(Picker,
	['_tempVector30',function(){return this._tempVector30=new Vector3();},'_tempVector31',function(){return this._tempVector31=new Vector3();},'_tempVector32',function(){return this._tempVector32=new Vector3();},'_tempVector33',function(){return this._tempVector33=new Vector3();},'_tempVector34',function(){return this._tempVector34=new Vector3();}
	]);
	return Picker;
})()


/**
*<code>Touch</code> 类用于实现触摸描述。
*/
//class laya.d3.Touch
var Touch=(function(){
	function Touch(){
		/**@private [实现IListPool接口]*/
		this._indexInList=-1;
		/**@private */
		this._identifier=-1;
		this._position=new Vector2();
	}

	__class(Touch,'laya.d3.Touch');
	var __proto=Touch.prototype;
	Laya.imps(__proto,{"laya.resource.ISingletonElement":true})
	/**
	*@private [实现ISingletonElement接口]
	*/
	__proto._getIndexInList=function(){
		return this._indexInList;
	}

	/**
	*@private [实现ISingletonElement接口]
	*/
	__proto._setIndexInList=function(index){
		this._indexInList=index;
	}

	/**
	*获取唯一识别ID。
	*@return 唯一识别ID。
	*/
	__getset(0,__proto,'identifier',function(){
		return this._identifier;
	});

	/**
	*获取触摸点的像素坐标。
	*@return 触摸点的像素坐标 [只读]。
	*/
	__getset(0,__proto,'position',function(){
		return this._position;
	});

	return Touch;
})()


/**
*<code>PixelLineData</code> 类用于表示线数据。
*/
//class laya.d3.core.pixelLine.PixelLineData
var PixelLineData=(function(){
	function PixelLineData(){
		this.startPosition=new Vector3();
		this.endPosition=new Vector3();
		this.startColor=new Color();
		this.endColor=new Color();
	}

	__class(PixelLineData,'laya.d3.core.pixelLine.PixelLineData');
	var __proto=PixelLineData.prototype;
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		this.startPosition.cloneTo(destObject.startPosition);
		this.endPosition.cloneTo(destObject.endPosition);
		this.startColor.cloneTo(destObject.startColor);
		this.endColor.cloneTo(destObject.endColor);
	}

	return PixelLineData;
})()


/**
*<code>Collision</code> 类用于创建物理碰撞信息。
*/
//class laya.d3.physics.Collision
var Collision=(function(){
	function Collision(){
		/**@private */
		this._lastUpdateFrame=-2147483648;
		/**@private */
		this._updateFrame=-2147483648;
		/**@private */
		this._isTrigger=false;
		/**@private */
		//this._colliderA=null;
		/**@private */
		//this._colliderB=null;
		/**@private [只读]*/
		//this.other=null;
		this.contacts=[];
	}

	__class(Collision,'laya.d3.physics.Collision');
	var __proto=Collision.prototype;
	/**
	*@private
	*/
	__proto._setUpdateFrame=function(farme){
		this._lastUpdateFrame=this._updateFrame;
		this._updateFrame=farme;
	}

	return Collision;
})()


/**
*@private
*<code>VertexDeclaration</code> 类用于生成顶点声明。
*/
//class laya.d3.graphics.VertexDeclaration
var VertexDeclaration=(function(){
	function VertexDeclaration(vertexStride,vertexElements){
		/**@private */
		this._id=0;
		/**@private */
		this._vertexStride=0;
		/**@private */
		this._vertexElementsDic=null;
		/**@private */
		this._shaderValues=null;
		/**@private */
		this._defineDatas=null;
		/**@private [只读]*/
		this.vertexElements=null;
		this._id=++VertexDeclaration._uniqueIDCounter;
		this._defineDatas=new DefineDatas();
		this._vertexElementsDic={};
		this._vertexStride=vertexStride;
		this.vertexElements=vertexElements;
		var count=vertexElements.length;
		this._shaderValues=new ShaderData(null);
		for (var j=0;j < count;j++){
			var vertexElement=vertexElements[j];
			var name=vertexElement.elementUsage;
			this._vertexElementsDic[name]=vertexElement;
			var value=new Int32Array(5);
			var elmentInfo=VertexElementFormat.getElementInfos(vertexElement.elementFormat);
			value[0]=elmentInfo[0];
			value[1]=elmentInfo[1];
			value[2]=elmentInfo[2];
			value[3]=this._vertexStride;
			value[4]=vertexElement.offset;
			this._shaderValues.setAttribute(name,value);
		}
	}

	__class(VertexDeclaration,'laya.d3.graphics.VertexDeclaration');
	var __proto=VertexDeclaration.prototype;
	/**
	*@private
	*/
	__proto.getVertexElementByUsage=function(usage){
		return this._vertexElementsDic[usage];
	}

	/**
	*@private
	*/
	__proto.unBinding=function(){}
	/**
	*获取唯一标识ID(通常用于优化或识别)。
	*@return 唯一标识ID
	*/
	__getset(0,__proto,'id',function(){
		return this._id;
	});

	/**
	*@private
	*/
	__getset(0,__proto,'vertexStride',function(){
		return this._vertexStride;
	});

	VertexDeclaration._uniqueIDCounter=1;
	return VertexDeclaration;
})()


/**
*<code>SkyRenderer</code> 类用于实现天空渲染器。
*/
//class laya.d3.resource.models.SkyRenderer
var SkyRenderer=(function(){
	function SkyRenderer(){
		/**@private */
		this._material=null;
		this._mesh=SkyBox.instance;
	}

	__class(SkyRenderer,'laya.d3.resource.models.SkyRenderer');
	var __proto=SkyRenderer.prototype;
	/**
	*@private
	*是否可用。
	*/
	__proto._isAvailable=function(){
		return this._material && this._mesh;
	}

	/**
	*@private
	*/
	__proto._render=function(state){
		if (this._material && this._mesh){
			var gl=LayaGL.instance;
			var scene=state.scene;
			var camera=state.camera;
			WebGLContext.setCullFace(gl,false);
			WebGLContext.setDepthFunc(gl,/*laya.webgl.WebGLContext.LEQUAL*/0x0203);
			WebGLContext.setDepthMask(gl,false);
			var shader=state.shader=this._material._shader.getSubShaderAt(0)._passes[0].withCompile(0,0,this._material._defineDatas.value);
			var switchShader=shader.bind();
			var switchShaderLoop=(Stat.loopCount!==shader._uploadMark);
			var uploadScene=(shader._uploadScene!==scene)|| switchShaderLoop;
			if (uploadScene || switchShader){
				shader.uploadUniforms(shader._sceneUniformParamsMap,scene._shaderValues,uploadScene);
				shader._uploadScene=scene;
			};
			var uploadCamera=(shader._uploadCamera!==camera)|| switchShaderLoop;
			if (uploadCamera || switchShader){
				shader.uploadUniforms(shader._cameraUniformParamsMap,camera._shaderValues,uploadCamera);
				shader._uploadCamera=camera;
			};
			var uploadMaterial=(shader._uploadMaterial!==this._material)|| switchShaderLoop;
			if (uploadMaterial || switchShader){
				shader.uploadUniforms(shader._materialUniformParamsMap,this._material._shaderValues,uploadMaterial);
				shader._uploadMaterial=this._material;
			}
			this._mesh._bufferState.bind();
			this._mesh._render(state);
			WebGLContext.setDepthFunc(gl,/*laya.webgl.WebGLContext.LESS*/0x0201);
			WebGLContext.setDepthMask(gl,true);
		}
	}

	/**
	*@private
	*/
	__proto.destroy=function(){
		if (this._material){
			this._material._removeReference();
			this._material=null;
		}
	}

	/**
	*设置材质。
	*@param 材质。
	*/
	/**
	*获取材质。
	*@return 材质。
	*/
	__getset(0,__proto,'material',function(){
		return this._material;
		},function(value){
		if (this._material!==value){
			(this._material)&& (this._material._removeReference());
			(value)&& (value._addReference());
			this._material=value;
		}
	});

	/**
	*设置网格。
	*@param 网格。
	*/
	/**
	*获取网格。
	*@return 网格。
	*/
	__getset(0,__proto,'mesh',function(){
		return this._mesh;
		},function(value){
		if (this._mesh!==value){
			this._mesh=value;
		}
	});

	return SkyRenderer;
})()


/**
*<code>AnimatorStateScript</code> 类用于动画状态脚本的父类,该类为抽象类,不允许实例。
*/
//class laya.d3.animation.AnimatorStateScript
var AnimatorStateScript=(function(){
	/**
	*创建一个新的 <code>AnimatorStateScript</code> 实例。
	*/
	function AnimatorStateScript(){}
	__class(AnimatorStateScript,'laya.d3.animation.AnimatorStateScript');
	var __proto=AnimatorStateScript.prototype;
	/**
	*动画状态开始时执行。
	*/
	__proto.onStateEnter=function(){}
	/**
	*动画状态更新时执行。
	*/
	__proto.onStateUpdate=function(){}
	/**
	*动画状态退出时执行。
	*/
	__proto.onStateExit=function(){}
	return AnimatorStateScript;
})()


/**
*@private
*/
//class laya.d3.core.render.BatchMark
var BatchMark=(function(){
	function BatchMark(){
		/**@private */
		this.updateMark=-1;
		/**@private */
		this.indexInList=-1;
		/**@private */
		this.batched=false;
	}

	__class(BatchMark,'laya.d3.core.render.BatchMark');
	return BatchMark;
})()


/**
*<code>HitResult</code> 类用于实现射线检测或形状扫描的结果。
*/
//class laya.d3.physics.HitResult
var HitResult=(function(){
	function HitResult(){
		/**是否成功。 */
		this.succeeded=false;
		/**发生碰撞的碰撞组件。*/
		this.collider=null;
		/**碰撞分数。 */
		this.hitFraction=0;
		this.point=new Vector3();
		this.normal=new Vector3();
	}

	__class(HitResult,'laya.d3.physics.HitResult');
	return HitResult;
})()


/**
*<code>GradientSize</code> 类用于创建渐变尺寸。
*/
//class laya.d3.core.particleShuriKen.module.GradientSize
var GradientSize=(function(){
	function GradientSize(){
		/**@private */
		this._type=0;
		/**@private */
		this._separateAxes=false;
		/**@private */
		this._gradient=null;
		/**@private */
		this._gradientX=null;
		/**@private */
		this._gradientY=null;
		/**@private */
		this._gradientZ=null;
		/**@private */
		this._constantMin=NaN;
		/**@private */
		this._constantMax=NaN;
		/**@private */
		this._constantMinSeparate=null;
		/**@private */
		this._constantMaxSeparate=null;
		/**@private */
		this._gradientMin=null;
		/**@private */
		this._gradientMax=null;
		/**@private */
		this._gradientXMin=null;
		/**@private */
		this._gradientXMax=null;
		/**@private */
		this._gradientYMin=null;
		/**@private */
		this._gradientYMax=null;
		/**@private */
		this._gradientZMin=null;
		/**@private */
		this._gradientZMax=null;
	}

	__class(GradientSize,'laya.d3.core.particleShuriKen.module.GradientSize');
	var __proto=GradientSize.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*获取最大尺寸。
	*/
	__proto.getMaxSizeInGradient=function(){
		var i=0,n=0;
		var maxSize=-Number.MAX_VALUE;
		switch (this._type){
			case 0:
				if (this._separateAxes){
					for (i=0,n=this._gradientX.gradientCount;i < n;i++)
					maxSize=Math.max(maxSize,this._gradientX.getValueByIndex(i));
					for (i=0,n=this._gradientY.gradientCount;i < n;i++)
					maxSize=Math.max(maxSize,this._gradientY.getValueByIndex(i));
					}else {
					for (i=0,n=this._gradient.gradientCount;i < n;i++)
					maxSize=Math.max(maxSize,this._gradient.getValueByIndex(i));
				}
				break ;
			case 1:
				if (this._separateAxes){
					maxSize=Math.max(this._constantMinSeparate.x,this._constantMaxSeparate.x);
					maxSize=Math.max(maxSize,this._constantMinSeparate.y);
					maxSize=Math.max(maxSize,this._constantMaxSeparate.y);
					}else {
					maxSize=Math.max(this._constantMin,this._constantMax);
				}
				break ;
			case 2:
				if (this._separateAxes){
					for (i=0,n=this._gradientXMin.gradientCount;i < n;i++)
					maxSize=Math.max(maxSize,this._gradientXMin.getValueByIndex(i));
					for (i=0,n=this._gradientXMax.gradientCount;i < n;i++)
					maxSize=Math.max(maxSize,this._gradientXMax.getValueByIndex(i));
					for (i=0,n=this._gradientYMin.gradientCount;i < n;i++)
					maxSize=Math.max(maxSize,this._gradientYMin.getValueByIndex(i));
					for (i=0,n=this._gradientZMax.gradientCount;i < n;i++)
					maxSize=Math.max(maxSize,this._gradientZMax.getValueByIndex(i));
					}else {
					for (i=0,n=this._gradientMin.gradientCount;i < n;i++)
					maxSize=Math.max(maxSize,this._gradientMin.getValueByIndex(i));
					for (i=0,n=this._gradientMax.gradientCount;i < n;i++)
					maxSize=Math.max(maxSize,this._gradientMax.getValueByIndex(i));
				}
				break ;
			}
		return maxSize;
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destGradientSize=destObject;
		destGradientSize._type=this._type;
		destGradientSize._separateAxes=this._separateAxes;
		this._gradient.cloneTo(destGradientSize._gradient);
		this._gradientX.cloneTo(destGradientSize._gradientX);
		this._gradientY.cloneTo(destGradientSize._gradientY);
		this._gradientZ.cloneTo(destGradientSize._gradientZ);
		destGradientSize._constantMin=this._constantMin;
		destGradientSize._constantMax=this._constantMax;
		this._constantMinSeparate.cloneTo(destGradientSize._constantMinSeparate);
		this._constantMaxSeparate.cloneTo(destGradientSize._constantMaxSeparate);
		this._gradientMin.cloneTo(destGradientSize._gradientMin);
		this._gradientMax.cloneTo(destGradientSize._gradientMax);
		this._gradientXMin.cloneTo(destGradientSize._gradientXMin);
		this._gradientXMax.cloneTo(destGradientSize._gradientXMax);
		this._gradientYMin.cloneTo(destGradientSize._gradientYMin);
		this._gradientYMax.cloneTo(destGradientSize._gradientYMax);
		this._gradientZMin.cloneTo(destGradientSize._gradientZMin);
		this._gradientZMax.cloneTo(destGradientSize._gradientZMax);
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destGradientSize=/*__JS__ */new this.constructor();
		this.cloneTo(destGradientSize);
		return destGradientSize;
	}

	/**
	*渐变尺寸Z。
	*/
	__getset(0,__proto,'gradientZ',function(){
		return this._gradientZ;
	});

	/**
	*渐变尺寸。
	*/
	__getset(0,__proto,'gradient',function(){
		return this._gradient;
	});

	/**
	*是否分轴。
	*/
	__getset(0,__proto,'separateAxes',function(){
		return this._separateAxes;
	});

	/**
	*生命周期尺寸类型，0曲线模式，1随机双常量模式，2随机双曲线模式。
	*/
	__getset(0,__proto,'type',function(){
		return this._type;
	});

	/**
	*渐变最小尺寸。
	*/
	__getset(0,__proto,'gradientMin',function(){
		return this._gradientMin;
	});

	/**
	*最小随机双固定尺寸。
	*/
	__getset(0,__proto,'constantMin',function(){
		return this._constantMin;
	});

	/**
	*渐变尺寸X。
	*/
	__getset(0,__proto,'gradientX',function(){
		return this._gradientX;
	});

	/**
	*渐变尺寸Y。
	*/
	__getset(0,__proto,'gradientY',function(){
		return this._gradientY;
	});

	/**
	*渐变最大尺寸。
	*/
	__getset(0,__proto,'gradientMax',function(){
		return this._gradientMax;
	});

	/**
	*最大随机双固定尺寸。
	*/
	__getset(0,__proto,'constantMax',function(){
		return this._constantMax;
	});

	/**
	*最小分轴随机双固定尺寸。
	*/
	__getset(0,__proto,'constantMinSeparate',function(){
		return this._constantMinSeparate;
	});

	/**
	*最小分轴随机双固定尺寸。
	*/
	__getset(0,__proto,'constantMaxSeparate',function(){
		return this._constantMaxSeparate;
	});

	/**
	*渐变最小尺寸X。
	*/
	__getset(0,__proto,'gradientXMin',function(){
		return this._gradientXMin;
	});

	/**
	*渐变最大尺寸X。
	*/
	__getset(0,__proto,'gradientXMax',function(){
		return this._gradientXMax;
	});

	/**
	*渐变最小尺寸Y。
	*/
	__getset(0,__proto,'gradientYMin',function(){
		return this._gradientYMin;
	});

	/**
	*渐变最大尺寸Y。
	*/
	__getset(0,__proto,'gradientYMax',function(){
		return this._gradientYMax;
	});

	/**
	*渐变最小尺寸Z。
	*/
	__getset(0,__proto,'gradientZMin',function(){
		return this._gradientZMin;
	});

	/**
	*渐变最大尺寸Z。
	*/
	__getset(0,__proto,'gradientZMax',function(){
		return this._gradientZMax;
	});

	GradientSize.createByGradient=function(gradient){
		var gradientSize=new GradientSize();
		gradientSize._type=0;
		gradientSize._separateAxes=false;
		gradientSize._gradient=gradient;
		return gradientSize;
	}

	GradientSize.createByGradientSeparate=function(gradientX,gradientY,gradientZ){
		var gradientSize=new GradientSize();
		gradientSize._type=0;
		gradientSize._separateAxes=true;
		gradientSize._gradientX=gradientX;
		gradientSize._gradientY=gradientY;
		gradientSize._gradientZ=gradientZ;
		return gradientSize;
	}

	GradientSize.createByRandomTwoConstant=function(constantMin,constantMax){
		var gradientSize=new GradientSize();
		gradientSize._type=1;
		gradientSize._separateAxes=false;
		gradientSize._constantMin=constantMin;
		gradientSize._constantMax=constantMax;
		return gradientSize;
	}

	GradientSize.createByRandomTwoConstantSeparate=function(constantMinSeparate,constantMaxSeparate){
		var gradientSize=new GradientSize();
		gradientSize._type=1;
		gradientSize._separateAxes=true;
		gradientSize._constantMinSeparate=constantMinSeparate;
		gradientSize._constantMaxSeparate=constantMaxSeparate;
		return gradientSize;
	}

	GradientSize.createByRandomTwoGradient=function(gradientMin,gradientMax){
		var gradientSize=new GradientSize();
		gradientSize._type=2;
		gradientSize._separateAxes=false;
		gradientSize._gradientMin=gradientMin;
		gradientSize._gradientMax=gradientMax;
		return gradientSize;
	}

	GradientSize.createByRandomTwoGradientSeparate=function(gradientXMin,gradientXMax,gradientYMin,gradientYMax,gradientZMin,gradientZMax){
		var gradientSize=new GradientSize();
		gradientSize._type=2;
		gradientSize._separateAxes=true;
		gradientSize._gradientXMin=gradientXMin;
		gradientSize._gradientXMax=gradientXMax;
		gradientSize._gradientYMin=gradientYMin;
		gradientSize._gradientYMax=gradientYMax;
		gradientSize._gradientZMin=gradientZMin;
		gradientSize._gradientZMax=gradientZMax;
		return gradientSize;
	}

	return GradientSize;
})()


/**
*<code>DetailTextureInfo</code> 类用于描述地形细节纹理。
*/
//class laya.d3.terrain.unit.ChunkInfo
var ChunkInfo=(function(){
	function ChunkInfo(){
		this.alphaMap=null;
		this.detailID=null;
		this.normalMap=null;
	}

	__class(ChunkInfo,'laya.d3.terrain.unit.ChunkInfo');
	return ChunkInfo;
})()


/**
*@private
*<code>shaderVariable</code> 类用于保存shader变量上传相关信息。
*/
//class laya.d3.shader.ShaderVariable
var ShaderVariable=(function(){
	function ShaderVariable(){
		/**@private */
		//this.name=null;
		/**@private */
		//this.type=0;
		/**@private */
		//this.location=0;
		/**@private */
		//this.isArray=false;
		/**@private */
		//this.textureID=0;
		/**@private */
		//this.dataOffset=0;
		/**@private */
		//this.caller=null;
		/**@private */
		//this.fun=null;
		/**@private */
		//this.uploadedValue=null;
		this.textureID=-1;
	}

	__class(ShaderVariable,'laya.d3.shader.ShaderVariable');
	return ShaderVariable;
})()


/**
*@private
*/
//class laya.d3.animation.KeyframeNode
var KeyframeNode=(function(){
	function KeyframeNode(){
		/**@private */
		this._indexInList=0;
		/**@private */
		this.type=0;
		/**@private */
		this.fullPath=null;
		/**@private */
		this.propertyOwner=null;
		/**@private */
		this.data=null;
		this._ownerPath=[];
		this._propertys=[];
		this._keyFrames=[];
	}

	__class(KeyframeNode,'laya.d3.animation.KeyframeNode');
	var __proto=KeyframeNode.prototype;
	/**
	*@private
	*/
	__proto._setOwnerPathCount=function(value){
		this._ownerPath.length=value;
	}

	/**
	*@private
	*/
	__proto._setOwnerPathByIndex=function(index,value){
		this._ownerPath[index]=value;
	}

	/**
	*@private
	*/
	__proto._joinOwnerPath=function(sep){
		return this._ownerPath.join(sep);
	}

	/**
	*@private
	*/
	__proto._setPropertyCount=function(value){
		this._propertys.length=value;
	}

	/**
	*@private
	*/
	__proto._setPropertyByIndex=function(index,value){
		this._propertys[index]=value;
	}

	/**
	*@private
	*/
	__proto._joinProperty=function(sep){
		return this._propertys.join(sep);
	}

	/**
	*@private
	*/
	__proto._setKeyframeCount=function(value){
		this._keyFrames.length=value;
	}

	/**
	*@private
	*/
	__proto._setKeyframeByIndex=function(index,value){
		this._keyFrames[index]=value;
	}

	/**
	*通过索引获取精灵路径。
	*@param index 索引。
	*/
	__proto.getOwnerPathByIndex=function(index){
		return this._ownerPath[index];
	}

	/**
	*通过索引获取属性路径。
	*@param index 索引。
	*/
	__proto.getPropertyByIndex=function(index){
		return this._propertys[index];
	}

	/**
	*通过索引获取帧。
	*@param index 索引。
	*/
	__proto.getKeyframeByIndex=function(index){
		return this._keyFrames[index];
	}

	/**
	*获取精灵路径个数。
	*@return 精灵路径个数。
	*/
	__getset(0,__proto,'ownerPathCount',function(){
		return this._ownerPath.length;
	});

	/**
	*获取属性路径个数。
	*@return 数量路径个数。
	*/
	__getset(0,__proto,'propertyCount',function(){
		return this._propertys.length;
	});

	/**
	*获取帧个数。
	*帧个数。
	*/
	__getset(0,__proto,'keyFramesCount',function(){
		return this._keyFrames.length;
	});

	return KeyframeNode;
})()


/**
*<code>GradientVelocity</code> 类用于创建渐变速度。
*/
//class laya.d3.core.particleShuriKen.module.GradientVelocity
var GradientVelocity=(function(){
	function GradientVelocity(){
		/**@private */
		this._type=0;
		/**@private */
		this._constant=null;
		/**@private */
		this._gradientX=null;
		/**@private */
		this._gradientY=null;
		/**@private */
		this._gradientZ=null;
		/**@private */
		this._constantMin=null;
		/**@private */
		this._constantMax=null;
		/**@private */
		this._gradientXMin=null;
		/**@private */
		this._gradientXMax=null;
		/**@private */
		this._gradientYMin=null;
		/**@private */
		this._gradientYMax=null;
		/**@private */
		this._gradientZMin=null;
		/**@private */
		this._gradientZMax=null;
	}

	__class(GradientVelocity,'laya.d3.core.particleShuriKen.module.GradientVelocity');
	var __proto=GradientVelocity.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destGradientVelocity=destObject;
		destGradientVelocity._type=this._type;
		this._constant.cloneTo(destGradientVelocity._constant);
		this._gradientX.cloneTo(destGradientVelocity._gradientX);
		this._gradientY.cloneTo(destGradientVelocity._gradientY);
		this._gradientZ.cloneTo(destGradientVelocity._gradientZ);
		this._constantMin.cloneTo(destGradientVelocity._constantMin);
		this._constantMax.cloneTo(destGradientVelocity._constantMax);
		this._gradientXMin.cloneTo(destGradientVelocity._gradientXMin);
		this._gradientXMax.cloneTo(destGradientVelocity._gradientXMax);
		this._gradientYMin.cloneTo(destGradientVelocity._gradientYMin);
		this._gradientYMax.cloneTo(destGradientVelocity._gradientYMax);
		this._gradientZMin.cloneTo(destGradientVelocity._gradientZMin);
		this._gradientZMax.cloneTo(destGradientVelocity._gradientZMax);
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destGradientVelocity=/*__JS__ */new this.constructor();
		this.cloneTo(destGradientVelocity);
		return destGradientVelocity;
	}

	/**
	*渐变速度Z。
	*/
	__getset(0,__proto,'gradientZ',function(){
		return this._gradientZ;
	});

	/**固定速度。*/
	__getset(0,__proto,'constant',function(){
		return this._constant;
	});

	/**
	*生命周期速度类型，0常量模式，1曲线模式，2随机双常量模式，3随机双曲线模式。
	*/
	__getset(0,__proto,'type',function(){
		return this._type;
	});

	/**
	*渐变最大速度X。
	*/
	__getset(0,__proto,'gradientXMax',function(){
		return this._gradientXMax;
	});

	/**最小固定速度。*/
	__getset(0,__proto,'constantMin',function(){
		return this._constantMin;
	});

	/**
	*渐变速度X。
	*/
	__getset(0,__proto,'gradientX',function(){
		return this._gradientX;
	});

	/**
	*渐变速度Y。
	*/
	__getset(0,__proto,'gradientY',function(){
		return this._gradientY;
	});

	/**
	*渐变最小速度X。
	*/
	__getset(0,__proto,'gradientXMin',function(){
		return this._gradientXMin;
	});

	/**最大固定速度。*/
	__getset(0,__proto,'constantMax',function(){
		return this._constantMax;
	});

	/**
	*渐变最小速度Y。
	*/
	__getset(0,__proto,'gradientYMin',function(){
		return this._gradientYMin;
	});

	/**
	*渐变最大速度Y。
	*/
	__getset(0,__proto,'gradientYMax',function(){
		return this._gradientYMax;
	});

	/**
	*渐变最小速度Z。
	*/
	__getset(0,__proto,'gradientZMin',function(){
		return this._gradientZMin;
	});

	/**
	*渐变最大速度Z。
	*/
	__getset(0,__proto,'gradientZMax',function(){
		return this._gradientZMax;
	});

	GradientVelocity.createByConstant=function(constant){
		var gradientVelocity=new GradientVelocity();
		gradientVelocity._type=0;
		gradientVelocity._constant=constant;
		return gradientVelocity;
	}

	GradientVelocity.createByGradient=function(gradientX,gradientY,gradientZ){
		var gradientVelocity=new GradientVelocity();
		gradientVelocity._type=1;
		gradientVelocity._gradientX=gradientX;
		gradientVelocity._gradientY=gradientY;
		gradientVelocity._gradientZ=gradientZ;
		return gradientVelocity;
	}

	GradientVelocity.createByRandomTwoConstant=function(constantMin,constantMax){
		var gradientVelocity=new GradientVelocity();
		gradientVelocity._type=2;
		gradientVelocity._constantMin=constantMin;
		gradientVelocity._constantMax=constantMax;
		return gradientVelocity;
	}

	GradientVelocity.createByRandomTwoGradient=function(gradientXMin,gradientXMax,gradientYMin,gradientYMax,gradientZMin,gradientZMax){
		var gradientVelocity=new GradientVelocity();
		gradientVelocity._type=3;
		gradientVelocity._gradientXMin=gradientXMin;
		gradientVelocity._gradientXMax=gradientXMax;
		gradientVelocity._gradientYMin=gradientYMin;
		gradientVelocity._gradientYMax=gradientYMax;
		gradientVelocity._gradientZMin=gradientZMin;
		gradientVelocity._gradientZMax=gradientZMax;
		return gradientVelocity;
	}

	return GradientVelocity;
})()


/**
*<code>Bounds</code> 类用于创建包围体。
*/
//class laya.d3.core.Bounds
var Bounds=(function(){
	function Bounds(min,max){
		/**@private */
		this._updateFlag=0;
		this._center=new Vector3();
		this._extent=new Vector3();
		this._boundBox=new BoundBox(new Vector3(),new Vector3());
		min.cloneTo(this._boundBox.min);
		max.cloneTo(this._boundBox.max);
		this._setUpdateFlag(0x04 | 0x08,true);
	}

	__class(Bounds,'laya.d3.core.Bounds');
	var __proto=Bounds.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*设置包围盒的最小点。
	*@param value 包围盒的最小点。
	*/
	__proto.setMin=function(value){
		var min=this._boundBox.min;
		if (value!==min)
			value.cloneTo(min);
		this._setUpdateFlag(0x04 | 0x08,true);
		this._setUpdateFlag(0x01,false);
	}

	/**
	*获取包围盒的最小点。
	*@return 包围盒的最小点。
	*/
	__proto.getMin=function(){
		var min=this._boundBox.min;
		if (this._getUpdateFlag(0x01)){
			this._getMin(this.getCenter(),this.getExtent(),min);
			this._setUpdateFlag(0x01,false);
		}
		return min;
	}

	/**
	*设置包围盒的最大点。
	*@param value 包围盒的最大点。
	*/
	__proto.setMax=function(value){
		var max=this._boundBox.max;
		if (value!==max)
			value.cloneTo(max);
		this._setUpdateFlag(0x04 | 0x08,true);
		this._setUpdateFlag(0x02,false);
	}

	/**
	*获取包围盒的最大点。
	*@return 包围盒的最大点。
	*/
	__proto.getMax=function(){
		var max=this._boundBox.max;
		if (this._getUpdateFlag(0x02)){
			this._getMax(this.getCenter(),this.getExtent(),max);
			this._setUpdateFlag(0x02,false);
		}
		return max;
	}

	/**
	*设置包围盒的中心点。
	*@param value 包围盒的中心点。
	*/
	__proto.setCenter=function(value){
		if (value!==this._center)
			value.cloneTo(this._center);
		this._setUpdateFlag(0x01 | 0x02,true);
		this._setUpdateFlag(0x04,false);
	}

	/**
	*获取包围盒的中心点。
	*@return 包围盒的中心点。
	*/
	__proto.getCenter=function(){
		if (this._getUpdateFlag(0x04)){
			this._getCenter(this.getMin(),this.getMax(),this._center);
			this._setUpdateFlag(0x04,false);
		}
		return this._center;
	}

	/**
	*设置包围盒的范围。
	*@param value 包围盒的范围。
	*/
	__proto.setExtent=function(value){
		if (value!==this._extent)
			value.cloneTo(this._extent);
		this._setUpdateFlag(0x01 | 0x02,true);
		this._setUpdateFlag(0x08,false);
	}

	/**
	*获取包围盒的范围。
	*@return 包围盒的范围。
	*/
	__proto.getExtent=function(){
		if (this._getUpdateFlag(0x08)){
			this._getExtent(this.getMin(),this.getMax(),this._extent);
			this._setUpdateFlag(0x08,false);
		}
		return this._extent;
	}

	/**
	*@private
	*/
	__proto._getUpdateFlag=function(type){
		return (this._updateFlag & type)!=0;
	}

	/**
	*@private
	*/
	__proto._setUpdateFlag=function(type,value){
		if (value)
			this._updateFlag |=type;
		else
		this._updateFlag &=~type;
	}

	/**
	*@private
	*/
	__proto._getCenter=function(min,max,out){
		Vector3.add(min,max,out);
		Vector3.scale(out,0.5,out);
	}

	/**
	*@private
	*/
	__proto._getExtent=function(min,max,out){
		Vector3.subtract(max,min,out);
		Vector3.scale(out,0.5,out);
	}

	/**
	*@private
	*/
	__proto._getMin=function(center,extent,out){
		Vector3.subtract(center,extent,out);
	}

	/**
	*@private
	*/
	__proto._getMax=function(center,extent,out){
		Vector3.add(center,extent,out);
	}

	/**
	*@private
	*/
	__proto._rotateExtents=function(extents,rotation,out){
		var extentsX=extents.x;
		var extentsY=extents.y;
		var extentsZ=extents.z;
		var matE=rotation.elements;
		out.x=Math.abs(matE[0] *extentsX)+Math.abs(matE[4] *extentsY)+Math.abs(matE[8] *extentsZ);
		out.y=Math.abs(matE[1] *extentsX)+Math.abs(matE[5] *extentsY)+Math.abs(matE[9] *extentsZ);
		out.z=Math.abs(matE[2] *extentsX)+Math.abs(matE[6] *extentsY)+Math.abs(matE[10] *extentsZ);
	}

	/**
	*@private
	*/
	__proto._tranform=function(matrix,out){
		var outCen=out._center;
		var outExt=out._extent;
		Vector3.transformCoordinate(this.getCenter(),matrix,outCen);
		this._rotateExtents(this.getExtent(),matrix,outExt);
		out._boundBox.setCenterAndExtent(outCen,outExt);
		out._updateFlag=0;
	}

	/**
	*@private
	*/
	__proto._getBoundBox=function(){
		var min=this._boundBox.min;
		if (this._getUpdateFlag(0x01)){
			this._getMin(this.getCenter(),this.getExtent(),min);
			this._setUpdateFlag(0x01,false);
		};
		var max=this._boundBox.max;
		if (this._getUpdateFlag(0x02)){
			this._getMax(this.getCenter(),this.getExtent(),max);
			this._setUpdateFlag(0x02,false);
		}
		return this._boundBox;
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destBounds=destObject;
		this.getMin().cloneTo(destBounds._boundBox.min);
		this.getMax().cloneTo(destBounds._boundBox.max);
		this.getCenter().cloneTo(destBounds._center);
		this.getExtent().cloneTo(destBounds._extent);
		destBounds._updateFlag=0;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var dest=/*__JS__ */new this.constructor();
		this.cloneTo(dest);
		return dest;
	}

	Bounds._UPDATE_MIN=0x01;
	Bounds._UPDATE_MAX=0x02;
	Bounds._UPDATE_CENTER=0x04;
	Bounds._UPDATE_EXTENT=0x08;
	return Bounds;
})()


/**
*<code>StartFrame</code> 类用于创建开始帧。
*/
//class laya.d3.core.particleShuriKen.module.StartFrame
var StartFrame=(function(){
	function StartFrame(){
		/**@private */
		this._type=0;
		/**@private */
		this._constant=NaN;
		/**@private */
		this._constantMin=NaN;
		/**@private */
		this._constantMax=NaN;
	}

	__class(StartFrame,'laya.d3.core.particleShuriKen.module.StartFrame');
	var __proto=StartFrame.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destStartFrame=destObject;
		destStartFrame._type=this._type;
		destStartFrame._constant=this._constant;
		destStartFrame._constantMin=this._constantMin;
		destStartFrame._constantMax=this._constantMax;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destStartFrame=/*__JS__ */new this.constructor();
		this.cloneTo(destStartFrame);
		return destStartFrame;
	}

	/**
	*固定帧。
	*/
	__getset(0,__proto,'constant',function(){
		return this._constant;
	});

	/**
	*开始帧类型,0常量模式，1随机双常量模式。
	*/
	__getset(0,__proto,'type',function(){
		return this._type;
	});

	/**
	*最小固定帧。
	*/
	__getset(0,__proto,'constantMin',function(){
		return this._constantMin;
	});

	/**
	*最大固定帧。
	*/
	__getset(0,__proto,'constantMax',function(){
		return this._constantMax;
	});

	StartFrame.createByConstant=function(constant){
		var rotationOverLifetime=new StartFrame();
		rotationOverLifetime._type=0;
		rotationOverLifetime._constant=constant;
		return rotationOverLifetime;
	}

	StartFrame.createByRandomTwoConstant=function(constantMin,constantMax){
		var rotationOverLifetime=new StartFrame();
		rotationOverLifetime._type=1;
		rotationOverLifetime._constantMin=constantMin;
		rotationOverLifetime._constantMax=constantMax;
		return rotationOverLifetime;
	}

	return StartFrame;
})()


/**
*<code>BoneNode</code> 类用于实现骨骼节点。
*/
//class laya.d3.animation.AnimationNode
var AnimationNode=(function(){
	function AnimationNode(localPosition,localRotation,localScale,worldMatrix){
		/**@private */
		//this._children=null;
		/**@private */
		//this._parent=null;
		/**@private [只读]*/
		//this.transform=null;
		/**节点名称。 */
		//this.name=null;
		/**@private [NATIVE]*/
		//this._worldMatrixIndex=0;
		this._children=[];
		this.transform=new AnimationTransform3D(this,localPosition,localRotation,localScale,worldMatrix);
	}

	__class(AnimationNode,'laya.d3.animation.AnimationNode');
	var __proto=AnimationNode.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*添加子节点。
	*@param child 子节点。
	*/
	__proto.addChild=function(child){
		child._parent=this;
		child.transform.setParent(this.transform);
		this._children.push(child);
	}

	/**
	*移除子节点。
	*@param child 子节点。
	*/
	__proto.removeChild=function(child){
		var index=this._children.indexOf(child);
		(index!==-1)&& (this._children.splice(index,1));
	}

	/**
	*根据名字获取子节点。
	*@param name 名字。
	*/
	__proto.getChildByName=function(name){
		for (var i=0,n=this._children.length;i < n;i++){
			var child=this._children[i];
			if (child.name===name)
				return child;
		}
		return null;
	}

	/**
	*根据索引获取子节点。
	*@param index 索引。
	*/
	__proto.getChildByIndex=function(index){
		return this._children[index];
	}

	/**
	*获取子节点的个数。
	*/
	__proto.getChildCount=function(){
		return this._children.length;
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destNode=destObject;
		destNode.name=this.name;
		for (var i=0,n=this._children.length;i < n;i++){
			var child=this._children[i];
			var destChild=child.clone();
			destNode.addChild(destChild);
			var transform=child.transform;
			var destTransform=destChild.transform;
			var destLocalPosition=destTransform.localPosition;
			var destLocalRotation=destTransform.localRotation;
			var destLocalScale=destTransform.localScale;
			transform.localPosition.cloneTo(destLocalPosition);
			transform.localRotation.cloneTo(destLocalRotation);
			transform.localScale.cloneTo(destLocalScale);
			destTransform.localPosition=destLocalPosition;
			destTransform.localRotation=destLocalRotation;
			destTransform.localScale=destLocalScale;
		}
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var dest=new AnimationNode();
		this.cloneTo(dest);
		return dest;
	}

	/**
	*@private [NATIVE]
	*/
	__proto._cloneNative=function(localPositions,localRotations,localScales,animationNodeWorldMatrixs,animationNodeParentIndices,parentIndex,avatar){
		var curID=avatar._nativeCurCloneCount;
		animationNodeParentIndices[curID]=parentIndex;
		var localPosition=new Float32Array(localPositions.buffer,curID *3 *4,3);
		var localRotation=new Float32Array(localRotations.buffer,curID *4 *4,4);
		var localScale=new Float32Array(localScales.buffer,curID *3 *4,3);
		var worldMatrix=new Float32Array(animationNodeWorldMatrixs.buffer,curID *16 *4,16);
		var dest=new AnimationNode(localPosition,localRotation,localScale,worldMatrix);
		dest._worldMatrixIndex=curID;
		this._cloneToNative(dest,localPositions,localRotations,localScales,animationNodeWorldMatrixs,animationNodeParentIndices,curID,avatar);
		return dest;
	}

	/**
	*@private [NATIVE]
	*/
	__proto._cloneToNative=function(destObject,localPositions,localRotations,localScales,animationNodeWorldMatrixs,animationNodeParentIndices,parentIndex,avatar){
		var destNode=destObject;
		destNode.name=this.name;
		for (var i=0,n=this._children.length;i < n;i++){
			var child=this._children[i];
			avatar._nativeCurCloneCount++;
			var destChild=child._cloneNative(localPositions,localRotations,localScales,animationNodeWorldMatrixs,animationNodeParentIndices,parentIndex,avatar);
			destNode.addChild(destChild);
			var transform=child.transform;
			var destTransform=destChild.transform;
			var destLocalPosition=destTransform.localPosition;
			var destLocalRotation=destTransform.localRotation;
			var destLocalScale=destTransform.localScale;
			transform.localPosition.cloneTo(destLocalPosition);
			transform.localRotation.cloneTo(destLocalRotation);
			transform.localScale.cloneTo(destLocalScale);
			destTransform.localPosition=destLocalPosition;
			destTransform.localRotation=destLocalRotation;
			destTransform.localScale=destLocalScale;
		}
	}

	return AnimationNode;
})()


/**
*<code>PostProcess</code> 类用于创建后期处理组件。
*/
//class laya.d3.component.PostProcess
var PostProcess=(function(){
	function PostProcess(){
		/**@private */
		this._context=null;
		this._compositeShader=Shader3D.find("PostProcessComposite");
		this._compositeShaderData=new ShaderData();
		this._compositeDefineData=new DefineDatas();
		this._effects=[];
		this._context=new PostProcessRenderContext();
		this._context.compositeShaderData=this._compositeShaderData;
		this._context.compositeDefineData=this._compositeDefineData;
	}

	__class(PostProcess,'laya.d3.component.PostProcess');
	var __proto=PostProcess.prototype;
	/**
	*@private
	*/
	__proto._init=function(camera,command){
		this._context.camera=camera;
		this._context.command=command;
	}

	/**
	*@private
	*/
	__proto._render=function(){
		var screenTexture=RenderTexture.getTemporary(RenderContext3D.clientWidth,RenderContext3D.clientHeight,/*laya.resource.BaseTexture.FORMAT_R8G8B8*/0,/*laya.resource.BaseTexture.FORMAT_DEPTHSTENCIL_NONE*/3);
		var cameraTarget=this._context.camera.getRenderTexture();
		this._context.command.clear();
		this._context.source=screenTexture;
		this._context.destination=cameraTarget;
		for (var i=0,n=this._effects.length;i < n;i++)
		this._effects[i].render(this._context);
		RenderTexture.setReleaseTemporary(screenTexture);
		var tempRenderTextures=this._context.tempRenderTextures;
		for (i=0,n=tempRenderTextures.length;i < n;i++)
		RenderTexture.setReleaseTemporary(tempRenderTextures[i]);
	}

	/**
	*添加后期处理效果。
	*/
	__proto.addEffect=function(effect){
		this._effects.push(effect);
	}

	/**
	*移除后期处理效果。
	*/
	__proto.removeEffect=function(effect){
		var index=this._effects.indexOf(effect);
		if (index!==-1)
			this._effects.splice(index,1);
	}

	PostProcess.__init__=function(){
		PostProcess.SHADERDEFINE_BLOOM_LOW=PostProcess.shaderDefines.registerDefine("BLOOM_LOW");
		PostProcess.SHADERDEFINE_BLOOM=PostProcess.shaderDefines.registerDefine("BLOOM");
	}

	PostProcess.SHADERDEFINE_BLOOM_LOW=0;
	PostProcess.SHADERDEFINE_BLOOM=0;
	__static(PostProcess,
	['SHADERVALUE_MAINTEX',function(){return this.SHADERVALUE_MAINTEX=Shader3D.propertyNameToID("u_MainTex");},'SHADERVALUE_BLOOMTEX',function(){return this.SHADERVALUE_BLOOMTEX=Shader3D.propertyNameToID("u_BloomTex");},'SHADERVALUE_AUTOEXPOSURETEX',function(){return this.SHADERVALUE_AUTOEXPOSURETEX=Shader3D.propertyNameToID("u_AutoExposureTex");},'SHADERVALUE_BLOOM_DIRTTEX',function(){return this.SHADERVALUE_BLOOM_DIRTTEX=Shader3D.propertyNameToID("u_Bloom_DirtTex");},'SHADERVALUE_BLOOMTEX_TEXELSIZE',function(){return this.SHADERVALUE_BLOOMTEX_TEXELSIZE=Shader3D.propertyNameToID("u_BloomTex_TexelSize");},'SHADERVALUE_BLOOM_DIRTTILEOFFSET',function(){return this.SHADERVALUE_BLOOM_DIRTTILEOFFSET=Shader3D.propertyNameToID("u_Bloom_DirtTileOffset");},'SHADERVALUE_BLOOM_SETTINGS',function(){return this.SHADERVALUE_BLOOM_SETTINGS=Shader3D.propertyNameToID("u_Bloom_Settings");},'SHADERVALUE_BLOOM_COLOR',function(){return this.SHADERVALUE_BLOOM_COLOR=Shader3D.propertyNameToID("u_Bloom_Color");},'shaderDefines',function(){return this.shaderDefines=new ShaderDefines();}
	]);
	return PostProcess;
})()


/**
*<code>Viewport</code> 类用于创建视口。
*/
//class laya.d3.math.Viewport
var Viewport=(function(){
	function Viewport(x,y,width,height){
		/**X轴坐标*/
		//this.x=NaN;
		/**Y轴坐标*/
		//this.y=NaN;
		/**宽度*/
		//this.width=NaN;
		/**高度*/
		//this.height=NaN;
		/**最小深度*/
		//this.minDepth=NaN;
		/**最大深度*/
		//this.maxDepth=NaN;
		this.minDepth=0.0;
		this.maxDepth=1.0;
		this.x=x;
		this.y=y;
		this.width=width;
		this.height=height;
	}

	__class(Viewport,'laya.d3.math.Viewport');
	var __proto=Viewport.prototype;
	/**
	*变换一个三维向量。
	*@param source 源三维向量。
	*@param matrix 变换矩阵。
	*@param vector 输出三维向量。
	*/
	__proto.project=function(source,matrix,out){
		Vector3.transformV3ToV3(source,matrix,out);
		var matrixEleme=matrix.elements;
		var a=(((source.x *matrixEleme[3])+(source.y *matrixEleme[7]))+(source.z *matrixEleme[11]))+matrixEleme[15];
		if (a!==1.0){
			out.x=out.x / a;
			out.y=out.y / a;
			out.z=out.z / a;
		}
		out.x=(((out.x+1.0)*0.5)*this.width)+this.x;
		out.y=(((-out.y+1.0)*0.5)*this.height)+this.y;
		out.z=(out.z *(this.maxDepth-this.minDepth))+this.minDepth;
	}

	__proto.project1=function(source,matrix,out){
		var v4=Vector3._tempVector4;
		Vector3.transformV3ToV4(source,matrix,v4);
		var dist=v4.w;
		if (dist < 1e-1 && dist >-1e-6)dist=1e-6;
		v4.x /=dist;
		v4.y /=dist;
		v4.z /=dist;
		out.x=(v4.x+1)*this.width / 2+this.x;
		out.y=(-v4.y+1)*this.height / 2+this.y;
		out.z=v4.w;
		return;
	}

	/**
	*反变换一个三维向量。
	*@param source 源三维向量。
	*@param matrix 变换矩阵。
	*@param vector 输出三维向量。
	*/
	__proto.unprojectFromMat=function(source,matrix,out){
		var matrixEleme=matrix.elements;
		out.x=(((source.x-this.x)/ (this.width))*2.0)-1.0;
		out.y=-((((source.y-this.y)/ (this.height))*2.0)-1.0);
		var halfDepth=(this.maxDepth-this.minDepth)/ 2;
		out.z=(source.z-this.minDepth-halfDepth)/ halfDepth;
		var a=(((out.x *matrixEleme[3])+(out.y *matrixEleme[7]))+(out.z *matrixEleme[11]))+matrixEleme[15];
		Vector3.transformV3ToV3(out,matrix,out);
		if (a!==1.0){
			out.x=out.x / a;
			out.y=out.y / a;
			out.z=out.z / a;
		}
	}

	/**
	*反变换一个三维向量。
	*@param source 源三维向量。
	*@param projection 透视投影矩阵。
	*@param view 视图矩阵。
	*@param world 世界矩阵,可设置为null。
	*@param out 输出向量。
	*/
	__proto.unprojectFromWVP=function(source,projection,view,world,out){
		Matrix4x4.multiply(projection,view,Viewport._tempMatrix4x4);
		(world)&& (Matrix4x4.multiply(Viewport._tempMatrix4x4,world,Viewport._tempMatrix4x4));
		Viewport._tempMatrix4x4.invert(Viewport._tempMatrix4x4);
		this.unprojectFromMat(source,Viewport._tempMatrix4x4,out);
	}

	/**
	*克隆
	*@param out
	*/
	__proto.cloneTo=function(out){
		out.x=this.x;
		out.y=this.y;
		out.width=this.width;
		out.height=this.height;
		out.minDepth=this.minDepth;
		out.maxDepth=this.maxDepth;
	}

	__static(Viewport,
	['_tempMatrix4x4',function(){return this._tempMatrix4x4=new Matrix4x4();}
	]);
	return Viewport;
})()


/**
*<code>DetailTextureInfo</code> 类用于描述地形细节纹理。
*/
//class laya.d3.terrain.unit.DetailTextureInfo
var DetailTextureInfo=(function(){
	function DetailTextureInfo(){
		this.diffuseTexture=null;
		this.normalTexture=null;
		this.scale=null;
		this.offset=null;
	}

	__class(DetailTextureInfo,'laya.d3.terrain.unit.DetailTextureInfo');
	return DetailTextureInfo;
})()


/**
*<code>OrientedBoundBox</code> 类用于创建OBB包围盒。
*/
//class laya.d3.math.OrientedBoundBox
var OrientedBoundBox=(function(){
	function OrientedBoundBox(extents,transformation){
		/**每个轴长度的一半*/
		this.extents=null;
		/**这个矩阵表示包围盒的位置和缩放,它的平移向量表示该包围盒的中心*/
		this.transformation=null;
		this.extents=extents;
		this.transformation=transformation;
	}

	__class(OrientedBoundBox,'laya.d3.math.OrientedBoundBox');
	var __proto=OrientedBoundBox.prototype;
	/**
	*获取OBB包围盒的8个顶点。
	*@param corners 返回顶点的输出队列。
	*/
	__proto.getCorners=function(corners){
		OrientedBoundBox._tempV30.x=this.extents.x;
		OrientedBoundBox._tempV30.y=OrientedBoundBox._tempV30.z=0;
		OrientedBoundBox._tempV31.y=this.extents.y;
		OrientedBoundBox._tempV31.x=OrientedBoundBox._tempV31.z=0;
		OrientedBoundBox._tempV32.z=this.extents.z;
		OrientedBoundBox._tempV32.x=OrientedBoundBox._tempV32.y=0;
		Vector3.TransformNormal(OrientedBoundBox._tempV30,this.transformation,OrientedBoundBox._tempV30);
		Vector3.TransformNormal(OrientedBoundBox._tempV31,this.transformation,OrientedBoundBox._tempV31);
		Vector3.TransformNormal(OrientedBoundBox._tempV32,this.transformation,OrientedBoundBox._tempV32);
		var center=OrientedBoundBox._tempV33;
		this.transformation.getTranslationVector(center);
		corners.length=8;
		Vector3.add(center,OrientedBoundBox._tempV30,OrientedBoundBox._tempV34);
		Vector3.add(OrientedBoundBox._tempV34,OrientedBoundBox._tempV31,OrientedBoundBox._tempV34);
		Vector3.add(OrientedBoundBox._tempV34,OrientedBoundBox._tempV32,corners[0]);
		Vector3.add(center,OrientedBoundBox._tempV30,OrientedBoundBox._tempV34);
		Vector3.add(OrientedBoundBox._tempV34,OrientedBoundBox._tempV31,OrientedBoundBox._tempV34);
		Vector3.subtract(OrientedBoundBox._tempV34,OrientedBoundBox._tempV32,corners[1]);
		Vector3.subtract(center,OrientedBoundBox._tempV30,OrientedBoundBox._tempV34);
		Vector3.add(OrientedBoundBox._tempV34,OrientedBoundBox._tempV31,OrientedBoundBox._tempV34);
		Vector3.subtract(OrientedBoundBox._tempV34,OrientedBoundBox._tempV32,corners[2]);
		Vector3.subtract(center,OrientedBoundBox._tempV30,OrientedBoundBox._tempV34);
		Vector3.add(OrientedBoundBox._tempV34,OrientedBoundBox._tempV31,OrientedBoundBox._tempV34);
		Vector3.add(OrientedBoundBox._tempV34,OrientedBoundBox._tempV32,corners[3]);
		Vector3.add(center,OrientedBoundBox._tempV30,OrientedBoundBox._tempV34);
		Vector3.subtract(OrientedBoundBox._tempV34,OrientedBoundBox._tempV31,OrientedBoundBox._tempV34);
		Vector3.add(OrientedBoundBox._tempV34,OrientedBoundBox._tempV32,corners[4]);
		Vector3.add(center,OrientedBoundBox._tempV30,OrientedBoundBox._tempV34);
		Vector3.subtract(OrientedBoundBox._tempV34,OrientedBoundBox._tempV31,OrientedBoundBox._tempV34);
		Vector3.subtract(OrientedBoundBox._tempV34,OrientedBoundBox._tempV32,corners[5]);
		Vector3.subtract(center,OrientedBoundBox._tempV30,OrientedBoundBox._tempV34);
		Vector3.subtract(OrientedBoundBox._tempV34,OrientedBoundBox._tempV31,OrientedBoundBox._tempV34);
		Vector3.subtract(OrientedBoundBox._tempV34,OrientedBoundBox._tempV32,corners[6]);
		Vector3.subtract(center,OrientedBoundBox._tempV30,OrientedBoundBox._tempV34);
		Vector3.subtract(OrientedBoundBox._tempV34,OrientedBoundBox._tempV31,OrientedBoundBox._tempV34);
		Vector3.add(OrientedBoundBox._tempV34,OrientedBoundBox._tempV32,corners[7]);
	}

	/**
	*变换该包围盒的矩阵信息。
	*@param mat 矩阵
	*/
	__proto.transform=function(mat){
		Matrix4x4.multiply(this.transformation,mat,this.transformation);
	}

	/**
	*缩放该包围盒
	*@param scaling 各轴的缩放比。
	*/
	__proto.scale=function(scaling){
		Vector3.multiply(this.extents,scaling,this.extents);
	}

	/**
	*平移该包围盒。
	*@param translation 平移参数
	*/
	__proto.translate=function(translation){
		this.transformation.getTranslationVector(OrientedBoundBox._tempV30);
		Vector3.add(OrientedBoundBox._tempV30,translation,OrientedBoundBox._tempV31);
		this.transformation.setTranslationVector(OrientedBoundBox._tempV31);
	}

	/**
	*该包围盒的尺寸。
	*@param out 输出
	*/
	__proto.Size=function(out){
		Vector3.scale(this.extents,2,out);
	}

	/**
	*该包围盒需要考虑的尺寸
	*@param out 输出
	*/
	__proto.getSize=function(out){
		OrientedBoundBox._tempV30.x=this.extents.x;
		OrientedBoundBox._tempV31.y=this.extents.y;
		OrientedBoundBox._tempV32.z=this.extents.z;
		Vector3.TransformNormal(OrientedBoundBox._tempV30,this.transformation,OrientedBoundBox._tempV30);
		Vector3.TransformNormal(OrientedBoundBox._tempV31,this.transformation,OrientedBoundBox._tempV31);
		Vector3.TransformNormal(OrientedBoundBox._tempV31,this.transformation,OrientedBoundBox._tempV32);
		out.x=Vector3.scalarLength(OrientedBoundBox._tempV30);
		out.y=Vector3.scalarLength(OrientedBoundBox._tempV31);
		out.z=Vector3.scalarLength(OrientedBoundBox._tempV32);
	}

	/**
	*该包围盒需要考虑尺寸的平方
	*@param out 输出
	*/
	__proto.getSizeSquared=function(out){
		OrientedBoundBox._tempV30.x=this.extents.x;
		OrientedBoundBox._tempV31.y=this.extents.y;
		OrientedBoundBox._tempV32.z=this.extents.z;
		Vector3.TransformNormal(OrientedBoundBox._tempV30,this.transformation,OrientedBoundBox._tempV30);
		Vector3.TransformNormal(OrientedBoundBox._tempV31,this.transformation,OrientedBoundBox._tempV31);
		Vector3.TransformNormal(OrientedBoundBox._tempV31,this.transformation,OrientedBoundBox._tempV32);
		out.x=Vector3.scalarLengthSquared(OrientedBoundBox._tempV30);
		out.y=Vector3.scalarLengthSquared(OrientedBoundBox._tempV31);
		out.z=Vector3.scalarLengthSquared(OrientedBoundBox._tempV32);
	}

	/**
	*该包围盒的几何中心
	*/
	__proto.getCenter=function(center){
		this.transformation.getTranslationVector(center);
	}

	/**
	*该包围盒是否包含空间中一点
	*@param point 点
	*@return 返回位置关系
	*/
	__proto.containsPoint=function(point){
		var extentsEX=this.extents.x;
		var extentsEY=this.extents.y;
		var extentsEZ=this.extents.z;
		this.transformation.invert(OrientedBoundBox._tempM0);
		Vector3.transformCoordinate(point,OrientedBoundBox._tempM0,OrientedBoundBox._tempV30);
		var _tempV30ex=Math.abs(OrientedBoundBox._tempV30.x);
		var _tempV30ey=Math.abs(OrientedBoundBox._tempV30.y);
		var _tempV30ez=Math.abs(OrientedBoundBox._tempV30.z);
		if (MathUtils3D.nearEqual(_tempV30ex,extentsEX)&& MathUtils3D.nearEqual(_tempV30ey,extentsEY)&& MathUtils3D.nearEqual(_tempV30ez,extentsEZ))
			return /*laya.d3.math.ContainmentType.Intersects*/2;
		if (_tempV30ex < extentsEX && _tempV30ey < extentsEY && _tempV30ez < extentsEZ)
			return /*laya.d3.math.ContainmentType.Contains*/1;
		else
		return /*laya.d3.math.ContainmentType.Disjoint*/0;
	}

	/**
	*该包围盒是否包含空间中多点
	*@param point 点
	*@return 返回位置关系
	*/
	__proto.containsPoints=function(points){
		var extentsex=this.extents.x;
		var extentsey=this.extents.y;
		var extentsez=this.extents.z;
		this.transformation.invert(OrientedBoundBox._tempM0);
		var containsAll=true;
		var containsAny=false;
		for (var i=0;i < points.length;i++){
			Vector3.transformCoordinate(points[i],OrientedBoundBox._tempM0,OrientedBoundBox._tempV30);
			var _tempV30ex=Math.abs(OrientedBoundBox._tempV30.x);
			var _tempV30ey=Math.abs(OrientedBoundBox._tempV30.y);
			var _tempV30ez=Math.abs(OrientedBoundBox._tempV30.z);
			if (MathUtils3D.nearEqual(_tempV30ex,extentsex)&& MathUtils3D.nearEqual(_tempV30ey,extentsey)&& MathUtils3D.nearEqual(_tempV30ez,extentsez))
				containsAny=true;
			if (_tempV30ex < extentsex && _tempV30ey < extentsey && _tempV30ez < extentsez)
				containsAny=true;
			else
			containsAll=false;
		}
		if (containsAll)
			return /*laya.d3.math.ContainmentType.Contains*/1;
		else if (containsAny)
		return /*laya.d3.math.ContainmentType.Intersects*/2;
		else
		return /*laya.d3.math.ContainmentType.Disjoint*/0;
	}

	/**
	*该包围盒是否包含空间中一包围球
	*@param sphere 包围球
	*@param ignoreScale 是否考虑该包围盒的缩放
	*@return 返回位置关系
	*/
	__proto.containsSphere=function(sphere,ignoreScale){
		(ignoreScale===void 0)&& (ignoreScale=false);
		var extentsEX=this.extents.x;
		var extentsEY=this.extents.y;
		var extentsEZ=this.extents.z;
		var sphereR=sphere.radius;
		this.transformation.invert(OrientedBoundBox._tempM0);
		Vector3.transformCoordinate(sphere.center,OrientedBoundBox._tempM0,OrientedBoundBox._tempV30);
		var locRadius=NaN;
		if (ignoreScale){
			locRadius=sphereR;
			}else {
			Vector3.scale(Vector3._UnitX,sphereR,OrientedBoundBox._tempV31);
			Vector3.TransformNormal(OrientedBoundBox._tempV31,OrientedBoundBox._tempM0,OrientedBoundBox._tempV31);
			locRadius=Vector3.scalarLength(OrientedBoundBox._tempV31);
		}
		Vector3.scale(this.extents,-1,OrientedBoundBox._tempV32);
		Vector3.Clamp(OrientedBoundBox._tempV30,OrientedBoundBox._tempV32,this.extents,OrientedBoundBox._tempV33);
		var distance=Vector3.distanceSquared(OrientedBoundBox._tempV30,OrientedBoundBox._tempV33);
		if (distance > locRadius *locRadius)
			return /*laya.d3.math.ContainmentType.Disjoint*/0;
		var tempV30ex=OrientedBoundBox._tempV30.x;
		var tempV30ey=OrientedBoundBox._tempV30.y;
		var tempV30ez=OrientedBoundBox._tempV30.z;
		var tempV32ex=OrientedBoundBox._tempV32.x;
		var tempV32ey=OrientedBoundBox._tempV32.y;
		var tempV32ez=OrientedBoundBox._tempV32.z;
		if ((((tempV32ex+locRadius <=tempV30ex)&& (tempV30ex <=extentsEX-locRadius))&& ((extentsEX-tempV32ex > locRadius)&& (tempV32ey+locRadius <=tempV30ey)))&& (((tempV30ey <=extentsEY-locRadius)&& (extentsEY-tempV32ey > locRadius))&& (((tempV32ez+locRadius <=tempV30ez)&& (tempV30ez <=extentsEZ-locRadius))&& (extentsEZ-tempV32ez > locRadius)))){
			return /*laya.d3.math.ContainmentType.Contains*/1;
		}
		return /*laya.d3.math.ContainmentType.Intersects*/2;
	}

	/**
	*For accuracy,The transformation matrix for both <see cref="OrientedBoundingBox"/> must not have any scaling applied to it.
	*Anyway,scaling using Scale method will keep this method accurate.
	*该包围盒是否包含空间中另一OBB包围盒
	*@param obb OBB包围盒
	*@return 返回位置关系
	*/
	__proto.containsOrientedBoundBox=function(obb){
		var i=0,k=0;
		obb.getCorners(OrientedBoundBox._corners);
		var cornersCheck=this.containsPoints(OrientedBoundBox._corners);
		if (cornersCheck !=/*laya.d3.math.ContainmentType.Disjoint*/0)
			return cornersCheck;
		OrientedBoundBox._sizeAe[0]=this.extents.x;
		OrientedBoundBox._sizeAe[1]=this.extents.y;
		OrientedBoundBox._sizeAe[2]=this.extents.z;
		obb.extents.cloneTo(OrientedBoundBox._tempV35);
		OrientedBoundBox._sizeBe[0]=OrientedBoundBox._tempV35.x;
		OrientedBoundBox._sizeBe[1]=OrientedBoundBox._tempV35.y;
		OrientedBoundBox._sizeBe[2]=OrientedBoundBox._tempV35.z;
		OrientedBoundBox._getRows(this.transformation,OrientedBoundBox._rows1);
		OrientedBoundBox._getRows(obb.transformation,OrientedBoundBox._rows2);
		var extentA=NaN,extentB=NaN,separation=NaN,dotNumber=NaN;
		for (i=0;i < 4;i++){
			for (k=0;k < 4;k++){
				if (i==3 || k==3){
					OrientedBoundBox._tempM0.setElementByRowColumn(i,k,0);
					OrientedBoundBox._tempM1.setElementByRowColumn(i,k,0);
					}else {
					dotNumber=Vector3.dot(OrientedBoundBox._rows1[i],OrientedBoundBox._rows2[k]);
					OrientedBoundBox._tempM0.setElementByRowColumn(i,k,dotNumber);
					OrientedBoundBox._tempM1.setElementByRowColumn(i,k,Math.abs(dotNumber));
				}
			}
		}
		obb.getCenter(OrientedBoundBox._tempV34);
		this.getCenter(OrientedBoundBox._tempV36);
		Vector3.subtract(OrientedBoundBox._tempV34,OrientedBoundBox._tempV36,OrientedBoundBox._tempV30);
		OrientedBoundBox._tempV31.x=Vector3.dot(OrientedBoundBox._tempV30,OrientedBoundBox._rows1[0]);
		OrientedBoundBox._tempV31.y=Vector3.dot(OrientedBoundBox._tempV30,OrientedBoundBox._rows1[1]);
		OrientedBoundBox._tempV31.z=Vector3.dot(OrientedBoundBox._tempV30,OrientedBoundBox._rows1[2]);
		OrientedBoundBox._vsepAe[0]=OrientedBoundBox._tempV31.x;
		OrientedBoundBox._vsepAe[1]=OrientedBoundBox._tempV31.y;
		OrientedBoundBox._vsepAe[2]=OrientedBoundBox._tempV31.z;
		for (i=0;i < 3;i++){
			OrientedBoundBox._tempV32.x=OrientedBoundBox._tempM1.getElementByRowColumn(i,0);
			OrientedBoundBox._tempV32.y=OrientedBoundBox._tempM1.getElementByRowColumn(i,1);
			OrientedBoundBox._tempV32.z=OrientedBoundBox._tempM1.getElementByRowColumn(i,2);
			extentA=OrientedBoundBox._sizeAe[i];
			extentB=Vector3.dot(OrientedBoundBox._tempV35,OrientedBoundBox._tempV32);
			separation=Math.abs(OrientedBoundBox._vsepAe[i]);
			if (separation > extentA+extentB)
				return /*laya.d3.math.ContainmentType.Disjoint*/0;
		}
		for (k=0;k < 3;k++){
			OrientedBoundBox._tempV32.x=OrientedBoundBox._tempM1.getElementByRowColumn(0,k);
			OrientedBoundBox._tempV32.y=OrientedBoundBox._tempM1.getElementByRowColumn(1,k);
			OrientedBoundBox._tempV32.z=OrientedBoundBox._tempM1.getElementByRowColumn(2,k);
			OrientedBoundBox._tempV33.x=OrientedBoundBox._tempM0.getElementByRowColumn(0,k);
			OrientedBoundBox._tempV33.y=OrientedBoundBox._tempM0.getElementByRowColumn(1,k);
			OrientedBoundBox._tempV33.z=OrientedBoundBox._tempM0.getElementByRowColumn(2,k);
			extentA=Vector3.dot(this.extents,OrientedBoundBox._tempV32);
			extentB=OrientedBoundBox._sizeBe[k];
			separation=Math.abs(Vector3.dot(OrientedBoundBox._tempV31,OrientedBoundBox._tempV33));
			if (separation > extentA+extentB)
				return /*laya.d3.math.ContainmentType.Disjoint*/0;
		}
		for (i=0;i < 3;i++){
			for (k=0;k < 3;k++){
				var i1=(i+1)% 3,i2=(i+2)% 3;
				var k1=(k+1)% 3,k2=(k+2)% 3;
				extentA=OrientedBoundBox._sizeAe[i1] *OrientedBoundBox._tempM1.getElementByRowColumn(i2,k)+OrientedBoundBox._sizeAe[i2] *OrientedBoundBox._tempM1.getElementByRowColumn(i1,k);
				extentB=OrientedBoundBox._sizeBe[k1] *OrientedBoundBox._tempM1.getElementByRowColumn(i,k2)+OrientedBoundBox._sizeBe[k2] *OrientedBoundBox._tempM1.getElementByRowColumn(i,k1);
				separation=Math.abs(OrientedBoundBox._vsepAe[i2] *OrientedBoundBox._tempM0.getElementByRowColumn(i1,k)-OrientedBoundBox._vsepAe[i1] *OrientedBoundBox._tempM0.getElementByRowColumn(i2,k));
				if (separation > extentA+extentB)
					return /*laya.d3.math.ContainmentType.Disjoint*/0;
			}
		}
		return /*laya.d3.math.ContainmentType.Intersects*/2;
	}

	/**
	*该包围盒是否包含空间中一条线
	*@param point1 点1
	*@param point2 点2
	*@return 返回位置关系
	*/
	__proto.containsLine=function(point1,point2){
		OrientedBoundBox._corners[0]=point1;
		OrientedBoundBox._corners[1]=point2;
		var cornersCheck=this.containsPoints(OrientedBoundBox._corners);
		if (cornersCheck !=/*laya.d3.math.ContainmentType.Disjoint*/0)
			return cornersCheck;
		var extentsX=this.extents.x;
		var extentsY=this.extents.y;
		var extentsZ=this.extents.z;
		this.transformation.invert(OrientedBoundBox._tempM0);
		Vector3.transformCoordinate(point1,OrientedBoundBox._tempM0,OrientedBoundBox._tempV30);
		Vector3.transformCoordinate(point2,OrientedBoundBox._tempM0,OrientedBoundBox._tempV31);
		Vector3.add(OrientedBoundBox._tempV30,OrientedBoundBox._tempV31,OrientedBoundBox._tempV32);
		Vector3.scale(OrientedBoundBox._tempV32,0.5,OrientedBoundBox._tempV32);
		Vector3.subtract(OrientedBoundBox._tempV30,OrientedBoundBox._tempV32,OrientedBoundBox._tempV33);
		var _tempV33X=OrientedBoundBox._tempV33.x;
		var _tempV33Y=OrientedBoundBox._tempV33.y;
		var _tempV33Z=OrientedBoundBox._tempV33.z;
		var _tempV34X=OrientedBoundBox._tempV34.x=Math.abs(OrientedBoundBox._tempV33.x);
		var _tempV34Y=OrientedBoundBox._tempV34.y=Math.abs(OrientedBoundBox._tempV33.y);
		var _tempV34Z=OrientedBoundBox._tempV34.z=Math.abs(OrientedBoundBox._tempV33.z);
		var _tempV32X=OrientedBoundBox._tempV32.x;
		var _tempV32Y=OrientedBoundBox._tempV32.y;
		var _tempV32Z=OrientedBoundBox._tempV32.z;
		if (Math.abs(_tempV32X)> extentsX+_tempV34X)
			return /*laya.d3.math.ContainmentType.Disjoint*/0;
		if (Math.abs(_tempV32Y)> extentsY+_tempV34Y)
			return /*laya.d3.math.ContainmentType.Disjoint*/0;
		if (Math.abs(_tempV32Z)> extentsZ+_tempV34Z)
			return /*laya.d3.math.ContainmentType.Disjoint*/0;
		if (Math.abs(_tempV32Y *_tempV33Z-_tempV32Z *_tempV33Y)> (extentsY *_tempV34Z+extentsZ *_tempV34Y))
			return /*laya.d3.math.ContainmentType.Disjoint*/0;
		if (Math.abs(_tempV32X *_tempV33Z-_tempV32Z *_tempV33X)> (extentsX *_tempV34Z+extentsZ *_tempV34X))
			return /*laya.d3.math.ContainmentType.Disjoint*/0;
		if (Math.abs(_tempV32X *_tempV33Y-_tempV32Y *_tempV33X)> (extentsX *_tempV34Y+extentsY *_tempV34X))
			return /*laya.d3.math.ContainmentType.Disjoint*/0;
		return /*laya.d3.math.ContainmentType.Intersects*/2;
	}

	/**
	*该包围盒是否包含空间中另一OBB包围盒
	*@param box 包围盒
	*@return 返回位置关系
	*/
	__proto.containsBoundBox=function(box){
		var i=0,k=0;
		var min=box.min;
		var max=box.max;
		box.getCorners(OrientedBoundBox._corners);
		var cornersCheck=this.containsPoints(OrientedBoundBox._corners);
		if (cornersCheck !=/*laya.d3.math.ContainmentType.Disjoint*/0)
			return cornersCheck;
		Vector3.subtract(max,min,OrientedBoundBox._tempV30);
		Vector3.scale(OrientedBoundBox._tempV30,0.5,OrientedBoundBox._tempV30);
		Vector3.add(min,OrientedBoundBox._tempV30,OrientedBoundBox._tempV30);
		Vector3.subtract(max,OrientedBoundBox._tempV30,OrientedBoundBox._tempV31);
		OrientedBoundBox._sizeAe[0]=this.extents.x;
		OrientedBoundBox._sizeAe[1]=this.extents.y;
		OrientedBoundBox._sizeAe[2]=this.extents.z;
		OrientedBoundBox._sizeBe[0]=OrientedBoundBox._tempV31.x;
		OrientedBoundBox._sizeBe[1]=OrientedBoundBox._tempV31.y;
		OrientedBoundBox._sizeBe[2]=OrientedBoundBox._tempV31.z;
		OrientedBoundBox._getRows(this.transformation,OrientedBoundBox._rows1);
		this.transformation.invert(OrientedBoundBox._tempM0);
		var extentA=NaN,extentB=NaN,separation=NaN,dotNumber=NaN;
		for (i=0;i < 3;i++){
			for (k=0;k < 3;k++){
				OrientedBoundBox._tempM1.setElementByRowColumn(i,k,Math.abs(OrientedBoundBox._tempM0.getElementByRowColumn(i,k)));
			}
		}
		this.getCenter(OrientedBoundBox._tempV35);
		Vector3.subtract(OrientedBoundBox._tempV30,OrientedBoundBox._tempV35,OrientedBoundBox._tempV32);
		OrientedBoundBox._tempV31.x=Vector3.dot(OrientedBoundBox._tempV32,OrientedBoundBox._rows1[0]);
		OrientedBoundBox._tempV31.y=Vector3.dot(OrientedBoundBox._tempV32,OrientedBoundBox._rows1[1]);
		OrientedBoundBox._tempV31.z=Vector3.dot(OrientedBoundBox._tempV32,OrientedBoundBox._rows1[2]);
		OrientedBoundBox._vsepAe[0]=OrientedBoundBox._tempV31.x;
		OrientedBoundBox._vsepAe[1]=OrientedBoundBox._tempV31.y;
		OrientedBoundBox._vsepAe[2]=OrientedBoundBox._tempV31.z;
		for (i=0;i < 3;i++){
			OrientedBoundBox._tempV33.x=OrientedBoundBox._tempM1.getElementByRowColumn(i,0);
			OrientedBoundBox._tempV33.y=OrientedBoundBox._tempM1.getElementByRowColumn(i,1);
			OrientedBoundBox._tempV33.z=OrientedBoundBox._tempM1.getElementByRowColumn(i,2);
			extentA=OrientedBoundBox._sizeAe[i];
			extentB=Vector3.dot(OrientedBoundBox._tempV31,OrientedBoundBox._tempV33);
			separation=Math.abs(OrientedBoundBox._vsepAe[i]);
			if (separation > extentA+extentB)
				return /*laya.d3.math.ContainmentType.Disjoint*/0;
		}
		for (k=0;k < 3;k++){
			OrientedBoundBox._tempV33.x=OrientedBoundBox._tempM1.getElementByRowColumn(0,k);
			OrientedBoundBox._tempV33.y=OrientedBoundBox._tempM1.getElementByRowColumn(1,k);
			OrientedBoundBox._tempV33.z=OrientedBoundBox._tempM1.getElementByRowColumn(2,k);
			OrientedBoundBox._tempV34.x=OrientedBoundBox._tempM0.getElementByRowColumn(0,k);
			OrientedBoundBox._tempV34.y=OrientedBoundBox._tempM0.getElementByRowColumn(1,k);
			OrientedBoundBox._tempV34.z=OrientedBoundBox._tempM0.getElementByRowColumn(2,k);
			extentA=Vector3.dot(this.extents,OrientedBoundBox._tempV33);
			extentB=OrientedBoundBox._sizeBe[k];
			separation=Math.abs(Vector3.dot(OrientedBoundBox._tempV31,OrientedBoundBox._tempV34));
			if (separation > extentA+extentB)
				return /*laya.d3.math.ContainmentType.Disjoint*/0;
		}
		for (i=0;i < 3;i++){
			for (k=0;k < 3;k++){
				var i1=(i+1)% 3,i2=(i+2)% 3;
				var k1=(k+1)% 3,k2=(k+2)% 3;
				extentA=OrientedBoundBox._sizeAe[i1] *OrientedBoundBox._tempM1.getElementByRowColumn(i2,k)+OrientedBoundBox._sizeAe[i2] *OrientedBoundBox._tempM1.getElementByRowColumn(i1,k);
				extentB=OrientedBoundBox._sizeBe[k1] *OrientedBoundBox._tempM1.getElementByRowColumn(i,k2)+OrientedBoundBox._sizeBe[k2] *OrientedBoundBox._tempM1.getElementByRowColumn(i,k1);
				separation=Math.abs(OrientedBoundBox._vsepAe[i2] *OrientedBoundBox._tempM0.getElementByRowColumn(i1,k)-OrientedBoundBox._vsepAe[i1] *OrientedBoundBox._tempM0.getElementByRowColumn(i2,k));
				if (separation > extentA+extentB)
					return /*laya.d3.math.ContainmentType.Disjoint*/0;
			}
		}
		return /*laya.d3.math.ContainmentType.Intersects*/2;
	}

	/**
	*该包围盒是否与空间中另一射线相交
	*@param ray
	*@param out
	*@return
	*/
	__proto.intersectsRay=function(ray,out){
		Vector3.scale(this.extents,-1,OrientedBoundBox._tempV30);
		this.transformation.invert(OrientedBoundBox._tempM0);
		Vector3.TransformNormal(ray.direction,OrientedBoundBox._tempM0,OrientedBoundBox._ray.direction);
		Vector3.transformCoordinate(ray.origin,OrientedBoundBox._tempM0,OrientedBoundBox._ray.origin);
		OrientedBoundBox._boxBound1.min=OrientedBoundBox._tempV30;
		OrientedBoundBox._boxBound1.max=this.extents;
		var intersects=CollisionUtils.intersectsRayAndBoxRP(OrientedBoundBox._ray,OrientedBoundBox._boxBound1,out);
		if (intersects!==-1)
			Vector3.transformCoordinate(out,this.transformation,out);
		return intersects;
	}

	__proto._getLocalCorners=function(corners){
		corners.length=8;
		OrientedBoundBox._tempV30.x=this.extents.x;
		OrientedBoundBox._tempV31.y=this.extents.y;
		OrientedBoundBox._tempV32.z=this.extents.z;
		Vector3.add(OrientedBoundBox._tempV30,OrientedBoundBox._tempV31,OrientedBoundBox._tempV33);
		Vector3.add(OrientedBoundBox._tempV33,OrientedBoundBox._tempV32,corners[0]);
		Vector3.add(OrientedBoundBox._tempV30,OrientedBoundBox._tempV31,OrientedBoundBox._tempV33);
		Vector3.subtract(OrientedBoundBox._tempV33,OrientedBoundBox._tempV32,corners[1]);
		Vector3.subtract(OrientedBoundBox._tempV31,OrientedBoundBox._tempV30,OrientedBoundBox._tempV33);
		Vector3.subtract(OrientedBoundBox._tempV33,OrientedBoundBox._tempV30,corners[2]);
		Vector3.subtract(OrientedBoundBox._tempV31,OrientedBoundBox._tempV30,OrientedBoundBox._tempV33);
		Vector3.add(OrientedBoundBox._tempV33,OrientedBoundBox._tempV32,corners[3]);
		Vector3.subtract(OrientedBoundBox._tempV30,OrientedBoundBox._tempV31,OrientedBoundBox._tempV33);
		Vector3.add(OrientedBoundBox._tempV33,OrientedBoundBox._tempV32,corners[4]);
		Vector3.subtract(OrientedBoundBox._tempV30,OrientedBoundBox._tempV31,OrientedBoundBox._tempV33);
		Vector3.subtract(OrientedBoundBox._tempV33,OrientedBoundBox._tempV32,corners[5]);
		Vector3.scale(corners[0],-1,corners[6]);
		Vector3.subtract(OrientedBoundBox._tempV32,OrientedBoundBox._tempV30,OrientedBoundBox._tempV33);
		Vector3.subtract(OrientedBoundBox._tempV33,OrientedBoundBox._tempV31,corners[7]);
	}

	/**
	*判断两个包围盒是否相等
	*@param obb obb包围盒
	*@return Boolean
	*/
	__proto.equals=function(obb){
		return this.extents==obb.extents && this.transformation==obb.transformation;
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var dest=destObject;
		this.extents.cloneTo(dest.extents);
		this.transformation.cloneTo(dest.transformation);
	}

	OrientedBoundBox.createByBoundBox=function(box,out){
		var min=box.min;
		var max=box.max;
		Vector3.subtract(max,min,OrientedBoundBox._tempV30);
		Vector3.scale(OrientedBoundBox._tempV30,0.5,OrientedBoundBox._tempV30);
		Vector3.add(min,OrientedBoundBox._tempV30,OrientedBoundBox._tempV31);
		Vector3.subtract(max,OrientedBoundBox._tempV31,OrientedBoundBox._tempV32);
		Matrix4x4.translation(OrientedBoundBox._tempV31,OrientedBoundBox._tempM0);
		var extents=OrientedBoundBox._tempV32.clone();
		var transformation=OrientedBoundBox._tempM0.clone();
		out.extents=extents;
		out.transformation=transformation;
	}

	OrientedBoundBox.createByMinAndMaxVertex=function(min,max){
		Vector3.subtract(max,min,OrientedBoundBox._tempV30);
		Vector3.scale(OrientedBoundBox._tempV30,0.5,OrientedBoundBox._tempV30);
		Vector3.add(min,OrientedBoundBox._tempV30,OrientedBoundBox._tempV31);
		Vector3.subtract(max,OrientedBoundBox._tempV31,OrientedBoundBox._tempV32);
		Matrix4x4.translation(OrientedBoundBox._tempV31,OrientedBoundBox._tempM0);
		var obb=new OrientedBoundBox(OrientedBoundBox._tempV32,OrientedBoundBox._tempM0);
		return obb;
	}

	OrientedBoundBox._getRows=function(mat,out){
		out.length=3;
		var mate=mat.elements;
		out[0].x=mate[0];
		out[0].y=mate[1];
		out[0].z=mate[2];
		out[1].x=mate[4];
		out[1].y=mate[5];
		out[1].z=mate[6];
		out[2].x=mate[8];
		out[2].y=mate[9];
		out[2].z=mate[10];
	}

	OrientedBoundBox.getObbtoObbMatrix4x4=function(a,b,noMatrixScaleApplied,out){
		var at=a.transformation;
		var bt=b.transformation;
		if (noMatrixScaleApplied){
			OrientedBoundBox._getRows(at,OrientedBoundBox._rows1);
			OrientedBoundBox._getRows(bt,OrientedBoundBox._rows2);
			for (var i=0;i < 3;i++){
				for (var k=0;k < 3;k++){
					out.setElementByRowColumn(i,k,Vector3.dot(OrientedBoundBox._rows2[i],OrientedBoundBox._rows1[k]));
				}
			}
			b.getCenter(OrientedBoundBox._tempV30);
			a.getCenter(OrientedBoundBox._tempV31);
			Vector3.subtract(OrientedBoundBox._tempV30,OrientedBoundBox._tempV31,OrientedBoundBox._tempV32);
			var AtoBMe=out.elements;
			AtoBMe[12]=Vector3.dot(OrientedBoundBox._tempV32,OrientedBoundBox._rows1[0]);
			AtoBMe[13]=Vector3.dot(OrientedBoundBox._tempV32,OrientedBoundBox._rows1[1]);
			AtoBMe[14]=Vector3.dot(OrientedBoundBox._tempV32,OrientedBoundBox._rows1[2]);
			AtoBMe[15]=1;
			}else {
			at.invert(OrientedBoundBox._tempM0);
			Matrix4x4.multiply(bt,OrientedBoundBox._tempM0,out);
		}
	}

	OrientedBoundBox.merge=function(a,b,noMatrixScaleApplied){
		var ae=a.extents;
		var at=a.transformation;
		OrientedBoundBox.getObbtoObbMatrix4x4(a,b,noMatrixScaleApplied,OrientedBoundBox._tempM0);
		b._getLocalCorners(OrientedBoundBox._corners);
		Vector3.transformCoordinate(OrientedBoundBox._corners[0],OrientedBoundBox._tempM0,OrientedBoundBox._corners[0]);
		Vector3.transformCoordinate(OrientedBoundBox._corners[1],OrientedBoundBox._tempM0,OrientedBoundBox._corners[1]);
		Vector3.transformCoordinate(OrientedBoundBox._corners[2],OrientedBoundBox._tempM0,OrientedBoundBox._corners[2]);
		Vector3.transformCoordinate(OrientedBoundBox._corners[3],OrientedBoundBox._tempM0,OrientedBoundBox._corners[3]);
		Vector3.transformCoordinate(OrientedBoundBox._corners[4],OrientedBoundBox._tempM0,OrientedBoundBox._corners[4]);
		Vector3.transformCoordinate(OrientedBoundBox._corners[5],OrientedBoundBox._tempM0,OrientedBoundBox._corners[5]);
		Vector3.transformCoordinate(OrientedBoundBox._corners[6],OrientedBoundBox._tempM0,OrientedBoundBox._corners[6]);
		Vector3.transformCoordinate(OrientedBoundBox._corners[7],OrientedBoundBox._tempM0,OrientedBoundBox._corners[7]);
		Vector3.scale(ae,-1,OrientedBoundBox._boxBound1.min);
		ae.cloneTo(OrientedBoundBox._boxBound1.max);
		BoundBox.createfromPoints(OrientedBoundBox._corners,OrientedBoundBox._boxBound2);
		BoundBox.merge(OrientedBoundBox._boxBound2,OrientedBoundBox._boxBound1,OrientedBoundBox._boxBound3);
		var box3Min=OrientedBoundBox._boxBound3.min;
		var box3Max=OrientedBoundBox._boxBound3.max;
		Vector3.subtract(box3Max,box3Min,OrientedBoundBox._tempV30);
		Vector3.scale(OrientedBoundBox._tempV30,0.5,OrientedBoundBox._tempV30);
		Vector3.add(box3Min,OrientedBoundBox._tempV30,OrientedBoundBox._tempV32);
		Vector3.subtract(box3Max,OrientedBoundBox._tempV32,ae);
		Vector3.transformCoordinate(OrientedBoundBox._tempV32,at,OrientedBoundBox._tempV33);
	}

	__static(OrientedBoundBox,
	['_tempV30',function(){return this._tempV30=new Vector3();},'_tempV31',function(){return this._tempV31=new Vector3();},'_tempV32',function(){return this._tempV32=new Vector3();},'_tempV33',function(){return this._tempV33=new Vector3();},'_tempV34',function(){return this._tempV34=new Vector3();},'_tempV35',function(){return this._tempV35=new Vector3();},'_tempV36',function(){return this._tempV36=new Vector3();},'_tempM0',function(){return this._tempM0=new Matrix4x4();},'_tempM1',function(){return this._tempM1=new Matrix4x4();},'_corners',function(){return this._corners=/*new vector.<>*/[new Vector3(),new Vector3(),new Vector3(),new Vector3(),new Vector3(),new Vector3(),new Vector3(),new Vector3()];},'_rows1',function(){return this._rows1=/*new vector.<>*/[new Vector3(),new Vector3(),new Vector3()];},'_rows2',function(){return this._rows2=/*new vector.<>*/[new Vector3(),new Vector3(),new Vector3()];},'_ray',function(){return this._ray=new Ray(new Vector3(),new Vector3());},'_boxBound1',function(){return this._boxBound1=new BoundBox(new Vector3(),new Vector3());},'_boxBound2',function(){return this._boxBound2=new BoundBox(new Vector3(),new Vector3());},'_boxBound3',function(){return this._boxBound3=new BoundBox(new Vector3(),new Vector3());},'_vsepAe',function(){return this._vsepAe=new Float32Array();},'_sizeBe',function(){return this._sizeBe=new Float32Array();},'_sizeAe',function(){return this._sizeAe=new Float32Array();}
	]);
	return OrientedBoundBox;
})()


/**
*@private
*<code>RenderQuene</code> 类用于实现渲染队列。
*/
//class laya.d3.core.render.RenderQueue
var RenderQueue=(function(){
	function RenderQueue(isTransparent){
		/**@private [只读]*/
		//this.isTransparent=false;
		/**@private */
		//this.elements=null;
		/**@private */
		//this.lastTransparentRenderElement=null;
		/**@private */
		//this.lastTransparentBatched=false;
		(isTransparent===void 0)&& (isTransparent=false);
		this.isTransparent=isTransparent;
		this.elements=[];
	}

	__class(RenderQueue,'laya.d3.core.render.RenderQueue');
	var __proto=RenderQueue.prototype;
	/**
	*@private
	*/
	__proto._compare=function(left,right){
		var renderQueue=left.material.renderQueue-right.material.renderQueue;
		if (renderQueue===0){
			var sort=this.isTransparent ? right.render._distanceForSort-left.render._distanceForSort :left.render._distanceForSort-right.render._distanceForSort;
			return sort+right.render.sortingFudge-left.render.sortingFudge;
			}else {
			return renderQueue;
		}
	}

	/**
	*@private
	*/
	__proto._partitionRenderObject=function(left,right){
		var pivot=this.elements[Math.floor((right+left)/ 2)];
		while (left <=right){
			while (this._compare(this.elements[left],pivot)< 0)
			left++;
			while (this._compare(this.elements[right],pivot)> 0)
			right--;
			if (left < right){
				var temp=this.elements[left];
				this.elements[left]=this.elements[right];
				this.elements[right]=temp;
				left++;
				right--;
				}else if (left===right){
				left++;
				break ;
			}
		}
		return left;
	}

	/**
	*@private
	*/
	__proto._quickSort=function(left,right){
		if (this.elements.length > 1){
			var index=this._partitionRenderObject(left,right);
			var leftIndex=index-1;
			if (left < leftIndex)
				this._quickSort(left,leftIndex);
			if (index < right)
				this._quickSort(index,right);
		}
	}

	/**
	*@private
	*/
	__proto._render=function(context,isTarget,customShader,replacementTag){
		for (var i=0,n=this.elements.length;i < n;i++)
		this.elements[i]._render(context,isTarget,customShader,replacementTag);
	}

	/**
	*@private
	*/
	__proto.clear=function(){
		this.elements.length=0;
		this.lastTransparentRenderElement=null;
		this.lastTransparentBatched=false;
	}

	return RenderQueue;
})()


/**
*...
*@author ...
*/
//class laya.d3.core.TextureMode
var TextureMode=(function(){
	function TextureMode(){}
	__class(TextureMode,'laya.d3.core.TextureMode');
	TextureMode.Stretch=0;
	TextureMode.Tile=1;
	return TextureMode;
})()


/**
*...
*@author ...
*/
//class laya.d3.physics.shape.HeightfieldColliderShape
var HeightfieldColliderShape=(function(){
	function HeightfieldColliderShape(){}
	__class(HeightfieldColliderShape,'laya.d3.physics.shape.HeightfieldColliderShape');
	return HeightfieldColliderShape;
})()


/**
*...
*@author ...
*/
//class laya.d3.core.particleShuriKen.module.shape.ShapeUtils
var ShapeUtils=(function(){
	function ShapeUtils(){}
	__class(ShapeUtils,'laya.d3.core.particleShuriKen.module.shape.ShapeUtils');
	ShapeUtils._randomPointUnitArcCircle=function(arc,out,rand){
		var angle=NaN;
		if (rand)
			angle=rand.getFloat()*arc;
		else
		angle=Math.random()*arc;
		out.x=Math.cos(angle);
		out.y=Math.sin(angle);
	}

	ShapeUtils._randomPointInsideUnitArcCircle=function(arc,out,rand){
		ShapeUtils._randomPointUnitArcCircle(arc,out,rand);
		var range=NaN;
		if (rand)
			range=Math.pow(rand.getFloat(),1.0 / 2.0);
		else
		range=Math.pow(Math.random(),1.0 / 2.0);
		out.x=out.x *range;
		out.y=out.y *range;
	}

	ShapeUtils._randomPointUnitCircle=function(out,rand){
		var angle=NaN;
		if (rand)
			angle=rand.getFloat()*Math.PI *2;
		else
		angle=Math.random()*Math.PI *2;
		out.x=Math.cos(angle);
		out.y=Math.sin(angle);
	}

	ShapeUtils._randomPointInsideUnitCircle=function(out,rand){
		ShapeUtils._randomPointUnitCircle(out);
		var range=NaN;
		if (rand)
			range=Math.pow(rand.getFloat(),1.0 / 2.0);
		else
		range=Math.pow(Math.random(),1.0 / 2.0);
		out.x=out.x *range;
		out.y=out.y *range;
	}

	ShapeUtils._randomPointUnitSphere=function(out,rand){
		var z=NaN;
		var a=NaN;
		if (rand){
			z=out.z=rand.getFloat()*2-1.0;
			a=rand.getFloat()*Math.PI *2;
			}else {
			z=out.z=Math.random()*2-1.0;
			a=Math.random()*Math.PI *2;
		};
		var r=Math.sqrt(1.0-z *z);
		out.x=r *Math.cos(a);
		out.y=r *Math.sin(a);
	}

	ShapeUtils._randomPointInsideUnitSphere=function(out,rand){;
		ShapeUtils._randomPointUnitSphere(out);
		var range=NaN;
		if (rand)
			range=Math.pow(rand.getFloat(),1.0 / 3.0);
		else
		range=Math.pow(Math.random(),1.0 / 3.0);
		out.x=out.x *range;
		out.y=out.y *range;
		out.z=out.z *range;
	}

	ShapeUtils._randomPointInsideHalfUnitBox=function(out,rand){
		if (rand){
			out.x=(rand.getFloat()-0.5);
			out.y=(rand.getFloat()-0.5);
			out.z=(rand.getFloat()-0.5);
			}else {
			out.x=(Math.random()-0.5);
			out.y=(Math.random()-0.5);
			out.z=(Math.random()-0.5);
		}
	}

	return ShapeUtils;
})()


/**
*...
*@author ...
*/
//class laya.d3.graphics.VertexElementFormat
var VertexElementFormat=(function(){
	function VertexElementFormat(){}
	__class(VertexElementFormat,'laya.d3.graphics.VertexElementFormat');
	VertexElementFormat.getElementInfos=function(element){
		var info=VertexElementFormat._elementInfos[element];
		if (info)
			return info;
		else
		throw "VertexElementFormat: this vertexElementFormat is not implement.";
	}

	VertexElementFormat.Single="single";
	VertexElementFormat.Vector2="vector2";
	VertexElementFormat.Vector3="vector3";
	VertexElementFormat.Vector4="vector4";
	VertexElementFormat.Color="color";
	VertexElementFormat.Byte4="byte4";
	VertexElementFormat.Short2="short2";
	VertexElementFormat.Short4="short4";
	VertexElementFormat.NormalizedShort2="normalizedshort2";
	VertexElementFormat.NormalizedShort4="normalizedshort4";
	VertexElementFormat.HalfVector2="halfvector2";
	VertexElementFormat.HalfVector4="halfvector4";
	__static(VertexElementFormat,
	['_elementInfos',function(){return this._elementInfos={
			"single":[1,/*laya.webgl.WebGLContext.FLOAT*/0x1406,0],
			"vector2":[2,/*laya.webgl.WebGLContext.FLOAT*/0x1406,0],
			"vector3":[3,/*laya.webgl.WebGLContext.FLOAT*/0x1406,0],
			"vector4":[4,/*laya.webgl.WebGLContext.FLOAT*/0x1406,0],
			"color":[4,/*laya.webgl.WebGLContext.FLOAT*/0x1406,0],
			"byte4":[4,/*laya.webgl.WebGLContext.UNSIGNED_BYTE*/0x1401,0],
			"short2":[2,/*laya.webgl.WebGLContext.FLOAT*/0x1406,0],
			"short4":[4,/*laya.webgl.WebGLContext.FLOAT*/0x1406,0],
			"normalizedshort2":[2,/*laya.webgl.WebGLContext.FLOAT*/0x1406,0],
			"normalizedshort4":[4,/*laya.webgl.WebGLContext.FLOAT*/0x1406,0],
			"halfvector2":[2,/*laya.webgl.WebGLContext.FLOAT*/0x1406,0],
			"halfvector4":[4,/*laya.webgl.WebGLContext.FLOAT*/0x1406,0]
	};}

	]);
	return VertexElementFormat;
})()


/**
*<code>RotationOverLifetime</code> 类用于粒子的生命周期旋转。
*/
//class laya.d3.core.particleShuriKen.module.RotationOverLifetime
var RotationOverLifetime=(function(){
	function RotationOverLifetime(angularVelocity){
		/**@private */
		this._angularVelocity=null;
		/**是否启用*/
		this.enbale=false;
		this._angularVelocity=angularVelocity;
	}

	__class(RotationOverLifetime,'laya.d3.core.particleShuriKen.module.RotationOverLifetime');
	var __proto=RotationOverLifetime.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var destRotationOverLifetime=destObject;
		this._angularVelocity.cloneTo(destRotationOverLifetime._angularVelocity);
		destRotationOverLifetime.enbale=this.enbale;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var destAngularVelocity;
		switch (this._angularVelocity.type){
			case 0:
				if (this._angularVelocity.separateAxes)
					destAngularVelocity=GradientAngularVelocity.createByConstantSeparate(this._angularVelocity.constantSeparate.clone());
				else
				destAngularVelocity=GradientAngularVelocity.createByConstant(this._angularVelocity.constant);
				break ;
			case 1:
				if (this._angularVelocity.separateAxes)
					destAngularVelocity=GradientAngularVelocity.createByGradientSeparate(this._angularVelocity.gradientX.clone(),this._angularVelocity.gradientY.clone(),this._angularVelocity.gradientZ.clone());
				else
				destAngularVelocity=GradientAngularVelocity.createByGradient(this._angularVelocity.gradient.clone());
				break ;
			case 2:
				if (this._angularVelocity.separateAxes)
					destAngularVelocity=GradientAngularVelocity.createByRandomTwoConstantSeparate(this._angularVelocity.constantMinSeparate.clone(),this._angularVelocity.constantMaxSeparate.clone());
				else
				destAngularVelocity=GradientAngularVelocity.createByRandomTwoConstant(this._angularVelocity.constantMin,this._angularVelocity.constantMax);
				break ;
			case 3:
				if (this._angularVelocity.separateAxes)
					destAngularVelocity=GradientAngularVelocity.createByRandomTwoGradientSeparate(this._angularVelocity.gradientXMin.clone(),this._angularVelocity.gradientYMin.clone(),this._angularVelocity.gradientZMin.clone(),this._angularVelocity.gradientWMin.clone(),this._angularVelocity.gradientXMax.clone(),this._angularVelocity.gradientYMax.clone(),this._angularVelocity.gradientZMax.clone(),this._angularVelocity.gradientWMax.clone());
				else
				destAngularVelocity=GradientAngularVelocity.createByRandomTwoGradient(this._angularVelocity.gradientMin.clone(),this._angularVelocity.gradientMax.clone());
				break ;
			};
		var destRotationOverLifetime=/*__JS__ */new this.constructor(destAngularVelocity);
		destRotationOverLifetime.enbale=this.enbale;
		return destRotationOverLifetime;
	}

	/**
	*获取角速度。
	*/
	__getset(0,__proto,'angularVelocity',function(){
		return this._angularVelocity;
	});

	return RotationOverLifetime;
})()


/**
*<code>BoundFrustum</code> 类用于创建锥截体。
*/
//class laya.d3.math.BoundFrustum
var BoundFrustum=(function(){
	function BoundFrustum(matrix){
		/**4x4矩阵*/
		this._matrix=null;
		/**近平面*/
		this._near=null;
		/**远平面*/
		this._far=null;
		/**左平面*/
		this._left=null;
		/**右平面*/
		this._right=null;
		/**顶平面*/
		this._top=null;
		/**底平面*/
		this._bottom=null;
		this._matrix=matrix;
		this._near=new Plane(new Vector3());
		this._far=new Plane(new Vector3());
		this._left=new Plane(new Vector3());
		this._right=new Plane(new Vector3());
		this._top=new Plane(new Vector3());
		this._bottom=new Plane(new Vector3());
		BoundFrustum._getPlanesFromMatrix(this._matrix,this._near,this._far,this._left,this._right,this._top,this._bottom);
	}

	__class(BoundFrustum,'laya.d3.math.BoundFrustum');
	var __proto=BoundFrustum.prototype;
	/**
	*判断是否与其他锥截体相等。
	*@param other 锥截体。
	*/
	__proto.equalsBoundFrustum=function(other){
		return this._matrix.equalsOtherMatrix(other.matrix)
	}

	/**
	*判断是否与其他对象相等。
	*@param obj 对象。
	*/
	__proto.equalsObj=function(obj){
		if ((obj instanceof laya.d3.math.BoundFrustum )){
			var bf=obj;
			return this.equalsBoundFrustum(bf);
		}
		return false;
	}

	/**
	*获取锥截体的任意一平面。
	*0:近平面
	*1:远平面
	*2:左平面
	*3:右平面
	*4:顶平面
	*5:底平面
	*@param index 索引。
	*/
	__proto.getPlane=function(index){
		switch (index){
			case 0:
				return this._near;
			case 1:
				return this._far;
			case 2:
				return this._left;
			case 3:
				return this._right;
			case 4:
				return this._top;
			case 5:
				return this._bottom;
			default :
				return null;
			}
	}

	/**
	*锥截体的8个顶点。
	*@param corners 返回顶点的输出队列。
	*/
	__proto.getCorners=function(corners){
		BoundFrustum._get3PlaneInterPoint(this._near,this._bottom,this._right).cloneTo(corners[0]);
		BoundFrustum._get3PlaneInterPoint(this._near,this._top,this._right).cloneTo(corners[1]);
		BoundFrustum._get3PlaneInterPoint(this._near,this._top,this._left).cloneTo(corners[2]);
		BoundFrustum._get3PlaneInterPoint(this._near,this._bottom,this._left).cloneTo(corners[3]);
		BoundFrustum._get3PlaneInterPoint(this._far,this._bottom,this._right).cloneTo(corners[4]);
		BoundFrustum._get3PlaneInterPoint(this._far,this._top,this._right).cloneTo(corners[5]);
		BoundFrustum._get3PlaneInterPoint(this._far,this._top,this._left).cloneTo(corners[6]);
		BoundFrustum._get3PlaneInterPoint(this._far,this._bottom,this._left).cloneTo(corners[7]);
	}

	/**
	*与点的位置关系。返回-1,包涵;0,相交;1,不相交
	*@param point 点。
	*/
	__proto.containsPoint=function(point){
		var result=Plane.PlaneIntersectionType_Front;
		var planeResult=Plane.PlaneIntersectionType_Front;
		for (var i=0;i < 6;i++){
			switch (i){
				case 0:
					planeResult=CollisionUtils.intersectsPlaneAndPoint(this._near,point);
					break ;
				case 1:
					planeResult=CollisionUtils.intersectsPlaneAndPoint(this._far,point);
					break ;
				case 2:
					planeResult=CollisionUtils.intersectsPlaneAndPoint(this._left,point);
					break ;
				case 3:
					planeResult=CollisionUtils.intersectsPlaneAndPoint(this._right,point);
					break ;
				case 4:
					planeResult=CollisionUtils.intersectsPlaneAndPoint(this._top,point);
					break ;
				case 5:
					planeResult=CollisionUtils.intersectsPlaneAndPoint(this._bottom,point);
					break ;
				}
			switch (planeResult){
				case Plane.PlaneIntersectionType_Back:
					return /*laya.d3.math.ContainmentType.Disjoint*/0;
				case Plane.PlaneIntersectionType_Intersecting:
					result=Plane.PlaneIntersectionType_Intersecting;
					break ;
				}
		}
		switch (result){
			case Plane.PlaneIntersectionType_Intersecting:
				return /*laya.d3.math.ContainmentType.Intersects*/2;
			default :
				return /*laya.d3.math.ContainmentType.Contains*/1;
			}
	}

	/**
	*与包围盒的位置关系。返回-1,包涵;0,相交;1,不相交
	*@param box 包围盒。
	*/
	__proto.containsBoundBox=function(box){
		var p=BoundFrustum._tempV30,n=BoundFrustum._tempV31;
		var boxMin=box.min;
		var boxMax=box.max;
		var result=/*laya.d3.math.ContainmentType.Contains*/1;
		for (var i=0;i < 6;i++){
			var plane=this.getPlane(i);
			var planeNor=plane.normal;
			if (planeNor.x >=0){
				p.x=boxMax.x;
				n.x=boxMin.x;
				}else {
				p.x=boxMin.x;
				n.x=boxMax.x;
			}
			if (planeNor.y >=0){
				p.y=boxMax.y;
				n.y=boxMin.y;
				}else {
				p.y=boxMin.y;
				n.y=boxMax.y;
			}
			if (planeNor.z >=0){
				p.z=boxMax.z;
				n.z=boxMin.z;
				}else {
				p.z=boxMin.z;
				n.z=boxMax.z;
			}
			if (CollisionUtils.intersectsPlaneAndPoint(plane,p)===Plane.PlaneIntersectionType_Back)
				return /*laya.d3.math.ContainmentType.Disjoint*/0;
			if (CollisionUtils.intersectsPlaneAndPoint(plane,n)===Plane.PlaneIntersectionType_Back)
				result=/*laya.d3.math.ContainmentType.Intersects*/2;
		}
		return result;
	}

	/**
	*与包围球的位置关系。返回-1,包涵;0,相交;1,不相交
	*@param sphere 包围球。
	*/
	__proto.containsBoundSphere=function(sphere){
		var result=Plane.PlaneIntersectionType_Front;
		var planeResult=Plane.PlaneIntersectionType_Front;
		for (var i=0;i < 6;i++){
			switch (i){
				case 0:
					planeResult=CollisionUtils.intersectsPlaneAndSphere(this._near,sphere);
					break ;
				case 1:
					planeResult=CollisionUtils.intersectsPlaneAndSphere(this._far,sphere);
					break ;
				case 2:
					planeResult=CollisionUtils.intersectsPlaneAndSphere(this._left,sphere);
					break ;
				case 3:
					planeResult=CollisionUtils.intersectsPlaneAndSphere(this._right,sphere);
					break ;
				case 4:
					planeResult=CollisionUtils.intersectsPlaneAndSphere(this._top,sphere);
					break ;
				case 5:
					planeResult=CollisionUtils.intersectsPlaneAndSphere(this._bottom,sphere);
					break ;
				}
			switch (planeResult){
				case Plane.PlaneIntersectionType_Back:
					return /*laya.d3.math.ContainmentType.Disjoint*/0;
				case Plane.PlaneIntersectionType_Intersecting:
					result=Plane.PlaneIntersectionType_Intersecting;
					break ;
				}
		}
		switch (result){
			case Plane.PlaneIntersectionType_Intersecting:
				return /*laya.d3.math.ContainmentType.Intersects*/2;
			default :
				return /*laya.d3.math.ContainmentType.Contains*/1;
			}
	}

	/**
	*获取顶平面。
	*@return 顶平面。
	*/
	__getset(0,__proto,'top',function(){
		return this._top;
	});

	/**
	*设置描述矩阵。
	*@param matrix 描述矩阵。
	*/
	/**
	*获取描述矩阵。
	*@return 描述矩阵。
	*/
	__getset(0,__proto,'matrix',function(){
		return this._matrix;
		},function(matrix){
		this._matrix=matrix;
		BoundFrustum._getPlanesFromMatrix(this._matrix,this._near,this._far,this._left,this._right,this._top,this._bottom);
	});

	/**
	*获取近平面。
	*@return 近平面。
	*/
	__getset(0,__proto,'near',function(){
		return this._near;
	});

	/**
	*获取远平面。
	*@return 远平面。
	*/
	__getset(0,__proto,'far',function(){
		return this._far;
	});

	/**
	*获取左平面。
	*@return 左平面。
	*/
	__getset(0,__proto,'left',function(){
		return this._left;
	});

	/**
	*获取右平面。
	*@return 右平面。
	*/
	__getset(0,__proto,'right',function(){
		return this._right;
	});

	/**
	*获取底平面。
	*@return 底平面。
	*/
	__getset(0,__proto,'bottom',function(){
		return this._bottom;
	});

	BoundFrustum._getPlanesFromMatrix=function(m,np,fp,lp,rp,tp,bp){
		var matrixE=m.elements;
		var m11=matrixE[0];
		var m12=matrixE[1];
		var m13=matrixE[2];
		var m14=matrixE[3];
		var m21=matrixE[4];
		var m22=matrixE[5];
		var m23=matrixE[6];
		var m24=matrixE[7];
		var m31=matrixE[8];
		var m32=matrixE[9];
		var m33=matrixE[10];
		var m34=matrixE[11];
		var m41=matrixE[12];
		var m42=matrixE[13];
		var m43=matrixE[14];
		var m44=matrixE[15];
		var nearNorE=np.normal;
		nearNorE.x=m14+m13;
		nearNorE.y=m24+m23;
		nearNorE.z=m34+m33;
		np.distance=m44+m43;
		np.normalize();
		var farNorE=fp.normal;
		farNorE.x=m14-m13;
		farNorE.y=m24-m23;
		farNorE.z=m34-m33;
		fp.distance=m44-m43;
		fp.normalize();
		var leftNorE=lp.normal;
		leftNorE.x=m14+m11;
		leftNorE.y=m24+m21;
		leftNorE.z=m34+m31;
		lp.distance=m44+m41;
		lp.normalize();
		var rightNorE=rp.normal;
		rightNorE.x=m14-m11;
		rightNorE.y=m24-m21;
		rightNorE.z=m34-m31;
		rp.distance=m44-m41;
		rp.normalize();
		var topNorE=tp.normal;
		topNorE.x=m14-m12;
		topNorE.y=m24-m22;
		topNorE.z=m34-m32;
		tp.distance=m44-m42;
		tp.normalize();
		var bottomNorE=bp.normal;
		bottomNorE.x=m14+m12;
		bottomNorE.y=m24+m22;
		bottomNorE.z=m34+m32;
		bp.distance=m44+m42;
		bp.normalize();
	}

	BoundFrustum._get3PlaneInterPoint=function(p1,p2,p3){
		var p1Nor=p1.normal;
		var p2Nor=p2.normal;
		var p3Nor=p3.normal;
		Vector3.cross(p2Nor,p3Nor,BoundFrustum._tempV30);
		Vector3.cross(p3Nor,p1Nor,BoundFrustum._tempV31);
		Vector3.cross(p1Nor,p2Nor,BoundFrustum._tempV32);
		var a=Vector3.dot(p1Nor,BoundFrustum._tempV30);
		var b=Vector3.dot(p2Nor,BoundFrustum._tempV31);
		var c=Vector3.dot(p3Nor,BoundFrustum._tempV32);
		Vector3.scale(BoundFrustum._tempV30,-p1.distance / a,BoundFrustum._tempV33);
		Vector3.scale(BoundFrustum._tempV31,-p2.distance / b,BoundFrustum._tempV34);
		Vector3.scale(BoundFrustum._tempV32,-p3.distance / c,BoundFrustum._tempV35);
		Vector3.add(BoundFrustum._tempV33,BoundFrustum._tempV34,BoundFrustum._tempV36);
		Vector3.add(BoundFrustum._tempV35,BoundFrustum._tempV36,BoundFrustum._tempV37);
		var v=BoundFrustum._tempV37;
		return v;
	}

	__static(BoundFrustum,
	['_tempV30',function(){return this._tempV30=new Vector3();},'_tempV31',function(){return this._tempV31=new Vector3();},'_tempV32',function(){return this._tempV32=new Vector3();},'_tempV33',function(){return this._tempV33=new Vector3();},'_tempV34',function(){return this._tempV34=new Vector3();},'_tempV35',function(){return this._tempV35=new Vector3();},'_tempV36',function(){return this._tempV36=new Vector3();},'_tempV37',function(){return this._tempV37=new Vector3();}
	]);
	return BoundFrustum;
})()


/**
*@private
*<code>KeyframeNodeOwner</code> 类用于保存帧节点的拥有者信息。
*/
//class laya.d3.component.KeyframeNodeOwner
var KeyframeNodeOwner=(function(){
	function KeyframeNodeOwner(){
		/**@private */
		this.indexInList=-1;
		/**@private */
		this.referenceCount=0;
		/**@private */
		this.updateMark=-1;
		/**@private */
		this.type=-1;
		/**@private */
		this.fullPath=null;
		/**@private */
		this.propertyOwner=null;
		/**@private */
		this.property=null;
		/**@private */
		this.defaultValue=null;
		/**@private */
		this.crossFixedValue=null;
	}

	__class(KeyframeNodeOwner,'laya.d3.component.KeyframeNodeOwner');
	var __proto=KeyframeNodeOwner.prototype;
	/**
	*@private
	*/
	__proto.saveCrossFixedValue=function(){
		var pro=this.propertyOwner;
		if (pro){
			switch (this.type){
				case 0:;
					var proPat=this.property;
					var m=proPat.length-1;
					for (var j=0;j < m;j++){
						pro=pro[proPat[j]];
						if (!pro)
							break ;
					}
					this.crossFixedValue=pro[proPat[m]];
					break ;
				case 1:;
					var locPos=pro.localPosition;
					this.crossFixedValue || (this.crossFixedValue=new Vector3());
					this.crossFixedValue.x=locPos.x;
					this.crossFixedValue.y=locPos.y;
					this.crossFixedValue.z=locPos.z;
					break ;
				case 2:;
					var locRot=pro.localRotation;
					this.crossFixedValue || (this.crossFixedValue=new Quaternion());
					this.crossFixedValue.x=locRot.x;
					this.crossFixedValue.y=locRot.y;
					this.crossFixedValue.z=locRot.z;
					this.crossFixedValue.w=locRot.w;
					break ;
				case 3:;
					var locSca=pro.localScale;
					this.crossFixedValue || (this.crossFixedValue=new Vector3());
					this.crossFixedValue.x=locSca.x;
					this.crossFixedValue.y=locSca.y;
					this.crossFixedValue.z=locSca.z;
					break ;
				case 4:;
					var locEul=pro.localRotationEuler;
					this.crossFixedValue || (this.crossFixedValue=new Vector3());
					this.crossFixedValue.x=locEul.x;
					this.crossFixedValue.y=locEul.y;
					this.crossFixedValue.z=locEul.z;
					break ;
				default :
					throw "Animator:unknown type.";
				}
		}
	}

	return KeyframeNodeOwner;
})()


/**
*@private
*<code>FrustumCulling</code> 类用于裁剪。
*/
//class laya.d3.graphics.FrustumCulling
var FrustumCulling=(function(){
	/**
	*创建一个 <code>FrustumCulling</code> 实例。
	*/
	function FrustumCulling(){}
	__class(FrustumCulling,'laya.d3.graphics.FrustumCulling');
	FrustumCulling.__init__=function(){
		if (Render.supportWebGLPlusCulling){
			FrustumCulling._cullingBufferLength=0;
			FrustumCulling._cullingBuffer=new Float32Array(4096);
		}
	}

	FrustumCulling._drawTraversalCullingBound=function(renderList,debugTool){
		var validCount=renderList.length;
		var renders=renderList.elements;
		for (var i=0,n=renderList.length;i < n;i++){
			var color=FrustumCulling._tempColor0;
			color.r=0;
			color.g=1;
			color.b=0;
			color.a=1;
			Utils3D._drawBound(debugTool,(renders [i]).bounds._getBoundBox(),color);
		}
	}

	FrustumCulling._traversalCulling=function(camera,scene,context,renderList){
		var validCount=renderList.length;
		var renders=renderList.elements;
		var boundFrustum=camera.boundFrustum;
		var camPos=camera._transform.position;
		for (var i=0;i < validCount;i++){
			var render=renders [i];
			if (camera._isLayerVisible(render._owner._layer)&& render._enable){
				Stat.frustumCulling++;
				if (!camera.useOcclusionCulling || render._needRender(boundFrustum)){
					render._visible=true;
					var bounds=render.bounds;
					render._distanceForSort=Vector3.distance(bounds.getCenter(),camPos);
					var elements=render._renderElements;
					for (var j=0,m=elements.length;j < m;j++){
						var element=elements[j];
						var renderQueue=scene._getRenderQueue(element.material.renderQueue);
						if (renderQueue.isTransparent)
							element.addToTransparentRenderQueue(context,renderQueue);
						else
						element.addToOpaqueRenderQueue(context,renderQueue);
					}
					}else {
					render._visible=false;
				}
				}else {
				render._visible=false;
			}
		}
	}

	FrustumCulling.renderObjectCulling=function(camera,scene,context,renderList){
		var i=0,n=0,j=0,m=0;
		var opaqueQueue=scene._opaqueQueue;
		var transparentQueue=scene._transparentQueue;
		opaqueQueue.clear();
		transparentQueue.clear();
		var staticBatchManagers=StaticBatchManager._managers;
		for (i=0,n=staticBatchManagers.length;i < n;i++)
		staticBatchManagers[i]._clear();
		var dynamicBatchManagers=DynamicBatchManager._managers;
		for (i=0,n=dynamicBatchManagers.length;i < n;i++)
		dynamicBatchManagers[i]._clear();
		var octree=scene._octree;
		if (octree){
			octree.updateMotionObjects();
			octree.shrinkRootIfPossible();
			octree.getCollidingWithFrustum(context);
			}else {
			FrustumCulling._traversalCulling(camera,scene,context,renderList);
		}
		if (Laya3D._config.debugFrustumCulling){
			var debugTool=scene._debugTool;
			debugTool.clear();
			if (octree){
				octree.drawAllBounds(debugTool);
				octree.drawAllObjects(debugTool);
				}else {
				FrustumCulling._drawTraversalCullingBound(renderList,debugTool);
			}
		};
		var count=opaqueQueue.elements.length;
		(count > 0)&& (opaqueQueue._quickSort(0,count-1));
		count=transparentQueue.elements.length;
		(count > 0)&& (transparentQueue._quickSort(0,count-1));
	}

	FrustumCulling.renderObjectCullingNative=function(camera,scene,context,renderList){
		var i=0,n=0,j=0,m=0;
		var opaqueQueue=scene._opaqueQueue;
		var transparentQueue=scene._transparentQueue;
		opaqueQueue.clear();
		transparentQueue.clear();
		var staticBatchManagers=StaticBatchManager._managers;
		for (i=0,n=staticBatchManagers.length;i < n;i++)
		staticBatchManagers[i]._clear();
		var dynamicBatchManagers=DynamicBatchManager._managers;
		for (i=0,n=dynamicBatchManagers.length;i < n;i++)
		dynamicBatchManagers[i]._clear();
		var validCount=renderList.length;
		var renders=renderList.elements;
		for (i=0;i < validCount;i++){
			(renders [i]).bounds;
		};
		var boundFrustum=camera.boundFrustum;
		FrustumCulling.cullingNative(camera._boundFrustumBuffer,FrustumCulling._cullingBuffer,scene._cullingBufferIndices,validCount,scene._cullingBufferResult);
		var camPos=context.camera._transform.position;
		for (i=0;i < validCount;i++){
			var render=renders [i];
			if (camera._isLayerVisible(render._owner._layer)&& render._enable && scene._cullingBufferResult[i]){
				render._visible=true;
				render._distanceForSort=Vector3.distance(render.bounds.getCenter(),camPos);
				var elements=render._renderElements;
				for (j=0,m=elements.length;j < m;j++){
					var element=elements[j];
					var renderQueue=scene._getRenderQueue(element.material.renderQueue);
					if (renderQueue.isTransparent)
						element.addToTransparentRenderQueue(context,renderQueue);
					else
					element.addToOpaqueRenderQueue(context,renderQueue);
				}
				}else {
				render._visible=false;
			}
		};
		var count=opaqueQueue.elements.length;
		(count > 0)&& (opaqueQueue._quickSort(0,count-1));
		count=transparentQueue.elements.length;
		(count > 0)&& (transparentQueue._quickSort(0,count-1));
	}

	FrustumCulling.cullingNative=function(boundFrustumBuffer,cullingBuffer,cullingBufferIndices,cullingCount,cullingBufferResult){
		return LayaGL.instance.culling(boundFrustumBuffer,cullingBuffer,cullingBufferIndices,cullingCount,cullingBufferResult);
	}

	FrustumCulling._cullingBufferLength=0;
	FrustumCulling._cullingBuffer=null;
	__static(FrustumCulling,
	['_tempVector3',function(){return this._tempVector3=new Vector3();},'_tempColor0',function(){return this._tempColor0=new Color();}
	]);
	return FrustumCulling;
})()


/**
*<code>AnimatorControllerLayer</code> 类用于创建动画控制器层。
*/
//class laya.d3.component.AnimatorControllerLayer
var AnimatorControllerLayer=(function(){
	function AnimatorControllerLayer(name){
		/**@private */
		this._defaultState=null;
		/**@private 0:常规播放、1:动态融合播放、2:固定融合播放*/
		//this._playType=0;
		/**@private */
		//this._crossDuration=NaN;
		/**@private */
		//this._crossPlayState=null;
		/**@private */
		//this._crossMark=0;
		/**@private */
		//this._crossNodesOwnersCount=0;
		/**@private */
		//this._crossNodesOwners=null;
		/**@private */
		//this._crossNodesOwnersIndicesMap=null;
		/**@private */
		//this._srcCrossClipNodeIndices=null;
		/**@private */
		//this._destCrossClipNodeIndices=null;
		/**@private */
		//this._currentPlayState=null;
		/**@private */
		this._statesMap={};
		/**@private */
		//this._states=null;
		/**@private */
		//this._playStateInfo=null;
		/**@private */
		//this._crossPlayStateInfo=null;
		/**层的名称。*/
		//this.name=null;
		/**名称。*/
		//this.blendingMode=0;
		/**权重。*/
		//this.defaultWeight=0;
		/**激活时是否自动播放*/
		this.playOnWake=true;
		this._playType=-1;
		this._crossMark=0;
		this._crossDuration=-1;
		this._crossNodesOwnersIndicesMap={};
		this._crossNodesOwnersCount=0;
		this._crossNodesOwners=[];
		this._currentPlayState=null;
		this._states=[];
		this._playStateInfo=new AnimatorPlayState();
		this._crossPlayStateInfo=new AnimatorPlayState();
		this._srcCrossClipNodeIndices=[];
		this._destCrossClipNodeIndices=[];
		this.name=name;
		this.defaultWeight=1.0;
		this.blendingMode=laya.d3.component.AnimatorControllerLayer.BLENDINGMODE_OVERRIDE;
	}

	__class(AnimatorControllerLayer,'laya.d3.component.AnimatorControllerLayer');
	var __proto=AnimatorControllerLayer.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*@private
	*/
	__proto.getAnimatorState=function(name){
		var state=this._statesMap[name];
		return state ? state :null;
	}

	/**
	*@private
	*/
	__proto.destroy=function(){
		this._statesMap=null;
		this._states=null;
		this._playStateInfo=null;
		this._crossPlayStateInfo=null;
		this._defaultState=null;
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var dest=destObject;
		dest.name=this.name;
		dest.blendingMode=this.blendingMode;
		dest.defaultWeight=this.defaultWeight;
		dest.playOnWake=this.playOnWake;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var dest=/*__JS__ */new this.constructor();
		this.cloneTo(dest);
		return dest;
	}

	/**
	*设置默认动画状态。
	*@param value 默认动画状态。
	*/
	/**
	*获取默认动画状态。
	*@return 默认动画状态。
	*/
	__getset(0,__proto,'defaultState',function(){
		return this._defaultState;
		},function(value){
		this._defaultState=value;
		this._statesMap[value.name]=value;
	});

	AnimatorControllerLayer.BLENDINGMODE_OVERRIDE=0;
	AnimatorControllerLayer.BLENDINGMODE_ADDTIVE=1;
	return AnimatorControllerLayer;
})()


/**
*<code>Collision</code> 类用于检测碰撞。
*/
//class laya.d3.math.CollisionUtils
var CollisionUtils=(function(){
	/**
	*创建一个 <code>Collision</code> 实例。
	*/
	function CollisionUtils(){}
	__class(CollisionUtils,'laya.d3.math.CollisionUtils');
	CollisionUtils.distancePlaneToPoint=function(plane,point){
		var dot=Vector3.dot(plane.normal,point);
		return dot-plane.distance;
	}

	CollisionUtils.distanceBoxToPoint=function(box,point){
		var boxMin=box.min;
		var boxMineX=boxMin.x;
		var boxMineY=boxMin.y;
		var boxMineZ=boxMin.z;
		var boxMax=box.max;
		var boxMaxeX=boxMax.x;
		var boxMaxeY=boxMax.y;
		var boxMaxeZ=boxMax.z;
		var pointeX=point.x;
		var pointeY=point.y;
		var pointeZ=point.z;
		var distance=0;
		if (pointeX < boxMineX)
			distance+=(boxMineX-pointeX)*(boxMineX-pointeX);
		if (pointeX > boxMaxeX)
			distance+=(boxMaxeX-pointeX)*(boxMaxeX-pointeX);
		if (pointeY < boxMineY)
			distance+=(boxMineY-pointeY)*(boxMineY-pointeY);
		if (pointeY > boxMaxeY)
			distance+=(boxMaxeY-pointeY)*(boxMaxeY-pointeY);
		if (pointeZ < boxMineZ)
			distance+=(boxMineZ-pointeZ)*(boxMineZ-pointeZ);
		if (pointeZ > boxMaxeZ)
			distance+=(boxMaxeZ-pointeZ)*(boxMaxeZ-pointeZ);
		return Math.sqrt(distance);
	}

	CollisionUtils.distanceBoxToBox=function(box1,box2){
		var box1Mine=box1.min;
		var box1MineX=box1Mine.x;
		var box1MineY=box1Mine.y;
		var box1MineZ=box1Mine.z;
		var box1Maxe=box1.max;
		var box1MaxeX=box1Maxe.x;
		var box1MaxeY=box1Maxe.y;
		var box1MaxeZ=box1Maxe.z;
		var box2Mine=box2.min;
		var box2MineX=box2Mine.x;
		var box2MineY=box2Mine.y;
		var box2MineZ=box2Mine.z;
		var box2Maxe=box2.max;
		var box2MaxeX=box2Maxe.x;
		var box2MaxeY=box2Maxe.y;
		var box2MaxeZ=box2Maxe.z;
		var distance=0;
		var delta=NaN;
		if (box1MineX > box2MaxeX){
			delta=box1MineX-box2MaxeX;
			distance+=delta *delta;
			}else if (box2MineX > box1MaxeX){
			delta=box2MineX-box1MaxeX;
			distance+=delta *delta;
		}
		if (box1MineY > box2MaxeY){
			delta=box1MineY-box2MaxeY;
			distance+=delta *delta;
			}else if (box2MineY > box1MaxeY){
			delta=box2MineY-box1MaxeY;
			distance+=delta *delta;
		}
		if (box1MineZ > box2MaxeZ){
			delta=box1MineZ-box2MaxeZ;
			distance+=delta *delta;
			}else if (box2MineZ > box1MaxeZ){
			delta=box2MineZ-box1MaxeZ;
			distance+=delta *delta;
		}
		return Math.sqrt(distance);
	}

	CollisionUtils.distanceSphereToPoint=function(sphere,point){
		var distance=Math.sqrt(Vector3.distanceSquared(sphere.center,point));
		distance-=sphere.radius;
		return Math.max(distance,0);
	}

	CollisionUtils.distanceSphereToSphere=function(sphere1,sphere2){
		var distance=Math.sqrt(Vector3.distanceSquared(sphere1.center,sphere2.center));
		distance-=sphere1.radius+sphere2.radius;
		return Math.max(distance,0);
	}

	CollisionUtils.intersectsRayAndTriangleRD=function(ray,vertex1,vertex2,vertex3,out){
		var rayO=ray.origin;
		var rayOeX=rayO.x;
		var rayOeY=rayO.y;
		var rayOeZ=rayO.z;
		var rayD=ray.direction;
		var rayDeX=rayD.x;
		var rayDeY=rayD.y;
		var rayDeZ=rayD.z;
		var v1eX=vertex1.x;
		var v1eY=vertex1.y;
		var v1eZ=vertex1.z;
		var v2eX=vertex2.x;
		var v2eY=vertex2.y;
		var v2eZ=vertex2.z;
		var v3eX=vertex3.x;
		var v3eY=vertex3.y;
		var v3eZ=vertex3.z;
		var _tempV30eX=CollisionUtils._tempV30.x;
		var _tempV30eY=CollisionUtils._tempV30.y;
		var _tempV30eZ=CollisionUtils._tempV30.z;
		_tempV30eX=v2eX-v1eX;
		_tempV30eY=v2eY-v1eY;
		_tempV30eZ=v2eZ-v1eZ;
		var _tempV31eX=CollisionUtils._tempV31.x;
		var _tempV31eY=CollisionUtils._tempV31.y;
		var _tempV31eZ=CollisionUtils._tempV31.z;
		_tempV31eX=v3eX-v1eX;
		_tempV31eY=v3eY-v1eY;
		_tempV31eZ=v3eZ-v1eZ;
		var _tempV32eX=CollisionUtils._tempV32.x;
		var _tempV32eY=CollisionUtils._tempV32.y;
		var _tempV32eZ=CollisionUtils._tempV32.z;
		_tempV32eX=(rayDeY *_tempV31eZ)-(rayDeZ *_tempV31eY);
		_tempV32eY=(rayDeZ *_tempV31eX)-(rayDeX *_tempV31eZ);
		_tempV32eZ=(rayDeX *_tempV31eY)-(rayDeY *_tempV31eX);
		var determinant=(_tempV30eX *_tempV32eX)+(_tempV30eY *_tempV32eY)+(_tempV30eZ *_tempV32eZ);
		if (MathUtils3D.isZero(determinant)){
			out=0;
			return false;
		};
		var inversedeterminant=1 / determinant;
		var _tempV33eX=CollisionUtils._tempV33.x;
		var _tempV33eY=CollisionUtils._tempV33.y;
		var _tempV33eZ=CollisionUtils._tempV33.z;
		_tempV33eX=rayOeX-v1eX;
		_tempV33eY=rayOeY-v1eY;
		_tempV33eZ=rayOeZ-v1eZ;
		var triangleU=(_tempV33eX *_tempV32eX)+(_tempV33eY *_tempV32eY)+(_tempV33eZ *_tempV32eZ);
		triangleU *=inversedeterminant;
		if (triangleU < 0 || triangleU > 1){
			out=0;
			return false;
		};
		var _tempV34eX=CollisionUtils._tempV34.x;
		var _tempV34eY=CollisionUtils._tempV34.y;
		var _tempV34eZ=CollisionUtils._tempV34.z;
		_tempV34eX=(_tempV33eY *_tempV30eZ)-(_tempV33eZ *_tempV30eY);
		_tempV34eY=(_tempV33eZ *_tempV30eX)-(_tempV33eX *_tempV30eZ);
		_tempV34eZ=(_tempV33eX *_tempV30eY)-(_tempV33eY *_tempV30eX);
		var triangleV=((rayDeX *_tempV34eX)+(rayDeY *_tempV34eY))+(rayDeZ *_tempV34eZ);
		triangleV *=inversedeterminant;
		if (triangleV < 0 || triangleU+triangleV > 1){
			out=0;
			return false;
		};
		var raydistance=(_tempV31eX *_tempV34eX)+(_tempV31eY *_tempV34eY)+(_tempV31eZ *_tempV34eZ);
		raydistance *=inversedeterminant;
		if (raydistance < 0){
			out=0;
			return false;
		}
		out=raydistance;
		return true;
	}

	CollisionUtils.intersectsRayAndTriangleRP=function(ray,vertex1,vertex2,vertex3,out){
		var distance=NaN;
		if (!CollisionUtils.intersectsRayAndTriangleRD(ray,vertex1,vertex2,vertex3,distance)){
			out=Vector3._ZERO;
			return false;
		}
		Vector3.scale(ray.direction,distance,CollisionUtils._tempV30);
		Vector3.add(ray.origin,CollisionUtils._tempV30,out);
		return true;
	}

	CollisionUtils.intersectsRayAndPoint=function(ray,point){
		Vector3.subtract(ray.origin,point,CollisionUtils._tempV30);
		var b=Vector3.dot(CollisionUtils._tempV30,ray.direction);
		var c=Vector3.dot(CollisionUtils._tempV30,CollisionUtils._tempV30)-MathUtils3D.zeroTolerance;
		if (c > 0 && b > 0)
			return false;
		var discriminant=b *b-c;
		if (discriminant < 0)
			return false;
		return true;
	}

	CollisionUtils.intersectsRayAndRay=function(ray1,ray2,out){
		var ray1o=ray1.origin;
		var ray1oeX=ray1o.x;
		var ray1oeY=ray1o.y;
		var ray1oeZ=ray1o.z;
		var ray1d=ray1.direction;
		var ray1deX=ray1d.x;
		var ray1deY=ray1d.y;
		var ray1deZ=ray1d.z;
		var ray2o=ray2.origin;
		var ray2oeX=ray2o.x;
		var ray2oeY=ray2o.y;
		var ray2oeZ=ray2o.z;
		var ray2d=ray2.direction;
		var ray2deX=ray2d.x;
		var ray2deY=ray2d.y;
		var ray2deZ=ray2d.z;
		Vector3.cross(ray1d,ray2d,CollisionUtils._tempV30);
		var tempV3=CollisionUtils._tempV30;
		var denominator=Vector3.scalarLength(CollisionUtils._tempV30);
		if (MathUtils3D.isZero(denominator)){
			if (MathUtils3D.nearEqual(ray2oeX,ray1oeX)&& MathUtils3D.nearEqual(ray2oeY,ray1oeY)&& MathUtils3D.nearEqual(ray2oeZ,ray1oeZ)){
				out=Vector3._ZERO;
				return true;
			}
		}
		denominator=denominator *denominator;
		var m11=ray2oeX-ray1oeX;
		var m12=ray2oeY-ray1oeY;
		var m13=ray2oeZ-ray1oeZ;
		var m21=ray2deX;
		var m22=ray2deY;
		var m23=ray2deZ;
		var m31=tempV3.x;
		var m32=tempV3.y;
		var m33=tempV3.z;
		var dets=m11 *m22 *m33+m12 *m23 *m31+m13 *m21 *m32-m11 *m23 *m32-m12 *m21 *m33-m13 *m22 *m31;
		m21=ray1deX;
		m22=ray1deY;
		m23=ray1deZ;
		var dett=m11 *m22 *m33+m12 *m23 *m31+m13 *m21 *m32-m11 *m23 *m32-m12 *m21 *m33-m13 *m22 *m31;
		var s=dets / denominator;
		var t=dett / denominator;
		Vector3.scale(ray1d,s,CollisionUtils._tempV30);
		Vector3.scale(ray2d,s,CollisionUtils._tempV31);
		Vector3.add(ray1o,CollisionUtils._tempV30,CollisionUtils._tempV32);
		Vector3.add(ray2o,CollisionUtils._tempV31,CollisionUtils._tempV33);
		var point1e=CollisionUtils._tempV32;
		var point2e=CollisionUtils._tempV33;
		if (!MathUtils3D.nearEqual(point2e.x,point1e.x)|| !MathUtils3D.nearEqual(point2e.y,point1e.y)|| !MathUtils3D.nearEqual(point2e.z,point1e.z)){
			out=Vector3._ZERO;
			return false;
		}
		out=CollisionUtils._tempV32;
		return true;
	}

	CollisionUtils.intersectsPlaneAndTriangle=function(plane,vertex1,vertex2,vertex3){
		var test1=CollisionUtils.intersectsPlaneAndPoint(plane,vertex1);
		var test2=CollisionUtils.intersectsPlaneAndPoint(plane,vertex2);
		var test3=CollisionUtils.intersectsPlaneAndPoint(plane,vertex3);
		if (test1==Plane.PlaneIntersectionType_Front && test2==Plane.PlaneIntersectionType_Front && test3==Plane.PlaneIntersectionType_Front)
			return Plane.PlaneIntersectionType_Front;
		if (test1==Plane.PlaneIntersectionType_Back && test2==Plane.PlaneIntersectionType_Back && test3==Plane.PlaneIntersectionType_Back)
			return Plane.PlaneIntersectionType_Back;
		return Plane.PlaneIntersectionType_Intersecting;
	}

	CollisionUtils.intersectsRayAndPlaneRD=function(ray,plane,out){
		var planeNor=plane.normal;
		var direction=Vector3.dot(planeNor,ray.direction);
		if (MathUtils3D.isZero(direction)){
			out=0;
			return false;
		};
		var position=Vector3.dot(planeNor,ray.origin);
		out=(-plane.distance-position)/ direction;
		if (out < 0){
			out=0;
			return false;
		}
		return true;
	}

	CollisionUtils.intersectsRayAndPlaneRP=function(ray,plane,out){
		var distance=NaN;
		if (!CollisionUtils.intersectsRayAndPlaneRD(ray,plane,distance)){
			out=Vector3._ZERO;
			return false;
		}
		Vector3.scale(ray.direction,distance,CollisionUtils._tempV30);
		Vector3.add(ray.origin,CollisionUtils._tempV30,CollisionUtils._tempV31);
		out=CollisionUtils._tempV31;
		return true;
	}

	CollisionUtils.intersectsRayAndBoxRD=function(ray,box){
		var rayoe=ray.origin;
		var rayoeX=rayoe.x;
		var rayoeY=rayoe.y;
		var rayoeZ=rayoe.z;
		var rayde=ray.direction;
		var raydeX=rayde.x;
		var raydeY=rayde.y;
		var raydeZ=rayde.z;
		var boxMine=box.min;
		var boxMineX=boxMine.x;
		var boxMineY=boxMine.y;
		var boxMineZ=boxMine.z;
		var boxMaxe=box.max;
		var boxMaxeX=boxMaxe.x;
		var boxMaxeY=boxMaxe.y;
		var boxMaxeZ=boxMaxe.z;
		var out=0;
		var tmax=MathUtils3D.MaxValue;
		if (MathUtils3D.isZero(raydeX)){
			if (rayoeX < boxMineX || rayoeX > boxMaxeX){
				return-1;
			}
			}else {
			var inverse=1 / raydeX;
			var t1=(boxMineX-rayoeX)*inverse;
			var t2=(boxMaxeX-rayoeX)*inverse;
			if (t1 > t2){
				var temp=t1;
				t1=t2;
				t2=temp;
			}
			out=Math.max(t1,out);
			tmax=Math.min(t2,tmax);
			if (out > tmax){
				return-1;
			}
		}
		if (MathUtils3D.isZero(raydeY)){
			if (rayoeY < boxMineY || rayoeY > boxMaxeY){
				return-1;
			}
			}else {
			var inverse1=1 / raydeY;
			var t3=(boxMineY-rayoeY)*inverse1;
			var t4=(boxMaxeY-rayoeY)*inverse1;
			if (t3 > t4){
				var temp1=t3;
				t3=t4;
				t4=temp1;
			}
			out=Math.max(t3,out);
			tmax=Math.min(t4,tmax);
			if (out > tmax){
				return-1;
			}
		}
		if (MathUtils3D.isZero(raydeZ)){
			if (rayoeZ < boxMineZ || rayoeZ > boxMaxeZ){
				return-1;
			}
			}else {
			var inverse2=1 / raydeZ;
			var t5=(boxMineZ-rayoeZ)*inverse2;
			var t6=(boxMaxeZ-rayoeZ)*inverse2;
			if (t5 > t6){
				var temp2=t5;
				t5=t6;
				t6=temp2;
			}
			out=Math.max(t5,out);
			tmax=Math.min(t6,tmax);
			if (out > tmax){
				return-1;
			}
		}
		return out;
	}

	CollisionUtils.intersectsRayAndBoxRP=function(ray,box,out){
		var distance=CollisionUtils.intersectsRayAndBoxRD(ray,box);
		if (distance===-1){
			Vector3._ZERO.cloneTo(out);
			return distance;
		}
		Vector3.scale(ray.direction,distance,CollisionUtils._tempV30);
		Vector3.add(ray.origin,CollisionUtils._tempV30,CollisionUtils._tempV31);
		CollisionUtils._tempV31.cloneTo(out);
		return distance;
	}

	CollisionUtils.intersectsRayAndSphereRD=function(ray,sphere){
		var sphereR=sphere.radius;
		Vector3.subtract(ray.origin,sphere.center,CollisionUtils._tempV30);
		var b=Vector3.dot(CollisionUtils._tempV30,ray.direction);
		var c=Vector3.dot(CollisionUtils._tempV30,CollisionUtils._tempV30)-(sphereR *sphereR);
		if (c > 0 && b > 0){
			return-1;
		};
		var discriminant=b *b-c;
		if (discriminant < 0){
			return-1;
		};
		var distance=-b-Math.sqrt(discriminant);
		if (distance < 0)
			distance=0;
		return distance;
	}

	CollisionUtils.intersectsRayAndSphereRP=function(ray,sphere,out){
		var distance=CollisionUtils.intersectsRayAndSphereRD(ray,sphere);
		if (distance===-1){
			Vector3._ZERO.cloneTo(out);
			return distance;
		}
		Vector3.scale(ray.direction,distance,CollisionUtils._tempV30);
		Vector3.add(ray.origin,CollisionUtils._tempV30,CollisionUtils._tempV31);
		CollisionUtils._tempV31.cloneTo(out);
		return distance;
	}

	CollisionUtils.intersectsSphereAndTriangle=function(sphere,vertex1,vertex2,vertex3){
		var sphereC=sphere.center;
		var sphereR=sphere.radius;
		CollisionUtils.closestPointPointTriangle(sphereC,vertex1,vertex2,vertex3,CollisionUtils._tempV30);
		Vector3.subtract(CollisionUtils._tempV30,sphereC,CollisionUtils._tempV31);
		var dot=Vector3.dot(CollisionUtils._tempV31,CollisionUtils._tempV31);
		return dot <=sphereR *sphereR;
	}

	CollisionUtils.intersectsPlaneAndPoint=function(plane,point){
		var distance=Vector3.dot(plane.normal,point)+plane.distance;
		if (distance > 0)
			return Plane.PlaneIntersectionType_Front;
		if (distance < 0)
			return Plane.PlaneIntersectionType_Back;
		return Plane.PlaneIntersectionType_Intersecting;
	}

	CollisionUtils.intersectsPlaneAndPlane=function(plane1,plane2){
		Vector3.cross(plane1.normal,plane2.normal,CollisionUtils._tempV30);
		var denominator=Vector3.dot(CollisionUtils._tempV30,CollisionUtils._tempV30);
		if (MathUtils3D.isZero(denominator))
			return false;
		return true;
	}

	CollisionUtils.intersectsPlaneAndPlaneRL=function(plane1,plane2,line){
		var plane1nor=plane1.normal;
		var plane2nor=plane2.normal;
		Vector3.cross(plane1nor,plane2nor,CollisionUtils._tempV34);
		var denominator=Vector3.dot(CollisionUtils._tempV34,CollisionUtils._tempV34);
		if (MathUtils3D.isZero(denominator))
			return false;
		Vector3.scale(plane2nor,plane1.distance,CollisionUtils._tempV30);
		Vector3.scale(plane1nor,plane2.distance,CollisionUtils._tempV31);
		Vector3.subtract(CollisionUtils._tempV30,CollisionUtils._tempV31,CollisionUtils._tempV32);
		Vector3.cross(CollisionUtils._tempV32,CollisionUtils._tempV34,CollisionUtils._tempV33);
		Vector3.normalize(CollisionUtils._tempV34,CollisionUtils._tempV34);
		line=new Ray(CollisionUtils._tempV33,CollisionUtils._tempV34);
		return true;
	}

	CollisionUtils.intersectsPlaneAndBox=function(plane,box){
		var planeD=plane.distance;
		var planeNor=plane.normal;
		var planeNoreX=planeNor.x;
		var planeNoreY=planeNor.y;
		var planeNoreZ=planeNor.z;
		var boxMine=box.min;
		var boxMineX=boxMine.x;
		var boxMineY=boxMine.y;
		var boxMineZ=boxMine.z;
		var boxMaxe=box.max;
		var boxMaxeX=boxMaxe.x;
		var boxMaxeY=boxMaxe.y;
		var boxMaxeZ=boxMaxe.z;
		CollisionUtils._tempV30.x=(planeNoreX > 0)? boxMineX :boxMaxeX;
		CollisionUtils._tempV30.y=(planeNoreY > 0)? boxMineY :boxMaxeY;
		CollisionUtils._tempV30.z=(planeNoreZ > 0)? boxMineZ :boxMaxeZ;
		CollisionUtils._tempV31.x=(planeNoreX > 0)? boxMaxeX :boxMineX;
		CollisionUtils._tempV31.y=(planeNoreY > 0)? boxMaxeY :boxMineY;
		CollisionUtils._tempV31.z=(planeNoreZ > 0)? boxMaxeZ :boxMineZ;
		var distance=Vector3.dot(planeNor,CollisionUtils._tempV30);
		if (distance+planeD > 0)
			return Plane.PlaneIntersectionType_Front;
		distance=Vector3.dot(planeNor,CollisionUtils._tempV31);
		if (distance+planeD < 0)
			return Plane.PlaneIntersectionType_Back;
		return Plane.PlaneIntersectionType_Intersecting;
	}

	CollisionUtils.intersectsPlaneAndSphere=function(plane,sphere){
		var sphereR=sphere.radius;
		var distance=Vector3.dot(plane.normal,sphere.center)+plane.distance;
		if (distance > sphereR)
			return Plane.PlaneIntersectionType_Front;
		if (distance <-sphereR)
			return Plane.PlaneIntersectionType_Back;
		return Plane.PlaneIntersectionType_Intersecting;
	}

	CollisionUtils.intersectsBoxAndBox=function(box1,box2){
		var box1Mine=box1.min;
		var box1Maxe=box1.max;
		var box2Mine=box2.min;
		var box2Maxe=box2.max;
		if (box1Mine.x > box2Maxe.x || box2Mine.x > box1Maxe.x)
			return false;
		if (box1Mine.y > box2Maxe.y || box2Mine.y > box1Maxe.y)
			return false;
		if (box1Mine.z > box2Maxe.z || box2Mine.z > box1Maxe.z)
			return false;
		return true;
	}

	CollisionUtils.intersectsBoxAndSphere=function(box,sphere){
		var sphereC=sphere.center;
		var sphereR=sphere.radius;
		Vector3.Clamp(sphereC,box.min,box.max,CollisionUtils._tempV30);
		var distance=Vector3.distanceSquared(sphereC,CollisionUtils._tempV30);
		return distance <=sphereR *sphereR;
	}

	CollisionUtils.intersectsSphereAndSphere=function(sphere1,sphere2){
		var radiisum=sphere1.radius+sphere2.radius;
		return Vector3.distanceSquared(sphere1.center,sphere2.center)<=radiisum *radiisum;
	}

	CollisionUtils.boxContainsPoint=function(box,point){
		var boxMine=box.min;
		var boxMaxe=box.max;
		if (boxMine.x <=point.x && boxMaxe.x >=point.x && boxMine.y <=point.y && boxMaxe.y >=point.y && boxMine.z <=point.z && boxMaxe.z >=point.z)
			return /*laya.d3.math.ContainmentType.Contains*/1;
		return /*laya.d3.math.ContainmentType.Disjoint*/0;
	}

	CollisionUtils.boxContainsBox=function(box1,box2){
		var box1Mine=box1.min;
		var box1MineX=box1Mine.x;
		var box1MineY=box1Mine.y;
		var box1MineZ=box1Mine.z;
		var box1Maxe=box1.max;
		var box1MaxeX=box1Maxe.x;
		var box1MaxeY=box1Maxe.y;
		var box1MaxeZ=box1Maxe.z;
		var box2Mine=box2.min;
		var box2MineX=box2Mine.x;
		var box2MineY=box2Mine.y;
		var box2MineZ=box2Mine.z;
		var box2Maxe=box2.max;
		var box2MaxeX=box2Maxe.x;
		var box2MaxeY=box2Maxe.y;
		var box2MaxeZ=box2Maxe.z;
		if (box1MaxeX < box2MineX || box1MineX > box2MaxeX)
			return /*laya.d3.math.ContainmentType.Disjoint*/0;
		if (box1MaxeY < box2MineY || box1MineY > box2MaxeY)
			return /*laya.d3.math.ContainmentType.Disjoint*/0;
		if (box1MaxeZ < box2MineZ || box1MineZ > box2MaxeZ)
			return /*laya.d3.math.ContainmentType.Disjoint*/0;
		if (box1MineX <=box2MineX && box2MaxeX <=box1MaxeX && box1MineY <=box2MineY && box2MaxeY <=box1MaxeY && box1MineZ <=box2MineZ && box2MaxeZ <=box1MaxeZ){
			return /*laya.d3.math.ContainmentType.Contains*/1;
		}
		return /*laya.d3.math.ContainmentType.Intersects*/2;
	}

	CollisionUtils.boxContainsSphere=function(box,sphere){
		var boxMin=box.min;
		var boxMineX=boxMin.x;
		var boxMineY=boxMin.y;
		var boxMineZ=boxMin.z;
		var boxMax=box.max;
		var boxMaxeX=boxMax.x;
		var boxMaxeY=boxMax.y;
		var boxMaxeZ=boxMax.z;
		var sphereC=sphere.center;
		var sphereCeX=sphereC.x;
		var sphereCeY=sphereC.y;
		var sphereCeZ=sphereC.z;
		var sphereR=sphere.radius;
		Vector3.Clamp(sphereC,boxMin,boxMax,CollisionUtils._tempV30);
		var distance=Vector3.distanceSquared(sphereC,CollisionUtils._tempV30);
		if (distance > sphereR *sphereR)
			return /*laya.d3.math.ContainmentType.Disjoint*/0;
		if ((((boxMineX+sphereR <=sphereCeX)&& (sphereCeX <=boxMaxeX-sphereR))&& ((boxMaxeX-boxMineX > sphereR)&&
			(boxMineY+sphereR <=sphereCeY)))&& (((sphereCeY <=boxMaxeY-sphereR)&& (boxMaxeY-boxMineY > sphereR))&&
		(((boxMineZ+sphereR <=sphereCeZ)&& (sphereCeZ <=boxMaxeZ-sphereR))&& (boxMaxeZ-boxMineZ > sphereR))))
		return /*laya.d3.math.ContainmentType.Contains*/1;
		return /*laya.d3.math.ContainmentType.Intersects*/2;
	}

	CollisionUtils.sphereContainsPoint=function(sphere,point){
		if (Vector3.distanceSquared(point,sphere.center)<=sphere.radius *sphere.radius)
			return /*laya.d3.math.ContainmentType.Contains*/1;
		return /*laya.d3.math.ContainmentType.Disjoint*/0;
	}

	CollisionUtils.sphereContainsTriangle=function(sphere,vertex1,vertex2,vertex3){
		var test1=CollisionUtils.sphereContainsPoint(sphere,vertex1);
		var test2=CollisionUtils.sphereContainsPoint(sphere,vertex2);
		var test3=CollisionUtils.sphereContainsPoint(sphere,vertex3);
		if (test1==/*laya.d3.math.ContainmentType.Contains*/1 && test2==/*laya.d3.math.ContainmentType.Contains*/1 && test3==/*laya.d3.math.ContainmentType.Contains*/1)
			return /*laya.d3.math.ContainmentType.Contains*/1;
		if (CollisionUtils.intersectsSphereAndTriangle(sphere,vertex1,vertex2,vertex3))
			return /*laya.d3.math.ContainmentType.Intersects*/2;
		return /*laya.d3.math.ContainmentType.Disjoint*/0;
	}

	CollisionUtils.sphereContainsBox=function(sphere,box){
		var sphereC=sphere.center;
		var sphereCeX=sphereC.x;
		var sphereCeY=sphereC.y;
		var sphereCeZ=sphereC.z;
		var sphereR=sphere.radius;
		var boxMin=box.min;
		var boxMineX=boxMin.x;
		var boxMineY=boxMin.y;
		var boxMineZ=boxMin.z;
		var boxMax=box.max;
		var boxMaxeX=boxMax.x;
		var boxMaxeY=boxMax.y;
		var boxMaxeZ=boxMax.z;
		var _tempV30e=CollisionUtils._tempV30;
		var _tempV30eX=_tempV30e.x;
		var _tempV30eY=_tempV30e.y;
		var _tempV30eZ=_tempV30e.z;
		if (!CollisionUtils.intersectsBoxAndSphere(box,sphere))
			return /*laya.d3.math.ContainmentType.Disjoint*/0;
		var radiusSquared=sphereR *sphereR;
		_tempV30eX=sphereCeX-boxMineX;
		_tempV30eY=sphereCeY-boxMaxeY;
		_tempV30eZ=sphereCeZ-boxMaxeZ;
		if (Vector3.scalarLengthSquared(CollisionUtils._tempV30)> radiusSquared)
			return /*laya.d3.math.ContainmentType.Intersects*/2;
		_tempV30eX=sphereCeX-boxMaxeX;
		_tempV30eY=sphereCeY-boxMaxeY;
		_tempV30eZ=sphereCeZ-boxMaxeZ;
		if (Vector3.scalarLengthSquared(CollisionUtils._tempV30)> radiusSquared)
			return /*laya.d3.math.ContainmentType.Intersects*/2;
		_tempV30eX=sphereCeX-boxMaxeX;
		_tempV30eY=sphereCeY-boxMineY;
		_tempV30eZ=sphereCeZ-boxMaxeZ;
		if (Vector3.scalarLengthSquared(CollisionUtils._tempV30)> radiusSquared)
			return /*laya.d3.math.ContainmentType.Intersects*/2;
		_tempV30eX=sphereCeX-boxMineX;
		_tempV30eY=sphereCeY-boxMineY;
		_tempV30eZ=sphereCeZ-boxMaxeZ;
		if (Vector3.scalarLengthSquared(CollisionUtils._tempV30)> radiusSquared)
			return /*laya.d3.math.ContainmentType.Intersects*/2;
		_tempV30eX=sphereCeX-boxMineX;
		_tempV30eY=sphereCeY-boxMaxeY;
		_tempV30eZ=sphereCeZ-boxMineZ;
		if (Vector3.scalarLengthSquared(CollisionUtils._tempV30)> radiusSquared)
			return /*laya.d3.math.ContainmentType.Intersects*/2;
		_tempV30eX=sphereCeX-boxMaxeX;
		_tempV30eY=sphereCeY-boxMaxeY;
		_tempV30eZ=sphereCeZ-boxMineZ;
		if (Vector3.scalarLengthSquared(CollisionUtils._tempV30)> radiusSquared)
			return /*laya.d3.math.ContainmentType.Intersects*/2;
		_tempV30eX=sphereCeX-boxMaxeX;
		_tempV30eY=sphereCeY-boxMineY;
		_tempV30eZ=sphereCeZ-boxMineZ;
		if (Vector3.scalarLengthSquared(CollisionUtils._tempV30)> radiusSquared)
			return /*laya.d3.math.ContainmentType.Intersects*/2;
		_tempV30eX=sphereCeX-boxMineX;
		_tempV30eY=sphereCeY-boxMineY;
		_tempV30eZ=sphereCeZ-boxMineZ;
		if (Vector3.scalarLengthSquared(CollisionUtils._tempV30)> radiusSquared)
			return /*laya.d3.math.ContainmentType.Intersects*/2;
		return /*laya.d3.math.ContainmentType.Contains*/1;
	}

	CollisionUtils.sphereContainsSphere=function(sphere1,sphere2){
		var sphere1R=sphere1.radius;
		var sphere2R=sphere2.radius;
		var distance=Vector3.distance(sphere1.center,sphere2.center);
		if (sphere1R+sphere2R < distance)
			return /*laya.d3.math.ContainmentType.Disjoint*/0;
		if (sphere1R-sphere2R < distance)
			return /*laya.d3.math.ContainmentType.Intersects*/2;
		return /*laya.d3.math.ContainmentType.Contains*/1;
	}

	CollisionUtils.closestPointPointTriangle=function(point,vertex1,vertex2,vertex3,out){
		Vector3.subtract(vertex2,vertex1,CollisionUtils._tempV30);
		Vector3.subtract(vertex3,vertex1,CollisionUtils._tempV31);
		Vector3.subtract(point,vertex1,CollisionUtils._tempV32);
		Vector3.subtract(point,vertex2,CollisionUtils._tempV33);
		Vector3.subtract(point,vertex3,CollisionUtils._tempV34);
		var d1=Vector3.dot(CollisionUtils._tempV30,CollisionUtils._tempV32);
		var d2=Vector3.dot(CollisionUtils._tempV31,CollisionUtils._tempV32);
		var d3=Vector3.dot(CollisionUtils._tempV30,CollisionUtils._tempV33);
		var d4=Vector3.dot(CollisionUtils._tempV31,CollisionUtils._tempV33);
		var d5=Vector3.dot(CollisionUtils._tempV30,CollisionUtils._tempV34);
		var d6=Vector3.dot(CollisionUtils._tempV31,CollisionUtils._tempV34);
		if (d1 <=0 && d2 <=0){
			vertex1.cloneTo(out);
			return;
		}
		if (d3 >=0 && d4 <=d3){
			vertex2.cloneTo(out);
			return;
		};
		var vc=d1 *d4-d3 *d2;
		if (vc <=0 && d1 >=0 && d3 <=0){
			var v=d1 / (d1-d3);
			Vector3.scale(CollisionUtils._tempV30,v,out);
			Vector3.add(vertex1,out,out);
			return;
		}
		if (d6 >=0 && d5 <=d6){
			vertex3.cloneTo(out);
			return;
		};
		var vb=d5 *d2-d1 *d6;
		if (vb <=0 && d2 >=0 && d6 <=0){
			var w=d2 / (d2-d6);
			Vector3.scale(CollisionUtils._tempV31,w,out);
			Vector3.add(vertex1,out,out);
			return;
		};
		var va=d3 *d6-d5 *d4;
		if (va <=0 && (d4-d3)>=0 && (d5-d6)>=0){
			var w3=(d4-d3)/ ((d4-d3)+(d5-d6));
			Vector3.subtract(vertex3,vertex2,out);
			Vector3.scale(out,w3,out);
			Vector3.add(vertex2,out,out);
			return;
		};
		var denom=1 / (va+vb+vc);
		var v2=vb *denom;
		var w2=vc *denom;
		Vector3.scale(CollisionUtils._tempV30,v2,CollisionUtils._tempV35);
		Vector3.scale(CollisionUtils._tempV31,w2,CollisionUtils._tempV36);
		Vector3.add(CollisionUtils._tempV35,CollisionUtils._tempV36,out);
		Vector3.add(vertex1,out,out);
	}

	CollisionUtils.closestPointPlanePoint=function(plane,point,out){
		var planeN=plane.normal;
		var t=Vector3.dot(planeN,point)-plane.distance;
		Vector3.scale(planeN,t,CollisionUtils._tempV30);
		Vector3.subtract(point,CollisionUtils._tempV30,out);
	}

	CollisionUtils.closestPointBoxPoint=function(box,point,out){
		Vector3.max(point,box.min,CollisionUtils._tempV30);
		Vector3.min(CollisionUtils._tempV30,box.max,out);
	}

	CollisionUtils.closestPointSpherePoint=function(sphere,point,out){
		var sphereC=sphere.center;
		Vector3.subtract(point,sphereC,out);
		Vector3.normalize(out,out);
		Vector3.scale(out,sphere.radius,out);
		Vector3.add(out,sphereC,out);
	}

	CollisionUtils.closestPointSphereSphere=function(sphere1,sphere2,out){
		var sphere1C=sphere1.center;
		Vector3.subtract(sphere2.center,sphere1C,out);
		Vector3.normalize(out,out);
		Vector3.scale(out,sphere1.radius,out);
		Vector3.add(out,sphere1C,out);
	}

	__static(CollisionUtils,
	['_tempV30',function(){return this._tempV30=new Vector3();},'_tempV31',function(){return this._tempV31=new Vector3();},'_tempV32',function(){return this._tempV32=new Vector3();},'_tempV33',function(){return this._tempV33=new Vector3();},'_tempV34',function(){return this._tempV34=new Vector3();},'_tempV35',function(){return this._tempV35=new Vector3();},'_tempV36',function(){return this._tempV36=new Vector3();}
	]);
	return CollisionUtils;
})()


/**
*<code>Matrix3x3</code> 类用于创建3x3矩阵。
*/
//class laya.d3.math.Matrix3x3
var Matrix3x3=(function(){
	function Matrix3x3(){
		/**矩阵元素数组*/
		//this.elements=null;
		var e=this.elements=new Float32Array(9);
		e[0]=1;
		e[1]=0;
		e[2]=0;
		e[3]=0;
		e[4]=1;
		e[5]=0;
		e[6]=0;
		e[7]=0;
		e[8]=1;
	}

	__class(Matrix3x3,'laya.d3.math.Matrix3x3');
	var __proto=Matrix3x3.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*计算3x3矩阵的行列式
	*@return 矩阵的行列式
	*/
	__proto.determinant=function(){
		var f=this.elements;
		var a00=f[0],a01=f[1],a02=f[2];
		var a10=f[3],a11=f[4],a12=f[5];
		var a20=f[6],a21=f[7],a22=f[8];
		return a00 *(a22 *a11-a12 *a21)+a01 *(-a22 *a10+a12 *a20)+a02 *(a21 *a10-a11 *a20);
	}

	/**
	*通过一个二维向量转换3x3矩阵
	*@param tra 转换向量
	*@param out 输出矩阵
	*/
	__proto.translate=function(trans,out){
		var e=out.elements;
		var f=this.elements;
		var a00=f[0],a01=f[1],a02=f[2];
		var a10=f[3],a11=f[4],a12=f[5];
		var a20=f[6],a21=f[7],a22=f[8];
		var x=trans.x,y=trans.y;
		e[0]=a00;
		e[1]=a01;
		e[2]=a02;
		e[3]=a10;
		e[4]=a11;
		e[5]=a12;
		e[6]=x *a00+y *a10+a20;
		e[7]=x *a01+y *a11+a21;
		e[8]=x *a02+y *a12+a22;
	}

	/**
	*根据指定角度旋转3x3矩阵
	*@param rad 旋转角度
	*@param out 输出矩阵
	*/
	__proto.rotate=function(rad,out){
		var e=out.elements;
		var f=this.elements;
		var a00=f[0],a01=f[1],a02=f[2];
		var a10=f[3],a11=f[4],a12=f[5];
		var a20=f[6],a21=f[7],a22=f[8];
		var s=Math.sin(rad);
		var c=Math.cos(rad);
		e[0]=c *a00+s *a10;
		e[1]=c *a01+s *a11;
		e[2]=c *a02+s *a12;
		e[3]=c *a10-s *a00;
		e[4]=c *a11-s *a01;
		e[5]=c *a12-s *a02;
		e[6]=a20;
		e[7]=a21;
		e[8]=a22;
	}

	/**
	*根据制定缩放3x3矩阵
	*@param scale 缩放值
	*@param out 输出矩阵
	*/
	__proto.scale=function(scale,out){
		var e=out.elements;
		var f=this.elements;
		var x=scale.x,y=scale.y;
		e[0]=x *f[0];
		e[1]=x *f[1];
		e[2]=x *f[2];
		e[3]=y *f[3];
		e[4]=y *f[4];
		e[5]=y *f[5];
		e[6]=f[6];
		e[7]=f[7];
		e[8]=f[8];
	}

	/**
	*计算3x3矩阵的逆矩阵
	*@param out 输出的逆矩阵
	*/
	__proto.invert=function(out){
		var e=out.elements;
		var f=this.elements;
		var a00=f[0],a01=f[1],a02=f[2];
		var a10=f[3],a11=f[4],a12=f[5];
		var a20=f[6],a21=f[7],a22=f[8];
		var b01=a22 *a11-a12 *a21;
		var b11=-a22 *a10+a12 *a20;
		var b21=a21 *a10-a11 *a20;
		var det=a00 *b01+a01 *b11+a02 *b21;
		if (!det){
			out=null;
		}
		det=1.0 / det;
		e[0]=b01 *det;
		e[1]=(-a22 *a01+a02 *a21)*det;
		e[2]=(a12 *a01-a02 *a11)*det;
		e[3]=b11 *det;
		e[4]=(a22 *a00-a02 *a20)*det;
		e[5]=(-a12 *a00+a02 *a10)*det;
		e[6]=b21 *det;
		e[7]=(-a21 *a00+a01 *a20)*det;
		e[8]=(a11 *a00-a01 *a10)*det;
	}

	/**
	*计算3x3矩阵的转置矩阵
	*@param out 输出矩阵
	*/
	__proto.transpose=function(out){
		var e=out.elements;
		var f=this.elements;
		if (out===this){
			var a01=f[1],a02=f[2],a12=f[5];
			e[1]=f[3];
			e[2]=f[6];
			e[3]=a01;
			e[5]=f[7];
			e[6]=a02;
			e[7]=a12;
			}else {
			e[0]=f[0];
			e[1]=f[3];
			e[2]=f[6];
			e[3]=f[1];
			e[4]=f[4];
			e[5]=f[7];
			e[6]=f[2];
			e[7]=f[5];
			e[8]=f[8];
		}
	}

	/**设置已有的矩阵为单位矩阵*/
	__proto.identity=function(){
		var e=this.elements;
		e[0]=1;
		e[1]=0;
		e[2]=0;
		e[3]=0;
		e[4]=1;
		e[5]=0;
		e[6]=0;
		e[7]=0;
		e[8]=1;
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var i,s,d;
		s=this.elements;
		d=destObject.elements;
		if (s===d){
			return;
		}
		for (i=0;i < 9;++i){
			d[i]=s[i];
		}
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var dest=/*__JS__ */new this.constructor();
		this.cloneTo(dest);
		return dest;
	}

	Matrix3x3.createFromTranslation=function(trans,out){
		var e=out.elements;
		out[0]=1;
		out[1]=0;
		out[2]=0;
		out[3]=0;
		out[4]=1;
		out[5]=0;
		out[6]=trans.x;
		out[7]=trans.y;
		out[8]=1;
	}

	Matrix3x3.createFromRotation=function(rad,out){
		var e=out.elements;
		var s=Math.sin(rad),c=Math.cos(rad);
		e[0]=c;
		e[1]=s;
		e[2]=0;
		e[3]=-s;
		e[4]=c;
		e[5]=0;
		e[6]=0;
		e[7]=0;
		e[8]=1;
	}

	Matrix3x3.createFromScaling=function(scale,out){
		var e=out.elements;
		e[0]=scale.x;
		e[1]=0;
		e[2]=0;
		e[3]=0;
		e[4]=scale.y;
		e[5]=0;
		e[6]=0;
		e[7]=0;
		e[8]=1;
	}

	Matrix3x3.createFromMatrix4x4=function(sou,out){
		out[0]=sou[0];
		out[1]=sou[1];
		out[2]=sou[2];
		out[3]=sou[4];
		out[4]=sou[5];
		out[5]=sou[6];
		out[6]=sou[8];
		out[7]=sou[9];
		out[8]=sou[10];
	}

	Matrix3x3.multiply=function(left,right,out){
		var e=out.elements;
		var f=left.elements;
		var g=right.elements;
		var a00=f[0],a01=f[1],a02=f[2];
		var a10=f[3],a11=f[4],a12=f[5];
		var a20=f[6],a21=f[7],a22=f[8];
		var b00=g[0],b01=g[1],b02=g[2];
		var b10=g[3],b11=g[4],b12=g[5];
		var b20=g[6],b21=g[7],b22=g[8];
		e[0]=b00 *a00+b01 *a10+b02 *a20;
		e[1]=b00 *a01+b01 *a11+b02 *a21;
		e[2]=b00 *a02+b01 *a12+b02 *a22;
		e[3]=b10 *a00+b11 *a10+b12 *a20;
		e[4]=b10 *a01+b11 *a11+b12 *a21;
		e[5]=b10 *a02+b11 *a12+b12 *a22;
		e[6]=b20 *a00+b21 *a10+b22 *a20;
		e[7]=b20 *a01+b21 *a11+b22 *a21;
		e[8]=b20 *a02+b21 *a12+b22 *a22;
	}

	Matrix3x3.lookAt=function(eye,target,up,out){
		Vector3.subtract(eye,target,Matrix3x3._tempV30);
		Vector3.normalize(Matrix3x3._tempV30,Matrix3x3._tempV30);
		Vector3.cross(up,Matrix3x3._tempV30,Matrix3x3._tempV31);
		Vector3.normalize(Matrix3x3._tempV31,Matrix3x3._tempV31);
		Vector3.cross(Matrix3x3._tempV30,Matrix3x3._tempV31,Matrix3x3._tempV32);
		var v0=Matrix3x3._tempV30;
		var v1=Matrix3x3._tempV31;
		var v2=Matrix3x3._tempV32;
		var me=out.elements;
		me[0]=v1.x;
		me[3]=v1.y;
		me[6]=v1.z;
		me[1]=v2.x;
		me[4]=v2.y;
		me[7]=v2.z;
		me[2]=v0.x;
		me[5]=v0.y;
		me[8]=v0.z;
	}

	Matrix3x3.DEFAULT=new Matrix3x3();
	__static(Matrix3x3,
	['_tempV30',function(){return this._tempV30=new Vector3();},'_tempV31',function(){return this._tempV31=new Vector3();},'_tempV32',function(){return this._tempV32=new Vector3();}
	]);
	return Matrix3x3;
})()


/**
*<code>Physics</code> 类用于简单物理检测。
*/
//class laya.d3.utils.Physics3DUtils
var Physics3DUtils=(function(){
	/**
	*创建一个 <code>Physics</code> 实例。
	*/
	function Physics3DUtils(){}
	__class(Physics3DUtils,'laya.d3.utils.Physics3DUtils');
	Physics3DUtils.setColliderCollision=function(collider1,collider2,collsion){}
	Physics3DUtils.getIColliderCollision=function(collider1,collider2){
		return false;
	}

	Physics3DUtils.COLLISIONFILTERGROUP_DEFAULTFILTER=0x1;
	Physics3DUtils.COLLISIONFILTERGROUP_STATICFILTER=0x2;
	Physics3DUtils.COLLISIONFILTERGROUP_KINEMATICFILTER=0x4;
	Physics3DUtils.COLLISIONFILTERGROUP_DEBRISFILTER=0x8;
	Physics3DUtils.COLLISIONFILTERGROUP_SENSORTRIGGER=0x10;
	Physics3DUtils.COLLISIONFILTERGROUP_CHARACTERFILTER=0x20;
	Physics3DUtils.COLLISIONFILTERGROUP_CUSTOMFILTER1=0x40;
	Physics3DUtils.COLLISIONFILTERGROUP_CUSTOMFILTER2=0x80;
	Physics3DUtils.COLLISIONFILTERGROUP_CUSTOMFILTER3=0x100;
	Physics3DUtils.COLLISIONFILTERGROUP_CUSTOMFILTER4=0x200;
	Physics3DUtils.COLLISIONFILTERGROUP_CUSTOMFILTER5=0x400;
	Physics3DUtils.COLLISIONFILTERGROUP_CUSTOMFILTER6=0x800;
	Physics3DUtils.COLLISIONFILTERGROUP_CUSTOMFILTER7=0x1000;
	Physics3DUtils.COLLISIONFILTERGROUP_CUSTOMFILTER8=0x2000;
	Physics3DUtils.COLLISIONFILTERGROUP_CUSTOMFILTER9=0x4000;
	Physics3DUtils.COLLISIONFILTERGROUP_CUSTOMFILTER10=0x8000;
	Physics3DUtils.COLLISIONFILTERGROUP_ALLFILTER=-1;
	__static(Physics3DUtils,
	['gravity',function(){return this.gravity=new Vector3(0,-9.81,0);}
	]);
	return Physics3DUtils;
})()


/**
*<code>BoundBox</code> 类用于创建包围盒。
*/
//class laya.d3.math.BoundBox
var BoundBox=(function(){
	function BoundBox(min,max){
		/**最小顶点。*/
		this.min=null;
		/**最大顶点。*/
		this.max=null;
		this.min=min;
		this.max=max;
	}

	__class(BoundBox,'laya.d3.math.BoundBox');
	var __proto=BoundBox.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*@private
	*/
	__proto._rotateExtents=function(extents,rotation,out){
		var extentsX=extents.x;
		var extentsY=extents.y;
		var extentsZ=extents.z;
		var matElements=rotation.elements;
		out.x=Math.abs(matElements[0] *extentsX)+Math.abs(matElements[4] *extentsY)+Math.abs(matElements[8] *extentsZ);
		out.y=Math.abs(matElements[1] *extentsX)+Math.abs(matElements[5] *extentsY)+Math.abs(matElements[9] *extentsZ);
		out.z=Math.abs(matElements[2] *extentsX)+Math.abs(matElements[6] *extentsY)+Math.abs(matElements[10] *extentsZ);
	}

	/**
	*获取包围盒的8个角顶点。
	*@param corners 返回顶点的输出队列。
	*/
	__proto.getCorners=function(corners){
		corners.length=8;
		var minX=this.min.x;
		var minY=this.min.y;
		var minZ=this.min.z;
		var maxX=this.max.x;
		var maxY=this.max.y;
		var maxZ=this.max.z;
		corners[0]=new Vector3(minX,maxY,maxZ);
		corners[1]=new Vector3(maxX,maxY,maxZ);
		corners[2]=new Vector3(maxX,minY,maxZ);
		corners[3]=new Vector3(minX,minY,maxZ);
		corners[4]=new Vector3(minX,maxY,minZ);
		corners[5]=new Vector3(maxX,maxY,minZ);
		corners[6]=new Vector3(maxX,minY,minZ);
		corners[7]=new Vector3(minX,minY,minZ);
	}

	/**
	*获取中心点。
	*@param out
	*/
	__proto.getCenter=function(out){
		Vector3.add(this.min,this.max,out);
		Vector3.scale(out,0.5,out);
	}

	/**
	*获取范围。
	*@param out
	*/
	__proto.getExtent=function(out){
		Vector3.subtract(this.max,this.min,out);
		Vector3.scale(out,0.5,out);
	}

	/**
	*设置中心点和范围。
	*@param center
	*/
	__proto.setCenterAndExtent=function(center,extent){
		Vector3.subtract(center,extent,this.min);
		Vector3.add(center,extent,this.max);
	}

	/**
	*@private
	*/
	__proto.tranform=function(matrix,out){
		var center=BoundBox._tempVector30;
		var extent=BoundBox._tempVector31;
		this.getCenter(center);
		this.getExtent(extent);
		Vector3.transformCoordinate(center,matrix,center);
		this._rotateExtents(extent,matrix,extent);
		out.setCenterAndExtent(center,extent);
	}

	__proto.toDefault=function(){
		this.min.toDefault();
		this.max.toDefault();
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var dest=destObject;
		this.min.cloneTo(dest.min);
		this.max.cloneTo(dest.max);
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var dest=/*__JS__ */new this.constructor(new Vector3(),new Vector3());
		this.cloneTo(dest);
		return dest;
	}

	BoundBox.createfromPoints=function(points,out){
		if (points==null)
			throw new Error("points");
		var min=out.min;
		var max=out.max;
		min.x=Number.MAX_VALUE;
		min.y=Number.MAX_VALUE;
		min.z=Number.MAX_VALUE;
		max.x=-Number.MAX_VALUE;
		max.y=-Number.MAX_VALUE;
		max.z=-Number.MAX_VALUE;
		for (var i=0,n=points.length;i < n;++i){
			Vector3.min(min,points[i],min);
			Vector3.max(max,points[i],max);
		}
	}

	BoundBox.merge=function(box1,box2,out){
		Vector3.min(box1.min,box2.min,out.min);
		Vector3.max(box1.max,box2.max,out.max);
	}

	__static(BoundBox,
	['_tempVector30',function(){return this._tempVector30=new Vector3();},'_tempVector31',function(){return this._tempVector31=new Vector3();}
	]);
	return BoundBox;
})()


/**
*<code>AnimatorState</code> 类用于创建动作状态。
*/
//class laya.d3.component.AnimatorState
var AnimatorState=(function(){
	function AnimatorState(){
		/**@private */
		//this._clip=null;
		/**@private */
		//this._currentFrameIndices=null;
		/**@private */
		//this._scripts=null;
		/**名称。*/
		//this.name=null;
		/**动画播放速度,1.0为正常播放速度。*/
		this.speed=1.0;
		/**动作播放起始时间。*/
		this.clipStart=0.0;
		/**动作播放结束时间。*/
		this.clipEnd=1.0;
		this._nodeOwners=[];
	}

	__class(AnimatorState,'laya.d3.component.AnimatorState');
	var __proto=AnimatorState.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	/**
	*@private
	*/
	__proto._resetFrameIndices=function(){
		for (var i=0,n=this._currentFrameIndices.length;i < n;i++)
		this._currentFrameIndices[i]=-1;
	}

	/**
	*添加脚本。
	*@param type 组件类型。
	*@return 脚本。
	*
	*/
	__proto.addScript=function(type){
		var script=new type();
		this._scripts=this._scripts || [];
		this._scripts.push(script);
		return script;
	}

	/**
	*获取脚本。
	*@param type 组件类型。
	*@return 脚本。
	*
	*/
	__proto.getScript=function(type){
		if (this._scripts){
			for (var i=0,n=this._scripts.length;i < n;i++){
				var script=this._scripts[i];
				if (Laya.__typeof(script,type))
					return script;
			}
		}
		return null;
	}

	/**
	*获取脚本集合。
	*@param type 组件类型。
	*@return 脚本集合。
	*
	*/
	__proto.getScripts=function(type){
		var coms;
		if (this._scripts){
			for (var i=0,n=this._scripts.length;i < n;i++){
				var script=this._scripts[i];
				if (Laya.__typeof(script,type)){
					coms=coms ||[];
					coms.push(script);
				}
			}
		}
		return coms;
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var dest=destObject;
		dest.name=this.name;
		dest.speed=this.speed;
		dest.clipStart=this.clipStart;
		dest.clipEnd=this.clipEnd;
		dest.clip=this._clip;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var dest=/*__JS__ */new this.constructor();
		this.cloneTo(dest);
		return dest;
	}

	/**
	*设置动作。
	*@param value 动作。
	*/
	/**
	*获取动作。
	*@return 动作
	*/
	__getset(0,__proto,'clip',function(){
		return this._clip;
		},function(value){
		this._clip=value;
		this._currentFrameIndices=new Int16Array(value._nodes.count);
		this._resetFrameIndices();
	});

	return AnimatorState;
})()


/**
*<code>TextMesh</code> 类用于创建文本网格。
*/
//class laya.d3.text.TextMesh
var TextMesh=(function(){
	function TextMesh(){
		/**@private */
		this._vertices=null;
		/**@private */
		this._vertexBuffer=null;
		/**@private */
		this._text=null;
		/**@private */
		this._fontSize=0;
		/**@private */
		this._color=null;
	}

	__class(TextMesh,'laya.d3.text.TextMesh');
	var __proto=TextMesh.prototype;
	/**
	*@private
	*/
	__proto._createVertexBuffer=function(charCount){}
	/**
	*@private
	*/
	__proto._resizeVertexBuffer=function(charCount){}
	/**
	*@private
	*/
	__proto._addChar=function(){}
	/**
	*设置文本。
	*@param value 文本。
	*/
	/**
	*获取文本。
	*@return 文本。
	*/
	__getset(0,__proto,'text',function(){
		return this._text;
		},function(value){
		this._text=value;
	});

	/**
	*设置字体储存。
	*@return 字体尺寸。
	*/
	/**
	*获取字体尺寸。
	*@param value 字体尺寸。
	*/
	__getset(0,__proto,'fontSize',function(){
		return this._fontSize;
		},function(value){
		this._fontSize=value;
	});

	/**
	*设置颜色。
	*@param 颜色。
	*/
	/**
	*获取颜色。
	*@return 颜色。
	*/
	__getset(0,__proto,'color',function(){
		return this._color;
		},function(value){
		this._color=value;
	});

	TextMesh._indexBuffer=null;
	return TextMesh;
})()


/**
*<code>Matrix4x4</code> 类用于创建4x4矩阵。
*/
//class laya.d3.math.Matrix4x4
var Matrix4x4=(function(){
	function Matrix4x4(m11,m12,m13,m14,m21,m22,m23,m24,m31,m32,m33,m34,m41,m42,m43,m44,elements){
		/**矩阵元素数组*/
		//this.elements=null;
		(m11===void 0)&& (m11=1);
		(m12===void 0)&& (m12=0);
		(m13===void 0)&& (m13=0);
		(m14===void 0)&& (m14=0);
		(m21===void 0)&& (m21=0);
		(m22===void 0)&& (m22=1);
		(m23===void 0)&& (m23=0);
		(m24===void 0)&& (m24=0);
		(m31===void 0)&& (m31=0);
		(m32===void 0)&& (m32=0);
		(m33===void 0)&& (m33=1);
		(m34===void 0)&& (m34=0);
		(m41===void 0)&& (m41=0);
		(m42===void 0)&& (m42=0);
		(m43===void 0)&& (m43=0);
		(m44===void 0)&& (m44=1);
		var e=elements ? this.elements=elements :this.elements=new Float32Array(16);
		e[0]=m11;
		e[1]=m12;
		e[2]=m13;
		e[3]=m14;
		e[4]=m21;
		e[5]=m22;
		e[6]=m23;
		e[7]=m24;
		e[8]=m31;
		e[9]=m32;
		e[10]=m33;
		e[11]=m34;
		e[12]=m41;
		e[13]=m42;
		e[14]=m43;
		e[15]=m44;
	}

	__class(Matrix4x4,'laya.d3.math.Matrix4x4');
	var __proto=Matrix4x4.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	__proto.setRotation=function(rotation){
		var rotationX=rotation.x;
		var rotationY=rotation.y;
		var rotationZ=rotation.z;
		var rotationW=rotation.w;
		var xx=rotationX *rotationX;
		var yy=rotationY *rotationY;
		var zz=rotationZ *rotationZ;
		var xy=rotationX *rotationY;
		var zw=rotationZ *rotationW;
		var zx=rotationZ *rotationX;
		var yw=rotationY *rotationW;
		var yz=rotationY *rotationZ;
		var xw=rotationX *rotationW;
		var e=this.elements;
		e[0]=1.0-(2.0 *(yy+zz));
		e[1]=2.0 *(xy+zw);
		e[2]=2.0 *(zx-yw);
		e[4]=2.0 *(xy-zw);
		e[5]=1.0-(2.0 *(zz+xx));
		e[6]=2.0 *(yz+xw);
		e[8]=2.0 *(zx+yw);
		e[9]=2.0 *(yz-xw);
		e[10]=1.0-(2.0 *(yy+xx));
	}

	__proto.setPosition=function(position){
		var e=this.elements;
		e[12]=position.x;
		e[13]=position.y;
		e[14]=position.z;
	}

	__proto.getElementByRowColumn=function(row,column){
		if (row < 0 || row > 3)
			throw new Error("row","Rows and columns for matrices run from 0 to 3, inclusive.");
		if (column < 0 || column > 3)
			throw new Error("column","Rows and columns for matrices run from 0 to 3, inclusive.");
		return this.elements[(row *4)+column];
	}

	__proto.setElementByRowColumn=function(row,column,value){
		if (row < 0 || row > 3)
			throw new Error("row","Rows and columns for matrices run from 0 to 3, inclusive.");
		if (column < 0 || column > 3)
			throw new Error("column","Rows and columns for matrices run from 0 to 3, inclusive.");
		this.elements[(row *4)+column]=value;
	}

	/**
	*判断两个4x4矩阵的值是否相等。
	*@param other 4x4矩阵
	*/
	__proto.equalsOtherMatrix=function(other){
		var e=this.elements;
		var oe=other.elements;
		return (MathUtils3D.nearEqual(e[0],oe[0])&& MathUtils3D.nearEqual(e[1],oe[1])&& MathUtils3D.nearEqual(e[2],oe[2])&& MathUtils3D.nearEqual(e[3],oe[3])&& MathUtils3D.nearEqual(e[4],oe[4])&& MathUtils3D.nearEqual(e[5],oe[5])&& MathUtils3D.nearEqual(e[6],oe[6])&& MathUtils3D.nearEqual(e[7],oe[7])&& MathUtils3D.nearEqual(e[8],oe[8])&& MathUtils3D.nearEqual(e[9],oe[9])&& MathUtils3D.nearEqual(e[10],oe[10])&& MathUtils3D.nearEqual(e[11],oe[11])&& MathUtils3D.nearEqual(e[12],oe[12])&& MathUtils3D.nearEqual(e[13],oe[13])&& MathUtils3D.nearEqual(e[14],oe[14])&& MathUtils3D.nearEqual(e[15],oe[15]));
	}

	/**
	*分解矩阵为平移向量、旋转四元数、缩放向量。
	*@param translation 平移向量。
	*@param rotation 旋转四元数。
	*@param scale 缩放向量。
	*@return 是否分解成功。
	*/
	__proto.decomposeTransRotScale=function(translation,rotation,scale){
		var rotationMatrix=Matrix4x4._tempMatrix4x4;
		if (this.decomposeTransRotMatScale(translation,rotationMatrix,scale)){
			Quaternion.createFromMatrix4x4(rotationMatrix,rotation);
			return true;
			}else {
			rotation.identity();
			return false;
		}
	}

	/**
	*分解矩阵为平移向量、旋转矩阵、缩放向量。
	*@param translation 平移向量。
	*@param rotationMatrix 旋转矩阵。
	*@param scale 缩放向量。
	*@return 是否分解成功。
	*/
	__proto.decomposeTransRotMatScale=function(translation,rotationMatrix,scale){
		var e=this.elements;
		var te=translation;
		var re=rotationMatrix.elements;
		var se=scale;
		te.x=e[12];
		te.y=e[13];
		te.z=e[14];
		var m11=e[0],m12=e[1],m13=e[2];
		var m21=e[4],m22=e[5],m23=e[6];
		var m31=e[8],m32=e[9],m33=e[10];
		var sX=se.x=Math.sqrt((m11 *m11)+(m12 *m12)+(m13 *m13));
		var sY=se.y=Math.sqrt((m21 *m21)+(m22 *m22)+(m23 *m23));
		var sZ=se.z=Math.sqrt((m31 *m31)+(m32 *m32)+(m33 *m33));
		if (MathUtils3D.isZero(sX)|| MathUtils3D.isZero(sY)|| MathUtils3D.isZero(sZ)){
			re[1]=re[2]=re[3]=re[4]=re[6]=re[7]=re[8]=re[9]=re[11]=re[12]=re[13]=re[14]=0;
			re[0]=re[5]=re[10]=re[15]=1;
			return false;
		};
		var at=Matrix4x4._tempVector0;
		at.x=m31 / sZ;
		at.y=m32 / sZ;
		at.z=m33 / sZ;
		var tempRight=Matrix4x4._tempVector1;
		tempRight.x=m11 / sX;
		tempRight.y=m12 / sX;
		tempRight.z=m13 / sX;
		var up=Matrix4x4._tempVector2;
		Vector3.cross(at,tempRight,up);
		var right=Matrix4x4._tempVector1;
		Vector3.cross(up,at,right);
		re[3]=re[7]=re[11]=re[12]=re[13]=re[14]=0;
		re[15]=1;
		re[0]=right.x;
		re[1]=right.y;
		re[2]=right.z;
		re[4]=up.x;
		re[5]=up.y;
		re[6]=up.z;
		re[8]=at.x;
		re[9]=at.y;
		re[10]=at.z;
		((re[0] *m11+re[1] *m12+re[2] *m13)< 0.0)&& (se[0]=-sX);
		((re[4] *m21+re[5] *m22+re[6] *m23)< 0.0)&& (se[1]=-sY);
		((re[8] *m31+re[9] *m32+re[10] *m33)< 0.0)&& (se[2]=-sZ);
		return true;
	}

	/**
	*分解旋转矩阵的旋转为YawPitchRoll欧拉角。
	*@param out float yaw
	*@param out float pitch
	*@param out float roll
	*@return
	*/
	__proto.decomposeYawPitchRoll=function(yawPitchRoll){
		var pitch=Math.asin(-this.elements[9]);
		yawPitchRoll.y=pitch;
		var test=Math.cos(pitch);
		if (test > MathUtils3D.zeroTolerance){
			yawPitchRoll.z=Math.atan2(this.elements[1],this.elements[5]);
			yawPitchRoll.x=Math.atan2(this.elements[8],this.elements[10]);
			}else {
			yawPitchRoll.z=Math.atan2(-this.elements[4],this.elements[0]);
			yawPitchRoll.x=0.0;
		}
	}

	/**归一化矩阵 */
	__proto.normalize=function(){
		var v=this.elements;
		var c=v[0],d=v[1],e=v[2],g=Math.sqrt(c *c+d *d+e *e);
		if (g){
			if (g==1)
				return;
			}else {
			v[0]=0;
			v[1]=0;
			v[2]=0;
			return;
		}
		g=1 / g;
		v[0]=c *g;
		v[1]=d *g;
		v[2]=e *g;
	}

	/**计算矩阵的转置矩阵*/
	__proto.transpose=function(){
		var e,t;
		e=this.elements;
		t=e[1];
		e[1]=e[4];
		e[4]=t;
		t=e[2];
		e[2]=e[8];
		e[8]=t;
		t=e[3];
		e[3]=e[12];
		e[12]=t;
		t=e[6];
		e[6]=e[9];
		e[9]=t;
		t=e[7];
		e[7]=e[13];
		e[13]=t;
		t=e[11];
		e[11]=e[14];
		e[14]=t;
		return this;
	}

	/**
	*计算一个矩阵的逆矩阵
	*@param out 输出矩阵
	*/
	__proto.invert=function(out){
		var ae=this.elements;
		var oe=out.elements;
		var a00=ae[0],a01=ae[1],a02=ae[2],a03=ae[3],a10=ae[4],a11=ae[5],a12=ae[6],a13=ae[7],a20=ae[8],a21=ae[9],a22=ae[10],a23=ae[11],a30=ae[12],a31=ae[13],a32=ae[14],a33=ae[15],
		b00=a00 *a11-a01 *a10,b01=a00 *a12-a02 *a10,b02=a00 *a13-a03 *a10,b03=a01 *a12-a02 *a11,b04=a01 *a13-a03 *a11,b05=a02 *a13-a03 *a12,b06=a20 *a31-a21 *a30,b07=a20 *a32-a22 *a30,b08=a20 *a33-a23 *a30,b09=a21 *a32-a22 *a31,b10=a21 *a33-a23 *a31,b11=a22 *a33-a23 *a32,
		det=b00 *b11-b01 *b10+b02 *b09+b03 *b08-b04 *b07+b05 *b06;
		if (Math.abs(det)===0.0){
			return;
		}
		det=1.0 / det;
		oe[0]=(a11 *b11-a12 *b10+a13 *b09)*det;
		oe[1]=(a02 *b10-a01 *b11-a03 *b09)*det;
		oe[2]=(a31 *b05-a32 *b04+a33 *b03)*det;
		oe[3]=(a22 *b04-a21 *b05-a23 *b03)*det;
		oe[4]=(a12 *b08-a10 *b11-a13 *b07)*det;
		oe[5]=(a00 *b11-a02 *b08+a03 *b07)*det;
		oe[6]=(a32 *b02-a30 *b05-a33 *b01)*det;
		oe[7]=(a20 *b05-a22 *b02+a23 *b01)*det;
		oe[8]=(a10 *b10-a11 *b08+a13 *b06)*det;
		oe[9]=(a01 *b08-a00 *b10-a03 *b06)*det;
		oe[10]=(a30 *b04-a31 *b02+a33 *b00)*det;
		oe[11]=(a21 *b02-a20 *b04-a23 *b00)*det;
		oe[12]=(a11 *b07-a10 *b09-a12 *b06)*det;
		oe[13]=(a00 *b09-a01 *b07+a02 *b06)*det;
		oe[14]=(a31 *b01-a30 *b03-a32 *b00)*det;
		oe[15]=(a20 *b03-a21 *b01+a22 *b00)*det;
	}

	/**设置矩阵为单位矩阵*/
	__proto.identity=function(){
		var e=this.elements;
		e[1]=e[2]=e[3]=e[4]=e[6]=e[7]=e[8]=e[9]=e[11]=e[12]=e[13]=e[14]=0;
		e[0]=e[5]=e[10]=e[15]=1;
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var i,s,d;
		s=this.elements;
		d=destObject.elements;
		if (s===d){
			return;
		}
		for (i=0;i < 16;++i){
			d[i]=s[i];
		}
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var dest=/*__JS__ */new this.constructor();
		this.cloneTo(dest);
		return dest;
	}

	/**
	*获取平移向量。
	*@param out 平移向量。
	*/
	__proto.getTranslationVector=function(out){
		var me=this.elements;
		out.x=me[12];
		out.y=me[13];
		out.z=me[14];
	}

	/**
	*设置平移向量。
	*@param translate 平移向量。
	*/
	__proto.setTranslationVector=function(translate){
		var me=this.elements;
		var ve=translate;
		me[12]=ve.x;
		me[13]=ve.y;
		me[14]=ve.z;
	}

	/**
	*获取前向量。
	*@param out 前向量。
	*/
	__proto.getForward=function(out){
		var me=this.elements;
		out.x=-me[8];
		out.y=-me[9];
		out.z=-me[10];
	}

	/**
	*设置前向量。
	*@param forward 前向量。
	*/
	__proto.setForward=function(forward){
		var me=this.elements;
		me[8]=-forward.x;
		me[9]=-forward.y;
		me[10]=-forward.z;
	}

	Matrix4x4.createRotationX=function(rad,out){
		var oe=out.elements;
		var s=Math.sin(rad),c=Math.cos(rad);
		oe[1]=oe[2]=oe[3]=oe[4]=oe[7]=oe[8]=oe[11]=oe[12]=oe[13]=oe[14]=0;
		oe[0]=oe[15]=1;
		oe[5]=oe[10]=c;
		oe[6]=s;
		oe[9]=-s;
	}

	Matrix4x4.createRotationY=function(rad,out){
		var oe=out.elements;
		var s=Math.sin(rad),c=Math.cos(rad);
		oe[1]=oe[3]=oe[4]=oe[6]=oe[7]=oe[9]=oe[11]=oe[12]=oe[13]=oe[14]=0;
		oe[5]=oe[15]=1;
		oe[0]=oe[10]=c;
		oe[2]=-s;
		oe[8]=s;
	}

	Matrix4x4.createRotationZ=function(rad,out){
		var oe=out.elements;
		var s=Math.sin(rad),c=Math.cos(rad);
		oe[2]=oe[3]=oe[6]=oe[7]=oe[8]=oe[9]=oe[11]=oe[12]=oe[13]=oe[14]=0;
		oe[10]=oe[15]=1;
		oe[0]=oe[5]=c;
		oe[1]=s;
		oe[4]=-s;
	}

	Matrix4x4.createRotationYawPitchRoll=function(yaw,pitch,roll,result){
		Quaternion.createFromYawPitchRoll(yaw,pitch,roll,Matrix4x4._tempQuaternion);
		Matrix4x4.createRotationQuaternion(Matrix4x4._tempQuaternion,result);
	}

	Matrix4x4.createRotationAxis=function(axis,angle,result){
		var x=axis.x;
		var y=axis.y;
		var z=axis.z;
		var cos=Math.cos(angle);
		var sin=Math.sin(angle);
		var xx=x *x;
		var yy=y *y;
		var zz=z *z;
		var xy=x *y;
		var xz=x *z;
		var yz=y *z;
		var resultE=result.elements;
		resultE[3]=resultE[7]=resultE[11]=resultE[12]=resultE[13]=resultE[14]=0;
		resultE[15]=1.0;
		resultE[0]=xx+(cos *(1.0-xx));
		resultE[1]=(xy-(cos *xy))+(sin *z);
		resultE[2]=(xz-(cos *xz))-(sin *y);
		resultE[4]=(xy-(cos *xy))-(sin *z);
		resultE[5]=yy+(cos *(1.0-yy));
		resultE[6]=(yz-(cos *yz))+(sin *x);
		resultE[8]=(xz-(cos *xz))+(sin *y);
		resultE[9]=(yz-(cos *yz))-(sin *x);
		resultE[10]=zz+(cos *(1.0-zz));
	}

	Matrix4x4.createRotationQuaternion=function(rotation,result){
		var resultE=result.elements;
		var rotationX=rotation.x;
		var rotationY=rotation.y;
		var rotationZ=rotation.z;
		var rotationW=rotation.w;
		var xx=rotationX *rotationX;
		var yy=rotationY *rotationY;
		var zz=rotationZ *rotationZ;
		var xy=rotationX *rotationY;
		var zw=rotationZ *rotationW;
		var zx=rotationZ *rotationX;
		var yw=rotationY *rotationW;
		var yz=rotationY *rotationZ;
		var xw=rotationX *rotationW;
		resultE[3]=resultE[7]=resultE[11]=resultE[12]=resultE[13]=resultE[14]=0;
		resultE[15]=1.0;
		resultE[0]=1.0-(2.0 *(yy+zz));
		resultE[1]=2.0 *(xy+zw);
		resultE[2]=2.0 *(zx-yw);
		resultE[4]=2.0 *(xy-zw);
		resultE[5]=1.0-(2.0 *(zz+xx));
		resultE[6]=2.0 *(yz+xw);
		resultE[8]=2.0 *(zx+yw);
		resultE[9]=2.0 *(yz-xw);
		resultE[10]=1.0-(2.0 *(yy+xx));
	}

	Matrix4x4.createTranslate=function(trans,out){
		var oe=out.elements;
		oe[4]=oe[8]=oe[1]=oe[9]=oe[2]=oe[6]=oe[3]=oe[7]=oe[11]=0;
		oe[0]=oe[5]=oe[10]=oe[15]=1;
		oe[12]=trans.x;
		oe[13]=trans.y;
		oe[14]=trans.z;
	}

	Matrix4x4.createScaling=function(scale,out){
		var oe=out.elements;
		oe[0]=scale.x;
		oe[5]=scale.y;
		oe[10]=scale.z;
		oe[1]=oe[4]=oe[8]=oe[12]=oe[9]=oe[13]=oe[2]=oe[6]=oe[14]=oe[3]=oe[7]=oe[11]=0;
		oe[15]=1;
	}

	Matrix4x4.multiply=function(left,right,out){
		var i,e,a,b,ai0,ai1,ai2,ai3;
		e=out.elements;
		a=left.elements;
		b=right.elements;
		if (e===b){
			b=new Float32Array(16);
			for (i=0;i < 16;++i){
				b[i]=e[i];
			}
		};
		var b0=b[0],b1=b[1],b2=b[2],b3=b[3];
		var b4=b[4],b5=b[5],b6=b[6],b7=b[7];
		var b8=b[8],b9=b[9],b10=b[10],b11=b[11];
		var b12=b[12],b13=b[13],b14=b[14],b15=b[15];
		for (i=0;i < 4;i++){
			ai0=a[i];
			ai1=a[i+4];
			ai2=a[i+8];
			ai3=a[i+12];
			e[i]=ai0 *b0+ai1 *b1+ai2 *b2+ai3 *b3;
			e[i+4]=ai0 *b4+ai1 *b5+ai2 *b6+ai3 *b7;
			e[i+8]=ai0 *b8+ai1 *b9+ai2 *b10+ai3 *b11;
			e[i+12]=ai0 *b12+ai1 *b13+ai2 *b14+ai3 *b15;
		}
	}

	Matrix4x4.multiplyForNative=function(left,right,out){
		LayaGL.instance.matrix4x4Multiply(left.elements,right.elements,out.elements);
	}

	Matrix4x4.createFromQuaternion=function(rotation,out){
		var e=out.elements;
		var x=rotation.x,y=rotation.y,z=rotation.z,w=rotation.w;
		var x2=x+x;
		var y2=y+y;
		var z2=z+z;
		var xx=x *x2;
		var yx=y *x2;
		var yy=y *y2;
		var zx=z *x2;
		var zy=z *y2;
		var zz=z *z2;
		var wx=w *x2;
		var wy=w *y2;
		var wz=w *z2;
		e[0]=1-yy-zz;
		e[1]=yx+wz;
		e[2]=zx-wy;
		e[3]=0;
		e[4]=yx-wz;
		e[5]=1-xx-zz;
		e[6]=zy+wx;
		e[7]=0;
		e[8]=zx+wy;
		e[9]=zy-wx;
		e[10]=1-xx-yy;
		e[11]=0;
		e[12]=0;
		e[13]=0;
		e[14]=0;
		e[15]=1;
	}

	Matrix4x4.createAffineTransformation=function(trans,rot,scale,out){
		var oe=out.elements;
		var x=rot.x,y=rot.y,z=rot.z,w=rot.w,x2=x+x,y2=y+y,z2=z+z;
		var xx=x *x2,xy=x *y2,xz=x *z2,yy=y *y2,yz=y *z2,zz=z *z2;
		var wx=w *x2,wy=w *y2,wz=w *z2,sx=scale.x,sy=scale.y,sz=scale.z;
		oe[0]=(1-(yy+zz))*sx;
		oe[1]=(xy+wz)*sx;
		oe[2]=(xz-wy)*sx;
		oe[3]=0;
		oe[4]=(xy-wz)*sy;
		oe[5]=(1-(xx+zz))*sy;
		oe[6]=(yz+wx)*sy;
		oe[7]=0;
		oe[8]=(xz+wy)*sz;
		oe[9]=(yz-wx)*sz;
		oe[10]=(1-(xx+yy))*sz;
		oe[11]=0;
		oe[12]=trans.x;
		oe[13]=trans.y;
		oe[14]=trans.z;
		oe[15]=1;
	}

	Matrix4x4.createLookAt=function(eye,target,up,out){
		var oE=out.elements;
		var xaxis=Matrix4x4._tempVector0;
		var yaxis=Matrix4x4._tempVector1;
		var zaxis=Matrix4x4._tempVector2;
		Vector3.subtract(eye,target,zaxis);
		Vector3.normalize(zaxis,zaxis);
		Vector3.cross(up,zaxis,xaxis);
		Vector3.normalize(xaxis,xaxis);
		Vector3.cross(zaxis,xaxis,yaxis);
		out.identity();
		oE[0]=xaxis.x;
		oE[4]=xaxis.y;
		oE[8]=xaxis.z;
		oE[1]=yaxis.x;
		oE[5]=yaxis.y;
		oE[9]=yaxis.z;
		oE[2]=zaxis.x;
		oE[6]=zaxis.y;
		oE[10]=zaxis.z;
		oE[12]=-Vector3.dot(xaxis,eye);
		oE[13]=-Vector3.dot(yaxis,eye);
		oE[14]=-Vector3.dot(zaxis,eye);
	}

	Matrix4x4.createPerspective=function(fov,aspect,znear,zfar,out){
		var yScale=1.0 / Math.tan(fov *0.5);
		var xScale=yScale / aspect;
		var halfWidth=znear / xScale;
		var halfHeight=znear / yScale;
		Matrix4x4.createPerspectiveOffCenter(-halfWidth,halfWidth,-halfHeight,halfHeight,znear,zfar,out);
	}

	Matrix4x4.createPerspectiveOffCenter=function(left,right,bottom,top,znear,zfar,out){
		var oe=out.elements;
		var zRange=zfar / (zfar-znear);
		oe[1]=oe[2]=oe[3]=oe[4]=oe[6]=oe[7]=oe[12]=oe[13]=oe[15]=0;
		oe[0]=2.0 *znear / (right-left);
		oe[5]=2.0 *znear / (top-bottom);
		oe[8]=(left+right)/ (right-left);
		oe[9]=(top+bottom)/ (top-bottom);
		oe[10]=-zRange;
		oe[11]=-1.0;
		oe[14]=-znear *zRange;
	}

	Matrix4x4.createOrthoOffCenter=function(left,right,bottom,top,znear,zfar,out){
		var oe=out.elements;
		var zRange=1.0 / (zfar-znear);
		oe[1]=oe[2]=oe[3]=oe[4]=oe[6]=oe[8]=oe[7]=oe[9]=oe[11]=0;
		oe[15]=1;
		oe[0]=2.0 / (right-left);
		oe[5]=2.0 / (top-bottom);
		oe[10]=-zRange;
		oe[12]=(left+right)/ (left-right);
		oe[13]=(top+bottom)/ (bottom-top);
		oe[14]=-znear *zRange;
	}

	Matrix4x4.billboard=function(objectPosition,cameraPosition,cameraRight,cameraUp,cameraForward,mat){
		Vector3.subtract(objectPosition,cameraPosition,Matrix4x4._tempVector0);
		var lengthSq=Vector3.scalarLengthSquared(Matrix4x4._tempVector0);
		if (MathUtils3D.isZero(lengthSq)){
			Vector3.scale(cameraForward,-1,Matrix4x4._tempVector1);
			Matrix4x4._tempVector1.cloneTo(Matrix4x4._tempVector0);
			}else {
			Vector3.scale(Matrix4x4._tempVector0,1 / Math.sqrt(lengthSq),Matrix4x4._tempVector0);
		}
		Vector3.cross(cameraUp,Matrix4x4._tempVector0,Matrix4x4._tempVector2);
		Vector3.normalize(Matrix4x4._tempVector2,Matrix4x4._tempVector2);
		Vector3.cross(Matrix4x4._tempVector0,Matrix4x4._tempVector2,Matrix4x4._tempVector3);
		var crosse=Matrix4x4._tempVector2;
		var finale=Matrix4x4._tempVector3;
		var diffee=Matrix4x4._tempVector0;
		var obpose=objectPosition;
		var mate=mat.elements;
		mate[0]=crosse.x;
		mate[1]=crosse.y;
		mate[2]=crosse.z;
		mate[3]=0.0;
		mate[4]=finale.x;
		mate[5]=finale.y;
		mate[6]=finale.z;
		mate[7]=0.0;
		mate[8]=diffee.x;
		mate[9]=diffee.y;
		mate[10]=diffee.z;
		mate[11]=0.0;
		mate[12]=obpose.x;
		mate[13]=obpose.y;
		mate[14]=obpose.z;
		mate[15]=1.0;
	}

	Matrix4x4.translation=function(v3,out){
		var oe=out.elements;
		oe[0]=oe[5]=oe[10]=oe[15]=1;
		oe[12]=v3.x;
		oe[13]=v3.y;
		oe[14]=v3.z;
	}

	__static(Matrix4x4,
	['_tempMatrix4x4',function(){return this._tempMatrix4x4=new Matrix4x4();},'_tempVector0',function(){return this._tempVector0=new Vector3();},'_tempVector1',function(){return this._tempVector1=new Vector3();},'_tempVector2',function(){return this._tempVector2=new Vector3();},'_tempVector3',function(){return this._tempVector3=new Vector3();},'_tempQuaternion',function(){return this._tempQuaternion=new Quaternion();},'DEFAULT',function(){return this.DEFAULT=new Matrix4x4();},'ZERO',function(){return this.ZERO=new Matrix4x4(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);}
	]);
	return Matrix4x4;
})()


/**
*<code>Simulation</code> 类用于创建物理模拟器。
*/
//class laya.d3.physics.PhysicsSimulation
var PhysicsSimulation=(function(){
	function PhysicsSimulation(configuration,flags){
		/**@private */
		this._nativeDiscreteDynamicsWorld=null;
		/**@private */
		this._nativeCollisionWorld=null;
		/**@private */
		this._nativeDispatcher=null;
		/**@private */
		this._nativeCollisionConfiguration=null;
		/**@private */
		this._nativeBroadphase=null;
		/**@private */
		this._nativeSolverInfo=null;
		/**@private */
		this._nativeDispatchInfo=null;
		/**@private */
		this._nativeClosestRayResultCallback=null;
		/**@private */
		this._nativeAllHitsRayResultCallback=null;
		/**@private */
		this._nativeClosestConvexResultCallback=null;
		/**@private */
		this._nativeAllConvexResultCallback=null;
		/**@private */
		this._updatedRigidbodies=0;
		/**物理引擎在一帧中用于补偿减速的最大次数：模拟器每帧允许的最大模拟次数，如果引擎运行缓慢,可能需要增加该次数，否则模拟器会丢失“时间",引擎间隔时间小于maxSubSteps*fixedTimeStep非常重要。*/
		this.maxSubSteps=1;
		/**物理模拟器帧的间隔时间:通过减少fixedTimeStep可增加模拟精度，默认是1.0 / 60.0。*/
		this.fixedTimeStep=1.0 / 60.0;
		this._gravity=new Vector3(0,-10,0);
		this._nativeVector3Zero=new Laya3D._physics3D.btVector3(0,0,0);
		this._nativeDefaultQuaternion=new Laya3D._physics3D.btQuaternion(0,0,0,-1);
		this._collisionsUtils=new CollisionTool();
		this._previousFrameCollisions=[];
		this._currentFrameCollisions=[];
		this._physicsUpdateList=new PhysicsUpdateList();
		this._characters=[];
		(flags===void 0)&& (flags=0);
		this.maxSubSteps=configuration.maxSubSteps;
		this.fixedTimeStep=configuration.fixedTimeStep;
		var physics3D=Laya3D._physics3D;
		this._nativeCollisionConfiguration=new physics3D.btDefaultCollisionConfiguration();
		this._nativeDispatcher=new physics3D.btCollisionDispatcher(this._nativeCollisionConfiguration);
		this._nativeBroadphase=new physics3D.btDbvtBroadphase();
		this._nativeBroadphase.getOverlappingPairCache().setInternalGhostPairCallback(new physics3D.btGhostPairCallback());
		var conFlags=configuration.flags;
		if (conFlags & 0x1){
			this._nativeCollisionWorld=new physics3D.btCollisionWorld(this._nativeDispatcher,this._nativeBroadphase,this._nativeCollisionConfiguration);
			}else if (conFlags & 0x2){
			throw "PhysicsSimulation:SoftBody processing is not yet available";
			}else {
			var solver=new physics3D.btSequentialImpulseConstraintSolver();
			this._nativeDiscreteDynamicsWorld=new physics3D.btDiscreteDynamicsWorld(this._nativeDispatcher,this._nativeBroadphase,solver,this._nativeCollisionConfiguration);
			this._nativeCollisionWorld=this._nativeDiscreteDynamicsWorld;
		}
		if (this._nativeDiscreteDynamicsWorld){
			this._nativeSolverInfo=this._nativeDiscreteDynamicsWorld.getSolverInfo();
			this._nativeDispatchInfo=this._nativeDiscreteDynamicsWorld.getDispatchInfo();
		}
		this._nativeClosestRayResultCallback=new physics3D.ClosestRayResultCallback(this._nativeVector3Zero,this._nativeVector3Zero);
		this._nativeAllHitsRayResultCallback=new physics3D.AllHitsRayResultCallback(this._nativeVector3Zero,this._nativeVector3Zero);
		this._nativeClosestConvexResultCallback=new physics3D.ClosestConvexResultCallback(this._nativeVector3Zero,this._nativeVector3Zero);
		this._nativeAllConvexResultCallback=new physics3D.AllConvexResultCallback(this._nativeVector3Zero,this._nativeVector3Zero);
		physics3D._btGImpactCollisionAlgorithm_RegisterAlgorithm(this._nativeDispatcher.a);
	}

	__class(PhysicsSimulation,'laya.d3.physics.PhysicsSimulation');
	var __proto=PhysicsSimulation.prototype;
	/**
	*@private
	*/
	__proto._simulate=function(deltaTime){
		this._updatedRigidbodies=0;
		if (this._nativeDiscreteDynamicsWorld)
			this._nativeDiscreteDynamicsWorld.stepSimulation(deltaTime,this.maxSubSteps,this.fixedTimeStep);
		else
		this._nativeCollisionWorld.PerformDiscreteCollisionDetection();
	}

	/**
	*@private
	*/
	__proto._destroy=function(){
		var physics3D=Laya3D._physics3D;
		if (this._nativeDiscreteDynamicsWorld){
			physics3D.destroy(this._nativeDiscreteDynamicsWorld);
			this._nativeDiscreteDynamicsWorld=null;
			}else {
			physics3D.destroy(this._nativeCollisionWorld);
			this._nativeCollisionWorld=null;
		}
		physics3D.destroy(this._nativeBroadphase);
		this._nativeBroadphase=null;
		physics3D.destroy(this._nativeDispatcher);
		this._nativeDispatcher=null;
		physics3D.destroy(this._nativeCollisionConfiguration);
		this._nativeCollisionConfiguration=null;
	}

	/**
	*@private
	*/
	__proto._addPhysicsCollider=function(component,group,mask){
		this._nativeCollisionWorld.addCollisionObject(component._nativeColliderObject,group,mask);
	}

	/**
	*@private
	*/
	__proto._removePhysicsCollider=function(component){
		this._nativeCollisionWorld.removeCollisionObject(component._nativeColliderObject);
	}

	/**
	*@private
	*/
	__proto._addRigidBody=function(rigidBody,group,mask){
		if (!this._nativeDiscreteDynamicsWorld)
			throw "Simulation:Cannot perform this action when the physics engine is set to CollisionsOnly";
		this._nativeCollisionWorld.addRigidBody(rigidBody._nativeColliderObject,group,mask);
	}

	/**
	*@private
	*/
	__proto._removeRigidBody=function(rigidBody){
		if (!this._nativeDiscreteDynamicsWorld)
			throw "Simulation:Cannot perform this action when the physics engine is set to CollisionsOnly";
		this._nativeCollisionWorld.removeRigidBody(rigidBody._nativeColliderObject);
	}

	/**
	*@private
	*/
	__proto._addCharacter=function(character,group,mask){
		if (!this._nativeDiscreteDynamicsWorld)
			throw "Simulation:Cannot perform this action when the physics engine is set to CollisionsOnly";
		this._nativeCollisionWorld.addCollisionObject(character._nativeColliderObject,group,mask);
		this._nativeCollisionWorld.addAction(character._nativeKinematicCharacter);
	}

	/**
	*@private
	*/
	__proto._removeCharacter=function(character){
		if (!this._nativeDiscreteDynamicsWorld)
			throw "Simulation:Cannot perform this action when the physics engine is set to CollisionsOnly";
		this._nativeCollisionWorld.removeCollisionObject(character._nativeColliderObject);
		this._nativeCollisionWorld.removeAction(character._nativeKinematicCharacter);
	}

	/**
	*射线检测第一个碰撞物体。
	*@param from 起始位置。
	*@param to 结束位置。
	*@param out 碰撞结果。
	*@param collisonGroup 射线所属碰撞组。
	*@param collisionMask 与射线可产生碰撞的组。
	*@return 是否成功。
	*/
	__proto.raycastFromTo=function(from,to,out,collisonGroup,collisionMask){
		(collisonGroup===void 0)&& (collisonGroup=Physics3DUtils.COLLISIONFILTERGROUP_ALLFILTER);
		(collisionMask===void 0)&& (collisionMask=Physics3DUtils.COLLISIONFILTERGROUP_ALLFILTER);
		var rayResultCall=this._nativeClosestRayResultCallback;
		var rayFrom=PhysicsSimulation._nativeTempVector30;
		var rayTo=PhysicsSimulation._nativeTempVector31;
		rayFrom.setValue(-from.x,from.y,from.z);
		rayTo.setValue(-to.x,to.y,to.z);
		rayResultCall.set_m_rayFromWorld(rayFrom);
		rayResultCall.set_m_rayToWorld(rayTo);
		rayResultCall.set_m_collisionFilterGroup(collisonGroup);
		rayResultCall.set_m_collisionFilterMask(collisionMask);
		rayResultCall.set_m_collisionObject(null);
		rayResultCall.set_m_closestHitFraction(1);
		this._nativeCollisionWorld.rayTest(rayFrom,rayTo,rayResultCall);
		if (rayResultCall.hasHit()){
			if (out){
				out.succeeded=true;
				out.collider=PhysicsComponent._physicObjectsMap[rayResultCall.get_m_collisionObject().getUserIndex()];
				out.hitFraction=rayResultCall.get_m_closestHitFraction();
				var nativePoint=rayResultCall.get_m_hitPointWorld();
				var point=out.point;
				point.x=-nativePoint.x();
				point.y=nativePoint.y();
				point.z=nativePoint.z();
				var nativeNormal=rayResultCall.get_m_hitNormalWorld();
				var normal=out.normal;
				normal.x=-nativeNormal.x();
				normal.y=nativeNormal.y();
				normal.z=nativeNormal.z();
			}
			return true;
			}else {
			if (out)
				out.succeeded=false;
			return false;
		}
	}

	/**
	*射线检测所有碰撞的物体。
	*@param from 起始位置。
	*@param to 结束位置。
	*@param out 碰撞结果[数组元素会被回收]。
	*@param collisonGroup 射线所属碰撞组。
	*@param collisionMask 与射线可产生碰撞的组。
	*@return 是否成功。
	*/
	__proto.raycastAllFromTo=function(from,to,out,collisonGroup,collisionMask){
		(collisonGroup===void 0)&& (collisonGroup=Physics3DUtils.COLLISIONFILTERGROUP_ALLFILTER);
		(collisionMask===void 0)&& (collisionMask=Physics3DUtils.COLLISIONFILTERGROUP_ALLFILTER);
		var rayResultCall=this._nativeAllHitsRayResultCallback;
		var rayFrom=PhysicsSimulation._nativeTempVector30;
		var rayTo=PhysicsSimulation._nativeTempVector31;
		out.length=0;
		rayFrom.setValue(-from.x,from.y,from.z);
		rayTo.setValue(-to.x,to.y,to.z);
		rayResultCall.set_m_rayFromWorld(rayFrom);
		rayResultCall.set_m_rayToWorld(rayTo);
		rayResultCall.set_m_collisionFilterGroup(collisonGroup);
		rayResultCall.set_m_collisionFilterMask(collisionMask);
		var collisionObjects=rayResultCall.get_m_collisionObjects();
		var nativePoints=rayResultCall.get_m_hitPointWorld();
		var nativeNormals=rayResultCall.get_m_hitNormalWorld();
		var nativeFractions=rayResultCall.get_m_hitFractions();
		collisionObjects.clear();
		nativePoints.clear();
		nativeNormals.clear();
		nativeFractions.clear();
		this._nativeCollisionWorld.rayTest(rayFrom,rayTo,rayResultCall);
		var count=collisionObjects.size();
		if (count > 0){
			this._collisionsUtils.recoverAllHitResultsPool();
			for (var i=0;i < count;i++){
				var hitResult=this._collisionsUtils.getHitResult();
				out.push(hitResult);
				hitResult.succeeded=true;
				hitResult.collider=PhysicsComponent._physicObjectsMap[collisionObjects.at(i).getUserIndex()];
				hitResult.hitFraction=nativeFractions.at(i);
				var nativePoint=nativePoints.at(i);
				var pointE=hitResult.point;
				pointE.x=-nativePoint.x();
				pointE.y=nativePoint.y();
				pointE.z=nativePoint.z();
				var nativeNormal=nativeNormals.at(i);
				var normalE=hitResult.normal;
				normalE.x=-nativeNormal.x();
				normalE.y=nativeNormal.y();
				normalE.z=nativeNormal.z();
			}
			return true;
			}else {
			return false;
		}
	}

	/**
	*射线检测第一个碰撞物体。
	*@param ray 射线
	*@param outHitInfo 与该射线发生碰撞的第一个碰撞器的碰撞信息
	*@param distance 射线长度,默认为最大值
	*@param collisonGroup 射线所属碰撞组。
	*@param collisionMask 与射线可产生碰撞的组。
	*@return 是否检测成功。
	*/
	__proto.rayCast=function(ray,outHitResult,distance,collisonGroup,collisionMask){
		(distance===void 0)&& (distance=2147483647);
		(collisonGroup===void 0)&& (collisonGroup=Physics3DUtils.COLLISIONFILTERGROUP_ALLFILTER);
		(collisionMask===void 0)&& (collisionMask=Physics3DUtils.COLLISIONFILTERGROUP_ALLFILTER);
		var from=ray.origin;
		var to=PhysicsSimulation._tempVector30;
		Vector3.normalize(ray.direction,to);
		Vector3.scale(to,distance,to);
		Vector3.add(from,to,to);
		return this.raycastFromTo(from,to,outHitResult,collisonGroup,collisionMask);
	}

	/**
	*射线检测所有碰撞的物体。
	*@param ray 射线
	*@param out 碰撞结果[数组元素会被回收]。
	*@param distance 射线长度,默认为最大值
	*@param collisonGroup 射线所属碰撞组。
	*@param collisionMask 与射线可产生碰撞的组。
	*@return 是否检测成功。
	*/
	__proto.rayCastAll=function(ray,out,distance,collisonGroup,collisionMask){
		(distance===void 0)&& (distance=2147483647);
		(collisonGroup===void 0)&& (collisonGroup=Physics3DUtils.COLLISIONFILTERGROUP_ALLFILTER);
		(collisionMask===void 0)&& (collisionMask=Physics3DUtils.COLLISIONFILTERGROUP_ALLFILTER);
		var from=ray.origin;
		var to=PhysicsSimulation._tempVector30;
		Vector3.normalize(ray.direction,to);
		Vector3.scale(to,distance,to);
		Vector3.add(from,to,to);
		return this.raycastAllFromTo(from,to,out,collisonGroup,collisionMask);
	}

	/**
	*形状检测第一个碰撞的物体。
	*@param shape 形状。
	*@param fromPosition 世界空间起始位置。
	*@param toPosition 世界空间结束位置。
	*@param out 碰撞结果。
	*@param fromRotation 起始旋转。
	*@param toRotation 结束旋转。
	*@param collisonGroup 射线所属碰撞组。
	*@param collisionMask 与射线可产生碰撞的组。
	*@return 是否成功。
	*/
	__proto.shapeCast=function(shape,fromPosition,toPosition,out,fromRotation,toRotation,collisonGroup,collisionMask,allowedCcdPenetration){
		(collisonGroup===void 0)&& (collisonGroup=Physics3DUtils.COLLISIONFILTERGROUP_ALLFILTER);
		(collisionMask===void 0)&& (collisionMask=Physics3DUtils.COLLISIONFILTERGROUP_ALLFILTER);
		(allowedCcdPenetration===void 0)&& (allowedCcdPenetration=0.0);
		var convexResultCall=this._nativeClosestConvexResultCallback;
		var convexPosFrom=PhysicsSimulation._nativeTempVector30;
		var convexPosTo=PhysicsSimulation._nativeTempVector31;
		var convexRotFrom=PhysicsSimulation._nativeTempQuaternion0;
		var convexRotTo=PhysicsSimulation._nativeTempQuaternion1;
		var convexTransform=PhysicsSimulation._nativeTempTransform0;
		var convexTransTo=PhysicsSimulation._nativeTempTransform1;
		var sweepShape=shape._nativeShape;
		convexPosFrom.setValue(-fromPosition.x,fromPosition.y,fromPosition.z);
		convexPosTo.setValue(-toPosition.x,toPosition.y,toPosition.z);
		convexResultCall.set_m_collisionFilterGroup(collisonGroup);
		convexResultCall.set_m_collisionFilterMask(collisionMask);
		convexTransform.setOrigin(convexPosFrom);
		convexTransTo.setOrigin(convexPosTo);
		if (fromRotation){
			convexRotFrom.setValue(-fromRotation.x,fromRotation.y,fromRotation.z,-fromRotation.w);
			convexTransform.setRotation(convexRotFrom);
			}else {
			convexTransform.setRotation(this._nativeDefaultQuaternion);
		}
		if (toRotation){
			convexRotTo.setValue(-toRotation.x,toRotation.y,toRotation.z,-toRotation.w);
			convexTransTo.setRotation(convexRotTo);
			}else {
			convexTransTo.setRotation(this._nativeDefaultQuaternion);
		}
		convexResultCall.set_m_hitCollisionObject(null);
		convexResultCall.set_m_closestHitFraction(1);
		this._nativeCollisionWorld.convexSweepTest(sweepShape,convexTransform,convexTransTo,convexResultCall,allowedCcdPenetration);
		if (convexResultCall.hasHit()){
			if (out){
				out.succeeded=true;
				out.collider=PhysicsComponent._physicObjectsMap[convexResultCall.get_m_hitCollisionObject().getUserIndex()];
				out.hitFraction=convexResultCall.get_m_closestHitFraction();
				var nativePoint=convexResultCall.get_m_hitPointWorld();
				var nativeNormal=convexResultCall.get_m_hitNormalWorld();
				var point=out.point;
				var normal=out.normal;
				point.x=-nativePoint.x();
				point.y=nativePoint.y();
				point.z=nativePoint.z();
				normal.x=-nativeNormal.x();
				normal.y=nativeNormal.y();
				normal.z=nativeNormal.z();
			}
			return true;
			}else {
			if (out)
				out.succeeded=false;
			return false;
		}
	}

	/**
	*形状检测所有碰撞的物体。
	*@param shape 形状。
	*@param fromPosition 世界空间起始位置。
	*@param toPosition 世界空间结束位置。
	*@param out 碰撞结果[数组元素会被回收]。
	*@param fromRotation 起始旋转。
	*@param toRotation 结束旋转。
	*@param collisonGroup 射线所属碰撞组。
	*@param collisionMask 与射线可产生碰撞的组。
	*@return 是否成功。
	*/
	__proto.shapeCastAll=function(shape,fromPosition,toPosition,out,fromRotation,toRotation,collisonGroup,collisionMask,allowedCcdPenetration){
		(collisonGroup===void 0)&& (collisonGroup=Physics3DUtils.COLLISIONFILTERGROUP_ALLFILTER);
		(collisionMask===void 0)&& (collisionMask=Physics3DUtils.COLLISIONFILTERGROUP_ALLFILTER);
		(allowedCcdPenetration===void 0)&& (allowedCcdPenetration=0.0);
		var convexResultCall=this._nativeAllConvexResultCallback;
		var convexPosFrom=PhysicsSimulation._nativeTempVector30;
		var convexPosTo=PhysicsSimulation._nativeTempVector31;
		var convexRotFrom=PhysicsSimulation._nativeTempQuaternion0;
		var convexRotTo=PhysicsSimulation._nativeTempQuaternion1;
		var convexTransform=PhysicsSimulation._nativeTempTransform0;
		var convexTransTo=PhysicsSimulation._nativeTempTransform1;
		var sweepShape=shape._nativeShape;
		out.length=0;
		convexPosFrom.setValue(-fromPosition.x,fromPosition.y,fromPosition.z);
		convexPosTo.setValue(-toPosition.x,toPosition.y,toPosition.z);
		convexResultCall.set_m_collisionFilterGroup(collisonGroup);
		convexResultCall.set_m_collisionFilterMask(collisionMask);
		convexTransform.setOrigin(convexPosFrom);
		convexTransTo.setOrigin(convexPosTo);
		if (fromRotation){
			convexRotFrom.setValue(-fromRotation.x,fromRotation.y,fromRotation.z,-fromRotation.w);
			convexTransform.setRotation(convexRotFrom);
			}else {
			convexTransform.setRotation(this._nativeDefaultQuaternion);
		}
		if (toRotation){
			convexRotTo.setValue(-toRotation.x,toRotation.y,toRotation.z,-toRotation.w);
			convexTransTo.setRotation(convexRotTo);
			}else {
			convexTransTo.setRotation(this._nativeDefaultQuaternion);
		};
		var collisionObjects=convexResultCall.get_m_collisionObjects();
		collisionObjects.clear();
		this._nativeCollisionWorld.convexSweepTest(sweepShape,convexTransform,convexTransTo,convexResultCall,allowedCcdPenetration);
		var count=collisionObjects.size();
		if (count > 0){
			var nativePoints=convexResultCall.get_m_hitPointWorld();
			var nativeNormals=convexResultCall.get_m_hitNormalWorld();
			var nativeFractions=convexResultCall.get_m_hitFractions();
			for (var i=0;i < count;i++){
				var hitResult=this._collisionsUtils.getHitResult();
				out.push(hitResult);
				hitResult.succeeded=true;
				hitResult.collider=PhysicsComponent._physicObjectsMap[collisionObjects.at(i).getUserIndex()];
				hitResult.hitFraction=nativeFractions.at(i);
				var nativePoint=nativePoints.at(i);
				var point=hitResult.point;
				point.x=-nativePoint.x();
				point.y=nativePoint.y();
				point.z=nativePoint.z();
				var nativeNormal=nativeNormals.at(i);
				var normal=hitResult.normal;
				normal.x=-nativeNormal.x();
				normal.y=nativeNormal.y();
				normal.z=nativeNormal.z();
			}
			return true;
			}else {
			return false;
		}
	}

	/**
	*添加刚体运动的约束条件。
	*@param constraint 约束。
	*@param disableCollisionsBetweenLinkedBodies 是否禁用
	*/
	__proto.addConstraint=function(constraint,disableCollisionsBetweenLinkedBodies){
		(disableCollisionsBetweenLinkedBodies===void 0)&& (disableCollisionsBetweenLinkedBodies=false);
		if (!this._nativeDiscreteDynamicsWorld)
			throw "Cannot perform this action when the physics engine is set to CollisionsOnly";
		this._nativeDiscreteDynamicsWorld.addConstraint(constraint._nativeConstraint,disableCollisionsBetweenLinkedBodies);
		constraint._simulation=this;
	}

	/**
	*移除刚体运动的约束条件。
	*/
	__proto.removeConstraint=function(constraint){
		if (!this._nativeDiscreteDynamicsWorld)
			throw "Cannot perform this action when the physics engine is set to CollisionsOnly";
		this._nativeDiscreteDynamicsWorld.removeConstraint(constraint._nativeConstraint);
	}

	/**
	*@private
	*/
	__proto._updatePhysicsTransformFromRender=function(){
		var elements=this._physicsUpdateList.elements;
		for (var i=0,n=this._physicsUpdateList.length;i < n;i++){
			var physicCollider=elements[i];
			physicCollider._derivePhysicsTransformation(false);
			physicCollider._inPhysicUpdateListIndex=-1;
		}
		this._physicsUpdateList.length=0;
	}

	/**
	*@private
	*/
	__proto._updateCharacters=function(){
		for (var i=0,n=this._characters.length;i < n;i++){
			var character=this._characters[i];
			character._updateTransformComponent(character._nativeColliderObject.getWorldTransform());
		}
	}

	/**
	*@private
	*/
	__proto._updateCollisions=function(){
		this._collisionsUtils.recoverAllContactPointsPool();
		var previous=this._currentFrameCollisions;
		this._currentFrameCollisions=this._previousFrameCollisions;
		this._currentFrameCollisions.length=0;
		this._previousFrameCollisions=previous;
		var loopCount=Stat.loopCount;
		var numManifolds=this._nativeDispatcher.getNumManifolds();
		for (var i=0;i < numManifolds;i++){
			var contactManifold=this._nativeDispatcher.getManifoldByIndexInternal(i);
			var componentA=PhysicsComponent._physicObjectsMap[contactManifold.getBody0().getUserIndex()];
			var componentB=PhysicsComponent._physicObjectsMap[contactManifold.getBody1().getUserIndex()];
			var collision=null;
			var isFirstCollision=false;
			var contacts=null;
			var isTrigger=componentA.isTrigger || componentB.isTrigger;
			if (isTrigger && ((componentA.owner)._needProcessTriggers || (componentB.owner)._needProcessTriggers)){
				var numContacts=contactManifold.getNumContacts();
				for (var j=0;j < numContacts;j++){
					var pt=contactManifold.getContactPoint(j);
					var distance=pt.getDistance();
					if (distance <=0){
						collision=this._collisionsUtils.getCollision(componentA,componentB);
						contacts=collision.contacts;
						isFirstCollision=collision._updateFrame!==loopCount;
						if (isFirstCollision){
							collision._isTrigger=true;
							contacts.length=0;
						}
						break ;
					}
				}
				}else if ((componentA.owner)._needProcessCollisions || (componentB.owner)._needProcessCollisions){
				if (componentA._enableProcessCollisions || componentB._enableProcessCollisions){
					numContacts=contactManifold.getNumContacts();
					for (j=0;j < numContacts;j++){
						pt=contactManifold.getContactPoint(j);
						distance=pt.getDistance();
						if (distance <=0){
							var contactPoint=this._collisionsUtils.getContactPoints();
							contactPoint.colliderA=componentA;
							contactPoint.colliderB=componentB;
							contactPoint.distance=distance;
							var nativeNormal=pt.get_m_normalWorldOnB();
							var normal=contactPoint.normal;
							normal.x=-nativeNormal.x();
							normal.y=nativeNormal.y();
							normal.z=nativeNormal.z();
							var nativePostionA=pt.get_m_positionWorldOnA();
							var positionOnA=contactPoint.positionOnA;
							positionOnA.x=-nativePostionA.x();
							positionOnA.y=nativePostionA.y();
							positionOnA.z=nativePostionA.z();
							var nativePostionB=pt.get_m_positionWorldOnB();
							var positionOnB=contactPoint.positionOnB;
							positionOnB.x=-nativePostionB.x();
							positionOnB.y=nativePostionB.y();
							positionOnB.z=nativePostionB.z();
							if (!collision){
								collision=this._collisionsUtils.getCollision(componentA,componentB);
								contacts=collision.contacts;
								isFirstCollision=collision._updateFrame!==loopCount;
								if (isFirstCollision){
									collision._isTrigger=false;
									contacts.length=0;
								}
							}
							contacts.push(contactPoint);
						}
					}
				}
			}
			if (collision && isFirstCollision){
				this._currentFrameCollisions.push(collision);
				collision._setUpdateFrame(loopCount);
			}
		}
	}

	/**
	*@private
	*/
	__proto._eventScripts=function(){
		var loopCount=Stat.loopCount;
		for (var i=0,n=this._currentFrameCollisions.length;i < n;i++){
			var curFrameCol=this._currentFrameCollisions[i];
			var colliderA=curFrameCol._colliderA;
			var colliderB=curFrameCol._colliderB;
			if (colliderA.destroyed || colliderB.destroyed)
				continue ;
			if (loopCount-curFrameCol._lastUpdateFrame===1){
				var ownerA=colliderA.owner;
				var scriptsA=ownerA._scripts;
				if (scriptsA){
					if (curFrameCol._isTrigger){
						if (ownerA._needProcessTriggers){
							for (var j=0,m=scriptsA.length;j < m;j++)
							scriptsA[j].onTriggerStay(colliderB);
						}
						}else {
						if (ownerA._needProcessCollisions){
							for (j=0,m=scriptsA.length;j < m;j++){
								curFrameCol.other=colliderB;
								scriptsA[j].onCollisionStay(curFrameCol);
							}
						}
					}
				};
				var ownerB=colliderB.owner;
				var scriptsB=ownerB._scripts;
				if (scriptsB){
					if (curFrameCol._isTrigger){
						if (ownerB._needProcessTriggers){
							for (j=0,m=scriptsB.length;j < m;j++)
							scriptsB[j].onTriggerStay(colliderA);
						}
						}else {
						if (ownerB._needProcessCollisions){
							for (j=0,m=scriptsB.length;j < m;j++){
								curFrameCol.other=colliderA;
								scriptsB[j].onCollisionStay(curFrameCol);
							}
						}
					}
				}
				}else {
				ownerA=colliderA.owner;
				scriptsA=ownerA._scripts;
				if (scriptsA){
					if (curFrameCol._isTrigger){
						if (ownerA._needProcessTriggers){
							for (j=0,m=scriptsA.length;j < m;j++)
							scriptsA[j].onTriggerEnter(colliderB);
						}
						}else {
						if (ownerA._needProcessCollisions){
							for (j=0,m=scriptsA.length;j < m;j++){
								curFrameCol.other=colliderB;
								scriptsA[j].onCollisionEnter(curFrameCol);
							}
						}
					}
				}
				ownerB=colliderB.owner;
				scriptsB=ownerB._scripts;
				if (scriptsB){
					if (curFrameCol._isTrigger){
						if (ownerB._needProcessTriggers){
							for (j=0,m=scriptsB.length;j < m;j++)
							scriptsB[j].onTriggerEnter(colliderA);
						}
						}else {
						if (ownerB._needProcessCollisions){
							for (j=0,m=scriptsB.length;j < m;j++){
								curFrameCol.other=colliderA;
								scriptsB[j].onCollisionEnter(curFrameCol);
							}
						}
					}
				}
			}
		}
		for (i=0,n=this._previousFrameCollisions.length;i < n;i++){
			var preFrameCol=this._previousFrameCollisions[i];
			var preColliderA=preFrameCol._colliderA;
			var preColliderB=preFrameCol._colliderB;
			if (preColliderA.destroyed || preColliderB.destroyed)
				continue ;
			if (loopCount-preFrameCol._updateFrame===1){
				this._collisionsUtils.recoverCollision(preFrameCol);
				ownerA=preColliderA.owner;
				scriptsA=ownerA._scripts;
				if (scriptsA){
					if (preFrameCol._isTrigger){
						if (ownerA._needProcessTriggers){
							for (j=0,m=scriptsA.length;j < m;j++)
							scriptsA[j].onTriggerExit(preColliderB);
						}
						}else {
						if (ownerA._needProcessCollisions){
							for (j=0,m=scriptsA.length;j < m;j++){
								preFrameCol.other=preColliderB;
								scriptsA[j].onCollisionExit(preFrameCol);
							}
						}
					}
				}
				ownerB=preColliderB.owner;
				scriptsB=ownerB._scripts;
				if (scriptsB){
					if (preFrameCol._isTrigger){
						if (ownerB._needProcessTriggers){
							for (j=0,m=scriptsB.length;j < m;j++)
							scriptsB[j].onTriggerExit(preColliderA);
						}
						}else {
						if (ownerB._needProcessCollisions){
							for (j=0,m=scriptsB.length;j < m;j++){
								preFrameCol.other=preColliderA;
								scriptsB[j].onCollisionExit(preFrameCol);
							}
						}
					}
				}
			}
		}
	}

	/**
	*清除力。
	*/
	__proto.clearForces=function(){
		if (!this._nativeDiscreteDynamicsWorld)
			throw "Cannot perform this action when the physics engine is set to CollisionsOnly";
		this._nativeDiscreteDynamicsWorld.clearForces();
	}

	/**
	*设置重力。
	*/
	/**
	*获取重力。
	*/
	__getset(0,__proto,'gravity',function(){
		if (!this._nativeDiscreteDynamicsWorld)
			throw "Simulation:Cannot perform this action when the physics engine is set to CollisionsOnly";
		return this._gravity;
		},function(value){
		if (!this._nativeDiscreteDynamicsWorld)
			throw "Simulation:Cannot perform this action when the physics engine is set to CollisionsOnly";
		this._gravity=value;
		var nativeGravity=PhysicsSimulation._nativeTempVector30;
		nativeGravity.setValue(-value.x,value.y,value.z);
		this._nativeDiscreteDynamicsWorld.setGravity(nativeGravity);
	});

	/**
	*设置是否进行连续碰撞检测。
	*@param value 是否进行连续碰撞检测。
	*/
	/**
	*获取是否进行连续碰撞检测。
	*@return 是否进行连续碰撞检测。
	*/
	__getset(0,__proto,'continuousCollisionDetection',function(){
		return this._nativeDispatchInfo.get_m_useContinuous();
		},function(value){
		this._nativeDispatchInfo.set_m_useContinuous(value);
	});

	/**
	*@private
	*/
	/**
	*@private
	*/
	__getset(0,__proto,'speculativeContactRestitution',function(){
		if (!this._nativeDiscreteDynamicsWorld)
			throw "Simulation:Cannot Cannot perform this action when the physics engine is set to CollisionsOnly";
		return this._nativeDiscreteDynamicsWorld.getApplySpeculativeContactRestitution();
		},function(value){
		if (!this._nativeDiscreteDynamicsWorld)
			throw "Simulation:Cannot Cannot perform this action when the physics engine is set to CollisionsOnly";
		this._nativeDiscreteDynamicsWorld.setApplySpeculativeContactRestitution(value);
	});

	PhysicsSimulation.createConstraint=function(){}
	PhysicsSimulation.PHYSICSENGINEFLAGS_NONE=0x0;
	PhysicsSimulation.PHYSICSENGINEFLAGS_COLLISIONSONLY=0x1;
	PhysicsSimulation.PHYSICSENGINEFLAGS_SOFTBODYSUPPORT=0x2;
	PhysicsSimulation.PHYSICSENGINEFLAGS_MULTITHREADED=0x4;
	PhysicsSimulation.PHYSICSENGINEFLAGS_USEHARDWAREWHENPOSSIBLE=0x8;
	PhysicsSimulation.SOLVERMODE_RANDMIZE_ORDER=1;
	PhysicsSimulation.SOLVERMODE_FRICTION_SEPARATE=2;
	PhysicsSimulation.SOLVERMODE_USE_WARMSTARTING=4;
	PhysicsSimulation.SOLVERMODE_USE_2_FRICTION_DIRECTIONS=16;
	PhysicsSimulation.SOLVERMODE_ENABLE_FRICTION_DIRECTION_CACHING=32;
	PhysicsSimulation.SOLVERMODE_DISABLE_VELOCITY_DEPENDENT_FRICTION_DIRECTION=64;
	PhysicsSimulation.SOLVERMODE_CACHE_FRIENDLY=128;
	PhysicsSimulation.SOLVERMODE_SIMD=256;
	PhysicsSimulation.SOLVERMODE_INTERLEAVE_CONTACT_AND_FRICTION_CONSTRAINTS=512;
	PhysicsSimulation.SOLVERMODE_ALLOW_ZERO_LENGTH_FRICTION_DIRECTIONS=1024;
	PhysicsSimulation.disableSimulation=false;
	__static(PhysicsSimulation,
	['_nativeTempVector30',function(){return this._nativeTempVector30=new Laya3D._physics3D.btVector3(0,0,0);},'_nativeTempVector31',function(){return this._nativeTempVector31=new Laya3D._physics3D.btVector3(0,0,0);},'_nativeTempQuaternion0',function(){return this._nativeTempQuaternion0=new Laya3D._physics3D.btQuaternion(0,0,0,1);},'_nativeTempQuaternion1',function(){return this._nativeTempQuaternion1=new Laya3D._physics3D.btQuaternion(0,0,0,1);},'_nativeTempTransform0',function(){return this._nativeTempTransform0=new Laya3D._physics3D.btTransform();},'_nativeTempTransform1',function(){return this._nativeTempTransform1=new Laya3D._physics3D.btTransform();},'_tempVector30',function(){return this._tempVector30=new Vector3();}
	]);
	return PhysicsSimulation;
})()


/**
*<code>PhysicsComponent</code> 类用于创建物理组件的父类。
*/
//class laya.d3.physics.PhysicsComponent extends laya.components.Component
var PhysicsComponent=(function(_super){
	function PhysicsComponent(collisionGroup,canCollideWith){
		/**@private */
		this._restitution=0.0;
		/**@private */
		this._friction=0.5;
		/**@private */
		this._rollingFriction=0.0;
		/**@private */
		this._ccdMotionThreshold=0.0;
		/**@private */
		this._ccdSweptSphereRadius=0.0;
		/**@private */
		this._colliderShape=null;
		/**@private */
		this._transformFlag=2147483647;
		/**@private */
		//this._nativeColliderObject=null;
		/**@private */
		//this._simulation=null;
		/**@private */
		this._enableProcessCollisions=true;
		/**@private */
		this._inPhysicUpdateListIndex=-1;
		/**是否可以缩放Shape。 */
		this.canScaleShape=true;
		PhysicsComponent.__super.call(this);
		this._collisionGroup=/*laya.d3.utils.Physics3DUtils.COLLISIONFILTERGROUP_DEFAULTFILTER*/0x1;
		this._canCollideWith=Physics3DUtils.COLLISIONFILTERGROUP_ALLFILTER;
		this._collisionGroup=collisionGroup;
		this._canCollideWith=canCollideWith;
		PhysicsComponent._physicObjectsMap[this.id]=this;
	}

	__class(PhysicsComponent,'laya.d3.physics.PhysicsComponent',_super);
	var __proto=PhysicsComponent.prototype;
	/**
	*@private
	*/
	__proto._isValid=function(){
		return this._simulation && this._colliderShape && this._enabled;
	}

	/**
	*@inheritDoc
	*/
	__proto._parse=function(data){
		(data.collisionGroup !=null)&& (this.collisionGroup=data.collisionGroup);
		(data.canCollideWith !=null)&& (this.canCollideWith=data.canCollideWith);
		(data.ccdMotionThreshold !=null)&& (this.ccdMotionThreshold=data.ccdMotionThreshold);
		(data.ccdSweptSphereRadius !=null)&& (this.ccdSweptSphereRadius=data.ccdSweptSphereRadius);
	}

	/**
	*@private
	*/
	__proto._parseShape=function(shapesData){
		var shapeCount=shapesData.length;
		if (shapeCount===1){
			var shape=ColliderShape._creatShape(shapesData[0]);
			this.colliderShape=shape;
			}else {
			var compoundShape=new CompoundColliderShape();
			for (var i=0;i < shapeCount;i++){
				shape=ColliderShape._creatShape(shapesData[i]);
				compoundShape.addChildShape(shape);
			}
			this.colliderShape=compoundShape;
		}
	}

	/**
	*@private
	*/
	__proto._onScaleChange=function(scale){
		this._colliderShape._setScale(scale);
	}

	/**
	*@private
	*/
	__proto._setTransformFlag=function(type,value){
		if (value)
			this._transformFlag |=type;
		else
		this._transformFlag &=~type;
	}

	/**
	*@private
	*/
	__proto._getTransformFlag=function(type){
		return (this._transformFlag & type)!=0;
	}

	/**
	*@private
	*/
	__proto._addToSimulation=function(){}
	/**
	*@private
	*/
	__proto._removeFromSimulation=function(){}
	/**
	*@private
	*/
	__proto._derivePhysicsTransformation=function(force){
		this._innerDerivePhysicsTransformation(this._nativeColliderObject.getWorldTransform(),force);
	}

	/**
	*@private
	*通过渲染矩阵更新物理矩阵。
	*/
	__proto._innerDerivePhysicsTransformation=function(physicTransformOut,force){
		var transform=(this.owner)._transform;
		var rotation=transform.rotation;
		if (force || this._getTransformFlag(/*laya.d3.core.Transform3D.TRANSFORM_WORLDPOSITION*/0x08)){
			var shapeOffset=this._colliderShape.localOffset;
			var position=transform.position;
			var nativePosition=PhysicsComponent._nativeVector30;
			if (shapeOffset.x!==0 || shapeOffset.y!==0 || shapeOffset.z!==0){
				var physicPosition=PhysicsComponent._tempVector30;
				PhysicsComponent.physicVector3TransformQuat(shapeOffset,rotation.x,rotation.y,rotation.z,rotation.w,physicPosition);
				Vector3.add(position,physicPosition,physicPosition);
				nativePosition.setValue(-physicPosition.x,physicPosition.y,physicPosition.z);
				}else {
				nativePosition.setValue(-position.x,position.y,position.z);
			}
			physicTransformOut.setOrigin(nativePosition);
			this._setTransformFlag(/*laya.d3.core.Transform3D.TRANSFORM_WORLDPOSITION*/0x08,false);
		}
		if (force || this._getTransformFlag(/*laya.d3.core.Transform3D.TRANSFORM_WORLDQUATERNION*/0x10)){
			var shapeRotation=this._colliderShape.localRotation;
			var nativeRotation=PhysicsComponent._nativeQuaternion0;
			if (shapeRotation.x!==0 || shapeRotation.y!==0 || shapeRotation.z!==0 || shapeRotation.w!==1){
				var physicRotation=PhysicsComponent._tempQuaternion0;
				PhysicsComponent.physicQuaternionMultiply(rotation.x,rotation.y,rotation.z,rotation.w,shapeRotation,physicRotation);
				nativeRotation.setValue(-physicRotation.x,physicRotation.y,physicRotation.z,-physicRotation.w);
				}else {
				nativeRotation.setValue(-rotation.x,rotation.y,rotation.z,-rotation.w);
			}
			physicTransformOut.setRotation(nativeRotation);
			this._setTransformFlag(/*laya.d3.core.Transform3D.TRANSFORM_WORLDQUATERNION*/0x10,false);
		}
		if (force || this._getTransformFlag(/*laya.d3.core.Transform3D.TRANSFORM_WORLDSCALE*/0x20)){
			this._onScaleChange(transform.scale);
			this._setTransformFlag(/*laya.d3.core.Transform3D.TRANSFORM_WORLDSCALE*/0x20,false);
		}
	}

	/**
	*@private
	*通过物理矩阵更新渲染矩阵。
	*/
	__proto._updateTransformComponent=function(physicsTransform){
		var localOffset=this._colliderShape.localOffset;
		var localRotation=this._colliderShape.localRotation;
		var transform=(this.owner)._transform;
		var position=transform.position;
		var rotation=transform.rotation;
		var nativePosition=physicsTransform.getOrigin();
		var nativeRotation=physicsTransform.getRotation();
		var nativeRotX=-nativeRotation.x();
		var nativeRotY=nativeRotation.y();
		var nativeRotZ=nativeRotation.z();
		var nativeRotW=-nativeRotation.w();
		if (localOffset.x!==0 || localOffset.y!==0 || localOffset.z!==0){
			var rotShapePosition=PhysicsComponent._tempVector30;
			PhysicsComponent.physicVector3TransformQuat(localOffset,nativeRotX,nativeRotY,nativeRotZ,nativeRotW,rotShapePosition);
			position.x=-nativePosition.x()-rotShapePosition.x;
			position.y=nativePosition.y()-rotShapePosition.y;
			position.z=nativePosition.z()-rotShapePosition.z;
			}else {
			position.x=-nativePosition.x();
			position.y=nativePosition.y();
			position.z=nativePosition.z();
		}
		transform.position=position;
		if (localRotation.x!==0 || localRotation.y!==0 || localRotation.z!==0 || localRotation.w!==1){
			var invertShapeRotaion=PhysicsComponent._tempQuaternion0;
			localRotation.invert(invertShapeRotaion);
			PhysicsComponent.physicQuaternionMultiply(nativeRotX,nativeRotY,nativeRotZ,nativeRotW,invertShapeRotaion,rotation);
			}else {
			rotation.x=nativeRotX;
			rotation.y=nativeRotY;
			rotation.z=nativeRotZ;
			rotation.w=nativeRotW;
		}
		transform.rotation=rotation;
	}

	/**
	*@inheritDoc
	*/
	__proto._onEnable=function(){
		this._simulation=(this.owner._scene).physicsSimulation;
		this._nativeColliderObject.setContactProcessingThreshold(1e30);
		if (this._colliderShape && this._enabled){
			this._derivePhysicsTransformation(true);
			this._addToSimulation();
		}
	}

	/**
	*@inheritDoc
	*/
	__proto._onDisable=function(){
		if (this._colliderShape && this._enabled){
			this._removeFromSimulation();
			(this._inPhysicUpdateListIndex!==-1)&& (this._simulation._physicsUpdateList.remove(this));
		}
		this._simulation=null;
	}

	/**
	*@private
	*/
	__proto._onShapeChange=function(colShape){
		var btColObj=this._nativeColliderObject;
		var flags=btColObj.getCollisionFlags();
		if (colShape.needsCustomCollisionCallback){
			if ((flags & 8)===0)
				btColObj.setCollisionFlags(flags | 8);
			}else {
			if ((flags & 8)> 0)
				btColObj.setCollisionFlags(flags ^ 8);
		}
	}

	/**
	*@inheritDoc
	*/
	__proto._onAdded=function(){
		this.enabled=this._enabled;
		this.restitution=this._restitution;
		this.friction=this._friction;
		this.rollingFriction=this._rollingFriction;
		this.ccdMotionThreshold=this._ccdMotionThreshold;
		this.ccdSweptSphereRadius=this._ccdSweptSphereRadius;
		(this.owner).transform.on(/*laya.events.Event.TRANSFORM_CHANGED*/"transformchanged",this,this._onTransformChanged);
	}

	/**
	*@inheritDoc
	*/
	__proto._onDestroy=function(){
		var physics3D=Laya3D._physics3D;
		delete PhysicsComponent._physicObjectsMap[this.id];
		physics3D.destroy(this._nativeColliderObject);
		this._colliderShape.destroy();
		_super.prototype._onDestroy.call(this);
		this._nativeColliderObject=null;
		this._colliderShape=null;
		this._simulation=null;
		(this.owner).transform.off(/*laya.events.Event.TRANSFORM_CHANGED*/"transformchanged",this,this._onTransformChanged);
	}

	/**
	*@private
	*/
	__proto._onTransformChanged=function(flag){
		if (PhysicsComponent._addUpdateList){
			flag &=/*laya.d3.core.Transform3D.TRANSFORM_WORLDPOSITION*/0x08 | /*laya.d3.core.Transform3D.TRANSFORM_WORLDQUATERNION*/0x10 | /*laya.d3.core.Transform3D.TRANSFORM_WORLDSCALE*/0x20;
			if (flag){
				this._transformFlag |=flag;
				if (this._isValid()&& this._inPhysicUpdateListIndex===-1)
					this._simulation._physicsUpdateList.add(this);
			}
		}
	}

	/**
	*@inheritDoc
	*/
	__proto._cloneTo=function(dest){
		var destPhysicsComponent=dest;
		destPhysicsComponent.restitution=this._restitution;
		destPhysicsComponent.friction=this._friction;
		destPhysicsComponent.rollingFriction=this._rollingFriction;
		destPhysicsComponent.ccdMotionThreshold=this._ccdMotionThreshold;
		destPhysicsComponent.ccdSweptSphereRadius=this._ccdSweptSphereRadius;
		destPhysicsComponent.collisionGroup=this._collisionGroup;
		destPhysicsComponent.canCollideWith=this._canCollideWith;
		destPhysicsComponent.canScaleShape=this.canScaleShape;
		(this._colliderShape)&& (destPhysicsComponent.colliderShape=this._colliderShape.clone());
	}

	/**
	*获取是否激活。
	*/
	__getset(0,__proto,'isActive',function(){
		return this._nativeColliderObject ? this._nativeColliderObject.isActive():false;
	});

	/**
	*设置弹力。
	*@param 弹力。
	*/
	/**
	*获取弹力。
	*@return 弹力。
	*/
	__getset(0,__proto,'restitution',function(){
		return this._restitution;
		},function(value){
		this._restitution=value;
		this._nativeColliderObject && this._nativeColliderObject.setRestitution(value);
	});

	/**
	*设置摩擦力。
	*@param value 摩擦力。
	*/
	/**
	*获取摩擦力。
	*@return 摩擦力。
	*/
	__getset(0,__proto,'friction',function(){
		return this._friction;
		},function(value){
		this._friction=value;
		this._nativeColliderObject && this._nativeColliderObject.setFriction(value);
	});

	/**
	*设置滚动摩擦力。
	*@param 滚动摩擦力。
	*/
	/**
	*获取滚动摩擦力。
	*@return 滚动摩擦力。
	*/
	__getset(0,__proto,'rollingFriction',function(){
		return this._nativeColliderObject.getRollingFriction();
		},function(value){
		this._rollingFriction=value;
		this._nativeColliderObject && this._nativeColliderObject.setRollingFriction(value);
	});

	/**
	*设置用于连续碰撞检测(CCD)的速度阈值，当物体移动速度小于该值时不进行CCD检测,防止快速移动物体(例如:子弹)错误的穿过其它物体,0表示禁止。
	*@param value 连续碰撞检测(CCD)的速度阈值。
	*/
	/**
	*获取用于连续碰撞检测(CCD)的速度阈值,当物体移动速度小于该值时不进行CCD检测,防止快速移动物体(例如:子弹)错误的穿过其它物体,0表示禁止。
	*@return 连续碰撞检测(CCD)的速度阈值。
	*/
	__getset(0,__proto,'ccdMotionThreshold',function(){
		return this._ccdMotionThreshold;
		},function(value){
		this._ccdMotionThreshold=value;
		this._nativeColliderObject && this._nativeColliderObject.setCcdMotionThreshold(value);
	});

	/**
	*设置用于进入连续碰撞检测(CCD)范围的球半径。
	*@param 球半径。
	*/
	/**
	*获取用于进入连续碰撞检测(CCD)范围的球半径。
	*@return 球半径。
	*/
	__getset(0,__proto,'ccdSweptSphereRadius',function(){
		return this._ccdSweptSphereRadius;
		},function(value){
		this._ccdSweptSphereRadius=value;
		this._nativeColliderObject && this._nativeColliderObject.setCcdSweptSphereRadius(value);
	});

	/**
	*设置所属碰撞组。
	*@param 所属碰撞组。
	*/
	/**
	*获取所属碰撞组。
	*@return 所属碰撞组。
	*/
	__getset(0,__proto,'collisionGroup',function(){
		return this._collisionGroup;
		},function(value){
		if (this._collisionGroup!==value){
			this._collisionGroup=value;
			if (this._simulation && this._colliderShape && this._enabled){
				this._removeFromSimulation();
				this._addToSimulation();
			}
		}
	});

	/**
	*获取模拟器。
	*@return 模拟器。
	*/
	__getset(0,__proto,'simulation',function(){
		return this._simulation;
	});

	/**
	*设置碰撞形状。
	*/
	/**
	*获取碰撞形状。
	*/
	__getset(0,__proto,'colliderShape',function(){
		return this._colliderShape;
		},function(value){
		var lastColliderShape=this._colliderShape;
		if (lastColliderShape){
			lastColliderShape._attatched=false;
			lastColliderShape._attatchedCollisionObject=null;
		}
		this._colliderShape=value;
		if (value){
			if (value._attatched){
				throw "PhysicsComponent: this shape has attatched to other entity.";
				}else {
				value._attatched=true;
				value._attatchedCollisionObject=this;
			}
			if (this._nativeColliderObject){
				this._nativeColliderObject.setCollisionShape(value._nativeShape);
				var canInSimulation=this._simulation && this._enabled;
				(canInSimulation && lastColliderShape)&& (this._removeFromSimulation());
				this._onShapeChange(value);
				if (canInSimulation){
					this._derivePhysicsTransformation(true);
					this._addToSimulation();
				}
			}
			}else {
			if (this._simulation && this._enabled)
				lastColliderShape && this._removeFromSimulation();
		}
	});

	/**
	*@inheritDoc
	*/
	__getset(0,__proto,'enabled',_super.prototype._$get_enabled,function(value){
		if (this._simulation && this._colliderShape){
			if (value){
				this._derivePhysicsTransformation(true);
				this._addToSimulation();
				}else {
				this._removeFromSimulation();
			}
		}
		Laya.superSet(Component,this,'enabled',value);
	});

	/**
	*设置可碰撞的碰撞组。
	*@param 可碰撞组。
	*/
	/**
	*获取可碰撞的碰撞组。
	*@return 可碰撞组。
	*/
	__getset(0,__proto,'canCollideWith',function(){
		return this._canCollideWith;
		},function(value){
		if (this._canCollideWith!==value){
			this._canCollideWith=value;
			if (this._simulation && this._colliderShape && this._enabled){
				this._removeFromSimulation();
				this._addToSimulation();
			}
		}
	});

	PhysicsComponent._createAffineTransformationArray=function(tranX,tranY,tranZ,rotX,rotY,rotZ,rotW,scale,outE){
		var x2=rotX+rotX,y2=rotY+rotY,z2=rotZ+rotZ;
		var xx=rotX *x2,xy=rotX *y2,xz=rotX *z2,yy=rotY *y2,yz=rotY *z2,zz=rotZ *z2;
		var wx=rotW *x2,wy=rotW *y2,wz=rotW *z2,sx=scale[0],sy=scale[1],sz=scale[2];
		outE[0]=(1-(yy+zz))*sx;
		outE[1]=(xy+wz)*sx;
		outE[2]=(xz-wy)*sx;
		outE[3]=0;
		outE[4]=(xy-wz)*sy;
		outE[5]=(1-(xx+zz))*sy;
		outE[6]=(yz+wx)*sy;
		outE[7]=0;
		outE[8]=(xz+wy)*sz;
		outE[9]=(yz-wx)*sz;
		outE[10]=(1-(xx+yy))*sz;
		outE[11]=0;
		outE[12]=tranX;
		outE[13]=tranY;
		outE[14]=tranZ;
		outE[15]=1;
	}

	PhysicsComponent.physicVector3TransformQuat=function(source,qx,qy,qz,qw,out){
		var x=source.x,y=source.y,z=source.z,
		ix=qw *x+qy *z-qz *y,iy=qw *y+qz *x-qx *z,iz=qw *z+qx *y-qy *x,iw=-qx *x-qy *y-qz *z;
		out.x=ix *qw+iw *-qx+iy *-qz-iz *-qy;
		out.y=iy *qw+iw *-qy+iz *-qx-ix *-qz;
		out.z=iz *qw+iw *-qz+ix *-qy-iy *-qx;
	}

	PhysicsComponent.physicQuaternionMultiply=function(lx,ly,lz,lw,right,out){
		var rx=right.x;
		var ry=right.y;
		var rz=right.z;
		var rw=right.w;
		var a=(ly *rz-lz *ry);
		var b=(lz *rx-lx *rz);
		var c=(lx *ry-ly *rx);
		var d=(lx *rx+ly *ry+lz *rz);
		out.x=(lx *rw+rx *lw)+a;
		out.y=(ly *rw+ry *lw)+b;
		out.z=(lz *rw+rz *lw)+c;
		out.w=lw *rw-d;
	}

	PhysicsComponent.ACTIVATIONSTATE_ACTIVE_TAG=1;
	PhysicsComponent.ACTIVATIONSTATE_ISLAND_SLEEPING=2;
	PhysicsComponent.ACTIVATIONSTATE_WANTS_DEACTIVATION=3;
	PhysicsComponent.ACTIVATIONSTATE_DISABLE_DEACTIVATION=4;
	PhysicsComponent.ACTIVATIONSTATE_DISABLE_SIMULATION=5;
	PhysicsComponent.COLLISIONFLAGS_STATIC_OBJECT=1;
	PhysicsComponent.COLLISIONFLAGS_KINEMATIC_OBJECT=2;
	PhysicsComponent.COLLISIONFLAGS_NO_CONTACT_RESPONSE=4;
	PhysicsComponent.COLLISIONFLAGS_CUSTOM_MATERIAL_CALLBACK=8;
	PhysicsComponent.COLLISIONFLAGS_CHARACTER_OBJECT=16;
	PhysicsComponent.COLLISIONFLAGS_DISABLE_VISUALIZE_OBJECT=32;
	PhysicsComponent.COLLISIONFLAGS_DISABLE_SPU_COLLISION_PROCESSING=64;
	PhysicsComponent._physicObjectsMap={};
	PhysicsComponent._addUpdateList=true;
	__static(PhysicsComponent,
	['_tempVector30',function(){return this._tempVector30=new Vector3();},'_tempQuaternion0',function(){return this._tempQuaternion0=new Quaternion();},'_tempQuaternion1',function(){return this._tempQuaternion1=new Quaternion();},'_tempMatrix4x40',function(){return this._tempMatrix4x40=new Matrix4x4();},'_nativeVector30',function(){return this._nativeVector30=new Laya3D._physics3D.btVector3(0,0,0);},'_nativeQuaternion0',function(){return this._nativeQuaternion0=new Laya3D._physics3D.btQuaternion(0,0,0,1);}
	]);
	return PhysicsComponent;
})(Component)


/**
*<code>Render</code> 类用于渲染器的父类，抽象类不允许实例。
*/
//class laya.d3.core.render.BaseRender extends laya.events.EventDispatcher
var BaseRender=(function(_super){
	function BaseRender(owner){
		/**@private */
		//this._id=0;
		/**@private */
		//this._lightmapScaleOffset=null;
		/**@private */
		//this._lightmapIndex=0;
		/**@private */
		//this._receiveShadow=false;
		/**@private */
		//this._materialsInstance=null;
		/**@private */
		//this._castShadow=false;
		/**@private [实现IListPool接口]*/
		this._indexInList=-1;
		/**@private */
		this._indexInCastShadowList=-1;
		/**@private */
		//this._bounds=null;
		/**@private */
		this._boundsChange=true;
		/**@private */
		//this._enable=false;
		/**@private */
		//this._shaderValues=null;
		/**@private */
		//this._defineDatas=null;
		/**@private */
		//this._scene=null;
		/**@private */
		//this._owner=null;
		/**@private */
		//this._renderElements=null;
		/**@private */
		//this._distanceForSort=NaN;
		/**@private */
		this._visible=true;
		/**@private */
		//this._octreeNode=null;
		/**@private */
		this._indexInOctreeMotionList=-1;
		/**@private */
		this._updateMark=-1;
		/**@private */
		this._updateRenderType=-1;
		/**@private */
		this._isPartOfStaticBatch=false;
		/**@private */
		this._staticBatch=null;
		/**排序矫正值。*/
		//this.sortingFudge=NaN;
		/**@private [NATIVE]*/
		//this._cullingBufferIndex=0;
		BaseRender.__super.call(this);
		this._sharedMaterials=[];
		this._id=++BaseRender._uniqueIDCounter;
		this._indexInCastShadowList=-1;
		this._bounds=new Bounds(Vector3._ZERO,Vector3._ZERO);
		if (Render.supportWebGLPlusCulling){
			var length=FrustumCulling._cullingBufferLength;
			this._cullingBufferIndex=length;
			var cullingBuffer=FrustumCulling._cullingBuffer;
			var resizeLength=length+7;
			if (resizeLength >=cullingBuffer.length){
				var temp=cullingBuffer;
				cullingBuffer=FrustumCulling._cullingBuffer=new Float32Array(cullingBuffer.length+4096);
				cullingBuffer.set(temp,0);
			}
			cullingBuffer[length]=2;
			FrustumCulling._cullingBufferLength=resizeLength;
		}
		this._renderElements=[];
		this._owner=owner;
		this._enable=true;
		this._materialsInstance=[];
		this._shaderValues=new ShaderData(null);
		this._defineDatas=new DefineDatas();
		this.lightmapIndex=-1;
		this._castShadow=false;
		this.receiveShadow=false;
		this.sortingFudge=0.0;
		(owner)&& (this._owner.transform.on(/*laya.events.Event.TRANSFORM_CHANGED*/"transformchanged",this,this._onWorldMatNeedChange));
	}

	__class(BaseRender,'laya.d3.core.render.BaseRender',_super);
	var __proto=BaseRender.prototype;
	Laya.imps(__proto,{"laya.resource.ISingletonElement":true,"laya.d3.core.scene.IOctreeObject":true})
	/**
	*@private
	*/
	__proto._getOctreeNode=function(){
		return this._octreeNode;
	}

	/**
	*@private
	*/
	__proto._setOctreeNode=function(value){
		this._octreeNode=value;
	}

	/**
	*@private
	*/
	__proto._getIndexInMotionList=function(){
		return this._indexInOctreeMotionList;
	}

	/**
	*@private
	*/
	__proto._setIndexInMotionList=function(value){
		this._indexInOctreeMotionList=value;
	}

	/**
	*@private
	*/
	__proto._changeMaterialReference=function(lastValue,value){
		(lastValue)&& (lastValue._removeReference());
		value._addReference();
	}

	/**
	*@private
	*/
	__proto._getInstanceMaterial=function(material,index){
		var insMat=/*__JS__ */new material.constructor();
		material.cloneTo(insMat);
		insMat.name=insMat.name+"(Instance)";
		this._materialsInstance[index]=true;
		this._changeMaterialReference(this._sharedMaterials[index],insMat);
		this._sharedMaterials[index]=insMat;
		return insMat;
	}

	/**
	*@private
	*/
	__proto._applyLightMapParams=function(){
		if (this._scene && this._lightmapIndex >=0){
			var lightMaps=this._scene.getlightmaps();
			if (this._lightmapIndex < lightMaps.length){
				this._defineDatas.add(RenderableSprite3D.SAHDERDEFINE_LIGHTMAP);
				this._shaderValues.setTexture(RenderableSprite3D.LIGHTMAP,lightMaps[this._lightmapIndex]);
				}else {
				this._defineDatas.remove(RenderableSprite3D.SAHDERDEFINE_LIGHTMAP);
			}
			}else {
			this._defineDatas.remove(RenderableSprite3D.SAHDERDEFINE_LIGHTMAP);
		}
	}

	/**
	*@private
	*/
	__proto._onWorldMatNeedChange=function(flag){
		this._boundsChange=true;
		if (this._octreeNode){
			flag &=/*laya.d3.core.Transform3D.TRANSFORM_WORLDPOSITION*/0x08 | /*laya.d3.core.Transform3D.TRANSFORM_WORLDQUATERNION*/0x10 | /*laya.d3.core.Transform3D.TRANSFORM_WORLDSCALE*/0x20;
			if (flag){
				if (this._indexInOctreeMotionList===-1)
					this._octreeNode._octree.addMotionObject(this);
			}
		}
	}

	/**
	*@private
	*/
	__proto._calculateBoundingBox=function(){
		throw("BaseRender: must override it.");
	}

	/**
	*@private [实现ISingletonElement接口]
	*/
	__proto._getIndexInList=function(){
		return this._indexInList;
	}

	/**
	*@private [实现ISingletonElement接口]
	*/
	__proto._setIndexInList=function(index){
		this._indexInList=index;
	}

	/**
	*@private
	*/
	__proto._setBelongScene=function(scene){
		if (this._scene!==scene){
			this._scene=scene;
			this._applyLightMapParams();
		}
	}

	/**
	*@private
	*@param boundFrustum 如果boundFrustum为空则为摄像机不裁剪模式。
	*/
	__proto._needRender=function(boundFrustum){
		return true;
	}

	/**
	*@private
	*/
	__proto._renderUpdate=function(context,transform){}
	/**
	*@private
	*/
	__proto._renderUpdateWithCamera=function(context,transform){}
	/**
	*@private
	*/
	__proto._revertBatchRenderUpdate=function(context){}
	/**
	*@private
	*/
	__proto._destroy=function(){
		(this._indexInOctreeMotionList!==-1)&& (this._octreeNode._octree.removeMotionObject(this));
		this.offAll();
		var i=0,n=0;
		for (i=0,n=this._renderElements.length;i < n;i++)
		this._renderElements[i].destroy();
		for (i=0,n=this._sharedMaterials.length;i < n;i++)
		(this._sharedMaterials[i].destroyed)|| (this._sharedMaterials[i]._removeReference());
		this._renderElements=null;
		this._owner=null;
		this._sharedMaterials=null;
		this._bounds=null;
		this._lightmapScaleOffset=null;
	}

	/**
	*获取包围盒,只读,不允许修改其值。
	*@return 包围盒。
	*/
	__getset(0,__proto,'bounds',function(){
		if (this._boundsChange){
			this._calculateBoundingBox();
			this._boundsChange=false;
		}
		return this._bounds;
	});

	/**
	*获取唯一标识ID,通常用于识别。
	*/
	__getset(0,__proto,'id',function(){
		return this._id;
	});

	/**
	*设置第一个实例材质。
	*@param value 第一个实例材质。
	*/
	/**
	*返回第一个实例材质,第一次使用会拷贝实例对象。
	*@return 第一个实例材质。
	*/
	__getset(0,__proto,'material',function(){
		var material=this._sharedMaterials[0];
		if (material && !this._materialsInstance[0]){
			var insMat=this._getInstanceMaterial(material,0);
			var renderElement=this._renderElements[0];
			(renderElement)&& (renderElement.material=insMat);
		}
		return this._sharedMaterials[0];
		},function(value){
		this.sharedMaterial=value;
	});

	/**
	*是否是静态的一部分。
	*/
	__getset(0,__proto,'isPartOfStaticBatch',function(){
		return this._isPartOfStaticBatch;
	});

	/**
	*设置第一个材质。
	*@param value 第一个材质。
	*/
	/**
	*返回第一个材质。
	*@return 第一个材质。
	*/
	__getset(0,__proto,'sharedMaterial',function(){
		return this._sharedMaterials[0];
		},function(value){
		var lastValue=this._sharedMaterials[0];
		if (lastValue!==value){
			this._sharedMaterials[0]=value;
			this._materialsInstance[0]=false;
			this._changeMaterialReference(lastValue,value);
			var renderElement=this._renderElements[0];
			(renderElement)&& (renderElement.material=value);
		}
	});

	/**
	*设置光照贴图的索引。
	*@param value 光照贴图的索引。
	*/
	/**
	*获取光照贴图的索引。
	*@return 光照贴图的索引。
	*/
	__getset(0,__proto,'lightmapIndex',function(){
		return this._lightmapIndex;
		},function(value){
		if (this._lightmapIndex!==value){
			this._lightmapIndex=value;
			this._applyLightMapParams();
		}
	});

	/**
	*设置光照贴图的缩放和偏移。
	*@param 光照贴图的缩放和偏移。
	*/
	/**
	*获取光照贴图的缩放和偏移。
	*@return 光照贴图的缩放和偏移。
	*/
	__getset(0,__proto,'lightmapScaleOffset',function(){
		return this._lightmapScaleOffset;
		},function(value){
		this._lightmapScaleOffset=value;
		this._shaderValues.setVector(RenderableSprite3D.LIGHTMAPSCALEOFFSET,value);
		this._defineDatas.add(RenderableSprite3D.SHADERDEFINE_SCALEOFFSETLIGHTINGMAPUV);
	});

	/**
	*设置是否产生阴影。
	*@param value 是否产生阴影。
	*/
	/**
	*获取是否产生阴影。
	*@return 是否产生阴影。
	*/
	__getset(0,__proto,'castShadow',function(){
		return this._castShadow;
		},function(value){
		if (this._castShadow!==value){
			if (this._owner.activeInHierarchy){
				if (value)
					this._scene._addShadowCastRenderObject(this);
				else
				this._scene._removeShadowCastRenderObject(this);
			}
			this._castShadow=value;
		}
	});

	/**
	*设置是否可用。
	*@param value 是否可用。
	*/
	/**
	*获取是否可用。
	*@return 是否可用。
	*/
	__getset(0,__proto,'enable',function(){
		return this._enable;
		},function(value){
		this._enable=!!value;
	});

	/**
	*设置实例材质列表。
	*@param value 实例材质列表。
	*/
	/**
	*获取潜拷贝实例材质列表,第一次使用会拷贝实例对象。
	*@return 浅拷贝实例材质列表。
	*/
	__getset(0,__proto,'materials',function(){
		for (var i=0,n=this._sharedMaterials.length;i < n;i++){
			if (!this._materialsInstance[i]){
				var insMat=this._getInstanceMaterial(this._sharedMaterials[i],i);
				var renderElement=this._renderElements[i];
				(renderElement)&& (renderElement.material=insMat);
			}
		}
		return this._sharedMaterials.slice();
		},function(value){
		this.sharedMaterials=value;
	});

	/**
	*设置材质列表。
	*@param value 材质列表。
	*/
	/**
	*获取浅拷贝材质列表。
	*@return 浅拷贝材质列表。
	*/
	__getset(0,__proto,'sharedMaterials',function(){
		return this._sharedMaterials.slice();
		},function(value){
		var mats=this._sharedMaterials;
		for (var i=0,n=mats.length;i < n;i++)
		mats[i]._removeReference();
		if (value){
			var count=value.length;
			this._materialsInstance.length=count;
			mats.length=count;
			for (i=0;i < count;i++){
				var lastMat=mats[i];
				var mat=value[i];
				if (lastMat!==mat){
					this._materialsInstance[i]=false;
					var renderElement=this._renderElements[i];
					(renderElement)&& (renderElement.material=mat);
				}
				mat._addReference();
				mats[i]=mat;
			}
			}else {
			throw new Error("BaseRender: shadredMaterials value can't be null.");
		}
	});

	/**
	*设置是否接收阴影属性
	*/
	/**
	*获得是否接收阴影属性
	*/
	__getset(0,__proto,'receiveShadow',function(){
		return this._receiveShadow;
		},function(value){
		if (this._receiveShadow!==value){
			this._receiveShadow=value;
			if (value)
				this._defineDatas.add(RenderableSprite3D.SHADERDEFINE_RECEIVE_SHADOW);
			else
			this._defineDatas.remove(RenderableSprite3D.SHADERDEFINE_RECEIVE_SHADOW);
		}
	});

	BaseRender._uniqueIDCounter=0;
	__static(BaseRender,
	['_tempBoundBoxCorners',function(){return this._tempBoundBoxCorners=/*new vector.<>*/[new Vector3(),new Vector3(),new Vector3(),new Vector3(),new Vector3(),new Vector3(),new Vector3(),new Vector3()];}
	]);
	return BaseRender;
})(EventDispatcher)


/**
*<code>Script3D</code> 类用于创建脚本的父类,该类为抽象类,不允许实例。
*/
//class laya.d3.component.Script3D extends laya.components.Component
var Script3D=(function(_super){
	function Script3D(){
		Script3D.__super.call(this);;
	}

	__class(Script3D,'laya.d3.component.Script3D',_super);
	var __proto=Script3D.prototype;
	/**
	*@private
	*/
	__proto._checkProcessTriggers=function(){
		var prototype=laya.d3.component.Script3D.prototype;
		if (this.onTriggerEnter!==prototype.onTriggerEnter)
			return true;
		if (this.onTriggerStay!==prototype.onTriggerStay)
			return true;
		if (this.onTriggerExit!==prototype.onTriggerExit)
			return true;
		return false;
	}

	/**
	*@private
	*/
	__proto._checkProcessCollisions=function(){
		var prototype=laya.d3.component.Script3D.prototype;
		if (this.onCollisionEnter!==prototype.onCollisionEnter)
			return true;
		if (this.onCollisionStay!==prototype.onCollisionStay)
			return true;
		if (this.onCollisionExit!==prototype.onCollisionExit)
			return true;
		return false;
	}

	/**
	*@inheritDoc
	*/
	__proto._onAwake=function(){
		this.onAwake();
		if (this.onStart!==laya.d3.component.Script3D.prototype.onStart)
			Laya.startTimer.callLater(this,this.onStart);
	}

	/**
	*@inheritDoc
	*/
	__proto._onEnable=function(){
		(this.owner)._scene._scriptPool.add(this);
		var proto=laya.d3.component.Script3D.prototype;
		if (this.onKeyDown!==proto.onKeyDown){
			Laya.stage.on(/*laya.events.Event.KEY_DOWN*/"keydown",this,this.onKeyDown);
		}
		if (this.onKeyPress!==proto.onKeyPress){
			Laya.stage.on(/*laya.events.Event.KEY_PRESS*/"keypress",this,this.onKeyUp);
		}
		if (this.onKeyUp!==proto.onKeyUp){
			Laya.stage.on(/*laya.events.Event.KEY_UP*/"keyup",this,this.onKeyUp);
		}
	}

	/**
	*@inheritDoc
	*/
	__proto._onDisable=function(){
		(this.owner)._scene._scriptPool.remove(this);
		this.owner.offAllCaller(this);
		Laya.stage.offAllCaller(this);
	}

	/**
	*@inheritDoc
	*/
	__proto._isScript=function(){
		return true;
	}

	/**
	*@inheritDoc
	*/
	__proto._onAdded=function(){
		var sprite=this.owner;
		var scripts=sprite._scripts;
		scripts || (sprite._scripts=scripts=[]);
		scripts.push(this);
		if (!sprite._needProcessCollisions)
			sprite._needProcessCollisions=this._checkProcessCollisions();
		if (!sprite._needProcessTriggers)
			sprite._needProcessTriggers=this._checkProcessTriggers();
	}

	/**
	*@inheritDoc
	*/
	__proto._onDestroy=function(){
		var scripts=(this.owner)._scripts;
		scripts.splice(scripts.indexOf(this),1);
		var sprite=this.owner;
		sprite._needProcessTriggers=false;
		for (var i=0,n=scripts.length;i < n;i++){
			if (scripts[i]._checkProcessTriggers()){
				sprite._needProcessTriggers=true;
				break ;
			}
		}
		sprite._needProcessCollisions=false;
		for (i=0,n=scripts.length;i < n;i++){
			if (scripts[i]._checkProcessCollisions()){
				sprite._needProcessCollisions=true;
				break ;
			}
		}
		this.onDestroy();
	}

	/**
	*创建后只执行一次
	*此方法为虚方法，使用时重写覆盖即可
	*/
	__proto.onAwake=function(){}
	/**
	*每次启动后执行
	*此方法为虚方法，使用时重写覆盖即可
	*/
	__proto.onEnable=function(){}
	/**
	*第一次执行update之前执行，只会执行一次
	*此方法为虚方法，使用时重写覆盖即可
	*/
	__proto.onStart=function(){}
	/**
	*开始触发时执行
	*此方法为虚方法，使用时重写覆盖即可
	*/
	__proto.onTriggerEnter=function(other){}
	/**
	*持续触发时执行
	*此方法为虚方法，使用时重写覆盖即可
	*/
	__proto.onTriggerStay=function(other){}
	/**
	*结束触发时执行
	*此方法为虚方法，使用时重写覆盖即可
	*/
	__proto.onTriggerExit=function(other){}
	/**
	*开始碰撞时执行
	*此方法为虚方法，使用时重写覆盖即可
	*/
	__proto.onCollisionEnter=function(collision){}
	/**
	*持续碰撞时执行
	*此方法为虚方法，使用时重写覆盖即可
	*/
	__proto.onCollisionStay=function(collision){}
	/**
	*结束碰撞时执行
	*此方法为虚方法，使用时重写覆盖即可
	*/
	__proto.onCollisionExit=function(collision){}
	/**
	*鼠标按下时执行
	*此方法为虚方法，使用时重写覆盖即可
	*/
	__proto.onMouseDown=function(){}
	/**
	*鼠标拖拽时执行
	*此方法为虚方法，使用时重写覆盖即可
	*/
	__proto.onMouseDrag=function(){}
	/**
	*鼠标点击时执行
	*此方法为虚方法，使用时重写覆盖即可
	*/
	__proto.onMouseClick=function(){}
	/**
	*鼠标弹起时执行
	*此方法为虚方法，使用时重写覆盖即可
	*/
	__proto.onMouseUp=function(){}
	/**
	*鼠标进入时执行
	*此方法为虚方法，使用时重写覆盖即可
	*/
	__proto.onMouseEnter=function(){}
	/**
	*鼠标经过时执行
	*此方法为虚方法，使用时重写覆盖即可
	*/
	__proto.onMouseOver=function(){}
	/**
	*鼠标离开时执行
	*此方法为虚方法，使用时重写覆盖即可
	*/
	__proto.onMouseOut=function(){}
	/**
	*键盘按下时执行
	*此方法为虚方法，使用时重写覆盖即可
	*/
	__proto.onKeyDown=function(e){}
	/**
	*键盘产生一个字符时执行
	*此方法为虚方法，使用时重写覆盖即可
	*/
	__proto.onKeyPress=function(e){}
	/**
	*键盘抬起时执行
	*此方法为虚方法，使用时重写覆盖即可
	*/
	__proto.onKeyUp=function(e){}
	/**
	*每帧更新时执行
	*此方法为虚方法，使用时重写覆盖即可
	*/
	__proto.onUpdate=function(){}
	/**
	*每帧更新时执行，在update之后执行
	*此方法为虚方法，使用时重写覆盖即可
	*/
	__proto.onLateUpdate=function(){}
	/**
	*渲染之前执行
	*此方法为虚方法，使用时重写覆盖即可
	*/
	__proto.onPreRender=function(){}
	/**
	*渲染之后执行
	*此方法为虚方法，使用时重写覆盖即可
	*/
	__proto.onPostRender=function(){}
	/**
	*禁用时执行
	*此方法为虚方法，使用时重写覆盖即可
	*/
	__proto.onDisable=function(){}
	/**
	*销毁时执行
	*此方法为虚方法，使用时重写覆盖即可
	*/
	__proto.onDestroy=function(){}
	/**
	*@inheritDoc
	*/
	__getset(0,__proto,'isSingleton',function(){
		return false;
	});

	return Script3D;
})(Component)


/**
*<code>Transform3D</code> 类用于实现3D变换。
*/
//class laya.d3.core.Transform3D extends laya.events.EventDispatcher
var Transform3D=(function(_super){
	function Transform3D(owner){
		/**@private */
		this._owner=null;
		/**@private */
		this._children=null;
		/**@private */
		this._parent=null;
		/**@private */
		this._dummy=null;
		/**@private */
		this._transformFlag=0;
		Transform3D.__super.call(this);
		this._localPosition=new Vector3(0,0,0);
		this._localRotation=new Quaternion(0,0,0,1);
		this._localScale=new Vector3(1,1,1);
		this._localRotationEuler=new Vector3(0,0,0);
		this._localMatrix=new Matrix4x4();
		this._position=new Vector3(0,0,0);
		this._rotation=new Quaternion(0,0,0,1);
		this._scale=new Vector3(1,1,1);
		this._rotationEuler=new Vector3(0,0,0);
		this._worldMatrix=new Matrix4x4();
		this._owner=owner;
		this._children=[];
		this._setTransformFlag(0x01 | 0x02 | 0x04,false);
		this._setTransformFlag(0x08 | 0x10 | 0x80 | 0x20 | 0x40,true);
	}

	__class(Transform3D,'laya.d3.core.Transform3D',_super);
	var __proto=Transform3D.prototype;
	/**
	*@private
	*/
	__proto._setTransformFlag=function(type,value){
		if (value)
			this._transformFlag |=type;
		else
		this._transformFlag &=~type;
	}

	/**
	*@private
	*/
	__proto._getTransformFlag=function(type){
		return (this._transformFlag & type)!=0;
	}

	/**
	*@private
	*/
	__proto._setParent=function(value){
		if (this._parent!==value){
			if (this._parent){
				var parentChilds=this._parent._children;
				var index=parentChilds.indexOf(this);
				parentChilds.splice(index,1);
			}
			if (value){
				value._children.push(this);
				(value)&& (this._onWorldTransform());
			}
			this._parent=value;
		}
	}

	/**
	*@private
	*/
	__proto._updateLocalMatrix=function(){
		Matrix4x4.createAffineTransformation(this._localPosition,this.localRotation,this._localScale,this._localMatrix);
	}

	/**
	*@private
	*/
	__proto._onWorldPositionRotationTransform=function(){
		if (!this._getTransformFlag(0x40)|| !this._getTransformFlag(0x08)|| !this._getTransformFlag(0x10)|| !this._getTransformFlag(0x80)){
			this._setTransformFlag(0x40 | 0x08 | 0x10 | 0x80,true);
			this.event(/*laya.events.Event.TRANSFORM_CHANGED*/"transformchanged",this._transformFlag);
			for (var i=0,n=this._children.length;i < n;i++)
			this._children[i]._onWorldPositionRotationTransform();
		}
	}

	/**
	*@private
	*/
	__proto._onWorldPositionScaleTransform=function(){
		if (!this._getTransformFlag(0x40)|| !this._getTransformFlag(0x08)|| !this._getTransformFlag(0x20)){
			this._setTransformFlag(0x40 | 0x08 | 0x20,true);
			this.event(/*laya.events.Event.TRANSFORM_CHANGED*/"transformchanged",this._transformFlag);
			for (var i=0,n=this._children.length;i < n;i++)
			this._children[i]._onWorldPositionScaleTransform();
		}
	}

	/**
	*@private
	*/
	__proto._onWorldPositionTransform=function(){
		if (!this._getTransformFlag(0x40)|| !this._getTransformFlag(0x08)){
			this._setTransformFlag(0x40 | 0x08,true);
			this.event(/*laya.events.Event.TRANSFORM_CHANGED*/"transformchanged",this._transformFlag);
			for (var i=0,n=this._children.length;i < n;i++)
			this._children[i]._onWorldPositionTransform();
		}
	}

	/**
	*@private
	*/
	__proto._onWorldRotationTransform=function(){
		if (!this._getTransformFlag(0x40)|| !this._getTransformFlag(0x10)|| !this._getTransformFlag(0x80)){
			this._setTransformFlag(0x40 | 0x10 | 0x80,true);
			this.event(/*laya.events.Event.TRANSFORM_CHANGED*/"transformchanged",this._transformFlag);
			for (var i=0,n=this._children.length;i < n;i++)
			this._children[i]._onWorldPositionRotationTransform();
		}
	}

	/**
	*@private
	*/
	__proto._onWorldScaleTransform=function(){
		if (!this._getTransformFlag(0x40)|| !this._getTransformFlag(0x20)){
			this._setTransformFlag(0x40 | 0x20,true);
			this.event(/*laya.events.Event.TRANSFORM_CHANGED*/"transformchanged",this._transformFlag);
			for (var i=0,n=this._children.length;i < n;i++)
			this._children[i]._onWorldPositionScaleTransform();
		}
	}

	/**
	*@private
	*/
	__proto._onWorldTransform=function(){
		if (!this._getTransformFlag(0x40)|| !this._getTransformFlag(0x08)|| !this._getTransformFlag(0x10)|| !this._getTransformFlag(0x80)|| !this._getTransformFlag(0x20)){
			this._setTransformFlag(0x40 | 0x08 | 0x10 | 0x80 | 0x20,true);
			this.event(/*laya.events.Event.TRANSFORM_CHANGED*/"transformchanged",this._transformFlag);
			for (var i=0,n=this._children.length;i < n;i++)
			this._children[i]._onWorldTransform();
		}
	}

	/**
	*平移变换。
	*@param translation 移动距离。
	*@param isLocal 是否局部空间。
	*/
	__proto.translate=function(translation,isLocal){
		(isLocal===void 0)&& (isLocal=true);
		if (isLocal){
			Matrix4x4.createFromQuaternion(this.localRotation,Transform3D._tempMatrix0);
			Vector3.transformCoordinate(translation,Transform3D._tempMatrix0,Transform3D._tempVector30);
			Vector3.add(this.localPosition,Transform3D._tempVector30,this._localPosition);
			this.localPosition=this._localPosition;
			}else {
			Vector3.add(this.position,translation,this._position);
			this.position=this._position;
		}
	}

	/**
	*旋转变换。
	*@param rotations 旋转幅度。
	*@param isLocal 是否局部空间。
	*@param isRadian 是否弧度制。
	*/
	__proto.rotate=function(rotation,isLocal,isRadian){
		(isLocal===void 0)&& (isLocal=true);
		(isRadian===void 0)&& (isRadian=true);
		var rot;
		if (isRadian){
			rot=rotation;
			}else {
			Vector3.scale(rotation,Math.PI / 180.0,Transform3D._tempVector30);
			rot=Transform3D._tempVector30;
		}
		Quaternion.createFromYawPitchRoll(rot.y,rot.x,rot.z,Transform3D._tempQuaternion0);
		if (isLocal){
			Quaternion.multiply(this._localRotation,Transform3D._tempQuaternion0,this._localRotation);
			this.localRotation=this._localRotation;
			}else {
			Quaternion.multiply(Transform3D._tempQuaternion0,this.rotation,this._rotation);
			this.rotation=this._rotation;
		}
	}

	/**
	*获取向前方向。
	*@param 前方向。
	*/
	__proto.getForward=function(forward){
		var worldMatElem=this.worldMatrix.elements;
		forward.x=-worldMatElem[8];
		forward.y=-worldMatElem[9];
		forward.z=-worldMatElem[10];
	}

	/**
	*获取向上方向。
	*@param 上方向。
	*/
	__proto.getUp=function(up){
		var worldMatElem=this.worldMatrix.elements;
		up.x=worldMatElem[4];
		up.y=worldMatElem[5];
		up.z=worldMatElem[6];
	}

	/**
	*获取向右方向。
	*@param 右方向。
	*/
	__proto.getRight=function(right){
		var worldMatElem=this.worldMatrix.elements;
		right.x=worldMatElem[0];
		right.y=worldMatElem[1];
		right.z=worldMatElem[2];
	}

	/**
	*观察目标位置。
	*@param target 观察目标。
	*@param up 向上向量。
	*@param isLocal 是否局部空间。
	*/
	__proto.lookAt=function(target,up,isLocal){
		(isLocal===void 0)&& (isLocal=false);
		var eye;
		if (isLocal){
			eye=this._localPosition;
			if (Math.abs(eye.x-target.x)< MathUtils3D.zeroTolerance && Math.abs(eye.y-target.y)< MathUtils3D.zeroTolerance && Math.abs(eye.z-target.z)< MathUtils3D.zeroTolerance)
				return;
			Quaternion.lookAt(this._localPosition,target,up,this._localRotation);
			this._localRotation.invert(this._localRotation);
			this.localRotation=this._localRotation;
			}else {
			var worldPosition=this.position;
			eye=worldPosition;
			if (Math.abs(eye.x-target.x)< MathUtils3D.zeroTolerance && Math.abs(eye.y-target.y)< MathUtils3D.zeroTolerance && Math.abs(eye.z-target.z)< MathUtils3D.zeroTolerance)
				return;
			Quaternion.lookAt(worldPosition,target,up,this._rotation);
			this._rotation.invert(this._rotation);
			this.rotation=this._rotation;
		}
	}

	/**
	*@private
	*/
	__getset(0,__proto,'_isFrontFaceInvert',function(){
		var scale=this.scale;
		var isInvert=scale.x < 0;
		(scale.y < 0)&& (isInvert=!isInvert);
		(scale.z < 0)&& (isInvert=!isInvert);
		return isInvert;
	});

	/**
	*获取所属精灵。
	*/
	__getset(0,__proto,'owner',function(){
		return this._owner;
	});

	/**
	*设置局部位置Y轴分量。
	*@param y 局部位置Y轴分量。
	*/
	/**
	*获取局部位置Y轴分量。
	*@return 局部位置Y轴分量。
	*/
	__getset(0,__proto,'localPositionY',function(){
		return this._localPosition.y;
		},function(y){
		this._localPosition.y=y;
		this.localPosition=this._localPosition;
	});

	/**
	*设置局部缩放X。
	*@param value 局部缩放X。
	*/
	/**
	*获取局部缩放X。
	*@return 局部缩放X。
	*/
	__getset(0,__proto,'localScaleX',function(){
		return this._localScale.x;
		},function(value){
		this._localScale.x=value;
		this.localScale=this._localScale;
	});

	/**
	*获取世界矩阵是否需要更新。
	*@return 世界矩阵是否需要更新。
	*/
	__getset(0,__proto,'worldNeedUpdate',function(){
		return this._getTransformFlag(0x40);
	});

	/**
	*设置局部位置X轴分量。
	*@param x 局部位置X轴分量。
	*/
	/**
	*获取局部位置X轴分量。
	*@return 局部位置X轴分量。
	*/
	__getset(0,__proto,'localPositionX',function(){
		return this._localPosition.x;
		},function(x){
		this._localPosition.x=x;
		this.localPosition=this._localPosition;
	});

	/**
	*设置局部位置。
	*@param value 局部位置。
	*/
	/**
	*获取局部位置。
	*@return 局部位置。
	*/
	__getset(0,__proto,'localPosition',function(){
		return this._localPosition;
		},function(value){
		if (this._localPosition!==value)
			value.cloneTo(this._localPosition);
		this._setTransformFlag(0x04,true);
		this._onWorldPositionTransform();
	});

	/**
	*设置局部位置Z轴分量。
	*@param z 局部位置Z轴分量。
	*/
	/**
	*获取局部位置Z轴分量。
	*@return 局部位置Z轴分量。
	*/
	__getset(0,__proto,'localPositionZ',function(){
		return this._localPosition.z;
		},function(z){
		this._localPosition.z=z;
		this.localPosition=this._localPosition;
	});

	/**
	*设置局部旋转四元数X分量。
	*@param x 局部旋转四元数X分量。
	*/
	/**
	*获取局部旋转四元数X分量。
	*@return 局部旋转四元数X分量。
	*/
	__getset(0,__proto,'localRotationX',function(){
		return this.localRotation.x;
		},function(x){
		this._localRotation.x=x;
		this.localRotation=this._localRotation;
	});

	/**
	*设置局部旋转四元数Y分量。
	*@param y 局部旋转四元数Y分量。
	*/
	/**
	*获取局部旋转四元数Y分量。
	*@return 局部旋转四元数Y分量。
	*/
	__getset(0,__proto,'localRotationY',function(){
		return this.localRotation.y;
		},function(y){
		this._localRotation.y=y;
		this.localRotation=this._localRotation;
	});

	/**
	*设置局部旋转四元数Z分量。
	*@param z 局部旋转四元数Z分量。
	*/
	/**
	*获取局部旋转四元数Z分量。
	*@return 局部旋转四元数Z分量。
	*/
	__getset(0,__proto,'localRotationZ',function(){
		return this.localRotation.z;
		},function(z){
		this._localRotation.z=z;
		this.localRotation=this._localRotation;
	});

	/**
	*设置局部旋转四元数W分量。
	*@param w 局部旋转四元数W分量。
	*/
	/**
	*获取局部旋转四元数W分量。
	*@return 局部旋转四元数W分量。
	*/
	__getset(0,__proto,'localRotationW',function(){
		return this.localRotation.w;
		},function(w){
		this._localRotation.w=w;
		this.localRotation=this._localRotation;
	});

	/**
	*设置局部旋转。
	*@param value 局部旋转。
	*/
	/**
	*获取局部旋转。
	*@return 局部旋转。
	*/
	__getset(0,__proto,'localRotation',function(){
		if (this._getTransformFlag(0x01)){
			var eulerE=this._localRotationEuler;
			Quaternion.createFromYawPitchRoll(eulerE.y / Transform3D._angleToRandin,eulerE.x / Transform3D._angleToRandin,eulerE.z / Transform3D._angleToRandin,this._localRotation);
			this._setTransformFlag(0x01,false);
		}
		return this._localRotation;
		},function(value){
		if (this._localRotation!==value)
			value.cloneTo(this._localRotation);
		this._localRotation.normalize(this._localRotation);
		this._setTransformFlag(0x02 | 0x04,true);
		this._setTransformFlag(0x01,false);
		this._onWorldRotationTransform();
	});

	/**
	*设置局部缩放Y。
	*@param value 局部缩放Y。
	*/
	/**
	*获取局部缩放Y。
	*@return 局部缩放Y。
	*/
	__getset(0,__proto,'localScaleY',function(){
		return this._localScale.y;
		},function(value){
		this._localScale.y=value;
		this.localScale=this._localScale;
	});

	/**
	*设置局部缩放Z。
	*@param value 局部缩放Z。
	*/
	/**
	*获取局部缩放Z。
	*@return 局部缩放Z。
	*/
	__getset(0,__proto,'localScaleZ',function(){
		return this._localScale.z;
		},function(value){
		this._localScale.z=value;
		this.localScale=this._localScale;
	});

	/**
	*设置世界位置。
	*@param value 世界位置。
	*/
	/**
	*获取世界位置。
	*@return 世界位置。
	*/
	__getset(0,__proto,'position',function(){
		if (this._getTransformFlag(0x08)){
			if (this._parent !=null){
				var parentPosition=this._parent.position;
				Vector3.multiply(this._localPosition,this._parent.scale,Transform3D._tempVector30);
				Vector3.transformQuat(Transform3D._tempVector30,this._parent.rotation,Transform3D._tempVector30);
				Vector3.add(parentPosition,Transform3D._tempVector30,this._position);
				}else {
				this._localPosition.cloneTo(this._position);
			}
			this._setTransformFlag(0x08,false);
		}
		return this._position;
		},function(value){
		if (this._parent !=null){
			Vector3.subtract(value,this._parent.position,this._localPosition);
			var parentScale=this._parent.scale;
			var psX=parentScale.x,psY=parentScale.y,psZ=parentScale.z;
			if (psX!==1.0 || psY!==1.0 || psZ!==1.0){
				var invertScale=Transform3D._tempVector30;
				invertScale.x=1.0 / psX;
				invertScale.y=1.0 / psY;
				invertScale.z=1.0 / psZ;
				Vector3.multiply(this._localPosition,invertScale,this._localPosition);
			};
			var parentRotation=this._parent.rotation;
			parentRotation.invert(Transform3D._tempQuaternion0);
			Vector3.transformQuat(this._localPosition,Transform3D._tempQuaternion0,this._localPosition);
			}else {
			value.cloneTo(this._localPosition);
		}
		this.localPosition=this._localPosition;
		if (this._position!==value)
			value.cloneTo(this._position);
		this._setTransformFlag(0x08,false);
	});

	/**
	*设置局部空间的Y轴欧拉角。
	*@param value 局部空间的Y轴欧拉角。
	*/
	/**
	*获取局部空间的Y轴欧拉角。
	*@return 局部空间的Y轴欧拉角。
	*/
	__getset(0,__proto,'localRotationEulerY',function(){
		return this.localRotationEuler.y;
		},function(value){
		this._localRotationEuler.y=value;
		this.localRotationEuler=this._localRotationEuler;
	});

	/**
	*设置局部缩放。
	*@param value 局部缩放。
	*/
	/**
	*获取局部缩放。
	*@return 局部缩放。
	*/
	__getset(0,__proto,'localScale',function(){
		return this._localScale;
		},function(value){
		if (this._localScale!==value)
			value.cloneTo(this._localScale);
		this._setTransformFlag(0x04,true);
		this._onWorldScaleTransform();
	});

	/**
	*设置局部空间的X轴欧拉角。
	*@param value 局部空间的X轴欧拉角。
	*/
	/**
	*获取局部空间的X轴欧拉角。
	*@return 局部空间的X轴欧拉角。
	*/
	__getset(0,__proto,'localRotationEulerX',function(){
		return this.localRotationEuler.x;
		},function(value){
		this._localRotationEuler.x=value;
		this.localRotationEuler=this._localRotationEuler;
	});

	/**
	*设置局部空间的Z轴欧拉角。
	*@param value 局部空间的Z轴欧拉角。
	*/
	/**
	*获取局部空间的Z轴欧拉角。
	*@return 局部空间的Z轴欧拉角。
	*/
	__getset(0,__proto,'localRotationEulerZ',function(){
		return this.localRotationEuler.z;
		},function(value){
		this._localRotationEuler.z=value;
		this.localRotationEuler=this._localRotationEuler;
	});

	/**
	*设置局部空间的欧拉角。
	*@param value 欧拉角的旋转值。
	*/
	/**
	*获取局部空间欧拉角。
	*@return 欧拉角的旋转值。
	*/
	__getset(0,__proto,'localRotationEuler',function(){
		if (this._getTransformFlag(0x02)){
			this._localRotation.getYawPitchRoll(Transform3D._tempVector30);
			var euler=Transform3D._tempVector30;
			var localRotationEuler=this._localRotationEuler;
			localRotationEuler.x=euler.y *Transform3D._angleToRandin;
			localRotationEuler.y=euler.x *Transform3D._angleToRandin;
			localRotationEuler.z=euler.z *Transform3D._angleToRandin;
			this._setTransformFlag(0x02,false);
		}
		return this._localRotationEuler;
		},function(value){
		if (this._localRotationEuler!==value)
			value.cloneTo(this._localRotationEuler);
		this._setTransformFlag(0x02,false);
		this._setTransformFlag(0x01 | 0x04,true);
		this._onWorldRotationTransform();
	});

	/**
	*设置局部矩阵。
	*@param value 局部矩阵。
	*/
	/**
	*获取局部矩阵。
	*@return 局部矩阵。
	*/
	__getset(0,__proto,'localMatrix',function(){
		if (this._getTransformFlag(0x04)){
			this._updateLocalMatrix();
			this._setTransformFlag(0x04,false);
		}
		return this._localMatrix;
		},function(value){
		if (this._localMatrix!==value)
			value.cloneTo(this._localMatrix);
		this._localMatrix.decomposeTransRotScale(this._localPosition,this._localRotation,this._localScale);
		this._setTransformFlag(0x04,false);
		this._onWorldTransform();
	});

	/**
	*设置世界旋转。
	*@param value 世界旋转。
	*/
	/**
	*获取世界旋转。
	*@return 世界旋转。
	*/
	__getset(0,__proto,'rotation',function(){
		if (this._getTransformFlag(0x10)){
			if (this._parent !=null)
				Quaternion.multiply(this._parent.rotation,this.localRotation,this._rotation);
			else
			this.localRotation.cloneTo(this._rotation);
			this._setTransformFlag(0x10,false);
		}
		return this._rotation;
		},function(value){
		if (this._parent !=null){
			this._parent.rotation.invert(Transform3D._tempQuaternion0);
			Quaternion.multiply(Transform3D._tempQuaternion0,value,this._localRotation);
			}else {
			value.cloneTo(this._localRotation);
		}
		this.localRotation=this._localRotation;
		if (value!==this._rotation)
			value.cloneTo(this._rotation);
		this._setTransformFlag(0x10,false);
	});

	/**
	*设置世界缩放。
	*@param value 世界缩放。
	*/
	/**
	*获取世界缩放。
	*@return 世界缩放。
	*/
	__getset(0,__proto,'scale',function(){
		if (!this._getTransformFlag(0x20))
			return this._scale;
		if (this._parent!==null)
			Vector3.multiply(this._parent.scale,this._localScale,this._scale);
		else
		this._localScale.cloneTo(this._scale);
		this._setTransformFlag(0x20,false);
		return this._scale;
		},function(value){
		if (this._parent!==null){
			var parScale=this._parent.scale;
			var invParScale=Transform3D._tempVector30;
			invParScale.x=1.0 / parScale.x;
			invParScale.y=1.0 / parScale.y;
			invParScale.z=1.0 / parScale.z;
			Vector3.multiply(value,Transform3D._tempVector30,this._localScale);
			}else {
			value.cloneTo(this._localScale);
		}
		this.localScale=this._localScale;
		if (this._scale!==value)
			value.cloneTo(this._scale);
		this._setTransformFlag(0x20,false);
	});

	/**
	*设置世界空间的旋转角度。
	*@param 欧拉角的旋转值，顺序为x、y、z。
	*/
	/**
	*获取世界空间的旋转角度。
	*@return 欧拉角的旋转值，顺序为x、y、z。
	*/
	__getset(0,__proto,'rotationEuler',function(){
		if (this._getTransformFlag(0x80)){
			this.rotation.getYawPitchRoll(Transform3D._tempVector30);
			var eulerE=Transform3D._tempVector30;
			var rotationEulerE=this._rotationEuler;
			rotationEulerE.x=eulerE.y *Transform3D._angleToRandin;
			rotationEulerE.y=eulerE.x *Transform3D._angleToRandin;
			rotationEulerE.z=eulerE.z *Transform3D._angleToRandin;
			this._setTransformFlag(0x80,false);
		}
		return this._rotationEuler;
		},function(value){
		Quaternion.createFromYawPitchRoll(value.y / Transform3D._angleToRandin,value.x / Transform3D._angleToRandin,value.z / Transform3D._angleToRandin,this._rotation);
		this.rotation=this._rotation;
		if (this._rotationEuler!==value)
			value.cloneTo(this._rotationEuler);
		this._setTransformFlag(0x80,false);
	});

	/**
	*设置世界矩阵。
	*@param value 世界矩阵。
	*/
	/**
	*获取世界矩阵。
	*@return 世界矩阵。
	*/
	__getset(0,__proto,'worldMatrix',function(){
		if (this._getTransformFlag(0x40)){
			if (this._parent !=null)
				Matrix4x4.multiply(this._parent.worldMatrix,this.localMatrix,this._worldMatrix);
			else
			this.localMatrix.cloneTo(this._worldMatrix);
			this._setTransformFlag(0x40,false);
		}
		return this._worldMatrix;
		},function(value){
		if (this._parent===null){
			value.cloneTo(this._localMatrix);
			}else {
			this._parent.worldMatrix.invert(this._localMatrix);
			Matrix4x4.multiply(this._localMatrix,value,this._localMatrix);
		}
		this.localMatrix=this._localMatrix;
		if (this._worldMatrix!==value)
			value.cloneTo(this._worldMatrix);
		this._setTransformFlag(0x40,false);
	});

	Transform3D.TRANSFORM_LOCALQUATERNION=0x01;
	Transform3D.TRANSFORM_LOCALEULER=0x02;
	Transform3D.TRANSFORM_LOCALMATRIX=0x04;
	Transform3D.TRANSFORM_WORLDPOSITION=0x08;
	Transform3D.TRANSFORM_WORLDQUATERNION=0x10;
	Transform3D.TRANSFORM_WORLDSCALE=0x20;
	Transform3D.TRANSFORM_WORLDMATRIX=0x40;
	Transform3D.TRANSFORM_WORLDEULER=0x80;
	__static(Transform3D,
	['_tempVector30',function(){return this._tempVector30=new Vector3();},'_tempVector31',function(){return this._tempVector31=new Vector3();},'_tempVector32',function(){return this._tempVector32=new Vector3();},'_tempVector33',function(){return this._tempVector33=new Vector3();},'_tempQuaternion0',function(){return this._tempQuaternion0=new Quaternion();},'_tempMatrix0',function(){return this._tempMatrix0=new Matrix4x4();},'_angleToRandin',function(){return this._angleToRandin=180 / Math.PI;}
	]);
	return Transform3D;
})(EventDispatcher)


/**
*<code>Animator</code> 类用于创建动画组件。
*/
//class laya.d3.component.Animator extends laya.components.Component
var Animator=(function(_super){
	function Animator(){
		/**@private */
		//this._speed=NaN;
		/**@private */
		//this._keyframeNodeOwnerMap=null;
		/**@private */
		//this._updateMark=0;
		/**@private */
		//this._controllerLayers=null;
		/**@private */
		//this._linkSprites=null;
		/**@private */
		//this._avatarNodeMap=null;
		/**@private */
		this._linkAvatarSpritesData={};
		/**@private [NATIVE]*/
		//this._animationNodeLocalPositions=null;
		/**@private [NATIVE]*/
		//this._animationNodeLocalRotations=null;
		/**@private [NATIVE]*/
		//this._animationNodeLocalScales=null;
		/**@private [NATIVE]*/
		//this._animationNodeWorldMatrixs=null;
		/**@private [NATIVE]*/
		//this._animationNodeParentIndices=null;
		/**@private */
		//this._avatar=null;
		this._keyframeNodeOwners=[];
		this._linkAvatarSprites=[];
		this._renderableSprites=[];
		this.cullingMode=2;
		Animator.__super.call(this);
		this._controllerLayers=[];
		this._linkSprites={};
		this._speed=1.0;
		this._keyframeNodeOwnerMap={};
		this._updateMark=0;
	}

	__class(Animator,'laya.d3.component.Animator',_super);
	var __proto=Animator.prototype;
	/**
	*@private
	*/
	__proto._linkToSprites=function(linkSprites){
		for (var k in linkSprites){
			var nodeOwner=this.owner;
			var path=linkSprites[k];
			for (var j=0,m=path.length;j < m;j++){
				var p=path[j];
				if (p===""){
					break ;
					}else {
					nodeOwner=nodeOwner.getChildByName(p);
					if (!nodeOwner)
						break ;
				}
			}
			(nodeOwner)&& (this.linkSprite3DToAvatarNode(k,nodeOwner));
		}
	}

	/**
	*@private
	*/
	__proto._addKeyframeNodeOwner=function(clipOwners,node,propertyOwner){
		var nodeIndex=node._indexInList;
		var fullPath=node.fullPath;
		var keyframeNodeOwner=this._keyframeNodeOwnerMap[fullPath];
		if (keyframeNodeOwner){
			keyframeNodeOwner.referenceCount++;
			clipOwners[nodeIndex]=keyframeNodeOwner;
			}else {
			var property=propertyOwner;
			for (var i=0,n=node.propertyCount;i < n;i++){
				property=property[node.getPropertyByIndex(i)];
				if (!property)
					break ;
			}
			keyframeNodeOwner=this._keyframeNodeOwnerMap[fullPath]=new KeyframeNodeOwner();
			keyframeNodeOwner.fullPath=fullPath;
			keyframeNodeOwner.indexInList=this._keyframeNodeOwners.length;
			keyframeNodeOwner.referenceCount=1;
			keyframeNodeOwner.propertyOwner=propertyOwner;
			var propertyCount=node.propertyCount;
			var propertys=__newvec(propertyCount);
			for (i=0;i < propertyCount;i++)
			propertys[i]=node.getPropertyByIndex(i);
			keyframeNodeOwner.property=propertys;
			keyframeNodeOwner.type=node.type;
			if (property){
				if (node.type===0){
					keyframeNodeOwner.defaultValue=property;
					}else {
					var defaultValue=new property.constructor();
					property.cloneTo(defaultValue);
					keyframeNodeOwner.defaultValue=defaultValue;
				}
			}
			this._keyframeNodeOwners.push(keyframeNodeOwner);
			clipOwners[nodeIndex]=keyframeNodeOwner;
		}
	}

	/**
	*@private
	*/
	__proto._removeKeyframeNodeOwner=function(nodeOwners,node){
		var fullPath=node.fullPath;
		var keyframeNodeOwner=this._keyframeNodeOwnerMap[fullPath];
		if (keyframeNodeOwner){
			keyframeNodeOwner.referenceCount--;
			if (keyframeNodeOwner.referenceCount===0){
				delete this._keyframeNodeOwnerMap[fullPath];
				this._keyframeNodeOwners.splice(this._keyframeNodeOwners.indexOf(keyframeNodeOwner),1);
			}
			nodeOwners[node._indexInList]=null;
		}
	}

	/**
	*@private
	*/
	__proto._getOwnersByClip=function(clipStateInfo){
		var frameNodes=clipStateInfo._clip._nodes;
		var frameNodesCount=frameNodes.count;
		var nodeOwners=clipStateInfo._nodeOwners;
		nodeOwners.length=frameNodesCount;
		for (var i=0;i < frameNodesCount;i++){
			var node=frameNodes.getNodeByIndex(i);
			var property=this._avatar ? this._avatarNodeMap[this._avatar._rootNode.name] :this.owner;
			for (var j=0,m=node.ownerPathCount;j < m;j++){
				var ownPat=node.getOwnerPathByIndex(j);
				if (ownPat===""){
					break ;
					}else {
					property=property.getChildByName(ownPat);
					if (!property)
						break ;
				}
			}
			if (property){
				var propertyOwner=node.propertyOwner;
				(propertyOwner)&& (property=property[propertyOwner]);
				property && this._addKeyframeNodeOwner(nodeOwners,node,property);
			}
		}
	}

	/**
	*@private
	*/
	__proto._updatePlayer=function(animatorState,playState,elapsedTime,islooping){
		var clipDuration=animatorState._clip._duration *(animatorState.clipEnd-animatorState.clipStart);
		var lastElapsedTime=playState._elapsedTime;
		var elapsedPlaybackTime=lastElapsedTime+elapsedTime;
		playState._lastElapsedTime=lastElapsedTime;
		playState._elapsedTime=elapsedPlaybackTime;
		var normalizedTime=elapsedPlaybackTime / clipDuration;
		playState._normalizedTime=normalizedTime;
		var playTime=normalizedTime % 1.0;
		playState._normalizedPlayTime=playTime < 0 ? playTime+1.0 :playTime;
		playState._duration=clipDuration;
		var scripts=animatorState._scripts;
		if ((!islooping && elapsedPlaybackTime >=clipDuration)){
			playState._finish=true;
			playState._elapsedTime=clipDuration;
			playState._normalizedPlayTime=1.0;
			if (scripts){
				for (var i=0,n=scripts.length;i < n;i++)
				scripts[i].onStateExit();
			}
			return;
		}
		if (scripts){
			for (i=0,n=scripts.length;i < n;i++)
			scripts[i].onStateUpdate();
		}
	}

	/**
	*@private
	*/
	__proto._eventScript=function(scripts,events,eventIndex,endTime,front){
		if (front){
			for (var n=events.length;eventIndex < n;eventIndex++){
				var event=events[eventIndex];
				if (event.time <=endTime){
					for (var j=0,m=scripts.length;j < m;j++){
						var script=scripts[j];
						var fun=script[event.eventName];
						(fun)&& (fun.apply(script,event.params));
					}
					}else {
					break ;
				}
			}
			}else {
			for (;eventIndex >=0;eventIndex--){
				event=events[eventIndex];
				if (event.time >=endTime){
					for (j=0,m=scripts.length;j < m;j++){
						script=scripts[j];
						fun=script[event.eventName];
						(fun)&& (fun.apply(script,event.params));
					}
					}else {
					break ;
				}
			}
		}
		return eventIndex;
	}

	/**
	*@private
	*/
	__proto._updateEventScript=function(stateInfo,playStateInfo){
		var scripts=(this.owner)._scripts;
		if (scripts){
			var clip=stateInfo._clip;
			var events=clip._events;
			var clipDuration=clip._duration;
			var elapsedTime=playStateInfo._elapsedTime;
			var time=elapsedTime % clipDuration;
			var loopCount=Math.abs(Math.floor(elapsedTime / clipDuration)-Math.floor(playStateInfo._lastElapsedTime / clipDuration));
			var frontPlay=playStateInfo._elapsedTime >=playStateInfo._lastElapsedTime;
			if (playStateInfo._lastIsFront!==frontPlay){
				if (frontPlay)
					playStateInfo._playEventIndex++;
				else
				playStateInfo._playEventIndex--;
				playStateInfo._lastIsFront=frontPlay;
			}
			if (loopCount==0){
				playStateInfo._playEventIndex=this._eventScript(scripts,events,playStateInfo._playEventIndex,time,frontPlay);
				}else {
				if (frontPlay){
					this._eventScript(scripts,events,playStateInfo._playEventIndex,clipDuration,true);
					for (var i=0,n=loopCount-1;i < n;i++)
					this._eventScript(scripts,events,0,clipDuration,true);
					playStateInfo._playEventIndex=this._eventScript(scripts,events,0,time,true);
					}else {
					this._eventScript(scripts,events,playStateInfo._playEventIndex,0,false);
					var eventIndex=events.length-1;
					for (i=0,n=loopCount-1;i < n;i++)
					this._eventScript(scripts,events,eventIndex,0,false);
					playStateInfo._playEventIndex=this._eventScript(scripts,events,eventIndex,time,false);
				}
			}
		}
	}

	/**
	*@private
	*/
	__proto._updateClipDatas=function(animatorState,addtive,playStateInfo,scale){
		var clip=animatorState._clip;
		var clipDuration=clip._duration;
		var curPlayTime=animatorState.clipStart *clipDuration+playStateInfo._normalizedPlayTime *playStateInfo._duration;
		var currentFrameIndices=animatorState._currentFrameIndices;
		var frontPlay=playStateInfo._elapsedTime > playStateInfo._lastElapsedTime;
		clip._evaluateClipDatasRealTime(clip._nodes,curPlayTime,currentFrameIndices,addtive,frontPlay);
	}

	/**
	*@private
	*/
	__proto._applyFloat=function(pro,proName,nodeOwner,additive,weight,isFirstLayer,data){
		if (nodeOwner.updateMark===this._updateMark){
			if (additive){
				pro[proName]+=weight *(data);
				}else {
				var oriValue=pro[proName];
				pro[proName]=oriValue+weight *(data-oriValue);
			}
			}else {
			if (isFirstLayer){
				if (additive)
					pro[proName]=nodeOwner.defaultValue+data;
				else
				pro[proName]=data;
				}else {
				if (additive){
					pro[proName]=nodeOwner.defaultValue+weight *(data);
					}else {
					var defValue=nodeOwner.defaultValue;
					pro[proName]=defValue+weight *(data-defValue);
				}
			}
		}
	}

	/**
	*@private
	*/
	__proto._applyPositionAndRotationEuler=function(nodeOwner,additive,weight,isFirstLayer,data,out){
		if (nodeOwner.updateMark===this._updateMark){
			if (additive){
				out.x+=weight *data.x;
				out.y+=weight *data.y;
				out.z+=weight *data.z;
				}else {
				var oriX=out.x;
				var oriY=out.y;
				var oriZ=out.z;
				out.x=oriX+weight *(data.x-oriX);
				out.y=oriY+weight *(data.y-oriY);
				out.z=oriZ+weight *(data.z-oriZ);
			}
			}else {
			if (isFirstLayer){
				if (additive){
					var defValue=nodeOwner.defaultValue;
					out.x=defValue.x+data.x;
					out.y=defValue.y+data.y;
					out.z=defValue.z+data.z;
					}else {
					out.x=data.x;
					out.y=data.y;
					out.z=data.z;
				}
				}else {
				defValue=nodeOwner.defaultValue;
				if (additive){
					out.x=defValue.x+weight *data.x;
					out.y=defValue.y+weight *data.y;
					out.z=defValue.z+weight *data.z;
					}else {
					var defX=defValue.x;
					var defY=defValue.y;
					var defZ=defValue.z;
					out.x=defX+weight *(data.x-defX);
					out.y=defY+weight *(data.y-defY);
					out.z=defZ+weight *(data.z-defZ);
				}
			}
		}
	}

	/**
	*@private
	*/
	__proto._applyRotation=function(nodeOwner,additive,weight,isFirstLayer,clipRot,localRotation){
		if (nodeOwner.updateMark===this._updateMark){
			if (additive){
				var tempQuat=Animator._tempQuaternion1;
				Utils3D.quaternionWeight(clipRot,weight,tempQuat);
				tempQuat.normalize(tempQuat);
				Quaternion.multiply(localRotation,tempQuat,localRotation);
				}else {
				Quaternion.lerp(localRotation,clipRot,weight,localRotation);
			}
			}else {
			if (isFirstLayer){
				if (additive){
					var defaultRot=nodeOwner.defaultValue;
					Quaternion.multiply(defaultRot,clipRot,localRotation);
					}else {
					localRotation.x=clipRot.x;
					localRotation.y=clipRot.y;
					localRotation.z=clipRot.z;
					localRotation.w=clipRot.w;
				}
				}else {
				defaultRot=nodeOwner.defaultValue;
				if (additive){
					tempQuat=Animator._tempQuaternion1;
					Utils3D.quaternionWeight(clipRot,weight,tempQuat);
					tempQuat.normalize(tempQuat);
					Quaternion.multiply(defaultRot,tempQuat,localRotation);
					}else {
					Quaternion.lerp(defaultRot,clipRot,weight,localRotation);
				}
			}
		}
	}

	/**
	*@private
	*/
	__proto._applyScale=function(nodeOwner,additive,weight,isFirstLayer,clipSca,localScale){
		if (nodeOwner.updateMark===this._updateMark){
			if (additive){
				var scale=Animator._tempVector31;
				Utils3D.scaleWeight(clipSca,weight,scale);
				localScale.x=localScale.x *scale.x;
				localScale.y=localScale.y *scale.y;
				localScale.z=localScale.z *scale.z;
				}else {
				Utils3D.scaleBlend(localScale,clipSca,weight,localScale);
			}
			}else {
			if (isFirstLayer){
				if (additive){
					var defaultSca=nodeOwner.defaultValue;
					localScale.x=defaultSca.x *clipSca.x;
					localScale.y=defaultSca.y *clipSca.y;
					localScale.z=defaultSca.z *clipSca.z;
					}else {
					localScale.x=clipSca.x;
					localScale.y=clipSca.y;
					localScale.z=clipSca.z;
				}
				}else {
				defaultSca=nodeOwner.defaultValue;
				if (additive){
					scale=Animator._tempVector31;
					Utils3D.scaleWeight(clipSca,weight,scale);
					localScale.x=defaultSca.x *scale.x;
					localScale.y=defaultSca.y *scale.y;
					localScale.z=defaultSca.z *scale.z;
					}else {
					Utils3D.scaleBlend(defaultSca,clipSca,weight,localScale);
				}
			}
		}
	}

	/**
	*@private
	*/
	__proto._applyCrossData=function(nodeOwner,additive,weight,isFirstLayer,srcValue,desValue,crossWeight){
		var pro=nodeOwner.propertyOwner;
		if (pro){
			switch (nodeOwner.type){
				case 0:;
					var proPat=nodeOwner.property;
					var m=proPat.length-1;
					for (var j=0;j < m;j++){
						pro=pro[proPat[j]];
						if (!pro)
							break ;
					};
					var crossValue=srcValue+crossWeight *(desValue-srcValue);
					this._applyFloat(pro,proPat[m],nodeOwner,additive,weight,isFirstLayer,crossValue);
					break ;
				case 1:;
					var localPos=pro.localPosition;
					var position=Animator._tempVector30;
					var srcX=srcValue.x,srcY=srcValue.y,srcZ=srcValue.z;
					position.x=srcX+crossWeight *(desValue.x-srcX);
					position.y=srcY+crossWeight *(desValue.y-srcY);
					position.z=srcZ+crossWeight *(desValue.z-srcZ);
					this._applyPositionAndRotationEuler(nodeOwner,additive,weight,isFirstLayer,position,localPos);
					pro.localPosition=localPos;
					break ;
				case 2:;
					var localRot=pro.localRotation;
					var rotation=Animator._tempQuaternion0;
					Quaternion.lerp(srcValue,desValue,crossWeight,rotation);
					this._applyRotation(nodeOwner,additive,weight,isFirstLayer,rotation,localRot);
					pro.localRotation=localRot;
					break ;
				case 3:;
					var localSca=pro.localScale;
					var scale=Animator._tempVector30;
					Utils3D.scaleBlend(srcValue,desValue,crossWeight,scale);
					this._applyScale(nodeOwner,additive,weight,isFirstLayer,scale,localSca);
					pro.localScale=localSca;
					break ;
				case 4:;
					var localEuler=pro.localRotationEuler;
					var rotationEuler=Animator._tempVector30;
					srcX=srcValue.x,srcY=srcValue.y,srcZ=srcValue.z;
					rotationEuler.x=srcX+crossWeight *(desValue.x-srcX);
					rotationEuler.y=srcY+crossWeight *(desValue.y-srcY);
					rotationEuler.z=srcZ+crossWeight *(desValue.z-srcZ);
					this._applyPositionAndRotationEuler(nodeOwner,additive,weight,isFirstLayer,rotationEuler,localEuler);
					pro.localRotationEuler=localEuler;
					break ;
				}
			nodeOwner.updateMark=this._updateMark;
		}
	}

	/**
	*@private
	*/
	__proto._setClipDatasToNode=function(stateInfo,additive,weight,isFirstLayer){
		var nodes=stateInfo._clip._nodes;
		var nodeOwners=stateInfo._nodeOwners;
		for (var i=0,n=nodes.count;i < n;i++){
			var nodeOwner=nodeOwners[i];
			if (nodeOwner){
				var pro=nodeOwner.propertyOwner;
				if (pro){
					switch (nodeOwner.type){
						case 0:;
							var proPat=nodeOwner.property;
							var m=proPat.length-1;
							for (var j=0;j < m;j++){
								pro=pro[proPat[j]];
								if (!pro)
									break ;
							}
							this._applyFloat(pro,proPat[m],nodeOwner,additive,weight,isFirstLayer,nodes.getNodeByIndex(i).data);
							break ;
						case 1:;
							var localPos=pro.localPosition;
							this._applyPositionAndRotationEuler(nodeOwner,additive,weight,isFirstLayer,nodes.getNodeByIndex(i).data,localPos);
							pro.localPosition=localPos;
							break ;
						case 2:;
							var localRot=pro.localRotation;
							this._applyRotation(nodeOwner,additive,weight,isFirstLayer,nodes.getNodeByIndex(i).data,localRot);
							pro.localRotation=localRot;
							break ;
						case 3:;
							var localSca=pro.localScale;
							this._applyScale(nodeOwner,additive,weight,isFirstLayer,nodes.getNodeByIndex(i).data,localSca);
							pro.localScale=localSca;
							break ;
						case 4:;
							var localEuler=pro.localRotationEuler;
							this._applyPositionAndRotationEuler(nodeOwner,additive,weight,isFirstLayer,nodes.getNodeByIndex(i).data,localEuler);
							pro.localRotationEuler=localEuler;
							break ;
						}
					nodeOwner.updateMark=this._updateMark;
				}
			}
		}
	}

	/**
	*@private
	*/
	__proto._setCrossClipDatasToNode=function(controllerLayer,srcState,destState,crossWeight,isFirstLayer){
		var nodeOwners=controllerLayer._crossNodesOwners;
		var ownerCount=controllerLayer._crossNodesOwnersCount;
		var additive=controllerLayer.blendingMode!==AnimatorControllerLayer.BLENDINGMODE_OVERRIDE;
		var weight=controllerLayer.defaultWeight;
		var destDataIndices=controllerLayer._destCrossClipNodeIndices;
		var destNodes=destState._clip._nodes;
		var destNodeOwners=destState._nodeOwners;
		var srcDataIndices=controllerLayer._srcCrossClipNodeIndices;
		var srcNodeOwners=srcState._nodeOwners;
		var srcNodes=srcState._clip._nodes;
		for (var i=0;i < ownerCount;i++){
			var nodeOwner=nodeOwners[i];
			if (nodeOwner){
				var srcIndex=srcDataIndices[i];
				var destIndex=destDataIndices[i];
				var srcValue=srcIndex!==-1 ? srcNodes.getNodeByIndex(srcIndex).data :destNodeOwners[destIndex].defaultValue;
				var desValue=destIndex!==-1 ? destNodes.getNodeByIndex(destIndex).data :srcNodeOwners[srcIndex].defaultValue;
				this._applyCrossData(nodeOwner,additive,weight,isFirstLayer,srcValue,desValue,crossWeight);
			}
		}
	}

	/**
	*@private
	*/
	__proto._setFixedCrossClipDatasToNode=function(controllerLayer,destState,crossWeight,isFirstLayer){
		var nodeOwners=controllerLayer._crossNodesOwners;
		var ownerCount=controllerLayer._crossNodesOwnersCount;
		var additive=controllerLayer.blendingMode!==AnimatorControllerLayer.BLENDINGMODE_OVERRIDE;
		var weight=controllerLayer.defaultWeight;
		var destDataIndices=controllerLayer._destCrossClipNodeIndices;
		var destNodes=destState._clip._nodes;
		for (var i=0;i < ownerCount;i++){
			var nodeOwner=nodeOwners[i];
			if (nodeOwner){
				var destIndex=destDataIndices[i];
				var srcValue=nodeOwner.crossFixedValue;
				var desValue=destIndex!==-1 ? destNodes.getNodeByIndex(destIndex).data :nodeOwner.defaultValue;
				this._applyCrossData(nodeOwner,additive,weight,isFirstLayer,srcValue,desValue,crossWeight);
			}
		}
	}

	/**
	*@private
	*/
	__proto._revertDefaultKeyframeNodes=function(clipStateInfo){
		var nodeOwners=clipStateInfo._nodeOwners;
		for (var i=0,n=nodeOwners.length;i < n;i++){
			var nodeOwner=nodeOwners[i];
			if (nodeOwner){
				var pro=nodeOwner.propertyOwner;
				if (pro){
					switch (nodeOwner.type){
						case 0:;
							var proPat=nodeOwner.property;
							var m=proPat.length-1;
							for (var j=0;j < m;j++){
								pro=pro[proPat[j]];
								if (!pro)
									break ;
							}
						pro[proPat[m]]=nodeOwner.defaultValue;
							break ;
						case 1:;
							var locPos=pro.localPosition;
						var def=nodeOwner.defaultValue;
							locPos.x=def.x;
							locPos.y=def.y;
							locPos.z=def.z;
							pro.localPosition=locPos;
							break ;
						case 2:;
							var locRot=pro.localRotation;
						var defQua=nodeOwner.defaultValue;
							locRot.x=defQua.x;
							locRot.y=defQua.y;
							locRot.z=defQua.z;
							locRot.w=defQua.w;
							pro.localRotation=locRot;
							break ;
						case 3:;
							var locSca=pro.localScale;
						def=nodeOwner.defaultValue;
							locSca.x=def.x;
							locSca.y=def.y;
							locSca.z=def.z;
							pro.localScale=locSca;
							break ;
						case 4:;
							var locEul=pro.localRotationEuler;
						def=nodeOwner.defaultValue;
							locEul.x=def.x;
							locEul.y=def.y;
							locEul.z=def.z;
							pro.localRotationEuler=locEul;
							break ;
						default :
							throw "Animator:unknown type.";
						}
				}
			}
		}
	}

	/**
	*@private
	*/
	__proto._removeClip=function(clipStateInfos,statesMap,index,state){
		var clip=state._clip;
		clip._removeReference();
		clipStateInfos.splice(index,1);
		delete statesMap[state.name];
		var clipStateInfo=clipStateInfos[index];
		var frameNodes=clip._nodes;
		var nodeOwners=clipStateInfo._nodeOwners;
		for (var i=0,n=frameNodes.count;i < n;i++)
		this._removeKeyframeNodeOwner(nodeOwners,frameNodes.getNodeByIndex(i));
	}

	/**
	*@inheritDoc
	*/
	__proto._onAdded=function(){
		var parent=this.owner._parent;
		(this.owner)._setHierarchyAnimator(this,parent ? (parent)._hierarchyAnimator :null);
		(this.owner)._changeAnimatorToLinkSprite3DNoAvatar(this,true,/*new vector.<>*/[]);
	}

	/**
	*@inheritDoc
	*/
	__proto._onDestroy=function(){
		for (var i=0,n=this._controllerLayers.length;i < n;i++){
			var clipStateInfos=this._controllerLayers[i]._states;
			for (var j=0,m=clipStateInfos.length;j < m;j++)
			clipStateInfos[j]._clip._removeReference();
		};
		var parent=this.owner._parent;
		(this.owner)._clearHierarchyAnimator(this,parent ? (parent)._hierarchyAnimator :null);
	}

	/**
	*@inheritDoc
	*/
	__proto._onEnableInScene=function(){
		(this.owner._scene)._animatorPool.add(this);
	}

	/**
	*@inheritDoc
	*/
	__proto._onDisableInScene=function(){
		(this.owner._scene)._animatorPool.remove(this);
	}

	/**
	*@inheritDoc
	*/
	__proto._onEnable=function(){
		for (var i=0,n=this._controllerLayers.length;i < n;i++){
			if (this._controllerLayers[i].playOnWake){
				var defaultClip=this.getDefaultState(i);
				(defaultClip)&& (this.play(null,i,0));
			}
		}
	}

	/**
	*@private
	*/
	__proto._handleSpriteOwnersBySprite=function(isLink,path,sprite){
		for (var i=0,n=this._controllerLayers.length;i < n;i++){
			var clipStateInfos=this._controllerLayers[i]._states;
			for (var j=0,m=clipStateInfos.length;j < m;j++){
				var clipStateInfo=clipStateInfos[j];
				var clip=clipStateInfo._clip;
				var nodePath=path.join("/");
				var ownersNodes=clip._nodesMap[nodePath];
				if (ownersNodes){
					var nodeOwners=clipStateInfo._nodeOwners;
					for (var k=0,p=ownersNodes.length;k < p;k++){
						if (isLink)
							this._addKeyframeNodeOwner(nodeOwners,ownersNodes[k],sprite);
						else
						this._removeKeyframeNodeOwner(nodeOwners,ownersNodes[k]);
					}
				}
			}
		}
	}

	/**
	*@inheritDoc
	*/
	__proto._parse=function(data){
		var avatarData=data.avatar;
		if (avatarData){
			this.avatar=Loader.getRes(avatarData.path);
			var linkSprites=avatarData.linkSprites;
			this._linkSprites=linkSprites;
			this._linkToSprites(linkSprites);
		};
		var clipPaths=data.clipPaths;
		var play=data.playOnWake;
		var layersData=data.layers;
		for (var i=0;i < layersData.length;i++){
			var layerData=layersData[i];
			var animatorLayer=new AnimatorControllerLayer(layerData.name);
			if (i===0)
				animatorLayer.defaultWeight=1.0;
			else
			animatorLayer.defaultWeight=layerData.weight;
			var blendingModeData=layerData.blendingMode;
			(blendingModeData)&& (animatorLayer.blendingMode=blendingModeData);
			this.addControllerLayer(animatorLayer);
			var states=layerData.states;
			for (var j=0,m=states.length;j < m;j++){
				var state=states[j];
				var clipPath=state.clipPath;
				if (clipPath){
					var name=state.name;
					var motion;
					motion=Loader.getRes(clipPath);
					if (motion){
						var animatorState=new AnimatorState();
						animatorState.name=name;
						animatorState.clip=motion;
						this.addState(animatorState,i);
						(j===0)&& (this.getControllerLayer(i).defaultState=animatorState);
					}
				}
			}
			(play!==undefined)&& (animatorLayer.playOnWake=play);
		};
		var cullingModeData=data.cullingMode;
		(cullingModeData!==undefined)&& (this.cullingMode=cullingModeData);
	}

	/**
	*@private
	*/
	__proto._update=function(){
		if (this._speed===0)
			return;
		var needRender=false;
		if (this.cullingMode===2){
			needRender=false;
			for (var i=0,n=this._renderableSprites.length;i < n;i++){
				if (this._renderableSprites[i]._render._visible){
					needRender=true;
					break ;
				}
			}
			}else {
			needRender=true;
		}
		this._updateMark++;
		var timer=(this.owner._scene).timer;
		var delta=timer._delta / 1000.0;
		var timerScale=timer.scale;
		for (i=0,n=this._controllerLayers.length;i < n;i++){
			var controllerLayer=this._controllerLayers[i];
			var playStateInfo=controllerLayer._playStateInfo;
			var crossPlayStateInfo=controllerLayer._crossPlayStateInfo;
			addtive=controllerLayer.blendingMode!==AnimatorControllerLayer.BLENDINGMODE_OVERRIDE;
			switch (controllerLayer._playType){
				case 0:;
					var animatorState=controllerLayer._currentPlayState;
					var clip=animatorState._clip;
					var speed=this._speed *animatorState.speed;
					var finish=playStateInfo._finish;
					finish || this._updatePlayer(animatorState,playStateInfo,delta *speed,clip.islooping);
					if (needRender){
						var addtive=controllerLayer.blendingMode!==AnimatorControllerLayer.BLENDINGMODE_OVERRIDE;
						this._updateClipDatas(animatorState,addtive,playStateInfo,timerScale *speed);
					this._setClipDatasToNode(animatorState,addtive,controllerLayer.defaultWeight,i===0);
						finish || this._updateEventScript(animatorState,playStateInfo);
					}
					break ;
				case 1:
					animatorState=controllerLayer._currentPlayState;
					clip=animatorState._clip;
					var crossClipState=controllerLayer._crossPlayState;
					var crossClip=crossClipState._clip;
					var crossDuratuion=controllerLayer._crossDuration;
					var startPlayTime=crossPlayStateInfo._startPlayTime;
					var crossClipDuration=crossClip._duration-startPlayTime;
					var crossScale=crossDuratuion > crossClipDuration ? crossClipDuration / crossDuratuion :1.0;
					var crossSpeed=this._speed *crossClipState.speed;
					this._updatePlayer(crossClipState,crossPlayStateInfo,delta *crossScale *crossSpeed,crossClip.islooping);
					var crossWeight=((crossPlayStateInfo._elapsedTime-startPlayTime)/ crossScale)/ crossDuratuion;
					if (crossWeight >=1.0){
						if (needRender){
							this._updateClipDatas(crossClipState,addtive,crossPlayStateInfo,timerScale *crossSpeed);
						this._setClipDatasToNode(crossClipState,addtive,controllerLayer.defaultWeight,i===0);
							controllerLayer._playType=0;
							controllerLayer._currentPlayState=crossClipState;
							crossPlayStateInfo._cloneTo(playStateInfo);
						}
						}else {
						if (!playStateInfo._finish){
							speed=this._speed *animatorState.speed;
							this._updatePlayer(animatorState,playStateInfo,delta *speed,clip.islooping);
							if (needRender){
								this._updateClipDatas(animatorState,addtive,playStateInfo,timerScale *speed);
							}
						}
						if (needRender){
							this._updateClipDatas(crossClipState,addtive,crossPlayStateInfo,timerScale *crossScale *crossSpeed);
							this._setCrossClipDatasToNode(controllerLayer,animatorState,crossClipState,crossWeight,i===0);
						}
					}
					if (needRender){
						this._updateEventScript(animatorState,playStateInfo);
						this._updateEventScript(crossClipState,crossPlayStateInfo);
					}
					break ;
				case 2:
					crossClipState=controllerLayer._crossPlayState;
					crossClip=crossClipState._clip;
					crossDuratuion=controllerLayer._crossDuration;
					startPlayTime=crossPlayStateInfo._startPlayTime;
					crossClipDuration=crossClip._duration-startPlayTime;
					crossScale=crossDuratuion > crossClipDuration ? crossClipDuration / crossDuratuion :1.0;
					crossSpeed=this._speed *crossClipState.speed;
					this._updatePlayer(crossClipState,crossPlayStateInfo,delta *crossScale *crossSpeed,crossClip.islooping);
					if (needRender){
						crossWeight=((crossPlayStateInfo._elapsedTime-startPlayTime)/ crossScale)/ crossDuratuion;
						if (crossWeight >=1.0){
							this._updateClipDatas(crossClipState,addtive,crossPlayStateInfo,timerScale *crossSpeed);
							this._setClipDatasToNode(crossClipState,addtive,1.0,i===0);
							controllerLayer._playType=0;
							controllerLayer._currentPlayState=crossClipState;
							crossPlayStateInfo._cloneTo(playStateInfo);
							}else {
							this._updateClipDatas(crossClipState,addtive,crossPlayStateInfo,timerScale *crossScale *crossSpeed);
							this._setFixedCrossClipDatasToNode(controllerLayer,crossClipState,crossWeight,i===0);
						}
						this._updateEventScript(crossClipState,crossPlayStateInfo);
					}
					break ;
				}
		}
		if (needRender){
			if (this._avatar){
				Render.supportWebGLPlusAnimation && this._updateAnimationNodeWorldMatix(this._animationNodeLocalPositions,this._animationNodeLocalRotations,this._animationNodeLocalScales,this._animationNodeWorldMatrixs,this._animationNodeParentIndices);
				this._updateAvatarNodesToSprite();
			}
		}
	}

	/**
	*@private
	*/
	__proto._cloneTo=function(dest){
		var animator=dest;
		animator.avatar=this.avatar;
		for (var i=0,n=this._controllerLayers.length;i < n;i++){
			var controllLayer=this._controllerLayers[i];
			animator.addControllerLayer(controllLayer.clone());
			var animatorStates=controllLayer._states;
			for (var j=0,m=animatorStates.length;j < m;j++){
				var state=animatorStates[j].clone();
				animator.addState(state,i);
				(j==0)&& (animator.getControllerLayer(i).defaultState=state);
			}
		}
		animator._linkSprites=this._linkSprites;
		animator._linkToSprites(this._linkSprites);
	}

	/**
	*获取默认动画状态。
	*@param layerIndex 层索引。
	*@return 默认动画状态。
	*/
	__proto.getDefaultState=function(layerIndex){
		(layerIndex===void 0)&& (layerIndex=0);
		var controllerLayer=this._controllerLayers[layerIndex];
		return controllerLayer.defaultState;
	}

	/**
	*添加动画状态。
	*@param state 动画状态。
	*@param layerIndex 层索引。
	*/
	__proto.addState=function(state,layerIndex){
		(layerIndex===void 0)&& (layerIndex=0);
		var stateName=state.name;
		var controllerLayer=this._controllerLayers[layerIndex];
		var statesMap=controllerLayer._statesMap;
		var states=controllerLayer._states;
		if (statesMap[stateName]){
			throw "Animator:this stat's name has exist.";
			}else {
			statesMap[stateName]=state;
			states.push(state);
			state._clip._addReference();
			this._getOwnersByClip(state);
		}
	}

	/**
	*移除动画状态。
	*@param state 动画状态。
	*@param layerIndex 层索引。
	*/
	__proto.removeState=function(state,layerIndex){
		(layerIndex===void 0)&& (layerIndex=0);
		var controllerLayer=this._controllerLayers[layerIndex];
		var clipStateInfos=controllerLayer._states;
		var statesMap=controllerLayer._statesMap;
		var index=-1;
		for (var i=0,n=clipStateInfos.length;i < n;i++){
			if (clipStateInfos[i]===state){
				index=i;
				break ;
			}
		}
		if (index!==-1)
			this._removeClip(clipStateInfos,statesMap,index,state);
	}

	/**
	*添加控制器层。
	*/
	__proto.addControllerLayer=function(controllderLayer){
		this._controllerLayers.push(controllderLayer);
	}

	/**
	*获取控制器层。
	*/
	__proto.getControllerLayer=function(layerInex){
		(layerInex===void 0)&& (layerInex=0);
		return this._controllerLayers[layerInex];
	}

	/**
	*获取当前的播放状态。
	*@param layerIndex 层索引。
	*@return 动画播放状态。
	*/
	__proto.getCurrentAnimatorPlayState=function(layerInex){
		(layerInex===void 0)&& (layerInex=0);
		return this._controllerLayers[layerInex]._playStateInfo;
	}

	/**
	*播放动画。
	*@param name 如果为null则播放默认动画，否则按名字播放动画片段。
	*@param layerIndex 层索引。
	*@param normalizedTime 归一化的播放起始时间。
	*/
	__proto.play=function(name,layerIndex,normalizedTime){
		(layerIndex===void 0)&& (layerIndex=0);
		(normalizedTime===void 0)&& (normalizedTime=Number.NEGATIVE_INFINITY);
		var controllerLayer=this._controllerLayers[layerIndex];
		var defaultState=controllerLayer.defaultState;
		if (!name && !defaultState)
			throw new Error("Animator:must have  default clip value,please set clip property.");
		var curPlayState=controllerLayer._currentPlayState;
		var playStateInfo=controllerLayer._playStateInfo;
		var animatorState=name ? controllerLayer._statesMap[name] :defaultState;
		var clipDuration=animatorState._clip._duration;
		if (curPlayState!==animatorState){
			if (normalizedTime!==Number.NEGATIVE_INFINITY)
				playStateInfo._resetPlayState(clipDuration *normalizedTime);
			else
			playStateInfo._resetPlayState(0.0);
			(curPlayState!==null && curPlayState!==animatorState)&& (this._revertDefaultKeyframeNodes(curPlayState));
			controllerLayer._playType=0;
			controllerLayer._currentPlayState=animatorState;
			}else {
			if (normalizedTime!==Number.NEGATIVE_INFINITY){
				playStateInfo._resetPlayState(clipDuration *normalizedTime);
				controllerLayer._playType=0;
			}
		};
		var scripts=animatorState._scripts;
		if (scripts){
			for (var i=0,n=scripts.length;i < n;i++)
			scripts[i].onStateEnter();
		}
	}

	/**
	*在当前动画状态和目标动画状态之间进行融合过渡播放。
	*@param name 目标动画状态。
	*@param transitionDuration 过渡时间,该值为当前动画状态的归一化时间，值在0.0~1.0之间。
	*@param layerIndex 层索引。
	*@param normalizedTime 归一化的播放起始时间。
	*/
	__proto.crossFade=function(name,transitionDuration,layerIndex,normalizedTime){
		(layerIndex===void 0)&& (layerIndex=0);
		(normalizedTime===void 0)&& (normalizedTime=Number.NEGATIVE_INFINITY);
		var controllerLayer=this._controllerLayers[layerIndex];
		var destAnimatorState=controllerLayer._statesMap[name];
		if (destAnimatorState){
			var playType=controllerLayer._playType;
			if (playType===-1){
				this.play(name,layerIndex,normalizedTime);
				return;
			};
			var crossPlayStateInfo=controllerLayer._crossPlayStateInfo;
			var crossNodeOwners=controllerLayer._crossNodesOwners;
			var crossNodeOwnerIndicesMap=controllerLayer._crossNodesOwnersIndicesMap;
			var srcAnimatorState=controllerLayer._currentPlayState;
			var destNodeOwners=destAnimatorState._nodeOwners;
			var destCrossClipNodeIndices=controllerLayer._destCrossClipNodeIndices;
			var destClip=destAnimatorState._clip;
			var destNodes=destClip._nodes;
			var destNodesMap=destClip._nodesDic;
			switch (playType){
				case 0:;
					var srcNodeOwners=srcAnimatorState._nodeOwners;
					var scrCrossClipNodeIndices=controllerLayer._srcCrossClipNodeIndices;
					var srcClip=srcAnimatorState._clip;
					var srcNodes=srcClip._nodes;
					var srcNodesMap=srcClip._nodesDic;
					controllerLayer._playType=1;
					var crossMark=++controllerLayer._crossMark;
					var crossCount=controllerLayer._crossNodesOwnersCount=0;
					for (var i=0,n=srcNodes.count;i < n;i++){
						var srcNode=srcNodes.getNodeByIndex(i);
						var srcIndex=srcNode._indexInList;
						var srcNodeOwner=srcNodeOwners[srcIndex];
						if (srcNodeOwner){
							var srcFullPath=srcNode.fullPath;
							scrCrossClipNodeIndices[crossCount]=srcIndex;
							var destNode=destNodesMap[srcFullPath];
							if (destNode)
								destCrossClipNodeIndices[crossCount]=destNode._indexInList;
							else
							destCrossClipNodeIndices[crossCount]=-1;
							crossNodeOwnerIndicesMap[srcFullPath]=crossMark;
							crossNodeOwners[crossCount]=srcNodeOwner;
							crossCount++;
						}
					}
					for (i=0,n=destNodes.count;i < n;i++){
						destNode=destNodes.getNodeByIndex(i);
						var destIndex=destNode._indexInList;
						var destNodeOwner=destNodeOwners[destIndex];
						if (destNodeOwner){
							var destFullPath=destNode.fullPath;
							if (!srcNodesMap[destFullPath]){
								scrCrossClipNodeIndices[crossCount]=-1;
								destCrossClipNodeIndices[crossCount]=destIndex;
								crossNodeOwnerIndicesMap[destFullPath]=crossMark;
								crossNodeOwners[crossCount]=destNodeOwner;
								crossCount++;
							}
						}
					}
					break ;
				case 1:
				case 2:
					controllerLayer._playType=2;
					for (i=0,n=crossNodeOwners.length;i < n;i++){
						var nodeOwner=crossNodeOwners[i];
						nodeOwner.saveCrossFixedValue();
						destNode=destNodesMap[nodeOwner.fullPath];
						if (destNode)
							destCrossClipNodeIndices[i]=destNode._indexInList;
						else
						destCrossClipNodeIndices[i]=-1;
					}
					crossCount=controllerLayer._crossNodesOwnersCount;
					crossMark=controllerLayer._crossMark;
					for (i=0,n=destNodes.count;i < n;i++){
						destNode=destNodes.getNodeByIndex(i);
						destIndex=destNode._indexInList;
						destNodeOwner=destNodeOwners[destIndex];
						if (destNodeOwner){
							destFullPath=destNode.fullPath;
							if (crossNodeOwnerIndicesMap[destFullPath]!==crossMark){
								destCrossClipNodeIndices[crossCount]=destIndex;
								crossNodeOwnerIndicesMap[destFullPath]=crossMark;
								nodeOwner=destNodeOwners[destIndex];
								crossNodeOwners[crossCount]=nodeOwner;
								nodeOwner.saveCrossFixedValue();
								crossCount++;
							}
						}
					}
					break ;
				default :
				}
			controllerLayer._crossNodesOwnersCount=crossCount;
			controllerLayer._crossPlayState=destAnimatorState;
			controllerLayer._crossDuration=srcAnimatorState._clip._duration *transitionDuration;
			if (normalizedTime!==Number.NEGATIVE_INFINITY)
				crossPlayStateInfo._resetPlayState(destClip._duration *normalizedTime);
			else
			crossPlayStateInfo._resetPlayState(0.0);
		};
		var scripts=destAnimatorState._scripts;
		if (scripts){
			for (i=0,n=scripts.length;i < n;i++)
			scripts[i].onStateEnter();
		}
	}

	/**
	*@private
	*/
	__proto._getAvatarOwnersAndInitDatasAsync=function(){
		for (var i=0,n=this._controllerLayers.length;i < n;i++){
			var clipStateInfos=this._controllerLayers[i]._states;
			for (var j=0,m=clipStateInfos.length;j < m;j++)
			this._getOwnersByClip(clipStateInfos[j]);
		}
		this._avatar._cloneDatasToAnimator(this);
		for (var k in this._linkAvatarSpritesData){
			var sprites=this._linkAvatarSpritesData[k];
			if (sprites){
				for (var c=0,p=sprites.length;c < p;c++)
				this._isLinkSpriteToAnimationNode(sprites[c],k,true);
			}
		}
	}

	/**
	*@private
	*/
	__proto._isLinkSpriteToAnimationNode=function(sprite,nodeName,isLink){
		if (this._avatar){
			var node=this._avatarNodeMap[nodeName];
			if (node){
				if (isLink){
					sprite._transform._dummy=node.transform;
					this._linkAvatarSprites.push(sprite);
					var nodeTransform=node.transform;
					var spriteTransform=sprite.transform;
					if (!spriteTransform.owner.isStatic && nodeTransform){
						var spriteWorldMatrix=spriteTransform.worldMatrix;
						var ownParTra=(this.owner)._transform._parent;
						if (ownParTra){
							Utils3D.matrix4x4MultiplyMFM(ownParTra.worldMatrix,nodeTransform.getWorldMatrix(),spriteWorldMatrix);
							}else {
							var sprWorE=spriteWorldMatrix.elements;
							var nodWorE=nodeTransform.getWorldMatrix();
							for (var i=0;i < 16;i++)
							sprWorE[i]=nodWorE[i];
						}
						spriteTransform.worldMatrix=spriteWorldMatrix;
					}
					}else {
					sprite._transform._dummy=null;
					this._linkAvatarSprites.splice(this._linkAvatarSprites.indexOf(sprite),1);
				}
			}
		}
	}

	/**
	*@private
	*/
	__proto._isLinkSpriteToAnimationNodeData=function(sprite,nodeName,isLink){
		var linkSprites=this._linkAvatarSpritesData[nodeName];
		if (isLink){
			linkSprites || (this._linkAvatarSpritesData[nodeName]=linkSprites=[]);
			linkSprites.push(sprite);
			}else {
			linkSprites.splice(sprite,1);
		}
	}

	/**
	*@private
	*/
	__proto._updateAvatarNodesToSprite=function(){
		for (var i=0,n=this._linkAvatarSprites.length;i < n;i++){
			var sprite=this._linkAvatarSprites[i];
			var nodeTransform=sprite.transform._dummy;
			var spriteTransform=sprite.transform;
			if (!spriteTransform.owner.isStatic && nodeTransform){
				var spriteWorldMatrix=spriteTransform.worldMatrix;
				var ownTra=(this.owner)._transform;
				Utils3D.matrix4x4MultiplyMFM(ownTra.worldMatrix,nodeTransform.getWorldMatrix(),spriteWorldMatrix);
				spriteTransform.worldMatrix=spriteWorldMatrix;
			}
		}
	}

	/**
	*关联精灵节点到Avatar节点,此Animator必须有Avatar文件。
	*@param nodeName 关联节点的名字。
	*@param sprite3D 精灵节点。
	*@return 是否关联成功。
	*/
	__proto.linkSprite3DToAvatarNode=function(nodeName,sprite3D){
		this._isLinkSpriteToAnimationNodeData(sprite3D,nodeName,true);
		this._isLinkSpriteToAnimationNode(sprite3D,nodeName,true);
		return true;
	}

	/**
	*解除精灵节点到Avatar节点的关联,此Animator必须有Avatar文件。
	*@param sprite3D 精灵节点。
	*@return 是否解除关联成功。
	*/
	__proto.unLinkSprite3DToAvatarNode=function(sprite3D){
		if (sprite3D._hierarchyAnimator===this){
			var dummy=sprite3D.transform._dummy;
			if (dummy){
				var nodeName=dummy._owner.name;
				this._isLinkSpriteToAnimationNodeData(sprite3D,nodeName,false);
				this._isLinkSpriteToAnimationNode(sprite3D,nodeName,false);
				return true;
				}else {
				return false;
			}
			}else {
			throw("Animator:sprite3D must belong to this Animator");
			return false;
		}
	}

	/**
	*@private
	*[NATIVE]
	*/
	__proto._updateAnimationNodeWorldMatix=function(localPositions,localRotations,localScales,worldMatrixs,parentIndices){
		LayaGL.instance.updateAnimationNodeWorldMatix(localPositions,localRotations,localScales,parentIndices,worldMatrixs);
	}

	/**
	*设置动画的播放速度,1.0为正常播放速度。
	*@param 动画的播放速度。
	*/
	/**
	*获取动画的播放速度,1.0为正常播放速度。
	*@return 动画的播放速度。
	*/
	__getset(0,__proto,'speed',function(){
		return this._speed;
		},function(value){
		this._speed=value;
	});

	/**
	*设置avatar。
	*@param value avatar。
	*/
	/**
	*获取avatar。
	*@return avator。
	*/
	__getset(0,__proto,'avatar',function(){
		return this._avatar;
		},function(value){
		if (this._avatar!==value){
			this._avatar=value;
			if (value){
				this._getAvatarOwnersAndInitDatasAsync();
				(this.owner)._changeHierarchyAnimatorAvatar(this,value);
				}else {
				var parent=this.owner._parent;
				(this.owner)._changeHierarchyAnimatorAvatar(this,parent ? (parent)._hierarchyAnimator._avatar :null);
			}
		}
	});

	Animator._update=function(scene){
		var pool=scene._animatorPool;
		var elements=pool.elements;
		for (var i=0,n=pool.length;i < n;i++){
			var animator=elements[i];
			(animator && animator.enabled)&& (animator._update());
		}
	}

	Animator._tempVector3Array0=new Float32Array(3);
	Animator._tempVector3Array1=new Float32Array(3);
	Animator._tempQuaternionArray0=new Float32Array(4);
	Animator._tempQuaternionArray1=new Float32Array(4);
	Animator.CULLINGMODE_ALWAYSANIMATE=0;
	Animator.CULLINGMODE_CULLCOMPLETELY=2;
	__static(Animator,
	['_tempVector30',function(){return this._tempVector30=new Vector3();},'_tempVector31',function(){return this._tempVector31=new Vector3();},'_tempQuaternion0',function(){return this._tempQuaternion0=new Quaternion();},'_tempQuaternion1',function(){return this._tempQuaternion1=new Quaternion();}
	]);
	return Animator;
})(Component)


/**
*<code>AnimationTransform3D</code> 类用于实现3D变换。
*/
//class laya.d3.animation.AnimationTransform3D extends laya.events.EventDispatcher
var AnimationTransform3D=(function(_super){
	function AnimationTransform3D(owner,localPosition,localRotation,localScale,worldMatrix){
		/**@private */
		//this._localMatrix=null;
		/**@private */
		//this._worldMatrix=null;
		/**@private */
		//this._localPosition=null;
		/**@private */
		//this._localRotation=null;
		/**@private */
		//this._localScale=null;
		/**@private */
		//this._localQuaternionUpdate=false;
		/**@private */
		//this._locaEulerlUpdate=false;
		/**@private */
		//this._localUpdate=false;
		/**@private */
		//this._parent=null;
		/**@private */
		//this._children=null;
		/**@private */
		//this._localRotationEuler=null;
		/**@private */
		//this._owner=null;
		/**@private */
		//this._worldUpdate=false;
		AnimationTransform3D.__super.call(this);
		this._owner=owner;
		this._children=[];
		this._localMatrix=new Float32Array(16);
		if (Render.supportWebGLPlusAnimation){
			/*__JS__ */this._localPosition=new ConchVector3(0,0,0,localPosition);
			/*__JS__ */this._localRotation=new ConchQuaternion(0,0,0,1,localRotation);
			/*__JS__ */this._localScale=new ConchVector3(0,0,0,localScale);
			this._worldMatrix=worldMatrix;
			}else {
			this._localPosition=new Vector3();
			this._localRotation=new Quaternion();
			this._localScale=new Vector3();
			this._worldMatrix=new Float32Array(16);
		}
		this._localQuaternionUpdate=false;
		this._locaEulerlUpdate=false;
		this._localUpdate=false;
		this._worldUpdate=true;
	}

	__class(AnimationTransform3D,'laya.d3.animation.AnimationTransform3D',_super);
	var __proto=AnimationTransform3D.prototype;
	/**
	*@private
	*/
	__proto._getlocalMatrix=function(){
		if (this._localUpdate){
			Utils3D._createAffineTransformationArray(this._localPosition,this._localRotation,this._localScale,this._localMatrix);
			this._localUpdate=false;
		}
		return this._localMatrix;
	}

	/**
	*@private
	*/
	__proto._onWorldTransform=function(){
		if (!this._worldUpdate){
			this._worldUpdate=true;
			this.event(/*laya.events.Event.TRANSFORM_CHANGED*/"transformchanged");
			for (var i=0,n=this._children.length;i < n;i++)
			this._children[i]._onWorldTransform();
		}
	}

	/**
	*获取世界矩阵。
	*@return 世界矩阵。
	*/
	__proto.getWorldMatrix=function(){
		if (!Render.supportWebGLPlusAnimation && this._worldUpdate){
			if (this._parent !=null){
				Utils3D.matrix4x4MultiplyFFF(this._parent.getWorldMatrix(),this._getlocalMatrix(),this._worldMatrix);
				}else {
				var e=this._worldMatrix;
				e[1]=e[2]=e[3]=e[4]=e[6]=e[7]=e[8]=e[9]=e[11]=e[12]=e[13]=e[14]=0;
				e[0]=e[5]=e[10]=e[15]=1;
			}
			this._worldUpdate=false;
		}
		if (Render.supportWebGLPlusAnimation && this._worldUpdate){
			this._worldUpdate=false;
		}
		return this._worldMatrix;
	}

	/**
	*设置父3D变换。
	*@param value 父3D变换。
	*/
	__proto.setParent=function(value){
		if (this._parent!==value){
			if (this._parent){
				var parentChilds=this._parent._children;
				var index=parentChilds.indexOf(this);
				parentChilds.splice(index,1);
			}
			if (value){
				value._children.push(this);
				(value)&& (this._onWorldTransform());
			}
			this._parent=value;
		}
	}

	/**
	*@private
	*/
	/**
	*@private
	*/
	__getset(0,__proto,'localPosition',function(){
		return this._localPosition;
		},function(value){
		this._localPosition=value;
		this._localUpdate=true;
		this._onWorldTransform();
	});

	/*
	*@private
	*/
	/**
	*@private
	*/
	__getset(0,__proto,'localRotation',function(){
		if (this._localQuaternionUpdate){
			var euler=this._localRotationEuler;
			Quaternion.createFromYawPitchRoll(euler.y / AnimationTransform3D._angleToRandin,euler.x / AnimationTransform3D._angleToRandin,euler.z / AnimationTransform3D._angleToRandin,this._localRotation);
			this._localQuaternionUpdate=false;
		}
		return this._localRotation;
		},function(value){
		this._localRotation=value;
		this._locaEulerlUpdate=true;
		this._localQuaternionUpdate=false;
		this._localUpdate=true;
		this._onWorldTransform();
	});

	/**
	*@private
	*/
	/**
	*@private
	*/
	__getset(0,__proto,'localScale',function(){
		return this._localScale;
		},function(value){
		this._localScale=value;
		this._localUpdate=true;
		this._onWorldTransform();
	});

	/**
	*@private
	*/
	/**
	*@private
	*/
	__getset(0,__proto,'localRotationEuler',function(){
		if (this._locaEulerlUpdate){
			this._localRotation.getYawPitchRoll(AnimationTransform3D._tempVector3);
			var euler=AnimationTransform3D._tempVector3;
			var localRotationEuler=this._localRotationEuler;
			localRotationEuler.x=euler.y *AnimationTransform3D._angleToRandin;
			localRotationEuler.y=euler.x *AnimationTransform3D._angleToRandin;
			localRotationEuler.z=euler.z *AnimationTransform3D._angleToRandin;
			this._locaEulerlUpdate=false;
		}
		return this._localRotationEuler;
		},function(value){
		this._localRotationEuler=value;
		this._locaEulerlUpdate=false;
		this._localQuaternionUpdate=true;
		this._localUpdate=true;
		this._onWorldTransform();
	});

	__static(AnimationTransform3D,
	['_tempVector3',function(){return this._tempVector3=new Vector3();},'_angleToRandin',function(){return this._angleToRandin=180 / Math.PI;}
	]);
	return AnimationTransform3D;
})(EventDispatcher)


/**
*<code>VertexBuffer3D</code> 类用于创建顶点缓冲。
*/
//class laya.d3.graphics.VertexBuffer3D extends laya.webgl.utils.Buffer
var VertexBuffer3D=(function(_super){
	function VertexBuffer3D(byteLength,bufferUsage,canRead,dateType){
		/**@private */
		this._vertexCount=0;
		/**@private */
		this._canRead=false;
		/**@private */
		this._dataType=0;
		/**@private */
		this._vertexDeclaration=null;
		(canRead===void 0)&& (canRead=false);
		(dateType===void 0)&& (dateType=0);
		VertexBuffer3D.__super.call(this);
		this._vertexCount=-1;
		this._bufferUsage=bufferUsage;
		this._bufferType=/*laya.webgl.WebGLContext.ARRAY_BUFFER*/0x8892;
		this._canRead=canRead;
		this._dataType=dateType;
		this._byteLength=byteLength;
		this.bind();
		LayaGL.instance.bufferData(this._bufferType,this._byteLength,this._bufferUsage);
		if (canRead){
			switch (dateType){
				case 0:
					this._buffer=new Float32Array(byteLength / 4);
					break ;
				case 1:
					this._buffer=new Uint8Array(byteLength);
					break ;
				}
		}
	}

	__class(VertexBuffer3D,'laya.d3.graphics.VertexBuffer3D',_super);
	var __proto=VertexBuffer3D.prototype;
	/**
	*@inheritDoc
	*/
	__proto.bind=function(){
		if (Buffer._bindedVertexBuffer!==this._glBuffer){
			LayaGL.instance.bindBuffer(/*laya.webgl.WebGLContext.ARRAY_BUFFER*/0x8892,this._glBuffer);
			Buffer._bindedVertexBuffer=this._glBuffer;
			return true;
			}else {
			return false;
		}
	}

	/**
	*设置数据。
	*@param data 顶点数据。
	*@param bufferOffset 顶点缓冲中的偏移。
	*@param dataStartIndex 顶点数据的偏移。
	*@param dataCount 顶点数据的数量。
	*/
	__proto.setData=function(data,bufferOffset,dataStartIndex,dataCount){
		(bufferOffset===void 0)&& (bufferOffset=0);
		(dataStartIndex===void 0)&& (dataStartIndex=0);
		(dataCount===void 0)&& (dataCount=4294967295);
		this.bind();
		var needSubData=dataStartIndex!==0 || dataCount!==4294967295;
		if (needSubData){
			switch (this._dataType){
				case 0:
					data=new Float32Array(data.buffer,dataStartIndex *4,dataCount);
					break ;
				case 1:
					data=new Uint8Array(data.buffer,dataStartIndex,dataCount);
					break ;
				}
		}
		switch (this._dataType){
			case 0:
				LayaGL.instance.bufferSubData(this._bufferType,bufferOffset *4,data);
				break ;
			case 1:
				LayaGL.instance.bufferSubData(this._bufferType,bufferOffset,data);
				break ;
			}
		if (this._canRead)
			this._buffer.set(data,bufferOffset);
	}

	/**
	*获取顶点数据。
	*@return 顶点数据。
	*/
	__proto.getData=function(){
		if (this._canRead)
			return this._buffer;
		else
		throw new Error("Can't read data from VertexBuffer with only write flag!");
	}

	/**
	*@inheritDoc
	*/
	__proto.destroy=function(){
		_super.prototype.destroy.call(this);
		this._buffer=null;
		this._vertexDeclaration=null;
	}

	/**
	*获取顶点声明。
	*/
	/**
	*获取顶点声明。
	*/
	__getset(0,__proto,'vertexDeclaration',function(){
		return this._vertexDeclaration;
		},function(value){
		if (this._vertexDeclaration!==value){
			this._vertexDeclaration=value;
			this._vertexCount=value ? this._byteLength / value.vertexStride :-1;
		}
	});

	/**
	*获取顶点个数。
	*@return 顶点个数。
	*/
	__getset(0,__proto,'vertexCount',function(){
		return this._vertexCount;
	});

	/**
	*获取是否可读。
	*@return 是否可读。
	*/
	__getset(0,__proto,'canRead',function(){
		return this._canRead;
	});

	VertexBuffer3D.DATATYPE_FLOAT32ARRAY=0;
	VertexBuffer3D.DATATYPE_UINT8ARRAY=1;
	return VertexBuffer3D;
})(Buffer)


/**
*<code>ConstraintComponent</code> 类用于创建约束的父类。
*/
//class laya.d3.physics.constraints.ConstraintComponent extends laya.components.Component
var ConstraintComponent=(function(_super){
	function ConstraintComponent(){
		/**@private */
		this._nativeConstraint=null;
		/**@private */
		this._breakingImpulseThreshold=NaN;
		/**@private */
		this._connectedBody=null;
		/**@private */
		this._feedbackEnabled=false;
		ConstraintComponent.__super.call(this);
	}

	__class(ConstraintComponent,'laya.d3.physics.constraints.ConstraintComponent',_super);
	var __proto=ConstraintComponent.prototype;
	/**
	*@inheritDoc
	*/
	__proto._onDestroy=function(){
		var physics3D=Laya3D._physics3D;
		physics3D.destroy(this._nativeConstraint);
		this._nativeConstraint=null;
	}

	/**
	*设置打破冲力阈值。
	*@param value 打破冲力阈值。
	*/
	/**
	*获取打破冲力阈值。
	*@return 打破冲力阈值。
	*/
	__getset(0,__proto,'breakingImpulseThreshold',function(){
		return this._breakingImpulseThreshold;
		},function(value){
		this._nativeConstraint.BreakingImpulseThreshold=value;
		this._breakingImpulseThreshold=value;
	});

	/**
	*@inheritDoc
	*/
	/**
	*@inheritDoc
	*/
	__getset(0,__proto,'enabled',function(){
		return Laya.superGet(Component,this,'enabled');
		},function(value){
		this._nativeConstraint.IsEnabled=value;
		Laya.superSet(Component,this,'enabled',value);
	});

	/**
	*获取应用的冲力。
	*/
	__getset(0,__proto,'appliedImpulse',function(){
		if (!this._feedbackEnabled){
			this._nativeConstraint.EnableFeedback(true);
			this._feedbackEnabled=true;
		}
		return this._nativeConstraint.AppliedImpulse;
	});

	/**
	*设置已连接刚体。
	*@param value 已连接刚体。
	*/
	/**
	*获取已连接的刚体。
	*@return 已连接刚体。
	*/
	__getset(0,__proto,'connectedBody',function(){
		return this._connectedBody;
		},function(value){
		this._connectedBody=value;
	});

	return ConstraintComponent;
})(Component)


/**
*<code>IndexBuffer3D</code> 类用于创建索引缓冲。
*/
//class laya.d3.graphics.IndexBuffer3D extends laya.webgl.utils.Buffer
var IndexBuffer3D=(function(_super){
	function IndexBuffer3D(indexType,indexCount,bufferUsage,canRead){
		/**@private */
		this._indexType=null;
		/**@private */
		this._indexTypeByteCount=0;
		/**@private */
		this._indexCount=0;
		/**@private */
		this._canRead=false;
		(bufferUsage===void 0)&& (bufferUsage=0x88E4);
		(canRead===void 0)&& (canRead=false);
		IndexBuffer3D.__super.call(this);
		this._indexType=indexType;
		this._indexCount=indexCount;
		this._bufferUsage=bufferUsage;
		this._bufferType=/*laya.webgl.WebGLContext.ELEMENT_ARRAY_BUFFER*/0x8893;
		this._canRead=canRead;
		var byteLength=0;
		if (indexType==/*CLASS CONST:laya.d3.graphics.IndexBuffer3D.INDEXTYPE_USHORT*/"ushort")
			this._indexTypeByteCount=2;
		else if (indexType==/*CLASS CONST:laya.d3.graphics.IndexBuffer3D.INDEXTYPE_UBYTE*/"ubyte")
		this._indexTypeByteCount=1;
		else
		throw new Error("unidentification index type.");
		byteLength=this._indexTypeByteCount *indexCount;
		this._byteLength=byteLength;
		var curBufSta=BufferStateBase._curBindedBufferState;
		if (curBufSta){
			if (curBufSta._bindedIndexBuffer===this){
				LayaGL.instance.bufferData(this._bufferType,byteLength,this._bufferUsage);
				}else {
				curBufSta.unBind();
				this.bind();
				LayaGL.instance.bufferData(this._bufferType,byteLength,this._bufferUsage);
				curBufSta.bind();
			}
			}else {
			this.bind();
			LayaGL.instance.bufferData(this._bufferType,byteLength,this._bufferUsage);
		}
		if (canRead){
			if (indexType==/*CLASS CONST:laya.d3.graphics.IndexBuffer3D.INDEXTYPE_USHORT*/"ushort")
				this._buffer=new Uint16Array(indexCount);
			else if (indexType==/*CLASS CONST:laya.d3.graphics.IndexBuffer3D.INDEXTYPE_UBYTE*/"ubyte")
			this._buffer=new Uint8Array(indexCount);
		}
	}

	__class(IndexBuffer3D,'laya.d3.graphics.IndexBuffer3D',_super);
	var __proto=IndexBuffer3D.prototype;
	/**
	*@inheritDoc
	*/
	__proto._bindForVAO=function(){
		if (BufferStateBase._curBindedBufferState){
			LayaGL.instance.bindBuffer(/*laya.webgl.WebGLContext.ELEMENT_ARRAY_BUFFER*/0x8893,this._glBuffer);
			}else {
			throw "IndexBuffer3D: must bind current BufferState.";
		}
	}

	/**
	*@inheritDoc
	*/
	__proto.bind=function(){
		if (BufferStateBase._curBindedBufferState){
			throw "IndexBuffer3D: must unbind current BufferState.";
			}else {
			if (Buffer._bindedIndexBuffer!==this._glBuffer){
				LayaGL.instance.bindBuffer(/*laya.webgl.WebGLContext.ELEMENT_ARRAY_BUFFER*/0x8893,this._glBuffer);
				Buffer._bindedIndexBuffer=this._glBuffer;
				return true;
				}else {
				return false;
			}
		}
	}

	/**
	*设置数据。
	*@param data 索引数据。
	*@param bufferOffset 索引缓冲中的偏移。
	*@param dataStartIndex 索引数据的偏移。
	*@param dataCount 索引数据的数量。
	*/
	__proto.setData=function(data,bufferOffset,dataStartIndex,dataCount){
		(bufferOffset===void 0)&& (bufferOffset=0);
		(dataStartIndex===void 0)&& (dataStartIndex=0);
		(dataCount===void 0)&& (dataCount=4294967295);
		var byteCount=0;
		if (this._indexType==/*CLASS CONST:laya.d3.graphics.IndexBuffer3D.INDEXTYPE_USHORT*/"ushort"){
			byteCount=2;
			if (dataStartIndex!==0 || dataCount!==4294967295)
				data=new Uint16Array(data.buffer,dataStartIndex *byteCount,dataCount);
			}else if (this._indexType==/*CLASS CONST:laya.d3.graphics.IndexBuffer3D.INDEXTYPE_UBYTE*/"ubyte"){
			byteCount=1;
			if (dataStartIndex!==0 || dataCount!==4294967295)
				data=new Uint8Array(data.buffer,dataStartIndex *byteCount,dataCount);
		};
		var curBufSta=BufferStateBase._curBindedBufferState;
		if (curBufSta){
			if (curBufSta._bindedIndexBuffer===this){
				LayaGL.instance.bufferSubData(this._bufferType,bufferOffset *byteCount,data);
				}else {
				curBufSta.unBind();
				this.bind();
				LayaGL.instance.bufferSubData(this._bufferType,bufferOffset *byteCount,data);
				curBufSta.bind();
			}
			}else {
			this.bind();
			LayaGL.instance.bufferSubData(this._bufferType,bufferOffset *byteCount,data);
		}
		if (this._canRead){
			if (bufferOffset!==0 || dataStartIndex!==0 || dataCount!==4294967295){
				var maxLength=this._buffer.length-bufferOffset;
				if (dataCount > maxLength)
					dataCount=maxLength;
				for (var i=0;i < dataCount;i++)
				this._buffer[bufferOffset+i]=data[i];
				}else {
				this._buffer=data;
			}
		}
	}

	/**
	*获取索引数据。
	*@return 索引数据。
	*/
	__proto.getData=function(){
		if (this._canRead)
			return this._buffer;
		else
		throw new Error("Can't read data from VertexBuffer with only write flag!");
	}

	/**
	*@inheritDoc
	*/
	__proto.destroy=function(){
		_super.prototype.destroy.call(this);
		this._buffer=null;
	}

	/**
	*获取索引类型。
	*@return 索引类型。
	*/
	__getset(0,__proto,'indexType',function(){
		return this._indexType;
	});

	/**
	*获取索引类型字节数量。
	*@return 索引类型字节数量。
	*/
	__getset(0,__proto,'indexTypeByteCount',function(){
		return this._indexTypeByteCount;
	});

	/**
	*获取索引个数。
	*@return 索引个数。
	*/
	__getset(0,__proto,'indexCount',function(){
		return this._indexCount;
	});

	/**
	*获取是否可读。
	*@return 是否可读。
	*/
	__getset(0,__proto,'canRead',function(){
		return this._canRead;
	});

	IndexBuffer3D.INDEXTYPE_UBYTE="ubyte";
	IndexBuffer3D.INDEXTYPE_USHORT="ushort";
	return IndexBuffer3D;
})(Buffer)


/**
*<code>ShaderPass</code> 类用于实现ShaderPass。
*/
//class laya.d3.shader.ShaderPass extends laya.webgl.utils.ShaderCompile
var ShaderPass=(function(_super){
	function ShaderPass(owner,vs,ps,stateMap){
		/**@private */
		//this._owner=null;
		/**@private */
		//this._stateMap=null;
		/**@private */
		//this._cacheSharders=null;
		/**@private */
		//this._publicValidDefine=0;
		/**@private */
		//this._spriteValidDefine=0;
		/**@private */
		//this._materialValidDefine=0;
		/**@private */
		//this._validDefineMap=null;
		this._renderState=new RenderState();
		this._owner=owner;
		this._cacheSharders=[];
		this._publicValidDefine=0;
		this._spriteValidDefine=0;
		this._materialValidDefine=0;
		this._validDefineMap={};
		ShaderPass.__super.call(this,vs,ps,null,this._validDefineMap);
		var publicDefineMap=this._owner._publicDefinesMap;
		var spriteDefineMap=this._owner._spriteDefinesMap;
		var materialDefineMap=this._owner._materialDefinesMap;
		for (var k in this._validDefineMap){
			if (publicDefineMap[k] !=null)
				this._publicValidDefine |=publicDefineMap[k];
			else if (spriteDefineMap[k] !=null)
			this._spriteValidDefine |=spriteDefineMap[k];
			else if (materialDefineMap[k] !=null)
			this._materialValidDefine |=materialDefineMap[k];
		}
		this._stateMap=stateMap;
	}

	__class(ShaderPass,'laya.d3.shader.ShaderPass',_super);
	var __proto=ShaderPass.prototype;
	/**
	*@private
	*/
	__proto._definesToNameDic=function(value,int2Name){
		var o={};
		var d=1;
		for (var i=0;i < 32;i++){
			d=1 << i;
			if (d > value)break ;
			if (value & d){
				var name=int2Name[d];
				o[name]="";
			}
		}
		return o;
	}

	/**
	*@inheritDoc
	*/
	__proto._compileToTree=function(parent,lines,start,includefiles,defs){
		var node,preNode;
		var text,name,fname;
		var ofs=0,words,noUseNode;
		var i=0,n=0,j=0;
		for (i=start;i < lines.length;i++){
			text=lines[i];
			if (text.length < 1)continue ;
			ofs=text.indexOf("//");
			if (ofs===0)continue ;
			if (ofs >=0)text=text.substr(0,ofs);
			node=noUseNode || new ShaderNode(includefiles);
			noUseNode=null;
			node.text=text;
			if ((ofs=text.indexOf("#"))>=0){
				name="#";
				for (j=ofs+1,n=text.length;j < n;j++){
					var c=text.charAt(j);
					if (c===' ' || c==='\t' || c==='?')break ;
					name+=c;
				}
				node.name=name;
				switch (name){
					case "#ifdef":
					case "#ifndef":
						node.setParent(parent);
						parent=node;
						if (defs){
							words=text.substr(j).split(ShaderCompile._splitToWordExps3);
							for (j=0;j < words.length;j++){
								text=words[j];
								text.length && (defs[text]=true);
							}
						}
						continue ;
					case "#if":
					case "#elif":
						node.setParent(parent);
						parent=node;
						if (defs){
							words=text.substr(j).split(ShaderCompile._splitToWordExps3);
							for (j=0;j < words.length;j++){
								text=words[j];
								text.length && text !="defined" && (defs[text]=true);
							}
						}
						continue ;
					case "#else":
						parent=parent.parent;
						preNode=parent.childs[parent.childs.length-1];
						node.setParent(parent);
						parent=node;
						continue ;
					case "#endif":
						parent=parent.parent;
						preNode=parent.childs[parent.childs.length-1];
						node.setParent(parent);
						continue ;
					case "#include":
						words=ShaderCompile.splitToWords(text,null);
						var inlcudeFile=ShaderCompile.includes[words[1]];
						if (!inlcudeFile){
							throw "ShaderCompile error no this include file:"+words[1];
						}
						if ((ofs=words[0].indexOf("?"))< 0){
							node.setParent(parent);
							text=inlcudeFile.getWith(words[2]=='with' ? words[3] :null);
							this._compileToTree(node,text.split('\n'),0,includefiles,defs);
							node.text="";
							continue ;
						}
						node.setCondition(words[0].substr(ofs+1),1);
						node.text=inlcudeFile.getWith(words[2]=='with' ? words[3] :null);
						break ;
					case "#import":
						words=ShaderCompile.splitToWords(text,null);
						fname=words[1];
						includefiles.push({node:node,file:ShaderCompile.includes[fname],ofs:node.text.length});
						continue ;
					}
				}else {
				preNode=parent.childs[parent.childs.length-1];
				if (preNode && !preNode.name){
					includefiles.length > 0 && ShaderCompile.splitToWords(text,preNode);
					noUseNode=node;
					preNode.text+="\n"+text;
					continue ;
				}
				includefiles.length > 0 && ShaderCompile.splitToWords(text,node);
			}
			node.setParent(parent);
		}
	}

	/**
	*@private
	*/
	__proto.withCompile=function(publicDefine,spriteDefine,materialDefine){
		publicDefine &=this._publicValidDefine;
		spriteDefine &=this._spriteValidDefine;
		materialDefine &=this._materialValidDefine;
		var shader;
		var spriteDefShaders,materialDefShaders;
		spriteDefShaders=this._cacheSharders[publicDefine];
		if (spriteDefShaders){
			materialDefShaders=spriteDefShaders[spriteDefine];
			if (materialDefShaders){
				shader=materialDefShaders[materialDefine];
				if (shader)
					return shader;
				}else {
				materialDefShaders=spriteDefShaders[spriteDefine]=[];
			}
			}else {
			spriteDefShaders=this._cacheSharders[publicDefine]=[];
			materialDefShaders=spriteDefShaders[spriteDefine]=[];
		};
		var publicDefGroup=this._definesToNameDic(publicDefine,this._owner._publicDefines);
		var spriteDefGroup=this._definesToNameDic(spriteDefine,this._owner._spriteDefines);
		var materialDefGroup=this._definesToNameDic(materialDefine,this._owner._materialDefines);
		var key;
		if (Shader3D.debugMode){
			var publicDefGroupStr="";
			for (key in publicDefGroup)
			publicDefGroupStr+=key+" ";
			var spriteDefGroupStr="";
			for (key in spriteDefGroup)
			spriteDefGroupStr+=key+" ";
			var materialDefGroupStr="";
			for (key in materialDefGroup)
			materialDefGroupStr+=key+" ";
			if (!WebGL.shaderHighPrecision)
				publicDefine+=Shader3D.SHADERDEFINE_HIGHPRECISION;
			console.log("%cShader3DDebugMode---(Name:"+this._owner._owner._name+" PassIndex:"+this._owner._passes.indexOf(this)+" PublicDefine:"+publicDefine+" SpriteDefine:"+spriteDefine+" MaterialDefine:"+materialDefine+" PublicDefineGroup:"+publicDefGroupStr+" SpriteDefineGroup:"+spriteDefGroupStr+"MaterialDefineGroup: "+materialDefGroupStr+")---ShaderCompile3DDebugMode","color:green");
		};
		var defMap={};
		var defineStr="";
		if (publicDefGroup){
			for (key in publicDefGroup){
				defineStr+="#define "+key+"\n";
				defMap[key]=true;
			}
		}
		if (spriteDefGroup){
			for (key in spriteDefGroup){
				defineStr+="#define "+key+"\n";
				defMap[key]=true;
			}
		}
		if (materialDefGroup){
			for (key in materialDefGroup){
				defineStr+="#define "+key+"\n";
				defMap[key]=true;
			}
		};
		var vs=this._VS.toscript(defMap,[]);
		var vsVersion='';
		if (vs[0].indexOf('#version')==0){
			vsVersion=vs[0]+'\n';
			vs.shift();
		};
		var ps=this._PS.toscript(defMap,[]);
		var psVersion='';
		if (ps[0].indexOf('#version')==0){
			psVersion=ps[0]+'\n';
			ps.shift();
		}
		shader=new ShaderInstance(vsVersion+defineStr+vs.join('\n'),psVersion+defineStr+ps.join('\n'),this._owner._attributeMap||this._owner._owner._attributeMap,this._owner._uniformMap||this._owner._owner._uniformMap,this);
		materialDefShaders[materialDefine]=shader;
		return shader;
	}

	/**
	*获取渲染状态。
	*@return 渲染状态。
	*/
	__getset(0,__proto,'renderState',function(){
		return this._renderState;
	});

	return ShaderPass;
})(ShaderCompile)


/**
*@private
*<code>BufferState</code> 类用于实现渲染所需的Buffer状态集合。
*/
//class laya.d3.core.BufferState extends laya.webgl.BufferStateBase
var BufferState=(function(_super){
	/**
	*创建一个 <code>BufferState</code> 实例。
	*/
	function BufferState(){
		BufferState.__super.call(this);
	}

	__class(BufferState,'laya.d3.core.BufferState',_super);
	var __proto=BufferState.prototype;
	/**
	*@private
	*vertexBuffer的vertexDeclaration不能为空,该函数比较消耗性能，建议初始化时使用。
	*/
	__proto.applyVertexBuffer=function(vertexBuffer){
		if (BufferStateBase._curBindedBufferState===this){
			var gl=LayaGL.instance;
			var verDec=vertexBuffer.vertexDeclaration;
			var valueData=null;
			if (Render.supportWebGLPlusRendering)
				valueData=verDec._shaderValues._nativeArray;
			else
			valueData=verDec._shaderValues.getData();
			vertexBuffer.bind();
			for (var k in valueData){
				var loc=parseInt(k);
				var attribute=valueData[k];
				gl.enableVertexAttribArray(loc);
				gl.vertexAttribPointer(loc,attribute[0],attribute[1],!!attribute[2],attribute[3],attribute[4]);
			}
			}else {
			throw "BufferState: must call bind() function first.";
		}
	}

	/**
	*@private
	*vertexBuffers中的vertexDeclaration不能为空,该函数比较消耗性能，建议初始化时使用。
	*/
	__proto.applyVertexBuffers=function(vertexBuffers){
		if (BufferStateBase._curBindedBufferState===this){
			var gl=LayaGL.instance;
			for (var i=0,n=vertexBuffers.length;i < n;i++){
				var verBuf=vertexBuffers[i];
				var verDec=verBuf.vertexDeclaration;
				var valueData=null;
				if (Render.supportWebGLPlusRendering)
					valueData=verDec._shaderValues._nativeArray;
				else
				valueData=verDec._shaderValues.getData();
				verBuf.bind();
				for (var k in valueData){
					var loc=parseInt(k);
					var attribute=valueData[k];
					gl.enableVertexAttribArray(loc);
					gl.vertexAttribPointer(loc,attribute[0],attribute[1],!!attribute[2],attribute[3],attribute[4]);
				}
			}
			}else {
			throw "BufferState: must call bind() function first.";
		}
	}

	/**
	*@private
	*/
	__proto.applyInstanceVertexBuffer=function(vertexBuffer){
		if (WebGLContext._angleInstancedArrays){
			if (BufferStateBase._curBindedBufferState===this){
				var gl=LayaGL.instance;
				var verDec=vertexBuffer.vertexDeclaration;
				var valueData=null;
				if (Render.supportWebGLPlusRendering)
					valueData=verDec._shaderValues._nativeArray;
				else
				valueData=verDec._shaderValues.getData();
				vertexBuffer.bind();
				for (var k in valueData){
					var loc=parseInt(k);
					var attribute=valueData[k];
					gl.enableVertexAttribArray(loc);
					gl.vertexAttribPointer(loc,attribute[0],attribute[1],!!attribute[2],attribute[3],attribute[4]);
					WebGLContext._angleInstancedArrays.vertexAttribDivisorANGLE(loc,1);
				}
				}else {
				throw "BufferState: must call bind() function first.";
			}
		}
	}

	/**
	*@private
	*/
	__proto.applyIndexBuffer=function(indexBuffer){
		if (BufferStateBase._curBindedBufferState===this){
			if (this._bindedIndexBuffer!==indexBuffer){
				indexBuffer._bindForVAO();
				this._bindedIndexBuffer=indexBuffer;
			}
			}else {
			throw "BufferState: must call bind() function first.";
		}
	}

	return BufferState;
})(BufferStateBase)


/**
*<code>ConeShape</code> 类用于创建锥形粒子形状。
*/
//class laya.d3.core.particleShuriKen.module.shape.ConeShape extends laya.d3.core.particleShuriKen.module.shape.BaseShape
var ConeShape=(function(_super){
	function ConeShape(){
		/**发射角度。*/
		this.angle=NaN;
		/**发射器半径。*/
		this.radius=NaN;
		/**椎体长度。*/
		this.length=NaN;
		/**发射类型,0为Base,1为BaseShell,2为Volume,3为VolumeShell。*/
		this.emitType=0;
		ConeShape.__super.call(this);
		this.angle=25.0 / 180.0 *Math.PI;
		this.radius=1.0;
		this.length=5.0;
		this.emitType=0;
		this.randomDirection=false;
	}

	__class(ConeShape,'laya.d3.core.particleShuriKen.module.shape.ConeShape',_super);
	var __proto=ConeShape.prototype;
	/**
	*@inheritDoc
	*/
	__proto._getShapeBoundBox=function(boundBox){
		var coneRadius2=this.radius+this.length *Math.sin(this.angle);
		var coneLength=this.length *Math.cos(this.angle);
		var min=boundBox.min;
		min.x=min.y=-coneRadius2;
		min.z=0;
		var max=boundBox.max;
		max.x=max.y=coneRadius2;
		max.z=coneLength;
	}

	/**
	*@inheritDoc
	*/
	__proto._getSpeedBoundBox=function(boundBox){
		var sinA=Math.sin(this.angle);
		var min=boundBox.min;
		min.x=min.y=-sinA;
		min.z=0;
		var max=boundBox.max;
		max.x=max.y=sinA;
		max.z=1;
	}

	/**
	*用于生成粒子初始位置和方向。
	*@param position 粒子位置。
	*@param direction 粒子方向。
	*/
	__proto.generatePositionAndDirection=function(position,direction,rand,randomSeeds){
		var positionPointE=ConeShape._tempPositionPoint;
		var positionX=NaN;
		var positionY=NaN;
		var directionPointE;
		var dirCosA=Math.cos(this.angle);
		var dirSinA=Math.sin(this.angle);
		switch (this.emitType){
			case 0:
				if (rand){
					rand.seed=randomSeeds[16];
					ShapeUtils._randomPointInsideUnitCircle(ConeShape._tempPositionPoint,rand);
					randomSeeds[16]=rand.seed;
					}else {
					ShapeUtils._randomPointInsideUnitCircle(ConeShape._tempPositionPoint);
				}
				positionX=positionPointE.x;
				positionY=positionPointE.y;
				position.x=positionX *this.radius;
				position.y=positionY *this.radius;
				position.z=0;
				if (this.randomDirection){
					if (rand){
						rand.seed=randomSeeds[17];
						ShapeUtils._randomPointInsideUnitCircle(ConeShape._tempDirectionPoint,rand);
						randomSeeds[17]=rand.seed;
						}else {
						ShapeUtils._randomPointInsideUnitCircle(ConeShape._tempDirectionPoint);
					}
					directionPointE=ConeShape._tempDirectionPoint;
					direction.x=directionPointE.x *dirSinA;
					direction.y=directionPointE.y *dirSinA;
					}else {
					direction.x=positionX *dirSinA;
					direction.y=positionY *dirSinA;
				}
				direction.z=dirCosA;
				break ;
			case 1:
				if (rand){
					rand.seed=randomSeeds[16];
					ShapeUtils._randomPointUnitCircle(ConeShape._tempPositionPoint,rand);
					randomSeeds[16]=rand.seed;
					}else {
					ShapeUtils._randomPointUnitCircle(ConeShape._tempPositionPoint);
				}
				positionX=positionPointE.x;
				positionY=positionPointE.y;
				position.x=positionX *this.radius;
				position.y=positionY *this.radius;
				position.z=0;
				if (this.randomDirection){
					if (rand){
						rand.seed=randomSeeds[17];
						ShapeUtils._randomPointInsideUnitCircle(ConeShape._tempDirectionPoint,rand);
						randomSeeds[17]=rand.seed;
						}else {
						ShapeUtils._randomPointInsideUnitCircle(ConeShape._tempDirectionPoint);
					}
					directionPointE=ConeShape._tempDirectionPoint;
					direction.x=directionPointE.x *dirSinA;
					direction.y=directionPointE.y *dirSinA;
					}else {
					direction.x=positionX *dirSinA;
					direction.y=positionY *dirSinA;
				}
				direction.z=dirCosA;
				break ;
			case 2:
				if (rand){
					rand.seed=randomSeeds[16];
					ShapeUtils._randomPointInsideUnitCircle(ConeShape._tempPositionPoint,rand);
					}else {
					ShapeUtils._randomPointInsideUnitCircle(ConeShape._tempPositionPoint);
				}
				positionX=positionPointE.x;
				positionY=positionPointE.y;
				position.x=positionX *this.radius;
				position.y=positionY *this.radius;
				position.z=0;
				direction.x=positionX *dirSinA;
				direction.y=positionY *dirSinA;
				direction.z=dirCosA;
				Vector3.normalize(direction,direction);
				if (rand){
					Vector3.scale(direction,this.length *rand.getFloat(),direction);
					randomSeeds[16]=rand.seed;
					}else {
					Vector3.scale(direction,this.length *Math.random(),direction);
				}
				Vector3.add(position,direction,position);
				if (this.randomDirection){
					if (rand){
						rand.seed=randomSeeds[17];
						ShapeUtils._randomPointUnitSphere(direction,rand);
						randomSeeds[17]=rand.seed;
						}else {
						ShapeUtils._randomPointUnitSphere(direction);
					}
				}
				break ;
			case 3:
				if (rand){
					rand.seed=randomSeeds[16];
					ShapeUtils._randomPointUnitCircle(ConeShape._tempPositionPoint,rand);
					}else {
					ShapeUtils._randomPointUnitCircle(ConeShape._tempPositionPoint);
				}
				positionX=positionPointE.x;
				positionY=positionPointE.y;
				position.x=positionX *this.radius;
				position.y=positionY *this.radius;
				position.z=0;
				direction.x=positionX *dirSinA;
				direction.y=positionY *dirSinA;
				direction.z=dirCosA;
				Vector3.normalize(direction,direction);
				if (rand){
					Vector3.scale(direction,this.length *rand.getFloat(),direction);
					randomSeeds[16]=rand.seed;
					}else {
					Vector3.scale(direction,this.length *Math.random(),direction);
				}
				Vector3.add(position,direction,position);
				if (this.randomDirection){
					if (rand){
						rand.seed=randomSeeds[17];
						ShapeUtils._randomPointUnitSphere(direction,rand);
						randomSeeds[17]=rand.seed;
						}else {
						ShapeUtils._randomPointUnitSphere(direction);
					}
				}
				break ;
			default :
				throw new Error("ConeShape:emitType is invalid.");
			}
	}

	__proto.cloneTo=function(destObject){
		_super.prototype.cloneTo.call(this,destObject);
		var destShape=destObject;
		destShape.angle=this.angle;
		destShape.radius=this.radius;
		destShape.length=this.length;
		destShape.emitType=this.emitType;
		destShape.randomDirection=this.randomDirection;
	}

	__static(ConeShape,
	['_tempPositionPoint',function(){return this._tempPositionPoint=new Vector2();},'_tempDirectionPoint',function(){return this._tempDirectionPoint=new Vector2();}
	]);
	return ConeShape;
})(BaseShape)


/**
*<code>SphereColliderShape</code> 类用于创建球形碰撞器。
*/
//class laya.d3.physics.shape.SphereColliderShape extends laya.d3.physics.shape.ColliderShape
var SphereColliderShape=(function(_super){
	function SphereColliderShape(radius){
		/**@private */
		//this._radius=NaN;
		SphereColliderShape.__super.call(this);
		(radius===void 0)&& (radius=0.5);
		this._radius=radius;
		this._type=/*laya.d3.physics.shape.ColliderShape.SHAPETYPES_SPHERE*/1;
		this._nativeShape=new Laya3D._physics3D.btSphereShape(radius);
	}

	__class(SphereColliderShape,'laya.d3.physics.shape.SphereColliderShape',_super);
	var __proto=SphereColliderShape.prototype;
	/**
	*@inheritDoc
	*/
	__proto.clone=function(){
		var dest=new SphereColliderShape(this._radius);
		this.cloneTo(dest);
		return dest;
	}

	/**
	*获取半径。
	*/
	__getset(0,__proto,'radius',function(){
		return this._radius;
	});

	return SphereColliderShape;
})(ColliderShape)


/**
*<code>CircleShape</code> 类用于创建环形粒子形状。
*/
//class laya.d3.core.particleShuriKen.module.shape.CircleShape extends laya.d3.core.particleShuriKen.module.shape.BaseShape
var CircleShape=(function(_super){
	function CircleShape(){
		/**发射器半径。*/
		this.radius=NaN;
		/**环形弧度。*/
		this.arc=NaN;
		/**从边缘发射。*/
		this.emitFromEdge=false;
		CircleShape.__super.call(this);
		this.radius=1.0;
		this.arc=360.0 / 180.0 *Math.PI;
		this.emitFromEdge=false;
		this.randomDirection=false;
	}

	__class(CircleShape,'laya.d3.core.particleShuriKen.module.shape.CircleShape',_super);
	var __proto=CircleShape.prototype;
	/**
	*@inheritDoc
	*/
	__proto._getShapeBoundBox=function(boundBox){
		var min=boundBox.min;
		min.x=min.z=-this.radius;
		min.y=0;
		var max=boundBox.max;
		max.x=max.z=this.radius;
		max.y=0;
	}

	/**
	*@inheritDoc
	*/
	__proto._getSpeedBoundBox=function(boundBox){
		var min=boundBox.min;
		min.x=min.y=-1;
		min.z=0;
		var max=boundBox.max;
		max.x=max.y=1;
		max.z=0;
	}

	/**
	*用于生成粒子初始位置和方向。
	*@param position 粒子位置。
	*@param direction 粒子方向。
	*/
	__proto.generatePositionAndDirection=function(position,direction,rand,randomSeeds){
		var positionPoint=CircleShape._tempPositionPoint;
		if (rand){
			rand.seed=randomSeeds[16];
			if (this.emitFromEdge)
				ShapeUtils._randomPointUnitArcCircle(this.arc,CircleShape._tempPositionPoint,rand);
			else
			ShapeUtils._randomPointInsideUnitArcCircle(this.arc,CircleShape._tempPositionPoint,rand);
			randomSeeds[16]=rand.seed;
			}else {
			if (this.emitFromEdge)
				ShapeUtils._randomPointUnitArcCircle(this.arc,CircleShape._tempPositionPoint);
			else
			ShapeUtils._randomPointInsideUnitArcCircle(this.arc,CircleShape._tempPositionPoint);
		}
		position.x=-positionPoint.x;
		position.y=positionPoint.y;
		position.z=0;
		Vector3.scale(position,this.radius,position);
		if (this.randomDirection){
			if (rand){
				rand.seed=randomSeeds[17];
				ShapeUtils._randomPointUnitSphere(direction,rand);
				randomSeeds[17]=rand.seed;
				}else {
				ShapeUtils._randomPointUnitSphere(direction);
			}
			}else {
			position.cloneTo(direction);
		}
	}

	__proto.cloneTo=function(destObject){
		_super.prototype.cloneTo.call(this,destObject);
		var destShape=destObject;
		destShape.radius=this.radius;
		destShape.arc=this.arc;
		destShape.emitFromEdge=this.emitFromEdge;
		destShape.randomDirection=this.randomDirection;
	}

	__static(CircleShape,
	['_tempPositionPoint',function(){return this._tempPositionPoint=new Vector2();}
	]);
	return CircleShape;
})(BaseShape)


/**
*@private
*<code>BlitCMD</code> 类用于创建从一张渲染目标输出到另外一张渲染目标指令。
*/
//class laya.d3.core.render.command.BlitCMD extends laya.d3.core.render.command.Command
var BlitCMD=(function(_super){
	function BlitCMD(){
		/**@private */
		this._source=null;
		/**@private */
		this._dest=null;
		/**@private */
		this._shader=null;
		/**@private */
		this._shaderData=null;
		/**@private */
		this._subShader=0;
		BlitCMD.__super.call(this);
	}

	__class(BlitCMD,'laya.d3.core.render.command.BlitCMD',_super);
	var __proto=BlitCMD.prototype;
	/**
	*@inheritDoc
	*/
	__proto.run=function(){
		this._shaderData.setTexture(CommandBuffer.SCREENTEXTURE_ID,this._source);
		var dest=this._dest;
		if (dest)
			dest._start();
		var subShader=this._shader.getSubShaderAt(this._subShader);
		var passes=subShader._passes;
		for (var i=0,n=passes.length;i < n;i++){
			var shaderPass=passes[i].withCompile(0,0,0);
			shaderPass.bind();
			(this._shaderData)&& (shaderPass.uploadUniforms(shaderPass._materialUniformParamsMap,this._shaderData,true));
			shaderPass.uploadRenderStateBlendDepth(this._shaderData);
			shaderPass.uploadRenderStateFrontFace(this._shaderData,true,null);
			ScreenQuad.instance.render();
		}
		if (dest)
			dest._end();
	}

	/**
	*@inheritDoc
	*/
	__proto.recover=function(){
		BlitCMD._pool.push(this);
		this._dest=null;
		this._shader=null;
		this._shaderData=null;
	}

	BlitCMD.create=function(source,dest,shader,shaderData,subShader){
		(subShader===void 0)&& (subShader=0);
		var cmd;
		cmd=BlitCMD._pool.length > 0 ? BlitCMD._pool.pop():new BlitCMD();
		cmd._source=source;
		cmd._dest=dest;
		cmd._shader=shader;
		cmd._shaderData=shaderData;
		cmd._subShader=subShader;
		return cmd;
	}

	BlitCMD._pool=[];
	return BlitCMD;
})(Command)


/**
*<code>CastShadowList</code> 类用于实现产生阴影者队列。
*/
//class laya.d3.CastShadowList extends laya.d3.component.SingletonList
var CastShadowList=(function(_super){
	/**
	*创建一个新的 <code>CastShadowList</code> 实例。
	*/
	function CastShadowList(){
		CastShadowList.__super.call(this);
	}

	__class(CastShadowList,'laya.d3.CastShadowList',_super);
	var __proto=CastShadowList.prototype;
	/**
	*@private
	*/
	__proto.add=function(element){
		var index=element._indexInCastShadowList;
		if (index!==-1)
			throw "CastShadowList:element has  in  CastShadowList.";
		this._add(element);
		element._indexInCastShadowList=this.length++;
	}

	/**
	*@private
	*/
	__proto.remove=function(element){
		var index=element._indexInCastShadowList;
		this.length--;
		if (index!==this.length){
			var end=this.elements[this.length];
			this.elements[index]=end;
			end._indexInCastShadowList=index;
		}
		element._indexInCastShadowList=-1;
	}

	return CastShadowList;
})(SingletonList)


/**
*<code>CapsuleColliderShape</code> 类用于创建胶囊形状碰撞器。
*/
//class laya.d3.physics.shape.CapsuleColliderShape extends laya.d3.physics.shape.ColliderShape
var CapsuleColliderShape=(function(_super){
	function CapsuleColliderShape(radius,length,orientation){
		/**@private */
		//this._radius=NaN;
		/**@private */
		//this._length=NaN;
		/**@private */
		//this._orientation=0;
		CapsuleColliderShape.__super.call(this);
		(radius===void 0)&& (radius=0.5);
		(length===void 0)&& (length=1.25);
		(orientation===void 0)&& (orientation=/*laya.d3.physics.shape.ColliderShape.SHAPEORIENTATION_UPY*/1);
		this._radius=radius;
		this._length=length;
		this._orientation=orientation;
		this._type=/*laya.d3.physics.shape.ColliderShape.SHAPETYPES_CAPSULE*/3;
		switch (orientation){
			case /*laya.d3.physics.shape.ColliderShape.SHAPEORIENTATION_UPX*/0:
				this._nativeShape=new Laya3D._physics3D.btCapsuleShapeX(radius,length-radius *2);
				break ;
			case /*laya.d3.physics.shape.ColliderShape.SHAPEORIENTATION_UPY*/1:
				this._nativeShape=new Laya3D._physics3D.btCapsuleShape(radius,length-radius *2);
				break ;
			case /*laya.d3.physics.shape.ColliderShape.SHAPEORIENTATION_UPZ*/2:
				this._nativeShape=new Laya3D._physics3D.btCapsuleShapeZ(radius,length-radius *2);
				break ;
			default :
				throw "CapsuleColliderShape:unknown orientation.";
			}
	}

	__class(CapsuleColliderShape,'laya.d3.physics.shape.CapsuleColliderShape',_super);
	var __proto=CapsuleColliderShape.prototype;
	/**
	*@inheritDoc
	*/
	__proto._setScale=function(value){
		var fixScale=CapsuleColliderShape._tempVector30;
		switch (this.orientation){
			case /*laya.d3.physics.shape.ColliderShape.SHAPEORIENTATION_UPX*/0:
				fixScale.x=value.x;
				fixScale.y=fixScale.z=Math.max(value.y,value.z);
				break ;
			case /*laya.d3.physics.shape.ColliderShape.SHAPEORIENTATION_UPY*/1:
				fixScale.y=value.y;
				fixScale.x=fixScale.z=Math.max(value.x,value.z);
				break ;
			case /*laya.d3.physics.shape.ColliderShape.SHAPEORIENTATION_UPZ*/2:
				fixScale.z=value.z;
				fixScale.x=fixScale.y=Math.max(value.x,value.y);
				break ;
			default :
				throw "CapsuleColliderShape:unknown orientation.";
			}
		_super.prototype._setScale.call(this,fixScale);
	}

	/**
	*@inheritDoc
	*/
	__proto.clone=function(){
		var dest=new CapsuleColliderShape(this._radius,this._length,this._orientation);
		this.cloneTo(dest);
		return dest;
	}

	/**
	*获取半径。
	*/
	__getset(0,__proto,'radius',function(){
		return this._radius;
	});

	/**
	*获取长度。
	*/
	__getset(0,__proto,'length',function(){
		return this._length;
	});

	/**
	*获取方向。
	*/
	__getset(0,__proto,'orientation',function(){
		return this._orientation;
	});

	__static(CapsuleColliderShape,
	['_tempVector30',function(){return this._tempVector30=new Vector3();}
	]);
	return CapsuleColliderShape;
})(ColliderShape)


/**
*<code>SubMesh</code> 类用于创建子网格数据模板。
*/
//class laya.d3.resource.models.SubMesh extends laya.d3.core.GeometryElement
var SubMesh=(function(_super){
	function SubMesh(mesh){
		/**@private */
		this._mesh=null;
		/**@private */
		this._boneIndicesList=null;
		/**@private */
		this._subIndexBufferStart=null;
		/**@private */
		this._subIndexBufferCount=null;
		/**@private */
		this._skinAnimationDatas=null;
		/**@private */
		this._indexInMesh=0;
		/**@private */
		this._vertexStart=0;
		/**@private */
		this._indexStart=0;
		/**@private */
		this._indexCount=0;
		/**@private */
		this._indices=null;
		/**@private [只读]*/
		this._vertexBuffer=null;
		/**@private [只读]*/
		this._indexBuffer=null;
		/**@private */
		this._id=0;
		SubMesh.__super.call(this);
		this._id=++SubMesh._uniqueIDCounter;
		this._mesh=mesh;
		this._boneIndicesList=[];
		this._subIndexBufferStart=[];
		this._subIndexBufferCount=[];
	}

	__class(SubMesh,'laya.d3.resource.models.SubMesh',_super);
	var __proto=SubMesh.prototype;
	/**
	*@inheritDoc
	*/
	__proto._getType=function(){
		return SubMesh._type;
	}

	/**
	*@inheritDoc
	*/
	__proto._render=function(state){
		this._mesh._bufferState.bind();
		var skinnedDatas=(state.renderElement.render)._skinnedData;
		if (skinnedDatas){
			var subSkinnedDatas=skinnedDatas[this._indexInMesh];
			var boneIndicesListCount=this._boneIndicesList.length;
			for (var i=0;i < boneIndicesListCount;i++){
				state.shader.uploadCustomUniform(SkinnedMeshSprite3D.BONES,subSkinnedDatas[i]);
				LayaGL.instance.drawElements(/*laya.webgl.WebGLContext.TRIANGLES*/0x0004,this._subIndexBufferCount[i],/*laya.webgl.WebGLContext.UNSIGNED_SHORT*/0x1403,this._subIndexBufferStart[i] *2);
			}
			}else {
			LayaGL.instance.drawElements(/*laya.webgl.WebGLContext.TRIANGLES*/0x0004,this._indexCount,/*laya.webgl.WebGLContext.UNSIGNED_SHORT*/0x1403,this._indexStart *2);
		}
		Stat.trianglesFaces+=this._indexCount / 3;
		Stat.renderBatches++;
	}

	/**
	*@private
	*/
	__proto.getIndices=function(){
		return this._indices;
	}

	/**
	*@inheritDoc
	*/
	__proto.destroy=function(){
		if (this._destroyed)
			return;
		_super.prototype.destroy.call(this);
		this._indexBuffer.destroy();
		this._indexBuffer=null;
		this._mesh=null;
		this._boneIndicesList=null;
		this._subIndexBufferStart=null;
		this._subIndexBufferCount=null;
		this._skinAnimationDatas=null;
	}

	SubMesh._uniqueIDCounter=0;
	__static(SubMesh,
	['_type',function(){return this._type=GeometryElement._typeCounter++;}
	]);
	return SubMesh;
})(GeometryElement)


/**
*<code>ShurikenParticleSystem</code> 类用于创建3D粒子数据模板。
*/
//class laya.d3.core.particleShuriKen.ShurikenParticleSystem extends laya.d3.core.GeometryElement
var ShurikenParticleSystem=(function(_super){
	function ShurikenParticleSystem(owner){
		/**@private */
		//this._boundingSphere=null;
		/**@private */
		//this._boundingBox=null;
		/**@private */
		//this._boundingBoxCorners=null;
		/**@private */
		//this._owner=null;
		/**@private */
		//this._ownerRender=null;
		/**@private */
		//this._vertices=null;
		/**@private */
		//this._floatCountPerVertex=0;
		/**@private */
		//this._startLifeTimeIndex=0;
		/**@private */
		//this._timeIndex=0;
		/**@private */
		//this._simulateUpdate=false;
		/**@private */
		//this._firstActiveElement=0;
		/**@private */
		//this._firstNewElement=0;
		/**@private */
		//this._firstFreeElement=0;
		/**@private */
		//this._firstRetiredElement=0;
		/**@private */
		//this._drawCounter=0;
		/**@private */
		//this._bufferMaxParticles=0;
		/**@private */
		//this._emission=null;
		/**@private */
		//this._shape=null;
		/**@private */
		//this._isEmitting=false;
		/**@private */
		//this._isPlaying=false;
		/**@private */
		//this._isPaused=false;
		/**@private */
		//this._playStartDelay=NaN;
		/**@private 发射的累计时间。*/
		//this._frameRateTime=NaN;
		/**@private 一次循环内的累计时间。*/
		//this._emissionTime=NaN;
		/**@private */
		//this._totalDelayTime=NaN;
		/**@private */
		//this._burstsIndex=0;
		/**@private */
		//this._velocityOverLifetime=null;
		/**@private */
		//this._colorOverLifetime=null;
		/**@private */
		//this._sizeOverLifetime=null;
		/**@private */
		//this._rotationOverLifetime=null;
		/**@private */
		//this._textureSheetAnimation=null;
		/**@private */
		//this._startLifetimeType=0;
		/**@private */
		//this._startLifetimeConstant=NaN;
		/**@private */
		//this._startLifeTimeGradient=null;
		/**@private */
		//this._startLifetimeConstantMin=NaN;
		/**@private */
		//this._startLifetimeConstantMax=NaN;
		/**@private */
		//this._startLifeTimeGradientMin=null;
		/**@private */
		//this._startLifeTimeGradientMax=null;
		/**@private */
		//this._maxStartLifetime=NaN;
		/**@private */
		//this._vertexStride=0;
		/**@private */
		//this._indexStride=0;
		/**@private */
		//this._vertexBuffer=null;
		/**@private */
		//this._indexBuffer=null;
		/**@private */
		//this._currentTime=NaN;
		/**@private */
		//this._startUpdateLoopCount=0;
		/**@private */
		//this._rand=null;
		/**@private */
		//this._randomSeeds=null;
		/**粒子运行的总时长，单位为秒。*/
		//this.duration=NaN;
		/**是否循环。*/
		//this.looping=false;
		/**是否预热。暂不支持*/
		//this.prewarm=false;
		/**开始延迟类型，0为常量模式,1为随机随机双常量模式，不能和prewarm一起使用。*/
		//this.startDelayType=0;
		/**开始播放延迟，不能和prewarm一起使用。*/
		//this.startDelay=NaN;
		/**开始播放最小延迟，不能和prewarm一起使用。*/
		//this.startDelayMin=NaN;
		/**开始播放最大延迟，不能和prewarm一起使用。*/
		//this.startDelayMax=NaN;
		/**开始速度模式，0为恒定速度，2为两个恒定速度的随机插值。缺少1、3模式*/
		//this.startSpeedType=0;
		/**开始速度,0模式。*/
		//this.startSpeedConstant=NaN;
		/**最小开始速度,1模式。*/
		//this.startSpeedConstantMin=NaN;
		/**最大开始速度,1模式。*/
		//this.startSpeedConstantMax=NaN;
		/**开始尺寸是否为3D模式。*/
		//this.threeDStartSize=false;
		/**开始尺寸模式,0为恒定尺寸，2为两个恒定尺寸的随机插值。缺少1、3模式和对应的二种3D模式*/
		//this.startSizeType=0;
		/**开始尺寸，0模式。*/
		//this.startSizeConstant=NaN;
		/**开始三维尺寸，0模式。*/
		//this.startSizeConstantSeparate=null;
		/**最小开始尺寸，2模式。*/
		//this.startSizeConstantMin=NaN;
		/**最大开始尺寸，2模式。*/
		//this.startSizeConstantMax=NaN;
		/**最小三维开始尺寸，2模式。*/
		//this.startSizeConstantMinSeparate=null;
		/**最大三维开始尺寸，2模式。*/
		//this.startSizeConstantMaxSeparate=null;
		/**3D开始旋转，暂不支持*/
		//this.threeDStartRotation=false;
		/**开始旋转模式,0为恒定尺寸，2为两个恒定旋转的随机插值,缺少2种模式,和对应的四种3D模式。*/
		//this.startRotationType=0;
		/**开始旋转，0模式。*/
		//this.startRotationConstant=NaN;
		/**开始三维旋转，0模式。*/
		//this.startRotationConstantSeparate=null;
		/**最小开始旋转，1模式。*/
		//this.startRotationConstantMin=NaN;
		/**最大开始旋转，1模式。*/
		//this.startRotationConstantMax=NaN;
		/**最小开始三维旋转，1模式。*/
		//this.startRotationConstantMinSeparate=null;
		/**最大开始三维旋转，1模式。*/
		//this.startRotationConstantMaxSeparate=null;
		/**随机旋转方向，范围为0.0到1.0*/
		//this.randomizeRotationDirection=NaN;
		/**开始颜色模式，0为恒定颜色，2为两个恒定颜色的随机插值,缺少2种模式。*/
		//this.startColorType=0;
		/**开始颜色，0模式。*/
		//this.startColorConstant=null;
		/**最小开始颜色，1模式。*/
		//this.startColorConstantMin=null;
		/**最大开始颜色，1模式。*/
		//this.startColorConstantMax=null;
		/**重力敏感度。*/
		//this.gravityModifier=NaN;
		/**模拟器空间,0为World,1为Local。暂不支持Custom。*/
		//this.simulationSpace=0;
		/**缩放模式，0为Hiercachy,1为Local,2为World。*/
		//this.scaleMode=0;
		/**激活时是否自动播放。*/
		//this.playOnAwake=false;
		/**随机种子,注:play()前设置有效。*/
		//this.randomSeed=null;
		/**是否使用随机种子。 */
		//this.autoRandomSeed=false;
		/**是否为性能模式,性能模式下会延迟粒子释放。*/
		//this.isPerformanceMode=false;
		ShurikenParticleSystem.__super.call(this);
		this._tempRotationMatrix=new Matrix4x4();
		this._uvLength=new Vector2();
		this._bufferState=new BufferState();
		this._firstActiveElement=0;
		this._firstNewElement=0;
		this._firstFreeElement=0;
		this._firstRetiredElement=0;
		this._owner=owner;
		this._ownerRender=owner.particleRenderer;
		this._boundingBoxCorners=__newvec(8,null);
		this._boundingSphere=new BoundSphere(new Vector3(),Number.MAX_VALUE);
		this._boundingBox=new BoundBox(new Vector3(-Number.MAX_VALUE,-Number.MAX_VALUE,-Number.MAX_VALUE),new Vector3(Number.MAX_VALUE,Number.MAX_VALUE,Number.MAX_VALUE));
		this._currentTime=0;
		this._isEmitting=false;
		this._isPlaying=false;
		this._isPaused=false;
		this._burstsIndex=0;
		this._frameRateTime=0;
		this._emissionTime=0;
		this._totalDelayTime=0;
		this._simulateUpdate=false;
		this._bufferMaxParticles=1;
		this.duration=5.0;
		this.looping=true;
		this.prewarm=false;
		this.startDelayType=0;
		this.startDelay=0.0;
		this.startDelayMin=0.0;
		this.startDelayMax=0.0;
		this._startLifetimeType=0;
		this._startLifetimeConstant=5.0;
		this._startLifeTimeGradient=new GradientDataNumber();
		this._startLifetimeConstantMin=0.0;
		this._startLifetimeConstantMax=5.0;
		this._startLifeTimeGradientMin=new GradientDataNumber();
		this._startLifeTimeGradientMax=new GradientDataNumber();
		this._maxStartLifetime=5.0;
		this.startSpeedType=0;
		this.startSpeedConstant=5.0;
		this.startSpeedConstantMin=0.0;
		this.startSpeedConstantMax=5.0;
		this.threeDStartSize=false;
		this.startSizeType=0;
		this.startSizeConstant=1;
		this.startSizeConstantSeparate=new Vector3(1,1,1);
		this.startSizeConstantMin=0;
		this.startSizeConstantMax=1;
		this.startSizeConstantMinSeparate=new Vector3(0,0,0);
		this.startSizeConstantMaxSeparate=new Vector3(1,1,1);
		this.threeDStartRotation=false;
		this.startRotationType=0;
		this.startRotationConstant=0;
		this.startRotationConstantSeparate=new Vector3(0,0,0);
		this.startRotationConstantMin=0.0;
		this.startRotationConstantMax=0.0;
		this.startRotationConstantMinSeparate=new Vector3(0,0,0);
		this.startRotationConstantMaxSeparate=new Vector3(0,0,0);
		this.randomizeRotationDirection=0.0;
		this.startColorType=0;
		this.startColorConstant=new Vector4(1,1,1,1);
		this.startColorConstantMin=new Vector4(1,1,1,1);
		this.startColorConstantMax=new Vector4(1,1,1,1);
		this.gravityModifier=0.0;
		this.simulationSpace=1;
		this.scaleMode=0;
		this.playOnAwake=true;
		this._rand=new Rand(0);
		this.autoRandomSeed=true;
		this.randomSeed=new Uint32Array(1);
		this._randomSeeds=new Uint32Array(ShurikenParticleSystem._RANDOMOFFSET.length);
		this.isPerformanceMode=true;
		this._emission=new Emission();
		this._emission.enbale=true;
	}

	__class(ShurikenParticleSystem,'laya.d3.core.particleShuriKen.ShurikenParticleSystem',_super);
	var __proto=ShurikenParticleSystem.prototype;
	Laya.imps(__proto,{"laya.d3.core.IClone":true})
	__proto._getVertexBuffer=function(index){
		(index===void 0)&& (index=0);
		if (index===0)
			return this._vertexBuffer;
		else
		return null;
	}

	__proto._getIndexBuffer=function(){
		return this._indexBuffer;
	}

	/**
	*@private
	*/
	__proto._generateBoundingSphere=function(){
		var centerE=this._boundingSphere.center;
		centerE.x=0;
		centerE.y=0;
		centerE.z=0;
		this._boundingSphere.radius=Number.MAX_VALUE;
	}

	/**
	*@private
	*/
	__proto._generateBoundingBox=function(){
		var particle=this._owner;
		var particleRender=particle.particleRenderer;
		var boundMin=this._boundingBox.min;
		var boundMax=this._boundingBox.max;
		var i=0,n=0;
		var maxStartLifeTime=NaN;
		switch (this.startLifetimeType){
			case 0:
				maxStartLifeTime=this.startLifetimeConstant;
				break ;
			case 1:
				maxStartLifeTime=-Number.MAX_VALUE;
				var startLifeTimeGradient=startLifeTimeGradient;
				for (i=0,n=startLifeTimeGradient.gradientCount;i < n;i++)
				maxStartLifeTime=Math.max(maxStartLifeTime,startLifeTimeGradient.getValueByIndex(i));
				break ;
			case 2:
				maxStartLifeTime=Math.max(this.startLifetimeConstantMin,this.startLifetimeConstantMax);
				break ;
			case 3:
				maxStartLifeTime=-Number.MAX_VALUE;
				var startLifeTimeGradientMin=startLifeTimeGradientMin;
				for (i=0,n=startLifeTimeGradientMin.gradientCount;i < n;i++)
				maxStartLifeTime=Math.max(maxStartLifeTime,startLifeTimeGradientMin.getValueByIndex(i));
				var startLifeTimeGradientMax=startLifeTimeGradientMax;
				for (i=0,n=startLifeTimeGradientMax.gradientCount;i < n;i++)
				maxStartLifeTime=Math.max(maxStartLifeTime,startLifeTimeGradientMax.getValueByIndex(i));
				break ;
			};
		var minStartSpeed=NaN,maxStartSpeed=NaN;
		switch (this.startSpeedType){
			case 0:
				minStartSpeed=maxStartSpeed=this.startSpeedConstant;
				break ;
			case 1:
				break ;
			case 2:
				minStartSpeed=this.startLifetimeConstantMin;
				maxStartSpeed=this.startLifetimeConstantMax;
				break ;
			case 3:
				break ;
			};
		var minPosition,maxPosition,minDirection,maxDirection;
		if (this._shape && this._shape.enable){
			}else {
			minPosition=maxPosition=Vector3._ZERO;
			minDirection=Vector3._ZERO;
			maxDirection=Vector3._UnitZ;
		};
		var startMinVelocity=new Vector3(minDirection.x *minStartSpeed,minDirection.y *minStartSpeed,minDirection.z *minStartSpeed);
		var startMaxVelocity=new Vector3(maxDirection.x *maxStartSpeed,maxDirection.y *maxStartSpeed,maxDirection.z *maxStartSpeed);
		if (this._velocityOverLifetime && this._velocityOverLifetime.enbale){
			var lifeMinVelocity;
			var lifeMaxVelocity;
			var velocity=this._velocityOverLifetime.velocity;
			switch (velocity.type){
				case 0:
					lifeMinVelocity=lifeMaxVelocity=velocity.constant;
					break ;
				case 1:
					lifeMinVelocity=lifeMaxVelocity=new Vector3(velocity.gradientX.getAverageValue(),velocity.gradientY.getAverageValue(),velocity.gradientZ.getAverageValue());
					break ;
				case 2:
					lifeMinVelocity=velocity.constantMin;
					lifeMaxVelocity=velocity.constantMax;
					break ;
				case 3:
					lifeMinVelocity=new Vector3(velocity.gradientXMin.getAverageValue(),velocity.gradientYMin.getAverageValue(),velocity.gradientZMin.getAverageValue());
					lifeMaxVelocity=new Vector3(velocity.gradientXMax.getAverageValue(),velocity.gradientYMax.getAverageValue(),velocity.gradientZMax.getAverageValue());
					break ;
				}
		};
		var positionScale,velocityScale;
		var transform=this._owner.transform;
		var worldPosition=transform.position;
		var sizeScale=ShurikenParticleSystem._tempVector39;
		var renderMode=particleRender.renderMode;
		switch (this.scaleMode){
			case 0:;
				var scale=transform.scale;
				positionScale=scale;
				sizeScale.x=scale.x;
				sizeScale.y=scale.z;
				sizeScale.z=scale.y;
				(renderMode===1)&& (velocityScale=scale);
				break ;
			case 1:;
				var localScale=transform.localScale;
				positionScale=localScale;
				sizeScale.x=localScale.x;
				sizeScale.y=localScale.z;
				sizeScale.z=localScale.y;
				(renderMode===1)&& (velocityScale=localScale);
				break ;
			case 2:
				positionScale=transform.scale;
				sizeScale.x=sizeScale.y=sizeScale.z=1;
				(renderMode===1)&& (velocityScale=Vector3._ONE);
				break ;
			};
		var minStratPosition,maxStratPosition;
		if (this._velocityOverLifetime && this._velocityOverLifetime.enbale){
			}else {
			minStratPosition=new Vector3(startMinVelocity.x *maxStartLifeTime,startMinVelocity.y *maxStartLifeTime,startMinVelocity.z *maxStartLifeTime);
			maxStratPosition=new Vector3(startMaxVelocity.x *maxStartLifeTime,startMaxVelocity.y *maxStartLifeTime,startMaxVelocity.z *maxStartLifeTime);
			if (this.scaleMode !=2){
				Vector3.add(minPosition,minStratPosition,boundMin);
				Vector3.multiply(positionScale,boundMin,boundMin);
				Vector3.add(maxPosition,maxStratPosition,boundMax);
				Vector3.multiply(positionScale,boundMax,boundMax);
				}else {
				Vector3.multiply(positionScale,minPosition,boundMin);
				Vector3.add(boundMin,minStratPosition,boundMin);
				Vector3.multiply(positionScale,maxPosition,boundMax);
				Vector3.add(boundMax,maxStratPosition,boundMax);
			}
		}
		switch (this.simulationSpace){
			case 0:
				break ;
			case 1:
				Vector3.add(boundMin,worldPosition,boundMin);
				Vector3.add(boundMax,worldPosition,boundMax);
				break ;
			};
		var maxSize=NaN,maxSizeY=NaN;
		switch (this.startSizeType){
			case 0:
				if (this.threeDStartSize){
					var startSizeConstantSeparate=startSizeConstantSeparate;
					maxSize=Math.max(startSizeConstantSeparate.x,startSizeConstantSeparate.y);
					if (renderMode===1)
						maxSizeY=startSizeConstantSeparate.y;
					}else {
					maxSize=this.startSizeConstant;
					if (renderMode===1)
						maxSizeY=this.startSizeConstant;
				}
				break ;
			case 1:
				break ;
			case 2:
				if (this.threeDStartSize){
					var startSizeConstantMaxSeparate=startSizeConstantMaxSeparate;
					maxSize=Math.max(startSizeConstantMaxSeparate.x,startSizeConstantMaxSeparate.y);
					if (renderMode===1)
						maxSizeY=startSizeConstantMaxSeparate.y;
					}else {
					maxSize=this.startSizeConstantMax;
					if (renderMode===1)
						maxSizeY=this.startSizeConstantMax;
				}
				break ;
			case 3:
				break ;
			}
		if (this._sizeOverLifetime && this._sizeOverLifetime.enbale){
			var size=this._sizeOverLifetime.size;
			maxSize *=this._sizeOverLifetime.size.getMaxSizeInGradient();
		};
		var threeDMaxSize=ShurikenParticleSystem._tempVector30;
		var rotSize=NaN,nonRotSize=NaN;
		switch (renderMode){
			case 0:
				rotSize=maxSize *ShurikenParticleSystem.halfKSqrtOf2;
				Vector3.scale(sizeScale,maxSize,threeDMaxSize);
				Vector3.subtract(boundMin,threeDMaxSize,boundMin);
				Vector3.add(boundMax,threeDMaxSize,boundMax);
				break ;
			case 1:;
				var maxStretchPosition=ShurikenParticleSystem._tempVector31;
				var maxStretchVelocity=ShurikenParticleSystem._tempVector32;
				var minStretchVelocity=ShurikenParticleSystem._tempVector33;
				var minStretchPosition=ShurikenParticleSystem._tempVector34;
				if (this._velocityOverLifetime && this._velocityOverLifetime.enbale){
					}else {
					Vector3.multiply(velocityScale,startMaxVelocity,maxStretchVelocity);
					Vector3.multiply(velocityScale,startMinVelocity,minStretchVelocity);
				};
				var sizeStretch=maxSizeY *particleRender.stretchedBillboardLengthScale;
				var maxStretchLength=Vector3.scalarLength(maxStretchVelocity)*particleRender.stretchedBillboardSpeedScale+sizeStretch;
				var minStretchLength=Vector3.scalarLength(minStretchVelocity)*particleRender.stretchedBillboardSpeedScale+sizeStretch;
				var norMaxStretchVelocity=ShurikenParticleSystem._tempVector35;
				var norMinStretchVelocity=ShurikenParticleSystem._tempVector36;
				Vector3.normalize(maxStretchVelocity,norMaxStretchVelocity);
				Vector3.scale(norMaxStretchVelocity,maxStretchLength,minStretchPosition);
				Vector3.subtract(maxStratPosition,minStretchPosition,minStretchPosition);
				Vector3.normalize(minStretchVelocity,norMinStretchVelocity);
				Vector3.scale(norMinStretchVelocity,minStretchLength,maxStretchPosition);
				Vector3.add(minStratPosition,maxStretchPosition,maxStretchPosition);
				rotSize=maxSize *ShurikenParticleSystem.halfKSqrtOf2;
				Vector3.scale(sizeScale,rotSize,threeDMaxSize);
				var halfNorMaxStretchVelocity=ShurikenParticleSystem._tempVector37;
				var halfNorMinStretchVelocity=ShurikenParticleSystem._tempVector38;
				Vector3.scale(norMaxStretchVelocity,0.5,halfNorMaxStretchVelocity);
				Vector3.scale(norMinStretchVelocity,0.5,halfNorMinStretchVelocity);
				Vector3.multiply(halfNorMaxStretchVelocity,sizeScale,halfNorMaxStretchVelocity);
				Vector3.multiply(halfNorMinStretchVelocity,sizeScale,halfNorMinStretchVelocity);
				Vector3.add(boundMin,halfNorMinStretchVelocity,boundMin);
				Vector3.min(boundMin,minStretchPosition,boundMin);
				Vector3.subtract(boundMin,threeDMaxSize,boundMin);
				Vector3.subtract(boundMax,halfNorMaxStretchVelocity,boundMax);
				Vector3.max(boundMax,maxStretchPosition,boundMax);
				Vector3.add(boundMax,threeDMaxSize,boundMax);
				break ;
			case 2:
				maxSize *=Math.cos(0.78539816339744830961566084581988);
				nonRotSize=maxSize *0.5;
				threeDMaxSize.x=sizeScale.x *nonRotSize;
				threeDMaxSize.y=sizeScale.z *nonRotSize;
				Vector3.subtract(boundMin,threeDMaxSize,boundMin);
				Vector3.add(boundMax,threeDMaxSize,boundMax);
				break ;
			case 3:
				maxSize *=Math.cos(0.78539816339744830961566084581988);
				nonRotSize=maxSize *0.5;
				Vector3.scale(sizeScale,nonRotSize,threeDMaxSize);
				Vector3.subtract(boundMin,threeDMaxSize,boundMin);
				Vector3.add(boundMax,threeDMaxSize,boundMax);
				break ;
			}
		this._boundingBox.getCorners(this._boundingBoxCorners);
	}

	/**
	*@private
	*/
	__proto._updateEmission=function(){
		if (!this.isAlive)
			return;
		if (this._simulateUpdate){
			this._simulateUpdate=false;
		}
		else{
			var elapsedTime=(this._startUpdateLoopCount!==Stat.loopCount && !this._isPaused)?(this._owner._scene).timer._delta / 1000.0:0;
			elapsedTime=Math.min(ShurikenParticleSystem._maxElapsedTime,elapsedTime);
			this._updateParticles(elapsedTime);
		}
	}

	/**
	*@private
	*/
	__proto._updateParticles=function(elapsedTime){
		if (this._ownerRender.renderMode===4 && !this._ownerRender.mesh)
			return;
		this._currentTime+=elapsedTime;
		this._retireActiveParticles();
		this._freeRetiredParticles();
		this._totalDelayTime+=elapsedTime;
		if (this._totalDelayTime < this._playStartDelay){
			return;
		}
		if (this._emission.enbale&&this._isEmitting &&!this._isPaused)
			this._advanceTime(elapsedTime,this._currentTime);
	}

	/**
	*@private
	*/
	__proto._updateParticlesSimulationRestart=function(time){
		this._firstActiveElement=0;
		this._firstNewElement=0;
		this._firstFreeElement=0;
		this._firstRetiredElement=0;
		this._burstsIndex=0;
		this._frameRateTime=time;
		this._emissionTime=0;
		this._totalDelayTime=0;
		this._currentTime=time;
		var delayTime=time;
		if (delayTime < this._playStartDelay){
			this._totalDelayTime=delayTime;
			return;
		}
		if (this._emission.enbale)
			this._advanceTime(time,time);
	}

	/**
	*@private
	*/
	__proto._retireActiveParticles=function(){
		var epsilon=0.0001;
		while (this._firstActiveElement !=this._firstNewElement){
			var index=this._firstActiveElement *this._floatCountPerVertex *this._vertexStride;
			var timeIndex=index+this._timeIndex;
			var particleAge=this._currentTime-this._vertices[timeIndex];
			if (particleAge+epsilon < this._vertices[index+this._startLifeTimeIndex])
				break ;
			this._vertices[timeIndex]=this._drawCounter;
			this._firstActiveElement++;
			if (this._firstActiveElement >=this._bufferMaxParticles)
				this._firstActiveElement=0;
		}
	}

	/**
	*@private
	*/
	__proto._freeRetiredParticles=function(){
		while (this._firstRetiredElement !=this._firstActiveElement){
			var age=this._drawCounter-this._vertices[this._firstRetiredElement *this._floatCountPerVertex *this._vertexStride+this._timeIndex];
			if (this.isPerformanceMode)
				if (age < 3)
			break ;
			this._firstRetiredElement++;
			if (this._firstRetiredElement >=this._bufferMaxParticles)
				this._firstRetiredElement=0;
		}
	}

	/**
	*@private
	*/
	__proto._burst=function(fromTime,toTime){
		var totalEmitCount=0;
		var bursts=this._emission._bursts;
		for (var n=bursts.length;this._burstsIndex < n;this._burstsIndex++){
			var burst=bursts[this._burstsIndex];
			var burstTime=burst.time;
			if (fromTime<=burstTime && burstTime < toTime){
				var emitCount=0;
				if (this.autoRandomSeed){
					emitCount=MathUtil.lerp(burst.minCount,burst.maxCount,Math.random());
					}else {
					this._rand.seed=this._randomSeeds[0];
					emitCount=MathUtil.lerp(burst.minCount,burst.maxCount,this._rand.getFloat());
					this._randomSeeds[0]=this._rand.seed;
				}
				totalEmitCount+=emitCount;
				}else {
				break ;
			}
		}
		return totalEmitCount;
	}

	/**
	*@private
	*/
	__proto._advanceTime=function(elapsedTime,emitTime){
		var i=0;
		var lastEmissionTime=this._emissionTime;
		this._emissionTime+=elapsedTime;
		var totalEmitCount=0;
		if (this._emissionTime > this.duration){
			if (this.looping){
				totalEmitCount+=this._burst(lastEmissionTime,this._emissionTime);
				this._emissionTime-=this.duration;
				this._burstsIndex=0;
				totalEmitCount+=this._burst(0,this._emissionTime);
				}else {
				totalEmitCount=Math.min(this.maxParticles-this.aliveParticleCount,totalEmitCount);
				for (i=0;i < totalEmitCount;i++)
				this.emit(emitTime);
				this._isPlaying=false;
				this.stop();
				return;
			}
			}else {
			totalEmitCount+=this._burst(lastEmissionTime,this._emissionTime);
		}
		totalEmitCount=Math.min(this.maxParticles-this.aliveParticleCount,totalEmitCount);
		for (i=0;i < totalEmitCount;i++)
		this.emit(emitTime);
		var emissionRate=this.emission.emissionRate;
		if (emissionRate>0){
			var minEmissionTime=1/emissionRate;
			this._frameRateTime+=minEmissionTime;
			this._frameRateTime=this._currentTime-(this._currentTime-this._frameRateTime)% this._maxStartLifetime;
			while (this._frameRateTime <=emitTime){
				if (this.emit(this._frameRateTime))
					this._frameRateTime+=minEmissionTime;
				else
				break ;
			}
			this._frameRateTime=Math.floor(emitTime / minEmissionTime)*minEmissionTime;
		}
	}

	/**
	*@private
	*/
	__proto._initBufferDatas=function(){
		if (this._vertexBuffer){
			this._vertexBuffer.destroy();
			this._indexBuffer.destroy();
		};
		var render=this._ownerRender;
		var renderMode=render.renderMode;
		if (renderMode!==-1 && this.maxParticles > 0){
			var indices,i=0,j=0,m=0,indexOffset=0,perPartOffset=0,vertexDeclaration;;
			var vbMemorySize=0,memorySize=0;
			var mesh=render.mesh;
			if (renderMode===4){
				if(mesh){
					var vertexBufferCount=mesh._vertexBuffers.length;
					if (vertexBufferCount > 1){
						throw new Error("ShurikenParticleSystem: submesh Count mesh be One or all subMeshes have the same vertexDeclaration.");
						}else {
						vertexDeclaration=VertexShurikenParticleMesh.vertexDeclaration;
						this._floatCountPerVertex=vertexDeclaration.vertexStride/4;
						this._startLifeTimeIndex=12;
						this._timeIndex=16;
						this._vertexStride=mesh._vertexBuffers[0].vertexCount;
						var totalVertexCount=this._bufferMaxParticles *this._vertexStride;
						var vbCount=Math.floor(totalVertexCount / 65535)+1;
						var lastVBVertexCount=totalVertexCount % 65535;
						if (vbCount > 1){
							throw new Error("ShurikenParticleSystem:the maxParticleCount multiply mesh vertexCount is large than 65535.");
						}
						vbMemorySize=vertexDeclaration.vertexStride *lastVBVertexCount;
						this._vertexBuffer=new VertexBuffer3D(vbMemorySize,/*laya.webgl.WebGLContext.DYNAMIC_DRAW*/0x88E8);
						this._vertexBuffer.vertexDeclaration=vertexDeclaration;
						this._vertices=new Float32Array(this._floatCountPerVertex *lastVBVertexCount);
						this._indexStride=mesh._indexBuffer.indexCount;
						var indexDatas=mesh._indexBuffer.getData();
						var indexCount=this._bufferMaxParticles *this._indexStride;
						this._indexBuffer=new IndexBuffer3D(/*laya.d3.graphics.IndexBuffer3D.INDEXTYPE_USHORT*/"ushort",indexCount,/*laya.webgl.WebGLContext.STATIC_DRAW*/0x88E4);
						indices=new Uint16Array(indexCount);
						memorySize=vbMemorySize+indexCount *2;
						indexOffset=0;
						for (i=0;i < this._bufferMaxParticles;i++){
							var indexValueOffset=i *this._vertexStride;
							for (j=0,m=indexDatas.length;j < m;j++)
							indices[indexOffset++]=indexValueOffset+indexDatas[j];
						}
						this._indexBuffer.setData(indices);
						this._bufferState.bind();
						this._bufferState.applyVertexBuffer(this._vertexBuffer);
						this._bufferState.applyIndexBuffer(this._indexBuffer);
						this._bufferState.unBind();
					}
				}
				}else {
				vertexDeclaration=VertexShurikenParticleBillboard.vertexDeclaration;
				this._floatCountPerVertex=vertexDeclaration.vertexStride/4;
				this._startLifeTimeIndex=7;
				this._timeIndex=11;
				this._vertexStride=4;
				vbMemorySize=vertexDeclaration.vertexStride *this._bufferMaxParticles *this._vertexStride;
				this._vertexBuffer=new VertexBuffer3D(vbMemorySize,/*laya.webgl.WebGLContext.DYNAMIC_DRAW*/0x88E8);
				this._vertexBuffer.vertexDeclaration=vertexDeclaration;
				this._vertices=new Float32Array(this._floatCountPerVertex *this._bufferMaxParticles *this._vertexStride);
				for (i=0;i < this._bufferMaxParticles;i++){
					perPartOffset=i *this._floatCountPerVertex *this._vertexStride;
					this._vertices[perPartOffset]=-0.5;
					this._vertices[perPartOffset+1]=-0.5;
					this._vertices[perPartOffset+2]=0;
					this._vertices[perPartOffset+3]=1;
					perPartOffset+=this._floatCountPerVertex;
					this._vertices[perPartOffset]=0.5;
					this._vertices[perPartOffset+1]=-0.5;
					this._vertices[perPartOffset+2]=1;
					this._vertices[perPartOffset+3]=1;
					perPartOffset+=this._floatCountPerVertex
					this._vertices[perPartOffset]=0.5;
					this._vertices[perPartOffset+1]=0.5;
					this._vertices[perPartOffset+2]=1;
					this._vertices[perPartOffset+3]=0;
					perPartOffset+=this._floatCountPerVertex
					this._vertices[perPartOffset]=-0.5;
					this._vertices[perPartOffset+1]=0.5;
					this._vertices[perPartOffset+2]=0;
					this._vertices[perPartOffset+3]=0;
				}
				this._indexStride=6;
				this._indexBuffer=new IndexBuffer3D(/*laya.d3.graphics.IndexBuffer3D.INDEXTYPE_USHORT*/"ushort",this._bufferMaxParticles *6,/*laya.webgl.WebGLContext.STATIC_DRAW*/0x88E4);
				indices=new Uint16Array(this._bufferMaxParticles *6);
				for (i=0;i < this._bufferMaxParticles;i++){
					indexOffset=i *6;
					var firstVertex=i *this._vertexStride,secondVertex=firstVertex+2;
					indices[indexOffset++]=firstVertex;
					indices[indexOffset++]=secondVertex;
					indices[indexOffset++]=firstVertex+1;
					indices[indexOffset++]=firstVertex;
					indices[indexOffset++]=firstVertex+3;
					indices[indexOffset++]=secondVertex;
				}
				this._indexBuffer.setData(indices);
				memorySize=vbMemorySize+this._bufferMaxParticles *6 *2;
				this._bufferState.bind();
				this._bufferState.applyVertexBuffer(this._vertexBuffer);
				this._bufferState.applyIndexBuffer(this._indexBuffer);
				this._bufferState.unBind();
			}
			Resource._addMemory(memorySize,memorySize);
		}
	}

	/**
	*@private
	*/
	__proto.destroy=function(){
		_super.prototype.destroy.call(this);
		var memorySize=this._vertexBuffer._byteLength+this._indexBuffer.indexCount *2;
		Resource._addMemory(-memorySize,-memorySize);
		this._bufferState.destroy();
		this._vertexBuffer.destroy();
		this._indexBuffer.destroy();
		this._emission.destroy();
		this._bufferState=null;
		this._vertexBuffer=null;
		this._indexBuffer=null;
		this._owner=null;
		this._vertices=null;
		this._indexBuffer=null;
		this._emission=null;
		this._shape=null;
		this.startLifeTimeGradient=null;
		this.startLifeTimeGradientMin=null;
		this.startLifeTimeGradientMax=null;
		this.startSizeConstantSeparate=null;
		this.startSizeConstantMinSeparate=null;
		this.startSizeConstantMaxSeparate=null;
		this.startRotationConstantSeparate=null;
		this.startRotationConstantMinSeparate=null;
		this.startRotationConstantMaxSeparate=null;
		this.startColorConstant=null;
		this.startColorConstantMin=null;
		this.startColorConstantMax=null;
		this._velocityOverLifetime=null;
		this._colorOverLifetime=null;
		this._sizeOverLifetime=null;
		this._rotationOverLifetime=null;
		this._textureSheetAnimation=null;
	}

	/**
	*发射一个粒子。
	*/
	__proto.emit=function(time){
		var position=ShurikenParticleSystem._tempPosition;
		var direction=ShurikenParticleSystem._tempDirection;
		if (this._shape&&this._shape.enable){
			if (this.autoRandomSeed)
				this._shape.generatePositionAndDirection(position,direction);
			else
			this._shape.generatePositionAndDirection(position,direction,this._rand,this._randomSeeds);
			}else {
			position.x=position.y=position.z=0;
			direction.x=direction.y=0;
			direction.z=1;
		}
		return this.addParticle(position,direction,time);
	}

	//TODO:提前判断优化
	__proto.addParticle=function(position,direction,time){
		Vector3.normalize(direction,direction);
		var nextFreeParticle=this._firstFreeElement+1;
		if (nextFreeParticle >=this._bufferMaxParticles)
			nextFreeParticle=0;
		if (nextFreeParticle===this._firstRetiredElement)
			return false;
		ShurikenParticleData.create(this,this._ownerRender,this._owner.transform);
		var particleAge=this._currentTime-time;
		if (particleAge >=ShurikenParticleData.startLifeTime)
			return true;
		var randomVelocityX=NaN,randomVelocityY=NaN,randomVelocityZ=NaN,randomColor=NaN,randomSize=NaN,randomRotation=NaN,randomTextureAnimation=NaN;
		var needRandomVelocity=this._velocityOverLifetime && this._velocityOverLifetime.enbale;
		if (needRandomVelocity){
			var velocityType=this._velocityOverLifetime.velocity.type;
			if (velocityType===2 || velocityType===3){
				if (this.autoRandomSeed){
					randomVelocityX=Math.random();
					randomVelocityY=Math.random();
					randomVelocityZ=Math.random();
					}else {
					this._rand.seed=this._randomSeeds[9];
					randomVelocityX=this._rand.getFloat();
					randomVelocityY=this._rand.getFloat();
					randomVelocityZ=this._rand.getFloat();
					this._randomSeeds[9]=this._rand.seed;
				}
				}else {
				needRandomVelocity=false;
			}
			}else {
			needRandomVelocity=false;
		};
		var needRandomColor=this._colorOverLifetime && this._colorOverLifetime.enbale;
		if (needRandomColor){
			var colorType=this._colorOverLifetime.color.type;
			if (colorType===3){
				if (this.autoRandomSeed){
					randomColor=Math.random();
					}else {
					this._rand.seed=this._randomSeeds[10];
					randomColor=this._rand.getFloat();
					this._randomSeeds[10]=this._rand.seed;
				}
				}else {
				needRandomColor=false;
			}
			}else {
			needRandomColor=false;
		};
		var needRandomSize=this._sizeOverLifetime && this._sizeOverLifetime.enbale;
		if (needRandomSize){
			var sizeType=this._sizeOverLifetime.size.type;
			if (sizeType===3){
				if (this.autoRandomSeed){
					randomSize=Math.random();
					}else {
					this._rand.seed=this._randomSeeds[11];
					randomSize=this._rand.getFloat();
					this._randomSeeds[11]=this._rand.seed;
				}
				}else {
				needRandomSize=false;
			}
			}else {
			needRandomSize=false;
		};
		var needRandomRotation=this._rotationOverLifetime && this._rotationOverLifetime.enbale;
		if (needRandomRotation){
			var rotationType=this._rotationOverLifetime.angularVelocity.type;
			if (rotationType===2 || rotationType===3){
				if (this.autoRandomSeed){
					randomRotation=Math.random();
					}else {
					this._rand.seed=this._randomSeeds[12];
					randomRotation=this._rand.getFloat();
					this._randomSeeds[12]=this._rand.seed;
				}
				}else {
				needRandomRotation=false;
			}
			}else {
			needRandomRotation=false;
		};
		var needRandomTextureAnimation=this._textureSheetAnimation && this._textureSheetAnimation.enable;
		if (needRandomTextureAnimation){
			var textureAnimationType=this._textureSheetAnimation.frame.type;
			if (textureAnimationType===3){
				if (this.autoRandomSeed){
					randomTextureAnimation=Math.random();
					}else {
					this._rand.seed=this._randomSeeds[15];
					randomTextureAnimation=this._rand.getFloat();
					this._randomSeeds[15]=this._rand.seed;
				}
				}else {
				needRandomTextureAnimation=false;
			}
			}else {
			needRandomTextureAnimation=false;
		};
		var startIndex=this._firstFreeElement *this._floatCountPerVertex *this._vertexStride;
		var subU=ShurikenParticleData.startUVInfo[0];
		var subV=ShurikenParticleData.startUVInfo[1];
		var startU=ShurikenParticleData.startUVInfo[2];
		var startV=ShurikenParticleData.startUVInfo[3];
		var meshVertices,meshVertexStride=0,meshPosOffset=0,meshCorOffset=0,meshUVOffset=0,meshVertexIndex=0;
		var render=this._ownerRender;
		if (render.renderMode===4){
			var meshVB=render.mesh._vertexBuffers[0];
			meshVertices=meshVB.getData();
			var meshVertexDeclaration=meshVB.vertexDeclaration;
			meshPosOffset=meshVertexDeclaration.getVertexElementByUsage(/*laya.d3.graphics.Vertex.VertexMesh.MESH_POSITION0*/0).offset / 4;
			var colorElement=meshVertexDeclaration.getVertexElementByUsage(/*laya.d3.graphics.Vertex.VertexMesh.MESH_COLOR0*/1);
			meshCorOffset=colorElement?colorElement.offset / 4:-1;
			var uvElement=meshVertexDeclaration.getVertexElementByUsage(/*laya.d3.graphics.Vertex.VertexMesh.MESH_TEXTURECOORDINATE0*/2);
			meshUVOffset=uvElement?uvElement.offset / 4:-1;
			meshVertexStride=meshVertexDeclaration.vertexStride / 4;
			meshVertexIndex=0;
			}else {
			this._vertices[startIndex+2]=startU;
			this._vertices[startIndex+3]=startV+subV;
			var secondOffset=startIndex+this._floatCountPerVertex;
			this._vertices[secondOffset+2]=startU+subU;
			this._vertices[secondOffset+3]=startV+subV;
			var thirdOffset=secondOffset+this._floatCountPerVertex;
			this._vertices[thirdOffset+2]=startU+subU;
			this._vertices[thirdOffset+3]=startV;
			var fourthOffset=thirdOffset+this._floatCountPerVertex;
			this._vertices[fourthOffset+2]=startU;
			this._vertices[fourthOffset+3]=startV;
		}
		for (var i=startIndex,n=startIndex+this._floatCountPerVertex *this._vertexStride;i < n;i+=this._floatCountPerVertex){
			var offset=0;
			if (render.renderMode===4){
				offset=i;
				var vertexOffset=meshVertexStride *(meshVertexIndex++);
				var meshOffset=vertexOffset+meshPosOffset;
				this._vertices[offset++]=meshVertices[meshOffset++];
				this._vertices[offset++]=meshVertices[meshOffset++];
				this._vertices[offset++]=meshVertices[meshOffset];
				if (meshCorOffset===-1){
					this._vertices[offset++]=1.0;
					this._vertices[offset++]=1.0;
					this._vertices[offset++]=1.0;
					this._vertices[offset++]=1.0;
				}
				else{
					meshOffset=vertexOffset+meshCorOffset;
					this._vertices[offset++]=meshVertices[meshOffset++];
					this._vertices[offset++]=meshVertices[meshOffset++];
					this._vertices[offset++]=meshVertices[meshOffset++];
					this._vertices[offset++]=meshVertices[meshOffset];
				}
				if (meshUVOffset===-1){
					this._vertices[offset++]=0.0;
					this._vertices[offset++]=0.0;
				}
				else{
					meshOffset=vertexOffset+meshUVOffset;
					this._vertices[offset++]=startU+meshVertices[meshOffset++] *subU;
					this._vertices[offset++]=startV+meshVertices[meshOffset] *subV;
				}
				}else {
				offset=i+4;
			}
			this._vertices[offset++]=position.x;
			this._vertices[offset++]=position.y;
			this._vertices[offset++]=position.z;
			this._vertices[offset++]=ShurikenParticleData.startLifeTime;
			this._vertices[offset++]=direction.x;
			this._vertices[offset++]=direction.y;
			this._vertices[offset++]=direction.z;
			this._vertices[offset++]=time;
			this._vertices[offset++]=ShurikenParticleData.startColor.x;
			this._vertices[offset++]=ShurikenParticleData.startColor.y;
			this._vertices[offset++]=ShurikenParticleData.startColor.z;
			this._vertices[offset++]=ShurikenParticleData.startColor.w;
			this._vertices[offset++]=ShurikenParticleData.startSize[0];
			this._vertices[offset++]=ShurikenParticleData.startSize[1];
			this._vertices[offset++]=ShurikenParticleData.startSize[2];
			this._vertices[offset++]=ShurikenParticleData.startRotation[0];
			this._vertices[offset++]=ShurikenParticleData.startRotation[1];
			this._vertices[offset++]=ShurikenParticleData.startRotation[2];
			this._vertices[offset++]=ShurikenParticleData.startSpeed;
			needRandomColor && (this._vertices[offset+1]=randomColor);
			needRandomSize && (this._vertices[offset+2]=randomSize);
			needRandomRotation && (this._vertices[offset+3]=randomRotation);
			needRandomTextureAnimation && (this._vertices[offset+4]=randomTextureAnimation);
			if (needRandomVelocity){
				this._vertices[offset+5]=randomVelocityX;
				this._vertices[offset+6]=randomVelocityY;
				this._vertices[offset+7]=randomVelocityZ;
			}
			switch(this.simulationSpace){
				case 0:
					offset+=8;
					this._vertices[offset++]=ShurikenParticleData.simulationWorldPostion[0];
					this._vertices[offset++]=ShurikenParticleData.simulationWorldPostion[1];
					this._vertices[offset++]=ShurikenParticleData.simulationWorldPostion[2];
					this._vertices[offset++]=ShurikenParticleData.simulationWorldRotation[0];
					this._vertices[offset++]=ShurikenParticleData.simulationWorldRotation[1];
					this._vertices[offset++]=ShurikenParticleData.simulationWorldRotation[2];
					this._vertices[offset++]=ShurikenParticleData.simulationWorldRotation[3];
					break ;
				case 1:
					break ;
				default :
					throw new Error("ShurikenParticleMaterial: SimulationSpace value is invalid.");
				}
		}
		this._firstFreeElement=nextFreeParticle;
		return true;
	}

	__proto.addNewParticlesToVertexBuffer=function(){
		var start=0;
		if (this._firstNewElement < this._firstFreeElement){
			start=this._firstNewElement *this._vertexStride *this._floatCountPerVertex;
			this._vertexBuffer.setData(this._vertices,start,start,(this._firstFreeElement-this._firstNewElement)*this._vertexStride *this._floatCountPerVertex);
			}else {
			start=this._firstNewElement *this._vertexStride *this._floatCountPerVertex;
			this._vertexBuffer.setData(this._vertices,start,start,(this._bufferMaxParticles-this._firstNewElement)*this._vertexStride *this._floatCountPerVertex);
			if (this._firstFreeElement > 0){
				this._vertexBuffer.setData(this._vertices,0,0,this._firstFreeElement *this._vertexStride *this._floatCountPerVertex);
			}
		}
		this._firstNewElement=this._firstFreeElement;
	}

	/**
	*@inheritDoc
	*/
	__proto._getType=function(){
		return ShurikenParticleSystem._type;
	}

	/**
	*@inheritDoc
	*/
	__proto._prepareRender=function(state){
		this._updateEmission();
		if (this._firstNewElement !=this._firstFreeElement)
			this.addNewParticlesToVertexBuffer();
		this._drawCounter++;
		if (this._firstActiveElement !=this._firstFreeElement)
			return true;
		else
		return false;
	}

	/**
	*@private
	*/
	__proto._render=function(state){
		this._bufferState.bind();
		var indexCount=0;
		var gl=LayaGL.instance;
		if (this._firstActiveElement < this._firstFreeElement){
			indexCount=(this._firstFreeElement-this._firstActiveElement)*this._indexStride;
			gl.drawElements(/*laya.webgl.WebGLContext.TRIANGLES*/0x0004,indexCount,/*laya.webgl.WebGLContext.UNSIGNED_SHORT*/0x1403,2 *this._firstActiveElement *this._indexStride);
			Stat.trianglesFaces+=indexCount / 3;
			Stat.renderBatches++;
			}else {
			indexCount=(this._bufferMaxParticles-this._firstActiveElement)*this._indexStride;
			gl.drawElements(/*laya.webgl.WebGLContext.TRIANGLES*/0x0004,indexCount,/*laya.webgl.WebGLContext.UNSIGNED_SHORT*/0x1403,2 *this._firstActiveElement *this._indexStride);
			Stat.trianglesFaces+=indexCount / 3;
			Stat.renderBatches++;
			if (this._firstFreeElement > 0){
				indexCount=this._firstFreeElement *this._indexStride;
				gl.drawElements(/*laya.webgl.WebGLContext.TRIANGLES*/0x0004,indexCount,/*laya.webgl.WebGLContext.UNSIGNED_SHORT*/0x1403,0);
				Stat.trianglesFaces+=indexCount / 3;
				Stat.renderBatches++;
			}
		}
	}

	/**
	*开始发射粒子。
	*/
	__proto.play=function(){
		this._burstsIndex=0;
		this._isEmitting=true;
		this._isPlaying=true;
		this._isPaused=false;
		this._emissionTime=0;
		this._totalDelayTime=0;
		if (!this.autoRandomSeed){
			for (var i=0,n=this._randomSeeds.length;i < n;i++)
			this._randomSeeds[i]=this.randomSeed[0]+ShurikenParticleSystem._RANDOMOFFSET[i];
		}
		switch (this.startDelayType){
			case 0:
				this._playStartDelay=this.startDelay;
				break ;
			case 1:
				if (this.autoRandomSeed){
					this._playStartDelay=MathUtil.lerp(this.startDelayMin,this.startDelayMax,Math.random());
					}else {
					this._rand.seed=this._randomSeeds[2];
					this._playStartDelay=MathUtil.lerp(this.startDelayMin,this.startDelayMax,this._rand.getFloat());
					this._randomSeeds[2]=this._rand.seed;
				}
				break ;
			default :
				throw new Error("Utils3D: startDelayType is invalid.");
			}
		this._frameRateTime=this._currentTime+this._playStartDelay;
		this._startUpdateLoopCount=Stat.loopCount;
	}

	/**
	*暂停发射粒子。
	*/
	__proto.pause=function(){
		this._isPaused=true;
	}

	/**
	*通过指定时间增加粒子播放进度，并暂停播放。
	*@param time 进度时间.如果restart为true,粒子播放时间会归零后再更新进度。
	*@param restart 是否重置播放状态。
	*/
	__proto.simulate=function(time,restart){
		(restart===void 0)&& (restart=true);
		this._simulateUpdate=true;
		if (restart){
			this._updateParticlesSimulationRestart(time);
		}
		else{
			this._isPaused=false;
			this._updateParticles(time);
		}
		this.pause();
	}

	/**
	*停止发射粒子。
	*/
	__proto.stop=function(){
		this._burstsIndex=0;
		this._isEmitting=false;
		this._emissionTime=0;
	}

	/**
	*克隆。
	*@param destObject 克隆源。
	*/
	__proto.cloneTo=function(destObject){
		var dest=destObject;
		dest.duration=this.duration;
		dest.looping=this.looping;
		dest.prewarm=this.prewarm;
		dest.startDelayType=this.startDelayType;
		dest.startDelay=this.startDelay;
		dest.startDelayMin=this.startDelayMin;
		dest.startDelayMax=this.startDelayMax;
		dest._maxStartLifetime=this._maxStartLifetime;
		dest.startLifetimeType=this.startLifetimeType;
		dest.startLifetimeConstant=this.startLifetimeConstant;
		this.startLifeTimeGradient.cloneTo(dest.startLifeTimeGradient);
		dest.startLifetimeConstantMin=this.startLifetimeConstantMin;
		dest.startLifetimeConstantMax=this.startLifetimeConstantMax;
		this.startLifeTimeGradientMin.cloneTo(dest.startLifeTimeGradientMin);
		this.startLifeTimeGradientMax.cloneTo(dest.startLifeTimeGradientMax);
		dest.startSpeedType=this.startSpeedType;
		dest.startSpeedConstant=this.startSpeedConstant;
		dest.startSpeedConstantMin=this.startSpeedConstantMin;
		dest.startSpeedConstantMax=this.startSpeedConstantMax;
		dest.threeDStartSize=this.threeDStartSize;
		dest.startSizeType=this.startSizeType;
		dest.startSizeConstant=this.startSizeConstant;
		this.startSizeConstantSeparate.cloneTo(dest.startSizeConstantSeparate);
		dest.startSizeConstantMin=this.startSizeConstantMin;
		dest.startSizeConstantMax=this.startSizeConstantMax;
		this.startSizeConstantMinSeparate.cloneTo(dest.startSizeConstantMinSeparate);
		this.startSizeConstantMaxSeparate.cloneTo(dest.startSizeConstantMaxSeparate);
		dest.threeDStartRotation=this.threeDStartRotation;
		dest.startRotationType=this.startRotationType;
		dest.startRotationConstant=this.startRotationConstant;
		this.startRotationConstantSeparate.cloneTo(dest.startRotationConstantSeparate);
		dest.startRotationConstantMin=this.startRotationConstantMin;
		dest.startRotationConstantMax=this.startRotationConstantMax;
		this.startRotationConstantMinSeparate.cloneTo(dest.startRotationConstantMinSeparate);
		this.startRotationConstantMaxSeparate.cloneTo(dest.startRotationConstantMaxSeparate);
		dest.randomizeRotationDirection=this.randomizeRotationDirection;
		dest.startColorType=this.startColorType;
		this.startColorConstant.cloneTo(dest.startColorConstant);
		this.startColorConstantMin.cloneTo(dest.startColorConstantMin);
		this.startColorConstantMax.cloneTo(dest.startColorConstantMax);
		dest.gravityModifier=this.gravityModifier;
		dest.simulationSpace=this.simulationSpace;
		dest.scaleMode=this.scaleMode;
		dest.playOnAwake=this.playOnAwake;
		dest.maxParticles=this.maxParticles;
		(this._emission)&& (dest._emission=this._emission.clone());
		(this.shape)&& (dest.shape=this.shape.clone());
		(this.velocityOverLifetime)&& (dest.velocityOverLifetime=this.velocityOverLifetime.clone());
		(this.colorOverLifetime)&& (dest.colorOverLifetime=this.colorOverLifetime.clone());
		(this.sizeOverLifetime)&& (dest.sizeOverLifetime=this.sizeOverLifetime.clone());
		(this.rotationOverLifetime)&& (dest.rotationOverLifetime=this.rotationOverLifetime.clone());
		(this.textureSheetAnimation)&& (dest.textureSheetAnimation=this.textureSheetAnimation.clone());
		dest.isPerformanceMode=this.isPerformanceMode;
		dest._isEmitting=this._isEmitting;
		dest._isPlaying=this._isPlaying;
		dest._isPaused=this._isPaused;
		dest._playStartDelay=this._playStartDelay;
		dest._frameRateTime=this._frameRateTime;
		dest._emissionTime=this._emissionTime;
		dest._totalDelayTime=this._totalDelayTime;
		dest._burstsIndex=this._burstsIndex;
	}

	/**
	*克隆。
	*@return 克隆副本。
	*/
	__proto.clone=function(){
		var dest=/*__JS__ */new this.constructor();
		this.cloneTo(dest);
		return dest;
	}

	/**设置最大粒子数,注意:谨慎修改此属性，有性能损耗。*/
	/**获取最大粒子数。*/
	__getset(0,__proto,'maxParticles',function(){
		return this._bufferMaxParticles-1;
		},function(value){
		var newMaxParticles=value+1;
		if (newMaxParticles!==this._bufferMaxParticles){
			this._bufferMaxParticles=newMaxParticles;
			this._initBufferDatas();
		}
	});

	/**
	*是否正在发射。
	*/
	__getset(0,__proto,'isEmitting',function(){
		return this._isEmitting;
	});

	/**
	*是否存活。
	*/
	__getset(0,__proto,'isAlive',function(){
		if (this._isPlaying || this.aliveParticleCount > 0)
			return true;
		return false;
	});

	/**
	*设置形状。
	*/
	/**
	*获取形状。
	*/
	__getset(0,__proto,'shape',function(){
		return this._shape;
		},function(value){
		if (this._shape!==value){
			if (value&&value.enable)
				this._owner._render._defineDatas.add(ShuriKenParticle3D.SHADERDEFINE_SHAPE);
			else
			this._owner._render._defineDatas.remove(ShuriKenParticle3D.SHADERDEFINE_SHAPE);
			this._shape=value;
		}
	});

	/**
	*设置生命周期旋转,注意:如修改该值的某些属性,需重新赋值此属性才可生效。
	*@param value 生命周期旋转。
	*/
	/**
	*获取生命周期旋转,注意:如修改该值的某些属性,需重新赋值此属性才可生效。
	*@return 生命周期旋转。
	*/
	__getset(0,__proto,'rotationOverLifetime',function(){
		return this._rotationOverLifetime;
		},function(value){
		var defDat=this._owner._render._defineDatas;
		var shaDat=this._owner._render._shaderValues;
		if (value){
			var rotation=value.angularVelocity;
			if (!rotation)
				return;
			var rotationSeparate=rotation.separateAxes;
			var rotationType=rotation.type;
			if (value.enbale){
				if (rotationSeparate)
					defDat.add(ShuriKenParticle3D.SHADERDEFINE_ROTATIONOVERLIFETIMESEPERATE);
				else
				defDat.add(ShuriKenParticle3D.SHADERDEFINE_ROTATIONOVERLIFETIME);
				switch (rotationType){
					case 0:
						defDat.add(ShuriKenParticle3D.SHADERDEFINE_ROTATIONOVERLIFETIMECONSTANT);
						break ;
					case 1:
						defDat.add(ShuriKenParticle3D.SHADERDEFINE_ROTATIONOVERLIFETIMECURVE);
						break ;
					case 2:
						defDat.add(ShuriKenParticle3D.SHADERDEFINE_ROTATIONOVERLIFETIMERANDOMCONSTANTS);
						break ;
					case 3:
						defDat.add(ShuriKenParticle3D.SHADERDEFINE_ROTATIONOVERLIFETIMERANDOMCURVES);
						break ;
					}
				}else {
				defDat.remove(ShuriKenParticle3D.SHADERDEFINE_ROTATIONOVERLIFETIME);
				defDat.remove(ShuriKenParticle3D.SHADERDEFINE_ROTATIONOVERLIFETIMESEPERATE);
				defDat.remove(ShuriKenParticle3D.SHADERDEFINE_ROTATIONOVERLIFETIMECONSTANT);
				defDat.remove(ShuriKenParticle3D.SHADERDEFINE_ROTATIONOVERLIFETIMECURVE);
				defDat.remove(ShuriKenParticle3D.SHADERDEFINE_ROTATIONOVERLIFETIMERANDOMCONSTANTS);
				defDat.remove(ShuriKenParticle3D.SHADERDEFINE_ROTATIONOVERLIFETIMERANDOMCURVES);
			}
			switch (rotationType){
				case 0:
					if (rotationSeparate){
						shaDat.setVector3(ShuriKenParticle3D.ROLANGULARVELOCITYCONSTSEPRARATE,rotation.constantSeparate);
						}else {
						shaDat.setNumber(ShuriKenParticle3D.ROLANGULARVELOCITYCONST,rotation.constant);
					}
					break ;
				case 1:
					if (rotationSeparate){
						shaDat.setBuffer(ShuriKenParticle3D.ROLANGULARVELOCITYGRADIENTX,rotation.gradientX._elements);
						shaDat.setBuffer(ShuriKenParticle3D.ROLANGULARVELOCITYGRADIENTY,rotation.gradientY._elements);
						shaDat.setBuffer(ShuriKenParticle3D.ROLANGULARVELOCITYGRADIENTZ,rotation.gradientZ._elements);
						}else {
						shaDat.setBuffer(ShuriKenParticle3D.ROLANGULARVELOCITYGRADIENT,rotation.gradient._elements);
					}
					break ;
				case 2:
					if (rotationSeparate){
						shaDat.setVector3(ShuriKenParticle3D.ROLANGULARVELOCITYCONSTSEPRARATE,rotation.constantMinSeparate);
						shaDat.setVector3(ShuriKenParticle3D.ROLANGULARVELOCITYCONSTMAXSEPRARATE,rotation.constantMaxSeparate);
						}else {
						shaDat.setNumber(ShuriKenParticle3D.ROLANGULARVELOCITYCONST,rotation.constantMin);
						shaDat.setNumber(ShuriKenParticle3D.ROLANGULARVELOCITYCONSTMAX,rotation.constantMax);
					}
					break ;
				case 3:
					if (rotationSeparate){
						shaDat.setBuffer(ShuriKenParticle3D.ROLANGULARVELOCITYGRADIENTX,rotation.gradientXMin._elements);
						shaDat.setBuffer(ShuriKenParticle3D.ROLANGULARVELOCITYGRADIENTXMAX,rotation.gradientXMax._elements);
						shaDat.setBuffer(ShuriKenParticle3D.ROLANGULARVELOCITYGRADIENTY,rotation.gradientYMin._elements);
						shaDat.setBuffer(ShuriKenParticle3D.ROLANGULARVELOCITYGRADIENTYMAX,rotation.gradientYMax._elements);
						shaDat.setBuffer(ShuriKenParticle3D.ROLANGULARVELOCITYGRADIENTZ,rotation.gradientZMin._elements);
						shaDat.setBuffer(ShuriKenParticle3D.ROLANGULARVELOCITYGRADIENTZMAX,rotation.gradientZMax._elements);
						}else {
						shaDat.setBuffer(ShuriKenParticle3D.ROLANGULARVELOCITYGRADIENT,rotation.gradientMin._elements);
						shaDat.setBuffer(ShuriKenParticle3D.ROLANGULARVELOCITYGRADIENTMAX,rotation.gradientMax._elements);
					}
					break ;
				}
			}else {
			defDat.remove(ShuriKenParticle3D.SHADERDEFINE_ROTATIONOVERLIFETIME);
			defDat.remove(ShuriKenParticle3D.SHADERDEFINE_ROTATIONOVERLIFETIMESEPERATE);
			defDat.remove(ShuriKenParticle3D.SHADERDEFINE_ROTATIONOVERLIFETIMECONSTANT);
			defDat.remove(ShuriKenParticle3D.SHADERDEFINE_ROTATIONOVERLIFETIMECURVE);
			defDat.remove(ShuriKenParticle3D.SHADERDEFINE_ROTATIONOVERLIFETIMERANDOMCONSTANTS);
			defDat.remove(ShuriKenParticle3D.SHADERDEFINE_ROTATIONOVERLIFETIMERANDOMCURVES);
			shaDat.setVector(ShuriKenParticle3D.ROLANGULARVELOCITYCONSTSEPRARATE,null);
			shaDat.setVector(ShuriKenParticle3D.ROLANGULARVELOCITYCONSTMAXSEPRARATE,null);
			shaDat.setNumber(ShuriKenParticle3D.ROLANGULARVELOCITYCONST,undefined);
			shaDat.setNumber(ShuriKenParticle3D.ROLANGULARVELOCITYCONSTMAX,undefined);
			shaDat.setBuffer(ShuriKenParticle3D.ROLANGULARVELOCITYGRADIENTX,null);
			shaDat.setBuffer(ShuriKenParticle3D.ROLANGULARVELOCITYGRADIENTXMAX,null);
			shaDat.setBuffer(ShuriKenParticle3D.ROLANGULARVELOCITYGRADIENTY,null);
			shaDat.setBuffer(ShuriKenParticle3D.ROLANGULARVELOCITYGRADIENTYMAX,null);
			shaDat.setBuffer(ShuriKenParticle3D.ROLANGULARVELOCITYGRADIENTZ,null);
			shaDat.setBuffer(ShuriKenParticle3D.ROLANGULARVELOCITYGRADIENTZMAX,null);
			shaDat.setBuffer(ShuriKenParticle3D.ROLANGULARVELOCITYGRADIENTWMAX,null);
			shaDat.setBuffer(ShuriKenParticle3D.ROLANGULARVELOCITYGRADIENT,null);
			shaDat.setBuffer(ShuriKenParticle3D.ROLANGULARVELOCITYGRADIENTMAX,null);
		}
		this._rotationOverLifetime=value;
	});

	/**
	*获取发射器。
	*/
	__getset(0,__proto,'emission',function(){
		return this._emission;
	});

	/**
	*获取一次循环内的累计时间。
	*@return 一次循环内的累计时间。
	*/
	__getset(0,__proto,'emissionTime',function(){
		return this._emissionTime > this.duration ? this.duration :this._emissionTime;
	});

	/**
	*粒子存活个数。
	*/
	__getset(0,__proto,'aliveParticleCount',function(){
		if (this._firstNewElement >=this._firstRetiredElement)
			return this._firstNewElement-this._firstRetiredElement;
		else
		return this._bufferMaxParticles-this._firstRetiredElement+this._firstNewElement;
	});

	/**
	*是否正在播放。
	*/
	__getset(0,__proto,'isPlaying',function(){
		return this._isPlaying;
	});

	/**
	*是否已暂停。
	*/
	__getset(0,__proto,'isPaused',function(){
		return this._isPaused;
	});

	/**
	*设置开始生命周期模式,0为固定时间，1为渐变时间，2为两个固定之间的随机插值,3为两个渐变时间的随机插值。
	*/
	/**
	*获取开始生命周期模式,0为固定时间，1为渐变时间，2为两个固定之间的随机插值,3为两个渐变时间的随机插值。
	*/
	__getset(0,__proto,'startLifetimeType',function(){
		return this._startLifetimeType;
		},function(value){
		var i=0,n=0;
		switch (this.startLifetimeType){
			case 0:
				this._maxStartLifetime=this.startLifetimeConstant;
				break ;
			case 1:
				this._maxStartLifetime=-Number.MAX_VALUE;
				var startLifeTimeGradient=startLifeTimeGradient;
				for (i=0,n=startLifeTimeGradient.gradientCount;i < n;i++)
				this._maxStartLifetime=Math.max(this._maxStartLifetime,startLifeTimeGradient.getValueByIndex(i));
				break ;
			case 2:
				this._maxStartLifetime=Math.max(this.startLifetimeConstantMin,this.startLifetimeConstantMax);
				break ;
			case 3:
				this._maxStartLifetime=-Number.MAX_VALUE;
				var startLifeTimeGradientMin=startLifeTimeGradientMin;
				for (i=0,n=startLifeTimeGradientMin.gradientCount;i < n;i++)
				this._maxStartLifetime=Math.max(this._maxStartLifetime,startLifeTimeGradientMin.getValueByIndex(i));
				var startLifeTimeGradientMax=startLifeTimeGradientMax;
				for (i=0,n=startLifeTimeGradientMax.gradientCount;i < n;i++)
				this._maxStartLifetime=Math.max(this._maxStartLifetime,startLifeTimeGradientMax.getValueByIndex(i));
				break ;
			}
		this._startLifetimeType=value;
	});

	/**
	*设置开始生命周期，0模式,单位为秒。
	*/
	/**
	*获取开始生命周期，0模式,单位为秒。
	*/
	__getset(0,__proto,'startLifetimeConstant',function(){
		return this._startLifetimeConstant;
		},function(value){
		if(this._startLifetimeType===0)
			this._maxStartLifetime=value;
		this._startLifetimeConstant=value;
	});

	/**
	*设置最小开始生命周期，2模式,单位为秒。
	*/
	/**
	*获取最小开始生命周期，2模式,单位为秒。
	*/
	__getset(0,__proto,'startLifetimeConstantMin',function(){
		return this._startLifetimeConstantMin;
		},function(value){
		if (this._startLifetimeType===2)
			this._maxStartLifetime=Math.max(value,this._startLifetimeConstantMax);
		this._startLifetimeConstantMin=value;
	});

	/**
	*设置开始渐变生命周期，1模式,单位为秒。
	*/
	/**
	*获取开始渐变生命周期，1模式,单位为秒。
	*/
	__getset(0,__proto,'startLifeTimeGradient',function(){
		return this._startLifeTimeGradient;
		},function(value){
		if (this._startLifetimeType===1){
			this._maxStartLifetime=-Number.MAX_VALUE;
			for (var i=0,n=value.gradientCount;i < n;i++)
			this._maxStartLifetime=Math.max(this._maxStartLifetime,value.getValueByIndex(i));
		}
		this._startLifeTimeGradient=value;
	});

	/**
	*设置最大开始生命周期，2模式,单位为秒。
	*/
	/**
	*获取最大开始生命周期，2模式,单位为秒。
	*/
	__getset(0,__proto,'startLifetimeConstantMax',function(){
		return this._startLifetimeConstantMax;
		},function(value){
		if (this._startLifetimeType===2)
			this._maxStartLifetime=Math.max(this._startLifetimeConstantMin,value);
		this._startLifetimeConstantMax=value;
	});

	/**
	*设置开始渐变最小生命周期，3模式,单位为秒。
	*/
	/**
	*获取开始渐变最小生命周期，3模式,单位为秒。
	*/
	__getset(0,__proto,'startLifeTimeGradientMin',function(){
		return this._startLifeTimeGradientMin;
		},function(value){
		if (this._startLifetimeType===3){
			var i=0,n=0;
			this._maxStartLifetime=-Number.MAX_VALUE;
			for (i=0,n=value.gradientCount;i < n;i++)
			this._maxStartLifetime=Math.max(this._maxStartLifetime,value.getValueByIndex(i));
			for (i=0,n=this._startLifeTimeGradientMax.gradientCount;i < n;i++)
			this._maxStartLifetime=Math.max(this._maxStartLifetime,this._startLifeTimeGradientMax.getValueByIndex(i));
		}
		this._startLifeTimeGradientMin=value;
	});

	/**
	*设置开始渐变最大生命周期，3模式,单位为秒。
	*/
	/**
	*获取开始渐变最大生命周期，3模式,单位为秒。
	*/
	__getset(0,__proto,'startLifeTimeGradientMax',function(){
		return this._startLifeTimeGradientMax;
		},function(value){
		if (this._startLifetimeType===3){
			var i=0,n=0;
			this._maxStartLifetime=-Number.MAX_VALUE;
			for (i=0,n=this._startLifeTimeGradientMin.gradientCount;i < n;i++)
			this._maxStartLifetime=Math.max(this._maxStartLifetime,this._startLifeTimeGradientMin.getValueByIndex(i));
			for (i=0,n=value.gradientCount;i < n;i++)
			this._maxStartLifetime=Math.max(this._maxStartLifetime,value.getValueByIndex(i));
		}
		this._startLifeTimeGradientMax=value;
	});

	/**
	*设置生命周期速度,注意:如修改该值的某些属性,需重新赋值此属性才可生效。
	*@param value 生命周期速度.
	*/
	/**
	*获取生命周期速度,注意:如修改该值的某些属性,需重新赋值此属性才可生效。
	*@return 生命周期速度.
	*/
	__getset(0,__proto,'velocityOverLifetime',function(){
		return this._velocityOverLifetime;
		},function(value){
		var defDat=this._owner._render._defineDatas;
		var shaDat=this._owner._render._shaderValues;
		if (value){
			var velocity=value.velocity;
			var velocityType=velocity.type;
			if (value.enbale){
				switch (velocityType){
					case 0:
						defDat.add(ShuriKenParticle3D.SHADERDEFINE_VELOCITYOVERLIFETIMECONSTANT);
						break ;
					case 1:
						defDat.add(ShuriKenParticle3D.SHADERDEFINE_VELOCITYOVERLIFETIMECURVE);
						break ;
					case 2:
						defDat.add(ShuriKenParticle3D.SHADERDEFINE_VELOCITYOVERLIFETIMERANDOMCONSTANT);
						break ;
					case 3:
						defDat.add(ShuriKenParticle3D.SHADERDEFINE_VELOCITYOVERLIFETIMERANDOMCURVE);
						break ;
					}
				}else {
				defDat.remove(ShuriKenParticle3D.SHADERDEFINE_VELOCITYOVERLIFETIMECONSTANT);
				defDat.remove(ShuriKenParticle3D.SHADERDEFINE_VELOCITYOVERLIFETIMECURVE);
				defDat.remove(ShuriKenParticle3D.SHADERDEFINE_VELOCITYOVERLIFETIMERANDOMCONSTANT);
				defDat.remove(ShuriKenParticle3D.SHADERDEFINE_VELOCITYOVERLIFETIMERANDOMCURVE);
			}
			switch (velocityType){
				case 0:
					shaDat.setVector3(ShuriKenParticle3D.VOLVELOCITYCONST,velocity.constant);
					break ;
				case 1:
					shaDat.setBuffer(ShuriKenParticle3D.VOLVELOCITYGRADIENTX,velocity.gradientX._elements);
					shaDat.setBuffer(ShuriKenParticle3D.VOLVELOCITYGRADIENTY,velocity.gradientY._elements);
					shaDat.setBuffer(ShuriKenParticle3D.VOLVELOCITYGRADIENTZ,velocity.gradientZ._elements);
					break ;
				case 2:
					shaDat.setVector3(ShuriKenParticle3D.VOLVELOCITYCONST,velocity.constantMin);
					shaDat.setVector3(ShuriKenParticle3D.VOLVELOCITYCONSTMAX,velocity.constantMax);
					break ;
				case 3:
					shaDat.setBuffer(ShuriKenParticle3D.VOLVELOCITYGRADIENTX,velocity.gradientXMin._elements);
					shaDat.setBuffer(ShuriKenParticle3D.VOLVELOCITYGRADIENTXMAX,velocity.gradientXMax._elements);
					shaDat.setBuffer(ShuriKenParticle3D.VOLVELOCITYGRADIENTY,velocity.gradientYMin._elements);
					shaDat.setBuffer(ShuriKenParticle3D.VOLVELOCITYGRADIENTYMAX,velocity.gradientYMax._elements);
					shaDat.setBuffer(ShuriKenParticle3D.VOLVELOCITYGRADIENTZ,velocity.gradientZMin._elements);
					shaDat.setBuffer(ShuriKenParticle3D.VOLVELOCITYGRADIENTZMAX,velocity.gradientZMax._elements);
					break ;
				}
			shaDat.setInt(ShuriKenParticle3D.VOLSPACETYPE,value.space);
			}else {
			defDat.remove(ShuriKenParticle3D.SHADERDEFINE_VELOCITYOVERLIFETIMECONSTANT);
			defDat.remove(ShuriKenParticle3D.SHADERDEFINE_VELOCITYOVERLIFETIMECURVE);
			defDat.remove(ShuriKenParticle3D.SHADERDEFINE_VELOCITYOVERLIFETIMERANDOMCONSTANT);
			defDat.remove(ShuriKenParticle3D.SHADERDEFINE_VELOCITYOVERLIFETIMERANDOMCURVE);
			shaDat.setVector(ShuriKenParticle3D.VOLVELOCITYCONST,null);
			shaDat.setBuffer(ShuriKenParticle3D.VOLVELOCITYGRADIENTX,null);
			shaDat.setBuffer(ShuriKenParticle3D.VOLVELOCITYGRADIENTY,null);
			shaDat.setBuffer(ShuriKenParticle3D.VOLVELOCITYGRADIENTZ,null);
			shaDat.setVector(ShuriKenParticle3D.VOLVELOCITYCONST,null);
			shaDat.setVector(ShuriKenParticle3D.VOLVELOCITYCONSTMAX,null);
			shaDat.setBuffer(ShuriKenParticle3D.VOLVELOCITYGRADIENTX,null);
			shaDat.setBuffer(ShuriKenParticle3D.VOLVELOCITYGRADIENTXMAX,null);
			shaDat.setBuffer(ShuriKenParticle3D.VOLVELOCITYGRADIENTY,null);
			shaDat.setBuffer(ShuriKenParticle3D.VOLVELOCITYGRADIENTYMAX,null);
			shaDat.setBuffer(ShuriKenParticle3D.VOLVELOCITYGRADIENTZ,null);
			shaDat.setBuffer(ShuriKenParticle3D.VOLVELOCITYGRADIENTZMAX,null);
			shaDat.setInt(ShuriKenParticle3D.VOLSPACETYPE,undefined);
		}
		this._velocityOverLifetime=value;
	});

	/**
	*设置生命周期颜色,注意:如修改该值的某些属性,需重新赋值此属性才可生效。
	*@param value 生命周期颜色
	*/
	/**
	*获取生命周期颜色,注意:如修改该值的某些属性,需重新赋值此属性才可生效。
	*@return 生命周期颜色
	*/
	__getset(0,__proto,'colorOverLifetime',function(){
		return this._colorOverLifetime;
		},function(value){
		var defDat=this._owner._render._defineDatas;
		var shaDat=this._owner._render._shaderValues;
		if (value){
			var color=value.color;
			if (value.enbale){
				switch (color.type){
					case 1:
						defDat.add(ShuriKenParticle3D.SHADERDEFINE_COLOROVERLIFETIME);
						break ;
					case 3:
						defDat.add(ShuriKenParticle3D.SHADERDEFINE_RANDOMCOLOROVERLIFETIME);
						break ;
					}
				}else {
				defDat.remove(ShuriKenParticle3D.SHADERDEFINE_COLOROVERLIFETIME);
				defDat.remove(ShuriKenParticle3D.SHADERDEFINE_RANDOMCOLOROVERLIFETIME);
			}
			switch (color.type){
				case 1:;
					var gradientColor=color.gradient;
					shaDat.setBuffer(ShuriKenParticle3D.COLOROVERLIFEGRADIENTALPHAS,gradientColor._alphaElements);
					shaDat.setBuffer(ShuriKenParticle3D.COLOROVERLIFEGRADIENTCOLORS,gradientColor._rgbElements);
					break ;
				case 3:;
					var minGradientColor=color.gradientMin;
					var maxGradientColor=color.gradientMax;
					shaDat.setBuffer(ShuriKenParticle3D.COLOROVERLIFEGRADIENTALPHAS,minGradientColor._alphaElements);
					shaDat.setBuffer(ShuriKenParticle3D.COLOROVERLIFEGRADIENTCOLORS,minGradientColor._rgbElements);
					shaDat.setBuffer(ShuriKenParticle3D.MAXCOLOROVERLIFEGRADIENTALPHAS,maxGradientColor._alphaElements);
					shaDat.setBuffer(ShuriKenParticle3D.MAXCOLOROVERLIFEGRADIENTCOLORS,maxGradientColor._rgbElements);
					break ;
				}
			}else {
			defDat.remove(ShuriKenParticle3D.SHADERDEFINE_COLOROVERLIFETIME);
			defDat.remove(ShuriKenParticle3D.SHADERDEFINE_RANDOMCOLOROVERLIFETIME);
			shaDat.setBuffer(ShuriKenParticle3D.COLOROVERLIFEGRADIENTALPHAS,gradientColor._alphaElements);
			shaDat.setBuffer(ShuriKenParticle3D.COLOROVERLIFEGRADIENTCOLORS,gradientColor._rgbElements);
			shaDat.setBuffer(ShuriKenParticle3D.COLOROVERLIFEGRADIENTALPHAS,minGradientColor._alphaElements);
			shaDat.setBuffer(ShuriKenParticle3D.COLOROVERLIFEGRADIENTCOLORS,minGradientColor._rgbElements);
			shaDat.setBuffer(ShuriKenParticle3D.MAXCOLOROVERLIFEGRADIENTALPHAS,maxGradientColor._alphaElements);
			shaDat.setBuffer(ShuriKenParticle3D.MAXCOLOROVERLIFEGRADIENTCOLORS,maxGradientColor._rgbElements);
		}
		this._colorOverLifetime=value;
	});

	/**
	*设置生命周期尺寸,注意:如修改该值的某些属性,需重新赋值此属性才可生效。
	*@param value 生命周期尺寸
	*/
	/**
	*获取生命周期尺寸,注意:如修改该值的某些属性,需重新赋值此属性才可生效。
	*@return 生命周期尺寸
	*/
	__getset(0,__proto,'sizeOverLifetime',function(){
		return this._sizeOverLifetime;
		},function(value){
		var defDat=this._owner._render._defineDatas;
		var shaDat=this._owner._render._shaderValues;
		if (value){
			var size=value.size;
			var sizeSeparate=size.separateAxes;
			var sizeType=size.type;
			if (value.enbale){
				switch (sizeType){
					case 0:
						if (sizeSeparate)
							defDat.add(ShuriKenParticle3D.SHADERDEFINE_SIZEOVERLIFETIMECURVESEPERATE);
						else
						defDat.add(ShuriKenParticle3D.SHADERDEFINE_SIZEOVERLIFETIMECURVE);
						break ;
					case 2:
						if (sizeSeparate)
							defDat.add(ShuriKenParticle3D.SHADERDEFINE_SIZEOVERLIFETIMERANDOMCURVESSEPERATE);
						else
						defDat.add(ShuriKenParticle3D.SHADERDEFINE_SIZEOVERLIFETIMERANDOMCURVES);
						break ;
					}
				}else {
				defDat.remove(ShuriKenParticle3D.SHADERDEFINE_SIZEOVERLIFETIMECURVE);
				defDat.remove(ShuriKenParticle3D.SHADERDEFINE_SIZEOVERLIFETIMECURVESEPERATE);
				defDat.remove(ShuriKenParticle3D.SHADERDEFINE_SIZEOVERLIFETIMERANDOMCURVES);
				defDat.remove(ShuriKenParticle3D.SHADERDEFINE_SIZEOVERLIFETIMERANDOMCURVESSEPERATE);
			}
			switch (sizeType){
				case 0:
					if (sizeSeparate){
						shaDat.setBuffer(ShuriKenParticle3D.SOLSIZEGRADIENTX,size.gradientX._elements);
						shaDat.setBuffer(ShuriKenParticle3D.SOLSIZEGRADIENTY,size.gradientY._elements);
						shaDat.setBuffer(ShuriKenParticle3D.SOLSizeGradientZ,size.gradientZ._elements);
						}else {
						shaDat.setBuffer(ShuriKenParticle3D.SOLSIZEGRADIENT,size.gradient._elements);
					}
					break ;
				case 2:
					if (sizeSeparate){
						shaDat.setBuffer(ShuriKenParticle3D.SOLSIZEGRADIENTX,size.gradientXMin._elements);
						shaDat.setBuffer(ShuriKenParticle3D.SOLSIZEGRADIENTXMAX,size.gradientXMax._elements);
						shaDat.setBuffer(ShuriKenParticle3D.SOLSIZEGRADIENTY,size.gradientYMin._elements);
						shaDat.setBuffer(ShuriKenParticle3D.SOLSIZEGRADIENTYMAX,size.gradientYMax._elements);
						shaDat.setBuffer(ShuriKenParticle3D.SOLSizeGradientZ,size.gradientZMin._elements);
						shaDat.setBuffer(ShuriKenParticle3D.SOLSizeGradientZMAX,size.gradientZMax._elements);
						}else {
						shaDat.setBuffer(ShuriKenParticle3D.SOLSIZEGRADIENT,size.gradientMin._elements);
						shaDat.setBuffer(ShuriKenParticle3D.SOLSizeGradientMax,size.gradientMax._elements);
					}
					break ;
				}
			}else {
			defDat.remove(ShuriKenParticle3D.SHADERDEFINE_SIZEOVERLIFETIMECURVE);
			defDat.remove(ShuriKenParticle3D.SHADERDEFINE_SIZEOVERLIFETIMECURVESEPERATE);
			defDat.remove(ShuriKenParticle3D.SHADERDEFINE_SIZEOVERLIFETIMERANDOMCURVES);
			defDat.remove(ShuriKenParticle3D.SHADERDEFINE_SIZEOVERLIFETIMERANDOMCURVESSEPERATE);
			shaDat.setBuffer(ShuriKenParticle3D.SOLSIZEGRADIENTX,null);
			shaDat.setBuffer(ShuriKenParticle3D.SOLSIZEGRADIENTXMAX,null);
			shaDat.setBuffer(ShuriKenParticle3D.SOLSIZEGRADIENTY,null);
			shaDat.setBuffer(ShuriKenParticle3D.SOLSIZEGRADIENTYMAX,null);
			shaDat.setBuffer(ShuriKenParticle3D.SOLSizeGradientZ,null);
			shaDat.setBuffer(ShuriKenParticle3D.SOLSizeGradientZMAX,null);
			shaDat.setBuffer(ShuriKenParticle3D.SOLSIZEGRADIENT,null);
			shaDat.setBuffer(ShuriKenParticle3D.SOLSizeGradientMax,null);
		}
		this._sizeOverLifetime=value;
	});

	/**
	*设置生命周期纹理动画,注意:如修改该值的某些属性,需重新赋值此属性才可生效。
	*@param value 生命周期纹理动画。
	*/
	/**
	*获取生命周期纹理动画,注意:如修改该值的某些属性,需重新赋值此属性才可生效。
	*@return 生命周期纹理动画。
	*/
	__getset(0,__proto,'textureSheetAnimation',function(){
		return this._textureSheetAnimation;
		},function(value){
		var defDat=this._owner._render._defineDatas;
		var shaDat=this._owner._render._shaderValues;
		if (value){
			var frameOverTime=value.frame;
			var textureAniType=frameOverTime.type;
			if (value.enable){
				switch (textureAniType){
					case 1:
						defDat.add(ShuriKenParticle3D.SHADERDEFINE_TEXTURESHEETANIMATIONCURVE);
						break ;
					case 3:
						defDat.add(ShuriKenParticle3D.SHADERDEFINE_TEXTURESHEETANIMATIONRANDOMCURVE);
						break ;
					}
				}else {
				defDat.remove(ShuriKenParticle3D.SHADERDEFINE_TEXTURESHEETANIMATIONCURVE);
				defDat.remove(ShuriKenParticle3D.SHADERDEFINE_TEXTURESHEETANIMATIONRANDOMCURVE);
			}
			if (textureAniType===1 || textureAniType===3){
				shaDat.setNumber(ShuriKenParticle3D.TEXTURESHEETANIMATIONCYCLES,value.cycles);
				var title=value.tiles;
				var _uvLengthE=this._uvLength;
				_uvLengthE.x=1.0 / title.x;
				_uvLengthE.y=1.0 / title.y;
				shaDat.setVector2(ShuriKenParticle3D.TEXTURESHEETANIMATIONSUBUVLENGTH,this._uvLength);
			}
			switch (textureAniType){
				case 1:
					shaDat.setBuffer(ShuriKenParticle3D.TEXTURESHEETANIMATIONGRADIENTUVS,frameOverTime.frameOverTimeData._elements);
					break ;
				case 3:
					shaDat.setBuffer(ShuriKenParticle3D.TEXTURESHEETANIMATIONGRADIENTUVS,frameOverTime.frameOverTimeDataMin._elements);
					shaDat.setBuffer(ShuriKenParticle3D.TEXTURESHEETANIMATIONGRADIENTMAXUVS,frameOverTime.frameOverTimeDataMax._elements);
					break ;
				}
			}else {
			defDat.remove(ShuriKenParticle3D.SHADERDEFINE_TEXTURESHEETANIMATIONCURVE);
			defDat.remove(ShuriKenParticle3D.SHADERDEFINE_TEXTURESHEETANIMATIONRANDOMCURVE);
			shaDat.setNumber(ShuriKenParticle3D.TEXTURESHEETANIMATIONCYCLES,undefined);
			shaDat.setVector(ShuriKenParticle3D.TEXTURESHEETANIMATIONSUBUVLENGTH,null);
			shaDat.setBuffer(ShuriKenParticle3D.TEXTURESHEETANIMATIONGRADIENTUVS,null);
			shaDat.setBuffer(ShuriKenParticle3D.TEXTURESHEETANIMATIONGRADIENTMAXUVS,null);
		}
		this._textureSheetAnimation=value;
	});

	ShurikenParticleSystem.halfKSqrtOf2=1.42 *0.5;
	__static(ShurikenParticleSystem,
	['_RANDOMOFFSET',function(){return this._RANDOMOFFSET=new Uint32Array([0x23571a3e,0xc34f56fe,0x13371337,0x12460f3b,0x6aed452e,0xdec4aea1,0x96aa4de3,0x8d2c8431,0xf3857f6f,0xe0fbd834,0x13740583,0x591bc05c,0x40eb95e4,0xbc524e5f,0xaf502044,0xa614b381,0x1034e524,0xfc524e5f]);},'_maxElapsedTime',function(){return this._maxElapsedTime=1.0 / 3.0;},'_tempVector30',function(){return this._tempVector30=new Vector3();},'_tempVector31',function(){return this._tempVector31=new Vector3();},'_tempVector32',function(){return this._tempVector32=new Vector3();},'_tempVector33',function(){return this._tempVector33=new Vector3();},'_tempVector34',function(){return this._tempVector34=new Vector3();},'_tempVector35',function(){return this._tempVector35=new Vector3();},'_tempVector36',function(){return this._tempVector36=new Vector3();},'_tempVector37',function(){return this._tempVector37=new Vector3();},'_tempVector38',function(){return this._tempVector38=new Vector3();},'_tempVector39',function(){return this._tempVector39=new Vector3();},'_tempPosition',function(){return this._tempPosition=new Vector3();},'_tempDirection',function(){return this._tempDirection=new Vector3();},'_type',function(){return this._type=GeometryElement._typeCounter++;}
	]);
	return ShurikenParticleSystem;
})(GeometryElement)


/**
*<code>StaticPlaneColliderShape</code> 类用于创建静态平面碰撞器。
*/
//class laya.d3.physics.shape.StaticPlaneColliderShape extends laya.d3.physics.shape.ColliderShape
var StaticPlaneColliderShape=(function(_super){
	function StaticPlaneColliderShape(normal,offset){
		/**@private */
		//this._offset=NaN;
		/**@private */
		//this._normal=null;
		StaticPlaneColliderShape.__super.call(this);
		this._normal=normal;
		this._offset=offset;
		this._type=/*laya.d3.physics.shape.ColliderShape.SHAPETYPES_STATICPLANE*/6;
		StaticPlaneColliderShape._nativeNormal.setValue(-normal.x,normal.y,normal.z);
		this._nativeShape=new Laya3D._physics3D.btStaticPlaneShape(StaticPlaneColliderShape._nativeNormal,offset);
	}

	__class(StaticPlaneColliderShape,'laya.d3.physics.shape.StaticPlaneColliderShape',_super);
	var __proto=StaticPlaneColliderShape.prototype;
	/**
	*@inheritDoc
	*/
	__proto.clone=function(){
		var dest=new StaticPlaneColliderShape(this._normal,this._offset);
		this.cloneTo(dest);
		return dest;
	}

	__static(StaticPlaneColliderShape,
	['_nativeNormal',function(){return this._nativeNormal=new Laya3D._physics3D.btVector3(0,0,0);}
	]);
	return StaticPlaneColliderShape;
})(ColliderShape)


/**
*@private
*<code>MeshSprite3DDynamicBatchManager</code> 类用于网格精灵动态批处理管理。
*/
//class laya.d3.graphics.MeshRenderDynamicBatchManager extends laya.d3.graphics.DynamicBatchManager
var MeshRenderDynamicBatchManager=(function(_super){
	function MeshRenderDynamicBatchManager(){
		/**@private [只读]*/
		//this._updateCountMark=0;
		this._instanceBatchOpaqueMarks=[];
		this._vertexBatchOpaqueMarks=[];
		this._cacheBufferStates=[];
		MeshRenderDynamicBatchManager.__super.call(this);
		SubMeshDynamicBatch.instance=new SubMeshDynamicBatch();
		this._updateCountMark=0;
	}

	__class(MeshRenderDynamicBatchManager,'laya.d3.graphics.MeshRenderDynamicBatchManager',_super);
	var __proto=MeshRenderDynamicBatchManager.prototype;
	/**
	*@private
	*/
	__proto.getInstanceBatchOpaquaMark=function(lightMapIndex,receiveShadow,materialID,subMeshID){
		var instanceLightMapMarks=(this._instanceBatchOpaqueMarks[lightMapIndex])|| (this._instanceBatchOpaqueMarks[lightMapIndex]=[]);
		var instanceReceiveShadowMarks=(instanceLightMapMarks[receiveShadow ? 0 :1])|| (instanceLightMapMarks[receiveShadow ? 0 :1]=[]);
		var instanceMaterialMarks=(instanceReceiveShadowMarks[materialID])|| (instanceReceiveShadowMarks[materialID]=[]);
		return instanceMaterialMarks[subMeshID] || (instanceMaterialMarks[subMeshID]=new BatchMark());
	}

	/**
	*@private
	*/
	__proto.getVertexBatchOpaquaMark=function(lightMapIndex,receiveShadow,materialID,verDecID){
		var dynLightMapMarks=(this._vertexBatchOpaqueMarks[lightMapIndex])|| (this._vertexBatchOpaqueMarks[lightMapIndex]=[]);
		var dynReceiveShadowMarks=(dynLightMapMarks[receiveShadow ? 0 :1])|| (dynLightMapMarks[receiveShadow ? 0 :1]=[]);
		var dynMaterialMarks=(dynReceiveShadowMarks[materialID])|| (dynReceiveShadowMarks[materialID]=[]);
		return dynMaterialMarks[verDecID] || (dynMaterialMarks[verDecID]=new BatchMark());
	}

	/**
	*@private
	*/
	__proto._getBufferState=function(vertexDeclaration){
		var bufferState=this._cacheBufferStates[vertexDeclaration.id];
		if (!bufferState){
			var instance=SubMeshDynamicBatch.instance;
			bufferState=new BufferState();
			bufferState.bind();
			var vertexBuffer=instance._vertexBuffer;
			vertexBuffer.vertexDeclaration=vertexDeclaration;
			bufferState.applyVertexBuffer(vertexBuffer);
			bufferState.applyIndexBuffer(instance._indexBuffer);
			bufferState.unBind();
			this._cacheBufferStates[vertexDeclaration.id]=bufferState;
		}
		return bufferState;
	}

	/**
	*@inheritDoc
	*/
	__proto._getBatchRenderElementFromPool=function(){
		var renderElement=this._batchRenderElementPool [this._batchRenderElementPoolIndex++];
		if (!renderElement){
			renderElement=new SubMeshRenderElement();
			this._batchRenderElementPool[this._batchRenderElementPoolIndex-1]=renderElement;
			renderElement.vertexBatchElementList=[];
			renderElement.instanceBatchElementList=[];
		}
		return renderElement;
	}

	/**
	*@inheritDoc
	*/
	__proto._clear=function(){
		_super.prototype._clear.call(this);
		this._updateCountMark++;
	}

	__static(MeshRenderDynamicBatchManager,
	['instance',function(){return this.instance=new MeshRenderDynamicBatchManager();}
	]);
	return MeshRenderDynamicBatchManager;
})(DynamicBatchManager)


/**
*<code>BoxColliderShape</code> 类用于创建盒子形状碰撞器。
*/
//class laya.d3.physics.shape.BoxColliderShape extends laya.d3.physics.shape.ColliderShape
var BoxColliderShape=(function(_super){
	function BoxColliderShape(sizeX,sizeY,sizeZ){
		/**@private */
		//this._sizeX=NaN;
		/**@private */
		//this._sizeY=NaN;
		/**@private */
		//this._sizeZ=NaN;
		BoxColliderShape.__super.call(this);
		(sizeX===void 0)&& (sizeX=1.0);
		(sizeY===void 0)&& (sizeY=1.0);
		(sizeZ===void 0)&& (sizeZ=1.0);
		this._sizeX=sizeX;
		this._sizeY=sizeY;
		this._sizeZ=sizeZ;
		this._type=/*laya.d3.physics.shape.ColliderShape.SHAPETYPES_BOX*/0;
		BoxColliderShape._nativeSize.setValue(sizeX / 2,sizeY / 2,sizeZ / 2);
		this._nativeShape=new Laya3D._physics3D.btBoxShape(BoxColliderShape._nativeSize);
	}

	__class(BoxColliderShape,'laya.d3.physics.shape.BoxColliderShape',_super);
	var __proto=BoxColliderShape.prototype;
	/**
	*@inheritDoc
	*/
	__proto.clone=function(){
		var dest=new BoxColliderShape(this._sizeX,this._sizeY,this._sizeZ);
		this.cloneTo(dest);
		return dest;
	}

	/**
	*获取X轴尺寸。
	*/
	__getset(0,__proto,'sizeX',function(){
		return this._sizeX;
	});

	/**
	*获取Y轴尺寸。
	*/
	__getset(0,__proto,'sizeY',function(){
		return this._sizeY;
	});

	/**
	*获取Z轴尺寸。
	*/
	__getset(0,__proto,'sizeZ',function(){
		return this._sizeZ;
	});

	__static(BoxColliderShape,
	['_nativeSize',function(){return this._nativeSize=new Laya3D._physics3D.btVector3(0,0,0);}
	]);
	return BoxColliderShape;
})(ColliderShape)


/**
*<code>SimpleSingletonList</code> 类用于实现单例队列。
*/
//class laya.d3.component.SimpleSingletonList extends laya.d3.component.SingletonList
var SimpleSingletonList=(function(_super){
	/**
	*创建一个新的 <code>SimpleSingletonList</code> 实例。
	*/
	function SimpleSingletonList(){
		SimpleSingletonList.__super.call(this);
	}

	__class(SimpleSingletonList,'laya.d3.component.SimpleSingletonList',_super);
	var __proto=SimpleSingletonList.prototype;
	/**
	*@private
	*/
	__proto.add=function(element){
		var index=element._getIndexInList();
		if (index!==-1)
			throw "SimpleSingletonList:"+element+" has  in  SingletonList.";
		this._add(element);
		element._setIndexInList(this.length++);
	}

	/**
	*@private
	*/
	__proto.remove=function(element){
		var index=element._getIndexInList();
		this.length--;
		if (index!==this.length){
			var end=this.elements[this.length];
			this.elements[index]=end;
			end._setIndexInList(index);
		}
		element._setIndexInList(-1);
	}

	return SimpleSingletonList;
})(SingletonList)


/**
*<code>PhysicsUpdateList</code> 类用于实现物理更新队列。
*/
//class laya.d3.physics.PhysicsUpdateList extends laya.d3.component.SingletonList
var PhysicsUpdateList=(function(_super){
	/**
	*创建一个新的 <code>PhysicsUpdateList</code> 实例。
	*/
	function PhysicsUpdateList(){
		PhysicsUpdateList.__super.call(this);
	}

	__class(PhysicsUpdateList,'laya.d3.physics.PhysicsUpdateList',_super);
	var __proto=PhysicsUpdateList.prototype;
	/**
	*@private
	*/
	__proto.add=function(element){
		var index=element._inPhysicUpdateListIndex;
		if (index!==-1)
			throw "PhysicsUpdateList:element has  in  PhysicsUpdateList.";
		this._add(element);
		element._inPhysicUpdateListIndex=this.length++;
	}

	/**
	*@private
	*/
	__proto.remove=function(element){
		var index=element._inPhysicUpdateListIndex;
		this.length--;
		if (index!==this.length){
			var end=this.elements[this.length];
			this.elements[index]=end;
			end._inPhysicUpdateListIndex=index;
		}
		element._inPhysicUpdateListIndex=-1;
	}

	return PhysicsUpdateList;
})(SingletonList)


/**
*@private
*<code>SubMeshStaticBatch</code> 类用于网格静态合并。
*/
//class laya.d3.graphics.SubMeshStaticBatch extends laya.d3.core.GeometryElement
var SubMeshStaticBatch=(function(_super){
	function SubMeshStaticBatch(batchOwner,number,vertexDeclaration){
		/**@private */
		//this._currentBatchVertexCount=0;
		/**@private */
		//this._currentBatchIndexCount=0;
		/**@private */
		//this._vertexDeclaration=null;
		/**@private */
		//this._vertexBuffer=null;
		/**@private */
		//this._indexBuffer=null;
		/**@private */
		//this._batchElements=null;
		/**@private */
		//this._batchID=0;
		/**@private [只读]*/
		//this.batchOwner=null;
		/**@private [只读]*/
		//this.number=0;
		SubMeshStaticBatch.__super.call(this);
		this._bufferState=new BufferState();
		this._batchID=SubMeshStaticBatch._batchIDCounter++;
		this._batchElements=[];
		this._currentBatchVertexCount=0;
		this._currentBatchIndexCount=0;
		this._vertexDeclaration=vertexDeclaration;
		this.batchOwner=batchOwner;
		this.number=number;
	}

	__class(SubMeshStaticBatch,'laya.d3.graphics.SubMeshStaticBatch',_super);
	var __proto=SubMeshStaticBatch.prototype;
	Laya.imps(__proto,{"laya.resource.IDispose":true})
	/**
	*@private
	*/
	__proto._getStaticBatchBakedVertexs=function(batchVertices,batchOffset,batchOwnerTransform,transform,render,mesh){
		var vertexBuffer=mesh._vertexBuffers[0];
		var vertexDeclaration=vertexBuffer.vertexDeclaration;
		var positionOffset=vertexDeclaration.getVertexElementByUsage(/*laya.d3.graphics.Vertex.VertexMesh.MESH_POSITION0*/0).offset / 4;
		var normalElement=vertexDeclaration.getVertexElementByUsage(/*laya.d3.graphics.Vertex.VertexMesh.MESH_NORMAL0*/3);
		var normalOffset=normalElement ? normalElement.offset / 4 :-1;
		var colorElement=vertexDeclaration.getVertexElementByUsage(/*laya.d3.graphics.Vertex.VertexMesh.MESH_COLOR0*/1);
		var colorOffset=colorElement ? colorElement.offset / 4 :-1;
		var uv0Element=vertexDeclaration.getVertexElementByUsage(/*laya.d3.graphics.Vertex.VertexMesh.MESH_TEXTURECOORDINATE0*/2);
		var uv0Offset=uv0Element ? uv0Element.offset / 4 :-1;
		var uv1Element=vertexDeclaration.getVertexElementByUsage(/*laya.d3.graphics.Vertex.VertexMesh.MESH_TEXTURECOORDINATE1*/7);
		var uv1Offset=uv1Element ? uv1Element.offset / 4 :-1;
		var tangentElement=vertexDeclaration.getVertexElementByUsage(/*laya.d3.graphics.Vertex.VertexMesh.MESH_TANGENT0*/4);
		var sTangentOffset=tangentElement ? tangentElement.offset / 4 :-1;
		var bakeVertexFloatCount=18;
		var oriVertexFloatCount=vertexDeclaration.vertexStride / 4;
		var oriVertexes=vertexBuffer.getData();
		var worldMat;
		if (batchOwnerTransform){
			var rootMat=batchOwnerTransform.worldMatrix;
			rootMat.invert(SubMeshStaticBatch._tempMatrix4x40);
			worldMat=SubMeshStaticBatch._tempMatrix4x41;
			Matrix4x4.multiply(SubMeshStaticBatch._tempMatrix4x40,transform.worldMatrix,worldMat);
			}else {
			worldMat=transform.worldMatrix;
		};
		var rotation=SubMeshStaticBatch._tempQuaternion0;
		worldMat.decomposeTransRotScale(SubMeshStaticBatch._tempVector30,rotation,SubMeshStaticBatch._tempVector31);
		var lightmapScaleOffset=render.lightmapScaleOffset;
		var vertexCount=mesh.vertexCount;
		for (var i=0;i < vertexCount;i++){
			var oriOffset=i *oriVertexFloatCount;
			var bakeOffset=(i+batchOffset)*bakeVertexFloatCount;
			Utils3D.transformVector3ArrayToVector3ArrayCoordinate(oriVertexes,oriOffset+positionOffset,worldMat,batchVertices,bakeOffset+0);
			if (normalOffset!==-1)
				Utils3D.transformVector3ArrayByQuat(oriVertexes,oriOffset+normalOffset,rotation,batchVertices,bakeOffset+3);
			var j=0,m=0;
			var bakOff=bakeOffset+6;
			if (colorOffset!==-1){
				var oriOff=oriOffset+colorOffset;
				for (j=0,m=4;j < m;j++)
				batchVertices[bakOff+j]=oriVertexes[oriOff+j];
				}else {
				for (j=0,m=4;j < m;j++)
				batchVertices[bakOff+j]=1.0;
			}
			if (uv0Offset!==-1){
				var absUv0Offset=oriOffset+uv0Offset;
				batchVertices[bakeOffset+10]=oriVertexes[absUv0Offset];
				batchVertices[bakeOffset+11]=oriVertexes[absUv0Offset+1];
			}
			if (lightmapScaleOffset){
				if (uv1Offset!==-1)
					Utils3D.transformLightingMapTexcoordArray(oriVertexes,oriOffset+uv1Offset,lightmapScaleOffset,batchVertices,bakeOffset+12);
				else
				Utils3D.transformLightingMapTexcoordArray(oriVertexes,oriOffset+uv0Offset,lightmapScaleOffset,batchVertices,bakeOffset+12);
			}
			if (sTangentOffset!==-1){
				var absSTanegntOffset=oriOffset+sTangentOffset;
				batchVertices[bakeOffset+14]=oriVertexes[absSTanegntOffset];
				batchVertices[bakeOffset+15]=oriVertexes[absSTanegntOffset+1];
				batchVertices[bakeOffset+16]=oriVertexes[absSTanegntOffset+2];
				batchVertices[bakeOffset+17]=oriVertexes[absSTanegntOffset+3];
			}
		}
		return vertexCount;
	}

	/**
	*@private
	*/
	__proto.addTest=function(sprite){
		var vertexCount=0;
		var subMeshVertexCount=((sprite).meshFilter.sharedMesh).vertexCount;
		vertexCount=this._currentBatchVertexCount+subMeshVertexCount;
		if (vertexCount > 65535)
			return false;
		return true;
	}

	/**
	*@private
	*/
	__proto.add=function(sprite){
		var oldStaticBatch=sprite._render._staticBatch;
		(oldStaticBatch)&& (oldStaticBatch.remove(sprite));
		var mesh=(sprite).meshFilter.sharedMesh;
		var subMeshVertexCount=mesh.vertexCount;
		this._batchElements.push(sprite);
		var render=sprite._render;
		render._isPartOfStaticBatch=true;
		render._staticBatch=this;
		var renderElements=render._renderElements;
		for (var i=0,n=renderElements.length;i < n;i++)
		renderElements[i].staticBatch=this;
		this._currentBatchIndexCount+=mesh._indexBuffer.indexCount;
		this._currentBatchVertexCount+=subMeshVertexCount;
	}

	/**
	*@private
	*/
	__proto.remove=function(sprite){
		var mesh=(sprite).meshFilter.sharedMesh;
		var index=this._batchElements.indexOf(sprite);
		if (index!==-1){
			this._batchElements.splice(index,1);
			var render=sprite._render;
			var renderElements=sprite._render._renderElements;
			for (var i=0,n=renderElements.length;i < n;i++)
			renderElements[i].staticBatch=null;
			var meshVertexCount=mesh.vertexCount;
			this._currentBatchIndexCount=this._currentBatchIndexCount-mesh._indexBuffer.indexCount;
			this._currentBatchVertexCount=this._currentBatchVertexCount-meshVertexCount;
			sprite._render._isPartOfStaticBatch=false;
		}
	}

	/**
	*@private
	*/
	__proto.finishInit=function(){
		if (this._vertexBuffer){
			this._vertexBuffer.destroy();
			this._indexBuffer.destroy();
			Resource._addGPUMemory(-(this._vertexBuffer._byteLength+this._indexBuffer._byteLength));
		};
		var batchVertexCount=0;
		var batchIndexCount=0;
		var rootOwner=this.batchOwner;
		var floatStride=this._vertexDeclaration.vertexStride / 4;
		var vertexDatas=new Float32Array(floatStride *this._currentBatchVertexCount);
		var indexDatas=new Uint16Array(this._currentBatchIndexCount);
		this._vertexBuffer=new VertexBuffer3D(this._vertexDeclaration.vertexStride *this._currentBatchVertexCount,/*laya.webgl.WebGLContext.STATIC_DRAW*/0x88E4);
		this._vertexBuffer.vertexDeclaration=this._vertexDeclaration;
		this._indexBuffer=new IndexBuffer3D(/*laya.d3.graphics.IndexBuffer3D.INDEXTYPE_USHORT*/"ushort",this._currentBatchIndexCount,/*laya.webgl.WebGLContext.STATIC_DRAW*/0x88E4);
		for (var i=0,n=this._batchElements.length;i < n;i++){
			var sprite=this._batchElements [i];
			var mesh=sprite.meshFilter.sharedMesh;
			var meshVerCount=this._getStaticBatchBakedVertexs(vertexDatas,batchVertexCount,rootOwner ? rootOwner._transform :null,sprite._transform,(sprite._render),mesh);
			var indices=mesh._indexBuffer.getData();
			var indexOffset=batchVertexCount;
			var indexEnd=batchIndexCount+indices.length;
			var elements=sprite._render._renderElements;
			for (var j=0,m=mesh.subMeshCount;j < m;j++){
				var subMesh=mesh._subMeshes[j];
				var start=batchIndexCount+subMesh._indexStart;
				var element=elements [j];
				element.staticBatchIndexStart=start;
				element.staticBatchIndexEnd=start+subMesh._indexCount;
			}
			indexDatas.set(indices,batchIndexCount);
			var k=0;
			var isInvert=rootOwner ? (sprite._transform._isFrontFaceInvert!==rootOwner.transform._isFrontFaceInvert):sprite._transform._isFrontFaceInvert;
			if (isInvert){
				for (k=batchIndexCount;k < indexEnd;k+=3){
					indexDatas[k]=indexOffset+indexDatas[k];
					var index1=indexDatas[k+1];
					var index2=indexDatas[k+2];
					indexDatas[k+1]=indexOffset+index2;
					indexDatas[k+2]=indexOffset+index1;
				}
				}else {
				for (k=batchIndexCount;k < indexEnd;k+=3){
					indexDatas[k]=indexOffset+indexDatas[k];
					indexDatas[k+1]=indexOffset+indexDatas[k+1];
					indexDatas[k+2]=indexOffset+indexDatas[k+2];
				}
			}
			batchIndexCount+=indices.length;
			batchVertexCount+=meshVerCount;
		}
		this._vertexBuffer.setData(vertexDatas);
		this._indexBuffer.setData(indexDatas);
		var memorySize=this._vertexBuffer._byteLength+this._indexBuffer._byteLength;
		Resource._addGPUMemory(memorySize);
		this._bufferState.bind();
		this._bufferState.applyVertexBuffer(this._vertexBuffer);
		this._bufferState.applyIndexBuffer(this._indexBuffer);
		this._bufferState.unBind();
	}

	/**
	*@inheritDoc
	*/
	__proto._render=function(state){
		this._bufferState.bind();
		var element=state.renderElement;
		var batchElementList=(element).staticBatchElementList;
		var from=0;
		var end=0;
		var count=batchElementList.length;
		for (var i=1;i < count;i++){
			var lastElement=batchElementList[i-1];
			if (lastElement.staticBatchIndexEnd===batchElementList[i].staticBatchIndexStart){
				end++;
				continue ;
				}else {
				var start=batchElementList[from].staticBatchIndexStart;
				var indexCount=batchElementList[end].staticBatchIndexEnd-start;
				LayaGL.instance.drawElements(/*laya.webgl.WebGLContext.TRIANGLES*/0x0004,indexCount,/*laya.webgl.WebGLContext.UNSIGNED_SHORT*/0x1403,start *2);
				from=++end;
				Stat.trianglesFaces+=indexCount / 3;
			}
		}
		start=batchElementList[from].staticBatchIndexStart;
		indexCount=batchElementList[end].staticBatchIndexEnd-start;
		LayaGL.instance.drawElements(/*laya.webgl.WebGLContext.TRIANGLES*/0x0004,indexCount,/*laya.webgl.WebGLContext.UNSIGNED_SHORT*/0x1403,start *2);
		Stat.renderBatches++;
		Stat.savedRenderBatches+=count-1;
		Stat.trianglesFaces+=indexCount / 3;
	}

	/**
	*@private
	*/
	__proto.dispose=function(){
		var memorySize=this._vertexBuffer._byteLength+this._indexBuffer._byteLength;
		Resource._addGPUMemory(-memorySize);
		this._batchElements=null;
		this.batchOwner=null;
		this._vertexDeclaration=null;
		this._bufferState.destroy();
		this._vertexBuffer.destroy();
		this._indexBuffer.destroy();
		this._vertexBuffer=null;
		this._indexBuffer=null;
		this._bufferState=null;
	}

	SubMeshStaticBatch.maxBatchVertexCount=65535;
	SubMeshStaticBatch._batchIDCounter=0;
	__static(SubMeshStaticBatch,
	['_tempVector30',function(){return this._tempVector30=new Vector3();},'_tempVector31',function(){return this._tempVector31=new Vector3();},'_tempQuaternion0',function(){return this._tempQuaternion0=new Quaternion();},'_tempMatrix4x40',function(){return this._tempMatrix4x40=new Matrix4x4();},'_tempMatrix4x41',function(){return this._tempMatrix4x41=new Matrix4x4();}
	]);
	return SubMeshStaticBatch;
})(GeometryElement)


/**
*<code>TrailGeometry</code> 类用于创建拖尾渲染单元。
*/
//class laya.d3.core.trail.TrailGeometry extends laya.d3.core.GeometryElement
var TrailGeometry=(function(_super){
	function TrailGeometry(owner){
		/**@private */
		this._floatCountPerVertices1=8;
		/**@private */
		this._floatCountPerVertices2=1;
		/**@private */
		this._increaseSegementCount=128;
		/**@private */
		this._activeIndex=0;
		/**@private */
		this._endIndex=0;
		/**@private */
		this._needAddFirstVertex=false;
		/**@private */
		this._isTempEndVertex=false;
		/**@private */
		this._subBirthTime=null;
		/**@private */
		this._subDistance=null;
		/**@private */
		this._segementCount=0;
		/**@private */
		this._vertices1=null;
		/**@private */
		this._vertices2=null;
		/**@private */
		this._vertexBuffer1=null;
		/**@private */
		this._vertexBuffer2=null;
		/**@private */
		this._owner=null;
		TrailGeometry.__super.call(this);
		this._lastFixedVertexPosition=new Vector3();
		this._bufferState=new BufferState();
		this._owner=owner;;
		this._resizeData(this._increaseSegementCount,this._bufferState);
	}

	__class(TrailGeometry,'laya.d3.core.trail.TrailGeometry',_super);
	var __proto=TrailGeometry.prototype;
	/**
	*@private
	*/
	__proto._resizeData=function(segementCount,bufferState){
		this._segementCount=this._increaseSegementCount;
		this._subBirthTime=new Float32Array(segementCount);
		this._subDistance=new Float32Array(segementCount);
		var vertexCount=segementCount *2;
		var vertexDeclaration1=VertexTrail.vertexDeclaration1;
		var vertexDeclaration2=VertexTrail.vertexDeclaration2;
		var vertexBuffers=[];
		var vertexbuffer1Size=vertexCount *vertexDeclaration1.vertexStride;
		var vertexbuffer2Size=vertexCount *vertexDeclaration2.vertexStride;
		var memorySize=vertexbuffer1Size+vertexbuffer2Size;
		this._vertices1=new Float32Array(vertexCount *this._floatCountPerVertices1);
		this._vertexBuffer1=new VertexBuffer3D(vertexbuffer1Size,/*laya.webgl.WebGLContext.STATIC_DRAW*/0x88E4,false);
		this._vertexBuffer1.vertexDeclaration=vertexDeclaration1;
		this._vertices2=new Float32Array(vertexCount *this._floatCountPerVertices2);
		this._vertexBuffer2=new VertexBuffer3D(vertexbuffer2Size,/*laya.webgl.WebGLContext.DYNAMIC_DRAW*/0x88E8,false);
		this._vertexBuffer2.vertexDeclaration=vertexDeclaration2;
		vertexBuffers.push(this._vertexBuffer1);
		vertexBuffers.push(this._vertexBuffer2);
		bufferState.bind();
		bufferState.applyVertexBuffers(vertexBuffers);
		bufferState.unBind();
		Resource._addMemory(memorySize,memorySize);
	}

	/**
	*@private
	*/
	__proto._resetData=function(){
		var count=this._endIndex-this._activeIndex;
		if (count==this._segementCount){
			this._vertexBuffer1.destroy();
			this._vertexBuffer2.destroy();
			this._segementCount+=this._increaseSegementCount;
			this._resizeData(this._segementCount,this._bufferState);
		}
		this._vertexBuffer1.setData(this._vertices1,0,this._floatCountPerVertices1 *2 *this._activeIndex,this._floatCountPerVertices1 *2 *count);
		this._vertexBuffer2.setData(this._vertices2,0,this._floatCountPerVertices2 *2 *this._activeIndex,this._floatCountPerVertices2 *2 *count);
		var offset=this._activeIndex *4;
		var rightSubDistance=new Float32Array(this._subDistance.buffer,offset,count);
		var rightSubBirthTime=new Float32Array(this._subBirthTime.buffer,offset,count);
		this._subDistance.set(rightSubDistance,0);
		this._subBirthTime.set(rightSubBirthTime,0);
		this._endIndex=count;
		this._activeIndex=0;
	}

	/**
	*@private
	*更新Trail数据
	*/
	__proto._updateTrail=function(camera,lastPosition,position){
		if (!Vector3.equals(lastPosition,position)){
			if ((this._endIndex-this._activeIndex)===0)
				this._addTrailByFirstPosition(camera,position);
			else
			this._addTrailByNextPosition(camera,position);
		}
	}

	/**
	*@private
	*通过起始位置添加TrailRenderElement起始数据
	*/
	__proto._addTrailByFirstPosition=function(camera,position){
		(this._endIndex===this._segementCount)&& (this._resetData());
		this._subDistance[this._endIndex]=0;
		this._subBirthTime[this._endIndex]=this._owner._curtime;
		this._endIndex++;
		position.cloneTo(this._lastFixedVertexPosition);
		this._needAddFirstVertex=true;
	}

	/**
	*@private
	*通过位置更新TrailRenderElement数据
	*/
	__proto._addTrailByNextPosition=function(camera,position){
		var delVector3=TrailGeometry._tempVector30;
		var pointAtoBVector3=TrailGeometry._tempVector31;
		Vector3.subtract(position,this._lastFixedVertexPosition,delVector3);
		var forward=TrailGeometry._tempVector32;
		switch (this._owner.alignment){
			case /*laya.d3.core.trail.TrailFilter.ALIGNMENT_VIEW*/0:
				camera.transform.getForward(forward);
				Vector3.cross(delVector3,forward,pointAtoBVector3);
				break ;
			case /*laya.d3.core.trail.TrailFilter.ALIGNMENT_TRANSFORM_Z*/1:
				this._owner._owner.transform.getForward(forward);
				Vector3.cross(delVector3,forward,pointAtoBVector3);
				break ;
			}
		Vector3.normalize(pointAtoBVector3,pointAtoBVector3);
		Vector3.scale(pointAtoBVector3,this._owner.widthMultiplier / 2,pointAtoBVector3);
		var delLength=Vector3.scalarLength(delVector3);
		var tempEndIndex=0;
		var offset=NaN;
		if (this._needAddFirstVertex){
			this._updateVerticesByPositionData(position,pointAtoBVector3,this._endIndex-1);
			this._needAddFirstVertex=false;
		}
		if (delLength-this._owner.minVertexDistance >=MathUtils3D.zeroTolerance){
			if (this._isTempEndVertex){
				tempEndIndex=this._endIndex-1;
				offset=delLength-this._subDistance[tempEndIndex];
				this._updateVerticesByPosition(position,pointAtoBVector3,delLength,tempEndIndex);
				this._owner._totalLength+=offset;
				}else {
				(this._endIndex===this._segementCount)&& (this._resetData());
				this._updateVerticesByPosition(position,pointAtoBVector3,delLength,this._endIndex);
				this._owner._totalLength+=delLength;
				this._endIndex++;
			}
			position.cloneTo(this._lastFixedVertexPosition);
			this._isTempEndVertex=false;
			}else {
			if (this._isTempEndVertex){
				tempEndIndex=this._endIndex-1;
				offset=delLength-this._subDistance[tempEndIndex];
				this._updateVerticesByPosition(position,pointAtoBVector3,delLength,tempEndIndex);
				this._owner._totalLength+=offset;
				}else {
				(this._endIndex===this._segementCount)&& (this._resetData());
				this._updateVerticesByPosition(position,pointAtoBVector3,delLength,this._endIndex);
				this._owner._totalLength+=delLength;
				this._endIndex++;
			}
			this._isTempEndVertex=true;
		}
	}

	/**
	*@private
	*通过位置更新顶点数据
	*/
	__proto._updateVerticesByPositionData=function(position,pointAtoBVector3,index){
		var vertexOffset=this._floatCountPerVertices1 *2 *index;
		var curtime=this._owner._curtime;
		this._vertices1[vertexOffset]=position.x;
		this._vertices1[vertexOffset+1]=position.y;
		this._vertices1[vertexOffset+2]=position.z;
		this._vertices1[vertexOffset+3]=-pointAtoBVector3.x;
		this._vertices1[vertexOffset+4]=-pointAtoBVector3.y;
		this._vertices1[vertexOffset+5]=-pointAtoBVector3.z;
		this._vertices1[vertexOffset+6]=curtime;
		this._vertices1[vertexOffset+7]=1.0;
		this._vertices1[vertexOffset+8]=position.x;
		this._vertices1[vertexOffset+9]=position.y;
		this._vertices1[vertexOffset+10]=position.z;
		this._vertices1[vertexOffset+11]=pointAtoBVector3.x;
		this._vertices1[vertexOffset+12]=pointAtoBVector3.y;
		this._vertices1[vertexOffset+13]=pointAtoBVector3.z;
		this._vertices1[vertexOffset+14]=curtime;
		this._vertices1[vertexOffset+15]=0.0;
		var floatCount=this._floatCountPerVertices1 *2;
		this._vertexBuffer1.setData(this._vertices1,vertexOffset,vertexOffset,floatCount);
	}

	/**
	*@private
	*通过位置更新顶点数据、距离、出生时间
	*/
	__proto._updateVerticesByPosition=function(position,pointAtoBVector3,delDistance,index){
		this._updateVerticesByPositionData(position,pointAtoBVector3,index);
		this._subDistance[index]=delDistance;
		this._subBirthTime[index]=this._owner._curtime;
	}

	/**
	*@private
	*更新VertexBuffer2数据
	*/
	__proto._updateVertexBufferUV=function(){
		var vertexCount=this._endIndex;
		var curLength=0;
		for (var i=this._activeIndex,j=vertexCount;i < j;i++){
			(i!==this._activeIndex)&& (curLength+=this._subDistance[i]);
			var uvX=NaN;
			if (this._owner.textureMode==/*laya.d3.core.TextureMode.Stretch*/0)
				uvX=1.0-curLength / this._owner._totalLength;
			else
			uvX=1.0-(this._owner._totalLength-curLength);
			this._vertices2[i *2]=uvX;
			this._vertices2[i *2+1]=uvX;
		};
		var offset=this._activeIndex *2;
		this._vertexBuffer2.setData(this._vertices2,offset,offset,vertexCount *2-offset);
	}

	/**
	*@private
	*/
	__proto._updateDisappear=function(){
		var count=this._endIndex;
		for (var i=this._activeIndex;i < count;i++){
			if (this._owner._curtime-this._subBirthTime[i] >=this._owner.time+MathUtils3D.zeroTolerance){
				var nextIndex=i+1;
				if (nextIndex!==count)
					this._owner._totalLength-=this._subDistance[nextIndex];
				if (this._isTempEndVertex && (nextIndex===count-1)){
					var offset=this._floatCountPerVertices1 *i *2;
					var fixedPos=this._lastFixedVertexPosition;
					fixedPos.x=this._vertices1[0];
					fixedPos.y=this._vertices1[1];
					fixedPos.z=this._vertices1[2];
					this._isTempEndVertex=false;
				}
				this._activeIndex++;
				}else {
				break ;
			}
		}
	}

	/**
	*@inheritDoc
	*/
	__proto._getType=function(){
		return TrailGeometry._type;
	}

	/**
	*@inheritDoc
	*/
	__proto._prepareRender=function(state){
		return this._endIndex-this._activeIndex > 1;
	}

	/**
	*@inheritDoc
	*/
	__proto._render=function(state){
		this._bufferState.bind();
		var start=this._activeIndex *2;
		var count=this._endIndex *2-start;
		LayaGL.instance.drawArrays(/*laya.webgl.WebGLContext.TRIANGLE_STRIP*/0x0005,start,count);
		Stat.renderBatches++;
		Stat.trianglesFaces+=count-2;
	}

	/**
	*@inheritDoc
	*/
	__proto.destroy=function(){
		_super.prototype.destroy.call(this);
		var memorySize=this._vertexBuffer1._byteLength+this._vertexBuffer2._byteLength;
		Resource._addMemory(-memorySize,-memorySize);
		this._bufferState.destroy();
		this._vertexBuffer1.destroy();
		this._vertexBuffer2.destroy();
		this._bufferState=null;
		this._vertices1=null;
		this._vertexBuffer1=null;
		this._vertices2=null;
		this._vertexBuffer2=null;
		this._subBirthTime=null;
		this._subDistance=null;
		this._lastFixedVertexPosition=null;
	}

	__static(TrailGeometry,
	['_tempVector30',function(){return this._tempVector30=new Vector3();},'_tempVector31',function(){return this._tempVector31=new Vector3();},'_tempVector32',function(){return this._tempVector32=new Vector3();},'_type',function(){return this._type=GeometryElement._typeCounter++;}
	]);
	return TrailGeometry;
})(GeometryElement)


/**
*<code>CompoundColliderShape</code> 类用于创建盒子形状碰撞器。
*/
//class laya.d3.physics.shape.CompoundColliderShape extends laya.d3.physics.shape.ColliderShape
var CompoundColliderShape=(function(_super){
	function CompoundColliderShape(){
		CompoundColliderShape.__super.call(this);
		this._childColliderShapes=[];
		this._type=/*laya.d3.physics.shape.ColliderShape.SHAPETYPES_COMPOUND*/5;
		this._nativeShape=new Laya3D._physics3D.btCompoundShape();
	}

	__class(CompoundColliderShape,'laya.d3.physics.shape.CompoundColliderShape',_super);
	var __proto=CompoundColliderShape.prototype;
	/**
	*@private
	*/
	__proto._clearChildShape=function(shape){
		shape._attatched=false;
		shape._compoundParent=null;
		shape._indexInCompound=-1;
	}

	/**
	*@inheritDoc
	*/
	__proto._addReference=function(){}
	/**
	*@inheritDoc
	*/
	__proto._removeReference=function(){}
	/**
	*@private
	*/
	__proto._updateChildTransform=function(shape){
		var offset=shape.localOffset;
		var rotation=shape.localRotation;
		var nativeOffset=ColliderShape._nativeVector30;
		var nativeQuaternion=ColliderShape._nativQuaternion0;
		var nativeTransform=ColliderShape._nativeTransform0;
		nativeOffset.setValue(-offset.x,offset.y,offset.z);
		nativeQuaternion.setValue(-rotation.x,rotation.y,rotation.z,-rotation.w);
		nativeTransform.setOrigin(nativeOffset);
		nativeTransform.setRotation(nativeQuaternion);
		this._nativeShape.updateChildTransform(shape._indexInCompound,nativeTransform,true);
	}

	/**
	*添加子碰撞器形状。
	*@param shape 子碰撞器形状。
	*/
	__proto.addChildShape=function(shape){
		if (shape._attatched)
			throw "CompoundColliderShape: this shape has attatched to other entity.";
		shape._attatched=true;
		shape._compoundParent=this;
		shape._indexInCompound=this._childColliderShapes.length;
		this._childColliderShapes.push(shape);
		var offset=shape.localOffset;
		var rotation=shape.localRotation;
		CompoundColliderShape._nativeOffset.setValue(-offset.x,offset.y,offset.z);
		CompoundColliderShape._nativRotation.setValue(-rotation.x,rotation.y,rotation.z,-rotation.w);
		CompoundColliderShape._nativeTransform.setOrigin(CompoundColliderShape._nativeOffset);
		CompoundColliderShape._nativeTransform.setRotation(CompoundColliderShape._nativRotation);
		var nativeScale=this._nativeShape.getLocalScaling();
		this._nativeShape.setLocalScaling(CompoundColliderShape._nativeVector3One);
		this._nativeShape.addChildShape(CompoundColliderShape._nativeTransform,shape._nativeShape);
		this._nativeShape.setLocalScaling(nativeScale);
		(this._attatchedCollisionObject)&& (this._attatchedCollisionObject.colliderShape=this);
	}

	/**
	*移除子碰撞器形状。
	*@param shape 子碰撞器形状。
	*/
	__proto.removeChildShape=function(shape){
		if (shape._compoundParent===this){
			var index=shape._indexInCompound;
			this._clearChildShape(shape);
			var endShape=this._childColliderShapes[this._childColliderShapes.length-1];
			endShape._indexInCompound=index;
			this._childColliderShapes[index]=endShape;
			this._childColliderShapes.pop();
			this._nativeShape.removeChildShapeByIndex(index);
		}
	}

	/**
	*清空子碰撞器形状。
	*/
	__proto.clearChildShape=function(){
		for (var i=0,n=this._childColliderShapes.length;i < n;i++){
			this._clearChildShape(this._childColliderShapes[i]);
			this._nativeShape.removeChildShapeByIndex(0);
		}
		this._childColliderShapes.length=0;
	}

	/**
	*获取子形状数量。
	*@return
	*/
	__proto.getChildShapeCount=function(){
		return this._childColliderShapes.length;
	}

	/**
	*@inheritDoc
	*/
	__proto.cloneTo=function(destObject){
		var destCompoundColliderShape=destObject;
		destCompoundColliderShape.clearChildShape();
		for (var i=0,n=this._childColliderShapes.length;i < n;i++)
		destCompoundColliderShape.addChildShape(this._childColliderShapes[i].clone());
	}

	/**
	*@inheritDoc
	*/
	__proto.clone=function(){
		var dest=new CompoundColliderShape();
		this.cloneTo(dest);
		return dest;
	}

	/**
	*@inheritDoc
	*/
	__proto.destroy=function(){
		_super.prototype.destroy.call(this);
		for (var i=0,n=this._childColliderShapes.length;i < n;i++){
			var childShape=this._childColliderShapes[i];
			if (childShape._referenceCount===0)
				childShape.destroy();
		}
	}

	__static(CompoundColliderShape,
	['_nativeVector3One',function(){return this._nativeVector3One=new Laya3D._physics3D.btVector3(1,1,1);},'_nativeTransform',function(){return this._nativeTransform=new Laya3D._physics3D.btTransform();},'_nativeOffset',function(){return this._nativeOffset=new Laya3D._physics3D.btVector3(0,0,0);},'_nativRotation',function(){return this._nativRotation=new Laya3D._physics3D.btQuaternion(0,0,0,1);}
	]);
	return CompoundColliderShape;
})(ColliderShape)


/**
*<code>PixelLineFilter</code> 类用于线过滤器。
*/
//class laya.d3.core.pixelLine.PixelLineFilter extends laya.d3.core.GeometryElement
var PixelLineFilter=(function(_super){
	function PixelLineFilter(owner,maxLineCount){
		/**@private */
		this._floatCountPerVertices=7;
		/**@private */
		this._owner=null;
		/**@private */
		this._vertexBuffer=null;
		/**@private */
		this._vertices=null;
		/**@private */
		this._maxLineCount=0;
		/**@private */
		this._lineCount=0;
		PixelLineFilter.__super.call(this);
		this._minUpdate=Number.MAX_VALUE;
		this._maxUpdate=Number.MIN_VALUE;
		this._bufferState=new BufferState();
		var pointCount=maxLineCount *2;
		this._owner=owner;
		this._maxLineCount=maxLineCount;
		this._vertices=new Float32Array(pointCount *this._floatCountPerVertices);
		this._vertexBuffer=new VertexBuffer3D(PixelLineVertex.vertexDeclaration.vertexStride *pointCount,/*laya.webgl.WebGLContext.STATIC_DRAW*/0x88E4,false);
		this._vertexBuffer.vertexDeclaration=PixelLineVertex.vertexDeclaration;
		this._bufferState.bind();
		this._bufferState.applyVertexBuffer(this._vertexBuffer);
		this._bufferState.unBind();
	}

	__class(PixelLineFilter,'laya.d3.core.pixelLine.PixelLineFilter',_super);
	var __proto=PixelLineFilter.prototype;
	/**
	*@inheritDoc
	*/
	__proto._getType=function(){
		return PixelLineFilter._type;
	}

	/**
	*@private
	*/
	__proto._resizeLineData=function(maxCount){
		var pointCount=maxCount *2;
		var lastVertices=this._vertices;
		this._vertexBuffer.destroy();
		this._maxLineCount=maxCount;
		var vertexCount=pointCount *this._floatCountPerVertices;
		this._vertices=new Float32Array(vertexCount);
		this._vertexBuffer=new VertexBuffer3D(PixelLineVertex.vertexDeclaration.vertexStride *pointCount,/*laya.webgl.WebGLContext.STATIC_DRAW*/0x88E4,false);
		this._vertexBuffer.vertexDeclaration=PixelLineVertex.vertexDeclaration;
		if (vertexCount < lastVertices.length){
			this._vertices.set(new Float32Array(lastVertices.buffer,0,vertexCount));
			this._vertexBuffer.setData(this._vertices,0,0,vertexCount);
			}else {
			this._vertices.set(lastVertices);
			this._vertexBuffer.setData(this._vertices,0,0,lastVertices.length);
		}
		this._bufferState.bind();
		this._bufferState.applyVertexBuffer(this._vertexBuffer);
		this._bufferState.unBind();
	}

	/**
	*@private
	*/
	__proto._updateLineVertices=function(offset,startPosition,endPosition,startColor,endColor){
		if (startPosition){
			this._vertices[offset+0]=startPosition.x;
			this._vertices[offset+1]=startPosition.y;
			this._vertices[offset+2]=startPosition.z;
		}
		if (startColor){
			this._vertices[offset+3]=startColor.r;
			this._vertices[offset+4]=startColor.g;
			this._vertices[offset+5]=startColor.b;
			this._vertices[offset+6]=startColor.a;
		}
		if (endPosition){
			this._vertices[offset+7]=endPosition.x;
			this._vertices[offset+8]=endPosition.y;
			this._vertices[offset+9]=endPosition.z;
		}
		if (endColor){
			this._vertices[offset+10]=endColor.r;
			this._vertices[offset+11]=endColor.g;
			this._vertices[offset+12]=endColor.b;
			this._vertices[offset+13]=endColor.a;
		}
		this._minUpdate=Math.min(this._minUpdate,offset);
		this._maxUpdate=Math.max(this._maxUpdate,offset+this._floatCountPerVertices *2);
	}

	/**
	*@private
	*/
	__proto._removeLineData=function(index){
		var floatCount=this._floatCountPerVertices *2;
		var nextIndex=index+1;
		var offset=index *floatCount;
		var nextOffset=nextIndex *floatCount;
		var rightPartVertices=new Float32Array(this._vertices.buffer,nextIndex *floatCount *4,(this._lineCount-nextIndex)*floatCount);
		this._vertices.set(rightPartVertices,offset);
		this._minUpdate=offset;
		this._maxUpdate=offset+this._floatCountPerVertices *2;
		this._lineCount--;
	}

	/**
	*@private
	*/
	__proto._updateLineData=function(index,startPosition,endPosition,startColor,endColor){
		var floatCount=this._floatCountPerVertices *2;
		var offset=index *floatCount;
		this._updateLineVertices(offset,startPosition,endPosition,startColor,endColor);
	}

	/**
	*@private
	*/
	__proto._updateLineDatas=function(index,data){
		var floatCount=this._floatCountPerVertices *2;
		var offset=index *floatCount;
		var count=data.length;
		for (var i=0;i < count;i++){
			var line=data[i];
			this._updateLineVertices((index+i)*floatCount,line.startPosition,line.endPosition,line.startColor,line.endColor);
		}
	}

	/**
	*获取线段数据
	*@return 线段数据。
	*/
	__proto._getLineData=function(index,out){
		var startPosition=out.startPosition;
		var startColor=out.startColor;
		var endPosition=out.endPosition;
		var endColor=out.endColor;
		var vertices=this._vertices;
		var offset=index *this._floatCountPerVertices *2;
		startPosition.x=vertices[offset+0];
		startPosition.y=vertices[offset+1];
		startPosition.z=vertices[offset+2];
		startColor.r=vertices[offset+3];
		startColor.g=vertices[offset+4];
		startColor.b=vertices[offset+5];
		startColor.a=vertices[offset+6];
		endPosition.x=vertices[offset+7];
		endPosition.y=vertices[offset+8];
		endPosition.z=vertices[offset+9];
		endColor.r=vertices[offset+10];
		endColor.g=vertices[offset+11];
		endColor.b=vertices[offset+12];
		endColor.a=vertices[offset+13];
	}

	/**
	*@inheritDoc
	*/
	__proto._prepareRender=function(state){
		return true;
	}

	/**
	*@inheritDoc
	*/
	__proto._render=function(state){
		if (this._minUpdate!==Number.MAX_VALUE && this._maxUpdate!==Number.MIN_VALUE){
			this._vertexBuffer.setData(this._vertices,this._minUpdate,this._minUpdate,this._maxUpdate-this._minUpdate);
			this._minUpdate=Number.MAX_VALUE;
			this._maxUpdate=Number.MIN_VALUE;
		}
		if (this._lineCount > 0){
			this._bufferState.bind();
			LayaGL.instance.drawArrays(/*laya.webgl.WebGLContext.LINES*/0x0001,0,this._lineCount *2);
			Stat.renderBatches++;
		}
	}

	/**
	*@inheritDoc
	*/
	__proto.destroy=function(){
		if (this._destroyed)
			return;
		_super.prototype.destroy.call(this);
		this._bufferState.destroy();
		this._vertexBuffer.destroy();
		this._bufferState=null;
		this._vertexBuffer=null;
		this._vertices=null;
	}

	__static(PixelLineFilter,
	['_type',function(){return this._type=GeometryElement._typeCounter++;}
	]);
	return PixelLineFilter;
})(GeometryElement)


/**
*<code>CylinderColliderShape</code> 类用于创建圆柱碰撞器。
*/
//class laya.d3.physics.shape.CylinderColliderShape extends laya.d3.physics.shape.ColliderShape
var CylinderColliderShape=(function(_super){
	function CylinderColliderShape(radius,height,orientation){
		/**@private */
		//this._orientation=0;
		/**@private */
		this._radius=1;
		/**@private */
		this._height=0.5;
		CylinderColliderShape.__super.call(this);
		(radius===void 0)&& (radius=0.5);
		(height===void 0)&& (height=1.0);
		(orientation===void 0)&& (orientation=/*laya.d3.physics.shape.ColliderShape.SHAPEORIENTATION_UPY*/1);
		this._radius=radius;
		this._height=height;
		this._orientation=orientation;
		this._type=/*laya.d3.physics.shape.ColliderShape.SHAPETYPES_CYLINDER*/2;
		switch (orientation){
			case /*laya.d3.physics.shape.ColliderShape.SHAPEORIENTATION_UPX*/0:
				CylinderColliderShape._nativeSize.setValue(height / 2,radius,radius);
				this._nativeShape=new Laya3D._physics3D.btCylinderShapeX(CylinderColliderShape._nativeSize);
				break ;
			case /*laya.d3.physics.shape.ColliderShape.SHAPEORIENTATION_UPY*/1:
				CylinderColliderShape._nativeSize.setValue(radius,height / 2,radius);
				this._nativeShape=new Laya3D._physics3D.btCylinderShape(CylinderColliderShape._nativeSize);
				break ;
			case /*laya.d3.physics.shape.Collide