import { ui } from "./../ui/layaMaxUI";
import Player from "./Player";
import Soldier from "./Soldier";

export default class GameUI extends ui.test.TestSceneUI
{
    scene3D:Laya.Scene3D;
    public static instance:GameUI;
    plane:Laya.MeshSprite3D;
    soldierPrefab:Laya.Sprite3D;
    soldierArray:Array<Soldier> = [];

    constructor()
    {
        super();
        GameUI.instance = this;

        if (typeof wx !== 'undefined')
        {
            // wx.setEnableDebug({enableDebug:true});
        }

        Laya.Scene3D.load('LayaScene_Game/Conventional/Game.ls',Laya.Handler.create(this,(scene:Laya.Scene3D)=>
		{
            this.scene3D = scene;
            Laya.stage.addChild(scene);
            scene.zOrder = -1;

            this.plane = scene.getChildByName('Plane') as Laya.MeshSprite3D;

            for (let i = 1; i <= 3; i++)
            {
                let ground = scene.getChildByName('Ground'+i) as Laya.MeshSprite3D;
                let cls = ground.addComponent(Player);
                cls.initPlayer(i)
            }
        }));

        Laya.Sprite3D.load('player/player.lh',Laya.Handler.create(this,(sp:Laya.Sprite3D)=>
        {
            let node = sp.clone() as Laya.Sprite3D;
            node.addComponent(Soldier);
            this.soldierPrefab = node;
        }));

        Laya.timer.frameLoop(10,this,this.updateSoldierCount)
    }

    updateSoldierCount()
    {
        this.LabelCount.text = '场景兵数量 ' + this.soldierArray.length;
    }
}