import GameUI from "./GameUI";
import Soldier from "./Soldier";

export default class Player extends Laya.Script3D
{
    ID:number = -1;
    node:Laya.MeshSprite3D;
    onStart()
    {
        
    }

    initPlayer(id:number)
    {
        this.ID = id;
        this.node = this.owner as Laya.MeshSprite3D;
        Laya.stage.on(Laya.Event.MOUSE_UP,this,this.createSoldier)
    }

    createSoldier()
    {
        if (GameUI.instance.soldierPrefab)
        {
            let soldier = GameUI.instance.soldierPrefab.clone() as Laya.Sprite3D
            let cls = soldier.getComponent(Soldier)
            
            GameUI.instance.scene3D.addChild(soldier);
            soldier.transform.position = new Laya.Vector3(this.node.transform.position.x,0,this.node.transform.position.z);
            GameUI.instance.soldierArray.push(cls);

            cls.initSoldier(this.ID)
        }
    }
}