export default class Soldier extends Laya.Script3D
{
    blood:number = 100;
    playerID:number = -1;
    node:Laya.Sprite3D;
    onStart()
    {

    }

    initSoldier(playerID)
    {
        this.node = this.owner as Laya.Sprite3D;
        this.playerID = playerID
        let playerNode = this.node.getChildByName('player') as Laya.Sprite3D;
        let face = playerNode.getChildByName('polySurface212') as Laya.SkinnedMeshSprite3D;
        let mat = face.skinnedMeshRenderer.material as Laya.BlinnPhongMaterial;
        mat.albedoColorR = playerID == 2 ? 1 : 0
        mat.albedoColorG = playerID == 1 ? 1 : 0
        mat.albedoColorB = playerID == 3 ? 1 : 0

        let pos = new Laya.Vector3(Math.random()*4-2,this.node.transform.position.y,Math.random()*4-2);

        this.node.transform.lookAt(pos,Laya.Vector3._Up,false);
        
        let time = Math.random()*300+500
        Laya.Tween.to(this.node,{position:{x:pos.x,z:pos.z}},time);
        Laya.Tween.to(playerNode,{localPosition:{y:2}},time/2);
        Laya.timer.once(time/2,this,()=>{
            Laya.Tween.to(playerNode,{localPosition:{y:0}},time/2);
        })
    }
}