//
// api: https://developers.weixin.qq.com/minigame/dev/document/open-api/data/wx.getUserInfo.html
//
cc.Class({
    extends: cc.Component,

    properties: {
        content: cc.Node,
        prefab: cc.Prefab,
        selfNode:cc.Node,
        rankView:cc.Node,
    },

    start () {
        this.selfData = null;
        this.rankArray = [];
        this.itemArray = [];
        this.selfItem = null;

        //接收主域数据
        wx.onMessage( data => {
            this.selfNode.active = data.state;
            this.rankView.active = data.state;
            if(data.state)
            {
                this.getFriendInfo();
            }
        });

        this.getFriendInfo();
    },

    //获取好友信息
    getFriendInfo:function() {
        wx.getFriendCloudStorage({
            keyList:["deep"],
            success: (res) => {
                // console.log("initFriendInfo===111===",res);
                //排序
                res.data.sort(function(a,b){
                    return b.KVDataList[0].value-a.KVDataList[0].value;
                });

                this.rankArray = [];
                for (let i = 0; i < res.data.length; ++i) {
                    var rankData = {};
                    rankData.index = i+1;
                    rankData.nickname = res.data[i].nickname;
                    rankData.rankNum = res.data[i].KVDataList[0].value;
                    rankData.avatarUrl = res.data[i].avatarUrl;
                    rankData.isSelf = false;
                    this.rankArray.push(rankData);
                }
                this.initUserInfo(res.data);
            },
            fail: (res) => {
                console.error(res);
            }
        });
    },

    //获取自己信息
    initUserInfo:function(dataArray) {
        wx.getUserInfo({
            openIdList: ['selfOpenId'],
            lang: 'zh_CN',
            success: (res) => {
                console.log("initUserInfo===111===",res.data[0]);
                var index = 0;
                for(var i=0;i<dataArray.length;++i)
                {
                    if(dataArray[i].avatarUrl == res.data[0].avatarUrl)
                    {
                        index = i;
                    }
                }
                var randkNum = "";
                for(var i=0;i<this.rankArray.length;++i)
                {
                    if(this.rankArray[i].avatarUrl == res.data[0].avatarUrl)
                    {
                        randkNum = this.rankArray[i].rankNum;
                    }
                }
                this.selfData = {};
                this.selfData.index = index+1;
                this.selfData.nickname = res.data[0].nickName;
                this.selfData.rankNum = randkNum;
                this.selfData.avatarUrl = res.data[0].avatarUrl;
                this.selfData.isSelf = true;

                this.updateView();
            },
            fail: (res) => {
                console.error(res);
            }
        });
    },

    //更新界面
    updateView:function(){
        //排行
        for(var i =0;i<this.rankArray.length;++i)
        {
            if(i<this.itemArray.length)
            {
                this.itemArray[i].updateInfo(this.rankArray[i]);
            }
            else
            {
                var  node = cc.instantiate(this.prefab);
                node.parent = this.content;
                var item = node.getComponent("item");
                this.itemArray.push(item);
                item.updateInfo(this.rankArray[i]);
            }
        }
        //自己
        if(!this.selfItem)
        {
            var  node = cc.instantiate(this.prefab);
            node.parent = this.selfNode;
            this.selfItem = node.getComponent("item");
        }
        this.selfItem.updateInfo(this.selfData);

        this.content.height = this.rankArray.length*102+20;
    },


});
