
const { ccclass, property } = cc._decorator;

@ccclass()
export class myAudioManager extends cc.Component {
    public static playMusic(name: string){
        const path = `audio/music/${name}`;
        let that = this;
        cc.loader.loadRes(path, cc.AudioClip, (err: any, clip: cc.AudioClip)=>{
            if(err){
                console.warn(err);
                return;
            }
            cc.audioEngine.play(clip, true, 1);
        })
    }

    public static playEffect(name: string){
        const path = `audio/sound/${name}`;
        // console.log(path);
        cc.loader.loadRes(path, cc.AudioClip, (err: any, clip: cc.AudioClip)=>{
            if(err){
                console.warn(err);
                return;
            }
            cc.audioEngine.playEffect(clip, false);
        })
    }

    public static playMusicLoop(clip){
        let audioID =cc.audioEngine.play(clip, false, 1);
        // console.log(clip, audioID, 777);
        cc.audioEngine.setFinishCallback( audioID,  ()=> {
            this.playMusicLoop(clip);
        })
    }
}
