
export enum AudioType {
    a1 = 0,
    a2 = 1,
    a3 = 2,
    a4 = 3,
    a5 = 4,
    a6 = 5,
}
const { ccclass, property } = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    private _audioSources: cc.AudioSource[] = [];
    onLoad() {

    }

    start() {
        let node = new cc.Node('_AudioManager');
        cc.game.addPersistRootNode(node);
        for (let index = 0; index < 1; index++) {
            let audiosource = node.addComponent(cc.AudioSource);
            this._audioSources.push(audiosource);
        }
        this.schedule(() => {
            this.playAudio();
        }, 0.1)
    }

    // update (dt) {}
    private _muteAudio: boolean = true;
    private _clip: cc.AudioClip = null;
    public playAudio() {
        if (!this._muteAudio) return;

        if (this._clip == null) {
            cc.loader.loadRes("test", cc.AudioClip, (err, obj) => {
                this._clip = obj;
                this.doPlayAudio(this._clip);
            })
        } else {
            this.doPlayAudio(this._clip);
        }
        // }
    }

    public onClick() {
        this._muteAudio = !this._muteAudio;
    }
    private countGunType = 0;
    private doPlayAudio(clip: cc.AudioClip) {
        // let audiotype = this.countGunType;
        this._audioSources[0].clip = clip;
        this._audioSources[0].play();
    }
}
