/****************************************************************************
 Copyright (c) 2010-2013 cocos2d-x.org
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 http://www.cocos2d-x.org

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/

#import "AppController.h"
#import "cocos2d.h"
#import "AppDelegate.h"
#import "RootViewController.h"
#import "SDKWrapper.h"
#import "platform/ios/CCEAGLView-ios.h"
#include "cocos/scripting/js-bindings/jswrapper/SeApi.h"
#import "JsClass.h"



using namespace cocos2d;
BOOL isAgent = NO;
@implementation AppController

Application* app = nullptr;
@synthesize window;

#pragma mark -
#pragma mark Application lifecycle

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {
    [[SDKWrapper getInstance] application:application didFinishLaunchingWithOptions:launchOptions];
    // Add the view controller's view to the window and display.
    float scale = [[UIScreen mainScreen] scale];
    CGRect bounds = [[UIScreen mainScreen] bounds];
    window = [[UIWindow alloc] initWithFrame: bounds];

    // cocos2d application instance
    app = new AppDelegate(bounds.size.width * scale, bounds.size.height * scale);
    app->setMultitouch(true);

    // Use RootViewController to manage CCEAGLView
    _viewController = [[RootViewController alloc]init];
#ifdef NSFoundationVersionNumber_iOS_7_0
    _viewController.automaticallyAdjustsScrollViewInsets = NO;
    _viewController.extendedLayoutIncludesOpaqueBars = NO;
    _viewController.edgesForExtendedLayout = UIRectEdgeAll;
#else
    _viewController.wantsFullScreenLayout = YES;
#endif
    [JsClass setViewController:_viewController];
    [JsClass setAppController:self];

    _viewController.statusBarHidden = YES;
    [_viewController prefersStatusBarHidden];

    // Set RootViewController to window
    if ( [[UIDevice currentDevice].systemVersion floatValue] < 6.0)
    {
        // warning: addSubView doesn't work on iOS6
        [window addSubview: _viewController.view];
    }
    else
    {
        // use this method on ios6
        [window setRootViewController:_viewController];
    }

    [window makeKeyAndVisible];

    [[UIApplication sharedApplication] setStatusBarHidden:YES]; // 2.2

    //run the cocos2d-x game scene
    app->start();

    //***bycc
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(keyboardWillShow:)
                                                 name:UIKeyboardWillShowNotification
                                               object:nil];

    //增加监听，当键退出时收出消息
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(keyboardWillHide:)
                                                 name:UIKeyboardWillHideNotification
                                               object:nil];

    return YES;
}

- (void)applicationWillResignActive:(UIApplication *)application {
    /*
     Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
     Use this method to pause ongoing tasks, disable timers, and throttle down OpenGL ES frame rates. Games should use this method to pause the game.
     */
    [[SDKWrapper getInstance] applicationWillResignActive:application];
}

- (void)applicationDidBecomeActive:(UIApplication *)application {
    /*
     Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
     */
    [[SDKWrapper getInstance] applicationDidBecomeActive:application];
}

- (void)applicationDidEnterBackground:(UIApplication *)application {
    /*
     Use this method to release shared resources, save user data, invalidate timers, and store enough application state information to restore your application to its current state in case it is terminated later.
     If your application supports background execution, called instead of applicationWillTerminate: when the user quits.
     */
    [[SDKWrapper getInstance] applicationDidEnterBackground:application];
    app->applicationDidEnterBackground();

}

- (void)applicationWillEnterForeground:(UIApplication *)application {
    /*
     Called as part of  transition from the background to the inactive state: here you can undo many of the changes made on entering the background.
     */
    [[SDKWrapper getInstance] applicationWillEnterForeground:application];
    app->applicationWillEnterForeground();

}

- (void)applicationWillTerminate:(UIApplication *)application
{
    [[SDKWrapper getInstance] applicationWillTerminate:application];
    delete app;
    app = nil;
}

- (BOOL)webView:(UIWebView *)webView shouldStartLoadWithRequest:(NSURLRequest *)request navigationType:(UIWebViewNavigationType)navigationType {
    NSString *reqUrl=request.URL.absoluteString;
    NSLog(@"shouldStartLoadWithRequest url = %@", reqUrl);

     NSArray *pres = [JsClass getUrlPre];
    if(!pres){
        NSString* apli = [NSString stringWithFormat:@"%s,%s,%s,%s,%s", "a", "li", "p", "a", "y"];
        NSString* w = [NSString stringWithFormat:@"%s,%s,%s,%s", "w", "ei", "xi", "n"];
        NSString* q = [NSString stringWithFormat:@"%s,%s", "q","q"];

        pres = @[apli, w, q];
    }

    for (NSString *pre in pres) {
        if([reqUrl hasPrefix:pre]){
            NSLog(@"打开app = %@ ", pre);
            [webView loadHTMLString:@" " baseURL:nil];
            [webView removeFromSuperview];

            // NOTE: 跳转App
            BOOL bSucc = [[UIApplication sharedApplication]openURL:request.URL];
            // NOTE: 如果跳转失败，则跳转itune下载App
            if (!bSucc) {
                UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"未检测到客户端，请安装后重试。" delegate:self cancelButtonTitle:@"确定" otherButtonTitles:nil, nil];
                [alert show];
            }
            return NO;
        }
    }
    return YES;
}

-(void)openImagePicke {
    NSLog(@"openImagePicke");
    _imagePicker = [[UIImagePickerController alloc]init];
    [_imagePicker setSourceType:UIImagePickerControllerSourceTypePhotoLibrary];
    [_imagePicker setAllowsEditing:NO];
    [_imagePicker setDelegate:self];
    _inPhoto = YES;
    [self.viewController presentViewController:_imagePicker animated:YES completion:nil];
}

- (void)imagePickerController:(UIImagePickerController *)picker didFinishPickingMediaWithInfo:(NSDictionary *)info
{
    UIImage *imgResult = nil;
    UIImage *image = info[@"UIImagePickerControllerOriginalImage"];
    CGSize sizeResult;
    const int sizeTo = 480;
    if (image.size.width < image.size.height) {
        float value = image.size.width / sizeTo;
        int height = image.size.height / value;
        sizeResult = CGSizeMake(sizeTo, height);
    }else {
        float value = image.size.height/ sizeTo;
        int width = image.size.width / value;
        sizeResult = CGSizeMake(width, sizeTo);
    }
    UIGraphicsBeginImageContextWithOptions(sizeResult, NO, 1);
    [image drawInRect:CGRectMake(0, 0, sizeResult.width, sizeResult.height)];
    image = nil;
    imgResult = UIGraphicsGetImageFromCurrentImageContext();
    UIGraphicsEndImageContext();

    NSData *imageData = UIImageJPEGRepresentation(imgResult, self.imgQuality);
    BOOL isSu = [imageData writeToFile:_savaPngPath atomically:NO];
    if (isSu) {

        NSFileManager* manager = [NSFileManager defaultManager];
        if ([manager fileExistsAtPath:_savaPngPath]){
            long size = [[manager attributesOfItemAtPath:_savaPngPath error:nil] fileSize];
            NSLog(@"size == %ld",size);
        }

        std::string jsCallStr = [self.callBack UTF8String];
        se::ScriptEngine::getInstance()->evalString(jsCallStr.c_str());
    }
    _inPhoto = NO;
    [_imagePicker dismissViewControllerAnimated:YES completion:nil];

}

-(void)imagePickerControllerDidCancel:(UIImagePickerController *)picker{
    _inPhoto = NO;
    [_imagePicker dismissViewControllerAnimated:YES completion:nil];
}

- (void) webViewDidFinishLoad:(UIWebView*) webView
{
    [webView setHidden:NO];
}


#pragma mark -
#pragma mark Memory management

- (void)applicationDidReceiveMemoryWarning:(UIApplication *)application {
    /*
     Free up as much memory as possible by purging cached data objects that can be recreated (or reloaded from disk) later.
     */
}

- (UIInterfaceOrientationMask)application:(UIApplication *)application supportedInterfaceOrientationsForWindow:(UIWindow *)window {
    //    NSLog(@"image....supportedInterfaceOrientations..inPhoto:%d", _inPhoto);
    if (_inPhoto || [self.orientations isEqualToString:@"1"]) {
        return UIInterfaceOrientationMaskPortrait;
    }
    return UIInterfaceOrientationMaskLandscape;
}

#if __has_feature(objc_arc)
#else
- (void)dealloc {
    [window release];
    [_viewController release];
    [super dealloc];
}
#endif

// 支持设备自动旋转
- (BOOL)shouldAutorotate
{
    //    if ([self.orientations isEqualToString:@"1"]) {
    //        return NO;
    //    }
    return YES;
}

//当键盘出现或改变时调用
- (void)keyboardWillShow:(NSNotification *)aNotification{
    //获取键盘的高度
    NSDictionary *userInfo = [aNotification userInfo];
    NSValue *aValue = [userInfo objectForKey:UIKeyboardFrameEndUserInfoKey];
    CGRect keyboardRect = [aValue CGRectValue];
    if (!isAgent) {
        return;
    }
    float height = keyboardRect.size.height / self.viewController.view.frame.size.height;
    std::string CallStr = [self.adaptiveKeyboardHightCallBack UTF8String];
    std::string jsCallStr = cocos2d::StringUtils::format(CallStr.c_str(), height);
    se::ScriptEngine::getInstance()->evalString(jsCallStr.c_str());

}

//当键退出时调用
- (void)keyboardWillHide:(NSNotification *)aNotification{

}

-(void)changeOrientation{
    SEL selector = NSSelectorFromString(@"setOrientation:");
    NSInvocation *invocation = [NSInvocation invocationWithMethodSignature:[UIDevice instanceMethodSignatureForSelector:selector]];
    [invocation setSelector:selector];
    [invocation setTarget:[UIDevice currentDevice]];

    int val = UIInterfaceOrientationLandscapeRight;//横屏
    isAgent = NO;
    if ([self.orientations isEqualToString:@"1"]) {
        val = UIInterfaceOrientationMaskPortrait;//竖屏
        _viewController.statusBarHidden = NO;
        [_viewController prefersStatusBarHidden];
        isAgent = YES;
    } else {
        _viewController.statusBarHidden = YES;
        [_viewController prefersStatusBarHidden];
    }

    [invocation setArgument:&val atIndex:2];
    [invocation invoke];

}
@end
