const { ccclass, property } = cc._decorator;

@ccclass
export default class Helloworld extends cc.Component {

    @property(cc.Label)
    label: cc.Label = null;

    @property
    text: string = 'hello';

    fmsize: cc.Size = undefined;
    rtsize: cc.Size = undefined;
    start() {
        // init logic
        this.label.string = this.text;
        this.fmsize = cc.view.getFrameSize();
        this.rtsize = cc.view.getDesignResolutionSize();
    }

    onClickChangeOrientation() {
        if (cc.sys.os === cc.sys.OS_IOS) {
            jsb.reflection.callStaticMethod("AppController", "setInterfaceOrientations:", "1");
        }
        let canvas = cc.find('Canvas');

        canvas.getComponent(cc.Canvas).designResolution = cc.size(640, 1136);
        cc.view.setFrameSize(this.fmsize.height, this.fmsize.width);
        cc.view.setDesignResolutionSize(this.rtsize.height, this.rtsize.width, cc.ResolutionPolicy.SHOW_ALL);
        cc.view.setOrientation(cc.macro.ORIENTATION_PORTRAIT);
        canvas.getComponent(cc.Canvas).fitHeight = true;
        canvas.getComponent(cc.Canvas).fitWidth = true;

    }

}
