let Net = {
    TYPE_EVENT: 1,
    TYPE_PING: 2,
    TYPE_PONG: 3,
    connection: null,
    connected: false,
    events: {},
    connect: function(addr){
        if (this.connected){
            cc.error('already connected');
            return;
        }
        this.connected = true;

        this.connection = new WebSocket(addr);
        this.connection.onopen = this._onopen.bind(this);
        this.connection.onmessage = this._onmessage.bind(this);
        this.connection.onerror = this._onerror.bind(this);
        this.connection.onclose = this._onclose.bind(this);

        return this;
    },
    send: function(message){
        cc.log('send', message);
        this.connection.send(message);
    },
    on: function(action, callback){
        if (action === 'open'){
            this.connection.onopen = callback;
        }else if (action === 'close'){
            this.connection.onclose = callback;
        }else if (action === 'error'){
            this.connection.onerror = callback;
        }else if (action === 'message') {
            cc.warn('do you want rewrite onmessage?');
            this.connection.onmessage = callback;
        }else{
            // 自定义事件
            this.events[action] = callback;
        }
    },
    emit: function(event, data){
        this.send(this.encoder(this.TYPE_EVENT, {event: event, data: data}));
    },
    ping: function(){
        this.send(this.encoder(this.TYPE_PING));
    },
    pong: function(){
        this.send(this.encoder(this.TYPE_PONG));
    },
    encoder: function(type, message){
        return JSON.stringify({type: type, message: message});
    },
    decoder: function(response){
        try{
            return JSON.parse(response);
        }catch (e){
            cc.error("bad message", response)
            return null;
        }
    },
    _onopen: function(event){
      cc.log('on open', event);
    },
    _onmessage: function(messageEvent){
        cc.log('on message', messageEvent);
        cc.log('message:', messageEvent.data);
        let r = this.decoder(messageEvent.data);
        if (r === null){
            cc.warn('on null message');
            return;
        }
        cc.log('onmessage:', r);
        if (r.type === this.TYPE_EVENT){
            cc.log('on type:', r.type);
            if (typeof this.events[r.message.event] === "undefined"){
                cc.warn("event " + r.message.event + ' not register');
            }
            if (typeof this.events[r.message.event] === "function"){
                this.events[r.message.event](r.message.data);
            }
        }else if (r.type === this.TYPE_PING){
            cc.log('ping');
            this.pong();
        }else if (r.type === this.TYPE_PONG){
            cc.log('pong');
        }
    },
    _onerror: function(a, b,c){
        cc.log('on error', a,b,c);
    },
    _onclose: function(event){
        cc.log('on close', event);
    }
};

module.exports = Net;