let Client = require('Client');
let PlayerStatePacket = require('PlayerStatePacket');
let Joystick = require('Joystick');
cc.Class({
    extends: cc.Component,

    properties: {
        animation: cc.Animation,
        acceleration: cc.Vec2,
        velocity: cc.Vec2,
        speed: 100,
        joystick: {
            default: null,
            type: Joystick,
            displayName: "摇杆",
            tooltip: "摇杆节点，包含Joystick脚本组件"
        },
    },

    onKeyDown: function(event){
        switch(event.keyCode){
            case cc.KEY.left:
                this.velocity.x = -this.speed;
                break;
            case cc.KEY.right:
                this.velocity.x = this.speed;
                break;
            case cc.KEY.up:
                this.velocity.y = this.speed;
                break;
            case cc.KEY.down:
                this.velocity.y = -this.speed;
                break;
        }
    },
    onKeyUp: function(event){
        switch(event.keyCode){
            case cc.KEY.left:
                this.velocity.x = 0;
                break;
            case cc.KEY.right:
                this.velocity.x = 0;
                break;
            case cc.KEY.up:
                this.velocity.y = 0;
                break;
            case cc.KEY.down:
                this.velocity.y = 0;
                break;
        }
    },

    onLoad: function(){
        this._lastAcceleration = this.acceleration;
        this._lastVelocity = this.velocity;
        this._lastPosition = this.node.getPosition();

        cc.systemEvent.on(cc.SystemEvent.EventType.KEY_DOWN, this.onKeyDown, this);
        cc.systemEvent.on(cc.SystemEvent.EventType.KEY_UP, this.onKeyUp, this);
    },

    onDestroy: function(){
        cc.systemEvent.off(cc.SystemEvent.EventType.KEY_DOWN, this.onKeyDown, this);
        cc.systemEvent.off(cc.SystemEvent.EventType.KEY_UP, this.onKeyUp, this);
    },

    left: function(){
        this.animation.play('yh_left');
    },
    right: function(){
        this.animation.play('yh_right');
    },
    down: function(){
        this.animation.play('yh_down');
    },
    up: function(){
        this.animation.play('yh_up');
    },

    update: function(dt){
        let angle = this.joystick.getAngle();
        if (angle !== false){
            this.velocity.x = Math.cos(angle) * this.speed;
            this.velocity.y = Math.sin(angle) * this.speed;
        }else{
            this.velocity.x = 0;
            this.velocity.y = 0;
        }

        // if (!this._lastPosition.equals(this.node.getPosition()) || !this._lastVelocity.equals(this.velocity) || !this._lastAcceleration.equals(this.acceleration)){
        //     cc.log('send packet');
        //     this._lastPosition = this.node.getPosition();
        //     this._lastAcceleration = this.acceleration;
        //     this._lastVelocity = this.velocity;
        //
        //     let ps = cc.clone(PlayerStatePacket);
        //     ps.velocity = cc.clone(this._lastVelocity);
        //     ps.position = cc.clone(this._lastPosition);
        //     ps.time = (new Date()).getTime();
        //
        //     Client.send(ps);
        // }

        if (this.velocity.x === 0 && this.velocity.y === 0){
            return;
        }

        this.node.x += dt * this.velocity.x;
        this.node.y += dt * this.velocity.y;
    }
});
