let client = require('Client');

cc.Class({
    extends: cc.Component,

    properties: {
        _position: cc.Vec2,
        _velocity: cc.Vec2,
        _lastTime: 0,
        _lastPosition: cc.Vec2,
    },

    update: function (dt) {
        while(true){
            let ps = client.receive();
            if (ps === null){
                break;
            }
            if (this._lastTime < ps.time){
                this._velocity = cc.clone(ps.velocity);
                this._position = cc.clone(ps.position);
                this._lastTime = ps.time;
            }
        }
        this.node.x += dt * this._velocity.x;
        this.node.y += dt * this._velocity.y;
    },
});
