cc.Class({
    extends: cc.Component,

    properties: {
        camera: cc.Camera,
        _startPosition: cc.Vec2.ZERO
    },


    _onTouchStart: function(event){
        this._startPosition = event.getTouches()[0].getLocation();
    },
    _onTouchEnd: function(){
    },
    _onTouchCancel: function(){

    },
    _onTouchMove: function(event){
        let target = event.getTouches()[0].getLocation();
        let current = this.camera.node.getPosition();
        let point = cc.pSub(current, cc.pSub(target, this._startPosition));
        this.camera.node.setPosition(point);
        this._startPosition = target;
    },

    onLoad: function () {
        this.node.on(cc.Node.EventType.TOUCH_START, this._onTouchStart, this);
        this.node.on(cc.Node.EventType.TOUCH_END, this._onTouchEnd, this);
        this.node.on(cc.Node.EventType.TOUCH_CANCEL, this._onTouchCancel, this);
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this._onTouchMove, this);
    },

});
