let Margin = require('Margin');

cc.Class({
    extends: cc.Component,

    properties: {
        camera: {
            type: cc.Camera,
            default: null
        },
        target: {
            type: cc.Node,
            default: null,
            tooltip: "摄像机跟随目标"
        },
        width: {
            type: cc.Integer,
            default: 0,
            min: 0,
            tooltip: "屏幕宽度"
        },
        height: {
            type: cc.Integer,
            default: 0,
            min: 0,
            tooltip: "屏幕高度"
        },
        margin_left: {
            type: cc.Integer,
            default: 0,
            min: 0,
            tooltip: "目标距离相机左方多远开始相机跟随"
        },
        margin_right: {
            type: cc.Integer,
            default: 0,
            min: 0,
            tooltip: "目标距离相机右方多远开始相机跟随"
        },
        margin_top: {
            type: cc.Integer,
            default: 0,
            min: 0,
            tooltip: "目标距离相机上方多远开始相机跟随"
        },
        margin_bottom: {
            type: cc.Integer,
            default: 0,
            min: 0,
            tooltip: "目标距离相机下方多远开始相机跟随"
        },
        frequency: {
            type: cc.Float,
            default: 0.1,
            min: 0,
            tooltip: "检测间隔，单位秒"
        },
        duration:{
            type: cc.Float,
            default: 0.5,
            min: 0,
            tooltip: "跟随时相机移动动画时间，单位秒"
        }
    },

    follow: function(pos, direction){
        if (this.duration){
            let follow = cc.moveTo(this.duration, pos);
            // follow.easing(cc.easeInOut(2));
            this.camera.node.stopAllActions();
            this.camera.node.runAction(follow);
        }else{
            this.camera.node.setPosition(pos);
        }

    },

    // use this for initialization
    onLoad: function () {
        this._frequencyTimer = this.frequency;
    },

    // called every frame, uncomment this function to activate update callback
    update: function (dt) {
        this._frequencyTimer -= dt;
        if (this._frequencyTimer <= 0){
            let cameraPos = this.camera.node.convertToWorldSpaceAR(cc.Vec2.ZERO);
            let targetPos = this.target.convertToWorldSpaceAR(cc.Vec2.ZERO);

            // 判断左右边距
            if (cameraPos.x - targetPos.x >= 0){
                if (cameraPos.x - targetPos.x >= this.width / 2 - this.margin_left){
                    this.follow(targetPos, 'left');
                }
            }else{
                if (cameraPos.x - targetPos.x <= -this.width / 2 + this.margin_right){
                    this.follow(targetPos, 'right');
                }
            }

            // 判断上下边距
            if (cameraPos.y - targetPos.y >= 0){
                if (cameraPos.y - targetPos.y >= this.height / 2 - this.margin_top){
                    this.follow(targetPos, 'bottom');
                }
            }else{
                if (cameraPos.y - targetPos.y <= -this.height / 2 + this.margin_bottom){
                    this.follow(targetPos, 'top');
                }
            }

            this._frequencyTimer = this.frequency;
        }
    },
});
