let _angle = false;
cc.Class({
    extends: cc.Component,

    properties: {
        bgSprite: cc.Node,
        stickSprite: cc.Node,
        directions: 360,
        smooth: {
            default: true,
            displayName: "摇杆360度方向",
            tooltip: "如果勾选则摇杆跟随滑动。如果取消，方向与设定方向相同（设定4方向，则摇杆也四方向滑动）"
        }
    },

    /**
     * 获取当前控制杆的角度
     * 使用方法：
     * x += Math.cos(getAngle()) * dt;
     * y += Math.sin(getAngle()) * dt;
     * @returns {number|bool}
     */
    getAngle: function(){
        return _angle;
    },
    onLoad: function () {
        this.stickSprite.on('touchmove', this.onTouchMove, this);
        this.stickSprite.on('touchend', this.onTouchEnd, this);
        this.stickSprite.on('touchcancel', this.onTouchCancel, this);
        cc.log(this.g);
    },
    onDestroy: function(){
        this.stickSprite.off('touchmove', this.onTouchMove, this);
        this.stickSprite.off('touchend', this.onTouchEnd, this);
        this.stickSprite.off('touchcancel', this.onTouchCancel, this);
    },
    onTouchMove: function(e){
        let radius = this.bgSprite.width / 2;
        let pos = this.bgSprite.convertToNodeSpaceAR(e.getLocation());
        let angle =  Math.atan2(pos.y, pos.x);
        if (this.directions >= 360){
            _angle = angle;
        }else{
            let singleAngle = 2 * Math.PI / this.directions;
            _angle = Math.floor((angle + singleAngle / 2) / singleAngle) * singleAngle;
        }
        let x = 0;
        let y = 0;
        if (this.smooth){
            x = pos.x > 0 ? Math.min(pos.x, Math.cos(angle) * radius) : Math.max(pos.x, Math.cos(angle) * radius);
            y = pos.y > 0 ? Math.min(pos.y, Math.sin(angle) * radius) : Math.max(pos.y, Math.sin(angle) * radius);
        }else{
            x = pos.x > 0 ? Math.min(pos.x, Math.cos(_angle) * radius) : Math.max(pos.x, Math.cos(_angle) * radius);
            y = pos.y > 0 ? Math.min(pos.y, Math.sin(_angle) * radius) : Math.max(pos.y, Math.sin(_angle) * radius);
        }
        this.stickSprite.setPosition(x, y);
    },
    onTouchEnd: function(e){
        _angle = false;
        this.stickSprite.setPosition(0, 0);
    },
    onTouchCancel: function(e){
        _angle = false;
        this.stickSprite.setPosition(0, 0);
    }
});
