
cc.Class({
    extends: cc.Component,

    properties: {
        sprite: cc.Sprite,
        iPercent: 0.5,
        _iTime: 0,
    },

    onLoad () {
        if (cc.dynamicAtlasManager) {
            cc.dynamicAtlasManager.enabled = false;
        }
    },

    start () {
        this._iTime = Date.now() + 3500 * Math.random();
        var mat = this.sprite.sharedMaterials[0];
        if (mat) {
            mat.setProperty('iPercent', this.iPercent);
            mat.setProperty('iTime', 0);
        }
    },

    update (dt) {
        var mat = this.sprite.sharedMaterials[0];
        if (mat) {
            var now = Date.now();
            var time = (now - this._iTime) / 1000;
            mat.setProperty('iTime', time);
        }
    },
});
