cc.Class({
    extends: cc.Component,

    properties: {
        updateBar : {
            default : null,
            type : cc.ProgressBar
        },
        updateTipsLal : {
            default : null,
            type : cc.Label
        },
        _updating: false,
        _canRetry: false,
        updateRes : "",
    },

    checkCb: function (event) {
        window.common.log('Code: ' + event.getEventCode());
        switch (event.getEventCode())
        {
            case jsb.EventAssetsManager.ERROR_NO_LOCAL_MANIFEST:
                window.common.log("No local manifest file found, hot update skipped.");
                break;
            case jsb.EventAssetsManager.ERROR_DOWNLOAD_MANIFEST:
            case jsb.EventAssetsManager.ERROR_PARSE_MANIFEST:
                window.common.log("Fail to download manifest file, hot update skipped.");
                break;
            case jsb.EventAssetsManager.ALREADY_UP_TO_DATE:
                window.common.log("Already up to date with the latest remote version .");
                break;
            case jsb.EventAssetsManager.NEW_VERSION_FOUND:
                window.common.log("New version found, please try to update.");
                this.updateTipsLal.progress = 0;
                break;
            default:
                return;
        }

        cc.eventManager.removeListener(this._checkListener);
        this._checkListener = null;
        this._updating = false;
    },

    updateCb: function (event) {
        var needRestart = false;
        var failed = false;
        switch (event.getEventCode())
        {
            case jsb.EventAssetsManager.ERROR_NO_LOCAL_MANIFEST:
                window.common.log("没有找到本地manifest");
                this.updateTipsLal.string = "没有找到本地配置文件,请点击一键修复";
                window.eventC.dispatchEvent(window.eventC.showXiuFuBtn);
                failed = true;
                break;
            case jsb.EventAssetsManager.UPDATE_PROGRESSION:
                var percent = event.getPercent();
                this.updateBar.progress = percent;
                // this.panel.fileProgress.progress = event.getPercentByFile() / 100
                // percent = event.getDownloadedBytes() * 100 / event.getTotalBytes();
                // percent = parseFloat(percent);
                // if(percent) {
                //
                //     percent = percent.toFixed(2) + '%';
                // }else{
                //     percent = "";
                //     // percent = (Number(this.updateBar.progress)*100).toFixed(2);
                // }
                // var msg = event.getMessage();
                // if (msg) {
                //     window.log('Updated file: ' + msg);
                //     //(" + (parseFloat(showPro) * 100) + ")
                //     this.updateTipsLal.string = "正在更新... " + percent;//";// +
                //     window.log(percent + '% : ' + msg);
                // }
                percent = parseFloat(percent) * 100;
                //window.log('Updated file1: ' + percent);
                if(percent) {
                    percent = percent.toFixed(2) + '%';
                }else{
                    percent = "";
                    // percent = (Number(this.updateBar.progress)*100).toFixed(2);
                }
                if (percent) {
                    //window.log('Updated file2: ' + msg);
                    //(" + (parseFloat(showPro) * 100) + ")
                    this.updateTipsLal.string = "正在更新... " + percent;//";// +
                    window.log(percent + '% : ' + msg);
                }
                break;
            case jsb.EventAssetsManager.ERROR_DOWNLOAD_MANIFEST:
            case jsb.EventAssetsManager.ERROR_PARSE_MANIFEST:
                window.common.log("解析manifest 或 错误的manifest");
                this.updateTipsLal.string = "没有找到服务器配置文件,请点击一键修复";
                window.eventC.dispatchEvent(window.eventC.showXiuFuBtn);
                failed = true;
                break;
            case jsb.EventAssetsManager.ALREADY_UP_TO_DATE:
                window.common.log("Already up to date with the latest remote version.");
                this.updateTipsLal.string = '没有更新！';
                //var updatePanel = cc.find("Canvas/layout_loading/lanuch");
                this.updateBar.progress = 1;
                // this.updateBar.node.active = false;
                failed = true;
                this.updateFinish();
                break;
            case jsb.EventAssetsManager.UPDATE_FINISHED:
                window.common.log('Update finished. ' + event.getMessage());
                this.updateTipsLal.string = '更新完成！';
                needRestart = true;
                this.updateFinish();
                break;
            case jsb.EventAssetsManager.UPDATE_FAILED:
                window.common.log('Update failed. ' + event.getMessage());
                this.updateTipsLal.string = "更新失败,请点击一键修复";
                window.eventC.dispatchEvent(window.eventC.showXiuFuBtn);
                //this.panel.retryBtn.active = true;
                this._updating = false;
                this._canRetry = true;
                break;
            case jsb.EventAssetsManager.ERROR_UPDATING:
                window.common.log("Asset update error: " + event.getAssetId() + ', ' + event.getMessage());
                this.updateTipsLal.string = "文件错误,请点击一键修复";
                window.eventC.dispatchEvent(window.eventC.showXiuFuBtn);
                break;
            case jsb.EventAssetsManager.ERROR_DECOMPRESS:
                window.common.log("解压缩失败");
                this.updateTipsLal.string = "文件错误,请点击一键修复";
                window.eventC.dispatchEvent(window.eventC.showXiuFuBtn);
                break;
            default:
                break;
        }

        if (failed) {
            cc.eventManager.removeListener(this._updateListener);
            this._updateListener = null;
            this._updating = false;
        }

        if (needRestart) {
            cc.eventManager.removeListener(this._updateListener);
            this._updateListener = null;
            // Prepend the manifest's search path
            var searchPaths = jsb.fileUtils.getSearchPaths();
            var newPaths = this._am.getLocalManifest().getSearchPaths();
            var itemSearchPaths = [];
            itemSearchPaths.unshift(searchPaths);

            window.log(JSON.stringify(searchPaths));
            window.log(JSON.stringify(newPaths));
            window.log(JSON.stringify(itemSearchPaths));
            Array.prototype.unshift(searchPaths, newPaths);
            jsb.fileUtils.setSearchPaths(searchPaths);
            var writab = jsb.fileUtils.getWritablePath(),tempArray = [];
            for(var i = 0; i < newPaths.length; ++i){
                var temp = newPaths[i].replace(writab,"");
                tempArray.push(temp);
            }
            itemSearchPaths.unshift(tempArray);
            window.log(JSON.stringify(itemSearchPaths));
            // This value will be retrieved and appended to the default search path during game startup,
            // please refer to samples/js-tests/main.js for detailed usage.
            // !!! Re-add the search paths in main.js is very important, otherwise, new scripts won't take effect.
            // cc.sys.localStorage.setItem('HotUpdateSearchPaths', JSON.stringify(searchPaths));
            window.common.setLocalData("HotUpdateSearchPaths",JSON.stringify(itemSearchPaths),true);

            cc.game.restart();
        }
    },

    updateFinish: function () {
        if (this.checkCanUpdate() == -1){
            window.myGlobal.resVersion = window.common.getAppVersionName();//this._am.getLocalManifest().getVersion();
        }else {
            window.myGlobal.resVersion = this._am.getLocalManifest().getVersion();
        }
        this.node.destroy();
        // cc.director.loadScene("assets/scene/loginScene");
        window.common.enterLogin();
    },

    checkUpdate: function () {
        var self = this;
        if (self._updating) {
            self.updateTipsLal.string = '正在检查更新 ...';
            return;
        }
        if (!self._am.getLocalManifest().isLoaded()) {
            self.updateTipsLal.string = '没有找到本地跟新文件 ...';
            window.eventC.dispatchEvent(window.eventC.showXiuFuBtn);
            return;
        }
        this._checkListener = new jsb.EventListenerAssetsManager(this._am, this.checkCb.bind(this));
        cc.eventManager.addListener(this._checkListener, 1);

        this._am.checkUpdate();
        this._updating = true;
    },
    //检查能否更新
    checkCanUpdate : function () {
        var rtn = -1;
        if(window.common.isMobile()){
            if(window.myGlobal.isInReview){
                rtn = -1;
            }else {
                rtn = 1;
            }
            var supportVersionRegExp = new RegExp(window.myGlobal.supportVersion,"gi");
            if(window.common.getAppVersionName().search(supportVersionRegExp) == -1){
                var panel = cc.director.getScene().getChildByName("debugBg");
                var zorder = window.const.TipsZorder;
                if(panel){
                    zorder = panel.getLocalZOrder();
                }
                window.myGlobal.supportVersion = JSON.stringify(window.myGlobal.supportVersion);
                var tipStrs = "有新版本更新，请点击确定\n重新下载安装最新版本";
                if(window.myGlobal.supportVersion && window.myGlobal.supportVersion.del){
                    tipStrs = "有新版本更新，请点击确定\n重新下载安装最新版本\n并删除之前的游戏应用";
                }
                var Tips = new window.publicTips(tipStrs,function () {
                    Tips.destroyPub();
                    cc.Application.getInstance().openURL(window.myGlobal.guanWangUrl)
                },function (data) {
                    Tips.destroyPub();
                },true);
                // Tips.setLocalZOrder(zorder + 10);
                rtn = 0;
            }
        }


        window.log("rtn " + rtn);
        return rtn;
    },
    //触发更新
    hotUpdate: function () {
        var rtn = this.checkCanUpdate();
        if (rtn <= 0){
            if(rtn == -1){
                this.updateFinish();
            }
            return false;
        }
        this.node.active = true;
        if (this._am && !this._updating) {
            this._updateListener = new jsb.EventListenerAssetsManager(this._am, this.updateCb.bind(this));
            cc.eventManager.addListener(this._updateListener, 1);

            this._failCount = 0;
            this._am.update();
            this._updating = true;
        }
    },


    // use this for initialization
    onLoad: function () {
        var self = this;
        self.node.active = false;
        // Hot update is only available in Native build
        if (!window.common.isNative()) {
            return;
        }
        if(window.myGlobal.gameScene != window.const.gameScene.loading){
            var mask = cc.find("mask",self.node);
            mask.opacity = 100;
            mask.on("touchstart", function (event) {

            },this);
        }
        var updatePath = window.const.updatePath;
        var storagePath = ((jsb.fileUtils ? jsb.fileUtils.getWritablePath() : '/') + updatePath);
        window.log('Storage path for remote asset : ' + storagePath);
        var appVersionName = "";
        if(window.common.isMobile()){
            appVersionName = window.common.getAppVersionName();
        }
        storagePath = storagePath + appVersionName;
        // this.updateRes = updatePath + appVersionName;
        // cc.log('Local manifest URL : ' + this.manifestUrl);
        window.log("cc.url.raw(resources/project.manifest)" + cc.url.raw("resources/project.manifest"));
        this._am = new jsb.AssetsManager(cc.url.raw("resources/project.manifest"), storagePath);
        if (!cc.sys.ENABLE_GC_FOR_NATIVE_OBJECTS) {
            this._am.retain();
        }
        var searchPaths = jsb.fileUtils.getSearchPaths();
        var newPaths = this._am.getLocalManifest().getSearchPaths();
        var itemSearchPaths = [];
        itemSearchPaths.unshift(searchPaths);

        window.log(JSON.stringify(searchPaths));
        window.log(JSON.stringify(newPaths));
        window.log(JSON.stringify(itemSearchPaths));

        // Setup your own version compare handler, versionA and B is versions in string
        // if the return value greater than 0, versionA is greater than B,
        // if the return value equals 0, versionA equals to B,
        // if the return value smaller than 0, versionA is smaller than B.
        this._am.setVersionCompareHandle(function (versionA, versionB) {
            window.common.log("JS Custom Version Compare: version A is " + versionA + ', version B is ' + versionB);
            var vA = versionA.split('.');
            var vB = versionB.split('.');
            for (var i = 0; i < vA.length; ++i) {
                var a = parseInt(vA[i]);
                var b = parseInt(vB[i] || 0);
                if (a === b) {
                    continue;
                }
                else {
                    return a - b;
                }
            }
            if (vB.length > vA.length) {
                return -1;
            }
            else {
                return 0;
            }
        });

        //var panel = this.panel;
        // Setup the verification callback, but we don't have md5 check function yet, so only print some message
        // Return true if the verification passed, otherwise return false
        this._am.setVerifyCallback(function (path, asset) {
            // When asset is compressed, we don't need to check its md5, because zip file have been deleted.
            var compressed = asset.compressed;
            // Retrieve the correct md5 value.
            var expectedMD5 = asset.md5;
            // asset.path is relative path and path is absolute.
            var relativePath = asset.path;
            // The size of asset file, but this value could be absent.
            var size = asset.size;
            if (compressed) {
                self.updateTipsLal.string = "验证通过 : " + relativePath;
                return true;
            }
            else {
                self.updateTipsLal.string = "验证通过 : " + relativePath + ' (' + expectedMD5 + ')';
                return true;
            }
        });

        // this.updateTipsLal.string = 'Hot update is ready, please check or directly update.';

        if (window.common.isWinPlatform()) {
            // Some Android device may slow down the download process when concurrent tasks is too much.
            // The value may not be accurate, please do more test and find what's most suitable for your game.
            this._am.setMaxConcurrentTask(2);
            this.updateTipsLal.string = "Max concurrent tasks count have been limited to 2";
        }
        window.common.log(JSON.stringify(this._am.getLocalManifest()));
        window.common.log(this._am.getLocalManifest().getVersion());
        window.common.log(this._am.getLocalManifest().getPackageUrl());
        window.common.log(self._am.getLocalManifest().isLoaded());
        this.updateBar.progress = 0;
        this.hotUpdate();

        // var self = this;
        //
        // window.common.getJsonForHttpGet(url,function (json) {
        //     window.common.initGameConfig(json);
        //     //window.log("aaaa");
        //     self.hotUpdate();
        // });
    },

    onDestroy: function () {
        if (this._updateListener) {
            cc.eventManager.removeListener(this._updateListener);
            this._updateListener = null;
        }
        if (this._am && !cc.sys.ENABLE_GC_FOR_NATIVE_OBJECTS) {
            this._am.release();
        }
        //window.event.removeEventListener(window.event.hotUpdateStart);
    }
});
