(function () {
    let chars = ['0','1','2','3','4','5','6','7','8','9',
    'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z',
    'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z'];

    function _StringBuilder()
    {
        this._buffers = [];
        this._length=0;
        this._splitChar = arguments.length>0 ? arguments[arguments.length-1] : '';

        if(arguments.length>0)
        {
            for(var i=0,iLen=arguments.length-1;i<iLen;i++)
            {
                this.Append(arguments[i]);
            }
        }

    }
    /**
     * 随机取一定长度的字符串
     * @param n
     * @returns {string}
     */
    _StringBuilder.prototype.generateMixed = function (n) {
        var str = "";
        for(var i = 0; i < n ; i ++) {
            var id = Math.ceil(Math.random()*61);
            str += chars[id];
        }
        return str;
    };
    //向对象中添加字符串
    //参数：一个字符串值
    _StringBuilder.prototype.Append=function(str)
    {
        this._length += str.length;
        this._buffers[this._buffers.length] = str;
    };

    _StringBuilder.prototype.Pop=function()
    {
        var str = this._buffers[this._buffers.length-1];
        this._length -= str.length;
        this._buffers.pop();
        // this._buffers[this._buffers.length] = str;
    };

    _StringBuilder.prototype.Add = _StringBuilder.prototype.Append;

    //向对象附加格式化的字符串
    //参数：参数一是预格式化的字符串，如：'{0} {1} {2}'
    //格式参数可以是数组，或对应长度的arguments,
    //参见示例
    _StringBuilder.prototype.AppendFormat=function()
    {
        if(arguments.length>1)
        {
            var TString=arguments[0];
            if(arguments[1] instanceof Array)
            {
                for(var i=0,iLen=arguments[1].length;i<iLen;i++)
                {
                    var jIndex=i;
                    var re=eval("/\\{"+jIndex+"\\}/g;");
                    TString= TString.replace(re,arguments[1][i]);
                }
            }
            else
            {
                for(var i=1,iLen=arguments.length;i<iLen;i++)
                {
                    var jIndex=i-1;
                    var re=eval("/\\{"+jIndex+"\\}/g;");
                    TString= TString.replace(re,arguments[i]);
                }
            }
            this.Append(TString);
        }
        else if(arguments.length==1)
        {
            this.Append(arguments[0]);
        }
    };

    //字符串长度（相当于ToString()后输出的字符串长度
    _StringBuilder.prototype.Length=function()
    {
        if(this._splitChar.length>0 && (!this.IsEmpty()))
        {
            return  this._length + ( this._splitChar.length * ( this._buffers.length-1 ) ) ;
        }
        else
        {
            return this._length;
        }
    };
    //字符串是否为空
    _StringBuilder.prototype.IsEmpty=function()
    {
        return this._buffers.length <= 0;
    };
    //清空
    _StringBuilder.prototype.Clear = function()
    {
        this._buffers = [];
        this._length=0;
    };
    //输出
    //参数：可以指定一个字符串（或单个字符），作为字符串拼接的分隔符
    _StringBuilder.prototype.ToString = function()
    {
        if(arguments.length==1)
        {
            return this._buffers.join(arguments[1]);
        }
        else
        {
            return this._buffers.join(this._splitChar);
        }
    };
    window.StringBuilder = _StringBuilder;
    //保留一定长度的字符串
    window.SubMyString = function(str, len) {
        if(typeof str != "string"){
            return "";
        }
        var strlen = 0;
        var stringBuilder = new _StringBuilder();
        var s = "";
        for (var i = 0; i < str.length; i++) {
            if (str.charCodeAt(i) > 128) {
                strlen += 2;
            } else {
                strlen++;
            }
            if (strlen > len) {
                stringBuilder.Pop();
                stringBuilder.Append("...");
                s = stringBuilder.ToString();
                return s;
            }
            stringBuilder.Append(str.charAt(i));
        }
        s = stringBuilder.ToString();
        return s;
    };
})();
