(function () {
    var _utils = function () {
        
    },TAG = "utils/utilsMethod";
    var isPlatform = 0;

    _utils.getWXAppId = function () {
        var appID = null;
        if (MyCommon.isIosPlatform()) {
            appID = jsb.reflection.callStaticMethod("AppController", "getAppID");
        } else if (window.common.isAndroidPlatform()) {
            appID = jsb.reflection.callStaticMethod("org/cocos2dx/javascript/AppActivity", "getAppID", "()Ljava/lang/String;");
        }
        return appID;
    };
    _utils.sendAuthRequest  = function () {
        if (MyCommon.isAndroidPlatform()) {
            jsb.reflection.callStaticMethod("org/cocos2dx/javascript/AppActivity", "sendAuthRequest", "()V");
        } else if (window.common.isIosPlatform()) {
            jsb.reflection.callStaticMethod("AppController","sendAuthRequest");
        }
    };

    _utils.shareURLToHY = function (url, title, description, isSharedState) {
        var self = this;
        if (url == null) {
            return;
        }
        var isPlatform = 0;
        var androidParam = "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)V";
        if (MyCommon.isAndroidPlatform()) {
            isPlatform = 1;
            jsb.reflection.callStaticMethod("org/cocos2dx/javascript/AppActivity", "shareURLToWX", androidParam, url, title, description, isSharedState);
        } else if (MyCommon.isIosPlatform()) {
            isPlatform = 2;
            jsb.reflection.callStaticMethod("AppController", "shareURLToWX:andsigntitle:anddescription:isShareGetRoomCard:", url, title, description, isSharedState);
        }
        _utils.isPlatformFun(isPlatform, "朋友");
    },
        //分享微信朋友圈
        _utils.shareURLToWXPYQ = function (url, title, description, isSharedState) {
            var self = this;
            if (url == null) {
                return;
            }
            var isPlatform = 0;
            var androidParam = "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)V";
            if (window.common.isAndroidPlatform()) {
                isPlatform = 1;
                jsb.reflection.callStaticMethod("org/cocos2dx/javascript/AppActivity", "shareURLToWXPYQ", androidParam, url, title, description, isSharedState);
            } else if (window.common.isIosPlatform()) {
                isPlatform = 2;
                jsb.reflection.callStaticMethod("AppController", "shareURLToWXPYQ:andsigntitle:anddescription:isShareGetRoomCard:", url, title, description, isSharedState);
            }
            _utils.isPlatformFun(isPlatform, "朋友圈");
        },
        //分享图片
        _utils.shareImageToWX = function (shareImgUrl) {
            var self = this;
            if (shareImgUrl == null) {
                return;
            }
            var isPlatform = 0;
            var androidParam = "(Ljava/lang/String;)V";
            if (window.common.isAndroidPlatform()) {
                isPlatform = 1;
                jsb.reflection.callStaticMethod("org/cocos2dx/javascript/AppActivity", "shareImageToWX", androidParam, shareImgUrl);
            } else if (window.common.isIosPlatform()) {
                isPlatform = 2;
                jsb.reflection.callStaticMethod("AppController", "shareImageToWX:", shareImgUrl);
            }
            window.log("分享图片成功了。");
            _utils.isPlatformFun(isPlatform, "图片");
        },
        //分享图片至朋友圈
        _utils.shareImageToPYQ = function (shareImgUrl) {
            var self = this;
            if (shareImgUrl == null) {
                return;
            }
            var isPlatform = 0;
            var androidParam = "(Ljava/lang/String;)V";
            if (window.common.isAndroidPlatform()) {
                isPlatform = 1;
                jsb.reflection.callStaticMethod("org/cocos2dx/javascript/AppActivity", "shareImageToPYQ", androidParam, shareImgUrl);
            } else if (window.common.isIosPlatform()) {
                isPlatform = 2;
                jsb.reflection.callStaticMethod("AppController", "shareImageToPYQ:", shareImgUrl);
            }
            _utils.isPlatformFun(isPlatform, "图片");
        },

        //检查是否安装微信客户端
        _utils.checkIsInstallWX = function () {
            var self = this;
            var isWXAppInstalled = false;
            if (window.common.isIosPlatform()) {
                var res = jsb.reflection.callStaticMethod("AppController", "isWXAppInstalled");
                isWXAppInstalled = res;
            } else if (window.common.isAndroidPlatform()) {
                var res = jsb.reflection.callStaticMethod("org/cocos2dx/javascript/AppActivity", "isWXAppInstalled", "()Z");
                isWXAppInstalled = res;
            }
            return isWXAppInstalled;
        },
        _utils.isPlatformFun = function (isPlatform, msg) {
            var self = this;
            if (typeof isPlatform == 1) {
                //window.log("Android 分享到微信"+msg+"。");
            } else if (typeof isPlatform == 2) {
                //window.log("IOS     分享到微信"+msg+"。");
            }
            self.isPlatform = 0;
        };

    //截取屏幕保存为JPG格式图片，并将图片路径返回。
    _utils.shareImgToUrl = function () {
        var self = this;
        //截屏分享图片
        var winSize = cc.director.getWinSize();
        // create a render texture
        var target = new cc.RenderTexture(winSize.width, winSize.height, 2);

        target.begin();
        cc.director.getRunningScene().visit();
        target.end();
        var date = new Date();
        var currentTime = date.getTime();
        var Y = date.getFullYear() + '-';
        var M = (date.getMonth() + 1 < 10 ? '0' + (date.getMonth() + 1) : date.getMonth() + 1) + '-';
        var D = date.getDate() + '';
        var h = date.getHours() + '-';
        var m = date.getMinutes() + '-';
        var s = date.getSeconds();
        window.log(Y + M + D + h + m + s);
        var shareImgToFileName = "wx-" + Utils.currentTime() + ".jpg";
        target.saveToFile(shareImgToFileName, cc.IMAGE_FORMAT_PNG, false);
        var shareImg = jsb.fileUtils.getWritablePath() + shareImgToFileName;
        window.log("images saved! 图片地址： " + shareImg);
        return shareImg;
    };
    //当前系统时间转换 ，该格式为： Y+M+D+h+m+s;
    _utils.currentTime = function () {
        var self = this;
        var date = new Date();
        var Y = date.getFullYear() + '_';
        var M = (date.getMonth() + 1 < 10 ? '0' + (date.getMonth() + 1) : date.getMonth() + 1) + '_';
        var D = date.getDate() + '_';
        var h = date.getHours() + '_';
        var m = date.getMinutes() + '_';
        var s = date.getSeconds();
        var appendTime = Y + M + D + h + m + s;
        window.log(appendTime);
        return appendTime;
    },
        //处理魔窗信息
        _utils.getMWAction = function () {
            var self = this;
            var result = "";
            if (window.common.isAndroidPlatform()) {
                var androidParam = "()Ljava/lang/String;";
                result = jsb.reflection.callStaticMethod("org/cocos2dx/javascript/AppActivity", "getMWAction", androidParam);
            } else if (window.common.isIosPlatform()) {
                result = jsb.reflection.callStaticMethod("AppController", "getMWAction");
            }
            //window.log("_utils.getMWAction   -->>>>    魔窗URI ：" + String(result)); //{"action":"enterroom","code":"148500"}
            return result;
        },
        _utils.clearMWAction = function () {
            var self = this;
            if (window.common.isAndroidPlatform()) {
                jsb.reflection.callStaticMethod("org/cocos2dx/javascript/AppActivity", "cleanMWAction", "()V");
            } else if (window.common.isIosPlatform()) {
                jsb.reflection.callStaticMethod("AppController", "cleanMWAction");
            }
        },
        //获取微信Code码，供java调用
        _utils.callWXAuthCode = function (authCode) {
            var self = this;
            if (authCode == null) {
                return;
            }
            setTimeout(function () {
                window.eventC.dispatchEvent(window.eventC.callName, authCode);
            }, 500);
        };
    //分享后回调
    _utils.callWXShared = function (code) {
        var self = this;
        if (code == null) {
            return;
        }
        // setTimeout(function () {
        //     window.eventC.dispatchEvent(window.eventC.sharedResult, code);
        // }, 200);
    };
    //录音权限
    _utils.callRecordState = function (recordState) {
        var self = this;
        if (recordState == null) {
            return;
        }
        setTimeout(function () {
            window.myGlobal.recordPer = recordState;
        }, 200);
    };
    _utils.getRecordPerState = function () {
        var recordState = false;
        if (window.common.isAndroidPlatform()) {
            var androidParam = "()Z";
            recordState = jsb.reflection.callStaticMethod("org/cocos2dx/javascript/AppActivity", "isHaveRedordPer", androidParam);
        } else if (window.common.isIosPlatform()) {
            recordState = jsb.reflection.callStaticMethod("AppController", "isHaveRedordPer");
        }
        //window.log("JavaScript 录音权限： " + recordState);
        if (recordState == null) {
            return false;
        }
        return recordState;
    };
    _utils.addA = function (sp1, sp2, sp3, sp4) {
        // 1280 720
        //var winSize = cc.getWinSize();
        var winSize = cc.view.getFrameSize();//cc.director.getVisibleSize();
        var pp = new cc.Node();
        pp.parent = cc.find("Canvas");
        pp.zIndex = -500;
        var jieSuanNode = cc.find("Canvas/NewSumNode");
        var shareimg = cc.instantiate(jieSuanNode);
        //cc.find("New Sprite(Splash)",shareimg).active = false;

        // shareimg.zIndex = -500;
        shareimg.parent = pp//cc.find("Canvas")//cc.director.getRunningScene();
        window.log("cc.winSize.width / 1280) " + winSize.width + " " + winSize.width / 1280);
        // pp.parent = null;

        // create a render texture
        var target = new cc.RenderTexture(1280, 720, cc.Texture2D.PIXEL_FORMAT_RGBA8888, gl.DEPTH24_STENCIL8_OES);

        // //背景    sp1
        // sp1.anchor = cc.p(0,0);
        // sp1.position = cc.p(640,360);
        //背景二维码字样   sp2
        sp2.anchor = cc.p(0, 0);
        sp2.position = cc.p(940, 40);
        //logo      sp3
        sp3.anchor = cc.p(0, 0);
        sp3.position = cc.p(1120, 660);
        // sp3.active = false;
        //二维码图片 sp4
        sp4.anchor = cc.p(0, 0);
        sp4.position = cc.p(1137, 74);
        shareimg.position = cc.p(640, 360);
        // sp4.parent = target;

        target.begin();
        // sp1._sgNode.visit();
        // shareimg.scale = 0.92; //* (winSize.height / 1280);
        // shareimg.scaleY = 0.8;
        shareimg._sgNode.visit();
        sp2._sgNode.visit();
        sp3.scale = 0.8;
        sp3._sgNode.visit();
        sp4.scale = 0.5;
        sp4._sgNode.visit();
        target.end();
        pp.parent = null
        var date = new Date();              //filePath:/data/data/com.senlinhuyu.mahjongjx/files/wx-2017-06-30-23-32-13.png
        var currentTime = date.getTime();
        var Y = date.getFullYear() + '_';
        var M = (date.getMonth() + 1 < 10 ? '0' + (date.getMonth() + 1) : date.getMonth() + 1) + '_';
        var D = date.getDate() + '';
        var h = date.getHours() + '_';
        var m = date.getMinutes() + '_';
        var s = date.getSeconds();
        window.log(Y + M + D + h + m + s);
        var shareImgToFileName = "wx_" + this.currentTime() + ".jpg";

        //var renderTexture = cc.RenderTexture.create(640,960, cc.Texture2D.PIXEL_FORMAT_RGBA8888, gl.DEPTH24_STENCIL8_OES);
        target.saveToFile(shareImgToFileName, cc.IMAGE_FORMAT_JPG, false);
        var shareImg = jsb.fileUtils.getWritablePath() + shareImgToFileName;
        //window.log("images saved! 图片地址： " + shareImg);
        return shareImg;
    };


    _utils.AddImage = function (func) {
        //截屏分享图片
        var _func = func;
        cc.loader.loadResArray([
            "Sumcalculation/zm_jsfxjm_bg",
            "Sumcalculation/zm_jsfxjm_bg_weima",
            "Sumcalculation/zm_jsfxjm_logo_lhjx",
            "Sumcalculation/zm_jsfxjm_ewm_lhjx",
        ], cc.SpriteFrame, function (err, spriteFrames) {
            if (err) {
                cc.error(err);
                return;
            }
            // node.active = false;
            var pp = new cc.Node();
            pp.parent = cc.find("Canvas");
            pp.zIndex = -500;
            // var n1 = new cc.Node("n1");
            // n1.parent =pp;
            // n1.addComponent(cc.Sprite).spriteFrame = spriteFrames[0];
            var n2 = new cc.Node("n2");
            n2.parent = pp;
            n2.addComponent(cc.Sprite).spriteFrame = spriteFrames[1];
            var n3 = new cc.Node("n3");
            n3.parent = pp;
            n3.addComponent(cc.Sprite).spriteFrame = spriteFrames[2];
            var n4 = new cc.Node("n4");
            n4.parent = pp;
            n4.addComponent(cc.Sprite).spriteFrame = spriteFrames[3];
            var imagePath = this.addA(null, n2, n3, n4);
            pp.parent = null;
            if (_func != null) {
                _func(imagePath);
            }
        });
    };
    _utils.getStaticMethodPro = function (callback) {
        var self = this;
        var batteryResult = null;
        var internetStates = null;
        if (window.common.isAndroidPlatform()) {
            var androidParam = "()Ljava/lang/String;";
            //window.log("获取Android 电量。");
            batteryResult = jsb.reflection.callStaticMethod("org/cocos2dx/javascript/AppActivity", "getDeviceBattery", androidParam);
        } else if (window.common.isIosPlatform()) {
            //window.log("获取IOS 电量。");
            batteryResult = jsb.reflection.callStaticMethod("AppController", "getDeviceBattery");

        }
        internetStates = self.getTypeNetwork();
        if (typeof callback === "function") {
            callback(batteryResult, internetStates);
        }
    };
    _utils.getTypeNetwork = function () {
        var internetStates = "WIFI";
        if (window.common.isAndroidPlatform()) {
            var androidParam = "()Ljava/lang/String;";
            internetStates = jsb.reflection.callStaticMethod("org/cocos2dx/javascript/AppActivity", "getInternetStatus", androidParam);
        } else if (window.common.isIosPlatform()) {
            internetStates = jsb.reflection.callStaticMethod("AppController", "getInternetStatus");
        }
        return internetStates;
        // if (typeof callback === "function"){
        //     callback(batteryResult,internetStates);
        // }
    },
    //IOS 定位
    _utils.LocationData = function (Lat, Lon, Accuracy, Address) {
        window.log("JavaScript 定位信息:" + Lat + Lon + Accuracy + Address);
        if (window.common.isIosPlatform()) {
            setTimeout(function () {
                if (Lat == null || Lon == null || Accuracy == null) {
                    window.user.setmLat(0);
                    window.user.setmLon(0);
                    window.user.setmAccuracy(0);
                    window.user.setmAddress("未知");
                    //window.log("JavaScript 定位失败。");
                } else {
                    window.user.setmLat(String(Lat));
                    window.user.setmLon(String(Lon));
                    window.user.setmAccuracy(String(Accuracy));
                    window.user.setmAddress(String(Address));
                    // window.common.setLocalData("Lat",String(Lat));
                    // window.common.setLocalData("Lon",String(Lon));
                    // window.common.setLocalData("Accuracy",String(Accuracy));
                    // window.common.setLocalData("Address",String(Address));
                    //window.log("得到的位置信息是：   经度：" + Lat + "'\t\t纬度：" + Lon + "\t\t精度" + Accuracy + "\t\t具体的位置信息：" + Address + "\t"+window.user.getmLat());
                }
            }, 200);
        }
    };
    _utils.getAndroidPermission = function () {
        if (window.common.isAndroidPlatform()) {
            jsb.reflection.callStaticMethod("org/cocos2dx/javascript/AppActivity", "getPermission", "()V");
        }
    };
    _utils.copyContext = function (content) {
        if (window.common.isIosPlatform()) {
            jsb.reflection.callStaticMethod("AppController", "copyStr:", content);
        } else if (window.common.isAndroidPlatform()) {
            jsb.reflection.callStaticMethod("org/cocos2dx/javascript/AppActivity", "copyStr", "(Ljava/lang/String;)V", content);
        }
    };

    _utils.callLocationData = function (callback) {
        var locationData = null;
        if (window.common.isAndroidPlatform()) {
            var androidParam = "()Ljava/lang/String;";
            locationData = jsb.reflection.callStaticMethod("org/cocos2dx/javascript/AppActivity", "getLocationData", androidParam);
        } else if (window.common.isIosPlatform()) {
            // var isVer = window.common.getAppVersionNameToInt();
            // if(isVer){
            locationData = jsb.reflection.callStaticMethod("AppController","getLocationData");
            // }else{
                //locationData = jsb.reflection.callStaticMethod("AppController","getGPSInfo");
            //}
        }
        window.log("callLocationData   location " + locationData);
        if (typeof callback == "function" && locationData && locationData != "") {
            callback(locationData);
        }
    };
    _utils.initLocation = function () {
        var locationKey = window.myGlobal.locationKey;
        if(window.common.isIosPlatform()){
            jsb.reflection.callStaticMethod("AppController", "initLocation:",locationKey);
        }else if(window.common.isAndroidPlatform()){
            // var isVer = window.common.getAppVersionNameToInt();
            // if(isVer){
            //jsb.reflection.callStaticMethod("org/cocos2dx/javascript/AppActivity", "initLocation","()V");
            // }
        }
    };
    _utils.startLocation = function () {
        if(window.common.isIosPlatform()){
            jsb.reflection.callStaticMethod("AppController", "startLocation");
        }else if(window.common.isAndroidPlatform()){
           //  var isVer = window.common.getAppVersionNameToInt();
           // if(isVer){
           jsb.reflection.callStaticMethod("org/cocos2dx/javascript/AppActivity", "startLocation","()V");
           //  }
        }
    };
    _utils.stopLocation = function () {
        if(window.common.isIosPlatform()){
            jsb.reflection.callStaticMethod("AppController", "stopLocation");
        }else if(window.common.isAndroidPlatform()){
            // var isVer = window.common.getAppVersionNameToInt();
            // if(isVer){
            jsb.reflection.callStaticMethod("org/cocos2dx/javascript/AppActivity", "stopLocation","()V");
            // }
        }
    };
    _utils.isInstallZFB = function () {
        var isZFBAppInstalled = false;
        if (window.common.isIosPlatform()) {
            isZFBAppInstalled = jsb.reflection.callStaticMethod("AppController", "isInstallALP");
        } else if (window.common.isAndroidPlatform()) {
            isZFBAppInstalled = jsb.reflection.callStaticMethod("com/senlinhuyu.mahjongjx/ExternalSDK/ALiPayShare", "isInstallALP", "()Z");
        }
        window.log("是否安装支付宝：" + isZFBAppInstalled);
        return isZFBAppInstalled;
    };
    _utils.isSupportShareToZFB = function () {
        var isSupportShareToZFB = false;
        if (window.common.isIosPlatform()) {
            isSupportShareToZFB = jsb.reflection.callStaticMethod("AppController", "isSupporyPY");
        } else if (window.common.isAndroidPlatform()) {
            isSupportShareToZFB = jsb.reflection.callStaticMethod("com/senlinhuyu.mahjongjx/ExternalSDK/ALiPayShare", "isSupporyPY", "()Z");
        }
        return isSupportShareToZFB;
    };
    _utils.isSupportShareToZFBDT = function () {
        var isSupportShareToZFBDT = false;
        if (window.common.isIosPlatform()) {
            isSupportShareToZFBDT = jsb.reflection.callStaticMethod("AppController", "isSupporySHQ");
        } else if (window.common.isAndroidPlatform()) {
            isSupportShareToZFBDT = jsb.reflection.callStaticMethod("com/senlinhuyu.mahjongjx/ExternalSDK/ALiPayShare", "isSupporySHQ", "()Z");
        }
        return isSupportShareToZFBDT;
    };

    _utils.alipayShareText = function (text) {
        var isInstall = this.isInstallZFB();
        if(isInstall){
            if (window.common.isIosPlatform()) {
                jsb.reflection.callStaticMethod("AppController", "sendTextMessage:",text);
            } else if (window.common.isAndroidPlatform()) {
                jsb.reflection.callStaticMethod("com/senlinhuyu.mahjongjx/ExternalSDK/ALiPayShare", "sendTextMessage", "(Ljava/lang/String;)V",text);
            }
        }else{
            this.showTips("请安装支付宝。");
        }
    };
    _utils.alipayShareImage = function (imageUrl) {
        var isInstall = this.isInstallZFB();
        if(isInstall){
            if (window.common.isIosPlatform()) {
                jsb.reflection.callStaticMethod("AppController", "sendImageMessage:",imageUrl);
            } else if (window.common.isAndroidPlatform()) {
                jsb.reflection.callStaticMethod("com/senlinhuyu.mahjongjx/ExternalSDK/ALiPayShare", "sendImageMessage", "(Ljava/lang/String;)V",imageUrl);
            }
        }else{
            this.showTips("请安装支付宝。");
        }
    };
    _utils.alipayShareUrl = function (shareUrl,title,description) {
        var isInstall = this.isInstallZFB();
        if(isInstall){
            if (window.common.isIosPlatform()) {
                jsb.reflection.callStaticMethod("AppController", "sendWebPageMessage:andsigntitle:anddescription:isShareGetRoomCard:", shareUrl, title, description, 0);
            } else if (window.common.isAndroidPlatform()) {
                var androidParams = "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)V";
               jsb.reflection.callStaticMethod("com/senlinhuyu.mahjongjx/ExternalSDK/ALiPayShare", "sendWebPageMessage", androidParams,shareUrl,title,description,0);
            }
        }else{
            this.showTips("请安装支付宝。");
        }
    };
    _utils.showTips = function (title) {
        var Tips = new window.publicTips(title, function () {
            Tips.destroyPub();
        }, null, true);
    }
    window.Utils = _utils;
})();