const { ccclass, property } = cc._decorator;

@ccclass
export default class Helloworld extends cc.Component {

    @property(cc.Label)
    label: cc.Label = null;

    @property
    text: string = 'hello';

    @property(dragonBones.ArmatureDisplay)
    body_armatureDisplay: dragonBones.ArmatureDisplay = null;

    @property(dragonBones.ArmatureDisplay)
    invisible_armatureDisplay: dragonBones.ArmatureDisplay = null;

    body_armature: dragonBones.Armature;

    start() {
        this.body_armature = this.body_armatureDisplay.armature();
        this.body_armatureDisplay.playAnimation("idle", 500);
        this.loadBones()
    }

    loadBones() {
        let name = "weapon_1004_show"
        const resources = [
            cc.url.raw(`resources/${name}_ske.json`),
            cc.url.raw(`resources/${name}_tex.json`),
            cc.url.raw(`resources/${name}_tex.png`),
        ];

        cc.loader.load(resources, (err, assets) => {
            let factory = dragonBones.CCFactory.getInstance();
            let data = JSON.parse(cc.loader.getRes(resources[0])._dragonBonesJson);
            factory.parseDragonBonesData(data);
            factory.parseTextureAtlasData(cc.loader.getRes(resources[1]), cc.loader.getRes(resources[2]));
        });
    }

    switchWeapon() {
        let factory = dragonBones.CCFactory.getInstance();
        let isok = factory.replaceSlotDisplay("weapon_1004_show",
            "weapon",
            "weapon_r",
            "weapon_1004_r",
            this.body_armature.getSlot('Layer 9'));
        console.log("is replase success = ", isok);
    }

    // let weapon = factory.buildArmature("qixingjian");
    // this.body_armature.getSlot('Layer 9').childArmature = weapon;
    // this.body_armature.getSlot('Layer 9').invalidUpdate();

    // factory.replaceSlotDisplay(
    //     this.invisible_armatureDisplay.getArmatureKey(),
    //     "qixingjian",
    //     "图层 6",
    //     "Qixingjian_L",
    //     this.body_armature.getSlot('Layer 9')
    // );


    // let isok = factory.replaceSlotDisplay(this.invisible_armatureDisplay.getArmatureKey(), "weapon", "weapon_r", "weapon_1004_r", this.body_armature.getSlot('Layer 9'));
    // console.log("===1", this.invisible_armatureDisplay.getArmatureKey());
    // console.log("===2", factory.getAllDragonBonesData());

    // try {
    //     this.loadEquipment("qixingjian", (display: dragonBones.ArmatureDisplay) => {
    //         // let name = "baguajian";
    //         let factory = dragonBones.CCFactory.getInstance();
    //         let weapon = factory.buildArmature("qixingjian");
    //         this.body_armature.getSlot('Layer 9').childArmature = weapon
    //         // factory.replaceSlotDisplay(
    //         //     this.invisible_armatureDisplay.armatureName,
    //         //     "qixingjian",
    //         //     "weapon_r",
    //         //     "weapon_1004c_r",
    //         //     this.body_armature.getSlot('Layer 9')
    //         // );
    //     });
    // } catch (err) {
    //     console.log("[Player switchWeapon] catch:", err)
    //     // Logger.debug("[Player switchWeapon] catch:", err);
    // }


    /**
     * 加载装备
     */
    public loadEquipment(name: string, next: Function) {
        const resources = [
            cc.url.raw(`resources/bones/icon/${name}_ske.json`),
            cc.url.raw(`resources/bones/icon/${name}_tex.json`),
            cc.url.raw(`resources/bones/icon/${name}_tex.png`),
        ];

        cc.loader.load(resources, (err, assets) => {
            let factory = dragonBones.CCFactory.getInstance();
            // console.log("===before", factory.getAllDragonBonesData());
            let data = JSON.parse(cc.loader.getRes(resources[0])._dragonBonesJson);
            factory.parseDragonBonesData(data);
            factory.parseTextureAtlasData(cc.loader.getRes(resources[1]), cc.loader.getRes(resources[2]));
            console.log("===after", factory.getAllDragonBonesData());
            // next(null)
        });
    }

    // public GetKeyString(rawData, key, defaultValue) {
    //     console.log("=====", key, rawData);
    //     if (key in rawData) {
    //         var value = rawData[key];
    //         var type = typeof value;
    //         console.log("=====", value);
    //         console.log("=====", type);
    //         if (type === "string") {
    //             if (dragonBones.DragonBones.webAssembly) {
    //                 for (var i = 0, l = value.length; i < l; ++i) {
    //                     if (value.charCodeAt(i) > 255) {
    //                         return encodeURI(value);
    //                     }
    //                 }
    //             }
    //             return value;
    //         }
    //         return String(value);
    //     }
    //     return defaultValue;
    // };

    // start() {
    //     const resources = [
    //         cc.url.raw("resources/mecha_1002_101d_show/mecha_1002_101d_show_ske.json"),
    //         cc.url.raw("resources/mecha_1002_101d_show/mecha_1002_101d_show_tex.json"),
    //         cc.url.raw("resources/mecha_1002_101d_show/mecha_1002_101d_show_tex.png"),
    //     ];
    //     cc.loader.load(resources, (err, assets) => {
    //         const factory = dragonBones.CocosFactory.factory;
    //         factory.parseDragonBonesData(cc.loader.getRes(resources[0]));
    //         factory.parseTextureAtlasData(cc.loader.getRes(resources[1]), cc.loader.getRes(resources[2]));

    //         const armatureComponent = factory.buildArmatureComponent("mecha_1002_101d", "mecha_1002_101d_show");
    //         armatureComponent.animation.play("idle");

    //         armatureComponent.node.x = 0.0;
    //         armatureComponent.node.y = -200.0;
    //         this.node.addChild(armatureComponent.node);
    //     });
    // }
}
