// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const {ccclass,executeInEditMode, property} = cc._decorator;


@ccclass
@executeInEditMode
export class NewClass extends cc.Component {

    _prefabNode = null;

    @property(cc.Prefab)
    private _prefab: cc.Prefab = null

    @property({type: cc.Prefab, visible: true, displayName:"预制体"})
    set prefab(value: cc.Prefab) {
        this._prefab = value;
        // this._onPrefabChanged(this._prefab, value)
    }

    get prefab(): cc.Prefab {
        return this._prefab;  
    }
    //加载完成
    onLoad () {
        
        let scene = cc.director.getScene();
        cc.log("Link onLoad+++++++++++  : ",scene.name) 

        if (this._prefab) {
            cc.log("Link onLoad _prefab not null ",this.namelog()); 
            let prefabNode = cc.instantiate(this._prefab);  
            prefabNode["_objFlags"] |= (cc.Object["Flags"].DontSave | cc.Object["Flags"].LockedInEditor | cc.Object["Flags"].HideInHierarchy);
            this.node.addChild(prefabNode, -1) // 添加到最底层  

            this._prefabNode = prefabNode;
        }
        else{
            cc.log("Link onLoad _prefab is null ",this.namelog()); 
        }
  
    }
 
    onDestroy() {
        cc.log("Link onDestroy ",this.namelog());     
    }

    //每帧调用
    namelog () {
        let str = "["
        let p = this.node;
        while(p){
            str = str + " " + p.name;
            p = p.parent;
        }
        str = str + "]";

        if (this._prefabNode) {
            str = str + this._prefabNode.name;
        }
        else{
            str = str + "null";
        }
        return str;
    } 
}