// Learn TypeScript:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/typescript.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html

const { ccclass, property } = cc._decorator;

@ccclass
export default class A extends cc.Component {

    // 每次处理完碰撞体接触逻辑时被调用
    onPostSolve(contact, selfCollider, otherCollider) {
        if (otherCollider.node.group == "B" && selfCollider.node.group != "B") {
            this.changedGroup();
        }
    }

    async changedGroup() {
        await 0;
        if (this.node.isValid) {
            this.node.color = cc.Color.GREEN;
            this.node.active = false;
            this.node.group = "B";
            this.node.active = true;
            this.getComponentInChildren(cc.Label).string = "B";
        }
    }

}
