(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/scripts/PhysicsBounds.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, '2113cGer3BH07DvtApe78+9', 'PhysicsBounds', __filename);
// settings/PhysicsBounds.ts

Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property, disallowMultiple = _a.disallowMultiple;
var PhysicsBounds = /** @class */ (function (_super) {
    __extends(PhysicsBounds, _super);
    function PhysicsBounds() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.size = cc.size(0, 0);
        _this.mouseJoint = true;
        return _this;
    }
    PhysicsBounds.prototype.start = function () {
        this.node.children.forEach(function (child) {
            child.removeFromParent();
        });
        var width = this.size.width || this.node.width;
        var height = this.size.height || this.node.height;
        var node = new cc.Node();
        var body = node.addComponent(cc.RigidBody);
        body.type = cc.RigidBodyType.Static;
        if (this.mouseJoint) {
            // add mouse joint
            var joint = node.addComponent(cc.MouseJoint);
            joint.mouseRegion = this.node;
        }
        this._addBound(node, 0, height / 2, width, 20);
        this._addBound(node, 0, -height / 2, width, 20);
        this._addBound(node, -width / 2, 0, 20, height);
        this._addBound(node, width / 2, 0, 20, height);
        node.setParent(this.node);
    };
    PhysicsBounds.prototype._addBound = function (node, x, y, width, height) {
        var collider = node.addComponent(cc.PhysicsBoxCollider);
        collider.offset.x = x;
        collider.offset.y = y;
        collider.size.width = width;
        collider.size.height = height;
    };
    __decorate([
        property(cc.Size)
    ], PhysicsBounds.prototype, "size", void 0);
    __decorate([
        property(cc.Boolean)
    ], PhysicsBounds.prototype, "mouseJoint", void 0);
    PhysicsBounds = __decorate([
        ccclass,
        disallowMultiple
    ], PhysicsBounds);
    return PhysicsBounds;
}(cc.Component));
exports.default = PhysicsBounds;

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=PhysicsBounds.js.map
        