// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html
const { ccclass, property } = cc._decorator;

export enum GameStatus {
    Game_Ready = 0,
    Game_Playing = 1,
    Game_Over = 2

}
@ccclass
export default class NewClass extends cc.Component {

    @property(cc.Sprite)
    spBg: cc.Sprite[] = [null, null];

    @property(cc.Prefab)
    pipePrefab: cc.Prefab = null

    spGameOver: cc.Sprite = null

    btnStart: cc.Button = null

    score: cc.Label = null
    // LIFE-CYCLE CALLBACKS:
    gameStatus: GameStatus = GameStatus.Game_Ready
    onLoad() {
        cc.director.getCollisionManager().enabled = true
        cc.director.getCollisionManager().enabledDebugDraw = true

        this.spGameOver = this.node.getChildByName("GameOver").getComponent(cc.Sprite);
        this.spGameOver.node.active = false;

        this.btnStart = this.node.getChildByName('StartBtn').getComponent(cc.Button)
        this.btnStart.node.on(cc.Node.EventType.TOUCH_END, this.onStart, this)

    }

    onStart() {
        this.btnStart.node.active = false
        this.gameStatus = GameStatus.Game_Playing

    }



    gameOver() {
        this.spGameOver.node.active = true
    }
    pipe: cc.Node[] = [null, null, null]

    start() {
        for (let i = 0; i < this.pipe.length; i++) {
            this.pipe[i] = cc.instantiate(this.pipePrefab);
            // this.node.addChild(this.pipe[i]);
            this.node.getChildByName('pipe').addChild(this.pipe[i])


            this.pipe[i].x = 170 + 200 * i;
            var minY = -120;
            var maxY = 120;
            this.pipe[i].y = minY + Math.random() * (maxY - minY);

            console.log(this.pipe[i].getChildByName('pipe_down'))

        }
    }

    update(dt) {
        if (this.gameStatus !== GameStatus.Game_Playing) {
            return

        }
        // move the background node
        for (let i = 0; i < this.spBg.length; i++) {
            this.spBg[i].node.x -= 1.0;
            if (this.spBg[i].node.x <= -288) {
                this.spBg[i].node.x = 288;
            }
        }
        for (let i = 0; i < this.pipe.length; i++) {
            this.pipe[i].x -= 1.0;
            if (this.pipe[i].x <= -170) {
                this.pipe[i].x = 430;

                var minY = -120;
                var maxY = 120;
                this.pipe[i].y = minY + Math.random() * (maxY - minY);
                //score ++
                this.score = this.node.getChildByName('score').getComponent(cc.Label)
                this.score.string = this.score.string.
            }
        }

    }
}
