"use strict";
cc._RF.push(module, '859e9Fu1SFMMIf5GQL48ivB', 'main_control');
// scripts/main_control.ts

Object.defineProperty(exports, "__esModule", { value: true });
// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var GameStatus;
(function (GameStatus) {
    GameStatus[GameStatus["Game_Ready"] = 0] = "Game_Ready";
    GameStatus[GameStatus["Game_Playing"] = 1] = "Game_Playing";
    GameStatus[GameStatus["Game_Over"] = 2] = "Game_Over";
})(GameStatus = exports.GameStatus || (exports.GameStatus = {}));
var NewClass = /** @class */ (function (_super) {
    __extends(NewClass, _super);
    function NewClass() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.spBg = [null, null];
        _this.pipePrefab = null;
        _this.spGameOver = null;
        _this.btnStart = null;
        _this.score = null;
        // LIFE-CYCLE CALLBACKS:
        _this.gameStatus = GameStatus.Game_Ready;
        _this.pipe = [null, null, null];
        return _this;
    }
    NewClass.prototype.onLoad = function () {
        cc.director.getCollisionManager().enabled = true;
        cc.director.getCollisionManager().enabledDebugDraw = true;
        this.spGameOver = this.node.getChildByName("GameOver").getComponent(cc.Sprite);
        this.spGameOver.node.active = false;
        this.btnStart = this.node.getChildByName('StartBtn').getComponent(cc.Button);
        this.btnStart.node.on(cc.Node.EventType.TOUCH_END, this.onStart, this);
    };
    NewClass.prototype.onStart = function () {
        this.btnStart.node.active = false;
        this.gameStatus = GameStatus.Game_Playing;
    };
    NewClass.prototype.gameOver = function () {
        this.spGameOver.node.active = true;
    };
    NewClass.prototype.start = function () {
        for (var i = 0; i < this.pipe.length; i++) {
            this.pipe[i] = cc.instantiate(this.pipePrefab);
            // this.node.addChild(this.pipe[i]);
            this.node.getChildByName('pipe').addChild(this.pipe[i]);
            this.pipe[i].x = 170 + 200 * i;
            var minY = -120;
            var maxY = 120;
            this.pipe[i].y = minY + Math.random() * (maxY - minY);
            console.log(this.pipe[i].getChildByName('pipe_down'));
        }
    };
    NewClass.prototype.update = function (dt) {
        if (this.gameStatus !== GameStatus.Game_Playing) {
            return;
        }
        // move the background node
        for (var i = 0; i < this.spBg.length; i++) {
            this.spBg[i].node.x -= 1.0;
            if (this.spBg[i].node.x <= -288) {
                this.spBg[i].node.x = 288;
            }
        }
        for (var i = 0; i < this.pipe.length; i++) {
            this.pipe[i].x -= 1.0;
            if (this.pipe[i].x <= -170) {
                this.pipe[i].x = 430;
                var minY = -120;
                var maxY = 120;
                this.pipe[i].y = minY + Math.random() * (maxY - minY);
                //score ++
                this.score = this.node.getChildByName('score').getComponent(cc.Label);
                this.score.string = this.score.string.
                ;
            }
        }
    };
    __decorate([
        property(cc.Sprite)
    ], NewClass.prototype, "spBg", void 0);
    __decorate([
        property(cc.Prefab)
    ], NewClass.prototype, "pipePrefab", void 0);
    NewClass = __decorate([
        ccclass
    ], NewClass);
    return NewClass;
}(cc.Component));
exports.default = NewClass;

cc._RF.pop();