cc.Class({
    extends: cc.Component,

    properties: {
        // foo: {
        //    default: null,      // The default value will be used only when the component attaching
        //                           to a node for the first time
        //    url: cc.Texture2D,  // optional, default is typeof default
        //    serializable: true, // optional, default is true
        //    visible: true,      // optional, default is true
        //    displayName: 'Foo', // optional
        //    readonly: false,    // optional, default is false
        // },
        // ...
        aniType: 0, // 动作类型 0 - 从屏幕中央开始缩放 
    },

    // 调用此接口关闭，附有动画效果
    close: function(aniType) {
        if (aniType == undefined) {
            aniType = this.aniType;
        }
        switch(aniType) {
            case 0: 
                this.scaleHideAni();
                break;      
            default:
                this.node.removeFromParent();
        }
    },

    // use this for initialization
    onLoad: function () {
        switch(this.aniType) {
            case 0: 
               this.scaleShowAni();
               break;                
        }
    },

    onDestroy: function() {

    },

    // called every frame, uncomment this function to activate update callback
    // update: function (dt) {

    // },
    scaleShowAni: function() {
        this.node.setScale(0, 0);
        var scaleTo = cc.scaleTo(0.2, 1, 1);
        this.node.runAction(scaleTo);
    },
    scaleHideAni: function() {
        let self = this;
        self.node.setScale(1, 1);
        var scaleTo = cc.scaleTo(0.2, 0, 0);
        let seq = cc.sequence(scaleTo, cc.callFunc(function() {
            self.node.removeFromParent();
        }));

        self.node.runAction(seq);
    },
});
