const MaxTime = 0.2;

cc.Class({
    extends: cc.Component,

    properties: {
        coinPrefab: {
            default: null,
            type: cc.Prefab,
        },
    },

    onLoad () {
        this.coinArray = [];
        this.dtime = 0;
    },

    onDestroy () {
        this.coinArray = null;
    },

    start () {

    },

    update (dt) {
        this.dtime += dt;
        if (this.dtime >= MaxTime) {
            this.dtime = 0;
            let count = Math.floor(Math.random()*3) + 3;
            let x = Math.floor(Math.random()*300);
            let y =  Math.floor(Math.random()*200);
            this.createCoins(cc.v2(300 + x, 100+ y), cc.v2(-600, -300), count);
        }
    },

    createCoins: function (startPos, endPos, count) {
        for (let i = 0; i < count; i++) {
            let pos = cc.v2(startPos.x + (count / 2 - i - 1) * 30, startPos.y);
            this.createCoin(pos, endPos);
        }
    },

    createCoin: function (startPos, endPos) {
        let node = null;
        if (this.coinArray.length > 0) {
            node = this.coinArray[this.coinArray.length - 1];
            this.coinArray.pop();
            node.opacity = 255;
        } else {
            node = cc.instantiate(this.coinPrefab);
            this.node.addChild(node);
            // let animate = node.getComponent(cc.Animation);
            // animate.play();
            console.log(this.node.childrenCount);
        }
        node.position = startPos;
        let dtime = cc.pDistance(startPos, endPos) / 500;
        let action = cc.sequence(cc.moveTo(dtime,endPos), cc.fadeOut(0.1), cc.callFunc(this.recoverCoin, this));//, 
        node.runAction(action);
    },

    recoverCoin: function (target) {
        // let animate = target.getComponent(cc.Animation);
        // animate.stop();
        this.coinArray.push(target);
    },
});
