(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/Script/CoinManager.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, 'e635cTT+TdKTaZZjQ1F5zaD', 'CoinManager', __filename);
// Script/CoinManager.js

"use strict";

var MaxTime = 0.2;

cc.Class({
    extends: cc.Component,

    properties: {
        coinPrefab: {
            default: null,
            type: cc.Prefab
        }
    },

    onLoad: function onLoad() {
        this.coinArray = [];
        this.dtime = 0;
    },
    onDestroy: function onDestroy() {
        this.coinArray = null;
    },
    start: function start() {},
    update: function update(dt) {
        this.dtime += dt;
        if (this.dtime >= MaxTime) {
            this.dtime = 0;
            var count = Math.floor(Math.random() * 3) + 3;
            var x = Math.floor(Math.random() * 300);
            var y = Math.floor(Math.random() * 200);
            this.createCoins(cc.v2(300 + x, 100 + y), cc.v2(-600, -300), count);
        }
    },


    createCoins: function createCoins(startPos, endPos, count) {
        for (var i = 0; i < count; i++) {
            var pos = cc.v2(startPos.x + (count / 2 - i - 1) * 30, startPos.y);
            this.createCoin(pos, endPos);
        }
    },

    createCoin: function createCoin(startPos, endPos) {
        var node = null;
        if (this.coinArray.length > 0) {
            node = this.coinArray[this.coinArray.length - 1];
            this.coinArray.pop();
            node.opacity = 255;
        } else {
            node = cc.instantiate(this.coinPrefab);
            this.node.addChild(node);
            // let animate = node.getComponent(cc.Animation);
            // animate.play();
            console.log(this.node.childrenCount);
        }
        node.position = startPos;
        var dtime = cc.pDistance(startPos, endPos) / 500;
        var action = cc.sequence(cc.moveTo(dtime, endPos), cc.fadeOut(0.1), cc.callFunc(this.recoverCoin, this)); //, 
        node.runAction(action);
    },

    recoverCoin: function recoverCoin(target) {
        // let animate = target.getComponent(cc.Animation);
        // animate.stop();
        this.coinArray.push(target);
    }
});

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=CoinManager.js.map
        