const {ccclass, property} = cc._decorator;

@ccclass
export default class Game extends cc.Component {

    @property(cc.Camera)
    camera: cc.Camera = null;

    @property(cc.Node)
    handCardNode: cc.Node = null;

    @property(cc.Prefab)
    cardPre: cc.Prefab = null;
 
    onLoad() {
        const self = this;
        this.node.on(cc.Node.EventType.TOUCH_START, (e, c) => {
            const wp = e.getLocation();
            self.radiographicInspection(wp);
        }, this);
        this.handCardNode.removeAllChildren();
        let beginPosX = 0 - 13 * this.handCardNode.anchorX *1;
        for (let k = 0; k < 13; ++k) {
            let card = cc.instantiate(this.cardPre);
            let x = beginPosX + k * 1;
            card.setPosition(x, card.position.y, card.position.z);
            this.handCardNode.addChild(card);
        }
        // this.handCardNode.children.forEach((child, _ind) => {
        //     let x = beginPosX + _ind * 0.75;
        //     child.setPosition(x, child.position.y, child.position.z);
        // })
        
    }

    
    /** 射线检测 */
    radiographicInspection(wP) {
        const ray = this.camera.getRay(wP);
        const r = cc.director.getPhysics3DManager().raycast(ray,'HandCard', 1000, false);
        cc.log(r);
        if (r) {
            for (let k in r) {
                let checkNode = r[k].collider.node;
                if (checkNode.z < 0) {
                    checkNode.setPosition(checkNode.x, checkNode.y, 0);
                } else {
                    checkNode.setPosition(checkNode.x, checkNode.y, -0.4);
                }
                // checkNode.getComponent(cc.BoxCollider3D).
                break;
            }
        }
    }
}
