// Learn cc.Class:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/class.html
//  - [English] http://docs.cocos2d-x.org/creator/manual/en/scripting/class.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://docs.cocos2d-x.org/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] https://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html

cc.Class({
    extends: cc.Component,

    properties: {
        video: cc.VideoPlayer,
        _isTouchVideo: 0,
        _touchVideoTimes: 0,

        bgMusic: {
            type: cc.AudioClip,
            default: null,
        }
    },

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {},

    start () {

        this.addEvent();
    },

    onBtn(){
        cc.audioEngine.playMusic(this.bgMusic, true);
        console.log("播放背景音乐");
    },

    onBtn2(){
        let path = cc.url.raw("resources/v001.mp4");
        this.video.resourceType = cc.VideoPlayer.ResourceType.REMOTE;
        this.video.remoteURL = path;
        this.video.node.active = true;
        this.video.play();
        console.log("开始播放视频");
    },

    update: function () {
        this._touchVideoTimes++;
        if (this._touchVideoTimes > 60) {
            this._touchVideoTimes = 0;
            this._isTouchVideo = 0;
        }
    },

    addEvent(){
        this.video.node.on("clicked", function () {
            this._isTouchVideo++;
            if (this._isTouchVideo % 2 == 0 && this._touchVideoTimes < 60) {
                this._touchVideoTimes = 0;
                this.video.stop();

                this.video.node.active = false;

                console.log("双击跳过");
            }
        }.bind(this));

        this.video.node.on("completed", function () {
            //--播放完成
            this.vedio.stop();
            this.vedioNode.active = false;
            console.log("视频播放完成");
        }.bind(this));
    }

    // update (dt) {},
});
