import MovableItem from "./MovableItem";

const {ccclass, property} = cc._decorator;

@ccclass
export default class MovableCollider extends cc.Component {
    onLoad () {
        cc.director.getCollisionManager().enabled = true;
    }
     onCollisionStay(other:cc.Collider, self:cc.Collider) {
         if(this.node.getComponent(MovableItem).getOtherPos()){
            return
         }  
         let pos = other.node.getPosition()
         console.log(pos)
         this.node.getComponent(MovableItem).setOtherPos(pos)
     }; 
     onCollisionExit(other:cc.Collider, self:cc.Collider){
        this.node.getComponent(MovableItem).setOtherPos(null)
     };
   
}
