
const {ccclass, property} = cc._decorator;

@ccclass
export default class MovableItem extends cc.Component {

    Xp:number
    Yp:number
    pos:cc.Vec2 = null
    otherPos:cc.Vec2 = null
    // LIFE-CYCLE CALLBACKS:
    onLoad () {
        this.node.on(cc.Node.EventType.TOUCH_START, this.TOUCH_START, this);
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this.TOUCH_MOVE, this);
        this.node.on(cc.Node.EventType.TOUCH_END, this.TOUCH_END, this);
        this.node.on(cc.Node.EventType.TOUCH_CANCEL, this.TOUCH_CANCEL, this);
        this.pos = this.node.getPosition()
    }

    setOtherPos(oPos){
        this.otherPos = oPos
    }
    getOtherPos(){
        return this.otherPos
    }
    TOUCH_START(event){
        this.node.stopAllActions()       
        this.Xp = event.touch.getLocationX()
        this.Yp = event.touch.getLocationY()
    }

    TOUCH_MOVE(event){
        let Nx = event.touch.getLocationX()
        let Ny = event.touch.getLocationY()
        let Dx =Nx-this.Xp
        let Dy =Ny-this.Yp
        this.node.x = this.node.x+Dx
        this.node.y = this.node.y+Dy
        this.Xp = Nx
        this.Yp = Ny
       
    }
    TOUCH_END(){
        if(this.otherPos){
            this.itemSetPos()
        }else{
            this.itemBackPos()
        }    
    }
    TOUCH_CANCEL(){    
        if(this.otherPos){
            this.itemSetPos()
        }else{
            this.itemBackPos()
        }              
    }
    itemSetPos(){
        this.node.setPosition(this.otherPos)
        this.pos = this.otherPos
    }
    itemBackPos(){
        let move = cc.moveTo(1,this.pos)
        this.node.runAction(move)
    }
}
